//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armstorsimple8000series.ClientFactory type.
type ServerFactory struct {
	AccessControlRecordsServer      AccessControlRecordsServer
	AlertsServer                    AlertsServer
	BackupPoliciesServer            BackupPoliciesServer
	BackupSchedulesServer           BackupSchedulesServer
	BackupsServer                   BackupsServer
	BandwidthSettingsServer         BandwidthSettingsServer
	CloudAppliancesServer           CloudAppliancesServer
	DeviceSettingsServer            DeviceSettingsServer
	DevicesServer                   DevicesServer
	HardwareComponentGroupsServer   HardwareComponentGroupsServer
	JobsServer                      JobsServer
	ManagersServer                  ManagersServer
	OperationsServer                OperationsServer
	StorageAccountCredentialsServer StorageAccountCredentialsServer
	VolumeContainersServer          VolumeContainersServer
	VolumesServer                   VolumesServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armstorsimple8000series.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armstorsimple8000series.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                               *ServerFactory
	trMu                              sync.Mutex
	trAccessControlRecordsServer      *AccessControlRecordsServerTransport
	trAlertsServer                    *AlertsServerTransport
	trBackupPoliciesServer            *BackupPoliciesServerTransport
	trBackupSchedulesServer           *BackupSchedulesServerTransport
	trBackupsServer                   *BackupsServerTransport
	trBandwidthSettingsServer         *BandwidthSettingsServerTransport
	trCloudAppliancesServer           *CloudAppliancesServerTransport
	trDeviceSettingsServer            *DeviceSettingsServerTransport
	trDevicesServer                   *DevicesServerTransport
	trHardwareComponentGroupsServer   *HardwareComponentGroupsServerTransport
	trJobsServer                      *JobsServerTransport
	trManagersServer                  *ManagersServerTransport
	trOperationsServer                *OperationsServerTransport
	trStorageAccountCredentialsServer *StorageAccountCredentialsServerTransport
	trVolumeContainersServer          *VolumeContainersServerTransport
	trVolumesServer                   *VolumesServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AccessControlRecordsClient":
		initServer(s, &s.trAccessControlRecordsServer, func() *AccessControlRecordsServerTransport {
			return NewAccessControlRecordsServerTransport(&s.srv.AccessControlRecordsServer)
		})
		resp, err = s.trAccessControlRecordsServer.Do(req)
	case "AlertsClient":
		initServer(s, &s.trAlertsServer, func() *AlertsServerTransport { return NewAlertsServerTransport(&s.srv.AlertsServer) })
		resp, err = s.trAlertsServer.Do(req)
	case "BackupPoliciesClient":
		initServer(s, &s.trBackupPoliciesServer, func() *BackupPoliciesServerTransport {
			return NewBackupPoliciesServerTransport(&s.srv.BackupPoliciesServer)
		})
		resp, err = s.trBackupPoliciesServer.Do(req)
	case "BackupSchedulesClient":
		initServer(s, &s.trBackupSchedulesServer, func() *BackupSchedulesServerTransport {
			return NewBackupSchedulesServerTransport(&s.srv.BackupSchedulesServer)
		})
		resp, err = s.trBackupSchedulesServer.Do(req)
	case "BackupsClient":
		initServer(s, &s.trBackupsServer, func() *BackupsServerTransport { return NewBackupsServerTransport(&s.srv.BackupsServer) })
		resp, err = s.trBackupsServer.Do(req)
	case "BandwidthSettingsClient":
		initServer(s, &s.trBandwidthSettingsServer, func() *BandwidthSettingsServerTransport {
			return NewBandwidthSettingsServerTransport(&s.srv.BandwidthSettingsServer)
		})
		resp, err = s.trBandwidthSettingsServer.Do(req)
	case "CloudAppliancesClient":
		initServer(s, &s.trCloudAppliancesServer, func() *CloudAppliancesServerTransport {
			return NewCloudAppliancesServerTransport(&s.srv.CloudAppliancesServer)
		})
		resp, err = s.trCloudAppliancesServer.Do(req)
	case "DeviceSettingsClient":
		initServer(s, &s.trDeviceSettingsServer, func() *DeviceSettingsServerTransport {
			return NewDeviceSettingsServerTransport(&s.srv.DeviceSettingsServer)
		})
		resp, err = s.trDeviceSettingsServer.Do(req)
	case "DevicesClient":
		initServer(s, &s.trDevicesServer, func() *DevicesServerTransport { return NewDevicesServerTransport(&s.srv.DevicesServer) })
		resp, err = s.trDevicesServer.Do(req)
	case "HardwareComponentGroupsClient":
		initServer(s, &s.trHardwareComponentGroupsServer, func() *HardwareComponentGroupsServerTransport {
			return NewHardwareComponentGroupsServerTransport(&s.srv.HardwareComponentGroupsServer)
		})
		resp, err = s.trHardwareComponentGroupsServer.Do(req)
	case "JobsClient":
		initServer(s, &s.trJobsServer, func() *JobsServerTransport { return NewJobsServerTransport(&s.srv.JobsServer) })
		resp, err = s.trJobsServer.Do(req)
	case "ManagersClient":
		initServer(s, &s.trManagersServer, func() *ManagersServerTransport { return NewManagersServerTransport(&s.srv.ManagersServer) })
		resp, err = s.trManagersServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "StorageAccountCredentialsClient":
		initServer(s, &s.trStorageAccountCredentialsServer, func() *StorageAccountCredentialsServerTransport {
			return NewStorageAccountCredentialsServerTransport(&s.srv.StorageAccountCredentialsServer)
		})
		resp, err = s.trStorageAccountCredentialsServer.Do(req)
	case "VolumeContainersClient":
		initServer(s, &s.trVolumeContainersServer, func() *VolumeContainersServerTransport {
			return NewVolumeContainersServerTransport(&s.srv.VolumeContainersServer)
		})
		resp, err = s.trVolumeContainersServer.Do(req)
	case "VolumesClient":
		initServer(s, &s.trVolumesServer, func() *VolumesServerTransport { return NewVolumesServerTransport(&s.srv.VolumesServer) })
		resp, err = s.trVolumesServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
