//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armstorsimple1200series.ClientFactory type.
type ServerFactory struct {
	AccessControlRecordsServer        AccessControlRecordsServer
	AlertsServer                      AlertsServer
	AvailableProviderOperationsServer AvailableProviderOperationsServer
	BackupScheduleGroupsServer        BackupScheduleGroupsServer
	BackupsServer                     BackupsServer
	ChapSettingsServer                ChapSettingsServer
	DevicesServer                     DevicesServer
	FileServersServer                 FileServersServer
	FileSharesServer                  FileSharesServer
	IscsiDisksServer                  IscsiDisksServer
	IscsiServersServer                IscsiServersServer
	JobsServer                        JobsServer
	ManagersServer                    ManagersServer
	StorageAccountCredentialsServer   StorageAccountCredentialsServer
	StorageDomainsServer              StorageDomainsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armstorsimple1200series.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armstorsimple1200series.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                 *ServerFactory
	trMu                                sync.Mutex
	trAccessControlRecordsServer        *AccessControlRecordsServerTransport
	trAlertsServer                      *AlertsServerTransport
	trAvailableProviderOperationsServer *AvailableProviderOperationsServerTransport
	trBackupScheduleGroupsServer        *BackupScheduleGroupsServerTransport
	trBackupsServer                     *BackupsServerTransport
	trChapSettingsServer                *ChapSettingsServerTransport
	trDevicesServer                     *DevicesServerTransport
	trFileServersServer                 *FileServersServerTransport
	trFileSharesServer                  *FileSharesServerTransport
	trIscsiDisksServer                  *IscsiDisksServerTransport
	trIscsiServersServer                *IscsiServersServerTransport
	trJobsServer                        *JobsServerTransport
	trManagersServer                    *ManagersServerTransport
	trStorageAccountCredentialsServer   *StorageAccountCredentialsServerTransport
	trStorageDomainsServer              *StorageDomainsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AccessControlRecordsClient":
		initServer(s, &s.trAccessControlRecordsServer, func() *AccessControlRecordsServerTransport {
			return NewAccessControlRecordsServerTransport(&s.srv.AccessControlRecordsServer)
		})
		resp, err = s.trAccessControlRecordsServer.Do(req)
	case "AlertsClient":
		initServer(s, &s.trAlertsServer, func() *AlertsServerTransport { return NewAlertsServerTransport(&s.srv.AlertsServer) })
		resp, err = s.trAlertsServer.Do(req)
	case "AvailableProviderOperationsClient":
		initServer(s, &s.trAvailableProviderOperationsServer, func() *AvailableProviderOperationsServerTransport {
			return NewAvailableProviderOperationsServerTransport(&s.srv.AvailableProviderOperationsServer)
		})
		resp, err = s.trAvailableProviderOperationsServer.Do(req)
	case "BackupScheduleGroupsClient":
		initServer(s, &s.trBackupScheduleGroupsServer, func() *BackupScheduleGroupsServerTransport {
			return NewBackupScheduleGroupsServerTransport(&s.srv.BackupScheduleGroupsServer)
		})
		resp, err = s.trBackupScheduleGroupsServer.Do(req)
	case "BackupsClient":
		initServer(s, &s.trBackupsServer, func() *BackupsServerTransport { return NewBackupsServerTransport(&s.srv.BackupsServer) })
		resp, err = s.trBackupsServer.Do(req)
	case "ChapSettingsClient":
		initServer(s, &s.trChapSettingsServer, func() *ChapSettingsServerTransport { return NewChapSettingsServerTransport(&s.srv.ChapSettingsServer) })
		resp, err = s.trChapSettingsServer.Do(req)
	case "DevicesClient":
		initServer(s, &s.trDevicesServer, func() *DevicesServerTransport { return NewDevicesServerTransport(&s.srv.DevicesServer) })
		resp, err = s.trDevicesServer.Do(req)
	case "FileServersClient":
		initServer(s, &s.trFileServersServer, func() *FileServersServerTransport { return NewFileServersServerTransport(&s.srv.FileServersServer) })
		resp, err = s.trFileServersServer.Do(req)
	case "FileSharesClient":
		initServer(s, &s.trFileSharesServer, func() *FileSharesServerTransport { return NewFileSharesServerTransport(&s.srv.FileSharesServer) })
		resp, err = s.trFileSharesServer.Do(req)
	case "IscsiDisksClient":
		initServer(s, &s.trIscsiDisksServer, func() *IscsiDisksServerTransport { return NewIscsiDisksServerTransport(&s.srv.IscsiDisksServer) })
		resp, err = s.trIscsiDisksServer.Do(req)
	case "IscsiServersClient":
		initServer(s, &s.trIscsiServersServer, func() *IscsiServersServerTransport { return NewIscsiServersServerTransport(&s.srv.IscsiServersServer) })
		resp, err = s.trIscsiServersServer.Do(req)
	case "JobsClient":
		initServer(s, &s.trJobsServer, func() *JobsServerTransport { return NewJobsServerTransport(&s.srv.JobsServer) })
		resp, err = s.trJobsServer.Do(req)
	case "ManagersClient":
		initServer(s, &s.trManagersServer, func() *ManagersServerTransport { return NewManagersServerTransport(&s.srv.ManagersServer) })
		resp, err = s.trManagersServer.Do(req)
	case "StorageAccountCredentialsClient":
		initServer(s, &s.trStorageAccountCredentialsServer, func() *StorageAccountCredentialsServerTransport {
			return NewStorageAccountCredentialsServerTransport(&s.srv.StorageAccountCredentialsServer)
		})
		resp, err = s.trStorageAccountCredentialsServer.Do(req)
	case "StorageDomainsClient":
		initServer(s, &s.trStorageDomainsServer, func() *StorageDomainsServerTransport {
			return NewStorageDomainsServerTransport(&s.srv.StorageDomainsServer)
		})
		resp, err = s.trStorageDomainsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
