//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstoragesync

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storagesync/armstoragesync"
	moduleVersion = "v1.2.0"
)

// ChangeDetectionMode - Change Detection Mode. Applies to a directory specified in directoryPath parameter.
type ChangeDetectionMode string

const (
	ChangeDetectionModeDefault   ChangeDetectionMode = "Default"
	ChangeDetectionModeRecursive ChangeDetectionMode = "Recursive"
)

// PossibleChangeDetectionModeValues returns the possible values for the ChangeDetectionMode const type.
func PossibleChangeDetectionModeValues() []ChangeDetectionMode {
	return []ChangeDetectionMode{
		ChangeDetectionModeDefault,
		ChangeDetectionModeRecursive,
	}
}

// CloudEndpointChangeEnumerationActivityState - State of change enumeration activity
type CloudEndpointChangeEnumerationActivityState string

const (
	CloudEndpointChangeEnumerationActivityStateEnumerationInProgress        CloudEndpointChangeEnumerationActivityState = "EnumerationInProgress"
	CloudEndpointChangeEnumerationActivityStateInitialEnumerationInProgress CloudEndpointChangeEnumerationActivityState = "InitialEnumerationInProgress"
)

// PossibleCloudEndpointChangeEnumerationActivityStateValues returns the possible values for the CloudEndpointChangeEnumerationActivityState const type.
func PossibleCloudEndpointChangeEnumerationActivityStateValues() []CloudEndpointChangeEnumerationActivityState {
	return []CloudEndpointChangeEnumerationActivityState{
		CloudEndpointChangeEnumerationActivityStateEnumerationInProgress,
		CloudEndpointChangeEnumerationActivityStateInitialEnumerationInProgress,
	}
}

// CloudEndpointChangeEnumerationTotalCountsState - State of the total counts of change enumeration activity
type CloudEndpointChangeEnumerationTotalCountsState string

const (
	CloudEndpointChangeEnumerationTotalCountsStateCalculating CloudEndpointChangeEnumerationTotalCountsState = "Calculating"
	CloudEndpointChangeEnumerationTotalCountsStateFinal       CloudEndpointChangeEnumerationTotalCountsState = "Final"
)

// PossibleCloudEndpointChangeEnumerationTotalCountsStateValues returns the possible values for the CloudEndpointChangeEnumerationTotalCountsState const type.
func PossibleCloudEndpointChangeEnumerationTotalCountsStateValues() []CloudEndpointChangeEnumerationTotalCountsState {
	return []CloudEndpointChangeEnumerationTotalCountsState{
		CloudEndpointChangeEnumerationTotalCountsStateCalculating,
		CloudEndpointChangeEnumerationTotalCountsStateFinal,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// FeatureStatus - Type of the Feature Status
type FeatureStatus string

const (
	FeatureStatusOff FeatureStatus = "off"
	FeatureStatusOn  FeatureStatus = "on"
)

// PossibleFeatureStatusValues returns the possible values for the FeatureStatus const type.
func PossibleFeatureStatusValues() []FeatureStatus {
	return []FeatureStatus{
		FeatureStatusOff,
		FeatureStatusOn,
	}
}

// IncomingTrafficPolicy - Type of the Incoming Traffic Policy
type IncomingTrafficPolicy string

const (
	IncomingTrafficPolicyAllowAllTraffic          IncomingTrafficPolicy = "AllowAllTraffic"
	IncomingTrafficPolicyAllowVirtualNetworksOnly IncomingTrafficPolicy = "AllowVirtualNetworksOnly"
)

// PossibleIncomingTrafficPolicyValues returns the possible values for the IncomingTrafficPolicy const type.
func PossibleIncomingTrafficPolicyValues() []IncomingTrafficPolicy {
	return []IncomingTrafficPolicy{
		IncomingTrafficPolicyAllowAllTraffic,
		IncomingTrafficPolicyAllowVirtualNetworksOnly,
	}
}

// InitialDownloadPolicy - Policy for how namespace and files are recalled during FastDr
type InitialDownloadPolicy string

const (
	InitialDownloadPolicyAvoidTieredFiles           InitialDownloadPolicy = "AvoidTieredFiles"
	InitialDownloadPolicyNamespaceOnly              InitialDownloadPolicy = "NamespaceOnly"
	InitialDownloadPolicyNamespaceThenModifiedFiles InitialDownloadPolicy = "NamespaceThenModifiedFiles"
)

// PossibleInitialDownloadPolicyValues returns the possible values for the InitialDownloadPolicy const type.
func PossibleInitialDownloadPolicyValues() []InitialDownloadPolicy {
	return []InitialDownloadPolicy{
		InitialDownloadPolicyAvoidTieredFiles,
		InitialDownloadPolicyNamespaceOnly,
		InitialDownloadPolicyNamespaceThenModifiedFiles,
	}
}

// InitialUploadPolicy - Policy for how the initial upload sync session is performed.
type InitialUploadPolicy string

const (
	InitialUploadPolicyMerge               InitialUploadPolicy = "Merge"
	InitialUploadPolicyServerAuthoritative InitialUploadPolicy = "ServerAuthoritative"
)

// PossibleInitialUploadPolicyValues returns the possible values for the InitialUploadPolicy const type.
func PossibleInitialUploadPolicyValues() []InitialUploadPolicy {
	return []InitialUploadPolicy{
		InitialUploadPolicyMerge,
		InitialUploadPolicyServerAuthoritative,
	}
}

// LocalCacheMode - Policy for enabling follow-the-sun business models: link local cache to cloud behavior to pre-populate
// before local access.
type LocalCacheMode string

const (
	LocalCacheModeDownloadNewAndModifiedFiles LocalCacheMode = "DownloadNewAndModifiedFiles"
	LocalCacheModeUpdateLocallyCachedFiles    LocalCacheMode = "UpdateLocallyCachedFiles"
)

// PossibleLocalCacheModeValues returns the possible values for the LocalCacheMode const type.
func PossibleLocalCacheModeValues() []LocalCacheMode {
	return []LocalCacheMode{
		LocalCacheModeDownloadNewAndModifiedFiles,
		LocalCacheModeUpdateLocallyCachedFiles,
	}
}

// NameAvailabilityReason - Gets the reason that a Storage Sync Service name could not be used. The Reason element is only
// returned if NameAvailable is false.
type NameAvailabilityReason string

const (
	NameAvailabilityReasonAlreadyExists NameAvailabilityReason = "AlreadyExists"
	NameAvailabilityReasonInvalid       NameAvailabilityReason = "Invalid"
)

// PossibleNameAvailabilityReasonValues returns the possible values for the NameAvailabilityReason const type.
func PossibleNameAvailabilityReasonValues() []NameAvailabilityReason {
	return []NameAvailabilityReason{
		NameAvailabilityReasonAlreadyExists,
		NameAvailabilityReasonInvalid,
	}
}

// OperationDirection - Type of the Operation Direction
type OperationDirection string

const (
	OperationDirectionCancel OperationDirection = "cancel"
	OperationDirectionDo     OperationDirection = "do"
	OperationDirectionUndo   OperationDirection = "undo"
)

// PossibleOperationDirectionValues returns the possible values for the OperationDirection const type.
func PossibleOperationDirectionValues() []OperationDirection {
	return []OperationDirection{
		OperationDirectionCancel,
		OperationDirectionDo,
		OperationDirectionUndo,
	}
}

// PrivateEndpointConnectionProvisioningState - The current provisioning state.
type PrivateEndpointConnectionProvisioningState string

const (
	PrivateEndpointConnectionProvisioningStateCreating  PrivateEndpointConnectionProvisioningState = "Creating"
	PrivateEndpointConnectionProvisioningStateDeleting  PrivateEndpointConnectionProvisioningState = "Deleting"
	PrivateEndpointConnectionProvisioningStateFailed    PrivateEndpointConnectionProvisioningState = "Failed"
	PrivateEndpointConnectionProvisioningStateSucceeded PrivateEndpointConnectionProvisioningState = "Succeeded"
)

// PossiblePrivateEndpointConnectionProvisioningStateValues returns the possible values for the PrivateEndpointConnectionProvisioningState const type.
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return []PrivateEndpointConnectionProvisioningState{
		PrivateEndpointConnectionProvisioningStateCreating,
		PrivateEndpointConnectionProvisioningStateDeleting,
		PrivateEndpointConnectionProvisioningStateFailed,
		PrivateEndpointConnectionProvisioningStateSucceeded,
	}
}

// PrivateEndpointServiceConnectionStatus - The private endpoint connection status.
type PrivateEndpointServiceConnectionStatus string

const (
	PrivateEndpointServiceConnectionStatusApproved PrivateEndpointServiceConnectionStatus = "Approved"
	PrivateEndpointServiceConnectionStatusPending  PrivateEndpointServiceConnectionStatus = "Pending"
	PrivateEndpointServiceConnectionStatusRejected PrivateEndpointServiceConnectionStatus = "Rejected"
)

// PossiblePrivateEndpointServiceConnectionStatusValues returns the possible values for the PrivateEndpointServiceConnectionStatus const type.
func PossiblePrivateEndpointServiceConnectionStatusValues() []PrivateEndpointServiceConnectionStatus {
	return []PrivateEndpointServiceConnectionStatus{
		PrivateEndpointServiceConnectionStatusApproved,
		PrivateEndpointServiceConnectionStatusPending,
		PrivateEndpointServiceConnectionStatusRejected,
	}
}

// ProgressType - Type of the ProgressType
type ProgressType string

const (
	ProgressTypeDownload   ProgressType = "download"
	ProgressTypeInitialize ProgressType = "initialize"
	ProgressTypeNone       ProgressType = "none"
	ProgressTypeRecall     ProgressType = "recall"
	ProgressTypeUpload     ProgressType = "upload"
)

// PossibleProgressTypeValues returns the possible values for the ProgressType const type.
func PossibleProgressTypeValues() []ProgressType {
	return []ProgressType{
		ProgressTypeDownload,
		ProgressTypeInitialize,
		ProgressTypeNone,
		ProgressTypeRecall,
		ProgressTypeUpload,
	}
}

// Reason - State of Azure Subscription
type Reason string

const (
	ReasonDeleted      Reason = "Deleted"
	ReasonRegistered   Reason = "Registered"
	ReasonSuspended    Reason = "Suspended"
	ReasonUnregistered Reason = "Unregistered"
	ReasonWarned       Reason = "Warned"
)

// PossibleReasonValues returns the possible values for the Reason const type.
func PossibleReasonValues() []Reason {
	return []Reason{
		ReasonDeleted,
		ReasonRegistered,
		ReasonSuspended,
		ReasonUnregistered,
		ReasonWarned,
	}
}

// RegisteredServerAgentVersionStatus - Type of the registered server agent version status
type RegisteredServerAgentVersionStatus string

const (
	RegisteredServerAgentVersionStatusBlocked    RegisteredServerAgentVersionStatus = "Blocked"
	RegisteredServerAgentVersionStatusExpired    RegisteredServerAgentVersionStatus = "Expired"
	RegisteredServerAgentVersionStatusNearExpiry RegisteredServerAgentVersionStatus = "NearExpiry"
	RegisteredServerAgentVersionStatusOk         RegisteredServerAgentVersionStatus = "Ok"
)

// PossibleRegisteredServerAgentVersionStatusValues returns the possible values for the RegisteredServerAgentVersionStatus const type.
func PossibleRegisteredServerAgentVersionStatusValues() []RegisteredServerAgentVersionStatus {
	return []RegisteredServerAgentVersionStatus{
		RegisteredServerAgentVersionStatusBlocked,
		RegisteredServerAgentVersionStatusExpired,
		RegisteredServerAgentVersionStatusNearExpiry,
		RegisteredServerAgentVersionStatusOk,
	}
}

// ServerEndpointHealthState - Type of the server endpoint health state
type ServerEndpointHealthState string

const (
	ServerEndpointHealthStateError       ServerEndpointHealthState = "Error"
	ServerEndpointHealthStateHealthy     ServerEndpointHealthState = "Healthy"
	ServerEndpointHealthStateUnavailable ServerEndpointHealthState = "Unavailable"
)

// PossibleServerEndpointHealthStateValues returns the possible values for the ServerEndpointHealthState const type.
func PossibleServerEndpointHealthStateValues() []ServerEndpointHealthState {
	return []ServerEndpointHealthState{
		ServerEndpointHealthStateError,
		ServerEndpointHealthStateHealthy,
		ServerEndpointHealthStateUnavailable,
	}
}

// ServerEndpointOfflineDataTransferState - Type of the Health state
type ServerEndpointOfflineDataTransferState string

const (
	ServerEndpointOfflineDataTransferStateComplete   ServerEndpointOfflineDataTransferState = "Complete"
	ServerEndpointOfflineDataTransferStateInProgress ServerEndpointOfflineDataTransferState = "InProgress"
	ServerEndpointOfflineDataTransferStateNotRunning ServerEndpointOfflineDataTransferState = "NotRunning"
	ServerEndpointOfflineDataTransferStateStopping   ServerEndpointOfflineDataTransferState = "Stopping"
)

// PossibleServerEndpointOfflineDataTransferStateValues returns the possible values for the ServerEndpointOfflineDataTransferState const type.
func PossibleServerEndpointOfflineDataTransferStateValues() []ServerEndpointOfflineDataTransferState {
	return []ServerEndpointOfflineDataTransferState{
		ServerEndpointOfflineDataTransferStateComplete,
		ServerEndpointOfflineDataTransferStateInProgress,
		ServerEndpointOfflineDataTransferStateNotRunning,
		ServerEndpointOfflineDataTransferStateStopping,
	}
}

// ServerEndpointSyncActivityState - Type of the sync activity state
type ServerEndpointSyncActivityState string

const (
	ServerEndpointSyncActivityStateDownload          ServerEndpointSyncActivityState = "Download"
	ServerEndpointSyncActivityStateUpload            ServerEndpointSyncActivityState = "Upload"
	ServerEndpointSyncActivityStateUploadAndDownload ServerEndpointSyncActivityState = "UploadAndDownload"
)

// PossibleServerEndpointSyncActivityStateValues returns the possible values for the ServerEndpointSyncActivityState const type.
func PossibleServerEndpointSyncActivityStateValues() []ServerEndpointSyncActivityState {
	return []ServerEndpointSyncActivityState{
		ServerEndpointSyncActivityStateDownload,
		ServerEndpointSyncActivityStateUpload,
		ServerEndpointSyncActivityStateUploadAndDownload,
	}
}

// ServerEndpointSyncMode - Sync mode for the server endpoint.
type ServerEndpointSyncMode string

const (
	ServerEndpointSyncModeInitialFullDownload ServerEndpointSyncMode = "InitialFullDownload"
	ServerEndpointSyncModeInitialUpload       ServerEndpointSyncMode = "InitialUpload"
	ServerEndpointSyncModeNamespaceDownload   ServerEndpointSyncMode = "NamespaceDownload"
	ServerEndpointSyncModeRegular             ServerEndpointSyncMode = "Regular"
	ServerEndpointSyncModeSnapshotUpload      ServerEndpointSyncMode = "SnapshotUpload"
)

// PossibleServerEndpointSyncModeValues returns the possible values for the ServerEndpointSyncMode const type.
func PossibleServerEndpointSyncModeValues() []ServerEndpointSyncMode {
	return []ServerEndpointSyncMode{
		ServerEndpointSyncModeInitialFullDownload,
		ServerEndpointSyncModeInitialUpload,
		ServerEndpointSyncModeNamespaceDownload,
		ServerEndpointSyncModeRegular,
		ServerEndpointSyncModeSnapshotUpload,
	}
}

// WorkflowStatus - Type of the Workflow Status
type WorkflowStatus string

const (
	WorkflowStatusAborted   WorkflowStatus = "aborted"
	WorkflowStatusActive    WorkflowStatus = "active"
	WorkflowStatusExpired   WorkflowStatus = "expired"
	WorkflowStatusFailed    WorkflowStatus = "failed"
	WorkflowStatusSucceeded WorkflowStatus = "succeeded"
)

// PossibleWorkflowStatusValues returns the possible values for the WorkflowStatus const type.
func PossibleWorkflowStatusValues() []WorkflowStatus {
	return []WorkflowStatus{
		WorkflowStatusAborted,
		WorkflowStatusActive,
		WorkflowStatusExpired,
		WorkflowStatusFailed,
		WorkflowStatusSucceeded,
	}
}
