//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// VulnerabilityAssessmentRuleBaselineServer is a fake server for instances of the armsql.VulnerabilityAssessmentRuleBaselineClient type.
type VulnerabilityAssessmentRuleBaselineServer struct {
	// CreateOrUpdate is the fake for method VulnerabilityAssessmentRuleBaselineClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, baselineName armsql.BaselineName, ruleID string, parameters armsql.DatabaseSQLVulnerabilityAssessmentRuleBaselineInput, options *armsql.VulnerabilityAssessmentRuleBaselineClientCreateOrUpdateOptions) (resp azfake.Responder[armsql.VulnerabilityAssessmentRuleBaselineClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method VulnerabilityAssessmentRuleBaselineClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, baselineName armsql.BaselineName, ruleID string, options *armsql.VulnerabilityAssessmentRuleBaselineClientGetOptions) (resp azfake.Responder[armsql.VulnerabilityAssessmentRuleBaselineClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByBaselinePager is the fake for method VulnerabilityAssessmentRuleBaselineClient.NewListByBaselinePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByBaselinePager func(resourceGroupName string, serverName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, baselineName armsql.BaselineName, options *armsql.VulnerabilityAssessmentRuleBaselineClientListByBaselineOptions) (resp azfake.PagerResponder[armsql.VulnerabilityAssessmentRuleBaselineClientListByBaselineResponse])
}

// NewVulnerabilityAssessmentRuleBaselineServerTransport creates a new instance of VulnerabilityAssessmentRuleBaselineServerTransport with the provided implementation.
// The returned VulnerabilityAssessmentRuleBaselineServerTransport instance is connected to an instance of armsql.VulnerabilityAssessmentRuleBaselineClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewVulnerabilityAssessmentRuleBaselineServerTransport(srv *VulnerabilityAssessmentRuleBaselineServer) *VulnerabilityAssessmentRuleBaselineServerTransport {
	return &VulnerabilityAssessmentRuleBaselineServerTransport{
		srv:                    srv,
		newListByBaselinePager: newTracker[azfake.PagerResponder[armsql.VulnerabilityAssessmentRuleBaselineClientListByBaselineResponse]](),
	}
}

// VulnerabilityAssessmentRuleBaselineServerTransport connects instances of armsql.VulnerabilityAssessmentRuleBaselineClient to instances of VulnerabilityAssessmentRuleBaselineServer.
// Don't use this type directly, use NewVulnerabilityAssessmentRuleBaselineServerTransport instead.
type VulnerabilityAssessmentRuleBaselineServerTransport struct {
	srv                    *VulnerabilityAssessmentRuleBaselineServer
	newListByBaselinePager *tracker[azfake.PagerResponder[armsql.VulnerabilityAssessmentRuleBaselineClientListByBaselineResponse]]
}

// Do implements the policy.Transporter interface for VulnerabilityAssessmentRuleBaselineServerTransport.
func (v *VulnerabilityAssessmentRuleBaselineServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "VulnerabilityAssessmentRuleBaselineClient.CreateOrUpdate":
		resp, err = v.dispatchCreateOrUpdate(req)
	case "VulnerabilityAssessmentRuleBaselineClient.Get":
		resp, err = v.dispatchGet(req)
	case "VulnerabilityAssessmentRuleBaselineClient.NewListByBaselinePager":
		resp, err = v.dispatchNewListByBaselinePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *VulnerabilityAssessmentRuleBaselineServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if v.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlVulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/baselines/(?P<baselineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/rules/(?P<ruleId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsql.DatabaseSQLVulnerabilityAssessmentRuleBaselineInput](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	baselineNameParam, err := parseWithCast(matches[regex.SubexpIndex("baselineName")], func(v string) (armsql.BaselineName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.BaselineName(p), nil
	})
	if err != nil {
		return nil, err
	}
	ruleIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("ruleId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, serverNameParam, vulnerabilityAssessmentNameParam, baselineNameParam, ruleIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseSQLVulnerabilityAssessmentRuleBaseline, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VulnerabilityAssessmentRuleBaselineServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if v.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlVulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/baselines/(?P<baselineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/rules/(?P<ruleId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	baselineNameParam, err := parseWithCast(matches[regex.SubexpIndex("baselineName")], func(v string) (armsql.BaselineName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.BaselineName(p), nil
	})
	if err != nil {
		return nil, err
	}
	ruleIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("ruleId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.Get(req.Context(), resourceGroupNameParam, serverNameParam, vulnerabilityAssessmentNameParam, baselineNameParam, ruleIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseSQLVulnerabilityAssessmentRuleBaseline, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VulnerabilityAssessmentRuleBaselineServerTransport) dispatchNewListByBaselinePager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListByBaselinePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByBaselinePager not implemented")}
	}
	newListByBaselinePager := v.newListByBaselinePager.get(req)
	if newListByBaselinePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlVulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/baselines/(?P<baselineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/rules`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.VulnerabilityAssessmentName(p), nil
		})
		if err != nil {
			return nil, err
		}
		baselineNameParam, err := parseWithCast(matches[regex.SubexpIndex("baselineName")], func(v string) (armsql.BaselineName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.BaselineName(p), nil
		})
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListByBaselinePager(resourceGroupNameParam, serverNameParam, vulnerabilityAssessmentNameParam, baselineNameParam, nil)
		newListByBaselinePager = &resp
		v.newListByBaselinePager.add(req, newListByBaselinePager)
		server.PagerResponderInjectNextLinks(newListByBaselinePager, req, func(page *armsql.VulnerabilityAssessmentRuleBaselineClientListByBaselineResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByBaselinePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListByBaselinePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByBaselinePager) {
		v.newListByBaselinePager.remove(req)
	}
	return resp, nil
}
