//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ManagedServerDNSAliasesServer is a fake server for instances of the armsql.ManagedServerDNSAliasesClient type.
type ManagedServerDNSAliasesServer struct {
	// BeginAcquire is the fake for method ManagedServerDNSAliasesClient.BeginAcquire
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginAcquire func(ctx context.Context, resourceGroupName string, managedInstanceName string, dnsAliasName string, parameters armsql.ManagedServerDNSAliasAcquisition, options *armsql.ManagedServerDNSAliasesClientBeginAcquireOptions) (resp azfake.PollerResponder[armsql.ManagedServerDNSAliasesClientAcquireResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method ManagedServerDNSAliasesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, managedInstanceName string, dnsAliasName string, parameters armsql.ManagedServerDNSAliasCreation, options *armsql.ManagedServerDNSAliasesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armsql.ManagedServerDNSAliasesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ManagedServerDNSAliasesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, managedInstanceName string, dnsAliasName string, options *armsql.ManagedServerDNSAliasesClientBeginDeleteOptions) (resp azfake.PollerResponder[armsql.ManagedServerDNSAliasesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ManagedServerDNSAliasesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, managedInstanceName string, dnsAliasName string, options *armsql.ManagedServerDNSAliasesClientGetOptions) (resp azfake.Responder[armsql.ManagedServerDNSAliasesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByManagedInstancePager is the fake for method ManagedServerDNSAliasesClient.NewListByManagedInstancePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByManagedInstancePager func(resourceGroupName string, managedInstanceName string, options *armsql.ManagedServerDNSAliasesClientListByManagedInstanceOptions) (resp azfake.PagerResponder[armsql.ManagedServerDNSAliasesClientListByManagedInstanceResponse])
}

// NewManagedServerDNSAliasesServerTransport creates a new instance of ManagedServerDNSAliasesServerTransport with the provided implementation.
// The returned ManagedServerDNSAliasesServerTransport instance is connected to an instance of armsql.ManagedServerDNSAliasesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewManagedServerDNSAliasesServerTransport(srv *ManagedServerDNSAliasesServer) *ManagedServerDNSAliasesServerTransport {
	return &ManagedServerDNSAliasesServerTransport{
		srv:                           srv,
		beginAcquire:                  newTracker[azfake.PollerResponder[armsql.ManagedServerDNSAliasesClientAcquireResponse]](),
		beginCreateOrUpdate:           newTracker[azfake.PollerResponder[armsql.ManagedServerDNSAliasesClientCreateOrUpdateResponse]](),
		beginDelete:                   newTracker[azfake.PollerResponder[armsql.ManagedServerDNSAliasesClientDeleteResponse]](),
		newListByManagedInstancePager: newTracker[azfake.PagerResponder[armsql.ManagedServerDNSAliasesClientListByManagedInstanceResponse]](),
	}
}

// ManagedServerDNSAliasesServerTransport connects instances of armsql.ManagedServerDNSAliasesClient to instances of ManagedServerDNSAliasesServer.
// Don't use this type directly, use NewManagedServerDNSAliasesServerTransport instead.
type ManagedServerDNSAliasesServerTransport struct {
	srv                           *ManagedServerDNSAliasesServer
	beginAcquire                  *tracker[azfake.PollerResponder[armsql.ManagedServerDNSAliasesClientAcquireResponse]]
	beginCreateOrUpdate           *tracker[azfake.PollerResponder[armsql.ManagedServerDNSAliasesClientCreateOrUpdateResponse]]
	beginDelete                   *tracker[azfake.PollerResponder[armsql.ManagedServerDNSAliasesClientDeleteResponse]]
	newListByManagedInstancePager *tracker[azfake.PagerResponder[armsql.ManagedServerDNSAliasesClientListByManagedInstanceResponse]]
}

// Do implements the policy.Transporter interface for ManagedServerDNSAliasesServerTransport.
func (m *ManagedServerDNSAliasesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ManagedServerDNSAliasesClient.BeginAcquire":
		resp, err = m.dispatchBeginAcquire(req)
	case "ManagedServerDNSAliasesClient.BeginCreateOrUpdate":
		resp, err = m.dispatchBeginCreateOrUpdate(req)
	case "ManagedServerDNSAliasesClient.BeginDelete":
		resp, err = m.dispatchBeginDelete(req)
	case "ManagedServerDNSAliasesClient.Get":
		resp, err = m.dispatchGet(req)
	case "ManagedServerDNSAliasesClient.NewListByManagedInstancePager":
		resp, err = m.dispatchNewListByManagedInstancePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *ManagedServerDNSAliasesServerTransport) dispatchBeginAcquire(req *http.Request) (*http.Response, error) {
	if m.srv.BeginAcquire == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginAcquire not implemented")}
	}
	beginAcquire := m.beginAcquire.get(req)
	if beginAcquire == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dnsAliases/(?P<dnsAliasName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/acquire`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.ManagedServerDNSAliasAcquisition](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		dnsAliasNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsAliasName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginAcquire(req.Context(), resourceGroupNameParam, managedInstanceNameParam, dnsAliasNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginAcquire = &respr
		m.beginAcquire.add(req, beginAcquire)
	}

	resp, err := server.PollerResponderNext(beginAcquire, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginAcquire.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginAcquire) {
		m.beginAcquire.remove(req)
	}

	return resp, nil
}

func (m *ManagedServerDNSAliasesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := m.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dnsAliases/(?P<dnsAliasName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.ManagedServerDNSAliasCreation](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		dnsAliasNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsAliasName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, managedInstanceNameParam, dnsAliasNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		m.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		m.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		m.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (m *ManagedServerDNSAliasesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if m.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := m.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dnsAliases/(?P<dnsAliasName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		dnsAliasNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsAliasName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginDelete(req.Context(), resourceGroupNameParam, managedInstanceNameParam, dnsAliasNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		m.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		m.beginDelete.remove(req)
	}

	return resp, nil
}

func (m *ManagedServerDNSAliasesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dnsAliases/(?P<dnsAliasName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
	if err != nil {
		return nil, err
	}
	dnsAliasNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsAliasName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), resourceGroupNameParam, managedInstanceNameParam, dnsAliasNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagedServerDNSAlias, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedServerDNSAliasesServerTransport) dispatchNewListByManagedInstancePager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListByManagedInstancePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByManagedInstancePager not implemented")}
	}
	newListByManagedInstancePager := m.newListByManagedInstancePager.get(req)
	if newListByManagedInstancePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dnsAliases`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListByManagedInstancePager(resourceGroupNameParam, managedInstanceNameParam, nil)
		newListByManagedInstancePager = &resp
		m.newListByManagedInstancePager.add(req, newListByManagedInstancePager)
		server.PagerResponderInjectNextLinks(newListByManagedInstancePager, req, func(page *armsql.ManagedServerDNSAliasesClientListByManagedInstanceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByManagedInstancePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListByManagedInstancePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByManagedInstancePager) {
		m.newListByManagedInstancePager.remove(req)
	}
	return resp, nil
}
