//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// DatabaseSQLVulnerabilityAssessmentScansServer is a fake server for instances of the armsql.DatabaseSQLVulnerabilityAssessmentScansClient type.
type DatabaseSQLVulnerabilityAssessmentScansServer struct {
	// Get is the fake for method DatabaseSQLVulnerabilityAssessmentScansClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, scanID string, options *armsql.DatabaseSQLVulnerabilityAssessmentScansClientGetOptions) (resp azfake.Responder[armsql.DatabaseSQLVulnerabilityAssessmentScansClientGetResponse], errResp azfake.ErrorResponder)

	// NewListBySQLVulnerabilityAssessmentsPager is the fake for method DatabaseSQLVulnerabilityAssessmentScansClient.NewListBySQLVulnerabilityAssessmentsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySQLVulnerabilityAssessmentsPager func(resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, options *armsql.DatabaseSQLVulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsOptions) (resp azfake.PagerResponder[armsql.DatabaseSQLVulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsResponse])
}

// NewDatabaseSQLVulnerabilityAssessmentScansServerTransport creates a new instance of DatabaseSQLVulnerabilityAssessmentScansServerTransport with the provided implementation.
// The returned DatabaseSQLVulnerabilityAssessmentScansServerTransport instance is connected to an instance of armsql.DatabaseSQLVulnerabilityAssessmentScansClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDatabaseSQLVulnerabilityAssessmentScansServerTransport(srv *DatabaseSQLVulnerabilityAssessmentScansServer) *DatabaseSQLVulnerabilityAssessmentScansServerTransport {
	return &DatabaseSQLVulnerabilityAssessmentScansServerTransport{
		srv: srv,
		newListBySQLVulnerabilityAssessmentsPager: newTracker[azfake.PagerResponder[armsql.DatabaseSQLVulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsResponse]](),
	}
}

// DatabaseSQLVulnerabilityAssessmentScansServerTransport connects instances of armsql.DatabaseSQLVulnerabilityAssessmentScansClient to instances of DatabaseSQLVulnerabilityAssessmentScansServer.
// Don't use this type directly, use NewDatabaseSQLVulnerabilityAssessmentScansServerTransport instead.
type DatabaseSQLVulnerabilityAssessmentScansServerTransport struct {
	srv                                       *DatabaseSQLVulnerabilityAssessmentScansServer
	newListBySQLVulnerabilityAssessmentsPager *tracker[azfake.PagerResponder[armsql.DatabaseSQLVulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsResponse]]
}

// Do implements the policy.Transporter interface for DatabaseSQLVulnerabilityAssessmentScansServerTransport.
func (d *DatabaseSQLVulnerabilityAssessmentScansServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DatabaseSQLVulnerabilityAssessmentScansClient.Get":
		resp, err = d.dispatchGet(req)
	case "DatabaseSQLVulnerabilityAssessmentScansClient.NewListBySQLVulnerabilityAssessmentsPager":
		resp, err = d.dispatchNewListBySQLVulnerabilityAssessmentsPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DatabaseSQLVulnerabilityAssessmentScansServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlVulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scans/(?P<scanId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	scanIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scanId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, vulnerabilityAssessmentNameParam, scanIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VulnerabilityAssessmentScanRecordForSQL, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DatabaseSQLVulnerabilityAssessmentScansServerTransport) dispatchNewListBySQLVulnerabilityAssessmentsPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListBySQLVulnerabilityAssessmentsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySQLVulnerabilityAssessmentsPager not implemented")}
	}
	newListBySQLVulnerabilityAssessmentsPager := d.newListBySQLVulnerabilityAssessmentsPager.get(req)
	if newListBySQLVulnerabilityAssessmentsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlVulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scans`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.VulnerabilityAssessmentName(p), nil
		})
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListBySQLVulnerabilityAssessmentsPager(resourceGroupNameParam, serverNameParam, databaseNameParam, vulnerabilityAssessmentNameParam, nil)
		newListBySQLVulnerabilityAssessmentsPager = &resp
		d.newListBySQLVulnerabilityAssessmentsPager.add(req, newListBySQLVulnerabilityAssessmentsPager)
		server.PagerResponderInjectNextLinks(newListBySQLVulnerabilityAssessmentsPager, req, func(page *armsql.DatabaseSQLVulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySQLVulnerabilityAssessmentsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListBySQLVulnerabilityAssessmentsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySQLVulnerabilityAssessmentsPager) {
		d.newListBySQLVulnerabilityAssessmentsPager.remove(req)
	}
	return resp, nil
}
