//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/springappdiscovery/armspringappdiscovery"
	"net/http"
	"net/url"
	"regexp"
)

// SpringbootsitesServer is a fake server for instances of the armspringappdiscovery.SpringbootsitesClient type.
type SpringbootsitesServer struct {
	// CreateOrUpdate is the fake for method SpringbootsitesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, springbootsitesName string, springbootsites armspringappdiscovery.SpringbootsitesModel, options *armspringappdiscovery.SpringbootsitesClientCreateOrUpdateOptions) (resp azfake.Responder[armspringappdiscovery.SpringbootsitesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method SpringbootsitesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, springbootsitesName string, options *armspringappdiscovery.SpringbootsitesClientBeginDeleteOptions) (resp azfake.PollerResponder[armspringappdiscovery.SpringbootsitesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SpringbootsitesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, springbootsitesName string, options *armspringappdiscovery.SpringbootsitesClientGetOptions) (resp azfake.Responder[armspringappdiscovery.SpringbootsitesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method SpringbootsitesClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armspringappdiscovery.SpringbootsitesClientListByResourceGroupOptions) (resp azfake.PagerResponder[armspringappdiscovery.SpringbootsitesClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method SpringbootsitesClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armspringappdiscovery.SpringbootsitesClientListBySubscriptionOptions) (resp azfake.PagerResponder[armspringappdiscovery.SpringbootsitesClientListBySubscriptionResponse])

	// BeginTriggerRefreshSite is the fake for method SpringbootsitesClient.BeginTriggerRefreshSite
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginTriggerRefreshSite func(ctx context.Context, resourceGroupName string, springbootsitesName string, options *armspringappdiscovery.SpringbootsitesClientBeginTriggerRefreshSiteOptions) (resp azfake.PollerResponder[armspringappdiscovery.SpringbootsitesClientTriggerRefreshSiteResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method SpringbootsitesClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, springbootsitesName string, springbootsites armspringappdiscovery.SpringbootsitesPatch, options *armspringappdiscovery.SpringbootsitesClientBeginUpdateOptions) (resp azfake.PollerResponder[armspringappdiscovery.SpringbootsitesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewSpringbootsitesServerTransport creates a new instance of SpringbootsitesServerTransport with the provided implementation.
// The returned SpringbootsitesServerTransport instance is connected to an instance of armspringappdiscovery.SpringbootsitesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSpringbootsitesServerTransport(srv *SpringbootsitesServer) *SpringbootsitesServerTransport {
	return &SpringbootsitesServerTransport{
		srv:                         srv,
		beginDelete:                 newTracker[azfake.PollerResponder[armspringappdiscovery.SpringbootsitesClientDeleteResponse]](),
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armspringappdiscovery.SpringbootsitesClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:  newTracker[azfake.PagerResponder[armspringappdiscovery.SpringbootsitesClientListBySubscriptionResponse]](),
		beginTriggerRefreshSite:     newTracker[azfake.PollerResponder[armspringappdiscovery.SpringbootsitesClientTriggerRefreshSiteResponse]](),
		beginUpdate:                 newTracker[azfake.PollerResponder[armspringappdiscovery.SpringbootsitesClientUpdateResponse]](),
	}
}

// SpringbootsitesServerTransport connects instances of armspringappdiscovery.SpringbootsitesClient to instances of SpringbootsitesServer.
// Don't use this type directly, use NewSpringbootsitesServerTransport instead.
type SpringbootsitesServerTransport struct {
	srv                         *SpringbootsitesServer
	beginDelete                 *tracker[azfake.PollerResponder[armspringappdiscovery.SpringbootsitesClientDeleteResponse]]
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armspringappdiscovery.SpringbootsitesClientListByResourceGroupResponse]]
	newListBySubscriptionPager  *tracker[azfake.PagerResponder[armspringappdiscovery.SpringbootsitesClientListBySubscriptionResponse]]
	beginTriggerRefreshSite     *tracker[azfake.PollerResponder[armspringappdiscovery.SpringbootsitesClientTriggerRefreshSiteResponse]]
	beginUpdate                 *tracker[azfake.PollerResponder[armspringappdiscovery.SpringbootsitesClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for SpringbootsitesServerTransport.
func (s *SpringbootsitesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SpringbootsitesClient.CreateOrUpdate":
		resp, err = s.dispatchCreateOrUpdate(req)
	case "SpringbootsitesClient.BeginDelete":
		resp, err = s.dispatchBeginDelete(req)
	case "SpringbootsitesClient.Get":
		resp, err = s.dispatchGet(req)
	case "SpringbootsitesClient.NewListByResourceGroupPager":
		resp, err = s.dispatchNewListByResourceGroupPager(req)
	case "SpringbootsitesClient.NewListBySubscriptionPager":
		resp, err = s.dispatchNewListBySubscriptionPager(req)
	case "SpringbootsitesClient.BeginTriggerRefreshSite":
		resp, err = s.dispatchBeginTriggerRefreshSite(req)
	case "SpringbootsitesClient.BeginUpdate":
		resp, err = s.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SpringbootsitesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OffAzureSpringBoot/springbootsites/(?P<springbootsitesName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armspringappdiscovery.SpringbootsitesModel](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	springbootsitesNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("springbootsitesName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, springbootsitesNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SpringbootsitesModel, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SpringbootsitesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := s.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OffAzureSpringBoot/springbootsites/(?P<springbootsitesName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		springbootsitesNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("springbootsitesName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDelete(req.Context(), resourceGroupNameParam, springbootsitesNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		s.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		s.beginDelete.remove(req)
	}

	return resp, nil
}

func (s *SpringbootsitesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OffAzureSpringBoot/springbootsites/(?P<springbootsitesName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	springbootsitesNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("springbootsitesName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, springbootsitesNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SpringbootsitesModel, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SpringbootsitesServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := s.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OffAzureSpringBoot/springbootsites`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		s.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armspringappdiscovery.SpringbootsitesClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		s.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (s *SpringbootsitesServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := s.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OffAzureSpringBoot/springbootsites`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := s.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		s.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armspringappdiscovery.SpringbootsitesClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		s.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (s *SpringbootsitesServerTransport) dispatchBeginTriggerRefreshSite(req *http.Request) (*http.Response, error) {
	if s.srv.BeginTriggerRefreshSite == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginTriggerRefreshSite not implemented")}
	}
	beginTriggerRefreshSite := s.beginTriggerRefreshSite.get(req)
	if beginTriggerRefreshSite == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OffAzureSpringBoot/springbootsites/(?P<springbootsitesName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/refreshSite`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		springbootsitesNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("springbootsitesName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginTriggerRefreshSite(req.Context(), resourceGroupNameParam, springbootsitesNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginTriggerRefreshSite = &respr
		s.beginTriggerRefreshSite.add(req, beginTriggerRefreshSite)
	}

	resp, err := server.PollerResponderNext(beginTriggerRefreshSite, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		s.beginTriggerRefreshSite.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginTriggerRefreshSite) {
		s.beginTriggerRefreshSite.remove(req)
	}

	return resp, nil
}

func (s *SpringbootsitesServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := s.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OffAzureSpringBoot/springbootsites/(?P<springbootsitesName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armspringappdiscovery.SpringbootsitesPatch](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		springbootsitesNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("springbootsitesName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginUpdate(req.Context(), resourceGroupNameParam, springbootsitesNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		s.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		s.beginUpdate.remove(req)
	}

	return resp, nil
}
