//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/solutions/armmanagedapplications/v2"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// ApplicationsServer is a fake server for instances of the armmanagedapplications.ApplicationsClient type.
type ApplicationsServer struct {
	// BeginCreateOrUpdate is the fake for method ApplicationsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, applicationName string, parameters armmanagedapplications.Application, options *armmanagedapplications.ApplicationsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armmanagedapplications.ApplicationsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdateByID is the fake for method ApplicationsClient.BeginCreateOrUpdateByID
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdateByID func(ctx context.Context, applicationID string, parameters armmanagedapplications.Application, options *armmanagedapplications.ApplicationsClientBeginCreateOrUpdateByIDOptions) (resp azfake.PollerResponder[armmanagedapplications.ApplicationsClientCreateOrUpdateByIDResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ApplicationsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, applicationName string, options *armmanagedapplications.ApplicationsClientBeginDeleteOptions) (resp azfake.PollerResponder[armmanagedapplications.ApplicationsClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDeleteByID is the fake for method ApplicationsClient.BeginDeleteByID
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeleteByID func(ctx context.Context, applicationID string, options *armmanagedapplications.ApplicationsClientBeginDeleteByIDOptions) (resp azfake.PollerResponder[armmanagedapplications.ApplicationsClientDeleteByIDResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ApplicationsClient.Get
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNotFound
	Get func(ctx context.Context, resourceGroupName string, applicationName string, options *armmanagedapplications.ApplicationsClientGetOptions) (resp azfake.Responder[armmanagedapplications.ApplicationsClientGetResponse], errResp azfake.ErrorResponder)

	// GetByID is the fake for method ApplicationsClient.GetByID
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNotFound
	GetByID func(ctx context.Context, applicationID string, options *armmanagedapplications.ApplicationsClientGetByIDOptions) (resp azfake.Responder[armmanagedapplications.ApplicationsClientGetByIDResponse], errResp azfake.ErrorResponder)

	// ListAllowedUpgradePlans is the fake for method ApplicationsClient.ListAllowedUpgradePlans
	// HTTP status codes to indicate success: http.StatusOK
	ListAllowedUpgradePlans func(ctx context.Context, resourceGroupName string, applicationName string, options *armmanagedapplications.ApplicationsClientListAllowedUpgradePlansOptions) (resp azfake.Responder[armmanagedapplications.ApplicationsClientListAllowedUpgradePlansResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method ApplicationsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armmanagedapplications.ApplicationsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armmanagedapplications.ApplicationsClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method ApplicationsClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armmanagedapplications.ApplicationsClientListBySubscriptionOptions) (resp azfake.PagerResponder[armmanagedapplications.ApplicationsClientListBySubscriptionResponse])

	// ListTokens is the fake for method ApplicationsClient.ListTokens
	// HTTP status codes to indicate success: http.StatusOK
	ListTokens func(ctx context.Context, resourceGroupName string, applicationName string, parameters armmanagedapplications.ListTokenRequest, options *armmanagedapplications.ApplicationsClientListTokensOptions) (resp azfake.Responder[armmanagedapplications.ApplicationsClientListTokensResponse], errResp azfake.ErrorResponder)

	// BeginRefreshPermissions is the fake for method ApplicationsClient.BeginRefreshPermissions
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRefreshPermissions func(ctx context.Context, resourceGroupName string, applicationName string, options *armmanagedapplications.ApplicationsClientBeginRefreshPermissionsOptions) (resp azfake.PollerResponder[armmanagedapplications.ApplicationsClientRefreshPermissionsResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method ApplicationsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, applicationName string, options *armmanagedapplications.ApplicationsClientBeginUpdateOptions) (resp azfake.PollerResponder[armmanagedapplications.ApplicationsClientUpdateResponse], errResp azfake.ErrorResponder)

	// BeginUpdateAccess is the fake for method ApplicationsClient.BeginUpdateAccess
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateAccess func(ctx context.Context, resourceGroupName string, applicationName string, parameters armmanagedapplications.UpdateAccessDefinition, options *armmanagedapplications.ApplicationsClientBeginUpdateAccessOptions) (resp azfake.PollerResponder[armmanagedapplications.ApplicationsClientUpdateAccessResponse], errResp azfake.ErrorResponder)

	// BeginUpdateByID is the fake for method ApplicationsClient.BeginUpdateByID
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateByID func(ctx context.Context, applicationID string, options *armmanagedapplications.ApplicationsClientBeginUpdateByIDOptions) (resp azfake.PollerResponder[armmanagedapplications.ApplicationsClientUpdateByIDResponse], errResp azfake.ErrorResponder)
}

// NewApplicationsServerTransport creates a new instance of ApplicationsServerTransport with the provided implementation.
// The returned ApplicationsServerTransport instance is connected to an instance of armmanagedapplications.ApplicationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewApplicationsServerTransport(srv *ApplicationsServer) *ApplicationsServerTransport {
	return &ApplicationsServerTransport{
		srv:                         srv,
		beginCreateOrUpdate:         newTracker[azfake.PollerResponder[armmanagedapplications.ApplicationsClientCreateOrUpdateResponse]](),
		beginCreateOrUpdateByID:     newTracker[azfake.PollerResponder[armmanagedapplications.ApplicationsClientCreateOrUpdateByIDResponse]](),
		beginDelete:                 newTracker[azfake.PollerResponder[armmanagedapplications.ApplicationsClientDeleteResponse]](),
		beginDeleteByID:             newTracker[azfake.PollerResponder[armmanagedapplications.ApplicationsClientDeleteByIDResponse]](),
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armmanagedapplications.ApplicationsClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:  newTracker[azfake.PagerResponder[armmanagedapplications.ApplicationsClientListBySubscriptionResponse]](),
		beginRefreshPermissions:     newTracker[azfake.PollerResponder[armmanagedapplications.ApplicationsClientRefreshPermissionsResponse]](),
		beginUpdate:                 newTracker[azfake.PollerResponder[armmanagedapplications.ApplicationsClientUpdateResponse]](),
		beginUpdateAccess:           newTracker[azfake.PollerResponder[armmanagedapplications.ApplicationsClientUpdateAccessResponse]](),
		beginUpdateByID:             newTracker[azfake.PollerResponder[armmanagedapplications.ApplicationsClientUpdateByIDResponse]](),
	}
}

// ApplicationsServerTransport connects instances of armmanagedapplications.ApplicationsClient to instances of ApplicationsServer.
// Don't use this type directly, use NewApplicationsServerTransport instead.
type ApplicationsServerTransport struct {
	srv                         *ApplicationsServer
	beginCreateOrUpdate         *tracker[azfake.PollerResponder[armmanagedapplications.ApplicationsClientCreateOrUpdateResponse]]
	beginCreateOrUpdateByID     *tracker[azfake.PollerResponder[armmanagedapplications.ApplicationsClientCreateOrUpdateByIDResponse]]
	beginDelete                 *tracker[azfake.PollerResponder[armmanagedapplications.ApplicationsClientDeleteResponse]]
	beginDeleteByID             *tracker[azfake.PollerResponder[armmanagedapplications.ApplicationsClientDeleteByIDResponse]]
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armmanagedapplications.ApplicationsClientListByResourceGroupResponse]]
	newListBySubscriptionPager  *tracker[azfake.PagerResponder[armmanagedapplications.ApplicationsClientListBySubscriptionResponse]]
	beginRefreshPermissions     *tracker[azfake.PollerResponder[armmanagedapplications.ApplicationsClientRefreshPermissionsResponse]]
	beginUpdate                 *tracker[azfake.PollerResponder[armmanagedapplications.ApplicationsClientUpdateResponse]]
	beginUpdateAccess           *tracker[azfake.PollerResponder[armmanagedapplications.ApplicationsClientUpdateAccessResponse]]
	beginUpdateByID             *tracker[azfake.PollerResponder[armmanagedapplications.ApplicationsClientUpdateByIDResponse]]
}

// Do implements the policy.Transporter interface for ApplicationsServerTransport.
func (a *ApplicationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ApplicationsClient.BeginCreateOrUpdate":
		resp, err = a.dispatchBeginCreateOrUpdate(req)
	case "ApplicationsClient.BeginCreateOrUpdateByID":
		resp, err = a.dispatchBeginCreateOrUpdateByID(req)
	case "ApplicationsClient.BeginDelete":
		resp, err = a.dispatchBeginDelete(req)
	case "ApplicationsClient.BeginDeleteByID":
		resp, err = a.dispatchBeginDeleteByID(req)
	case "ApplicationsClient.Get":
		resp, err = a.dispatchGet(req)
	case "ApplicationsClient.GetByID":
		resp, err = a.dispatchGetByID(req)
	case "ApplicationsClient.ListAllowedUpgradePlans":
		resp, err = a.dispatchListAllowedUpgradePlans(req)
	case "ApplicationsClient.NewListByResourceGroupPager":
		resp, err = a.dispatchNewListByResourceGroupPager(req)
	case "ApplicationsClient.NewListBySubscriptionPager":
		resp, err = a.dispatchNewListBySubscriptionPager(req)
	case "ApplicationsClient.ListTokens":
		resp, err = a.dispatchListTokens(req)
	case "ApplicationsClient.BeginRefreshPermissions":
		resp, err = a.dispatchBeginRefreshPermissions(req)
	case "ApplicationsClient.BeginUpdate":
		resp, err = a.dispatchBeginUpdate(req)
	case "ApplicationsClient.BeginUpdateAccess":
		resp, err = a.dispatchBeginUpdateAccess(req)
	case "ApplicationsClient.BeginUpdateByID":
		resp, err = a.dispatchBeginUpdateByID(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *ApplicationsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := a.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/applications/(?P<applicationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagedapplications.Application](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		applicationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, applicationNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		a.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		a.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		a.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (a *ApplicationsServerTransport) dispatchBeginCreateOrUpdateByID(req *http.Request) (*http.Response, error) {
	if a.srv.BeginCreateOrUpdateByID == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateByID not implemented")}
	}
	beginCreateOrUpdateByID := a.beginCreateOrUpdateByID.get(req)
	if beginCreateOrUpdateByID == nil {
		const regexStr = `/(?P<applicationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagedapplications.Application](req)
		if err != nil {
			return nil, err
		}
		applicationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginCreateOrUpdateByID(req.Context(), applicationIDParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateByID = &respr
		a.beginCreateOrUpdateByID.add(req, beginCreateOrUpdateByID)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateByID, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		a.beginCreateOrUpdateByID.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateByID) {
		a.beginCreateOrUpdateByID.remove(req)
	}

	return resp, nil
}

func (a *ApplicationsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if a.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := a.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/applications/(?P<applicationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		applicationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginDelete(req.Context(), resourceGroupNameParam, applicationNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		a.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		a.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		a.beginDelete.remove(req)
	}

	return resp, nil
}

func (a *ApplicationsServerTransport) dispatchBeginDeleteByID(req *http.Request) (*http.Response, error) {
	if a.srv.BeginDeleteByID == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteByID not implemented")}
	}
	beginDeleteByID := a.beginDeleteByID.get(req)
	if beginDeleteByID == nil {
		const regexStr = `/(?P<applicationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		applicationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginDeleteByID(req.Context(), applicationIDParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteByID = &respr
		a.beginDeleteByID.add(req, beginDeleteByID)
	}

	resp, err := server.PollerResponderNext(beginDeleteByID, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		a.beginDeleteByID.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteByID) {
		a.beginDeleteByID.remove(req)
	}

	return resp, nil
}

func (a *ApplicationsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/applications/(?P<applicationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	applicationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), resourceGroupNameParam, applicationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNotFound}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNotFound", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Application, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ApplicationsServerTransport) dispatchGetByID(req *http.Request) (*http.Response, error) {
	if a.srv.GetByID == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByID not implemented")}
	}
	const regexStr = `/(?P<applicationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	applicationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.GetByID(req.Context(), applicationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNotFound}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNotFound", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Application, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ApplicationsServerTransport) dispatchListAllowedUpgradePlans(req *http.Request) (*http.Response, error) {
	if a.srv.ListAllowedUpgradePlans == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListAllowedUpgradePlans not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/applications/(?P<applicationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listAllowedUpgradePlans`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	applicationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.ListAllowedUpgradePlans(req.Context(), resourceGroupNameParam, applicationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AllowedUpgradePlansResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ApplicationsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := a.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/applications`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		a.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armmanagedapplications.ApplicationsClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		a.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (a *ApplicationsServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := a.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/applications`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := a.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		a.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armmanagedapplications.ApplicationsClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		a.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (a *ApplicationsServerTransport) dispatchListTokens(req *http.Request) (*http.Response, error) {
	if a.srv.ListTokens == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListTokens not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/applications/(?P<applicationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listTokens`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmanagedapplications.ListTokenRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	applicationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.ListTokens(req.Context(), resourceGroupNameParam, applicationNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagedIdentityTokenResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ApplicationsServerTransport) dispatchBeginRefreshPermissions(req *http.Request) (*http.Response, error) {
	if a.srv.BeginRefreshPermissions == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRefreshPermissions not implemented")}
	}
	beginRefreshPermissions := a.beginRefreshPermissions.get(req)
	if beginRefreshPermissions == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/applications/(?P<applicationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/refreshPermissions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		applicationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginRefreshPermissions(req.Context(), resourceGroupNameParam, applicationNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRefreshPermissions = &respr
		a.beginRefreshPermissions.add(req, beginRefreshPermissions)
	}

	resp, err := server.PollerResponderNext(beginRefreshPermissions, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		a.beginRefreshPermissions.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRefreshPermissions) {
		a.beginRefreshPermissions.remove(req)
	}

	return resp, nil
}

func (a *ApplicationsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := a.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/applications/(?P<applicationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagedapplications.ApplicationPatchable](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		applicationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationName")])
		if err != nil {
			return nil, err
		}
		var options *armmanagedapplications.ApplicationsClientBeginUpdateOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armmanagedapplications.ApplicationsClientBeginUpdateOptions{
				Parameters: &body,
			}
		}
		respr, errRespr := a.srv.BeginUpdate(req.Context(), resourceGroupNameParam, applicationNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		a.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		a.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		a.beginUpdate.remove(req)
	}

	return resp, nil
}

func (a *ApplicationsServerTransport) dispatchBeginUpdateAccess(req *http.Request) (*http.Response, error) {
	if a.srv.BeginUpdateAccess == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateAccess not implemented")}
	}
	beginUpdateAccess := a.beginUpdateAccess.get(req)
	if beginUpdateAccess == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Solutions/applications/(?P<applicationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/updateAccess`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagedapplications.UpdateAccessDefinition](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		applicationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginUpdateAccess(req.Context(), resourceGroupNameParam, applicationNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateAccess = &respr
		a.beginUpdateAccess.add(req, beginUpdateAccess)
	}

	resp, err := server.PollerResponderNext(beginUpdateAccess, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		a.beginUpdateAccess.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateAccess) {
		a.beginUpdateAccess.remove(req)
	}

	return resp, nil
}

func (a *ApplicationsServerTransport) dispatchBeginUpdateByID(req *http.Request) (*http.Response, error) {
	if a.srv.BeginUpdateByID == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateByID not implemented")}
	}
	beginUpdateByID := a.beginUpdateByID.get(req)
	if beginUpdateByID == nil {
		const regexStr = `/(?P<applicationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagedapplications.ApplicationPatchable](req)
		if err != nil {
			return nil, err
		}
		applicationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationId")])
		if err != nil {
			return nil, err
		}
		var options *armmanagedapplications.ApplicationsClientBeginUpdateByIDOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armmanagedapplications.ApplicationsClientBeginUpdateByIDOptions{
				Parameters: &body,
			}
		}
		respr, errRespr := a.srv.BeginUpdateByID(req.Context(), applicationIDParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateByID = &respr
		a.beginUpdateByID.add(req, beginUpdateByID)
	}

	resp, err := server.PollerResponderNext(beginUpdateByID, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		a.beginUpdateByID.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateByID) {
		a.beginUpdateByID.remove(req)
	}

	return resp, nil
}
