//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armservicelinker_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/servicelinker/armservicelinker/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c16ce913afbdaa073e8ca5e480f3b465db2de542/specification/servicelinker/resource-manager/Microsoft.ServiceLinker/preview/2023-04-01-preview/examples/OperationsList.json
func ExampleOperationsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armservicelinker.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOperationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OperationListResult = armservicelinker.OperationListResult{
		// 	Value: []*armservicelinker.Operation{
		// 		{
		// 			Name: to.Ptr("Microsoft.ServiceLinker/register/action"),
		// 			Display: &armservicelinker.OperationDisplay{
		// 				Description: to.Ptr("Register the subscription for Microsoft.ServiceLinker"),
		// 				Operation: to.Ptr("Register the Microsoft.ServiceLinker"),
		// 				Provider: to.Ptr("Microsoft.ServiceLinker"),
		// 				Resource: to.Ptr("Microsoft.ServiceLinker"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ServiceLinker/unregister/action"),
		// 			Display: &armservicelinker.OperationDisplay{
		// 				Description: to.Ptr("Unregister the subscription for Microsoft.ServiceLinker"),
		// 				Operation: to.Ptr("Unregister the Microsoft.ServiceLinker"),
		// 				Provider: to.Ptr("Microsoft.ServiceLinker"),
		// 				Resource: to.Ptr("Microsoft.ServiceLinker"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ServiceLinker/operations/read"),
		// 			Display: &armservicelinker.OperationDisplay{
		// 				Description: to.Ptr("read operations"),
		// 				Operation: to.Ptr("read_operations"),
		// 				Provider: to.Ptr("Microsoft.ServiceLinker"),
		// 				Resource: to.Ptr("operations"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ServiceLinker/dryruns/read"),
		// 			Display: &armservicelinker.OperationDisplay{
		// 				Description: to.Ptr("list dryrun jobs"),
		// 				Operation: to.Ptr("Dryrun_List"),
		// 				Provider: to.Ptr("Microsoft.ServiceLinker"),
		// 				Resource: to.Ptr("dryruns"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ServiceLinker/dryruns/read"),
		// 			Display: &armservicelinker.OperationDisplay{
		// 				Description: to.Ptr("get a dryrun job"),
		// 				Operation: to.Ptr("Dryrun_Get"),
		// 				Provider: to.Ptr("Microsoft.ServiceLinker"),
		// 				Resource: to.Ptr("dryruns"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ServiceLinker/dryruns/write"),
		// 			Display: &armservicelinker.OperationDisplay{
		// 				Description: to.Ptr("create a dryrun job to do necessary check before actual creation"),
		// 				Operation: to.Ptr("Dryrun_Create"),
		// 				Provider: to.Ptr("Microsoft.ServiceLinker"),
		// 				Resource: to.Ptr("dryruns"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ServiceLinker/dryruns/delete"),
		// 			Display: &armservicelinker.OperationDisplay{
		// 				Description: to.Ptr("delete a dryrun job"),
		// 				Operation: to.Ptr("Dryrun_Delete"),
		// 				Provider: to.Ptr("Microsoft.ServiceLinker"),
		// 				Resource: to.Ptr("dryruns"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ServiceLinker/dryruns/write"),
		// 			Display: &armservicelinker.OperationDisplay{
		// 				Description: to.Ptr("add a dryrun job to do necessary check before actual creation"),
		// 				Operation: to.Ptr("Dryrun_Update"),
		// 				Provider: to.Ptr("Microsoft.ServiceLinker"),
		// 				Resource: to.Ptr("dryruns"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ServiceLinker/locations/operationStatuses/read"),
		// 			Display: &armservicelinker.OperationDisplay{
		// 				Description: to.Ptr("read operationStatuses"),
		// 				Operation: to.Ptr("read_operationStatuses"),
		// 				Provider: to.Ptr("Microsoft.ServiceLinker"),
		// 				Resource: to.Ptr("locations/operationStatuses"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ServiceLinker/locations/operationStatuses/write"),
		// 			Display: &armservicelinker.OperationDisplay{
		// 				Description: to.Ptr("write operationStatuses"),
		// 				Operation: to.Ptr("write_operationStatuses"),
		// 				Provider: to.Ptr("Microsoft.ServiceLinker"),
		// 				Resource: to.Ptr("locations/operationStatuses"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ServiceLinker/linkers/read"),
		// 			Display: &armservicelinker.OperationDisplay{
		// 				Description: to.Ptr("Returns list of Linkers which connects to the resource."),
		// 				Operation: to.Ptr("Linker_List"),
		// 				Provider: to.Ptr("Microsoft.ServiceLinker"),
		// 				Resource: to.Ptr("linkers"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ServiceLinker/linkers/read"),
		// 			Display: &armservicelinker.OperationDisplay{
		// 				Description: to.Ptr("Returns Linker resource for a given name."),
		// 				Operation: to.Ptr("Linker_Get"),
		// 				Provider: to.Ptr("Microsoft.ServiceLinker"),
		// 				Resource: to.Ptr("linkers"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ServiceLinker/linkers/write"),
		// 			Display: &armservicelinker.OperationDisplay{
		// 				Description: to.Ptr("Create or update linker resource."),
		// 				Operation: to.Ptr("Linker_CreateOrUpdate"),
		// 				Provider: to.Ptr("Microsoft.ServiceLinker"),
		// 				Resource: to.Ptr("linkers"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ServiceLinker/linkers/delete"),
		// 			Display: &armservicelinker.OperationDisplay{
		// 				Description: to.Ptr("Delete a link."),
		// 				Operation: to.Ptr("Linker_Delete"),
		// 				Provider: to.Ptr("Microsoft.ServiceLinker"),
		// 				Resource: to.Ptr("linkers"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ServiceLinker/linkers/write"),
		// 			Display: &armservicelinker.OperationDisplay{
		// 				Description: to.Ptr("Operation to update an existing link."),
		// 				Operation: to.Ptr("Linker_Update"),
		// 				Provider: to.Ptr("Microsoft.ServiceLinker"),
		// 				Resource: to.Ptr("linkers"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ServiceLinker/linkers/validateLinker/action"),
		// 			Display: &armservicelinker.OperationDisplay{
		// 				Description: to.Ptr("Validate a link."),
		// 				Operation: to.Ptr("Linker_Validate"),
		// 				Provider: to.Ptr("Microsoft.ServiceLinker"),
		// 				Resource: to.Ptr("linkers"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ServiceLinker/linkers/listConfigurations/action"),
		// 			Display: &armservicelinker.OperationDisplay{
		// 				Description: to.Ptr("list source configurations for a linker."),
		// 				Operation: to.Ptr("Linker_ListConfigurations"),
		// 				Provider: to.Ptr("Microsoft.ServiceLinker"),
		// 				Resource: to.Ptr("linkers"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 	}},
		// }
	}
}
