//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armservicelinker

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ConnectorClient contains the methods for the Connector group.
// Don't use this type directly, use NewConnectorClient() instead.
type ConnectorClient struct {
	internal *arm.Client
}

// NewConnectorClient creates a new instance of ConnectorClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewConnectorClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*ConnectorClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ConnectorClient{
		internal: cl,
	}
	return client, nil
}

// BeginCreateDryrun - create a dryrun job to do necessary check before actual creation
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
//   - subscriptionID - The ID of the target subscription.
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - location - The name of Azure region.
//   - dryrunName - The name of dryrun.
//   - parameters - dryrun resource.
//   - options - ConnectorClientBeginCreateDryrunOptions contains the optional parameters for the ConnectorClient.BeginCreateDryrun
//     method.
func (client *ConnectorClient) BeginCreateDryrun(ctx context.Context, subscriptionID string, resourceGroupName string, location string, dryrunName string, parameters DryrunResource, options *ConnectorClientBeginCreateDryrunOptions) (*runtime.Poller[ConnectorClientCreateDryrunResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createDryrun(ctx, subscriptionID, resourceGroupName, location, dryrunName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ConnectorClientCreateDryrunResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ConnectorClientCreateDryrunResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateDryrun - create a dryrun job to do necessary check before actual creation
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
func (client *ConnectorClient) createDryrun(ctx context.Context, subscriptionID string, resourceGroupName string, location string, dryrunName string, parameters DryrunResource, options *ConnectorClientBeginCreateDryrunOptions) (*http.Response, error) {
	var err error
	const operationName = "ConnectorClient.BeginCreateDryrun"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createDryrunCreateRequest(ctx, subscriptionID, resourceGroupName, location, dryrunName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createDryrunCreateRequest creates the CreateDryrun request.
func (client *ConnectorClient) createDryrunCreateRequest(ctx context.Context, subscriptionID string, resourceGroupName string, location string, dryrunName string, parameters DryrunResource, options *ConnectorClientBeginCreateDryrunOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.ServiceLinker/locations/{location}/dryruns/{dryrunName}"
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	if dryrunName == "" {
		return nil, errors.New("parameter dryrunName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dryrunName}", url.PathEscape(dryrunName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginCreateOrUpdate - Create or update Connector resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
//   - subscriptionID - The ID of the target subscription.
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - location - The name of Azure region.
//   - connectorName - The name of resource.
//   - parameters - Connector details.
//   - options - ConnectorClientBeginCreateOrUpdateOptions contains the optional parameters for the ConnectorClient.BeginCreateOrUpdate
//     method.
func (client *ConnectorClient) BeginCreateOrUpdate(ctx context.Context, subscriptionID string, resourceGroupName string, location string, connectorName string, parameters LinkerResource, options *ConnectorClientBeginCreateOrUpdateOptions) (*runtime.Poller[ConnectorClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, subscriptionID, resourceGroupName, location, connectorName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ConnectorClientCreateOrUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ConnectorClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdate - Create or update Connector resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
func (client *ConnectorClient) createOrUpdate(ctx context.Context, subscriptionID string, resourceGroupName string, location string, connectorName string, parameters LinkerResource, options *ConnectorClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "ConnectorClient.BeginCreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, subscriptionID, resourceGroupName, location, connectorName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *ConnectorClient) createOrUpdateCreateRequest(ctx context.Context, subscriptionID string, resourceGroupName string, location string, connectorName string, parameters LinkerResource, options *ConnectorClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.ServiceLinker/locations/{location}/connectors/{connectorName}"
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	if connectorName == "" {
		return nil, errors.New("parameter connectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{connectorName}", url.PathEscape(connectorName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - Delete a Connector.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
//   - subscriptionID - The ID of the target subscription.
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - location - The name of Azure region.
//   - connectorName - The name of resource.
//   - options - ConnectorClientBeginDeleteOptions contains the optional parameters for the ConnectorClient.BeginDelete method.
func (client *ConnectorClient) BeginDelete(ctx context.Context, subscriptionID string, resourceGroupName string, location string, connectorName string, options *ConnectorClientBeginDeleteOptions) (*runtime.Poller[ConnectorClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, subscriptionID, resourceGroupName, location, connectorName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ConnectorClientDeleteResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ConnectorClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Delete a Connector.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
func (client *ConnectorClient) deleteOperation(ctx context.Context, subscriptionID string, resourceGroupName string, location string, connectorName string, options *ConnectorClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "ConnectorClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, subscriptionID, resourceGroupName, location, connectorName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ConnectorClient) deleteCreateRequest(ctx context.Context, subscriptionID string, resourceGroupName string, location string, connectorName string, options *ConnectorClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.ServiceLinker/locations/{location}/connectors/{connectorName}"
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	if connectorName == "" {
		return nil, errors.New("parameter connectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{connectorName}", url.PathEscape(connectorName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteDryrun - delete a dryrun job
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
//   - subscriptionID - The ID of the target subscription.
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - location - The name of Azure region.
//   - dryrunName - The name of dryrun.
//   - options - ConnectorClientDeleteDryrunOptions contains the optional parameters for the ConnectorClient.DeleteDryrun method.
func (client *ConnectorClient) DeleteDryrun(ctx context.Context, subscriptionID string, resourceGroupName string, location string, dryrunName string, options *ConnectorClientDeleteDryrunOptions) (ConnectorClientDeleteDryrunResponse, error) {
	var err error
	const operationName = "ConnectorClient.DeleteDryrun"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteDryrunCreateRequest(ctx, subscriptionID, resourceGroupName, location, dryrunName, options)
	if err != nil {
		return ConnectorClientDeleteDryrunResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ConnectorClientDeleteDryrunResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return ConnectorClientDeleteDryrunResponse{}, err
	}
	return ConnectorClientDeleteDryrunResponse{}, nil
}

// deleteDryrunCreateRequest creates the DeleteDryrun request.
func (client *ConnectorClient) deleteDryrunCreateRequest(ctx context.Context, subscriptionID string, resourceGroupName string, location string, dryrunName string, options *ConnectorClientDeleteDryrunOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.ServiceLinker/locations/{location}/dryruns/{dryrunName}"
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	if dryrunName == "" {
		return nil, errors.New("parameter dryrunName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dryrunName}", url.PathEscape(dryrunName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GenerateConfigurations - Generate configurations for a Connector.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
//   - subscriptionID - The ID of the target subscription.
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - location - The name of Azure region.
//   - connectorName - The name of resource.
//   - options - ConnectorClientGenerateConfigurationsOptions contains the optional parameters for the ConnectorClient.GenerateConfigurations
//     method.
func (client *ConnectorClient) GenerateConfigurations(ctx context.Context, subscriptionID string, resourceGroupName string, location string, connectorName string, options *ConnectorClientGenerateConfigurationsOptions) (ConnectorClientGenerateConfigurationsResponse, error) {
	var err error
	const operationName = "ConnectorClient.GenerateConfigurations"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.generateConfigurationsCreateRequest(ctx, subscriptionID, resourceGroupName, location, connectorName, options)
	if err != nil {
		return ConnectorClientGenerateConfigurationsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ConnectorClientGenerateConfigurationsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ConnectorClientGenerateConfigurationsResponse{}, err
	}
	resp, err := client.generateConfigurationsHandleResponse(httpResp)
	return resp, err
}

// generateConfigurationsCreateRequest creates the GenerateConfigurations request.
func (client *ConnectorClient) generateConfigurationsCreateRequest(ctx context.Context, subscriptionID string, resourceGroupName string, location string, connectorName string, options *ConnectorClientGenerateConfigurationsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.ServiceLinker/locations/{location}/connectors/{connectorName}/generateConfigurations"
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	if connectorName == "" {
		return nil, errors.New("parameter connectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{connectorName}", url.PathEscape(connectorName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Parameters != nil {
		if err := runtime.MarshalAsJSON(req, *options.Parameters); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// generateConfigurationsHandleResponse handles the GenerateConfigurations response.
func (client *ConnectorClient) generateConfigurationsHandleResponse(resp *http.Response) (ConnectorClientGenerateConfigurationsResponse, error) {
	result := ConnectorClientGenerateConfigurationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ConfigurationResult); err != nil {
		return ConnectorClientGenerateConfigurationsResponse{}, err
	}
	return result, nil
}

// Get - Returns Connector resource for a given name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
//   - subscriptionID - The ID of the target subscription.
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - location - The name of Azure region.
//   - connectorName - The name of resource.
//   - options - ConnectorClientGetOptions contains the optional parameters for the ConnectorClient.Get method.
func (client *ConnectorClient) Get(ctx context.Context, subscriptionID string, resourceGroupName string, location string, connectorName string, options *ConnectorClientGetOptions) (ConnectorClientGetResponse, error) {
	var err error
	const operationName = "ConnectorClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, subscriptionID, resourceGroupName, location, connectorName, options)
	if err != nil {
		return ConnectorClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ConnectorClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ConnectorClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ConnectorClient) getCreateRequest(ctx context.Context, subscriptionID string, resourceGroupName string, location string, connectorName string, options *ConnectorClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.ServiceLinker/locations/{location}/connectors/{connectorName}"
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	if connectorName == "" {
		return nil, errors.New("parameter connectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{connectorName}", url.PathEscape(connectorName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ConnectorClient) getHandleResponse(resp *http.Response) (ConnectorClientGetResponse, error) {
	result := ConnectorClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.LinkerResource); err != nil {
		return ConnectorClientGetResponse{}, err
	}
	return result, nil
}

// GetDryrun - get a dryrun job
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
//   - subscriptionID - The ID of the target subscription.
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - location - The name of Azure region.
//   - dryrunName - The name of dryrun.
//   - options - ConnectorClientGetDryrunOptions contains the optional parameters for the ConnectorClient.GetDryrun method.
func (client *ConnectorClient) GetDryrun(ctx context.Context, subscriptionID string, resourceGroupName string, location string, dryrunName string, options *ConnectorClientGetDryrunOptions) (ConnectorClientGetDryrunResponse, error) {
	var err error
	const operationName = "ConnectorClient.GetDryrun"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getDryrunCreateRequest(ctx, subscriptionID, resourceGroupName, location, dryrunName, options)
	if err != nil {
		return ConnectorClientGetDryrunResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ConnectorClientGetDryrunResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ConnectorClientGetDryrunResponse{}, err
	}
	resp, err := client.getDryrunHandleResponse(httpResp)
	return resp, err
}

// getDryrunCreateRequest creates the GetDryrun request.
func (client *ConnectorClient) getDryrunCreateRequest(ctx context.Context, subscriptionID string, resourceGroupName string, location string, dryrunName string, options *ConnectorClientGetDryrunOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.ServiceLinker/locations/{location}/dryruns/{dryrunName}"
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	if dryrunName == "" {
		return nil, errors.New("parameter dryrunName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dryrunName}", url.PathEscape(dryrunName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDryrunHandleResponse handles the GetDryrun response.
func (client *ConnectorClient) getDryrunHandleResponse(resp *http.Response) (ConnectorClientGetDryrunResponse, error) {
	result := ConnectorClientGetDryrunResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DryrunResource); err != nil {
		return ConnectorClientGetDryrunResponse{}, err
	}
	return result, nil
}

// NewListPager - Returns list of connector which connects to the resource, which supports to config the target service during
// the resource provision.
//
// Generated from API version 2023-04-01-preview
//   - subscriptionID - The ID of the target subscription.
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - location - The name of Azure region.
//   - options - ConnectorClientListOptions contains the optional parameters for the ConnectorClient.NewListPager method.
func (client *ConnectorClient) NewListPager(subscriptionID string, resourceGroupName string, location string, options *ConnectorClientListOptions) *runtime.Pager[ConnectorClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[ConnectorClientListResponse]{
		More: func(page ConnectorClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ConnectorClientListResponse) (ConnectorClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ConnectorClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, subscriptionID, resourceGroupName, location, options)
			}, nil)
			if err != nil {
				return ConnectorClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *ConnectorClient) listCreateRequest(ctx context.Context, subscriptionID string, resourceGroupName string, location string, options *ConnectorClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.ServiceLinker/locations/{location}/connectors"
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *ConnectorClient) listHandleResponse(resp *http.Response) (ConnectorClientListResponse, error) {
	result := ConnectorClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceList); err != nil {
		return ConnectorClientListResponse{}, err
	}
	return result, nil
}

// NewListDryrunPager - list dryrun jobs
//
// Generated from API version 2023-04-01-preview
//   - subscriptionID - The ID of the target subscription.
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - location - The name of Azure region.
//   - options - ConnectorClientListDryrunOptions contains the optional parameters for the ConnectorClient.NewListDryrunPager
//     method.
func (client *ConnectorClient) NewListDryrunPager(subscriptionID string, resourceGroupName string, location string, options *ConnectorClientListDryrunOptions) *runtime.Pager[ConnectorClientListDryrunResponse] {
	return runtime.NewPager(runtime.PagingHandler[ConnectorClientListDryrunResponse]{
		More: func(page ConnectorClientListDryrunResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ConnectorClientListDryrunResponse) (ConnectorClientListDryrunResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ConnectorClient.NewListDryrunPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listDryrunCreateRequest(ctx, subscriptionID, resourceGroupName, location, options)
			}, nil)
			if err != nil {
				return ConnectorClientListDryrunResponse{}, err
			}
			return client.listDryrunHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listDryrunCreateRequest creates the ListDryrun request.
func (client *ConnectorClient) listDryrunCreateRequest(ctx context.Context, subscriptionID string, resourceGroupName string, location string, options *ConnectorClientListDryrunOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.ServiceLinker/locations/{location}/dryruns"
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listDryrunHandleResponse handles the ListDryrun response.
func (client *ConnectorClient) listDryrunHandleResponse(resp *http.Response) (ConnectorClientListDryrunResponse, error) {
	result := ConnectorClientListDryrunResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DryrunList); err != nil {
		return ConnectorClientListDryrunResponse{}, err
	}
	return result, nil
}

// BeginUpdate - Operation to update an existing Connector.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
//   - subscriptionID - The ID of the target subscription.
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - location - The name of Azure region.
//   - connectorName - The name of resource.
//   - parameters - Connector details.
//   - options - ConnectorClientBeginUpdateOptions contains the optional parameters for the ConnectorClient.BeginUpdate method.
func (client *ConnectorClient) BeginUpdate(ctx context.Context, subscriptionID string, resourceGroupName string, location string, connectorName string, parameters LinkerPatch, options *ConnectorClientBeginUpdateOptions) (*runtime.Poller[ConnectorClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, subscriptionID, resourceGroupName, location, connectorName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ConnectorClientUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ConnectorClientUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Update - Operation to update an existing Connector.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
func (client *ConnectorClient) update(ctx context.Context, subscriptionID string, resourceGroupName string, location string, connectorName string, parameters LinkerPatch, options *ConnectorClientBeginUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "ConnectorClient.BeginUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, subscriptionID, resourceGroupName, location, connectorName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateCreateRequest creates the Update request.
func (client *ConnectorClient) updateCreateRequest(ctx context.Context, subscriptionID string, resourceGroupName string, location string, connectorName string, parameters LinkerPatch, options *ConnectorClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.ServiceLinker/locations/{location}/connectors/{connectorName}"
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	if connectorName == "" {
		return nil, errors.New("parameter connectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{connectorName}", url.PathEscape(connectorName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginUpdateDryrun - update a dryrun job to do necessary check before actual creation
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
//   - subscriptionID - The ID of the target subscription.
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - location - The name of Azure region.
//   - dryrunName - The name of dryrun.
//   - parameters - dryrun resource.
//   - options - ConnectorClientBeginUpdateDryrunOptions contains the optional parameters for the ConnectorClient.BeginUpdateDryrun
//     method.
func (client *ConnectorClient) BeginUpdateDryrun(ctx context.Context, subscriptionID string, resourceGroupName string, location string, dryrunName string, parameters DryrunPatch, options *ConnectorClientBeginUpdateDryrunOptions) (*runtime.Poller[ConnectorClientUpdateDryrunResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.updateDryrun(ctx, subscriptionID, resourceGroupName, location, dryrunName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ConnectorClientUpdateDryrunResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ConnectorClientUpdateDryrunResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// UpdateDryrun - update a dryrun job to do necessary check before actual creation
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
func (client *ConnectorClient) updateDryrun(ctx context.Context, subscriptionID string, resourceGroupName string, location string, dryrunName string, parameters DryrunPatch, options *ConnectorClientBeginUpdateDryrunOptions) (*http.Response, error) {
	var err error
	const operationName = "ConnectorClient.BeginUpdateDryrun"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateDryrunCreateRequest(ctx, subscriptionID, resourceGroupName, location, dryrunName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateDryrunCreateRequest creates the UpdateDryrun request.
func (client *ConnectorClient) updateDryrunCreateRequest(ctx context.Context, subscriptionID string, resourceGroupName string, location string, dryrunName string, parameters DryrunPatch, options *ConnectorClientBeginUpdateDryrunOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.ServiceLinker/locations/{location}/dryruns/{dryrunName}"
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	if dryrunName == "" {
		return nil, errors.New("parameter dryrunName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dryrunName}", url.PathEscape(dryrunName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginValidate - Validate a Connector.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
//   - subscriptionID - The ID of the target subscription.
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - location - The name of Azure region.
//   - connectorName - The name of resource.
//   - options - ConnectorClientBeginValidateOptions contains the optional parameters for the ConnectorClient.BeginValidate method.
func (client *ConnectorClient) BeginValidate(ctx context.Context, subscriptionID string, resourceGroupName string, location string, connectorName string, options *ConnectorClientBeginValidateOptions) (*runtime.Poller[ConnectorClientValidateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.validate(ctx, subscriptionID, resourceGroupName, location, connectorName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ConnectorClientValidateResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ConnectorClientValidateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Validate - Validate a Connector.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01-preview
func (client *ConnectorClient) validate(ctx context.Context, subscriptionID string, resourceGroupName string, location string, connectorName string, options *ConnectorClientBeginValidateOptions) (*http.Response, error) {
	var err error
	const operationName = "ConnectorClient.BeginValidate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.validateCreateRequest(ctx, subscriptionID, resourceGroupName, location, connectorName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// validateCreateRequest creates the Validate request.
func (client *ConnectorClient) validateCreateRequest(ctx context.Context, subscriptionID string, resourceGroupName string, location string, connectorName string, options *ConnectorClientBeginValidateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.ServiceLinker/locations/{location}/connectors/{connectorName}/validate"
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	if connectorName == "" {
		return nil, errors.New("parameter connectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{connectorName}", url.PathEscape(connectorName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}
