//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/servicebus/armservicebus"
	"net/http"
	"net/url"
	"regexp"
)

// MigrationConfigsServer is a fake server for instances of the armservicebus.MigrationConfigsClient type.
type MigrationConfigsServer struct {
	// CompleteMigration is the fake for method MigrationConfigsClient.CompleteMigration
	// HTTP status codes to indicate success: http.StatusOK
	CompleteMigration func(ctx context.Context, resourceGroupName string, namespaceName string, configName armservicebus.MigrationConfigurationName, options *armservicebus.MigrationConfigsClientCompleteMigrationOptions) (resp azfake.Responder[armservicebus.MigrationConfigsClientCompleteMigrationResponse], errResp azfake.ErrorResponder)

	// BeginCreateAndStartMigration is the fake for method MigrationConfigsClient.BeginCreateAndStartMigration
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateAndStartMigration func(ctx context.Context, resourceGroupName string, namespaceName string, configName armservicebus.MigrationConfigurationName, parameters armservicebus.MigrationConfigProperties, options *armservicebus.MigrationConfigsClientBeginCreateAndStartMigrationOptions) (resp azfake.PollerResponder[armservicebus.MigrationConfigsClientCreateAndStartMigrationResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method MigrationConfigsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, namespaceName string, configName armservicebus.MigrationConfigurationName, options *armservicebus.MigrationConfigsClientDeleteOptions) (resp azfake.Responder[armservicebus.MigrationConfigsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method MigrationConfigsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, namespaceName string, configName armservicebus.MigrationConfigurationName, options *armservicebus.MigrationConfigsClientGetOptions) (resp azfake.Responder[armservicebus.MigrationConfigsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method MigrationConfigsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, namespaceName string, options *armservicebus.MigrationConfigsClientListOptions) (resp azfake.PagerResponder[armservicebus.MigrationConfigsClientListResponse])

	// Revert is the fake for method MigrationConfigsClient.Revert
	// HTTP status codes to indicate success: http.StatusOK
	Revert func(ctx context.Context, resourceGroupName string, namespaceName string, configName armservicebus.MigrationConfigurationName, options *armservicebus.MigrationConfigsClientRevertOptions) (resp azfake.Responder[armservicebus.MigrationConfigsClientRevertResponse], errResp azfake.ErrorResponder)
}

// NewMigrationConfigsServerTransport creates a new instance of MigrationConfigsServerTransport with the provided implementation.
// The returned MigrationConfigsServerTransport instance is connected to an instance of armservicebus.MigrationConfigsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMigrationConfigsServerTransport(srv *MigrationConfigsServer) *MigrationConfigsServerTransport {
	return &MigrationConfigsServerTransport{
		srv:                          srv,
		beginCreateAndStartMigration: newTracker[azfake.PollerResponder[armservicebus.MigrationConfigsClientCreateAndStartMigrationResponse]](),
		newListPager:                 newTracker[azfake.PagerResponder[armservicebus.MigrationConfigsClientListResponse]](),
	}
}

// MigrationConfigsServerTransport connects instances of armservicebus.MigrationConfigsClient to instances of MigrationConfigsServer.
// Don't use this type directly, use NewMigrationConfigsServerTransport instead.
type MigrationConfigsServerTransport struct {
	srv                          *MigrationConfigsServer
	beginCreateAndStartMigration *tracker[azfake.PollerResponder[armservicebus.MigrationConfigsClientCreateAndStartMigrationResponse]]
	newListPager                 *tracker[azfake.PagerResponder[armservicebus.MigrationConfigsClientListResponse]]
}

// Do implements the policy.Transporter interface for MigrationConfigsServerTransport.
func (m *MigrationConfigsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MigrationConfigsClient.CompleteMigration":
		resp, err = m.dispatchCompleteMigration(req)
	case "MigrationConfigsClient.BeginCreateAndStartMigration":
		resp, err = m.dispatchBeginCreateAndStartMigration(req)
	case "MigrationConfigsClient.Delete":
		resp, err = m.dispatchDelete(req)
	case "MigrationConfigsClient.Get":
		resp, err = m.dispatchGet(req)
	case "MigrationConfigsClient.NewListPager":
		resp, err = m.dispatchNewListPager(req)
	case "MigrationConfigsClient.Revert":
		resp, err = m.dispatchRevert(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MigrationConfigsServerTransport) dispatchCompleteMigration(req *http.Request) (*http.Response, error) {
	if m.srv.CompleteMigration == nil {
		return nil, &nonRetriableError{errors.New("fake for method CompleteMigration not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceBus/namespaces/(?P<namespaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/migrationConfigurations/(?P<configName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/upgrade`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	namespaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("namespaceName")])
	if err != nil {
		return nil, err
	}
	configNameParam, err := parseWithCast(matches[regex.SubexpIndex("configName")], func(v string) (armservicebus.MigrationConfigurationName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armservicebus.MigrationConfigurationName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.CompleteMigration(req.Context(), resourceGroupNameParam, namespaceNameParam, configNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MigrationConfigsServerTransport) dispatchBeginCreateAndStartMigration(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCreateAndStartMigration == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateAndStartMigration not implemented")}
	}
	beginCreateAndStartMigration := m.beginCreateAndStartMigration.get(req)
	if beginCreateAndStartMigration == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceBus/namespaces/(?P<namespaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/migrationConfigurations/(?P<configName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armservicebus.MigrationConfigProperties](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		namespaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("namespaceName")])
		if err != nil {
			return nil, err
		}
		configNameParam, err := parseWithCast(matches[regex.SubexpIndex("configName")], func(v string) (armservicebus.MigrationConfigurationName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armservicebus.MigrationConfigurationName(p), nil
		})
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginCreateAndStartMigration(req.Context(), resourceGroupNameParam, namespaceNameParam, configNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateAndStartMigration = &respr
		m.beginCreateAndStartMigration.add(req, beginCreateAndStartMigration)
	}

	resp, err := server.PollerResponderNext(beginCreateAndStartMigration, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		m.beginCreateAndStartMigration.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateAndStartMigration) {
		m.beginCreateAndStartMigration.remove(req)
	}

	return resp, nil
}

func (m *MigrationConfigsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if m.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceBus/namespaces/(?P<namespaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/migrationConfigurations/(?P<configName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	namespaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("namespaceName")])
	if err != nil {
		return nil, err
	}
	configNameParam, err := parseWithCast(matches[regex.SubexpIndex("configName")], func(v string) (armservicebus.MigrationConfigurationName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armservicebus.MigrationConfigurationName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Delete(req.Context(), resourceGroupNameParam, namespaceNameParam, configNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MigrationConfigsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceBus/namespaces/(?P<namespaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/migrationConfigurations/(?P<configName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	namespaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("namespaceName")])
	if err != nil {
		return nil, err
	}
	configNameParam, err := parseWithCast(matches[regex.SubexpIndex("configName")], func(v string) (armservicebus.MigrationConfigurationName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armservicebus.MigrationConfigurationName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), resourceGroupNameParam, namespaceNameParam, configNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MigrationConfigProperties, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MigrationConfigsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := m.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceBus/namespaces/(?P<namespaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/migrationConfigurations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		namespaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("namespaceName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListPager(resourceGroupNameParam, namespaceNameParam, nil)
		newListPager = &resp
		m.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armservicebus.MigrationConfigsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		m.newListPager.remove(req)
	}
	return resp, nil
}

func (m *MigrationConfigsServerTransport) dispatchRevert(req *http.Request) (*http.Response, error) {
	if m.srv.Revert == nil {
		return nil, &nonRetriableError{errors.New("fake for method Revert not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceBus/namespaces/(?P<namespaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/migrationConfigurations/(?P<configName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/revert`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	namespaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("namespaceName")])
	if err != nil {
		return nil, err
	}
	configNameParam, err := parseWithCast(matches[regex.SubexpIndex("configName")], func(v string) (armservicebus.MigrationConfigurationName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armservicebus.MigrationConfigurationName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Revert(req.Context(), resourceGroupNameParam, namespaceNameParam, configNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
