//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armselfhelp

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AutomatedCheckResult.
func (a AutomatedCheckResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "result", a.Result)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "type", a.Type)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomatedCheckResult.
func (a *AutomatedCheckResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "result":
			err = unpopulate(val, "Result", &a.Result)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityRequest.
func (c CheckNameAvailabilityRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityRequest.
func (c *CheckNameAvailabilityRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityResponse.
func (c CheckNameAvailabilityResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "nameAvailable", c.NameAvailable)
	populate(objectMap, "reason", c.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityResponse.
func (c *CheckNameAvailabilityResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "nameAvailable":
			err = unpopulate(val, "NameAvailable", &c.NameAvailable)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &c.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClassificationService.
func (c ClassificationService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", c.DisplayName)
	populate(objectMap, "resourceTypes", c.ResourceTypes)
	populate(objectMap, "serviceId", c.ServiceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClassificationService.
func (c *ClassificationService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &c.DisplayName)
			delete(rawMsg, key)
		case "resourceTypes":
			err = unpopulate(val, "ResourceTypes", &c.ResourceTypes)
			delete(rawMsg, key)
		case "serviceId":
			err = unpopulate(val, "ServiceID", &c.ServiceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContinueRequestBody.
func (c ContinueRequestBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "responses", c.Responses)
	populate(objectMap, "stepId", c.StepID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContinueRequestBody.
func (c *ContinueRequestBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "responses":
			err = unpopulate(val, "Responses", &c.Responses)
			delete(rawMsg, key)
		case "stepId":
			err = unpopulate(val, "StepID", &c.StepID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Diagnostic.
func (d Diagnostic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", d.Error)
	populate(objectMap, "insights", d.Insights)
	populate(objectMap, "solutionId", d.SolutionID)
	populate(objectMap, "status", d.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Diagnostic.
func (d *Diagnostic) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &d.Error)
			delete(rawMsg, key)
		case "insights":
			err = unpopulate(val, "Insights", &d.Insights)
			delete(rawMsg, key)
		case "solutionId":
			err = unpopulate(val, "SolutionID", &d.SolutionID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticInvocation.
func (d DiagnosticInvocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalParameters", d.AdditionalParameters)
	populate(objectMap, "solutionId", d.SolutionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticInvocation.
func (d *DiagnosticInvocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalParameters":
			err = unpopulate(val, "AdditionalParameters", &d.AdditionalParameters)
			delete(rawMsg, key)
		case "solutionId":
			err = unpopulate(val, "SolutionID", &d.SolutionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticResource.
func (d DiagnosticResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticResource.
func (d *DiagnosticResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticResourceProperties.
func (d DiagnosticResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "acceptedAt", d.AcceptedAt)
	populate(objectMap, "diagnostics", d.Diagnostics)
	populate(objectMap, "globalParameters", d.GlobalParameters)
	populate(objectMap, "insights", d.Insights)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticResourceProperties.
func (d *DiagnosticResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "acceptedAt":
			err = unpopulate(val, "AcceptedAt", &d.AcceptedAt)
			delete(rawMsg, key)
		case "diagnostics":
			err = unpopulate(val, "Diagnostics", &d.Diagnostics)
			delete(rawMsg, key)
		case "globalParameters":
			err = unpopulate(val, "GlobalParameters", &d.GlobalParameters)
			delete(rawMsg, key)
		case "insights":
			err = unpopulate(val, "Insights", &d.Insights)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiscoveryNlpRequest.
func (d DiscoveryNlpRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalContext", d.AdditionalContext)
	populate(objectMap, "issueSummary", d.IssueSummary)
	populate(objectMap, "resourceId", d.ResourceID)
	populate(objectMap, "serviceId", d.ServiceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiscoveryNlpRequest.
func (d *DiscoveryNlpRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalContext":
			err = unpopulate(val, "AdditionalContext", &d.AdditionalContext)
			delete(rawMsg, key)
		case "issueSummary":
			err = unpopulate(val, "IssueSummary", &d.IssueSummary)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &d.ResourceID)
			delete(rawMsg, key)
		case "serviceId":
			err = unpopulate(val, "ServiceID", &d.ServiceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiscoveryNlpResponse.
func (d DiscoveryNlpResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiscoveryNlpResponse.
func (d *DiscoveryNlpResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiscoveryResponse.
func (d DiscoveryResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiscoveryResponse.
func (d *DiscoveryResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Error.
func (e Error) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Error.
func (e *Error) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorAdditionalInfo.
func (e ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "info", e.Info)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorAdditionalInfo.
func (e *ErrorAdditionalInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "info":
			err = unpopulate(val, "Info", &e.Info)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetail.
func (e ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetail.
func (e *ErrorDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &e.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Filter.
func (f Filter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "operator", f.Operator)
	populate(objectMap, "values", f.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Filter.
func (f *Filter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &f.Operator)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &f.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FilterGroup.
func (f FilterGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "filter", f.Filter)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FilterGroup.
func (f *FilterGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filter":
			err = unpopulate(val, "Filter", &f.Filter)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Insight.
func (i Insight) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "importanceLevel", i.ImportanceLevel)
	populate(objectMap, "results", i.Results)
	populate(objectMap, "title", i.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Insight.
func (i *Insight) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "importanceLevel":
			err = unpopulate(val, "ImportanceLevel", &i.ImportanceLevel)
			delete(rawMsg, key)
		case "results":
			err = unpopulate(val, "Results", &i.Results)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &i.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricsBasedChart.
func (m MetricsBasedChart) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregationType", m.AggregationType)
	populate(objectMap, "filterGroup", m.FilterGroup)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "replacementKey", m.ReplacementKey)
	populate(objectMap, "timeSpanDuration", m.TimeSpanDuration)
	populate(objectMap, "title", m.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricsBasedChart.
func (m *MetricsBasedChart) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregationType":
			err = unpopulate(val, "AggregationType", &m.AggregationType)
			delete(rawMsg, key)
		case "filterGroup":
			err = unpopulate(val, "FilterGroup", &m.FilterGroup)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "replacementKey":
			err = unpopulate(val, "ReplacementKey", &m.ReplacementKey)
			delete(rawMsg, key)
		case "timeSpanDuration":
			err = unpopulate(val, "TimeSpanDuration", &m.TimeSpanDuration)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &m.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NlpSolutions.
func (n NlpSolutions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "problemClassificationId", n.ProblemClassificationID)
	populate(objectMap, "problemDescription", n.ProblemDescription)
	populate(objectMap, "problemTitle", n.ProblemTitle)
	populate(objectMap, "relatedServices", n.RelatedServices)
	populate(objectMap, "serviceId", n.ServiceID)
	populate(objectMap, "solutions", n.Solutions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NlpSolutions.
func (n *NlpSolutions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "problemClassificationId":
			err = unpopulate(val, "ProblemClassificationID", &n.ProblemClassificationID)
			delete(rawMsg, key)
		case "problemDescription":
			err = unpopulate(val, "ProblemDescription", &n.ProblemDescription)
			delete(rawMsg, key)
		case "problemTitle":
			err = unpopulate(val, "ProblemTitle", &n.ProblemTitle)
			delete(rawMsg, key)
		case "relatedServices":
			err = unpopulate(val, "RelatedServices", &n.RelatedServices)
			delete(rawMsg, key)
		case "serviceId":
			err = unpopulate(val, "ServiceID", &n.ServiceID)
			delete(rawMsg, key)
		case "solutions":
			err = unpopulate(val, "Solutions", &n.Solutions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionType", o.ActionType)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &o.ActionType)
			delete(rawMsg, key)
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplacementMaps.
func (r ReplacementMaps) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diagnostics", r.Diagnostics)
	populate(objectMap, "metricsBasedCharts", r.MetricsBasedCharts)
	populate(objectMap, "troubleshooters", r.Troubleshooters)
	populate(objectMap, "videoGroups", r.VideoGroups)
	populate(objectMap, "videos", r.Videos)
	populate(objectMap, "webResults", r.WebResults)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplacementMaps.
func (r *ReplacementMaps) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diagnostics":
			err = unpopulate(val, "Diagnostics", &r.Diagnostics)
			delete(rawMsg, key)
		case "metricsBasedCharts":
			err = unpopulate(val, "MetricsBasedCharts", &r.MetricsBasedCharts)
			delete(rawMsg, key)
		case "troubleshooters":
			err = unpopulate(val, "Troubleshooters", &r.Troubleshooters)
			delete(rawMsg, key)
		case "videoGroups":
			err = unpopulate(val, "VideoGroups", &r.VideoGroups)
			delete(rawMsg, key)
		case "videos":
			err = unpopulate(val, "Videos", &r.Videos)
			delete(rawMsg, key)
		case "webResults":
			err = unpopulate(val, "WebResults", &r.WebResults)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplacementMapsSelfHelp.
func (r ReplacementMapsSelfHelp) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "videoGroups", r.VideoGroups)
	populate(objectMap, "videos", r.Videos)
	populate(objectMap, "webResults", r.WebResults)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplacementMapsSelfHelp.
func (r *ReplacementMapsSelfHelp) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "videoGroups":
			err = unpopulate(val, "VideoGroups", &r.VideoGroups)
			delete(rawMsg, key)
		case "videos":
			err = unpopulate(val, "Videos", &r.Videos)
			delete(rawMsg, key)
		case "webResults":
			err = unpopulate(val, "WebResults", &r.WebResults)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResponseOption.
func (r ResponseOption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "key", r.Key)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResponseOption.
func (r *ResponseOption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &r.Key)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResponseValidationProperties.
func (r ResponseValidationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isRequired", r.IsRequired)
	populate(objectMap, "maxLength", r.MaxLength)
	populate(objectMap, "regex", r.Regex)
	populate(objectMap, "validationErrorMessage", r.ValidationErrorMessage)
	populate(objectMap, "validationScope", r.ValidationScope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResponseValidationProperties.
func (r *ResponseValidationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isRequired":
			err = unpopulate(val, "IsRequired", &r.IsRequired)
			delete(rawMsg, key)
		case "maxLength":
			err = unpopulate(val, "MaxLength", &r.MaxLength)
			delete(rawMsg, key)
		case "regex":
			err = unpopulate(val, "Regex", &r.Regex)
			delete(rawMsg, key)
		case "validationErrorMessage":
			err = unpopulate(val, "ValidationErrorMessage", &r.ValidationErrorMessage)
			delete(rawMsg, key)
		case "validationScope":
			err = unpopulate(val, "ValidationScope", &r.ValidationScope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestartTroubleshooterResponse.
func (r RestartTroubleshooterResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "troubleshooterResourceName", r.TroubleshooterResourceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestartTroubleshooterResponse.
func (r *RestartTroubleshooterResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "troubleshooterResourceName":
			err = unpopulate(val, "TroubleshooterResourceName", &r.TroubleshooterResourceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SearchResult.
func (s SearchResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "confidence", s.Confidence)
	populate(objectMap, "content", s.Content)
	populate(objectMap, "link", s.Link)
	populate(objectMap, "rank", s.Rank)
	populate(objectMap, "resultType", s.ResultType)
	populate(objectMap, "solutionId", s.SolutionID)
	populate(objectMap, "source", s.Source)
	populate(objectMap, "title", s.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SearchResult.
func (s *SearchResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "confidence":
			err = unpopulate(val, "Confidence", &s.Confidence)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &s.Content)
			delete(rawMsg, key)
		case "link":
			err = unpopulate(val, "Link", &s.Link)
			delete(rawMsg, key)
		case "rank":
			err = unpopulate(val, "Rank", &s.Rank)
			delete(rawMsg, key)
		case "resultType":
			err = unpopulate(val, "ResultType", &s.ResultType)
			delete(rawMsg, key)
		case "solutionId":
			err = unpopulate(val, "SolutionID", &s.SolutionID)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &s.Source)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &s.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Section.
func (s Section) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", s.Content)
	populate(objectMap, "replacementMaps", s.ReplacementMaps)
	populate(objectMap, "title", s.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Section.
func (s *Section) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &s.Content)
			delete(rawMsg, key)
		case "replacementMaps":
			err = unpopulate(val, "ReplacementMaps", &s.ReplacementMaps)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &s.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SectionSelfHelp.
func (s SectionSelfHelp) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", s.Content)
	populate(objectMap, "replacementMaps", s.ReplacementMaps)
	populate(objectMap, "title", s.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SectionSelfHelp.
func (s *SectionSelfHelp) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &s.Content)
			delete(rawMsg, key)
		case "replacementMaps":
			err = unpopulate(val, "ReplacementMaps", &s.ReplacementMaps)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &s.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SimplifiedSolutionsResource.
func (s SimplifiedSolutionsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SimplifiedSolutionsResource.
func (s *SimplifiedSolutionsResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SimplifiedSolutionsResourceProperties.
func (s SimplifiedSolutionsResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appendix", s.Appendix)
	populate(objectMap, "content", s.Content)
	populate(objectMap, "parameters", s.Parameters)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "solutionId", s.SolutionID)
	populate(objectMap, "title", s.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SimplifiedSolutionsResourceProperties.
func (s *SimplifiedSolutionsResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appendix":
			err = unpopulate(val, "Appendix", &s.Appendix)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &s.Content)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &s.Parameters)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "solutionId":
			err = unpopulate(val, "SolutionID", &s.SolutionID)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &s.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SolutionMetadataProperties.
func (s SolutionMetadataProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "requiredInputs", s.RequiredInputs)
	populate(objectMap, "solutionId", s.SolutionID)
	populate(objectMap, "solutionType", s.SolutionType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SolutionMetadataProperties.
func (s *SolutionMetadataProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "requiredInputs":
			err = unpopulate(val, "RequiredInputs", &s.RequiredInputs)
			delete(rawMsg, key)
		case "solutionId":
			err = unpopulate(val, "SolutionID", &s.SolutionID)
			delete(rawMsg, key)
		case "solutionType":
			err = unpopulate(val, "SolutionType", &s.SolutionType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SolutionMetadataResource.
func (s SolutionMetadataResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SolutionMetadataResource.
func (s *SolutionMetadataResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SolutionNlpMetadataResource.
func (s SolutionNlpMetadataResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SolutionNlpMetadataResource.
func (s *SolutionNlpMetadataResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SolutionPatchRequestBody.
func (s SolutionPatchRequestBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SolutionPatchRequestBody.
func (s *SolutionPatchRequestBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SolutionResource.
func (s SolutionResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SolutionResource.
func (s *SolutionResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SolutionResourceProperties.
func (s SolutionResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", s.Content)
	populate(objectMap, "parameters", s.Parameters)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "replacementMaps", s.ReplacementMaps)
	populate(objectMap, "sections", s.Sections)
	populate(objectMap, "solutionId", s.SolutionID)
	populate(objectMap, "title", s.Title)
	populate(objectMap, "triggerCriteria", s.TriggerCriteria)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SolutionResourceProperties.
func (s *SolutionResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &s.Content)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &s.Parameters)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "replacementMaps":
			err = unpopulate(val, "ReplacementMaps", &s.ReplacementMaps)
			delete(rawMsg, key)
		case "sections":
			err = unpopulate(val, "Sections", &s.Sections)
			delete(rawMsg, key)
		case "solutionId":
			err = unpopulate(val, "SolutionID", &s.SolutionID)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &s.Title)
			delete(rawMsg, key)
		case "triggerCriteria":
			err = unpopulate(val, "TriggerCriteria", &s.TriggerCriteria)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SolutionResourceSelfHelp.
func (s SolutionResourceSelfHelp) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SolutionResourceSelfHelp.
func (s *SolutionResourceSelfHelp) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SolutionWarmUpRequestBody.
func (s SolutionWarmUpRequestBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "parameters", s.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SolutionWarmUpRequestBody.
func (s *SolutionWarmUpRequestBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "parameters":
			err = unpopulate(val, "Parameters", &s.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Solutions.
func (s Solutions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "solutions", s.Solutions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Solutions.
func (s *Solutions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "solutions":
			err = unpopulate(val, "Solutions", &s.Solutions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SolutionsDiagnostic.
func (s SolutionsDiagnostic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "estimatedCompletionTime", s.EstimatedCompletionTime)
	populate(objectMap, "insights", s.Insights)
	populate(objectMap, "replacementKey", s.ReplacementKey)
	populate(objectMap, "requiredParameters", s.RequiredParameters)
	populate(objectMap, "solutionId", s.SolutionID)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "statusDetails", s.StatusDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SolutionsDiagnostic.
func (s *SolutionsDiagnostic) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "estimatedCompletionTime":
			err = unpopulate(val, "EstimatedCompletionTime", &s.EstimatedCompletionTime)
			delete(rawMsg, key)
		case "insights":
			err = unpopulate(val, "Insights", &s.Insights)
			delete(rawMsg, key)
		case "replacementKey":
			err = unpopulate(val, "ReplacementKey", &s.ReplacementKey)
			delete(rawMsg, key)
		case "requiredParameters":
			err = unpopulate(val, "RequiredParameters", &s.RequiredParameters)
			delete(rawMsg, key)
		case "solutionId":
			err = unpopulate(val, "SolutionID", &s.SolutionID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "statusDetails":
			err = unpopulate(val, "StatusDetails", &s.StatusDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SolutionsResourcePropertiesSelfHelp.
func (s SolutionsResourcePropertiesSelfHelp) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", s.Content)
	populate(objectMap, "replacementMaps", s.ReplacementMaps)
	populate(objectMap, "sections", s.Sections)
	populate(objectMap, "solutionId", s.SolutionID)
	populate(objectMap, "title", s.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SolutionsResourcePropertiesSelfHelp.
func (s *SolutionsResourcePropertiesSelfHelp) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &s.Content)
			delete(rawMsg, key)
		case "replacementMaps":
			err = unpopulate(val, "ReplacementMaps", &s.ReplacementMaps)
			delete(rawMsg, key)
		case "sections":
			err = unpopulate(val, "Sections", &s.Sections)
			delete(rawMsg, key)
		case "solutionId":
			err = unpopulate(val, "SolutionID", &s.SolutionID)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &s.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SolutionsTroubleshooters.
func (s SolutionsTroubleshooters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "solutionId", s.SolutionID)
	populate(objectMap, "summary", s.Summary)
	populate(objectMap, "title", s.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SolutionsTroubleshooters.
func (s *SolutionsTroubleshooters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "solutionId":
			err = unpopulate(val, "SolutionID", &s.SolutionID)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &s.Summary)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &s.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Step.
func (s Step) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "automatedCheckResults", s.AutomatedCheckResults)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "error", s.Error)
	populate(objectMap, "executionStatus", s.ExecutionStatus)
	populate(objectMap, "executionStatusDescription", s.ExecutionStatusDescription)
	populate(objectMap, "guidance", s.Guidance)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "inputs", s.Inputs)
	populate(objectMap, "insights", s.Insights)
	populate(objectMap, "isLastStep", s.IsLastStep)
	populate(objectMap, "title", s.Title)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Step.
func (s *Step) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "automatedCheckResults":
			err = unpopulate(val, "AutomatedCheckResults", &s.AutomatedCheckResults)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &s.Error)
			delete(rawMsg, key)
		case "executionStatus":
			err = unpopulate(val, "ExecutionStatus", &s.ExecutionStatus)
			delete(rawMsg, key)
		case "executionStatusDescription":
			err = unpopulate(val, "ExecutionStatusDescription", &s.ExecutionStatusDescription)
			delete(rawMsg, key)
		case "guidance":
			err = unpopulate(val, "Guidance", &s.Guidance)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "inputs":
			err = unpopulate(val, "Inputs", &s.Inputs)
			delete(rawMsg, key)
		case "insights":
			err = unpopulate(val, "Insights", &s.Insights)
			delete(rawMsg, key)
		case "isLastStep":
			err = unpopulate(val, "IsLastStep", &s.IsLastStep)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &s.Title)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StepInput.
func (s StepInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "questionContent", s.QuestionContent)
	populate(objectMap, "questionContentType", s.QuestionContentType)
	populate(objectMap, "questionId", s.QuestionID)
	populate(objectMap, "questionTitle", s.QuestionTitle)
	populate(objectMap, "questionType", s.QuestionType)
	populate(objectMap, "recommendedOption", s.RecommendedOption)
	populate(objectMap, "responseHint", s.ResponseHint)
	populate(objectMap, "responseOptions", s.ResponseOptions)
	populate(objectMap, "responseValidationProperties", s.ResponseValidationProperties)
	populate(objectMap, "selectedOptionValue", s.SelectedOptionValue)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StepInput.
func (s *StepInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "questionContent":
			err = unpopulate(val, "QuestionContent", &s.QuestionContent)
			delete(rawMsg, key)
		case "questionContentType":
			err = unpopulate(val, "QuestionContentType", &s.QuestionContentType)
			delete(rawMsg, key)
		case "questionId":
			err = unpopulate(val, "QuestionID", &s.QuestionID)
			delete(rawMsg, key)
		case "questionTitle":
			err = unpopulate(val, "QuestionTitle", &s.QuestionTitle)
			delete(rawMsg, key)
		case "questionType":
			err = unpopulate(val, "QuestionType", &s.QuestionType)
			delete(rawMsg, key)
		case "recommendedOption":
			err = unpopulate(val, "RecommendedOption", &s.RecommendedOption)
			delete(rawMsg, key)
		case "responseHint":
			err = unpopulate(val, "ResponseHint", &s.ResponseHint)
			delete(rawMsg, key)
		case "responseOptions":
			err = unpopulate(val, "ResponseOptions", &s.ResponseOptions)
			delete(rawMsg, key)
		case "responseValidationProperties":
			err = unpopulate(val, "ResponseValidationProperties", &s.ResponseValidationProperties)
			delete(rawMsg, key)
		case "selectedOptionValue":
			err = unpopulate(val, "SelectedOptionValue", &s.SelectedOptionValue)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TriggerCriterion.
func (t TriggerCriterion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TriggerCriterion.
func (t *TriggerCriterion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TroubleshooterInstanceProperties.
func (t TroubleshooterInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "parameters", t.Parameters)
	populate(objectMap, "provisioningState", t.ProvisioningState)
	populate(objectMap, "solutionId", t.SolutionID)
	populate(objectMap, "steps", t.Steps)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TroubleshooterInstanceProperties.
func (t *TroubleshooterInstanceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "parameters":
			err = unpopulate(val, "Parameters", &t.Parameters)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &t.ProvisioningState)
			delete(rawMsg, key)
		case "solutionId":
			err = unpopulate(val, "SolutionID", &t.SolutionID)
			delete(rawMsg, key)
		case "steps":
			err = unpopulate(val, "Steps", &t.Steps)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TroubleshooterResource.
func (t TroubleshooterResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TroubleshooterResource.
func (t *TroubleshooterResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &t.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TroubleshooterResponse.
func (t TroubleshooterResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "questionId", t.QuestionID)
	populate(objectMap, "questionType", t.QuestionType)
	populate(objectMap, "response", t.Response)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TroubleshooterResponse.
func (t *TroubleshooterResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "questionId":
			err = unpopulate(val, "QuestionID", &t.QuestionID)
			delete(rawMsg, key)
		case "questionType":
			err = unpopulate(val, "QuestionType", &t.QuestionType)
			delete(rawMsg, key)
		case "response":
			err = unpopulate(val, "Response", &t.Response)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Video.
func (v Video) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "replacementKey", v.ReplacementKey)
	populate(objectMap, "src", v.Src)
	populate(objectMap, "title", v.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Video.
func (v *Video) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "replacementKey":
			err = unpopulate(val, "ReplacementKey", &v.ReplacementKey)
			delete(rawMsg, key)
		case "src":
			err = unpopulate(val, "Src", &v.Src)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &v.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VideoGroup.
func (v VideoGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "replacementKey", v.ReplacementKey)
	populate(objectMap, "videos", v.Videos)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VideoGroup.
func (v *VideoGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "replacementKey":
			err = unpopulate(val, "ReplacementKey", &v.ReplacementKey)
			delete(rawMsg, key)
		case "videos":
			err = unpopulate(val, "Videos", &v.Videos)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VideoGroupVideo.
func (v VideoGroupVideo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "src", v.Src)
	populate(objectMap, "title", v.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VideoGroupVideo.
func (v *VideoGroupVideo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "src":
			err = unpopulate(val, "Src", &v.Src)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &v.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebResult.
func (w WebResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "replacementKey", w.ReplacementKey)
	populate(objectMap, "searchResults", w.SearchResults)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebResult.
func (w *WebResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "replacementKey":
			err = unpopulate(val, "ReplacementKey", &w.ReplacementKey)
			delete(rawMsg, key)
		case "searchResults":
			err = unpopulate(val, "SearchResults", &w.SearchResults)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil || string(data) == "null" {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
