//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armselfhelp

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// DiscoverySolutionNLPSubscriptionScopeClient contains the methods for the DiscoverySolutionNLPSubscriptionScope group.
// Don't use this type directly, use NewDiscoverySolutionNLPSubscriptionScopeClient() instead.
type DiscoverySolutionNLPSubscriptionScopeClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewDiscoverySolutionNLPSubscriptionScopeClient creates a new instance of DiscoverySolutionNLPSubscriptionScopeClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewDiscoverySolutionNLPSubscriptionScopeClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*DiscoverySolutionNLPSubscriptionScopeClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &DiscoverySolutionNLPSubscriptionScopeClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Post - Search for relevant Azure Diagnostics, Solutions and Troubleshooters using a natural language issue summary and
// subscription.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-03-01-preview
//   - options - DiscoverySolutionNLPSubscriptionScopeClientPostOptions contains the optional parameters for the DiscoverySolutionNLPSubscriptionScopeClient.Post
//     method.
func (client *DiscoverySolutionNLPSubscriptionScopeClient) Post(ctx context.Context, options *DiscoverySolutionNLPSubscriptionScopeClientPostOptions) (DiscoverySolutionNLPSubscriptionScopeClientPostResponse, error) {
	var err error
	const operationName = "DiscoverySolutionNLPSubscriptionScopeClient.Post"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.postCreateRequest(ctx, options)
	if err != nil {
		return DiscoverySolutionNLPSubscriptionScopeClientPostResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DiscoverySolutionNLPSubscriptionScopeClientPostResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DiscoverySolutionNLPSubscriptionScopeClientPostResponse{}, err
	}
	resp, err := client.postHandleResponse(httpResp)
	return resp, err
}

// postCreateRequest creates the Post request.
func (client *DiscoverySolutionNLPSubscriptionScopeClient) postCreateRequest(ctx context.Context, options *DiscoverySolutionNLPSubscriptionScopeClientPostOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Help/discoverSolutions"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-03-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.DiscoverSolutionRequest != nil {
		if err := runtime.MarshalAsJSON(req, *options.DiscoverSolutionRequest); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// postHandleResponse handles the Post response.
func (client *DiscoverySolutionNLPSubscriptionScopeClient) postHandleResponse(resp *http.Response) (DiscoverySolutionNLPSubscriptionScopeClientPostResponse, error) {
	result := DiscoverySolutionNLPSubscriptionScopeClientPostResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DiscoveryNlpResponse); err != nil {
		return DiscoverySolutionNLPSubscriptionScopeClientPostResponse{}, err
	}
	return result, nil
}
