//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/securitydevops/armsecuritydevops"
	"net/http"
	"net/url"
	"regexp"
)

// AzureDevOpsConnectorStatsServer is a fake server for instances of the armsecuritydevops.AzureDevOpsConnectorStatsClient type.
type AzureDevOpsConnectorStatsServer struct {
	// Get is the fake for method AzureDevOpsConnectorStatsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, azureDevOpsConnectorName string, options *armsecuritydevops.AzureDevOpsConnectorStatsClientGetOptions) (resp azfake.Responder[armsecuritydevops.AzureDevOpsConnectorStatsClientGetResponse], errResp azfake.ErrorResponder)
}

// NewAzureDevOpsConnectorStatsServerTransport creates a new instance of AzureDevOpsConnectorStatsServerTransport with the provided implementation.
// The returned AzureDevOpsConnectorStatsServerTransport instance is connected to an instance of armsecuritydevops.AzureDevOpsConnectorStatsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAzureDevOpsConnectorStatsServerTransport(srv *AzureDevOpsConnectorStatsServer) *AzureDevOpsConnectorStatsServerTransport {
	return &AzureDevOpsConnectorStatsServerTransport{srv: srv}
}

// AzureDevOpsConnectorStatsServerTransport connects instances of armsecuritydevops.AzureDevOpsConnectorStatsClient to instances of AzureDevOpsConnectorStatsServer.
// Don't use this type directly, use NewAzureDevOpsConnectorStatsServerTransport instead.
type AzureDevOpsConnectorStatsServerTransport struct {
	srv *AzureDevOpsConnectorStatsServer
}

// Do implements the policy.Transporter interface for AzureDevOpsConnectorStatsServerTransport.
func (a *AzureDevOpsConnectorStatsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AzureDevOpsConnectorStatsClient.Get":
		resp, err = a.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AzureDevOpsConnectorStatsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityDevOps/azureDevOpsConnectors/(?P<azureDevOpsConnectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stats`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	azureDevOpsConnectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureDevOpsConnectorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), resourceGroupNameParam, azureDevOpsConnectorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AzureDevOpsConnectorStatsListResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
