//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// InformationProtectionPoliciesServer is a fake server for instances of the armsecurity.InformationProtectionPoliciesClient type.
type InformationProtectionPoliciesServer struct {
	// CreateOrUpdate is the fake for method InformationProtectionPoliciesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, scope string, informationProtectionPolicyName armsecurity.InformationProtectionPolicyName, informationProtectionPolicy armsecurity.InformationProtectionPolicy, options *armsecurity.InformationProtectionPoliciesClientCreateOrUpdateOptions) (resp azfake.Responder[armsecurity.InformationProtectionPoliciesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method InformationProtectionPoliciesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, scope string, informationProtectionPolicyName armsecurity.InformationProtectionPolicyName, options *armsecurity.InformationProtectionPoliciesClientGetOptions) (resp azfake.Responder[armsecurity.InformationProtectionPoliciesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method InformationProtectionPoliciesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(scope string, options *armsecurity.InformationProtectionPoliciesClientListOptions) (resp azfake.PagerResponder[armsecurity.InformationProtectionPoliciesClientListResponse])
}

// NewInformationProtectionPoliciesServerTransport creates a new instance of InformationProtectionPoliciesServerTransport with the provided implementation.
// The returned InformationProtectionPoliciesServerTransport instance is connected to an instance of armsecurity.InformationProtectionPoliciesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewInformationProtectionPoliciesServerTransport(srv *InformationProtectionPoliciesServer) *InformationProtectionPoliciesServerTransport {
	return &InformationProtectionPoliciesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armsecurity.InformationProtectionPoliciesClientListResponse]](),
	}
}

// InformationProtectionPoliciesServerTransport connects instances of armsecurity.InformationProtectionPoliciesClient to instances of InformationProtectionPoliciesServer.
// Don't use this type directly, use NewInformationProtectionPoliciesServerTransport instead.
type InformationProtectionPoliciesServerTransport struct {
	srv          *InformationProtectionPoliciesServer
	newListPager *tracker[azfake.PagerResponder[armsecurity.InformationProtectionPoliciesClientListResponse]]
}

// Do implements the policy.Transporter interface for InformationProtectionPoliciesServerTransport.
func (i *InformationProtectionPoliciesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "InformationProtectionPoliciesClient.CreateOrUpdate":
		resp, err = i.dispatchCreateOrUpdate(req)
	case "InformationProtectionPoliciesClient.Get":
		resp, err = i.dispatchGet(req)
	case "InformationProtectionPoliciesClient.NewListPager":
		resp, err = i.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *InformationProtectionPoliciesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if i.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/informationProtectionPolicies/(?P<informationProtectionPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsecurity.InformationProtectionPolicy](req)
	if err != nil {
		return nil, err
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	informationProtectionPolicyNameParam, err := parseWithCast(matches[regex.SubexpIndex("informationProtectionPolicyName")], func(v string) (armsecurity.InformationProtectionPolicyName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsecurity.InformationProtectionPolicyName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.CreateOrUpdate(req.Context(), scopeParam, informationProtectionPolicyNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).InformationProtectionPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *InformationProtectionPoliciesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if i.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/informationProtectionPolicies/(?P<informationProtectionPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	informationProtectionPolicyNameParam, err := parseWithCast(matches[regex.SubexpIndex("informationProtectionPolicyName")], func(v string) (armsecurity.InformationProtectionPolicyName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsecurity.InformationProtectionPolicyName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Get(req.Context(), scopeParam, informationProtectionPolicyNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).InformationProtectionPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *InformationProtectionPoliciesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := i.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/informationProtectionPolicies`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		resp := i.srv.NewListPager(scopeParam, nil)
		newListPager = &resp
		i.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsecurity.InformationProtectionPoliciesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		i.newListPager.remove(req)
	}
	return resp, nil
}
