//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurity

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// AzureDevOpsProjectsClient contains the methods for the AzureDevOpsProjects group.
// Don't use this type directly, use NewAzureDevOpsProjectsClient() instead.
type AzureDevOpsProjectsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewAzureDevOpsProjectsClient creates a new instance of AzureDevOpsProjectsClient with the specified values.
//   - subscriptionID - Azure subscription ID
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewAzureDevOpsProjectsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*AzureDevOpsProjectsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &AzureDevOpsProjectsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Creates or updates a monitored Azure DevOps project resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - securityConnectorName - The security connector name.
//   - orgName - The Azure DevOps organization name.
//   - projectName - The project name.
//   - azureDevOpsProject - The Azure DevOps project resource payload.
//   - options - AzureDevOpsProjectsClientBeginCreateOrUpdateOptions contains the optional parameters for the AzureDevOpsProjectsClient.BeginCreateOrUpdate
//     method.
func (client *AzureDevOpsProjectsClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, securityConnectorName string, orgName string, projectName string, azureDevOpsProject AzureDevOpsProject, options *AzureDevOpsProjectsClientBeginCreateOrUpdateOptions) (*runtime.Poller[AzureDevOpsProjectsClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, securityConnectorName, orgName, projectName, azureDevOpsProject, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[AzureDevOpsProjectsClientCreateOrUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[AzureDevOpsProjectsClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdate - Creates or updates a monitored Azure DevOps project resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01-preview
func (client *AzureDevOpsProjectsClient) createOrUpdate(ctx context.Context, resourceGroupName string, securityConnectorName string, orgName string, projectName string, azureDevOpsProject AzureDevOpsProject, options *AzureDevOpsProjectsClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "AzureDevOpsProjectsClient.BeginCreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, securityConnectorName, orgName, projectName, azureDevOpsProject, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *AzureDevOpsProjectsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, securityConnectorName string, orgName string, projectName string, azureDevOpsProject AzureDevOpsProject, options *AzureDevOpsProjectsClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/azureDevOpsOrgs/{orgName}/projects/{projectName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if securityConnectorName == "" {
		return nil, errors.New("parameter securityConnectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{securityConnectorName}", url.PathEscape(securityConnectorName))
	if orgName == "" {
		return nil, errors.New("parameter orgName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{orgName}", url.PathEscape(orgName))
	if projectName == "" {
		return nil, errors.New("parameter projectName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{projectName}", url.PathEscape(projectName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, azureDevOpsProject); err != nil {
		return nil, err
	}
	return req, nil
}

// Get - Returns a monitored Azure DevOps project resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - securityConnectorName - The security connector name.
//   - orgName - The Azure DevOps organization name.
//   - projectName - The project name.
//   - options - AzureDevOpsProjectsClientGetOptions contains the optional parameters for the AzureDevOpsProjectsClient.Get method.
func (client *AzureDevOpsProjectsClient) Get(ctx context.Context, resourceGroupName string, securityConnectorName string, orgName string, projectName string, options *AzureDevOpsProjectsClientGetOptions) (AzureDevOpsProjectsClientGetResponse, error) {
	var err error
	const operationName = "AzureDevOpsProjectsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, securityConnectorName, orgName, projectName, options)
	if err != nil {
		return AzureDevOpsProjectsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureDevOpsProjectsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AzureDevOpsProjectsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *AzureDevOpsProjectsClient) getCreateRequest(ctx context.Context, resourceGroupName string, securityConnectorName string, orgName string, projectName string, options *AzureDevOpsProjectsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/azureDevOpsOrgs/{orgName}/projects/{projectName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if securityConnectorName == "" {
		return nil, errors.New("parameter securityConnectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{securityConnectorName}", url.PathEscape(securityConnectorName))
	if orgName == "" {
		return nil, errors.New("parameter orgName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{orgName}", url.PathEscape(orgName))
	if projectName == "" {
		return nil, errors.New("parameter projectName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{projectName}", url.PathEscape(projectName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *AzureDevOpsProjectsClient) getHandleResponse(resp *http.Response) (AzureDevOpsProjectsClientGetResponse, error) {
	result := AzureDevOpsProjectsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AzureDevOpsProject); err != nil {
		return AzureDevOpsProjectsClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Returns a list of Azure DevOps projects onboarded to the connector.
//
// Generated from API version 2023-09-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - securityConnectorName - The security connector name.
//   - orgName - The Azure DevOps organization name.
//   - options - AzureDevOpsProjectsClientListOptions contains the optional parameters for the AzureDevOpsProjectsClient.NewListPager
//     method.
func (client *AzureDevOpsProjectsClient) NewListPager(resourceGroupName string, securityConnectorName string, orgName string, options *AzureDevOpsProjectsClientListOptions) *runtime.Pager[AzureDevOpsProjectsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[AzureDevOpsProjectsClientListResponse]{
		More: func(page AzureDevOpsProjectsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AzureDevOpsProjectsClientListResponse) (AzureDevOpsProjectsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "AzureDevOpsProjectsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceGroupName, securityConnectorName, orgName, options)
			}, nil)
			if err != nil {
				return AzureDevOpsProjectsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *AzureDevOpsProjectsClient) listCreateRequest(ctx context.Context, resourceGroupName string, securityConnectorName string, orgName string, options *AzureDevOpsProjectsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/azureDevOpsOrgs/{orgName}/projects"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if securityConnectorName == "" {
		return nil, errors.New("parameter securityConnectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{securityConnectorName}", url.PathEscape(securityConnectorName))
	if orgName == "" {
		return nil, errors.New("parameter orgName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{orgName}", url.PathEscape(orgName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *AzureDevOpsProjectsClient) listHandleResponse(resp *http.Response) (AzureDevOpsProjectsClientListResponse, error) {
	result := AzureDevOpsProjectsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AzureDevOpsProjectListResponse); err != nil {
		return AzureDevOpsProjectsClientListResponse{}, err
	}
	return result, nil
}

// BeginUpdate - Updates a monitored Azure DevOps project resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - securityConnectorName - The security connector name.
//   - orgName - The Azure DevOps organization name.
//   - projectName - The project name.
//   - azureDevOpsProject - The Azure DevOps project resource payload.
//   - options - AzureDevOpsProjectsClientBeginUpdateOptions contains the optional parameters for the AzureDevOpsProjectsClient.BeginUpdate
//     method.
func (client *AzureDevOpsProjectsClient) BeginUpdate(ctx context.Context, resourceGroupName string, securityConnectorName string, orgName string, projectName string, azureDevOpsProject AzureDevOpsProject, options *AzureDevOpsProjectsClientBeginUpdateOptions) (*runtime.Poller[AzureDevOpsProjectsClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, resourceGroupName, securityConnectorName, orgName, projectName, azureDevOpsProject, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[AzureDevOpsProjectsClientUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[AzureDevOpsProjectsClientUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Update - Updates a monitored Azure DevOps project resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01-preview
func (client *AzureDevOpsProjectsClient) update(ctx context.Context, resourceGroupName string, securityConnectorName string, orgName string, projectName string, azureDevOpsProject AzureDevOpsProject, options *AzureDevOpsProjectsClientBeginUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "AzureDevOpsProjectsClient.BeginUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, securityConnectorName, orgName, projectName, azureDevOpsProject, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateCreateRequest creates the Update request.
func (client *AzureDevOpsProjectsClient) updateCreateRequest(ctx context.Context, resourceGroupName string, securityConnectorName string, orgName string, projectName string, azureDevOpsProject AzureDevOpsProject, options *AzureDevOpsProjectsClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/azureDevOpsOrgs/{orgName}/projects/{projectName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if securityConnectorName == "" {
		return nil, errors.New("parameter securityConnectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{securityConnectorName}", url.PathEscape(securityConnectorName))
	if orgName == "" {
		return nil, errors.New("parameter orgName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{orgName}", url.PathEscape(orgName))
	if projectName == "" {
		return nil, errors.New("parameter projectName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{projectName}", url.PathEscape(projectName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, azureDevOpsProject); err != nil {
		return nil, err
	}
	return req, nil
}
