//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/search/armsearch"
	"net/http"
	"net/url"
	"regexp"
)

// PrivateLinkResourcesServer is a fake server for instances of the armsearch.PrivateLinkResourcesClient type.
type PrivateLinkResourcesServer struct {
	// NewListSupportedPager is the fake for method PrivateLinkResourcesClient.NewListSupportedPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSupportedPager func(resourceGroupName string, searchServiceName string, searchManagementRequestOptions *armsearch.SearchManagementRequestOptions, options *armsearch.PrivateLinkResourcesClientListSupportedOptions) (resp azfake.PagerResponder[armsearch.PrivateLinkResourcesClientListSupportedResponse])
}

// NewPrivateLinkResourcesServerTransport creates a new instance of PrivateLinkResourcesServerTransport with the provided implementation.
// The returned PrivateLinkResourcesServerTransport instance is connected to an instance of armsearch.PrivateLinkResourcesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPrivateLinkResourcesServerTransport(srv *PrivateLinkResourcesServer) *PrivateLinkResourcesServerTransport {
	return &PrivateLinkResourcesServerTransport{
		srv:                   srv,
		newListSupportedPager: newTracker[azfake.PagerResponder[armsearch.PrivateLinkResourcesClientListSupportedResponse]](),
	}
}

// PrivateLinkResourcesServerTransport connects instances of armsearch.PrivateLinkResourcesClient to instances of PrivateLinkResourcesServer.
// Don't use this type directly, use NewPrivateLinkResourcesServerTransport instead.
type PrivateLinkResourcesServerTransport struct {
	srv                   *PrivateLinkResourcesServer
	newListSupportedPager *tracker[azfake.PagerResponder[armsearch.PrivateLinkResourcesClientListSupportedResponse]]
}

// Do implements the policy.Transporter interface for PrivateLinkResourcesServerTransport.
func (p *PrivateLinkResourcesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PrivateLinkResourcesClient.NewListSupportedPager":
		resp, err = p.dispatchNewListSupportedPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PrivateLinkResourcesServerTransport) dispatchNewListSupportedPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListSupportedPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSupportedPager not implemented")}
	}
	newListSupportedPager := p.newListSupportedPager.get(req)
	if newListSupportedPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Search/searchServices/(?P<searchServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateLinkResources`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		clientRequestIDParam := getOptional(getHeaderValue(req.Header, "x-ms-client-request-id"))
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		searchServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("searchServiceName")])
		if err != nil {
			return nil, err
		}
		var searchManagementRequestOptions *armsearch.SearchManagementRequestOptions
		if clientRequestIDParam != nil {
			searchManagementRequestOptions = &armsearch.SearchManagementRequestOptions{
				ClientRequestID: clientRequestIDParam,
			}
		}
		resp := p.srv.NewListSupportedPager(resourceGroupNameParam, searchServiceNameParam, searchManagementRequestOptions, nil)
		newListSupportedPager = &resp
		p.newListSupportedPager.add(req, newListSupportedPager)
	}
	resp, err := server.PagerResponderNext(newListSupportedPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListSupportedPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSupportedPager) {
		p.newListSupportedPager.remove(req)
	}
	return resp, nil
}
