//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armpolicy_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armpolicy"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/preview/2022-08-01-preview/examples/deleteVariableValue.json
func ExampleVariableValuesClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewVariableValuesClient().Delete(ctx, "DemoTestVariable", "TestValue", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/preview/2022-08-01-preview/examples/createOrUpdateVariableValue.json
func ExampleVariableValuesClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVariableValuesClient().CreateOrUpdate(ctx, "DemoTestVariable", "TestValue", armpolicy.VariableValue{
		Properties: &armpolicy.VariableValueProperties{
			Values: []*armpolicy.VariableValueColumnValue{
				{
					ColumnName:  to.Ptr("StringColumn"),
					ColumnValue: "SampleValue",
				},
				{
					ColumnName:  to.Ptr("IntegerColumn"),
					ColumnValue: float64(10),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VariableValue = armpolicy.VariableValue{
	// 	Name: to.Ptr("TestValue"),
	// 	Type: to.Ptr("Microsoft.Authorization/variables/values"),
	// 	ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/variables/DemoTestVariable/values/TestValue"),
	// 	Properties: &armpolicy.VariableValueProperties{
	// 		Values: []*armpolicy.VariableValueColumnValue{
	// 			{
	// 				ColumnName: to.Ptr("StringColumn"),
	// 				ColumnValue: "SampleValue",
	// 			},
	// 			{
	// 				ColumnName: to.Ptr("IntegerColumn"),
	// 				ColumnValue: float64(10),
	// 		}},
	// 	},
	// 	SystemData: &armpolicy.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-07-01T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armpolicy.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-07-01T02:01:01.107Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armpolicy.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/preview/2022-08-01-preview/examples/getVariableValue.json
func ExampleVariableValuesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVariableValuesClient().Get(ctx, "DemoTestVariable", "TestValue", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VariableValue = armpolicy.VariableValue{
	// 	Name: to.Ptr("TestValue"),
	// 	Type: to.Ptr("Microsoft.Authorization/variables/values"),
	// 	ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/variables/DemoTestVariable/values/TestValue"),
	// 	Properties: &armpolicy.VariableValueProperties{
	// 		Values: []*armpolicy.VariableValueColumnValue{
	// 			{
	// 				ColumnName: to.Ptr("StringColumn"),
	// 				ColumnValue: "SampleValue",
	// 			},
	// 			{
	// 				ColumnName: to.Ptr("IntegerColumn"),
	// 				ColumnValue: float64(10),
	// 		}},
	// 	},
	// 	SystemData: &armpolicy.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-07-01T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armpolicy.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-08-01T01:01:01.107Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armpolicy.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/preview/2022-08-01-preview/examples/listVariableValuesForSubscription.json
func ExampleVariableValuesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVariableValuesClient().NewListPager("DemoTestVariable", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VariableValueListResult = armpolicy.VariableValueListResult{
		// 	Value: []*armpolicy.VariableValue{
		// 		{
		// 			Name: to.Ptr("TestValue"),
		// 			Type: to.Ptr("Microsoft.Authorization/variables/values"),
		// 			ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/variables/DemoTestVariable/values/TestValue"),
		// 			Properties: &armpolicy.VariableValueProperties{
		// 				Values: []*armpolicy.VariableValueColumnValue{
		// 					{
		// 						ColumnName: to.Ptr("StringColumn"),
		// 						ColumnValue: "SampleValue",
		// 					},
		// 					{
		// 						ColumnName: to.Ptr("IntegerColumn"),
		// 						ColumnValue: float64(10),
		// 				}},
		// 			},
		// 			SystemData: &armpolicy.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-07-01T01:01:01.107Z"); return t}()),
		// 				CreatedBy: to.Ptr("string"),
		// 				CreatedByType: to.Ptr(armpolicy.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-08-01T01:01:01.107Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("string"),
		// 				LastModifiedByType: to.Ptr(armpolicy.CreatedByTypeUser),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("NullableTestValue"),
		// 			Type: to.Ptr("Microsoft.Authorization/variables/values"),
		// 			ID: to.Ptr("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/variables/DemoTestVariable/values/NullableTestValue"),
		// 			Properties: &armpolicy.VariableValueProperties{
		// 				Values: []*armpolicy.VariableValueColumnValue{
		// 					{
		// 						ColumnName: to.Ptr("NullColumnName"),
		// 				}},
		// 			},
		// 			SystemData: &armpolicy.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-07-01T01:01:01.107Z"); return t}()),
		// 				CreatedBy: to.Ptr("string"),
		// 				CreatedByType: to.Ptr(armpolicy.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-08-01T01:01:01.107Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("string"),
		// 				LastModifiedByType: to.Ptr(armpolicy.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/preview/2022-08-01-preview/examples/listVariableValuesForManagementGroup.json
func ExampleVariableValuesClient_NewListForManagementGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVariableValuesClient().NewListForManagementGroupPager("DevOrg", "DemoTestVariable", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VariableValueListResult = armpolicy.VariableValueListResult{
		// 	Value: []*armpolicy.VariableValue{
		// 		{
		// 			Name: to.Ptr("TestValue"),
		// 			Type: to.Ptr("Microsoft.Authorization/variables/values"),
		// 			ID: to.Ptr("/providers/Microsoft.Management/managementGroups/DevOrg/providers/Microsoft.Authorization/variables/DemoTestVariable/values/TestValue"),
		// 			Properties: &armpolicy.VariableValueProperties{
		// 				Values: []*armpolicy.VariableValueColumnValue{
		// 					{
		// 						ColumnName: to.Ptr("StringColumn"),
		// 						ColumnValue: "SampleValue",
		// 					},
		// 					{
		// 						ColumnName: to.Ptr("IntegerColumn"),
		// 						ColumnValue: float64(10),
		// 				}},
		// 			},
		// 			SystemData: &armpolicy.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-07-01T01:01:01.107Z"); return t}()),
		// 				CreatedBy: to.Ptr("string"),
		// 				CreatedByType: to.Ptr(armpolicy.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-08-01T01:01:01.107Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("string"),
		// 				LastModifiedByType: to.Ptr(armpolicy.CreatedByTypeUser),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("NullableTestValue"),
		// 			Type: to.Ptr("Microsoft.Authorization/variables/values"),
		// 			ID: to.Ptr("/providers/Microsoft.Management/managementGroups/DevOrg/providers/Microsoft.Authorization/variables/DemoTestVariable/values/NullableTestValue"),
		// 			Properties: &armpolicy.VariableValueProperties{
		// 				Values: []*armpolicy.VariableValueColumnValue{
		// 					{
		// 						ColumnName: to.Ptr("NullColumnName"),
		// 				}},
		// 			},
		// 			SystemData: &armpolicy.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-07-01T01:01:01.107Z"); return t}()),
		// 				CreatedBy: to.Ptr("string"),
		// 				CreatedByType: to.Ptr(armpolicy.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-07-01T02:01:01.107Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("string"),
		// 				LastModifiedByType: to.Ptr(armpolicy.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/preview/2022-08-01-preview/examples/deleteVariableValueAtManagementGroup.json
func ExampleVariableValuesClient_DeleteAtManagementGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewVariableValuesClient().DeleteAtManagementGroup(ctx, "DevOrg", "DemoTestVariable", "TestValue", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/preview/2022-08-01-preview/examples/createOrUpdateVariableValueAtManagementGroup.json
func ExampleVariableValuesClient_CreateOrUpdateAtManagementGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVariableValuesClient().CreateOrUpdateAtManagementGroup(ctx, "DevOrg", "DemoTestVariable", "TestValue", armpolicy.VariableValue{
		Properties: &armpolicy.VariableValueProperties{
			Values: []*armpolicy.VariableValueColumnValue{
				{
					ColumnName:  to.Ptr("StringColumn"),
					ColumnValue: "SampleValue",
				},
				{
					ColumnName:  to.Ptr("IntegerColumn"),
					ColumnValue: float64(10),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VariableValue = armpolicy.VariableValue{
	// 	Name: to.Ptr("TestValue"),
	// 	Type: to.Ptr("Microsoft.Authorization/variables/values"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementGroups/DevOrg/providers/Microsoft.Authorization/variables/DemoTestVariable/values/TestValue"),
	// 	Properties: &armpolicy.VariableValueProperties{
	// 		Values: []*armpolicy.VariableValueColumnValue{
	// 			{
	// 				ColumnName: to.Ptr("StringColumn"),
	// 				ColumnValue: "SampleValue",
	// 			},
	// 			{
	// 				ColumnName: to.Ptr("IntegerColumn"),
	// 				ColumnValue: float64(10),
	// 		}},
	// 	},
	// 	SystemData: &armpolicy.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-07-01T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armpolicy.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-07-01T02:01:01.107Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armpolicy.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/resources/resource-manager/Microsoft.Authorization/preview/2022-08-01-preview/examples/getVariableValueAtManagementGroup.json
func ExampleVariableValuesClient_GetAtManagementGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicy.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVariableValuesClient().GetAtManagementGroup(ctx, "DevOrg", "DemoTestVariable", "TestValue", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VariableValue = armpolicy.VariableValue{
	// 	Name: to.Ptr("TestValue"),
	// 	Type: to.Ptr("Microsoft.Authorization/variables/values"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementGroups/DevOrg/providers/Microsoft.Authorization/variables/DemoTestVariable/values/TestValue"),
	// 	Properties: &armpolicy.VariableValueProperties{
	// 		Values: []*armpolicy.VariableValueColumnValue{
	// 			{
	// 				ColumnName: to.Ptr("StringColumn"),
	// 				ColumnValue: "SampleValue",
	// 			},
	// 			{
	// 				ColumnName: to.Ptr("IntegerColumn"),
	// 				ColumnValue: float64(10),
	// 		}},
	// 	},
	// 	SystemData: &armpolicy.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-07-01T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armpolicy.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-08-01T01:01:01.107Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armpolicy.CreatedByTypeUser),
	// 	},
	// }
}
