//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armlocks

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
)

// AuthorizationOperationsClient contains the methods for the AuthorizationOperations group.
// Don't use this type directly, use NewAuthorizationOperationsClient() instead.
type AuthorizationOperationsClient struct {
	internal *arm.Client
}

// NewAuthorizationOperationsClient creates a new instance of AuthorizationOperationsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewAuthorizationOperationsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*AuthorizationOperationsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &AuthorizationOperationsClient{
		internal: cl,
	}
	return client, nil
}

// NewListPager - Lists all of the available Microsoft.Authorization REST API operations.
//
// Generated from API version 2020-05-01
//   - options - AuthorizationOperationsClientListOptions contains the optional parameters for the AuthorizationOperationsClient.NewListPager
//     method.
func (client *AuthorizationOperationsClient) NewListPager(options *AuthorizationOperationsClientListOptions) *runtime.Pager[AuthorizationOperationsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[AuthorizationOperationsClientListResponse]{
		More: func(page AuthorizationOperationsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AuthorizationOperationsClientListResponse) (AuthorizationOperationsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "AuthorizationOperationsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return AuthorizationOperationsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *AuthorizationOperationsClient) listCreateRequest(ctx context.Context, options *AuthorizationOperationsClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Authorization/operations"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *AuthorizationOperationsClient) listHandleResponse(resp *http.Response) (AuthorizationOperationsClientListResponse, error) {
	result := AuthorizationOperationsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OperationListResult); err != nil {
		return AuthorizationOperationsClientListResponse{}, err
	}
	return result, nil
}
