//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdeploymentscripts

import "encoding/json"

// ClientCreateResponse contains the response from method Client.BeginCreate.
type ClientCreateResponse struct {
	// Deployment script object.
	DeploymentScriptClassification
}

// MarshalJSON implements the json.Marshaller interface for type ClientCreateResponse.
func (c ClientCreateResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(c.DeploymentScriptClassification)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClientCreateResponse.
func (c *ClientCreateResponse) UnmarshalJSON(data []byte) error {
	res, err := unmarshalDeploymentScriptClassification(data)
	if err != nil {
		return err
	}
	c.DeploymentScriptClassification = res
	return nil
}

// ClientDeleteResponse contains the response from method Client.Delete.
type ClientDeleteResponse struct {
	// placeholder for future response values
}

// ClientGetLogsDefaultResponse contains the response from method Client.GetLogsDefault.
type ClientGetLogsDefaultResponse struct {
	// Script execution log object.
	ScriptLog
}

// ClientGetLogsResponse contains the response from method Client.GetLogs.
type ClientGetLogsResponse struct {
	// Deployment script execution logs.
	ScriptLogsList
}

// ClientGetResponse contains the response from method Client.Get.
type ClientGetResponse struct {
	// Deployment script object.
	DeploymentScriptClassification
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClientGetResponse.
func (c *ClientGetResponse) UnmarshalJSON(data []byte) error {
	res, err := unmarshalDeploymentScriptClassification(data)
	if err != nil {
		return err
	}
	c.DeploymentScriptClassification = res
	return nil
}

// ClientListByResourceGroupResponse contains the response from method Client.NewListByResourceGroupPager.
type ClientListByResourceGroupResponse struct {
	// List of deployment scripts.
	DeploymentScriptListResult
}

// ClientListBySubscriptionResponse contains the response from method Client.NewListBySubscriptionPager.
type ClientListBySubscriptionResponse struct {
	// List of deployment scripts.
	DeploymentScriptListResult
}

// ClientUpdateResponse contains the response from method Client.Update.
type ClientUpdateResponse struct {
	// Deployment script object.
	DeploymentScriptClassification
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClientUpdateResponse.
func (c *ClientUpdateResponse) UnmarshalJSON(data []byte) error {
	res, err := unmarshalDeploymentScriptClassification(data)
	if err != nil {
		return err
	}
	c.DeploymentScriptClassification = res
	return nil
}
