//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armresourcemover

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AffectedMoveResource.
func (a AffectedMoveResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "moveResources", a.MoveResources)
	populate(objectMap, "sourceId", a.SourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AffectedMoveResource.
func (a *AffectedMoveResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "moveResources":
			err = unpopulate(val, "MoveResources", &a.MoveResources)
			delete(rawMsg, key)
		case "sourceId":
			err = unpopulate(val, "SourceID", &a.SourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomaticResolutionProperties.
func (a AutomaticResolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "moveResourceId", a.MoveResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomaticResolutionProperties.
func (a *AutomaticResolutionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "moveResourceId":
			err = unpopulate(val, "MoveResourceID", &a.MoveResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailabilitySetResourceSettings.
func (a AvailabilitySetResourceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "faultDomain", a.FaultDomain)
	objectMap["resourceType"] = "Microsoft.Compute/availabilitySets"
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "targetResourceGroupName", a.TargetResourceGroupName)
	populate(objectMap, "targetResourceName", a.TargetResourceName)
	populate(objectMap, "updateDomain", a.UpdateDomain)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilitySetResourceSettings.
func (a *AvailabilitySetResourceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "faultDomain":
			err = unpopulate(val, "FaultDomain", &a.FaultDomain)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &a.ResourceType)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "targetResourceGroupName":
			err = unpopulate(val, "TargetResourceGroupName", &a.TargetResourceGroupName)
			delete(rawMsg, key)
		case "targetResourceName":
			err = unpopulate(val, "TargetResourceName", &a.TargetResourceName)
			delete(rawMsg, key)
		case "updateDomain":
			err = unpopulate(val, "UpdateDomain", &a.UpdateDomain)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BulkRemoveRequest.
func (b BulkRemoveRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "moveResourceInputType", b.MoveResourceInputType)
	populate(objectMap, "moveResources", b.MoveResources)
	populate(objectMap, "validateOnly", b.ValidateOnly)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BulkRemoveRequest.
func (b *BulkRemoveRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "moveResourceInputType":
			err = unpopulate(val, "MoveResourceInputType", &b.MoveResourceInputType)
			delete(rawMsg, key)
		case "moveResources":
			err = unpopulate(val, "MoveResources", &b.MoveResources)
			delete(rawMsg, key)
		case "validateOnly":
			err = unpopulate(val, "ValidateOnly", &b.ValidateOnly)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommitRequest.
func (c CommitRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "moveResourceInputType", c.MoveResourceInputType)
	populate(objectMap, "moveResources", c.MoveResources)
	populate(objectMap, "validateOnly", c.ValidateOnly)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommitRequest.
func (c *CommitRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "moveResourceInputType":
			err = unpopulate(val, "MoveResourceInputType", &c.MoveResourceInputType)
			delete(rawMsg, key)
		case "moveResources":
			err = unpopulate(val, "MoveResources", &c.MoveResources)
			delete(rawMsg, key)
		case "validateOnly":
			err = unpopulate(val, "ValidateOnly", &c.ValidateOnly)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiscardRequest.
func (d DiscardRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "moveResourceInputType", d.MoveResourceInputType)
	populate(objectMap, "moveResources", d.MoveResources)
	populate(objectMap, "validateOnly", d.ValidateOnly)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiscardRequest.
func (d *DiscardRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "moveResourceInputType":
			err = unpopulate(val, "MoveResourceInputType", &d.MoveResourceInputType)
			delete(rawMsg, key)
		case "moveResources":
			err = unpopulate(val, "MoveResources", &d.MoveResources)
			delete(rawMsg, key)
		case "validateOnly":
			err = unpopulate(val, "ValidateOnly", &d.ValidateOnly)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskEncryptionSetResourceSettings.
func (d DiskEncryptionSetResourceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["resourceType"] = "Microsoft.Compute/diskEncryptionSets"
	populate(objectMap, "targetResourceGroupName", d.TargetResourceGroupName)
	populate(objectMap, "targetResourceName", d.TargetResourceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskEncryptionSetResourceSettings.
func (d *DiskEncryptionSetResourceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceType":
			err = unpopulate(val, "ResourceType", &d.ResourceType)
			delete(rawMsg, key)
		case "targetResourceGroupName":
			err = unpopulate(val, "TargetResourceGroupName", &d.TargetResourceGroupName)
			delete(rawMsg, key)
		case "targetResourceName":
			err = unpopulate(val, "TargetResourceName", &d.TargetResourceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Display.
func (d Display) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "operation", d.Operation)
	populate(objectMap, "provider", d.Provider)
	populate(objectMap, "resource", d.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Display.
func (d *Display) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &d.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &d.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &d.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", i.PrincipalID)
	populate(objectMap, "tenantId", i.TenantID)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Identity.
func (i *Identity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &i.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &i.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobStatus.
func (j JobStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "jobName", j.JobName)
	populate(objectMap, "jobProgress", j.JobProgress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobStatus.
func (j *JobStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobName":
			err = unpopulate(val, "JobName", &j.JobName)
			delete(rawMsg, key)
		case "jobProgress":
			err = unpopulate(val, "JobProgress", &j.JobProgress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultResourceSettings.
func (k KeyVaultResourceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["resourceType"] = "Microsoft.KeyVault/vaults"
	populate(objectMap, "targetResourceGroupName", k.TargetResourceGroupName)
	populate(objectMap, "targetResourceName", k.TargetResourceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultResourceSettings.
func (k *KeyVaultResourceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceType":
			err = unpopulate(val, "ResourceType", &k.ResourceType)
			delete(rawMsg, key)
		case "targetResourceGroupName":
			err = unpopulate(val, "TargetResourceGroupName", &k.TargetResourceGroupName)
			delete(rawMsg, key)
		case "targetResourceName":
			err = unpopulate(val, "TargetResourceName", &k.TargetResourceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LBBackendAddressPoolResourceSettings.
func (l LBBackendAddressPoolResourceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", l.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LBBackendAddressPoolResourceSettings.
func (l *LBBackendAddressPoolResourceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LBFrontendIPConfigurationResourceSettings.
func (l LBFrontendIPConfigurationResourceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "privateIpAddress", l.PrivateIPAddress)
	populate(objectMap, "privateIpAllocationMethod", l.PrivateIPAllocationMethod)
	populate(objectMap, "subnet", l.Subnet)
	populate(objectMap, "zones", l.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LBFrontendIPConfigurationResourceSettings.
func (l *LBFrontendIPConfigurationResourceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "privateIpAddress":
			err = unpopulate(val, "PrivateIPAddress", &l.PrivateIPAddress)
			delete(rawMsg, key)
		case "privateIpAllocationMethod":
			err = unpopulate(val, "PrivateIPAllocationMethod", &l.PrivateIPAllocationMethod)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &l.Subnet)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &l.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerBackendAddressPoolReference.
func (l LoadBalancerBackendAddressPoolReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "sourceArmResourceId", l.SourceArmResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerBackendAddressPoolReference.
func (l *LoadBalancerBackendAddressPoolReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "sourceArmResourceId":
			err = unpopulate(val, "SourceArmResourceID", &l.SourceArmResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerNatRuleReference.
func (l LoadBalancerNatRuleReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "sourceArmResourceId", l.SourceArmResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerNatRuleReference.
func (l *LoadBalancerNatRuleReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "sourceArmResourceId":
			err = unpopulate(val, "SourceArmResourceID", &l.SourceArmResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerResourceSettings.
func (l LoadBalancerResourceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendAddressPools", l.BackendAddressPools)
	populate(objectMap, "frontendIPConfigurations", l.FrontendIPConfigurations)
	objectMap["resourceType"] = "Microsoft.Network/loadBalancers"
	populate(objectMap, "sku", l.SKU)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "targetResourceGroupName", l.TargetResourceGroupName)
	populate(objectMap, "targetResourceName", l.TargetResourceName)
	populate(objectMap, "zones", l.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerResourceSettings.
func (l *LoadBalancerResourceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendAddressPools":
			err = unpopulate(val, "BackendAddressPools", &l.BackendAddressPools)
			delete(rawMsg, key)
		case "frontendIPConfigurations":
			err = unpopulate(val, "FrontendIPConfigurations", &l.FrontendIPConfigurations)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &l.ResourceType)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &l.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		case "targetResourceGroupName":
			err = unpopulate(val, "TargetResourceGroupName", &l.TargetResourceGroupName)
			delete(rawMsg, key)
		case "targetResourceName":
			err = unpopulate(val, "TargetResourceName", &l.TargetResourceName)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &l.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManualResolutionProperties.
func (m ManualResolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "targetId", m.TargetID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManualResolutionProperties.
func (m *ManualResolutionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "targetId":
			err = unpopulate(val, "TargetID", &m.TargetID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MoveCollection.
func (m MoveCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", m.Etag)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "identity", m.Identity)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MoveCollection.
func (m *MoveCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &m.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &m.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MoveCollectionProperties.
func (m MoveCollectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "moveRegion", m.MoveRegion)
	populate(objectMap, "moveType", m.MoveType)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "sourceRegion", m.SourceRegion)
	populate(objectMap, "targetRegion", m.TargetRegion)
	populate(objectMap, "version", m.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MoveCollectionProperties.
func (m *MoveCollectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "moveRegion":
			err = unpopulate(val, "MoveRegion", &m.MoveRegion)
			delete(rawMsg, key)
		case "moveType":
			err = unpopulate(val, "MoveType", &m.MoveType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		case "sourceRegion":
			err = unpopulate(val, "SourceRegion", &m.SourceRegion)
			delete(rawMsg, key)
		case "targetRegion":
			err = unpopulate(val, "TargetRegion", &m.TargetRegion)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &m.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MoveCollectionPropertiesErrors.
func (m MoveCollectionPropertiesErrors) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", m.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MoveCollectionPropertiesErrors.
func (m *MoveCollectionPropertiesErrors) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MoveCollectionResultList.
func (m MoveCollectionResultList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MoveCollectionResultList.
func (m *MoveCollectionResultList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MoveErrorInfo.
func (m MoveErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "moveResources", m.MoveResources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MoveErrorInfo.
func (m *MoveErrorInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "moveResources":
			err = unpopulate(val, "MoveResources", &m.MoveResources)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MoveResource.
func (m MoveResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MoveResource.
func (m *MoveResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MoveResourceCollection.
func (m MoveResourceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "summaryCollection", m.SummaryCollection)
	populate(objectMap, "totalCount", m.TotalCount)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MoveResourceCollection.
func (m *MoveResourceCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "summaryCollection":
			err = unpopulate(val, "SummaryCollection", &m.SummaryCollection)
			delete(rawMsg, key)
		case "totalCount":
			err = unpopulate(val, "TotalCount", &m.TotalCount)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MoveResourceDependency.
func (m MoveResourceDependency) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "automaticResolution", m.AutomaticResolution)
	populate(objectMap, "dependencyType", m.DependencyType)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "isOptional", m.IsOptional)
	populate(objectMap, "manualResolution", m.ManualResolution)
	populate(objectMap, "resolutionStatus", m.ResolutionStatus)
	populate(objectMap, "resolutionType", m.ResolutionType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MoveResourceDependency.
func (m *MoveResourceDependency) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "automaticResolution":
			err = unpopulate(val, "AutomaticResolution", &m.AutomaticResolution)
			delete(rawMsg, key)
		case "dependencyType":
			err = unpopulate(val, "DependencyType", &m.DependencyType)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "isOptional":
			err = unpopulate(val, "IsOptional", &m.IsOptional)
			delete(rawMsg, key)
		case "manualResolution":
			err = unpopulate(val, "ManualResolution", &m.ManualResolution)
			delete(rawMsg, key)
		case "resolutionStatus":
			err = unpopulate(val, "ResolutionStatus", &m.ResolutionStatus)
			delete(rawMsg, key)
		case "resolutionType":
			err = unpopulate(val, "ResolutionType", &m.ResolutionType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MoveResourceDependencyOverride.
func (m MoveResourceDependencyOverride) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "targetId", m.TargetID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MoveResourceDependencyOverride.
func (m *MoveResourceDependencyOverride) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "targetId":
			err = unpopulate(val, "TargetID", &m.TargetID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MoveResourceError.
func (m MoveResourceError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", m.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MoveResourceError.
func (m *MoveResourceError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MoveResourceErrorBody.
func (m MoveResourceErrorBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", m.Code)
	populate(objectMap, "details", m.Details)
	populate(objectMap, "message", m.Message)
	populate(objectMap, "target", m.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MoveResourceErrorBody.
func (m *MoveResourceErrorBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &m.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &m.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &m.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MoveResourceFilter.
func (m MoveResourceFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", m.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MoveResourceFilter.
func (m *MoveResourceFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MoveResourceFilterProperties.
func (m MoveResourceFilterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MoveResourceFilterProperties.
func (m *MoveResourceFilterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MoveResourceProperties.
func (m MoveResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", m.DependsOn)
	populate(objectMap, "dependsOnOverrides", m.DependsOnOverrides)
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "existingTargetId", m.ExistingTargetID)
	populate(objectMap, "isResolveRequired", m.IsResolveRequired)
	populate(objectMap, "moveStatus", m.MoveStatus)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "resourceSettings", m.ResourceSettings)
	populate(objectMap, "sourceId", m.SourceID)
	populate(objectMap, "sourceResourceSettings", m.SourceResourceSettings)
	populate(objectMap, "targetId", m.TargetID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MoveResourceProperties.
func (m *MoveResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &m.DependsOn)
			delete(rawMsg, key)
		case "dependsOnOverrides":
			err = unpopulate(val, "DependsOnOverrides", &m.DependsOnOverrides)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "existingTargetId":
			err = unpopulate(val, "ExistingTargetID", &m.ExistingTargetID)
			delete(rawMsg, key)
		case "isResolveRequired":
			err = unpopulate(val, "IsResolveRequired", &m.IsResolveRequired)
			delete(rawMsg, key)
		case "moveStatus":
			err = unpopulate(val, "MoveStatus", &m.MoveStatus)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		case "resourceSettings":
			m.ResourceSettings, err = unmarshalResourceSettingsClassification(val)
			delete(rawMsg, key)
		case "sourceId":
			err = unpopulate(val, "SourceID", &m.SourceID)
			delete(rawMsg, key)
		case "sourceResourceSettings":
			m.SourceResourceSettings, err = unmarshalResourceSettingsClassification(val)
			delete(rawMsg, key)
		case "targetId":
			err = unpopulate(val, "TargetID", &m.TargetID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MoveResourcePropertiesErrors.
func (m MoveResourcePropertiesErrors) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", m.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MoveResourcePropertiesErrors.
func (m *MoveResourcePropertiesErrors) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MoveResourcePropertiesMoveStatus.
func (m MoveResourcePropertiesMoveStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errors", m.Errors)
	populate(objectMap, "jobStatus", m.JobStatus)
	populate(objectMap, "moveState", m.MoveState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MoveResourcePropertiesMoveStatus.
func (m *MoveResourcePropertiesMoveStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "jobStatus":
			err = unpopulate(val, "JobStatus", &m.JobStatus)
			delete(rawMsg, key)
		case "moveState":
			err = unpopulate(val, "MoveState", &m.MoveState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkInterfaceResourceSettings.
func (n NetworkInterfaceResourceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enableAcceleratedNetworking", n.EnableAcceleratedNetworking)
	populate(objectMap, "ipConfigurations", n.IPConfigurations)
	objectMap["resourceType"] = "Microsoft.Network/networkInterfaces"
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "targetResourceGroupName", n.TargetResourceGroupName)
	populate(objectMap, "targetResourceName", n.TargetResourceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkInterfaceResourceSettings.
func (n *NetworkInterfaceResourceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enableAcceleratedNetworking":
			err = unpopulate(val, "EnableAcceleratedNetworking", &n.EnableAcceleratedNetworking)
			delete(rawMsg, key)
		case "ipConfigurations":
			err = unpopulate(val, "IPConfigurations", &n.IPConfigurations)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &n.ResourceType)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		case "targetResourceGroupName":
			err = unpopulate(val, "TargetResourceGroupName", &n.TargetResourceGroupName)
			delete(rawMsg, key)
		case "targetResourceName":
			err = unpopulate(val, "TargetResourceName", &n.TargetResourceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkSecurityGroupResourceSettings.
func (n NetworkSecurityGroupResourceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["resourceType"] = "Microsoft.Network/networkSecurityGroups"
	populate(objectMap, "securityRules", n.SecurityRules)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "targetResourceGroupName", n.TargetResourceGroupName)
	populate(objectMap, "targetResourceName", n.TargetResourceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkSecurityGroupResourceSettings.
func (n *NetworkSecurityGroupResourceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceType":
			err = unpopulate(val, "ResourceType", &n.ResourceType)
			delete(rawMsg, key)
		case "securityRules":
			err = unpopulate(val, "SecurityRules", &n.SecurityRules)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		case "targetResourceGroupName":
			err = unpopulate(val, "TargetResourceGroupName", &n.TargetResourceGroupName)
			delete(rawMsg, key)
		case "targetResourceName":
			err = unpopulate(val, "TargetResourceName", &n.TargetResourceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NicIPConfigurationResourceSettings.
func (n NicIPConfigurationResourceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "loadBalancerBackendAddressPools", n.LoadBalancerBackendAddressPools)
	populate(objectMap, "loadBalancerNatRules", n.LoadBalancerNatRules)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "primary", n.Primary)
	populate(objectMap, "privateIpAddress", n.PrivateIPAddress)
	populate(objectMap, "privateIpAllocationMethod", n.PrivateIPAllocationMethod)
	populate(objectMap, "publicIp", n.PublicIP)
	populate(objectMap, "subnet", n.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NicIPConfigurationResourceSettings.
func (n *NicIPConfigurationResourceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "loadBalancerBackendAddressPools":
			err = unpopulate(val, "LoadBalancerBackendAddressPools", &n.LoadBalancerBackendAddressPools)
			delete(rawMsg, key)
		case "loadBalancerNatRules":
			err = unpopulate(val, "LoadBalancerNatRules", &n.LoadBalancerNatRules)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "primary":
			err = unpopulate(val, "Primary", &n.Primary)
			delete(rawMsg, key)
		case "privateIpAddress":
			err = unpopulate(val, "PrivateIPAddress", &n.PrivateIPAddress)
			delete(rawMsg, key)
		case "privateIpAllocationMethod":
			err = unpopulate(val, "PrivateIPAllocationMethod", &n.PrivateIPAllocationMethod)
			delete(rawMsg, key)
		case "publicIp":
			err = unpopulate(val, "PublicIP", &n.PublicIP)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &n.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NsgReference.
func (n NsgReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sourceArmResourceId", n.SourceArmResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NsgReference.
func (n *NsgReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sourceArmResourceId":
			err = unpopulate(val, "SourceArmResourceID", &n.SourceArmResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NsgSecurityRule.
func (n NsgSecurityRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "access", n.Access)
	populate(objectMap, "description", n.Description)
	populate(objectMap, "destinationAddressPrefix", n.DestinationAddressPrefix)
	populate(objectMap, "destinationPortRange", n.DestinationPortRange)
	populate(objectMap, "direction", n.Direction)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "priority", n.Priority)
	populate(objectMap, "protocol", n.Protocol)
	populate(objectMap, "sourceAddressPrefix", n.SourceAddressPrefix)
	populate(objectMap, "sourcePortRange", n.SourcePortRange)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NsgSecurityRule.
func (n *NsgSecurityRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "access":
			err = unpopulate(val, "Access", &n.Access)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &n.Description)
			delete(rawMsg, key)
		case "destinationAddressPrefix":
			err = unpopulate(val, "DestinationAddressPrefix", &n.DestinationAddressPrefix)
			delete(rawMsg, key)
		case "destinationPortRange":
			err = unpopulate(val, "DestinationPortRange", &n.DestinationPortRange)
			delete(rawMsg, key)
		case "direction":
			err = unpopulate(val, "Direction", &n.Direction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &n.Priority)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &n.Protocol)
			delete(rawMsg, key)
		case "sourceAddressPrefix":
			err = unpopulate(val, "SourceAddressPrefix", &n.SourceAddressPrefix)
			delete(rawMsg, key)
		case "sourcePortRange":
			err = unpopulate(val, "SourcePortRange", &n.SourcePortRange)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationErrorAdditionalInfo.
func (o OperationErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "info", o.Info)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationErrorAdditionalInfo.
func (o *OperationErrorAdditionalInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "info":
			err = unpopulate(val, "Info", &o.Info)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationStatus.
func (o OperationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endTime", o.EndTime)
	populate(objectMap, "error", o.Error)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populateAny(objectMap, "properties", o.Properties)
	populate(objectMap, "startTime", o.StartTime)
	populate(objectMap, "status", o.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationStatus.
func (o *OperationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulate(val, "EndTime", &o.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationStatusError.
func (o OperationStatusError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInfo", o.AdditionalInfo)
	populate(objectMap, "code", o.Code)
	populate(objectMap, "details", o.Details)
	populate(objectMap, "message", o.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationStatusError.
func (o *OperationStatusError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &o.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &o.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &o.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &o.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationsDiscovery.
func (o OperationsDiscovery) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	populateAny(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationsDiscovery.
func (o *OperationsDiscovery) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationsDiscoveryCollection.
func (o OperationsDiscoveryCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationsDiscoveryCollection.
func (o *OperationsDiscoveryCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrepareRequest.
func (p PrepareRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "moveResourceInputType", p.MoveResourceInputType)
	populate(objectMap, "moveResources", p.MoveResources)
	populate(objectMap, "validateOnly", p.ValidateOnly)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrepareRequest.
func (p *PrepareRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "moveResourceInputType":
			err = unpopulate(val, "MoveResourceInputType", &p.MoveResourceInputType)
			delete(rawMsg, key)
		case "moveResources":
			err = unpopulate(val, "MoveResources", &p.MoveResources)
			delete(rawMsg, key)
		case "validateOnly":
			err = unpopulate(val, "ValidateOnly", &p.ValidateOnly)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicIPAddressResourceSettings.
func (p PublicIPAddressResourceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "domainNameLabel", p.DomainNameLabel)
	populate(objectMap, "fqdn", p.Fqdn)
	populate(objectMap, "publicIpAllocationMethod", p.PublicIPAllocationMethod)
	objectMap["resourceType"] = "Microsoft.Network/publicIPAddresses"
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "targetResourceGroupName", p.TargetResourceGroupName)
	populate(objectMap, "targetResourceName", p.TargetResourceName)
	populate(objectMap, "zones", p.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicIPAddressResourceSettings.
func (p *PublicIPAddressResourceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "domainNameLabel":
			err = unpopulate(val, "DomainNameLabel", &p.DomainNameLabel)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &p.Fqdn)
			delete(rawMsg, key)
		case "publicIpAllocationMethod":
			err = unpopulate(val, "PublicIPAllocationMethod", &p.PublicIPAllocationMethod)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &p.ResourceType)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &p.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "targetResourceGroupName":
			err = unpopulate(val, "TargetResourceGroupName", &p.TargetResourceGroupName)
			delete(rawMsg, key)
		case "targetResourceName":
			err = unpopulate(val, "TargetResourceName", &p.TargetResourceName)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &p.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicIPReference.
func (p PublicIPReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sourceArmResourceId", p.SourceArmResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicIPReference.
func (p *PublicIPReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sourceArmResourceId":
			err = unpopulate(val, "SourceArmResourceID", &p.SourceArmResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequiredForResourcesCollection.
func (r RequiredForResourcesCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sourceIds", r.SourceIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequiredForResourcesCollection.
func (r *RequiredForResourcesCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sourceIds":
			err = unpopulate(val, "SourceIDs", &r.SourceIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceGroupResourceSettings.
func (r ResourceGroupResourceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["resourceType"] = "resourceGroups"
	populate(objectMap, "targetResourceGroupName", r.TargetResourceGroupName)
	populate(objectMap, "targetResourceName", r.TargetResourceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceGroupResourceSettings.
func (r *ResourceGroupResourceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceType":
			err = unpopulate(val, "ResourceType", &r.ResourceType)
			delete(rawMsg, key)
		case "targetResourceGroupName":
			err = unpopulate(val, "TargetResourceGroupName", &r.TargetResourceGroupName)
			delete(rawMsg, key)
		case "targetResourceName":
			err = unpopulate(val, "TargetResourceName", &r.TargetResourceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceMoveRequest.
func (r ResourceMoveRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "moveResourceInputType", r.MoveResourceInputType)
	populate(objectMap, "moveResources", r.MoveResources)
	populate(objectMap, "validateOnly", r.ValidateOnly)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceMoveRequest.
func (r *ResourceMoveRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "moveResourceInputType":
			err = unpopulate(val, "MoveResourceInputType", &r.MoveResourceInputType)
			delete(rawMsg, key)
		case "moveResources":
			err = unpopulate(val, "MoveResources", &r.MoveResources)
			delete(rawMsg, key)
		case "validateOnly":
			err = unpopulate(val, "ValidateOnly", &r.ValidateOnly)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceSettings.
func (r ResourceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["resourceType"] = r.ResourceType
	populate(objectMap, "targetResourceGroupName", r.TargetResourceGroupName)
	populate(objectMap, "targetResourceName", r.TargetResourceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceSettings.
func (r *ResourceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceType":
			err = unpopulate(val, "ResourceType", &r.ResourceType)
			delete(rawMsg, key)
		case "targetResourceGroupName":
			err = unpopulate(val, "TargetResourceGroupName", &r.TargetResourceGroupName)
			delete(rawMsg, key)
		case "targetResourceName":
			err = unpopulate(val, "TargetResourceName", &r.TargetResourceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLDatabaseResourceSettings.
func (s SQLDatabaseResourceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["resourceType"] = "Microsoft.Sql/servers/databases"
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "targetResourceGroupName", s.TargetResourceGroupName)
	populate(objectMap, "targetResourceName", s.TargetResourceName)
	populate(objectMap, "zoneRedundant", s.ZoneRedundant)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLDatabaseResourceSettings.
func (s *SQLDatabaseResourceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceType":
			err = unpopulate(val, "ResourceType", &s.ResourceType)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "targetResourceGroupName":
			err = unpopulate(val, "TargetResourceGroupName", &s.TargetResourceGroupName)
			delete(rawMsg, key)
		case "targetResourceName":
			err = unpopulate(val, "TargetResourceName", &s.TargetResourceName)
			delete(rawMsg, key)
		case "zoneRedundant":
			err = unpopulate(val, "ZoneRedundant", &s.ZoneRedundant)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLElasticPoolResourceSettings.
func (s SQLElasticPoolResourceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["resourceType"] = "Microsoft.Sql/servers/elasticPools"
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "targetResourceGroupName", s.TargetResourceGroupName)
	populate(objectMap, "targetResourceName", s.TargetResourceName)
	populate(objectMap, "zoneRedundant", s.ZoneRedundant)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLElasticPoolResourceSettings.
func (s *SQLElasticPoolResourceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceType":
			err = unpopulate(val, "ResourceType", &s.ResourceType)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "targetResourceGroupName":
			err = unpopulate(val, "TargetResourceGroupName", &s.TargetResourceGroupName)
			delete(rawMsg, key)
		case "targetResourceName":
			err = unpopulate(val, "TargetResourceName", &s.TargetResourceName)
			delete(rawMsg, key)
		case "zoneRedundant":
			err = unpopulate(val, "ZoneRedundant", &s.ZoneRedundant)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLServerResourceSettings.
func (s SQLServerResourceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["resourceType"] = "Microsoft.Sql/servers"
	populate(objectMap, "targetResourceGroupName", s.TargetResourceGroupName)
	populate(objectMap, "targetResourceName", s.TargetResourceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLServerResourceSettings.
func (s *SQLServerResourceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceType":
			err = unpopulate(val, "ResourceType", &s.ResourceType)
			delete(rawMsg, key)
		case "targetResourceGroupName":
			err = unpopulate(val, "TargetResourceGroupName", &s.TargetResourceGroupName)
			delete(rawMsg, key)
		case "targetResourceName":
			err = unpopulate(val, "TargetResourceName", &s.TargetResourceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubnetReference.
func (s SubnetReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "sourceArmResourceId", s.SourceArmResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubnetReference.
func (s *SubnetReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "sourceArmResourceId":
			err = unpopulate(val, "SourceArmResourceID", &s.SourceArmResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubnetResourceSettings.
func (s SubnetResourceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressPrefix", s.AddressPrefix)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "networkSecurityGroup", s.NetworkSecurityGroup)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubnetResourceSettings.
func (s *SubnetResourceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressPrefix":
			err = unpopulate(val, "AddressPrefix", &s.AddressPrefix)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "networkSecurityGroup":
			err = unpopulate(val, "NetworkSecurityGroup", &s.NetworkSecurityGroup)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Summary.
func (s Summary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", s.Count)
	populate(objectMap, "item", s.Item)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Summary.
func (s *Summary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &s.Count)
			delete(rawMsg, key)
		case "item":
			err = unpopulate(val, "Item", &s.Item)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SummaryCollection.
func (s SummaryCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fieldName", s.FieldName)
	populate(objectMap, "summary", s.Summary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SummaryCollection.
func (s *SummaryCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fieldName":
			err = unpopulate(val, "FieldName", &s.FieldName)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &s.Summary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UnresolvedDependenciesFilter.
func (u UnresolvedDependenciesFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UnresolvedDependenciesFilter.
func (u *UnresolvedDependenciesFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UnresolvedDependenciesFilterProperties.
func (u UnresolvedDependenciesFilterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", u.Count)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UnresolvedDependenciesFilterProperties.
func (u *UnresolvedDependenciesFilterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &u.Count)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UnresolvedDependency.
func (u UnresolvedDependency) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", u.Count)
	populate(objectMap, "id", u.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UnresolvedDependency.
func (u *UnresolvedDependency) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &u.Count)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &u.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UnresolvedDependencyCollection.
func (u UnresolvedDependencyCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", u.NextLink)
	populate(objectMap, "summaryCollection", u.SummaryCollection)
	populate(objectMap, "totalCount", u.TotalCount)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UnresolvedDependencyCollection.
func (u *UnresolvedDependencyCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &u.NextLink)
			delete(rawMsg, key)
		case "summaryCollection":
			err = unpopulate(val, "SummaryCollection", &u.SummaryCollection)
			delete(rawMsg, key)
		case "totalCount":
			err = unpopulate(val, "TotalCount", &u.TotalCount)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateMoveCollectionRequest.
func (u UpdateMoveCollectionRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", u.Identity)
	populate(objectMap, "tags", u.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateMoveCollectionRequest.
func (u *UpdateMoveCollectionRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &u.Identity)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &u.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineResourceSettings.
func (v VirtualMachineResourceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["resourceType"] = "Microsoft.Compute/virtualMachines"
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "targetAvailabilitySetId", v.TargetAvailabilitySetID)
	populate(objectMap, "targetAvailabilityZone", v.TargetAvailabilityZone)
	populate(objectMap, "targetResourceGroupName", v.TargetResourceGroupName)
	populate(objectMap, "targetResourceName", v.TargetResourceName)
	populate(objectMap, "targetVmSize", v.TargetVMSize)
	populate(objectMap, "userManagedIdentities", v.UserManagedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineResourceSettings.
func (v *VirtualMachineResourceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceType":
			err = unpopulate(val, "ResourceType", &v.ResourceType)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "targetAvailabilitySetId":
			err = unpopulate(val, "TargetAvailabilitySetID", &v.TargetAvailabilitySetID)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &v.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetResourceGroupName":
			err = unpopulate(val, "TargetResourceGroupName", &v.TargetResourceGroupName)
			delete(rawMsg, key)
		case "targetResourceName":
			err = unpopulate(val, "TargetResourceName", &v.TargetResourceName)
			delete(rawMsg, key)
		case "targetVmSize":
			err = unpopulate(val, "TargetVMSize", &v.TargetVMSize)
			delete(rawMsg, key)
		case "userManagedIdentities":
			err = unpopulate(val, "UserManagedIdentities", &v.UserManagedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkResourceSettings.
func (v VirtualNetworkResourceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressSpace", v.AddressSpace)
	populate(objectMap, "dnsServers", v.DNSServers)
	populate(objectMap, "enableDdosProtection", v.EnableDdosProtection)
	objectMap["resourceType"] = "Microsoft.Network/virtualNetworks"
	populate(objectMap, "subnets", v.Subnets)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "targetResourceGroupName", v.TargetResourceGroupName)
	populate(objectMap, "targetResourceName", v.TargetResourceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkResourceSettings.
func (v *VirtualNetworkResourceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressSpace":
			err = unpopulate(val, "AddressSpace", &v.AddressSpace)
			delete(rawMsg, key)
		case "dnsServers":
			err = unpopulate(val, "DNSServers", &v.DNSServers)
			delete(rawMsg, key)
		case "enableDdosProtection":
			err = unpopulate(val, "EnableDdosProtection", &v.EnableDdosProtection)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &v.ResourceType)
			delete(rawMsg, key)
		case "subnets":
			err = unpopulate(val, "Subnets", &v.Subnets)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "targetResourceGroupName":
			err = unpopulate(val, "TargetResourceGroupName", &v.TargetResourceGroupName)
			delete(rawMsg, key)
		case "targetResourceName":
			err = unpopulate(val, "TargetResourceName", &v.TargetResourceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
