//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resourcemover/armresourcemover"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// MoveCollectionsServer is a fake server for instances of the armresourcemover.MoveCollectionsClient type.
type MoveCollectionsServer struct {
	// BeginBulkRemove is the fake for method MoveCollectionsClient.BeginBulkRemove
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginBulkRemove func(ctx context.Context, resourceGroupName string, moveCollectionName string, options *armresourcemover.MoveCollectionsClientBeginBulkRemoveOptions) (resp azfake.PollerResponder[armresourcemover.MoveCollectionsClientBulkRemoveResponse], errResp azfake.ErrorResponder)

	// BeginCommit is the fake for method MoveCollectionsClient.BeginCommit
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCommit func(ctx context.Context, resourceGroupName string, moveCollectionName string, options *armresourcemover.MoveCollectionsClientBeginCommitOptions) (resp azfake.PollerResponder[armresourcemover.MoveCollectionsClientCommitResponse], errResp azfake.ErrorResponder)

	// Create is the fake for method MoveCollectionsClient.Create
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Create func(ctx context.Context, resourceGroupName string, moveCollectionName string, options *armresourcemover.MoveCollectionsClientCreateOptions) (resp azfake.Responder[armresourcemover.MoveCollectionsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method MoveCollectionsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, moveCollectionName string, options *armresourcemover.MoveCollectionsClientBeginDeleteOptions) (resp azfake.PollerResponder[armresourcemover.MoveCollectionsClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDiscard is the fake for method MoveCollectionsClient.BeginDiscard
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDiscard func(ctx context.Context, resourceGroupName string, moveCollectionName string, options *armresourcemover.MoveCollectionsClientBeginDiscardOptions) (resp azfake.PollerResponder[armresourcemover.MoveCollectionsClientDiscardResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method MoveCollectionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, moveCollectionName string, options *armresourcemover.MoveCollectionsClientGetOptions) (resp azfake.Responder[armresourcemover.MoveCollectionsClientGetResponse], errResp azfake.ErrorResponder)

	// BeginInitiateMove is the fake for method MoveCollectionsClient.BeginInitiateMove
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginInitiateMove func(ctx context.Context, resourceGroupName string, moveCollectionName string, options *armresourcemover.MoveCollectionsClientBeginInitiateMoveOptions) (resp azfake.PollerResponder[armresourcemover.MoveCollectionsClientInitiateMoveResponse], errResp azfake.ErrorResponder)

	// NewListMoveCollectionsByResourceGroupPager is the fake for method MoveCollectionsClient.NewListMoveCollectionsByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMoveCollectionsByResourceGroupPager func(resourceGroupName string, options *armresourcemover.MoveCollectionsClientListMoveCollectionsByResourceGroupOptions) (resp azfake.PagerResponder[armresourcemover.MoveCollectionsClientListMoveCollectionsByResourceGroupResponse])

	// NewListMoveCollectionsBySubscriptionPager is the fake for method MoveCollectionsClient.NewListMoveCollectionsBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMoveCollectionsBySubscriptionPager func(options *armresourcemover.MoveCollectionsClientListMoveCollectionsBySubscriptionOptions) (resp azfake.PagerResponder[armresourcemover.MoveCollectionsClientListMoveCollectionsBySubscriptionResponse])

	// ListRequiredFor is the fake for method MoveCollectionsClient.ListRequiredFor
	// HTTP status codes to indicate success: http.StatusOK
	ListRequiredFor func(ctx context.Context, resourceGroupName string, moveCollectionName string, sourceID string, options *armresourcemover.MoveCollectionsClientListRequiredForOptions) (resp azfake.Responder[armresourcemover.MoveCollectionsClientListRequiredForResponse], errResp azfake.ErrorResponder)

	// BeginPrepare is the fake for method MoveCollectionsClient.BeginPrepare
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginPrepare func(ctx context.Context, resourceGroupName string, moveCollectionName string, options *armresourcemover.MoveCollectionsClientBeginPrepareOptions) (resp azfake.PollerResponder[armresourcemover.MoveCollectionsClientPrepareResponse], errResp azfake.ErrorResponder)

	// BeginResolveDependencies is the fake for method MoveCollectionsClient.BeginResolveDependencies
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginResolveDependencies func(ctx context.Context, resourceGroupName string, moveCollectionName string, options *armresourcemover.MoveCollectionsClientBeginResolveDependenciesOptions) (resp azfake.PollerResponder[armresourcemover.MoveCollectionsClientResolveDependenciesResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method MoveCollectionsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, moveCollectionName string, options *armresourcemover.MoveCollectionsClientUpdateOptions) (resp azfake.Responder[armresourcemover.MoveCollectionsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewMoveCollectionsServerTransport creates a new instance of MoveCollectionsServerTransport with the provided implementation.
// The returned MoveCollectionsServerTransport instance is connected to an instance of armresourcemover.MoveCollectionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMoveCollectionsServerTransport(srv *MoveCollectionsServer) *MoveCollectionsServerTransport {
	return &MoveCollectionsServerTransport{
		srv:               srv,
		beginBulkRemove:   newTracker[azfake.PollerResponder[armresourcemover.MoveCollectionsClientBulkRemoveResponse]](),
		beginCommit:       newTracker[azfake.PollerResponder[armresourcemover.MoveCollectionsClientCommitResponse]](),
		beginDelete:       newTracker[azfake.PollerResponder[armresourcemover.MoveCollectionsClientDeleteResponse]](),
		beginDiscard:      newTracker[azfake.PollerResponder[armresourcemover.MoveCollectionsClientDiscardResponse]](),
		beginInitiateMove: newTracker[azfake.PollerResponder[armresourcemover.MoveCollectionsClientInitiateMoveResponse]](),
		newListMoveCollectionsByResourceGroupPager: newTracker[azfake.PagerResponder[armresourcemover.MoveCollectionsClientListMoveCollectionsByResourceGroupResponse]](),
		newListMoveCollectionsBySubscriptionPager:  newTracker[azfake.PagerResponder[armresourcemover.MoveCollectionsClientListMoveCollectionsBySubscriptionResponse]](),
		beginPrepare:             newTracker[azfake.PollerResponder[armresourcemover.MoveCollectionsClientPrepareResponse]](),
		beginResolveDependencies: newTracker[azfake.PollerResponder[armresourcemover.MoveCollectionsClientResolveDependenciesResponse]](),
	}
}

// MoveCollectionsServerTransport connects instances of armresourcemover.MoveCollectionsClient to instances of MoveCollectionsServer.
// Don't use this type directly, use NewMoveCollectionsServerTransport instead.
type MoveCollectionsServerTransport struct {
	srv                                        *MoveCollectionsServer
	beginBulkRemove                            *tracker[azfake.PollerResponder[armresourcemover.MoveCollectionsClientBulkRemoveResponse]]
	beginCommit                                *tracker[azfake.PollerResponder[armresourcemover.MoveCollectionsClientCommitResponse]]
	beginDelete                                *tracker[azfake.PollerResponder[armresourcemover.MoveCollectionsClientDeleteResponse]]
	beginDiscard                               *tracker[azfake.PollerResponder[armresourcemover.MoveCollectionsClientDiscardResponse]]
	beginInitiateMove                          *tracker[azfake.PollerResponder[armresourcemover.MoveCollectionsClientInitiateMoveResponse]]
	newListMoveCollectionsByResourceGroupPager *tracker[azfake.PagerResponder[armresourcemover.MoveCollectionsClientListMoveCollectionsByResourceGroupResponse]]
	newListMoveCollectionsBySubscriptionPager  *tracker[azfake.PagerResponder[armresourcemover.MoveCollectionsClientListMoveCollectionsBySubscriptionResponse]]
	beginPrepare                               *tracker[azfake.PollerResponder[armresourcemover.MoveCollectionsClientPrepareResponse]]
	beginResolveDependencies                   *tracker[azfake.PollerResponder[armresourcemover.MoveCollectionsClientResolveDependenciesResponse]]
}

// Do implements the policy.Transporter interface for MoveCollectionsServerTransport.
func (m *MoveCollectionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MoveCollectionsClient.BeginBulkRemove":
		resp, err = m.dispatchBeginBulkRemove(req)
	case "MoveCollectionsClient.BeginCommit":
		resp, err = m.dispatchBeginCommit(req)
	case "MoveCollectionsClient.Create":
		resp, err = m.dispatchCreate(req)
	case "MoveCollectionsClient.BeginDelete":
		resp, err = m.dispatchBeginDelete(req)
	case "MoveCollectionsClient.BeginDiscard":
		resp, err = m.dispatchBeginDiscard(req)
	case "MoveCollectionsClient.Get":
		resp, err = m.dispatchGet(req)
	case "MoveCollectionsClient.BeginInitiateMove":
		resp, err = m.dispatchBeginInitiateMove(req)
	case "MoveCollectionsClient.NewListMoveCollectionsByResourceGroupPager":
		resp, err = m.dispatchNewListMoveCollectionsByResourceGroupPager(req)
	case "MoveCollectionsClient.NewListMoveCollectionsBySubscriptionPager":
		resp, err = m.dispatchNewListMoveCollectionsBySubscriptionPager(req)
	case "MoveCollectionsClient.ListRequiredFor":
		resp, err = m.dispatchListRequiredFor(req)
	case "MoveCollectionsClient.BeginPrepare":
		resp, err = m.dispatchBeginPrepare(req)
	case "MoveCollectionsClient.BeginResolveDependencies":
		resp, err = m.dispatchBeginResolveDependencies(req)
	case "MoveCollectionsClient.Update":
		resp, err = m.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MoveCollectionsServerTransport) dispatchBeginBulkRemove(req *http.Request) (*http.Response, error) {
	if m.srv.BeginBulkRemove == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginBulkRemove not implemented")}
	}
	beginBulkRemove := m.beginBulkRemove.get(req)
	if beginBulkRemove == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/moveCollections/(?P<moveCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/bulkRemove`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armresourcemover.BulkRemoveRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		moveCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("moveCollectionName")])
		if err != nil {
			return nil, err
		}
		var options *armresourcemover.MoveCollectionsClientBeginBulkRemoveOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armresourcemover.MoveCollectionsClientBeginBulkRemoveOptions{
				Body: &body,
			}
		}
		respr, errRespr := m.srv.BeginBulkRemove(req.Context(), resourceGroupNameParam, moveCollectionNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginBulkRemove = &respr
		m.beginBulkRemove.add(req, beginBulkRemove)
	}

	resp, err := server.PollerResponderNext(beginBulkRemove, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginBulkRemove.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginBulkRemove) {
		m.beginBulkRemove.remove(req)
	}

	return resp, nil
}

func (m *MoveCollectionsServerTransport) dispatchBeginCommit(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCommit == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCommit not implemented")}
	}
	beginCommit := m.beginCommit.get(req)
	if beginCommit == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/moveCollections/(?P<moveCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/commit`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armresourcemover.CommitRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		moveCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("moveCollectionName")])
		if err != nil {
			return nil, err
		}
		var options *armresourcemover.MoveCollectionsClientBeginCommitOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armresourcemover.MoveCollectionsClientBeginCommitOptions{
				Body: &body,
			}
		}
		respr, errRespr := m.srv.BeginCommit(req.Context(), resourceGroupNameParam, moveCollectionNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCommit = &respr
		m.beginCommit.add(req, beginCommit)
	}

	resp, err := server.PollerResponderNext(beginCommit, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginCommit.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCommit) {
		m.beginCommit.remove(req)
	}

	return resp, nil
}

func (m *MoveCollectionsServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if m.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/moveCollections/(?P<moveCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armresourcemover.MoveCollection](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	moveCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("moveCollectionName")])
	if err != nil {
		return nil, err
	}
	var options *armresourcemover.MoveCollectionsClientCreateOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armresourcemover.MoveCollectionsClientCreateOptions{
			Body: &body,
		}
	}
	respr, errRespr := m.srv.Create(req.Context(), resourceGroupNameParam, moveCollectionNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MoveCollection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MoveCollectionsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if m.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := m.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/moveCollections/(?P<moveCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		moveCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("moveCollectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginDelete(req.Context(), resourceGroupNameParam, moveCollectionNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		m.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		m.beginDelete.remove(req)
	}

	return resp, nil
}

func (m *MoveCollectionsServerTransport) dispatchBeginDiscard(req *http.Request) (*http.Response, error) {
	if m.srv.BeginDiscard == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDiscard not implemented")}
	}
	beginDiscard := m.beginDiscard.get(req)
	if beginDiscard == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/moveCollections/(?P<moveCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/discard`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armresourcemover.DiscardRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		moveCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("moveCollectionName")])
		if err != nil {
			return nil, err
		}
		var options *armresourcemover.MoveCollectionsClientBeginDiscardOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armresourcemover.MoveCollectionsClientBeginDiscardOptions{
				Body: &body,
			}
		}
		respr, errRespr := m.srv.BeginDiscard(req.Context(), resourceGroupNameParam, moveCollectionNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDiscard = &respr
		m.beginDiscard.add(req, beginDiscard)
	}

	resp, err := server.PollerResponderNext(beginDiscard, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginDiscard.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDiscard) {
		m.beginDiscard.remove(req)
	}

	return resp, nil
}

func (m *MoveCollectionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/moveCollections/(?P<moveCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	moveCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("moveCollectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), resourceGroupNameParam, moveCollectionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MoveCollection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MoveCollectionsServerTransport) dispatchBeginInitiateMove(req *http.Request) (*http.Response, error) {
	if m.srv.BeginInitiateMove == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginInitiateMove not implemented")}
	}
	beginInitiateMove := m.beginInitiateMove.get(req)
	if beginInitiateMove == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/moveCollections/(?P<moveCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/initiateMove`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armresourcemover.ResourceMoveRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		moveCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("moveCollectionName")])
		if err != nil {
			return nil, err
		}
		var options *armresourcemover.MoveCollectionsClientBeginInitiateMoveOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armresourcemover.MoveCollectionsClientBeginInitiateMoveOptions{
				Body: &body,
			}
		}
		respr, errRespr := m.srv.BeginInitiateMove(req.Context(), resourceGroupNameParam, moveCollectionNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginInitiateMove = &respr
		m.beginInitiateMove.add(req, beginInitiateMove)
	}

	resp, err := server.PollerResponderNext(beginInitiateMove, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginInitiateMove.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginInitiateMove) {
		m.beginInitiateMove.remove(req)
	}

	return resp, nil
}

func (m *MoveCollectionsServerTransport) dispatchNewListMoveCollectionsByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListMoveCollectionsByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMoveCollectionsByResourceGroupPager not implemented")}
	}
	newListMoveCollectionsByResourceGroupPager := m.newListMoveCollectionsByResourceGroupPager.get(req)
	if newListMoveCollectionsByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/moveCollections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListMoveCollectionsByResourceGroupPager(resourceGroupNameParam, nil)
		newListMoveCollectionsByResourceGroupPager = &resp
		m.newListMoveCollectionsByResourceGroupPager.add(req, newListMoveCollectionsByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListMoveCollectionsByResourceGroupPager, req, func(page *armresourcemover.MoveCollectionsClientListMoveCollectionsByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListMoveCollectionsByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListMoveCollectionsByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMoveCollectionsByResourceGroupPager) {
		m.newListMoveCollectionsByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (m *MoveCollectionsServerTransport) dispatchNewListMoveCollectionsBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListMoveCollectionsBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMoveCollectionsBySubscriptionPager not implemented")}
	}
	newListMoveCollectionsBySubscriptionPager := m.newListMoveCollectionsBySubscriptionPager.get(req)
	if newListMoveCollectionsBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/moveCollections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := m.srv.NewListMoveCollectionsBySubscriptionPager(nil)
		newListMoveCollectionsBySubscriptionPager = &resp
		m.newListMoveCollectionsBySubscriptionPager.add(req, newListMoveCollectionsBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListMoveCollectionsBySubscriptionPager, req, func(page *armresourcemover.MoveCollectionsClientListMoveCollectionsBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListMoveCollectionsBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListMoveCollectionsBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMoveCollectionsBySubscriptionPager) {
		m.newListMoveCollectionsBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (m *MoveCollectionsServerTransport) dispatchListRequiredFor(req *http.Request) (*http.Response, error) {
	if m.srv.ListRequiredFor == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListRequiredFor not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/moveCollections/(?P<moveCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/requiredFor`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	moveCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("moveCollectionName")])
	if err != nil {
		return nil, err
	}
	sourceIDParam, err := url.QueryUnescape(qp.Get("sourceId"))
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.ListRequiredFor(req.Context(), resourceGroupNameParam, moveCollectionNameParam, sourceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RequiredForResourcesCollection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MoveCollectionsServerTransport) dispatchBeginPrepare(req *http.Request) (*http.Response, error) {
	if m.srv.BeginPrepare == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPrepare not implemented")}
	}
	beginPrepare := m.beginPrepare.get(req)
	if beginPrepare == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/moveCollections/(?P<moveCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/prepare`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armresourcemover.PrepareRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		moveCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("moveCollectionName")])
		if err != nil {
			return nil, err
		}
		var options *armresourcemover.MoveCollectionsClientBeginPrepareOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armresourcemover.MoveCollectionsClientBeginPrepareOptions{
				Body: &body,
			}
		}
		respr, errRespr := m.srv.BeginPrepare(req.Context(), resourceGroupNameParam, moveCollectionNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPrepare = &respr
		m.beginPrepare.add(req, beginPrepare)
	}

	resp, err := server.PollerResponderNext(beginPrepare, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginPrepare.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPrepare) {
		m.beginPrepare.remove(req)
	}

	return resp, nil
}

func (m *MoveCollectionsServerTransport) dispatchBeginResolveDependencies(req *http.Request) (*http.Response, error) {
	if m.srv.BeginResolveDependencies == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginResolveDependencies not implemented")}
	}
	beginResolveDependencies := m.beginResolveDependencies.get(req)
	if beginResolveDependencies == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/moveCollections/(?P<moveCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resolveDependencies`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		moveCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("moveCollectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginResolveDependencies(req.Context(), resourceGroupNameParam, moveCollectionNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginResolveDependencies = &respr
		m.beginResolveDependencies.add(req, beginResolveDependencies)
	}

	resp, err := server.PollerResponderNext(beginResolveDependencies, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginResolveDependencies.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginResolveDependencies) {
		m.beginResolveDependencies.remove(req)
	}

	return resp, nil
}

func (m *MoveCollectionsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/moveCollections/(?P<moveCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armresourcemover.UpdateMoveCollectionRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	moveCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("moveCollectionName")])
	if err != nil {
		return nil, err
	}
	var options *armresourcemover.MoveCollectionsClientUpdateOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armresourcemover.MoveCollectionsClientUpdateOptions{
			Body: &body,
		}
	}
	respr, errRespr := m.srv.Update(req.Context(), resourceGroupNameParam, moveCollectionNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MoveCollection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
