//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resourcehealth/armresourcehealth"
	"net/http"
	"net/url"
	"regexp"
)

// SecurityAdvisoryImpactedResourcesServer is a fake server for instances of the armresourcehealth.SecurityAdvisoryImpactedResourcesClient type.
type SecurityAdvisoryImpactedResourcesServer struct {
	// NewListBySubscriptionIDAndEventIDPager is the fake for method SecurityAdvisoryImpactedResourcesClient.NewListBySubscriptionIDAndEventIDPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionIDAndEventIDPager func(eventTrackingID string, options *armresourcehealth.SecurityAdvisoryImpactedResourcesClientListBySubscriptionIDAndEventIDOptions) (resp azfake.PagerResponder[armresourcehealth.SecurityAdvisoryImpactedResourcesClientListBySubscriptionIDAndEventIDResponse])

	// NewListByTenantIDAndEventIDPager is the fake for method SecurityAdvisoryImpactedResourcesClient.NewListByTenantIDAndEventIDPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByTenantIDAndEventIDPager func(eventTrackingID string, options *armresourcehealth.SecurityAdvisoryImpactedResourcesClientListByTenantIDAndEventIDOptions) (resp azfake.PagerResponder[armresourcehealth.SecurityAdvisoryImpactedResourcesClientListByTenantIDAndEventIDResponse])
}

// NewSecurityAdvisoryImpactedResourcesServerTransport creates a new instance of SecurityAdvisoryImpactedResourcesServerTransport with the provided implementation.
// The returned SecurityAdvisoryImpactedResourcesServerTransport instance is connected to an instance of armresourcehealth.SecurityAdvisoryImpactedResourcesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSecurityAdvisoryImpactedResourcesServerTransport(srv *SecurityAdvisoryImpactedResourcesServer) *SecurityAdvisoryImpactedResourcesServerTransport {
	return &SecurityAdvisoryImpactedResourcesServerTransport{
		srv:                                    srv,
		newListBySubscriptionIDAndEventIDPager: newTracker[azfake.PagerResponder[armresourcehealth.SecurityAdvisoryImpactedResourcesClientListBySubscriptionIDAndEventIDResponse]](),
		newListByTenantIDAndEventIDPager:       newTracker[azfake.PagerResponder[armresourcehealth.SecurityAdvisoryImpactedResourcesClientListByTenantIDAndEventIDResponse]](),
	}
}

// SecurityAdvisoryImpactedResourcesServerTransport connects instances of armresourcehealth.SecurityAdvisoryImpactedResourcesClient to instances of SecurityAdvisoryImpactedResourcesServer.
// Don't use this type directly, use NewSecurityAdvisoryImpactedResourcesServerTransport instead.
type SecurityAdvisoryImpactedResourcesServerTransport struct {
	srv                                    *SecurityAdvisoryImpactedResourcesServer
	newListBySubscriptionIDAndEventIDPager *tracker[azfake.PagerResponder[armresourcehealth.SecurityAdvisoryImpactedResourcesClientListBySubscriptionIDAndEventIDResponse]]
	newListByTenantIDAndEventIDPager       *tracker[azfake.PagerResponder[armresourcehealth.SecurityAdvisoryImpactedResourcesClientListByTenantIDAndEventIDResponse]]
}

// Do implements the policy.Transporter interface for SecurityAdvisoryImpactedResourcesServerTransport.
func (s *SecurityAdvisoryImpactedResourcesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SecurityAdvisoryImpactedResourcesClient.NewListBySubscriptionIDAndEventIDPager":
		resp, err = s.dispatchNewListBySubscriptionIDAndEventIDPager(req)
	case "SecurityAdvisoryImpactedResourcesClient.NewListByTenantIDAndEventIDPager":
		resp, err = s.dispatchNewListByTenantIDAndEventIDPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SecurityAdvisoryImpactedResourcesServerTransport) dispatchNewListBySubscriptionIDAndEventIDPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListBySubscriptionIDAndEventIDPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionIDAndEventIDPager not implemented")}
	}
	newListBySubscriptionIDAndEventIDPager := s.newListBySubscriptionIDAndEventIDPager.get(req)
	if newListBySubscriptionIDAndEventIDPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ResourceHealth/events/(?P<eventTrackingId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listSecurityAdvisoryImpactedResources`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		eventTrackingIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventTrackingId")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armresourcehealth.SecurityAdvisoryImpactedResourcesClientListBySubscriptionIDAndEventIDOptions
		if filterParam != nil {
			options = &armresourcehealth.SecurityAdvisoryImpactedResourcesClientListBySubscriptionIDAndEventIDOptions{
				Filter: filterParam,
			}
		}
		resp := s.srv.NewListBySubscriptionIDAndEventIDPager(eventTrackingIDParam, options)
		newListBySubscriptionIDAndEventIDPager = &resp
		s.newListBySubscriptionIDAndEventIDPager.add(req, newListBySubscriptionIDAndEventIDPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionIDAndEventIDPager, req, func(page *armresourcehealth.SecurityAdvisoryImpactedResourcesClientListBySubscriptionIDAndEventIDResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionIDAndEventIDPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListBySubscriptionIDAndEventIDPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionIDAndEventIDPager) {
		s.newListBySubscriptionIDAndEventIDPager.remove(req)
	}
	return resp, nil
}

func (s *SecurityAdvisoryImpactedResourcesServerTransport) dispatchNewListByTenantIDAndEventIDPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByTenantIDAndEventIDPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByTenantIDAndEventIDPager not implemented")}
	}
	newListByTenantIDAndEventIDPager := s.newListByTenantIDAndEventIDPager.get(req)
	if newListByTenantIDAndEventIDPager == nil {
		const regexStr = `/providers/Microsoft\.ResourceHealth/events/(?P<eventTrackingId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listSecurityAdvisoryImpactedResources`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		eventTrackingIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventTrackingId")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armresourcehealth.SecurityAdvisoryImpactedResourcesClientListByTenantIDAndEventIDOptions
		if filterParam != nil {
			options = &armresourcehealth.SecurityAdvisoryImpactedResourcesClientListByTenantIDAndEventIDOptions{
				Filter: filterParam,
			}
		}
		resp := s.srv.NewListByTenantIDAndEventIDPager(eventTrackingIDParam, options)
		newListByTenantIDAndEventIDPager = &resp
		s.newListByTenantIDAndEventIDPager.add(req, newListByTenantIDAndEventIDPager)
		server.PagerResponderInjectNextLinks(newListByTenantIDAndEventIDPager, req, func(page *armresourcehealth.SecurityAdvisoryImpactedResourcesClientListByTenantIDAndEventIDResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByTenantIDAndEventIDPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByTenantIDAndEventIDPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByTenantIDAndEventIDPager) {
		s.newListByTenantIDAndEventIDPager.remove(req)
	}
	return resp, nil
}
