//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/redis/armredis/v3"
	"net/http"
	"net/url"
	"regexp"
)

// PrivateLinkResourcesServer is a fake server for instances of the armredis.PrivateLinkResourcesClient type.
type PrivateLinkResourcesServer struct {
	// NewListByRedisCachePager is the fake for method PrivateLinkResourcesClient.NewListByRedisCachePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByRedisCachePager func(resourceGroupName string, cacheName string, options *armredis.PrivateLinkResourcesClientListByRedisCacheOptions) (resp azfake.PagerResponder[armredis.PrivateLinkResourcesClientListByRedisCacheResponse])
}

// NewPrivateLinkResourcesServerTransport creates a new instance of PrivateLinkResourcesServerTransport with the provided implementation.
// The returned PrivateLinkResourcesServerTransport instance is connected to an instance of armredis.PrivateLinkResourcesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPrivateLinkResourcesServerTransport(srv *PrivateLinkResourcesServer) *PrivateLinkResourcesServerTransport {
	return &PrivateLinkResourcesServerTransport{
		srv:                      srv,
		newListByRedisCachePager: newTracker[azfake.PagerResponder[armredis.PrivateLinkResourcesClientListByRedisCacheResponse]](),
	}
}

// PrivateLinkResourcesServerTransport connects instances of armredis.PrivateLinkResourcesClient to instances of PrivateLinkResourcesServer.
// Don't use this type directly, use NewPrivateLinkResourcesServerTransport instead.
type PrivateLinkResourcesServerTransport struct {
	srv                      *PrivateLinkResourcesServer
	newListByRedisCachePager *tracker[azfake.PagerResponder[armredis.PrivateLinkResourcesClientListByRedisCacheResponse]]
}

// Do implements the policy.Transporter interface for PrivateLinkResourcesServerTransport.
func (p *PrivateLinkResourcesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PrivateLinkResourcesClient.NewListByRedisCachePager":
		resp, err = p.dispatchNewListByRedisCachePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PrivateLinkResourcesServerTransport) dispatchNewListByRedisCachePager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByRedisCachePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByRedisCachePager not implemented")}
	}
	newListByRedisCachePager := p.newListByRedisCachePager.get(req)
	if newListByRedisCachePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cache/redis/(?P<cacheName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateLinkResources`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cacheNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cacheName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListByRedisCachePager(resourceGroupNameParam, cacheNameParam, nil)
		newListByRedisCachePager = &resp
		p.newListByRedisCachePager.add(req, newListByRedisCachePager)
	}
	resp, err := server.PagerResponderNext(newListByRedisCachePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByRedisCachePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByRedisCachePager) {
		p.newListByRedisCachePager.remove(req)
	}
	return resp, nil
}
