//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armrecoveryservicessiterecovery_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicessiterecovery/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationLogicalNetworks_ListByReplicationFabrics.json
func ExampleReplicationLogicalNetworksClient_NewListByReplicationFabricsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicessiterecovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewReplicationLogicalNetworksClient().NewListByReplicationFabricsPager("vault1", "resourceGroupPS1", "cloud1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.LogicalNetworkCollection = armrecoveryservicessiterecovery.LogicalNetworkCollection{
		// 	Value: []*armrecoveryservicessiterecovery.LogicalNetwork{
		// 		{
		// 			Name: to.Ptr("87ab394f-165f-4aa9-bd84-b018500b4509"),
		// 			Type: to.Ptr("Microsoft.RecoveryServices/vaults/replicationFabrics/replicationLogicalNetworks"),
		// 			ID: to.Ptr("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud1/replicationLogicalNetworks/53f5a278-ae85-4001-bd5f-f6a02e1f579d"),
		// 			Properties: &armrecoveryservicessiterecovery.LogicalNetworkProperties{
		// 				FriendlyName: to.Ptr("corp"),
		// 				LogicalNetworkDefinitionsStatus: to.Ptr("LogicalNetworkDefinitionsNotIsolated"),
		// 				LogicalNetworkUsage: to.Ptr("NotUsedAsPrivateNetworkForTestFailover"),
		// 				NetworkVirtualizationStatus: to.Ptr("NetworkVirtualizationNotEnabled"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("53f5a278-ae85-4001-bd5f-f6a02e1f579d"),
		// 			Type: to.Ptr("Microsoft.RecoveryServices/vaults/replicationFabrics/replicationLogicalNetworks"),
		// 			ID: to.Ptr("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud1/replicationLogicalNetworks/87ab394f-165f-4aa9-bd84-b018500b4509"),
		// 			Properties: &armrecoveryservicessiterecovery.LogicalNetworkProperties{
		// 				FriendlyName: to.Ptr("LN-VLANNetwork-4"),
		// 				LogicalNetworkDefinitionsStatus: to.Ptr("LogicalNetworkDefinitionsIsolated"),
		// 				LogicalNetworkUsage: to.Ptr("NotUsedAsPrivateNetworkForTestFailover"),
		// 				NetworkVirtualizationStatus: to.Ptr("NetworkVirtualizationNotEnabled"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationLogicalNetworks_Get.json
func ExampleReplicationLogicalNetworksClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicessiterecovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewReplicationLogicalNetworksClient().Get(ctx, "vault1", "resourceGroupPS1", "cloud1", "87ab394f-165f-4aa9-bd84-b018500b4509", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.LogicalNetwork = armrecoveryservicessiterecovery.LogicalNetwork{
	// 	Name: to.Ptr("87ab394f-165f-4aa9-bd84-b018500b4509"),
	// 	Type: to.Ptr("Microsoft.RecoveryServices/vaults/replicationFabrics/replicationLogicalNetworks"),
	// 	ID: to.Ptr("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud1/replicationLogicalNetworks/53f5a278-ae85-4001-bd5f-f6a02e1f579d"),
	// 	Properties: &armrecoveryservicessiterecovery.LogicalNetworkProperties{
	// 		FriendlyName: to.Ptr("corp"),
	// 		LogicalNetworkDefinitionsStatus: to.Ptr("LogicalNetworkDefinitionsNotIsolated"),
	// 		LogicalNetworkUsage: to.Ptr("NotUsedAsPrivateNetworkForTestFailover"),
	// 		NetworkVirtualizationStatus: to.Ptr("NetworkVirtualizationNotEnabled"),
	// 	},
	// }
}
