//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicessiterecovery/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ReplicationEligibilityResultsServer is a fake server for instances of the armrecoveryservicessiterecovery.ReplicationEligibilityResultsClient type.
type ReplicationEligibilityResultsServer struct {
	// Get is the fake for method ReplicationEligibilityResultsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, virtualMachineName string, options *armrecoveryservicessiterecovery.ReplicationEligibilityResultsClientGetOptions) (resp azfake.Responder[armrecoveryservicessiterecovery.ReplicationEligibilityResultsClientGetResponse], errResp azfake.ErrorResponder)

	// List is the fake for method ReplicationEligibilityResultsClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, resourceGroupName string, virtualMachineName string, options *armrecoveryservicessiterecovery.ReplicationEligibilityResultsClientListOptions) (resp azfake.Responder[armrecoveryservicessiterecovery.ReplicationEligibilityResultsClientListResponse], errResp azfake.ErrorResponder)
}

// NewReplicationEligibilityResultsServerTransport creates a new instance of ReplicationEligibilityResultsServerTransport with the provided implementation.
// The returned ReplicationEligibilityResultsServerTransport instance is connected to an instance of armrecoveryservicessiterecovery.ReplicationEligibilityResultsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewReplicationEligibilityResultsServerTransport(srv *ReplicationEligibilityResultsServer) *ReplicationEligibilityResultsServerTransport {
	return &ReplicationEligibilityResultsServerTransport{srv: srv}
}

// ReplicationEligibilityResultsServerTransport connects instances of armrecoveryservicessiterecovery.ReplicationEligibilityResultsClient to instances of ReplicationEligibilityResultsServer.
// Don't use this type directly, use NewReplicationEligibilityResultsServerTransport instead.
type ReplicationEligibilityResultsServerTransport struct {
	srv *ReplicationEligibilityResultsServer
}

// Do implements the policy.Transporter interface for ReplicationEligibilityResultsServerTransport.
func (r *ReplicationEligibilityResultsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ReplicationEligibilityResultsClient.Get":
		resp, err = r.dispatchGet(req)
	case "ReplicationEligibilityResultsClient.List":
		resp, err = r.dispatchList(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ReplicationEligibilityResultsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<virtualMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/replicationEligibilityResults/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	virtualMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualMachineName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), resourceGroupNameParam, virtualMachineNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ReplicationEligibilityResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ReplicationEligibilityResultsServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if r.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<virtualMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/replicationEligibilityResults`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	virtualMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualMachineName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.List(req.Context(), resourceGroupNameParam, virtualMachineNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ReplicationEligibilityResultsCollection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
