//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicesbackup/v4"
	"net/http"
	"net/url"
	"regexp"
)

// BackupResourceStorageConfigsNonCRRServer is a fake server for instances of the armrecoveryservicesbackup.BackupResourceStorageConfigsNonCRRClient type.
type BackupResourceStorageConfigsNonCRRServer struct {
	// Get is the fake for method BackupResourceStorageConfigsNonCRRClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, vaultName string, resourceGroupName string, options *armrecoveryservicesbackup.BackupResourceStorageConfigsNonCRRClientGetOptions) (resp azfake.Responder[armrecoveryservicesbackup.BackupResourceStorageConfigsNonCRRClientGetResponse], errResp azfake.ErrorResponder)

	// Patch is the fake for method BackupResourceStorageConfigsNonCRRClient.Patch
	// HTTP status codes to indicate success: http.StatusNoContent
	Patch func(ctx context.Context, vaultName string, resourceGroupName string, parameters armrecoveryservicesbackup.BackupResourceConfigResource, options *armrecoveryservicesbackup.BackupResourceStorageConfigsNonCRRClientPatchOptions) (resp azfake.Responder[armrecoveryservicesbackup.BackupResourceStorageConfigsNonCRRClientPatchResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method BackupResourceStorageConfigsNonCRRClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, vaultName string, resourceGroupName string, parameters armrecoveryservicesbackup.BackupResourceConfigResource, options *armrecoveryservicesbackup.BackupResourceStorageConfigsNonCRRClientUpdateOptions) (resp azfake.Responder[armrecoveryservicesbackup.BackupResourceStorageConfigsNonCRRClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewBackupResourceStorageConfigsNonCRRServerTransport creates a new instance of BackupResourceStorageConfigsNonCRRServerTransport with the provided implementation.
// The returned BackupResourceStorageConfigsNonCRRServerTransport instance is connected to an instance of armrecoveryservicesbackup.BackupResourceStorageConfigsNonCRRClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewBackupResourceStorageConfigsNonCRRServerTransport(srv *BackupResourceStorageConfigsNonCRRServer) *BackupResourceStorageConfigsNonCRRServerTransport {
	return &BackupResourceStorageConfigsNonCRRServerTransport{srv: srv}
}

// BackupResourceStorageConfigsNonCRRServerTransport connects instances of armrecoveryservicesbackup.BackupResourceStorageConfigsNonCRRClient to instances of BackupResourceStorageConfigsNonCRRServer.
// Don't use this type directly, use NewBackupResourceStorageConfigsNonCRRServerTransport instead.
type BackupResourceStorageConfigsNonCRRServerTransport struct {
	srv *BackupResourceStorageConfigsNonCRRServer
}

// Do implements the policy.Transporter interface for BackupResourceStorageConfigsNonCRRServerTransport.
func (b *BackupResourceStorageConfigsNonCRRServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "BackupResourceStorageConfigsNonCRRClient.Get":
		resp, err = b.dispatchGet(req)
	case "BackupResourceStorageConfigsNonCRRClient.Patch":
		resp, err = b.dispatchPatch(req)
	case "BackupResourceStorageConfigsNonCRRClient.Update":
		resp, err = b.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (b *BackupResourceStorageConfigsNonCRRServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if b.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/Subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupstorageconfig/vaultstorageconfig`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.Get(req.Context(), vaultNameParam, resourceGroupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BackupResourceConfigResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BackupResourceStorageConfigsNonCRRServerTransport) dispatchPatch(req *http.Request) (*http.Response, error) {
	if b.srv.Patch == nil {
		return nil, &nonRetriableError{errors.New("fake for method Patch not implemented")}
	}
	const regexStr = `/Subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupstorageconfig/vaultstorageconfig`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armrecoveryservicesbackup.BackupResourceConfigResource](req)
	if err != nil {
		return nil, err
	}
	vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.Patch(req.Context(), vaultNameParam, resourceGroupNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BackupResourceStorageConfigsNonCRRServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if b.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/Subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupstorageconfig/vaultstorageconfig`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armrecoveryservicesbackup.BackupResourceConfigResource](req)
	if err != nil {
		return nil, err
	}
	vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.Update(req.Context(), vaultNameParam, resourceGroupNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BackupResourceConfigResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
