//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpolicyinsights

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
	"time"
)

// PolicyStatesClient contains the methods for the PolicyStates group.
// Don't use this type directly, use NewPolicyStatesClient() instead.
type PolicyStatesClient struct {
	internal *arm.Client
}

// NewPolicyStatesClient creates a new instance of PolicyStatesClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewPolicyStatesClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*PolicyStatesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &PolicyStatesClient{
		internal: cl,
	}
	return client, nil
}

// NewListQueryResultsForManagementGroupPager - Queries policy states for the resources under the management group.
//
// Generated from API version 2019-10-01
//   - policyStatesResource - The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents
//     the latest policy state(s), whereas 'default' represents all policy state(s).
//   - managementGroupName - Management group name.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyStatesClientListQueryResultsForManagementGroupOptions contains the optional parameters for the PolicyStatesClient.NewListQueryResultsForManagementGroupPager
//     method.
func (client *PolicyStatesClient) NewListQueryResultsForManagementGroupPager(policyStatesResource PolicyStatesResource, managementGroupName string, queryOptions *QueryOptions, options *PolicyStatesClientListQueryResultsForManagementGroupOptions) *runtime.Pager[PolicyStatesClientListQueryResultsForManagementGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyStatesClientListQueryResultsForManagementGroupResponse]{
		More: func(page PolicyStatesClientListQueryResultsForManagementGroupResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyStatesClientListQueryResultsForManagementGroupResponse) (PolicyStatesClientListQueryResultsForManagementGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PolicyStatesClient.NewListQueryResultsForManagementGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.ODataNextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listQueryResultsForManagementGroupCreateRequest(ctx, policyStatesResource, managementGroupName, queryOptions, options)
			}, nil)
			if err != nil {
				return PolicyStatesClientListQueryResultsForManagementGroupResponse{}, err
			}
			return client.listQueryResultsForManagementGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listQueryResultsForManagementGroupCreateRequest creates the ListQueryResultsForManagementGroup request.
func (client *PolicyStatesClient) listQueryResultsForManagementGroupCreateRequest(ctx context.Context, policyStatesResource PolicyStatesResource, managementGroupName string, queryOptions *QueryOptions, options *PolicyStatesClientListQueryResultsForManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/{managementGroupsNamespace}/managementGroups/{managementGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults"
	if policyStatesResource == "" {
		return nil, errors.New("parameter policyStatesResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyStatesResource}", url.PathEscape(string(policyStatesResource)))
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupsNamespace}", url.PathEscape("Microsoft.Management"))
	if managementGroupName == "" {
		return nil, errors.New("parameter managementGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupName}", url.PathEscape(managementGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForManagementGroupHandleResponse handles the ListQueryResultsForManagementGroup response.
func (client *PolicyStatesClient) listQueryResultsForManagementGroupHandleResponse(resp *http.Response) (PolicyStatesClientListQueryResultsForManagementGroupResponse, error) {
	result := PolicyStatesClientListQueryResultsForManagementGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyStatesQueryResults); err != nil {
		return PolicyStatesClientListQueryResultsForManagementGroupResponse{}, err
	}
	return result, nil
}

// NewListQueryResultsForPolicyDefinitionPager - Queries policy states for the subscription level policy definition.
//
// Generated from API version 2019-10-01
//   - policyStatesResource - The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents
//     the latest policy state(s), whereas 'default' represents all policy state(s).
//   - subscriptionID - Microsoft Azure subscription ID.
//   - policyDefinitionName - Policy definition name.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyStatesClientListQueryResultsForPolicyDefinitionOptions contains the optional parameters for the PolicyStatesClient.NewListQueryResultsForPolicyDefinitionPager
//     method.
func (client *PolicyStatesClient) NewListQueryResultsForPolicyDefinitionPager(policyStatesResource PolicyStatesResource, subscriptionID string, policyDefinitionName string, queryOptions *QueryOptions, options *PolicyStatesClientListQueryResultsForPolicyDefinitionOptions) *runtime.Pager[PolicyStatesClientListQueryResultsForPolicyDefinitionResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyStatesClientListQueryResultsForPolicyDefinitionResponse]{
		More: func(page PolicyStatesClientListQueryResultsForPolicyDefinitionResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyStatesClientListQueryResultsForPolicyDefinitionResponse) (PolicyStatesClientListQueryResultsForPolicyDefinitionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PolicyStatesClient.NewListQueryResultsForPolicyDefinitionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.ODataNextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listQueryResultsForPolicyDefinitionCreateRequest(ctx, policyStatesResource, subscriptionID, policyDefinitionName, queryOptions, options)
			}, nil)
			if err != nil {
				return PolicyStatesClientListQueryResultsForPolicyDefinitionResponse{}, err
			}
			return client.listQueryResultsForPolicyDefinitionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listQueryResultsForPolicyDefinitionCreateRequest creates the ListQueryResultsForPolicyDefinition request.
func (client *PolicyStatesClient) listQueryResultsForPolicyDefinitionCreateRequest(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, policyDefinitionName string, queryOptions *QueryOptions, options *PolicyStatesClientListQueryResultsForPolicyDefinitionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyDefinitions/{policyDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults"
	if policyStatesResource == "" {
		return nil, errors.New("parameter policyStatesResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyStatesResource}", url.PathEscape(string(policyStatesResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	urlPath = strings.ReplaceAll(urlPath, "{authorizationNamespace}", url.PathEscape("Microsoft.Authorization"))
	if policyDefinitionName == "" {
		return nil, errors.New("parameter policyDefinitionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyDefinitionName}", url.PathEscape(policyDefinitionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForPolicyDefinitionHandleResponse handles the ListQueryResultsForPolicyDefinition response.
func (client *PolicyStatesClient) listQueryResultsForPolicyDefinitionHandleResponse(resp *http.Response) (PolicyStatesClientListQueryResultsForPolicyDefinitionResponse, error) {
	result := PolicyStatesClientListQueryResultsForPolicyDefinitionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyStatesQueryResults); err != nil {
		return PolicyStatesClientListQueryResultsForPolicyDefinitionResponse{}, err
	}
	return result, nil
}

// NewListQueryResultsForPolicySetDefinitionPager - Queries policy states for the subscription level policy set definition.
//
// Generated from API version 2019-10-01
//   - policyStatesResource - The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents
//     the latest policy state(s), whereas 'default' represents all policy state(s).
//   - subscriptionID - Microsoft Azure subscription ID.
//   - policySetDefinitionName - Policy set definition name.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyStatesClientListQueryResultsForPolicySetDefinitionOptions contains the optional parameters for the PolicyStatesClient.NewListQueryResultsForPolicySetDefinitionPager
//     method.
func (client *PolicyStatesClient) NewListQueryResultsForPolicySetDefinitionPager(policyStatesResource PolicyStatesResource, subscriptionID string, policySetDefinitionName string, queryOptions *QueryOptions, options *PolicyStatesClientListQueryResultsForPolicySetDefinitionOptions) *runtime.Pager[PolicyStatesClientListQueryResultsForPolicySetDefinitionResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyStatesClientListQueryResultsForPolicySetDefinitionResponse]{
		More: func(page PolicyStatesClientListQueryResultsForPolicySetDefinitionResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyStatesClientListQueryResultsForPolicySetDefinitionResponse) (PolicyStatesClientListQueryResultsForPolicySetDefinitionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PolicyStatesClient.NewListQueryResultsForPolicySetDefinitionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.ODataNextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listQueryResultsForPolicySetDefinitionCreateRequest(ctx, policyStatesResource, subscriptionID, policySetDefinitionName, queryOptions, options)
			}, nil)
			if err != nil {
				return PolicyStatesClientListQueryResultsForPolicySetDefinitionResponse{}, err
			}
			return client.listQueryResultsForPolicySetDefinitionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listQueryResultsForPolicySetDefinitionCreateRequest creates the ListQueryResultsForPolicySetDefinition request.
func (client *PolicyStatesClient) listQueryResultsForPolicySetDefinitionCreateRequest(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, policySetDefinitionName string, queryOptions *QueryOptions, options *PolicyStatesClientListQueryResultsForPolicySetDefinitionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policySetDefinitions/{policySetDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults"
	if policyStatesResource == "" {
		return nil, errors.New("parameter policyStatesResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyStatesResource}", url.PathEscape(string(policyStatesResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	urlPath = strings.ReplaceAll(urlPath, "{authorizationNamespace}", url.PathEscape("Microsoft.Authorization"))
	if policySetDefinitionName == "" {
		return nil, errors.New("parameter policySetDefinitionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policySetDefinitionName}", url.PathEscape(policySetDefinitionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForPolicySetDefinitionHandleResponse handles the ListQueryResultsForPolicySetDefinition response.
func (client *PolicyStatesClient) listQueryResultsForPolicySetDefinitionHandleResponse(resp *http.Response) (PolicyStatesClientListQueryResultsForPolicySetDefinitionResponse, error) {
	result := PolicyStatesClientListQueryResultsForPolicySetDefinitionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyStatesQueryResults); err != nil {
		return PolicyStatesClientListQueryResultsForPolicySetDefinitionResponse{}, err
	}
	return result, nil
}

// NewListQueryResultsForResourcePager - Queries policy states for the resource.
//
// Generated from API version 2019-10-01
//   - policyStatesResource - The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents
//     the latest policy state(s), whereas 'default' represents all policy state(s).
//   - resourceID - Resource ID.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyStatesClientListQueryResultsForResourceOptions contains the optional parameters for the PolicyStatesClient.NewListQueryResultsForResourcePager
//     method.
func (client *PolicyStatesClient) NewListQueryResultsForResourcePager(policyStatesResource PolicyStatesResource, resourceID string, queryOptions *QueryOptions, options *PolicyStatesClientListQueryResultsForResourceOptions) *runtime.Pager[PolicyStatesClientListQueryResultsForResourceResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyStatesClientListQueryResultsForResourceResponse]{
		More: func(page PolicyStatesClientListQueryResultsForResourceResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyStatesClientListQueryResultsForResourceResponse) (PolicyStatesClientListQueryResultsForResourceResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PolicyStatesClient.NewListQueryResultsForResourcePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.ODataNextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listQueryResultsForResourceCreateRequest(ctx, policyStatesResource, resourceID, queryOptions, options)
			}, nil)
			if err != nil {
				return PolicyStatesClientListQueryResultsForResourceResponse{}, err
			}
			return client.listQueryResultsForResourceHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listQueryResultsForResourceCreateRequest creates the ListQueryResultsForResource request.
func (client *PolicyStatesClient) listQueryResultsForResourceCreateRequest(ctx context.Context, policyStatesResource PolicyStatesResource, resourceID string, queryOptions *QueryOptions, options *PolicyStatesClientListQueryResultsForResourceOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults"
	if policyStatesResource == "" {
		return nil, errors.New("parameter policyStatesResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyStatesResource}", url.PathEscape(string(policyStatesResource)))
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.Expand != nil {
		reqQP.Set("$expand", *queryOptions.Expand)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForResourceHandleResponse handles the ListQueryResultsForResource response.
func (client *PolicyStatesClient) listQueryResultsForResourceHandleResponse(resp *http.Response) (PolicyStatesClientListQueryResultsForResourceResponse, error) {
	result := PolicyStatesClientListQueryResultsForResourceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyStatesQueryResults); err != nil {
		return PolicyStatesClientListQueryResultsForResourceResponse{}, err
	}
	return result, nil
}

// NewListQueryResultsForResourceGroupPager - Queries policy states for the resources under the resource group.
//
// Generated from API version 2019-10-01
//   - policyStatesResource - The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents
//     the latest policy state(s), whereas 'default' represents all policy state(s).
//   - subscriptionID - Microsoft Azure subscription ID.
//   - resourceGroupName - Resource group name.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyStatesClientListQueryResultsForResourceGroupOptions contains the optional parameters for the PolicyStatesClient.NewListQueryResultsForResourceGroupPager
//     method.
func (client *PolicyStatesClient) NewListQueryResultsForResourceGroupPager(policyStatesResource PolicyStatesResource, subscriptionID string, resourceGroupName string, queryOptions *QueryOptions, options *PolicyStatesClientListQueryResultsForResourceGroupOptions) *runtime.Pager[PolicyStatesClientListQueryResultsForResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyStatesClientListQueryResultsForResourceGroupResponse]{
		More: func(page PolicyStatesClientListQueryResultsForResourceGroupResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyStatesClientListQueryResultsForResourceGroupResponse) (PolicyStatesClientListQueryResultsForResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PolicyStatesClient.NewListQueryResultsForResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.ODataNextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listQueryResultsForResourceGroupCreateRequest(ctx, policyStatesResource, subscriptionID, resourceGroupName, queryOptions, options)
			}, nil)
			if err != nil {
				return PolicyStatesClientListQueryResultsForResourceGroupResponse{}, err
			}
			return client.listQueryResultsForResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listQueryResultsForResourceGroupCreateRequest creates the ListQueryResultsForResourceGroup request.
func (client *PolicyStatesClient) listQueryResultsForResourceGroupCreateRequest(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, resourceGroupName string, queryOptions *QueryOptions, options *PolicyStatesClientListQueryResultsForResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults"
	if policyStatesResource == "" {
		return nil, errors.New("parameter policyStatesResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyStatesResource}", url.PathEscape(string(policyStatesResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForResourceGroupHandleResponse handles the ListQueryResultsForResourceGroup response.
func (client *PolicyStatesClient) listQueryResultsForResourceGroupHandleResponse(resp *http.Response) (PolicyStatesClientListQueryResultsForResourceGroupResponse, error) {
	result := PolicyStatesClientListQueryResultsForResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyStatesQueryResults); err != nil {
		return PolicyStatesClientListQueryResultsForResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager - Queries policy states for the resource group level policy
// assignment.
//
// Generated from API version 2019-10-01
//   - policyStatesResource - The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents
//     the latest policy state(s), whereas 'default' represents all policy state(s).
//   - subscriptionID - Microsoft Azure subscription ID.
//   - resourceGroupName - Resource group name.
//   - policyAssignmentName - Policy assignment name.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyStatesClientListQueryResultsForResourceGroupLevelPolicyAssignmentOptions contains the optional parameters
//     for the PolicyStatesClient.NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager method.
func (client *PolicyStatesClient) NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager(policyStatesResource PolicyStatesResource, subscriptionID string, resourceGroupName string, policyAssignmentName string, queryOptions *QueryOptions, options *PolicyStatesClientListQueryResultsForResourceGroupLevelPolicyAssignmentOptions) *runtime.Pager[PolicyStatesClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyStatesClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse]{
		More: func(page PolicyStatesClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyStatesClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse) (PolicyStatesClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PolicyStatesClient.NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.ODataNextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listQueryResultsForResourceGroupLevelPolicyAssignmentCreateRequest(ctx, policyStatesResource, subscriptionID, resourceGroupName, policyAssignmentName, queryOptions, options)
			}, nil)
			if err != nil {
				return PolicyStatesClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse{}, err
			}
			return client.listQueryResultsForResourceGroupLevelPolicyAssignmentHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listQueryResultsForResourceGroupLevelPolicyAssignmentCreateRequest creates the ListQueryResultsForResourceGroupLevelPolicyAssignment request.
func (client *PolicyStatesClient) listQueryResultsForResourceGroupLevelPolicyAssignmentCreateRequest(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, resourceGroupName string, policyAssignmentName string, queryOptions *QueryOptions, options *PolicyStatesClientListQueryResultsForResourceGroupLevelPolicyAssignmentOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults"
	if policyStatesResource == "" {
		return nil, errors.New("parameter policyStatesResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyStatesResource}", url.PathEscape(string(policyStatesResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	urlPath = strings.ReplaceAll(urlPath, "{authorizationNamespace}", url.PathEscape("Microsoft.Authorization"))
	if policyAssignmentName == "" {
		return nil, errors.New("parameter policyAssignmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyAssignmentName}", url.PathEscape(policyAssignmentName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForResourceGroupLevelPolicyAssignmentHandleResponse handles the ListQueryResultsForResourceGroupLevelPolicyAssignment response.
func (client *PolicyStatesClient) listQueryResultsForResourceGroupLevelPolicyAssignmentHandleResponse(resp *http.Response) (PolicyStatesClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse, error) {
	result := PolicyStatesClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyStatesQueryResults); err != nil {
		return PolicyStatesClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse{}, err
	}
	return result, nil
}

// NewListQueryResultsForSubscriptionPager - Queries policy states for the resources under the subscription.
//
// Generated from API version 2019-10-01
//   - policyStatesResource - The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents
//     the latest policy state(s), whereas 'default' represents all policy state(s).
//   - subscriptionID - Microsoft Azure subscription ID.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyStatesClientListQueryResultsForSubscriptionOptions contains the optional parameters for the PolicyStatesClient.NewListQueryResultsForSubscriptionPager
//     method.
func (client *PolicyStatesClient) NewListQueryResultsForSubscriptionPager(policyStatesResource PolicyStatesResource, subscriptionID string, queryOptions *QueryOptions, options *PolicyStatesClientListQueryResultsForSubscriptionOptions) *runtime.Pager[PolicyStatesClientListQueryResultsForSubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyStatesClientListQueryResultsForSubscriptionResponse]{
		More: func(page PolicyStatesClientListQueryResultsForSubscriptionResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyStatesClientListQueryResultsForSubscriptionResponse) (PolicyStatesClientListQueryResultsForSubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PolicyStatesClient.NewListQueryResultsForSubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.ODataNextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listQueryResultsForSubscriptionCreateRequest(ctx, policyStatesResource, subscriptionID, queryOptions, options)
			}, nil)
			if err != nil {
				return PolicyStatesClientListQueryResultsForSubscriptionResponse{}, err
			}
			return client.listQueryResultsForSubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listQueryResultsForSubscriptionCreateRequest creates the ListQueryResultsForSubscription request.
func (client *PolicyStatesClient) listQueryResultsForSubscriptionCreateRequest(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, queryOptions *QueryOptions, options *PolicyStatesClientListQueryResultsForSubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults"
	if policyStatesResource == "" {
		return nil, errors.New("parameter policyStatesResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyStatesResource}", url.PathEscape(string(policyStatesResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForSubscriptionHandleResponse handles the ListQueryResultsForSubscription response.
func (client *PolicyStatesClient) listQueryResultsForSubscriptionHandleResponse(resp *http.Response) (PolicyStatesClientListQueryResultsForSubscriptionResponse, error) {
	result := PolicyStatesClientListQueryResultsForSubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyStatesQueryResults); err != nil {
		return PolicyStatesClientListQueryResultsForSubscriptionResponse{}, err
	}
	return result, nil
}

// NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager - Queries policy states for the subscription level policy
// assignment.
//
// Generated from API version 2019-10-01
//   - policyStatesResource - The virtual resource under PolicyStates resource type. In a given time range, 'latest' represents
//     the latest policy state(s), whereas 'default' represents all policy state(s).
//   - subscriptionID - Microsoft Azure subscription ID.
//   - policyAssignmentName - Policy assignment name.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyStatesClientListQueryResultsForSubscriptionLevelPolicyAssignmentOptions contains the optional parameters
//     for the PolicyStatesClient.NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager method.
func (client *PolicyStatesClient) NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager(policyStatesResource PolicyStatesResource, subscriptionID string, policyAssignmentName string, queryOptions *QueryOptions, options *PolicyStatesClientListQueryResultsForSubscriptionLevelPolicyAssignmentOptions) *runtime.Pager[PolicyStatesClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyStatesClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse]{
		More: func(page PolicyStatesClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyStatesClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse) (PolicyStatesClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PolicyStatesClient.NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.ODataNextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listQueryResultsForSubscriptionLevelPolicyAssignmentCreateRequest(ctx, policyStatesResource, subscriptionID, policyAssignmentName, queryOptions, options)
			}, nil)
			if err != nil {
				return PolicyStatesClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse{}, err
			}
			return client.listQueryResultsForSubscriptionLevelPolicyAssignmentHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listQueryResultsForSubscriptionLevelPolicyAssignmentCreateRequest creates the ListQueryResultsForSubscriptionLevelPolicyAssignment request.
func (client *PolicyStatesClient) listQueryResultsForSubscriptionLevelPolicyAssignmentCreateRequest(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, policyAssignmentName string, queryOptions *QueryOptions, options *PolicyStatesClientListQueryResultsForSubscriptionLevelPolicyAssignmentOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults"
	if policyStatesResource == "" {
		return nil, errors.New("parameter policyStatesResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyStatesResource}", url.PathEscape(string(policyStatesResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	urlPath = strings.ReplaceAll(urlPath, "{authorizationNamespace}", url.PathEscape("Microsoft.Authorization"))
	if policyAssignmentName == "" {
		return nil, errors.New("parameter policyAssignmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyAssignmentName}", url.PathEscape(policyAssignmentName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForSubscriptionLevelPolicyAssignmentHandleResponse handles the ListQueryResultsForSubscriptionLevelPolicyAssignment response.
func (client *PolicyStatesClient) listQueryResultsForSubscriptionLevelPolicyAssignmentHandleResponse(resp *http.Response) (PolicyStatesClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse, error) {
	result := PolicyStatesClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyStatesQueryResults); err != nil {
		return PolicyStatesClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse{}, err
	}
	return result, nil
}

// SummarizeForManagementGroup - Summarizes policy states for the resources under the management group.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-10-01
//   - policyStatesSummaryResource - The virtual resource under PolicyStates resource type for summarize action. In a given time
//     range, 'latest' represents the latest policy state(s) and is the only allowed value.
//   - managementGroupName - Management group name.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyStatesClientSummarizeForManagementGroupOptions contains the optional parameters for the PolicyStatesClient.SummarizeForManagementGroup
//     method.
func (client *PolicyStatesClient) SummarizeForManagementGroup(ctx context.Context, policyStatesSummaryResource PolicyStatesSummaryResourceType, managementGroupName string, queryOptions *QueryOptions, options *PolicyStatesClientSummarizeForManagementGroupOptions) (PolicyStatesClientSummarizeForManagementGroupResponse, error) {
	var err error
	const operationName = "PolicyStatesClient.SummarizeForManagementGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.summarizeForManagementGroupCreateRequest(ctx, policyStatesSummaryResource, managementGroupName, queryOptions, options)
	if err != nil {
		return PolicyStatesClientSummarizeForManagementGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PolicyStatesClientSummarizeForManagementGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PolicyStatesClientSummarizeForManagementGroupResponse{}, err
	}
	resp, err := client.summarizeForManagementGroupHandleResponse(httpResp)
	return resp, err
}

// summarizeForManagementGroupCreateRequest creates the SummarizeForManagementGroup request.
func (client *PolicyStatesClient) summarizeForManagementGroupCreateRequest(ctx context.Context, policyStatesSummaryResource PolicyStatesSummaryResourceType, managementGroupName string, queryOptions *QueryOptions, options *PolicyStatesClientSummarizeForManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/{managementGroupsNamespace}/managementGroups/{managementGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize"
	if policyStatesSummaryResource == "" {
		return nil, errors.New("parameter policyStatesSummaryResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyStatesSummaryResource}", url.PathEscape(string(policyStatesSummaryResource)))
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupsNamespace}", url.PathEscape("Microsoft.Management"))
	if managementGroupName == "" {
		return nil, errors.New("parameter managementGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupName}", url.PathEscape(managementGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// summarizeForManagementGroupHandleResponse handles the SummarizeForManagementGroup response.
func (client *PolicyStatesClient) summarizeForManagementGroupHandleResponse(resp *http.Response) (PolicyStatesClientSummarizeForManagementGroupResponse, error) {
	result := PolicyStatesClientSummarizeForManagementGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SummarizeResults); err != nil {
		return PolicyStatesClientSummarizeForManagementGroupResponse{}, err
	}
	return result, nil
}

// SummarizeForPolicyDefinition - Summarizes policy states for the subscription level policy definition.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-10-01
//   - policyStatesSummaryResource - The virtual resource under PolicyStates resource type for summarize action. In a given time
//     range, 'latest' represents the latest policy state(s) and is the only allowed value.
//   - subscriptionID - Microsoft Azure subscription ID.
//   - policyDefinitionName - Policy definition name.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyStatesClientSummarizeForPolicyDefinitionOptions contains the optional parameters for the PolicyStatesClient.SummarizeForPolicyDefinition
//     method.
func (client *PolicyStatesClient) SummarizeForPolicyDefinition(ctx context.Context, policyStatesSummaryResource PolicyStatesSummaryResourceType, subscriptionID string, policyDefinitionName string, queryOptions *QueryOptions, options *PolicyStatesClientSummarizeForPolicyDefinitionOptions) (PolicyStatesClientSummarizeForPolicyDefinitionResponse, error) {
	var err error
	const operationName = "PolicyStatesClient.SummarizeForPolicyDefinition"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.summarizeForPolicyDefinitionCreateRequest(ctx, policyStatesSummaryResource, subscriptionID, policyDefinitionName, queryOptions, options)
	if err != nil {
		return PolicyStatesClientSummarizeForPolicyDefinitionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PolicyStatesClientSummarizeForPolicyDefinitionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PolicyStatesClientSummarizeForPolicyDefinitionResponse{}, err
	}
	resp, err := client.summarizeForPolicyDefinitionHandleResponse(httpResp)
	return resp, err
}

// summarizeForPolicyDefinitionCreateRequest creates the SummarizeForPolicyDefinition request.
func (client *PolicyStatesClient) summarizeForPolicyDefinitionCreateRequest(ctx context.Context, policyStatesSummaryResource PolicyStatesSummaryResourceType, subscriptionID string, policyDefinitionName string, queryOptions *QueryOptions, options *PolicyStatesClientSummarizeForPolicyDefinitionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyDefinitions/{policyDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize"
	if policyStatesSummaryResource == "" {
		return nil, errors.New("parameter policyStatesSummaryResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyStatesSummaryResource}", url.PathEscape(string(policyStatesSummaryResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	urlPath = strings.ReplaceAll(urlPath, "{authorizationNamespace}", url.PathEscape("Microsoft.Authorization"))
	if policyDefinitionName == "" {
		return nil, errors.New("parameter policyDefinitionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyDefinitionName}", url.PathEscape(policyDefinitionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// summarizeForPolicyDefinitionHandleResponse handles the SummarizeForPolicyDefinition response.
func (client *PolicyStatesClient) summarizeForPolicyDefinitionHandleResponse(resp *http.Response) (PolicyStatesClientSummarizeForPolicyDefinitionResponse, error) {
	result := PolicyStatesClientSummarizeForPolicyDefinitionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SummarizeResults); err != nil {
		return PolicyStatesClientSummarizeForPolicyDefinitionResponse{}, err
	}
	return result, nil
}

// SummarizeForPolicySetDefinition - Summarizes policy states for the subscription level policy set definition.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-10-01
//   - policyStatesSummaryResource - The virtual resource under PolicyStates resource type for summarize action. In a given time
//     range, 'latest' represents the latest policy state(s) and is the only allowed value.
//   - subscriptionID - Microsoft Azure subscription ID.
//   - policySetDefinitionName - Policy set definition name.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyStatesClientSummarizeForPolicySetDefinitionOptions contains the optional parameters for the PolicyStatesClient.SummarizeForPolicySetDefinition
//     method.
func (client *PolicyStatesClient) SummarizeForPolicySetDefinition(ctx context.Context, policyStatesSummaryResource PolicyStatesSummaryResourceType, subscriptionID string, policySetDefinitionName string, queryOptions *QueryOptions, options *PolicyStatesClientSummarizeForPolicySetDefinitionOptions) (PolicyStatesClientSummarizeForPolicySetDefinitionResponse, error) {
	var err error
	const operationName = "PolicyStatesClient.SummarizeForPolicySetDefinition"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.summarizeForPolicySetDefinitionCreateRequest(ctx, policyStatesSummaryResource, subscriptionID, policySetDefinitionName, queryOptions, options)
	if err != nil {
		return PolicyStatesClientSummarizeForPolicySetDefinitionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PolicyStatesClientSummarizeForPolicySetDefinitionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PolicyStatesClientSummarizeForPolicySetDefinitionResponse{}, err
	}
	resp, err := client.summarizeForPolicySetDefinitionHandleResponse(httpResp)
	return resp, err
}

// summarizeForPolicySetDefinitionCreateRequest creates the SummarizeForPolicySetDefinition request.
func (client *PolicyStatesClient) summarizeForPolicySetDefinitionCreateRequest(ctx context.Context, policyStatesSummaryResource PolicyStatesSummaryResourceType, subscriptionID string, policySetDefinitionName string, queryOptions *QueryOptions, options *PolicyStatesClientSummarizeForPolicySetDefinitionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policySetDefinitions/{policySetDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize"
	if policyStatesSummaryResource == "" {
		return nil, errors.New("parameter policyStatesSummaryResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyStatesSummaryResource}", url.PathEscape(string(policyStatesSummaryResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	urlPath = strings.ReplaceAll(urlPath, "{authorizationNamespace}", url.PathEscape("Microsoft.Authorization"))
	if policySetDefinitionName == "" {
		return nil, errors.New("parameter policySetDefinitionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policySetDefinitionName}", url.PathEscape(policySetDefinitionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// summarizeForPolicySetDefinitionHandleResponse handles the SummarizeForPolicySetDefinition response.
func (client *PolicyStatesClient) summarizeForPolicySetDefinitionHandleResponse(resp *http.Response) (PolicyStatesClientSummarizeForPolicySetDefinitionResponse, error) {
	result := PolicyStatesClientSummarizeForPolicySetDefinitionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SummarizeResults); err != nil {
		return PolicyStatesClientSummarizeForPolicySetDefinitionResponse{}, err
	}
	return result, nil
}

// SummarizeForResource - Summarizes policy states for the resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-10-01
//   - policyStatesSummaryResource - The virtual resource under PolicyStates resource type for summarize action. In a given time
//     range, 'latest' represents the latest policy state(s) and is the only allowed value.
//   - resourceID - Resource ID.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyStatesClientSummarizeForResourceOptions contains the optional parameters for the PolicyStatesClient.SummarizeForResource
//     method.
func (client *PolicyStatesClient) SummarizeForResource(ctx context.Context, policyStatesSummaryResource PolicyStatesSummaryResourceType, resourceID string, queryOptions *QueryOptions, options *PolicyStatesClientSummarizeForResourceOptions) (PolicyStatesClientSummarizeForResourceResponse, error) {
	var err error
	const operationName = "PolicyStatesClient.SummarizeForResource"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.summarizeForResourceCreateRequest(ctx, policyStatesSummaryResource, resourceID, queryOptions, options)
	if err != nil {
		return PolicyStatesClientSummarizeForResourceResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PolicyStatesClientSummarizeForResourceResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PolicyStatesClientSummarizeForResourceResponse{}, err
	}
	resp, err := client.summarizeForResourceHandleResponse(httpResp)
	return resp, err
}

// summarizeForResourceCreateRequest creates the SummarizeForResource request.
func (client *PolicyStatesClient) summarizeForResourceCreateRequest(ctx context.Context, policyStatesSummaryResource PolicyStatesSummaryResourceType, resourceID string, queryOptions *QueryOptions, options *PolicyStatesClientSummarizeForResourceOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize"
	if policyStatesSummaryResource == "" {
		return nil, errors.New("parameter policyStatesSummaryResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyStatesSummaryResource}", url.PathEscape(string(policyStatesSummaryResource)))
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// summarizeForResourceHandleResponse handles the SummarizeForResource response.
func (client *PolicyStatesClient) summarizeForResourceHandleResponse(resp *http.Response) (PolicyStatesClientSummarizeForResourceResponse, error) {
	result := PolicyStatesClientSummarizeForResourceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SummarizeResults); err != nil {
		return PolicyStatesClientSummarizeForResourceResponse{}, err
	}
	return result, nil
}

// SummarizeForResourceGroup - Summarizes policy states for the resources under the resource group.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-10-01
//   - policyStatesSummaryResource - The virtual resource under PolicyStates resource type for summarize action. In a given time
//     range, 'latest' represents the latest policy state(s) and is the only allowed value.
//   - subscriptionID - Microsoft Azure subscription ID.
//   - resourceGroupName - Resource group name.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyStatesClientSummarizeForResourceGroupOptions contains the optional parameters for the PolicyStatesClient.SummarizeForResourceGroup
//     method.
func (client *PolicyStatesClient) SummarizeForResourceGroup(ctx context.Context, policyStatesSummaryResource PolicyStatesSummaryResourceType, subscriptionID string, resourceGroupName string, queryOptions *QueryOptions, options *PolicyStatesClientSummarizeForResourceGroupOptions) (PolicyStatesClientSummarizeForResourceGroupResponse, error) {
	var err error
	const operationName = "PolicyStatesClient.SummarizeForResourceGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.summarizeForResourceGroupCreateRequest(ctx, policyStatesSummaryResource, subscriptionID, resourceGroupName, queryOptions, options)
	if err != nil {
		return PolicyStatesClientSummarizeForResourceGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PolicyStatesClientSummarizeForResourceGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PolicyStatesClientSummarizeForResourceGroupResponse{}, err
	}
	resp, err := client.summarizeForResourceGroupHandleResponse(httpResp)
	return resp, err
}

// summarizeForResourceGroupCreateRequest creates the SummarizeForResourceGroup request.
func (client *PolicyStatesClient) summarizeForResourceGroupCreateRequest(ctx context.Context, policyStatesSummaryResource PolicyStatesSummaryResourceType, subscriptionID string, resourceGroupName string, queryOptions *QueryOptions, options *PolicyStatesClientSummarizeForResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize"
	if policyStatesSummaryResource == "" {
		return nil, errors.New("parameter policyStatesSummaryResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyStatesSummaryResource}", url.PathEscape(string(policyStatesSummaryResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// summarizeForResourceGroupHandleResponse handles the SummarizeForResourceGroup response.
func (client *PolicyStatesClient) summarizeForResourceGroupHandleResponse(resp *http.Response) (PolicyStatesClientSummarizeForResourceGroupResponse, error) {
	result := PolicyStatesClientSummarizeForResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SummarizeResults); err != nil {
		return PolicyStatesClientSummarizeForResourceGroupResponse{}, err
	}
	return result, nil
}

// SummarizeForResourceGroupLevelPolicyAssignment - Summarizes policy states for the resource group level policy assignment.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-10-01
//   - policyStatesSummaryResource - The virtual resource under PolicyStates resource type for summarize action. In a given time
//     range, 'latest' represents the latest policy state(s) and is the only allowed value.
//   - subscriptionID - Microsoft Azure subscription ID.
//   - resourceGroupName - Resource group name.
//   - policyAssignmentName - Policy assignment name.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyStatesClientSummarizeForResourceGroupLevelPolicyAssignmentOptions contains the optional parameters for
//     the PolicyStatesClient.SummarizeForResourceGroupLevelPolicyAssignment method.
func (client *PolicyStatesClient) SummarizeForResourceGroupLevelPolicyAssignment(ctx context.Context, policyStatesSummaryResource PolicyStatesSummaryResourceType, subscriptionID string, resourceGroupName string, policyAssignmentName string, queryOptions *QueryOptions, options *PolicyStatesClientSummarizeForResourceGroupLevelPolicyAssignmentOptions) (PolicyStatesClientSummarizeForResourceGroupLevelPolicyAssignmentResponse, error) {
	var err error
	const operationName = "PolicyStatesClient.SummarizeForResourceGroupLevelPolicyAssignment"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.summarizeForResourceGroupLevelPolicyAssignmentCreateRequest(ctx, policyStatesSummaryResource, subscriptionID, resourceGroupName, policyAssignmentName, queryOptions, options)
	if err != nil {
		return PolicyStatesClientSummarizeForResourceGroupLevelPolicyAssignmentResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PolicyStatesClientSummarizeForResourceGroupLevelPolicyAssignmentResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PolicyStatesClientSummarizeForResourceGroupLevelPolicyAssignmentResponse{}, err
	}
	resp, err := client.summarizeForResourceGroupLevelPolicyAssignmentHandleResponse(httpResp)
	return resp, err
}

// summarizeForResourceGroupLevelPolicyAssignmentCreateRequest creates the SummarizeForResourceGroupLevelPolicyAssignment request.
func (client *PolicyStatesClient) summarizeForResourceGroupLevelPolicyAssignmentCreateRequest(ctx context.Context, policyStatesSummaryResource PolicyStatesSummaryResourceType, subscriptionID string, resourceGroupName string, policyAssignmentName string, queryOptions *QueryOptions, options *PolicyStatesClientSummarizeForResourceGroupLevelPolicyAssignmentOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize"
	if policyStatesSummaryResource == "" {
		return nil, errors.New("parameter policyStatesSummaryResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyStatesSummaryResource}", url.PathEscape(string(policyStatesSummaryResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	urlPath = strings.ReplaceAll(urlPath, "{authorizationNamespace}", url.PathEscape("Microsoft.Authorization"))
	if policyAssignmentName == "" {
		return nil, errors.New("parameter policyAssignmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyAssignmentName}", url.PathEscape(policyAssignmentName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// summarizeForResourceGroupLevelPolicyAssignmentHandleResponse handles the SummarizeForResourceGroupLevelPolicyAssignment response.
func (client *PolicyStatesClient) summarizeForResourceGroupLevelPolicyAssignmentHandleResponse(resp *http.Response) (PolicyStatesClientSummarizeForResourceGroupLevelPolicyAssignmentResponse, error) {
	result := PolicyStatesClientSummarizeForResourceGroupLevelPolicyAssignmentResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SummarizeResults); err != nil {
		return PolicyStatesClientSummarizeForResourceGroupLevelPolicyAssignmentResponse{}, err
	}
	return result, nil
}

// SummarizeForSubscription - Summarizes policy states for the resources under the subscription.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-10-01
//   - policyStatesSummaryResource - The virtual resource under PolicyStates resource type for summarize action. In a given time
//     range, 'latest' represents the latest policy state(s) and is the only allowed value.
//   - subscriptionID - Microsoft Azure subscription ID.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyStatesClientSummarizeForSubscriptionOptions contains the optional parameters for the PolicyStatesClient.SummarizeForSubscription
//     method.
func (client *PolicyStatesClient) SummarizeForSubscription(ctx context.Context, policyStatesSummaryResource PolicyStatesSummaryResourceType, subscriptionID string, queryOptions *QueryOptions, options *PolicyStatesClientSummarizeForSubscriptionOptions) (PolicyStatesClientSummarizeForSubscriptionResponse, error) {
	var err error
	const operationName = "PolicyStatesClient.SummarizeForSubscription"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.summarizeForSubscriptionCreateRequest(ctx, policyStatesSummaryResource, subscriptionID, queryOptions, options)
	if err != nil {
		return PolicyStatesClientSummarizeForSubscriptionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PolicyStatesClientSummarizeForSubscriptionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PolicyStatesClientSummarizeForSubscriptionResponse{}, err
	}
	resp, err := client.summarizeForSubscriptionHandleResponse(httpResp)
	return resp, err
}

// summarizeForSubscriptionCreateRequest creates the SummarizeForSubscription request.
func (client *PolicyStatesClient) summarizeForSubscriptionCreateRequest(ctx context.Context, policyStatesSummaryResource PolicyStatesSummaryResourceType, subscriptionID string, queryOptions *QueryOptions, options *PolicyStatesClientSummarizeForSubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize"
	if policyStatesSummaryResource == "" {
		return nil, errors.New("parameter policyStatesSummaryResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyStatesSummaryResource}", url.PathEscape(string(policyStatesSummaryResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// summarizeForSubscriptionHandleResponse handles the SummarizeForSubscription response.
func (client *PolicyStatesClient) summarizeForSubscriptionHandleResponse(resp *http.Response) (PolicyStatesClientSummarizeForSubscriptionResponse, error) {
	result := PolicyStatesClientSummarizeForSubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SummarizeResults); err != nil {
		return PolicyStatesClientSummarizeForSubscriptionResponse{}, err
	}
	return result, nil
}

// SummarizeForSubscriptionLevelPolicyAssignment - Summarizes policy states for the subscription level policy assignment.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-10-01
//   - policyStatesSummaryResource - The virtual resource under PolicyStates resource type for summarize action. In a given time
//     range, 'latest' represents the latest policy state(s) and is the only allowed value.
//   - subscriptionID - Microsoft Azure subscription ID.
//   - policyAssignmentName - Policy assignment name.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - PolicyStatesClientSummarizeForSubscriptionLevelPolicyAssignmentOptions contains the optional parameters for the
//     PolicyStatesClient.SummarizeForSubscriptionLevelPolicyAssignment method.
func (client *PolicyStatesClient) SummarizeForSubscriptionLevelPolicyAssignment(ctx context.Context, policyStatesSummaryResource PolicyStatesSummaryResourceType, subscriptionID string, policyAssignmentName string, queryOptions *QueryOptions, options *PolicyStatesClientSummarizeForSubscriptionLevelPolicyAssignmentOptions) (PolicyStatesClientSummarizeForSubscriptionLevelPolicyAssignmentResponse, error) {
	var err error
	const operationName = "PolicyStatesClient.SummarizeForSubscriptionLevelPolicyAssignment"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.summarizeForSubscriptionLevelPolicyAssignmentCreateRequest(ctx, policyStatesSummaryResource, subscriptionID, policyAssignmentName, queryOptions, options)
	if err != nil {
		return PolicyStatesClientSummarizeForSubscriptionLevelPolicyAssignmentResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PolicyStatesClientSummarizeForSubscriptionLevelPolicyAssignmentResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PolicyStatesClientSummarizeForSubscriptionLevelPolicyAssignmentResponse{}, err
	}
	resp, err := client.summarizeForSubscriptionLevelPolicyAssignmentHandleResponse(httpResp)
	return resp, err
}

// summarizeForSubscriptionLevelPolicyAssignmentCreateRequest creates the SummarizeForSubscriptionLevelPolicyAssignment request.
func (client *PolicyStatesClient) summarizeForSubscriptionLevelPolicyAssignmentCreateRequest(ctx context.Context, policyStatesSummaryResource PolicyStatesSummaryResourceType, subscriptionID string, policyAssignmentName string, queryOptions *QueryOptions, options *PolicyStatesClientSummarizeForSubscriptionLevelPolicyAssignmentOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize"
	if policyStatesSummaryResource == "" {
		return nil, errors.New("parameter policyStatesSummaryResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyStatesSummaryResource}", url.PathEscape(string(policyStatesSummaryResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	urlPath = strings.ReplaceAll(urlPath, "{authorizationNamespace}", url.PathEscape("Microsoft.Authorization"))
	if policyAssignmentName == "" {
		return nil, errors.New("parameter policyAssignmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyAssignmentName}", url.PathEscape(policyAssignmentName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// summarizeForSubscriptionLevelPolicyAssignmentHandleResponse handles the SummarizeForSubscriptionLevelPolicyAssignment response.
func (client *PolicyStatesClient) summarizeForSubscriptionLevelPolicyAssignmentHandleResponse(resp *http.Response) (PolicyStatesClientSummarizeForSubscriptionLevelPolicyAssignmentResponse, error) {
	result := PolicyStatesClientSummarizeForSubscriptionLevelPolicyAssignmentResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SummarizeResults); err != nil {
		return PolicyStatesClientSummarizeForSubscriptionLevelPolicyAssignmentResponse{}, err
	}
	return result, nil
}

// BeginTriggerResourceGroupEvaluation - Triggers a policy evaluation scan for all the resources under the resource group.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-10-01
//   - subscriptionID - Microsoft Azure subscription ID.
//   - resourceGroupName - Resource group name.
//   - options - PolicyStatesClientBeginTriggerResourceGroupEvaluationOptions contains the optional parameters for the PolicyStatesClient.BeginTriggerResourceGroupEvaluation
//     method.
func (client *PolicyStatesClient) BeginTriggerResourceGroupEvaluation(ctx context.Context, subscriptionID string, resourceGroupName string, options *PolicyStatesClientBeginTriggerResourceGroupEvaluationOptions) (*runtime.Poller[PolicyStatesClientTriggerResourceGroupEvaluationResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.triggerResourceGroupEvaluation(ctx, subscriptionID, resourceGroupName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[PolicyStatesClientTriggerResourceGroupEvaluationResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[PolicyStatesClientTriggerResourceGroupEvaluationResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// TriggerResourceGroupEvaluation - Triggers a policy evaluation scan for all the resources under the resource group.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-10-01
func (client *PolicyStatesClient) triggerResourceGroupEvaluation(ctx context.Context, subscriptionID string, resourceGroupName string, options *PolicyStatesClientBeginTriggerResourceGroupEvaluationOptions) (*http.Response, error) {
	var err error
	const operationName = "PolicyStatesClient.BeginTriggerResourceGroupEvaluation"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.triggerResourceGroupEvaluationCreateRequest(ctx, subscriptionID, resourceGroupName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// triggerResourceGroupEvaluationCreateRequest creates the TriggerResourceGroupEvaluation request.
func (client *PolicyStatesClient) triggerResourceGroupEvaluationCreateRequest(ctx context.Context, subscriptionID string, resourceGroupName string, options *PolicyStatesClientBeginTriggerResourceGroupEvaluationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyStates/latest/triggerEvaluation"
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginTriggerSubscriptionEvaluation - Triggers a policy evaluation scan for all the resources under the subscription
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-10-01
//   - subscriptionID - Microsoft Azure subscription ID.
//   - options - PolicyStatesClientBeginTriggerSubscriptionEvaluationOptions contains the optional parameters for the PolicyStatesClient.BeginTriggerSubscriptionEvaluation
//     method.
func (client *PolicyStatesClient) BeginTriggerSubscriptionEvaluation(ctx context.Context, subscriptionID string, options *PolicyStatesClientBeginTriggerSubscriptionEvaluationOptions) (*runtime.Poller[PolicyStatesClientTriggerSubscriptionEvaluationResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.triggerSubscriptionEvaluation(ctx, subscriptionID, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[PolicyStatesClientTriggerSubscriptionEvaluationResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[PolicyStatesClientTriggerSubscriptionEvaluationResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// TriggerSubscriptionEvaluation - Triggers a policy evaluation scan for all the resources under the subscription
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-10-01
func (client *PolicyStatesClient) triggerSubscriptionEvaluation(ctx context.Context, subscriptionID string, options *PolicyStatesClientBeginTriggerSubscriptionEvaluationOptions) (*http.Response, error) {
	var err error
	const operationName = "PolicyStatesClient.BeginTriggerSubscriptionEvaluation"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.triggerSubscriptionEvaluationCreateRequest(ctx, subscriptionID, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// triggerSubscriptionEvaluationCreateRequest creates the TriggerSubscriptionEvaluation request.
func (client *PolicyStatesClient) triggerSubscriptionEvaluationCreateRequest(ctx context.Context, subscriptionID string, options *PolicyStatesClientBeginTriggerSubscriptionEvaluationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyStates/latest/triggerEvaluation"
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}
