//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armpeering_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/peering/armpeering"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/peering/resource-manager/Microsoft.Peering/stable/2022-01-01/examples/GetPeeringService.json
func ExampleServicesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpeering.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServicesClient().Get(ctx, "rgName", "peeringServiceName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Service = armpeering.Service{
	// 	Name: to.Ptr("peeringServiceName"),
	// 	Type: to.Ptr("Microsoft.Peering/peeringServices"),
	// 	ID: to.Ptr("/subscriptions/subId/resourceGroups/rgName/providers/Microsoft.Peering/peeringServices/peeringServiceName"),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armpeering.ServiceProperties{
	// 		LogAnalyticsWorkspaceProperties: &armpeering.LogAnalyticsWorkspaceProperties{
	// 			ConnectedAgents: []*string{
	// 				to.Ptr("Agent1"),
	// 				to.Ptr("Agent2")},
	// 				Key: to.Ptr("key"),
	// 				WorkspaceID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 			},
	// 			PeeringServiceLocation: to.Ptr("state1"),
	// 			PeeringServiceProvider: to.Ptr("serviceProvider1"),
	// 			ProviderBackupPeeringLocation: to.Ptr("peeringLocation2"),
	// 			ProviderPrimaryPeeringLocation: to.Ptr("peeringLocation1"),
	// 			ProvisioningState: to.Ptr(armpeering.ProvisioningStateSucceeded),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/peering/resource-manager/Microsoft.Peering/stable/2022-01-01/examples/CreatePeeringService.json
func ExampleServicesClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpeering.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServicesClient().CreateOrUpdate(ctx, "rgName", "peeringServiceName", armpeering.Service{
		Location: to.Ptr("eastus"),
		Properties: &armpeering.ServiceProperties{
			PeeringServiceLocation:         to.Ptr("state1"),
			PeeringServiceProvider:         to.Ptr("serviceProvider1"),
			ProviderBackupPeeringLocation:  to.Ptr("peeringLocation2"),
			ProviderPrimaryPeeringLocation: to.Ptr("peeringLocation1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Service = armpeering.Service{
	// 	Name: to.Ptr("peeringServiceName"),
	// 	Type: to.Ptr("Microsoft.Peering/peeringServices"),
	// 	ID: to.Ptr("/subscriptions/subId/resourceGroups/rgName/providers/Microsoft.Peering/peeringServices/peeringServiceName"),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armpeering.ServiceProperties{
	// 		PeeringServiceLocation: to.Ptr("state1"),
	// 		PeeringServiceProvider: to.Ptr("serviceProvider1"),
	// 		ProviderBackupPeeringLocation: to.Ptr("peeringLocation2"),
	// 		ProviderPrimaryPeeringLocation: to.Ptr("peeringLocation1"),
	// 		ProvisioningState: to.Ptr(armpeering.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/peering/resource-manager/Microsoft.Peering/stable/2022-01-01/examples/DeletePeeringService.json
func ExampleServicesClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpeering.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewServicesClient().Delete(ctx, "rgName", "peeringServiceName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/peering/resource-manager/Microsoft.Peering/stable/2022-01-01/examples/UpdatePeeringServiceTags.json
func ExampleServicesClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpeering.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServicesClient().Update(ctx, "rgName", "peeringServiceName", armpeering.ResourceTags{
		Tags: map[string]*string{
			"tag0": to.Ptr("value0"),
			"tag1": to.Ptr("value1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Service = armpeering.Service{
	// 	Name: to.Ptr("peeringServiceName"),
	// 	Type: to.Ptr("Microsoft.Peering/peeringServices"),
	// 	ID: to.Ptr("/subscriptions/subId/resourceGroups/rgName/providers/Microsoft.Peering/peeringServices/peeringServiceName"),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armpeering.ServiceProperties{
	// 		LogAnalyticsWorkspaceProperties: &armpeering.LogAnalyticsWorkspaceProperties{
	// 			ConnectedAgents: []*string{
	// 				to.Ptr("Agent1"),
	// 				to.Ptr("Agent2")},
	// 				Key: to.Ptr("key"),
	// 				WorkspaceID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 			},
	// 			PeeringServiceLocation: to.Ptr("state1"),
	// 			PeeringServiceProvider: to.Ptr("serviceProvider1"),
	// 			ProviderBackupPeeringLocation: to.Ptr("peeringLocation2"),
	// 			ProviderPrimaryPeeringLocation: to.Ptr("peeringLocation1"),
	// 			ProvisioningState: to.Ptr(armpeering.ProvisioningStateSucceeded),
	// 		},
	// 		Tags: map[string]*string{
	// 			"tag0": to.Ptr("value0"),
	// 			"tag1": to.Ptr("value1"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/peering/resource-manager/Microsoft.Peering/stable/2022-01-01/examples/ListPeeringServicesByResourceGroup.json
func ExampleServicesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpeering.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServicesClient().NewListByResourceGroupPager("rgName", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ServiceListResult = armpeering.ServiceListResult{
		// 	Value: []*armpeering.Service{
		// 		{
		// 			Name: to.Ptr("peeringServiceName"),
		// 			Type: to.Ptr("Microsoft.Peering/peeringServices"),
		// 			ID: to.Ptr("/subscriptions/subId/resourceGroups/rgName/providers/Microsoft.Peering/peeringServices/peeringServiceName"),
		// 			Location: to.Ptr("eastus"),
		// 			Properties: &armpeering.ServiceProperties{
		// 				LogAnalyticsWorkspaceProperties: &armpeering.LogAnalyticsWorkspaceProperties{
		// 					ConnectedAgents: []*string{
		// 						to.Ptr("Agent1"),
		// 						to.Ptr("Agent2")},
		// 						Key: to.Ptr("key"),
		// 						WorkspaceID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 					},
		// 					PeeringServiceLocation: to.Ptr("state1"),
		// 					PeeringServiceProvider: to.Ptr("serviceProvider1"),
		// 					ProviderBackupPeeringLocation: to.Ptr("peeringLocation2"),
		// 					ProviderPrimaryPeeringLocation: to.Ptr("peeringLocation1"),
		// 					ProvisioningState: to.Ptr(armpeering.ProvisioningStateSucceeded),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/peering/resource-manager/Microsoft.Peering/stable/2022-01-01/examples/ListPeeringServicesBySubscription.json
func ExampleServicesClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpeering.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServicesClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ServiceListResult = armpeering.ServiceListResult{
		// 	Value: []*armpeering.Service{
		// 		{
		// 			Name: to.Ptr("peeringServiceName"),
		// 			Type: to.Ptr("Microsoft.Peering/peeringServices"),
		// 			ID: to.Ptr("/subscriptions/subId/resourceGroups/rgName/providers/Microsoft.Peering/peeringServices/peeringServiceName"),
		// 			Location: to.Ptr("eastus"),
		// 			Properties: &armpeering.ServiceProperties{
		// 				LogAnalyticsWorkspaceProperties: &armpeering.LogAnalyticsWorkspaceProperties{
		// 					ConnectedAgents: []*string{
		// 						to.Ptr("Agent1"),
		// 						to.Ptr("Agent2")},
		// 						Key: to.Ptr("key"),
		// 						WorkspaceID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 					},
		// 					PeeringServiceLocation: to.Ptr("state1"),
		// 					PeeringServiceProvider: to.Ptr("serviceProvider1"),
		// 					ProviderBackupPeeringLocation: to.Ptr("peeringLocation2"),
		// 					ProviderPrimaryPeeringLocation: to.Ptr("peeringLocation1"),
		// 					ProvisioningState: to.Ptr(armpeering.ProvisioningStateSucceeded),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/peering/resource-manager/Microsoft.Peering/stable/2022-01-01/examples/InitializeConnectionMonitor.json
func ExampleServicesClient_InitializeConnectionMonitor() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpeering.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewServicesClient().InitializeConnectionMonitor(ctx, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
