//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/peering/armpeering"
	"net/http"
	"net/url"
	"regexp"
)

// RegisteredAsnsServer is a fake server for instances of the armpeering.RegisteredAsnsClient type.
type RegisteredAsnsServer struct {
	// CreateOrUpdate is the fake for method RegisteredAsnsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, peeringName string, registeredAsnName string, registeredAsn armpeering.RegisteredAsn, options *armpeering.RegisteredAsnsClientCreateOrUpdateOptions) (resp azfake.Responder[armpeering.RegisteredAsnsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method RegisteredAsnsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, peeringName string, registeredAsnName string, options *armpeering.RegisteredAsnsClientDeleteOptions) (resp azfake.Responder[armpeering.RegisteredAsnsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method RegisteredAsnsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, peeringName string, registeredAsnName string, options *armpeering.RegisteredAsnsClientGetOptions) (resp azfake.Responder[armpeering.RegisteredAsnsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByPeeringPager is the fake for method RegisteredAsnsClient.NewListByPeeringPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByPeeringPager func(resourceGroupName string, peeringName string, options *armpeering.RegisteredAsnsClientListByPeeringOptions) (resp azfake.PagerResponder[armpeering.RegisteredAsnsClientListByPeeringResponse])
}

// NewRegisteredAsnsServerTransport creates a new instance of RegisteredAsnsServerTransport with the provided implementation.
// The returned RegisteredAsnsServerTransport instance is connected to an instance of armpeering.RegisteredAsnsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewRegisteredAsnsServerTransport(srv *RegisteredAsnsServer) *RegisteredAsnsServerTransport {
	return &RegisteredAsnsServerTransport{
		srv:                   srv,
		newListByPeeringPager: newTracker[azfake.PagerResponder[armpeering.RegisteredAsnsClientListByPeeringResponse]](),
	}
}

// RegisteredAsnsServerTransport connects instances of armpeering.RegisteredAsnsClient to instances of RegisteredAsnsServer.
// Don't use this type directly, use NewRegisteredAsnsServerTransport instead.
type RegisteredAsnsServerTransport struct {
	srv                   *RegisteredAsnsServer
	newListByPeeringPager *tracker[azfake.PagerResponder[armpeering.RegisteredAsnsClientListByPeeringResponse]]
}

// Do implements the policy.Transporter interface for RegisteredAsnsServerTransport.
func (r *RegisteredAsnsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "RegisteredAsnsClient.CreateOrUpdate":
		resp, err = r.dispatchCreateOrUpdate(req)
	case "RegisteredAsnsClient.Delete":
		resp, err = r.dispatchDelete(req)
	case "RegisteredAsnsClient.Get":
		resp, err = r.dispatchGet(req)
	case "RegisteredAsnsClient.NewListByPeeringPager":
		resp, err = r.dispatchNewListByPeeringPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *RegisteredAsnsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if r.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Peering/peerings/(?P<peeringName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/registeredAsns/(?P<registeredAsnName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpeering.RegisteredAsn](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	peeringNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("peeringName")])
	if err != nil {
		return nil, err
	}
	registeredAsnNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registeredAsnName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, peeringNameParam, registeredAsnNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RegisteredAsn, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RegisteredAsnsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if r.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Peering/peerings/(?P<peeringName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/registeredAsns/(?P<registeredAsnName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	peeringNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("peeringName")])
	if err != nil {
		return nil, err
	}
	registeredAsnNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registeredAsnName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Delete(req.Context(), resourceGroupNameParam, peeringNameParam, registeredAsnNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RegisteredAsnsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Peering/peerings/(?P<peeringName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/registeredAsns/(?P<registeredAsnName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	peeringNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("peeringName")])
	if err != nil {
		return nil, err
	}
	registeredAsnNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registeredAsnName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), resourceGroupNameParam, peeringNameParam, registeredAsnNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RegisteredAsn, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RegisteredAsnsServerTransport) dispatchNewListByPeeringPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByPeeringPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByPeeringPager not implemented")}
	}
	newListByPeeringPager := r.newListByPeeringPager.get(req)
	if newListByPeeringPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Peering/peerings/(?P<peeringName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/registeredAsns`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		peeringNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("peeringName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListByPeeringPager(resourceGroupNameParam, peeringNameParam, nil)
		newListByPeeringPager = &resp
		r.newListByPeeringPager.add(req, newListByPeeringPager)
		server.PagerResponderInjectNextLinks(newListByPeeringPager, req, func(page *armpeering.RegisteredAsnsClientListByPeeringResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByPeeringPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByPeeringPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByPeeringPager) {
		r.newListByPeeringPager.remove(req)
	}
	return resp, nil
}
