//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/peering/armpeering"
	"net/http"
	"net/url"
	"regexp"
)

// ReceivedRoutesServer is a fake server for instances of the armpeering.ReceivedRoutesClient type.
type ReceivedRoutesServer struct {
	// NewListByPeeringPager is the fake for method ReceivedRoutesClient.NewListByPeeringPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByPeeringPager func(resourceGroupName string, peeringName string, options *armpeering.ReceivedRoutesClientListByPeeringOptions) (resp azfake.PagerResponder[armpeering.ReceivedRoutesClientListByPeeringResponse])
}

// NewReceivedRoutesServerTransport creates a new instance of ReceivedRoutesServerTransport with the provided implementation.
// The returned ReceivedRoutesServerTransport instance is connected to an instance of armpeering.ReceivedRoutesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewReceivedRoutesServerTransport(srv *ReceivedRoutesServer) *ReceivedRoutesServerTransport {
	return &ReceivedRoutesServerTransport{
		srv:                   srv,
		newListByPeeringPager: newTracker[azfake.PagerResponder[armpeering.ReceivedRoutesClientListByPeeringResponse]](),
	}
}

// ReceivedRoutesServerTransport connects instances of armpeering.ReceivedRoutesClient to instances of ReceivedRoutesServer.
// Don't use this type directly, use NewReceivedRoutesServerTransport instead.
type ReceivedRoutesServerTransport struct {
	srv                   *ReceivedRoutesServer
	newListByPeeringPager *tracker[azfake.PagerResponder[armpeering.ReceivedRoutesClientListByPeeringResponse]]
}

// Do implements the policy.Transporter interface for ReceivedRoutesServerTransport.
func (r *ReceivedRoutesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ReceivedRoutesClient.NewListByPeeringPager":
		resp, err = r.dispatchNewListByPeeringPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ReceivedRoutesServerTransport) dispatchNewListByPeeringPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByPeeringPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByPeeringPager not implemented")}
	}
	newListByPeeringPager := r.newListByPeeringPager.get(req)
	if newListByPeeringPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Peering/peerings/(?P<peeringName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/receivedRoutes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		peeringNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("peeringName")])
		if err != nil {
			return nil, err
		}
		prefixUnescaped, err := url.QueryUnescape(qp.Get("prefix"))
		if err != nil {
			return nil, err
		}
		prefixParam := getOptional(prefixUnescaped)
		asPathUnescaped, err := url.QueryUnescape(qp.Get("asPath"))
		if err != nil {
			return nil, err
		}
		asPathParam := getOptional(asPathUnescaped)
		originAsValidationStateUnescaped, err := url.QueryUnescape(qp.Get("originAsValidationState"))
		if err != nil {
			return nil, err
		}
		originAsValidationStateParam := getOptional(originAsValidationStateUnescaped)
		rpkiValidationStateUnescaped, err := url.QueryUnescape(qp.Get("rpkiValidationState"))
		if err != nil {
			return nil, err
		}
		rpkiValidationStateParam := getOptional(rpkiValidationStateUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armpeering.ReceivedRoutesClientListByPeeringOptions
		if prefixParam != nil || asPathParam != nil || originAsValidationStateParam != nil || rpkiValidationStateParam != nil || skipTokenParam != nil {
			options = &armpeering.ReceivedRoutesClientListByPeeringOptions{
				Prefix:                  prefixParam,
				AsPath:                  asPathParam,
				OriginAsValidationState: originAsValidationStateParam,
				RpkiValidationState:     rpkiValidationStateParam,
				SkipToken:               skipTokenParam,
			}
		}
		resp := r.srv.NewListByPeeringPager(resourceGroupNameParam, peeringNameParam, options)
		newListByPeeringPager = &resp
		r.newListByPeeringPager.add(req, newListByPeeringPager)
		server.PagerResponderInjectNextLinks(newListByPeeringPager, req, func(page *armpeering.ReceivedRoutesClientListByPeeringResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByPeeringPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByPeeringPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByPeeringPager) {
		r.newListByPeeringPager.remove(req)
	}
	return resp, nil
}
