//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpanngfw

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AdvSecurityObjectListResponse.
func (a AdvSecurityObjectListResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdvSecurityObjectListResponse.
func (a *AdvSecurityObjectListResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdvSecurityObjectModel.
func (a AdvSecurityObjectModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "entry", a.Entry)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdvSecurityObjectModel.
func (a *AdvSecurityObjectModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "entry":
			err = unpopulate(val, "Entry", &a.Entry)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppSeenData.
func (a AppSeenData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appSeenList", a.AppSeenList)
	populate(objectMap, "count", a.Count)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppSeenData.
func (a *AppSeenData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appSeenList":
			err = unpopulate(val, "AppSeenList", &a.AppSeenList)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &a.Count)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppSeenInfo.
func (a AppSeenInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", a.Category)
	populate(objectMap, "risk", a.Risk)
	populate(objectMap, "standardPorts", a.StandardPorts)
	populate(objectMap, "subCategory", a.SubCategory)
	populate(objectMap, "tag", a.Tag)
	populate(objectMap, "technology", a.Technology)
	populate(objectMap, "title", a.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppSeenInfo.
func (a *AppSeenInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &a.Category)
			delete(rawMsg, key)
		case "risk":
			err = unpopulate(val, "Risk", &a.Risk)
			delete(rawMsg, key)
		case "standardPorts":
			err = unpopulate(val, "StandardPorts", &a.StandardPorts)
			delete(rawMsg, key)
		case "subCategory":
			err = unpopulate(val, "SubCategory", &a.SubCategory)
			delete(rawMsg, key)
		case "tag":
			err = unpopulate(val, "Tag", &a.Tag)
			delete(rawMsg, key)
		case "technology":
			err = unpopulate(val, "Technology", &a.Technology)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &a.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationInsights.
func (a ApplicationInsights) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "key", a.Key)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationInsights.
func (a *ApplicationInsights) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, "Key", &a.Key)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureResourceManagerManagedIdentityProperties.
func (a AzureResourceManagerManagedIdentityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", a.PrincipalID)
	populate(objectMap, "tenantId", a.TenantID)
	populate(objectMap, "type", a.Type)
	populate(objectMap, "userAssignedIdentities", a.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureResourceManagerManagedIdentityProperties.
func (a *AzureResourceManagerManagedIdentityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &a.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &a.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &a.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureResourceManagerUserAssignedIdentity.
func (a AzureResourceManagerUserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", a.ClientID)
	populate(objectMap, "principalId", a.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureResourceManagerUserAssignedIdentity.
func (a *AzureResourceManagerUserAssignedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &a.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &a.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Category.
func (c Category) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "feeds", c.Feeds)
	populate(objectMap, "urlCustom", c.URLCustom)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Category.
func (c *Category) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "feeds":
			err = unpopulate(val, "Feeds", &c.Feeds)
			delete(rawMsg, key)
		case "urlCustom":
			err = unpopulate(val, "URLCustom", &c.URLCustom)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateObject.
func (c CertificateObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "auditComment", c.AuditComment)
	populate(objectMap, "certificateSelfSigned", c.CertificateSelfSigned)
	populate(objectMap, "certificateSignerResourceId", c.CertificateSignerResourceID)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateObject.
func (c *CertificateObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "auditComment":
			err = unpopulate(val, "AuditComment", &c.AuditComment)
			delete(rawMsg, key)
		case "certificateSelfSigned":
			err = unpopulate(val, "CertificateSelfSigned", &c.CertificateSelfSigned)
			delete(rawMsg, key)
		case "certificateSignerResourceId":
			err = unpopulate(val, "CertificateSignerResourceID", &c.CertificateSignerResourceID)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &c.Etag)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateObjectGlobalRulestackResource.
func (c CertificateObjectGlobalRulestackResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateObjectGlobalRulestackResource.
func (c *CertificateObjectGlobalRulestackResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateObjectGlobalRulestackResourceListResult.
func (c CertificateObjectGlobalRulestackResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateObjectGlobalRulestackResourceListResult.
func (c *CertificateObjectGlobalRulestackResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateObjectLocalRulestackResource.
func (c CertificateObjectLocalRulestackResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateObjectLocalRulestackResource.
func (c *CertificateObjectLocalRulestackResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateObjectLocalRulestackResourceListResult.
func (c CertificateObjectLocalRulestackResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateObjectLocalRulestackResourceListResult.
func (c *CertificateObjectLocalRulestackResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Changelog.
func (c Changelog) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "changes", c.Changes)
	populateDateTimeRFC3339(objectMap, "lastCommitted", c.LastCommitted)
	populateDateTimeRFC3339(objectMap, "lastModified", c.LastModified)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Changelog.
func (c *Changelog) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changes":
			err = unpopulate(val, "Changes", &c.Changes)
			delete(rawMsg, key)
		case "lastCommitted":
			err = unpopulateDateTimeRFC3339(val, "LastCommitted", &c.LastCommitted)
			delete(rawMsg, key)
		case "lastModified":
			err = unpopulateDateTimeRFC3339(val, "LastModified", &c.LastModified)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CountriesResponse.
func (c CountriesResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CountriesResponse.
func (c *CountriesResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Country.
func (c Country) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", c.Code)
	populate(objectMap, "description", c.Description)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Country.
func (c *Country) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &c.Code)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DNSSettings.
func (d DNSSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsServers", d.DNSServers)
	populate(objectMap, "enableDnsProxy", d.EnableDNSProxy)
	populate(objectMap, "enabledDnsType", d.EnabledDNSType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DNSSettings.
func (d *DNSSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsServers":
			err = unpopulate(val, "DNSServers", &d.DNSServers)
			delete(rawMsg, key)
		case "enableDnsProxy":
			err = unpopulate(val, "EnableDNSProxy", &d.EnableDNSProxy)
			delete(rawMsg, key)
		case "enabledDnsType":
			err = unpopulate(val, "EnabledDNSType", &d.EnabledDNSType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DestinationAddr.
func (d DestinationAddr) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cidrs", d.Cidrs)
	populate(objectMap, "countries", d.Countries)
	populate(objectMap, "feeds", d.Feeds)
	populate(objectMap, "fqdnLists", d.FqdnLists)
	populate(objectMap, "prefixLists", d.PrefixLists)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DestinationAddr.
func (d *DestinationAddr) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cidrs":
			err = unpopulate(val, "Cidrs", &d.Cidrs)
			delete(rawMsg, key)
		case "countries":
			err = unpopulate(val, "Countries", &d.Countries)
			delete(rawMsg, key)
		case "feeds":
			err = unpopulate(val, "Feeds", &d.Feeds)
			delete(rawMsg, key)
		case "fqdnLists":
			err = unpopulate(val, "FqdnLists", &d.FqdnLists)
			delete(rawMsg, key)
		case "prefixLists":
			err = unpopulate(val, "PrefixLists", &d.PrefixLists)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointConfiguration.
func (e EndpointConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", e.Address)
	populate(objectMap, "port", e.Port)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointConfiguration.
func (e *EndpointConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &e.Address)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &e.Port)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHub.
func (e EventHub) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "nameSpace", e.NameSpace)
	populate(objectMap, "policyName", e.PolicyName)
	populate(objectMap, "subscriptionId", e.SubscriptionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHub.
func (e *EventHub) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "nameSpace":
			err = unpopulate(val, "NameSpace", &e.NameSpace)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &e.PolicyName)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &e.SubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallDeploymentProperties.
func (f FirewallDeploymentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "associatedRulestack", f.AssociatedRulestack)
	populate(objectMap, "dnsSettings", f.DNSSettings)
	populate(objectMap, "frontEndSettings", f.FrontEndSettings)
	populate(objectMap, "isPanoramaManaged", f.IsPanoramaManaged)
	populate(objectMap, "marketplaceDetails", f.MarketplaceDetails)
	populate(objectMap, "networkProfile", f.NetworkProfile)
	populate(objectMap, "panEtag", f.PanEtag)
	populate(objectMap, "panoramaConfig", f.PanoramaConfig)
	populate(objectMap, "planData", f.PlanData)
	populate(objectMap, "provisioningState", f.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallDeploymentProperties.
func (f *FirewallDeploymentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "associatedRulestack":
			err = unpopulate(val, "AssociatedRulestack", &f.AssociatedRulestack)
			delete(rawMsg, key)
		case "dnsSettings":
			err = unpopulate(val, "DNSSettings", &f.DNSSettings)
			delete(rawMsg, key)
		case "frontEndSettings":
			err = unpopulate(val, "FrontEndSettings", &f.FrontEndSettings)
			delete(rawMsg, key)
		case "isPanoramaManaged":
			err = unpopulate(val, "IsPanoramaManaged", &f.IsPanoramaManaged)
			delete(rawMsg, key)
		case "marketplaceDetails":
			err = unpopulate(val, "MarketplaceDetails", &f.MarketplaceDetails)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &f.NetworkProfile)
			delete(rawMsg, key)
		case "panEtag":
			err = unpopulate(val, "PanEtag", &f.PanEtag)
			delete(rawMsg, key)
		case "panoramaConfig":
			err = unpopulate(val, "PanoramaConfig", &f.PanoramaConfig)
			delete(rawMsg, key)
		case "planData":
			err = unpopulate(val, "PlanData", &f.PlanData)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &f.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallResource.
func (f FirewallResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "identity", f.Identity)
	populate(objectMap, "location", f.Location)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "systemData", f.SystemData)
	populate(objectMap, "tags", f.Tags)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallResource.
func (f *FirewallResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &f.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &f.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &f.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &f.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallResourceListResult.
func (f FirewallResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallResourceListResult.
func (f *FirewallResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallResourceUpdate.
func (f FirewallResourceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", f.Identity)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "tags", f.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallResourceUpdate.
func (f *FirewallResourceUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &f.Identity)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &f.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallResourceUpdateProperties.
func (f FirewallResourceUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "associatedRulestack", f.AssociatedRulestack)
	populate(objectMap, "dnsSettings", f.DNSSettings)
	populate(objectMap, "frontEndSettings", f.FrontEndSettings)
	populate(objectMap, "isPanoramaManaged", f.IsPanoramaManaged)
	populate(objectMap, "marketplaceDetails", f.MarketplaceDetails)
	populate(objectMap, "networkProfile", f.NetworkProfile)
	populate(objectMap, "panEtag", f.PanEtag)
	populate(objectMap, "panoramaConfig", f.PanoramaConfig)
	populate(objectMap, "planData", f.PlanData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallResourceUpdateProperties.
func (f *FirewallResourceUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "associatedRulestack":
			err = unpopulate(val, "AssociatedRulestack", &f.AssociatedRulestack)
			delete(rawMsg, key)
		case "dnsSettings":
			err = unpopulate(val, "DNSSettings", &f.DNSSettings)
			delete(rawMsg, key)
		case "frontEndSettings":
			err = unpopulate(val, "FrontEndSettings", &f.FrontEndSettings)
			delete(rawMsg, key)
		case "isPanoramaManaged":
			err = unpopulate(val, "IsPanoramaManaged", &f.IsPanoramaManaged)
			delete(rawMsg, key)
		case "marketplaceDetails":
			err = unpopulate(val, "MarketplaceDetails", &f.MarketplaceDetails)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &f.NetworkProfile)
			delete(rawMsg, key)
		case "panEtag":
			err = unpopulate(val, "PanEtag", &f.PanEtag)
			delete(rawMsg, key)
		case "panoramaConfig":
			err = unpopulate(val, "PanoramaConfig", &f.PanoramaConfig)
			delete(rawMsg, key)
		case "planData":
			err = unpopulate(val, "PlanData", &f.PlanData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallStatusProperty.
func (f FirewallStatusProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "healthReason", f.HealthReason)
	populate(objectMap, "healthStatus", f.HealthStatus)
	populate(objectMap, "isPanoramaManaged", f.IsPanoramaManaged)
	populate(objectMap, "panoramaStatus", f.PanoramaStatus)
	populate(objectMap, "provisioningState", f.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallStatusProperty.
func (f *FirewallStatusProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "healthReason":
			err = unpopulate(val, "HealthReason", &f.HealthReason)
			delete(rawMsg, key)
		case "healthStatus":
			err = unpopulate(val, "HealthStatus", &f.HealthStatus)
			delete(rawMsg, key)
		case "isPanoramaManaged":
			err = unpopulate(val, "IsPanoramaManaged", &f.IsPanoramaManaged)
			delete(rawMsg, key)
		case "panoramaStatus":
			err = unpopulate(val, "PanoramaStatus", &f.PanoramaStatus)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &f.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallStatusResource.
func (f FirewallStatusResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "systemData", f.SystemData)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallStatusResource.
func (f *FirewallStatusResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &f.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallStatusResourceListResult.
func (f FirewallStatusResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallStatusResourceListResult.
func (f *FirewallStatusResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FqdnListGlobalRulestackResource.
func (f FqdnListGlobalRulestackResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "systemData", f.SystemData)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FqdnListGlobalRulestackResource.
func (f *FqdnListGlobalRulestackResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &f.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FqdnListGlobalRulestackResourceListResult.
func (f FqdnListGlobalRulestackResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FqdnListGlobalRulestackResourceListResult.
func (f *FqdnListGlobalRulestackResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FqdnListLocalRulestackResource.
func (f FqdnListLocalRulestackResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "systemData", f.SystemData)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FqdnListLocalRulestackResource.
func (f *FqdnListLocalRulestackResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &f.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FqdnListLocalRulestackResourceListResult.
func (f FqdnListLocalRulestackResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FqdnListLocalRulestackResourceListResult.
func (f *FqdnListLocalRulestackResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FqdnObject.
func (f FqdnObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "auditComment", f.AuditComment)
	populate(objectMap, "description", f.Description)
	populate(objectMap, "etag", f.Etag)
	populate(objectMap, "fqdnList", f.FqdnList)
	populate(objectMap, "provisioningState", f.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FqdnObject.
func (f *FqdnObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "auditComment":
			err = unpopulate(val, "AuditComment", &f.AuditComment)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &f.Description)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &f.Etag)
			delete(rawMsg, key)
		case "fqdnList":
			err = unpopulate(val, "FqdnList", &f.FqdnList)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &f.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FrontendSetting.
func (f FrontendSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendConfiguration", f.BackendConfiguration)
	populate(objectMap, "frontendConfiguration", f.FrontendConfiguration)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "protocol", f.Protocol)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FrontendSetting.
func (f *FrontendSetting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendConfiguration":
			err = unpopulate(val, "BackendConfiguration", &f.BackendConfiguration)
			delete(rawMsg, key)
		case "frontendConfiguration":
			err = unpopulate(val, "FrontendConfiguration", &f.FrontendConfiguration)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &f.Protocol)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GlobalRulestackInfo.
func (g GlobalRulestackInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureId", g.AzureID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GlobalRulestackInfo.
func (g *GlobalRulestackInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureId":
			err = unpopulate(val, "AzureID", &g.AzureID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GlobalRulestackResource.
func (g GlobalRulestackResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "identity", g.Identity)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "systemData", g.SystemData)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GlobalRulestackResource.
func (g *GlobalRulestackResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &g.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &g.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &g.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GlobalRulestackResourceListResult.
func (g GlobalRulestackResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", g.NextLink)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GlobalRulestackResourceListResult.
func (g *GlobalRulestackResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &g.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GlobalRulestackResourceUpdate.
func (g GlobalRulestackResourceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", g.Identity)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "properties", g.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GlobalRulestackResourceUpdate.
func (g *GlobalRulestackResourceUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &g.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &g.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GlobalRulestackResourceUpdateProperties.
func (g GlobalRulestackResourceUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "associatedSubscriptions", g.AssociatedSubscriptions)
	populate(objectMap, "defaultMode", g.DefaultMode)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "minAppIdVersion", g.MinAppIDVersion)
	populate(objectMap, "panEtag", g.PanEtag)
	populate(objectMap, "panLocation", g.PanLocation)
	populate(objectMap, "scope", g.Scope)
	populate(objectMap, "securityServices", g.SecurityServices)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GlobalRulestackResourceUpdateProperties.
func (g *GlobalRulestackResourceUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "associatedSubscriptions":
			err = unpopulate(val, "AssociatedSubscriptions", &g.AssociatedSubscriptions)
			delete(rawMsg, key)
		case "defaultMode":
			err = unpopulate(val, "DefaultMode", &g.DefaultMode)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "minAppIdVersion":
			err = unpopulate(val, "MinAppIDVersion", &g.MinAppIDVersion)
			delete(rawMsg, key)
		case "panEtag":
			err = unpopulate(val, "PanEtag", &g.PanEtag)
			delete(rawMsg, key)
		case "panLocation":
			err = unpopulate(val, "PanLocation", &g.PanLocation)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &g.Scope)
			delete(rawMsg, key)
		case "securityServices":
			err = unpopulate(val, "SecurityServices", &g.SecurityServices)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPAddress.
func (i IPAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", i.Address)
	populate(objectMap, "resourceId", i.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPAddress.
func (i *IPAddress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &i.Address)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &i.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPAddressSpace.
func (i IPAddressSpace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressSpace", i.AddressSpace)
	populate(objectMap, "resourceId", i.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPAddressSpace.
func (i *IPAddressSpace) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressSpace":
			err = unpopulate(val, "AddressSpace", &i.AddressSpace)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &i.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListAppIDResponse.
func (l ListAppIDResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListAppIDResponse.
func (l *ListAppIDResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListFirewallsResponse.
func (l ListFirewallsResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListFirewallsResponse.
func (l *ListFirewallsResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalRulesResource.
func (l LocalRulesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "systemData", l.SystemData)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalRulesResource.
func (l *LocalRulesResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &l.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalRulesResourceListResult.
func (l LocalRulesResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalRulesResourceListResult.
func (l *LocalRulesResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalRulestackResource.
func (l LocalRulestackResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "identity", l.Identity)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "systemData", l.SystemData)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalRulestackResource.
func (l *LocalRulestackResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &l.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &l.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalRulestackResourceListResult.
func (l LocalRulestackResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalRulestackResourceListResult.
func (l *LocalRulestackResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalRulestackResourceUpdate.
func (l LocalRulestackResourceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", l.Identity)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "tags", l.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalRulestackResourceUpdate.
func (l *LocalRulestackResourceUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &l.Identity)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalRulestackResourceUpdateProperties.
func (l LocalRulestackResourceUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "associatedSubscriptions", l.AssociatedSubscriptions)
	populate(objectMap, "defaultMode", l.DefaultMode)
	populate(objectMap, "description", l.Description)
	populate(objectMap, "minAppIdVersion", l.MinAppIDVersion)
	populate(objectMap, "panEtag", l.PanEtag)
	populate(objectMap, "panLocation", l.PanLocation)
	populate(objectMap, "scope", l.Scope)
	populate(objectMap, "securityServices", l.SecurityServices)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalRulestackResourceUpdateProperties.
func (l *LocalRulestackResourceUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "associatedSubscriptions":
			err = unpopulate(val, "AssociatedSubscriptions", &l.AssociatedSubscriptions)
			delete(rawMsg, key)
		case "defaultMode":
			err = unpopulate(val, "DefaultMode", &l.DefaultMode)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &l.Description)
			delete(rawMsg, key)
		case "minAppIdVersion":
			err = unpopulate(val, "MinAppIDVersion", &l.MinAppIDVersion)
			delete(rawMsg, key)
		case "panEtag":
			err = unpopulate(val, "PanEtag", &l.PanEtag)
			delete(rawMsg, key)
		case "panLocation":
			err = unpopulate(val, "PanLocation", &l.PanLocation)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &l.Scope)
			delete(rawMsg, key)
		case "securityServices":
			err = unpopulate(val, "SecurityServices", &l.SecurityServices)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogDestination.
func (l LogDestination) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eventHubConfigurations", l.EventHubConfigurations)
	populate(objectMap, "monitorConfigurations", l.MonitorConfigurations)
	populate(objectMap, "storageConfigurations", l.StorageConfigurations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogDestination.
func (l *LogDestination) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eventHubConfigurations":
			err = unpopulate(val, "EventHubConfigurations", &l.EventHubConfigurations)
			delete(rawMsg, key)
		case "monitorConfigurations":
			err = unpopulate(val, "MonitorConfigurations", &l.MonitorConfigurations)
			delete(rawMsg, key)
		case "storageConfigurations":
			err = unpopulate(val, "StorageConfigurations", &l.StorageConfigurations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogSettings.
func (l LogSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationInsights", l.ApplicationInsights)
	populate(objectMap, "commonDestination", l.CommonDestination)
	populate(objectMap, "decryptLogDestination", l.DecryptLogDestination)
	populate(objectMap, "logOption", l.LogOption)
	populate(objectMap, "logType", l.LogType)
	populate(objectMap, "threatLogDestination", l.ThreatLogDestination)
	populate(objectMap, "trafficLogDestination", l.TrafficLogDestination)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogSettings.
func (l *LogSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationInsights":
			err = unpopulate(val, "ApplicationInsights", &l.ApplicationInsights)
			delete(rawMsg, key)
		case "commonDestination":
			err = unpopulate(val, "CommonDestination", &l.CommonDestination)
			delete(rawMsg, key)
		case "decryptLogDestination":
			err = unpopulate(val, "DecryptLogDestination", &l.DecryptLogDestination)
			delete(rawMsg, key)
		case "logOption":
			err = unpopulate(val, "LogOption", &l.LogOption)
			delete(rawMsg, key)
		case "logType":
			err = unpopulate(val, "LogType", &l.LogType)
			delete(rawMsg, key)
		case "threatLogDestination":
			err = unpopulate(val, "ThreatLogDestination", &l.ThreatLogDestination)
			delete(rawMsg, key)
		case "trafficLogDestination":
			err = unpopulate(val, "TrafficLogDestination", &l.TrafficLogDestination)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MarketplaceDetails.
func (m MarketplaceDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "marketplaceSubscriptionId", m.MarketplaceSubscriptionID)
	populate(objectMap, "marketplaceSubscriptionStatus", m.MarketplaceSubscriptionStatus)
	populate(objectMap, "offerId", m.OfferID)
	populate(objectMap, "publisherId", m.PublisherID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MarketplaceDetails.
func (m *MarketplaceDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "marketplaceSubscriptionId":
			err = unpopulate(val, "MarketplaceSubscriptionID", &m.MarketplaceSubscriptionID)
			delete(rawMsg, key)
		case "marketplaceSubscriptionStatus":
			err = unpopulate(val, "MarketplaceSubscriptionStatus", &m.MarketplaceSubscriptionStatus)
			delete(rawMsg, key)
		case "offerId":
			err = unpopulate(val, "OfferID", &m.OfferID)
			delete(rawMsg, key)
		case "publisherId":
			err = unpopulate(val, "PublisherID", &m.PublisherID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MonitorLog.
func (m MonitorLog) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "primaryKey", m.PrimaryKey)
	populate(objectMap, "secondaryKey", m.SecondaryKey)
	populate(objectMap, "subscriptionId", m.SubscriptionID)
	populate(objectMap, "workspace", m.Workspace)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MonitorLog.
func (m *MonitorLog) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "primaryKey":
			err = unpopulate(val, "PrimaryKey", &m.PrimaryKey)
			delete(rawMsg, key)
		case "secondaryKey":
			err = unpopulate(val, "SecondaryKey", &m.SecondaryKey)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &m.SubscriptionID)
			delete(rawMsg, key)
		case "workspace":
			err = unpopulate(val, "Workspace", &m.Workspace)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NameDescriptionObject.
func (n NameDescriptionObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", n.Description)
	populate(objectMap, "name", n.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NameDescriptionObject.
func (n *NameDescriptionObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &n.Description)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkProfile.
func (n NetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "egressNatIp", n.EgressNatIP)
	populate(objectMap, "enableEgressNat", n.EnableEgressNat)
	populate(objectMap, "networkType", n.NetworkType)
	populate(objectMap, "publicIps", n.PublicIPs)
	populate(objectMap, "trustedRanges", n.TrustedRanges)
	populate(objectMap, "vnetConfiguration", n.VnetConfiguration)
	populate(objectMap, "vwanConfiguration", n.VwanConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkProfile.
func (n *NetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "egressNatIp":
			err = unpopulate(val, "EgressNatIP", &n.EgressNatIP)
			delete(rawMsg, key)
		case "enableEgressNat":
			err = unpopulate(val, "EnableEgressNat", &n.EnableEgressNat)
			delete(rawMsg, key)
		case "networkType":
			err = unpopulate(val, "NetworkType", &n.NetworkType)
			delete(rawMsg, key)
		case "publicIps":
			err = unpopulate(val, "PublicIPs", &n.PublicIPs)
			delete(rawMsg, key)
		case "trustedRanges":
			err = unpopulate(val, "TrustedRanges", &n.TrustedRanges)
			delete(rawMsg, key)
		case "vnetConfiguration":
			err = unpopulate(val, "VnetConfiguration", &n.VnetConfiguration)
			delete(rawMsg, key)
		case "vwanConfiguration":
			err = unpopulate(val, "VwanConfiguration", &n.VwanConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionType", o.ActionType)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &o.ActionType)
			delete(rawMsg, key)
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PanoramaConfig.
func (p PanoramaConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cgName", p.CgName)
	populate(objectMap, "configString", p.ConfigString)
	populate(objectMap, "dgName", p.DgName)
	populate(objectMap, "hostName", p.HostName)
	populate(objectMap, "panoramaServer", p.PanoramaServer)
	populate(objectMap, "panoramaServer2", p.PanoramaServer2)
	populate(objectMap, "tplName", p.TplName)
	populate(objectMap, "vmAuthKey", p.VMAuthKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PanoramaConfig.
func (p *PanoramaConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cgName":
			err = unpopulate(val, "CgName", &p.CgName)
			delete(rawMsg, key)
		case "configString":
			err = unpopulate(val, "ConfigString", &p.ConfigString)
			delete(rawMsg, key)
		case "dgName":
			err = unpopulate(val, "DgName", &p.DgName)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &p.HostName)
			delete(rawMsg, key)
		case "panoramaServer":
			err = unpopulate(val, "PanoramaServer", &p.PanoramaServer)
			delete(rawMsg, key)
		case "panoramaServer2":
			err = unpopulate(val, "PanoramaServer2", &p.PanoramaServer2)
			delete(rawMsg, key)
		case "tplName":
			err = unpopulate(val, "TplName", &p.TplName)
			delete(rawMsg, key)
		case "vmAuthKey":
			err = unpopulate(val, "VMAuthKey", &p.VMAuthKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PanoramaStatus.
func (p PanoramaStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "panoramaServer2Status", p.PanoramaServer2Status)
	populate(objectMap, "panoramaServerStatus", p.PanoramaServerStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PanoramaStatus.
func (p *PanoramaStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "panoramaServer2Status":
			err = unpopulate(val, "PanoramaServer2Status", &p.PanoramaServer2Status)
			delete(rawMsg, key)
		case "panoramaServerStatus":
			err = unpopulate(val, "PanoramaServerStatus", &p.PanoramaServerStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlanData.
func (p PlanData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingCycle", p.BillingCycle)
	populateDateTimeRFC3339(objectMap, "effectiveDate", p.EffectiveDate)
	populate(objectMap, "planId", p.PlanID)
	populate(objectMap, "usageType", p.UsageType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlanData.
func (p *PlanData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingCycle":
			err = unpopulate(val, "BillingCycle", &p.BillingCycle)
			delete(rawMsg, key)
		case "effectiveDate":
			err = unpopulateDateTimeRFC3339(val, "EffectiveDate", &p.EffectiveDate)
			delete(rawMsg, key)
		case "planId":
			err = unpopulate(val, "PlanID", &p.PlanID)
			delete(rawMsg, key)
		case "usageType":
			err = unpopulate(val, "UsageType", &p.UsageType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PostRulesResource.
func (p PostRulesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PostRulesResource.
func (p *PostRulesResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PostRulesResourceListResult.
func (p PostRulesResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PostRulesResourceListResult.
func (p *PostRulesResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PreRulesResource.
func (p PreRulesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PreRulesResource.
func (p *PreRulesResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PreRulesResourceListResult.
func (p PreRulesResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PreRulesResourceListResult.
func (p *PreRulesResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PredefinedURLCategoriesResponse.
func (p PredefinedURLCategoriesResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PredefinedURLCategoriesResponse.
func (p *PredefinedURLCategoriesResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PredefinedURLCategory.
func (p PredefinedURLCategory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", p.Action)
	populate(objectMap, "name", p.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PredefinedURLCategory.
func (p *PredefinedURLCategory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &p.Action)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrefixListGlobalRulestackResource.
func (p PrefixListGlobalRulestackResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrefixListGlobalRulestackResource.
func (p *PrefixListGlobalRulestackResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrefixListGlobalRulestackResourceListResult.
func (p PrefixListGlobalRulestackResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrefixListGlobalRulestackResourceListResult.
func (p *PrefixListGlobalRulestackResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrefixListResource.
func (p PrefixListResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrefixListResource.
func (p *PrefixListResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrefixListResourceListResult.
func (p PrefixListResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrefixListResourceListResult.
func (p *PrefixListResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrefixObject.
func (p PrefixObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "auditComment", p.AuditComment)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "prefixList", p.PrefixList)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrefixObject.
func (p *PrefixObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "auditComment":
			err = unpopulate(val, "AuditComment", &p.AuditComment)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "prefixList":
			err = unpopulate(val, "PrefixList", &p.PrefixList)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RuleCounter.
func (r RuleCounter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appSeen", r.AppSeen)
	populate(objectMap, "firewallName", r.FirewallName)
	populate(objectMap, "hitCount", r.HitCount)
	populateDateTimeRFC3339(objectMap, "lastUpdatedTimestamp", r.LastUpdatedTimestamp)
	populate(objectMap, "priority", r.Priority)
	populateDateTimeRFC3339(objectMap, "requestTimestamp", r.RequestTimestamp)
	populate(objectMap, "ruleListName", r.RuleListName)
	populate(objectMap, "ruleName", r.RuleName)
	populate(objectMap, "ruleStackName", r.RuleStackName)
	populateDateTimeRFC3339(objectMap, "timestamp", r.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuleCounter.
func (r *RuleCounter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appSeen":
			err = unpopulate(val, "AppSeen", &r.AppSeen)
			delete(rawMsg, key)
		case "firewallName":
			err = unpopulate(val, "FirewallName", &r.FirewallName)
			delete(rawMsg, key)
		case "hitCount":
			err = unpopulate(val, "HitCount", &r.HitCount)
			delete(rawMsg, key)
		case "lastUpdatedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "LastUpdatedTimestamp", &r.LastUpdatedTimestamp)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &r.Priority)
			delete(rawMsg, key)
		case "requestTimestamp":
			err = unpopulateDateTimeRFC3339(val, "RequestTimestamp", &r.RequestTimestamp)
			delete(rawMsg, key)
		case "ruleListName":
			err = unpopulate(val, "RuleListName", &r.RuleListName)
			delete(rawMsg, key)
		case "ruleName":
			err = unpopulate(val, "RuleName", &r.RuleName)
			delete(rawMsg, key)
		case "ruleStackName":
			err = unpopulate(val, "RuleStackName", &r.RuleStackName)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &r.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RuleCounterReset.
func (r RuleCounterReset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "firewallName", r.FirewallName)
	populate(objectMap, "priority", r.Priority)
	populate(objectMap, "ruleListName", r.RuleListName)
	populate(objectMap, "ruleName", r.RuleName)
	populate(objectMap, "ruleStackName", r.RuleStackName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuleCounterReset.
func (r *RuleCounterReset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "firewallName":
			err = unpopulate(val, "FirewallName", &r.FirewallName)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &r.Priority)
			delete(rawMsg, key)
		case "ruleListName":
			err = unpopulate(val, "RuleListName", &r.RuleListName)
			delete(rawMsg, key)
		case "ruleName":
			err = unpopulate(val, "RuleName", &r.RuleName)
			delete(rawMsg, key)
		case "ruleStackName":
			err = unpopulate(val, "RuleStackName", &r.RuleStackName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RuleEntry.
func (r RuleEntry) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionType", r.ActionType)
	populate(objectMap, "applications", r.Applications)
	populate(objectMap, "auditComment", r.AuditComment)
	populate(objectMap, "category", r.Category)
	populate(objectMap, "decryptionRuleType", r.DecryptionRuleType)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "destination", r.Destination)
	populate(objectMap, "enableLogging", r.EnableLogging)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "inboundInspectionCertificate", r.InboundInspectionCertificate)
	populate(objectMap, "negateDestination", r.NegateDestination)
	populate(objectMap, "negateSource", r.NegateSource)
	populate(objectMap, "priority", r.Priority)
	populate(objectMap, "protocol", r.Protocol)
	populate(objectMap, "protocolPortList", r.ProtocolPortList)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "ruleName", r.RuleName)
	populate(objectMap, "ruleState", r.RuleState)
	populate(objectMap, "source", r.Source)
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RuleEntry.
func (r *RuleEntry) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &r.ActionType)
			delete(rawMsg, key)
		case "applications":
			err = unpopulate(val, "Applications", &r.Applications)
			delete(rawMsg, key)
		case "auditComment":
			err = unpopulate(val, "AuditComment", &r.AuditComment)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &r.Category)
			delete(rawMsg, key)
		case "decryptionRuleType":
			err = unpopulate(val, "DecryptionRuleType", &r.DecryptionRuleType)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "destination":
			err = unpopulate(val, "Destination", &r.Destination)
			delete(rawMsg, key)
		case "enableLogging":
			err = unpopulate(val, "EnableLogging", &r.EnableLogging)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "inboundInspectionCertificate":
			err = unpopulate(val, "InboundInspectionCertificate", &r.InboundInspectionCertificate)
			delete(rawMsg, key)
		case "negateDestination":
			err = unpopulate(val, "NegateDestination", &r.NegateDestination)
			delete(rawMsg, key)
		case "negateSource":
			err = unpopulate(val, "NegateSource", &r.NegateSource)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &r.Priority)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &r.Protocol)
			delete(rawMsg, key)
		case "protocolPortList":
			err = unpopulate(val, "ProtocolPortList", &r.ProtocolPortList)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "ruleName":
			err = unpopulate(val, "RuleName", &r.RuleName)
			delete(rawMsg, key)
		case "ruleState":
			err = unpopulate(val, "RuleState", &r.RuleState)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &r.Source)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RulestackDetails.
func (r RulestackDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "resourceId", r.ResourceID)
	populate(objectMap, "rulestackId", r.RulestackID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RulestackDetails.
func (r *RulestackDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &r.ResourceID)
			delete(rawMsg, key)
		case "rulestackId":
			err = unpopulate(val, "RulestackID", &r.RulestackID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RulestackProperties.
func (r RulestackProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "associatedSubscriptions", r.AssociatedSubscriptions)
	populate(objectMap, "defaultMode", r.DefaultMode)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "minAppIdVersion", r.MinAppIDVersion)
	populate(objectMap, "panEtag", r.PanEtag)
	populate(objectMap, "panLocation", r.PanLocation)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "scope", r.Scope)
	populate(objectMap, "securityServices", r.SecurityServices)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RulestackProperties.
func (r *RulestackProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "associatedSubscriptions":
			err = unpopulate(val, "AssociatedSubscriptions", &r.AssociatedSubscriptions)
			delete(rawMsg, key)
		case "defaultMode":
			err = unpopulate(val, "DefaultMode", &r.DefaultMode)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "minAppIdVersion":
			err = unpopulate(val, "MinAppIDVersion", &r.MinAppIDVersion)
			delete(rawMsg, key)
		case "panEtag":
			err = unpopulate(val, "PanEtag", &r.PanEtag)
			delete(rawMsg, key)
		case "panLocation":
			err = unpopulate(val, "PanLocation", &r.PanLocation)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &r.Scope)
			delete(rawMsg, key)
		case "securityServices":
			err = unpopulate(val, "SecurityServices", &r.SecurityServices)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityServices.
func (s SecurityServices) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "antiSpywareProfile", s.AntiSpywareProfile)
	populate(objectMap, "antiVirusProfile", s.AntiVirusProfile)
	populate(objectMap, "dnsSubscription", s.DNSSubscription)
	populate(objectMap, "fileBlockingProfile", s.FileBlockingProfile)
	populate(objectMap, "outboundTrustCertificate", s.OutboundTrustCertificate)
	populate(objectMap, "outboundUnTrustCertificate", s.OutboundUnTrustCertificate)
	populate(objectMap, "urlFilteringProfile", s.URLFilteringProfile)
	populate(objectMap, "vulnerabilityProfile", s.VulnerabilityProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityServices.
func (s *SecurityServices) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "antiSpywareProfile":
			err = unpopulate(val, "AntiSpywareProfile", &s.AntiSpywareProfile)
			delete(rawMsg, key)
		case "antiVirusProfile":
			err = unpopulate(val, "AntiVirusProfile", &s.AntiVirusProfile)
			delete(rawMsg, key)
		case "dnsSubscription":
			err = unpopulate(val, "DNSSubscription", &s.DNSSubscription)
			delete(rawMsg, key)
		case "fileBlockingProfile":
			err = unpopulate(val, "FileBlockingProfile", &s.FileBlockingProfile)
			delete(rawMsg, key)
		case "outboundTrustCertificate":
			err = unpopulate(val, "OutboundTrustCertificate", &s.OutboundTrustCertificate)
			delete(rawMsg, key)
		case "outboundUnTrustCertificate":
			err = unpopulate(val, "OutboundUnTrustCertificate", &s.OutboundUnTrustCertificate)
			delete(rawMsg, key)
		case "urlFilteringProfile":
			err = unpopulate(val, "URLFilteringProfile", &s.URLFilteringProfile)
			delete(rawMsg, key)
		case "vulnerabilityProfile":
			err = unpopulate(val, "VulnerabilityProfile", &s.VulnerabilityProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityServicesResponse.
func (s SecurityServicesResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityServicesResponse.
func (s *SecurityServicesResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityServicesTypeList.
func (s SecurityServicesTypeList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "entry", s.Entry)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityServicesTypeList.
func (s *SecurityServicesTypeList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "entry":
			err = unpopulate(val, "Entry", &s.Entry)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceAddr.
func (s SourceAddr) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cidrs", s.Cidrs)
	populate(objectMap, "countries", s.Countries)
	populate(objectMap, "feeds", s.Feeds)
	populate(objectMap, "prefixLists", s.PrefixLists)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceAddr.
func (s *SourceAddr) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cidrs":
			err = unpopulate(val, "Cidrs", &s.Cidrs)
			delete(rawMsg, key)
		case "countries":
			err = unpopulate(val, "Countries", &s.Countries)
			delete(rawMsg, key)
		case "feeds":
			err = unpopulate(val, "Feeds", &s.Feeds)
			delete(rawMsg, key)
		case "prefixLists":
			err = unpopulate(val, "PrefixLists", &s.PrefixLists)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageAccount.
func (s StorageAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountName", s.AccountName)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "subscriptionId", s.SubscriptionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageAccount.
func (s *StorageAccount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &s.AccountName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &s.SubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SupportInfo.
func (s SupportInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountId", s.AccountID)
	populate(objectMap, "accountRegistered", s.AccountRegistered)
	populate(objectMap, "freeTrial", s.FreeTrial)
	populate(objectMap, "freeTrialCreditLeft", s.FreeTrialCreditLeft)
	populate(objectMap, "freeTrialDaysLeft", s.FreeTrialDaysLeft)
	populate(objectMap, "helpURL", s.HelpURL)
	populate(objectMap, "productSku", s.ProductSKU)
	populate(objectMap, "productSerial", s.ProductSerial)
	populate(objectMap, "registerURL", s.RegisterURL)
	populate(objectMap, "supportURL", s.SupportURL)
	populate(objectMap, "userDomainSupported", s.UserDomainSupported)
	populate(objectMap, "userRegistered", s.UserRegistered)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SupportInfo.
func (s *SupportInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountId":
			err = unpopulate(val, "AccountID", &s.AccountID)
			delete(rawMsg, key)
		case "accountRegistered":
			err = unpopulate(val, "AccountRegistered", &s.AccountRegistered)
			delete(rawMsg, key)
		case "freeTrial":
			err = unpopulate(val, "FreeTrial", &s.FreeTrial)
			delete(rawMsg, key)
		case "freeTrialCreditLeft":
			err = unpopulate(val, "FreeTrialCreditLeft", &s.FreeTrialCreditLeft)
			delete(rawMsg, key)
		case "freeTrialDaysLeft":
			err = unpopulate(val, "FreeTrialDaysLeft", &s.FreeTrialDaysLeft)
			delete(rawMsg, key)
		case "helpURL":
			err = unpopulate(val, "HelpURL", &s.HelpURL)
			delete(rawMsg, key)
		case "productSku":
			err = unpopulate(val, "ProductSKU", &s.ProductSKU)
			delete(rawMsg, key)
		case "productSerial":
			err = unpopulate(val, "ProductSerial", &s.ProductSerial)
			delete(rawMsg, key)
		case "registerURL":
			err = unpopulate(val, "RegisterURL", &s.RegisterURL)
			delete(rawMsg, key)
		case "supportURL":
			err = unpopulate(val, "SupportURL", &s.SupportURL)
			delete(rawMsg, key)
		case "userDomainSupported":
			err = unpopulate(val, "UserDomainSupported", &s.UserDomainSupported)
			delete(rawMsg, key)
		case "userRegistered":
			err = unpopulate(val, "UserRegistered", &s.UserRegistered)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagInfo.
func (t TagInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "key", t.Key)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagInfo.
func (t *TagInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &t.Key)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetConfiguration.
func (v VnetConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipOfTrustSubnetForUdr", v.IPOfTrustSubnetForUdr)
	populate(objectMap, "trustSubnet", v.TrustSubnet)
	populate(objectMap, "unTrustSubnet", v.UnTrustSubnet)
	populate(objectMap, "vnet", v.Vnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetConfiguration.
func (v *VnetConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipOfTrustSubnetForUdr":
			err = unpopulate(val, "IPOfTrustSubnetForUdr", &v.IPOfTrustSubnetForUdr)
			delete(rawMsg, key)
		case "trustSubnet":
			err = unpopulate(val, "TrustSubnet", &v.TrustSubnet)
			delete(rawMsg, key)
		case "unTrustSubnet":
			err = unpopulate(val, "UnTrustSubnet", &v.UnTrustSubnet)
			delete(rawMsg, key)
		case "vnet":
			err = unpopulate(val, "Vnet", &v.Vnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VwanConfiguration.
func (v VwanConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipOfTrustSubnetForUdr", v.IPOfTrustSubnetForUdr)
	populate(objectMap, "networkVirtualApplianceId", v.NetworkVirtualApplianceID)
	populate(objectMap, "trustSubnet", v.TrustSubnet)
	populate(objectMap, "unTrustSubnet", v.UnTrustSubnet)
	populate(objectMap, "vHub", v.VHub)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VwanConfiguration.
func (v *VwanConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipOfTrustSubnetForUdr":
			err = unpopulate(val, "IPOfTrustSubnetForUdr", &v.IPOfTrustSubnetForUdr)
			delete(rawMsg, key)
		case "networkVirtualApplianceId":
			err = unpopulate(val, "NetworkVirtualApplianceID", &v.NetworkVirtualApplianceID)
			delete(rawMsg, key)
		case "trustSubnet":
			err = unpopulate(val, "TrustSubnet", &v.TrustSubnet)
			delete(rawMsg, key)
		case "unTrustSubnet":
			err = unpopulate(val, "UnTrustSubnet", &v.UnTrustSubnet)
			delete(rawMsg, key)
		case "vHub":
			err = unpopulate(val, "VHub", &v.VHub)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
