//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/paloaltonetworksngfw/armpanngfw"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// LocalRulestacksServer is a fake server for instances of the armpanngfw.LocalRulestacksClient type.
type LocalRulestacksServer struct {
	// BeginCommit is the fake for method LocalRulestacksClient.BeginCommit
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginCommit func(ctx context.Context, resourceGroupName string, localRulestackName string, options *armpanngfw.LocalRulestacksClientBeginCommitOptions) (resp azfake.PollerResponder[armpanngfw.LocalRulestacksClientCommitResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method LocalRulestacksClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, localRulestackName string, resource armpanngfw.LocalRulestackResource, options *armpanngfw.LocalRulestacksClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armpanngfw.LocalRulestacksClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method LocalRulestacksClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, localRulestackName string, options *armpanngfw.LocalRulestacksClientBeginDeleteOptions) (resp azfake.PollerResponder[armpanngfw.LocalRulestacksClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method LocalRulestacksClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, localRulestackName string, options *armpanngfw.LocalRulestacksClientGetOptions) (resp azfake.Responder[armpanngfw.LocalRulestacksClientGetResponse], errResp azfake.ErrorResponder)

	// GetChangeLog is the fake for method LocalRulestacksClient.GetChangeLog
	// HTTP status codes to indicate success: http.StatusOK
	GetChangeLog func(ctx context.Context, resourceGroupName string, localRulestackName string, options *armpanngfw.LocalRulestacksClientGetChangeLogOptions) (resp azfake.Responder[armpanngfw.LocalRulestacksClientGetChangeLogResponse], errResp azfake.ErrorResponder)

	// GetSupportInfo is the fake for method LocalRulestacksClient.GetSupportInfo
	// HTTP status codes to indicate success: http.StatusOK
	GetSupportInfo func(ctx context.Context, resourceGroupName string, localRulestackName string, options *armpanngfw.LocalRulestacksClientGetSupportInfoOptions) (resp azfake.Responder[armpanngfw.LocalRulestacksClientGetSupportInfoResponse], errResp azfake.ErrorResponder)

	// ListAdvancedSecurityObjects is the fake for method LocalRulestacksClient.ListAdvancedSecurityObjects
	// HTTP status codes to indicate success: http.StatusOK
	ListAdvancedSecurityObjects func(ctx context.Context, resourceGroupName string, localRulestackName string, typeParam armpanngfw.AdvSecurityObjectTypeEnum, options *armpanngfw.LocalRulestacksClientListAdvancedSecurityObjectsOptions) (resp azfake.Responder[armpanngfw.LocalRulestacksClientListAdvancedSecurityObjectsResponse], errResp azfake.ErrorResponder)

	// ListAppIDs is the fake for method LocalRulestacksClient.ListAppIDs
	// HTTP status codes to indicate success: http.StatusOK
	ListAppIDs func(ctx context.Context, resourceGroupName string, localRulestackName string, options *armpanngfw.LocalRulestacksClientListAppIDsOptions) (resp azfake.Responder[armpanngfw.LocalRulestacksClientListAppIDsResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method LocalRulestacksClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armpanngfw.LocalRulestacksClientListByResourceGroupOptions) (resp azfake.PagerResponder[armpanngfw.LocalRulestacksClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method LocalRulestacksClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armpanngfw.LocalRulestacksClientListBySubscriptionOptions) (resp azfake.PagerResponder[armpanngfw.LocalRulestacksClientListBySubscriptionResponse])

	// ListCountries is the fake for method LocalRulestacksClient.ListCountries
	// HTTP status codes to indicate success: http.StatusOK
	ListCountries func(ctx context.Context, resourceGroupName string, localRulestackName string, options *armpanngfw.LocalRulestacksClientListCountriesOptions) (resp azfake.Responder[armpanngfw.LocalRulestacksClientListCountriesResponse], errResp azfake.ErrorResponder)

	// ListFirewalls is the fake for method LocalRulestacksClient.ListFirewalls
	// HTTP status codes to indicate success: http.StatusOK
	ListFirewalls func(ctx context.Context, resourceGroupName string, localRulestackName string, options *armpanngfw.LocalRulestacksClientListFirewallsOptions) (resp azfake.Responder[armpanngfw.LocalRulestacksClientListFirewallsResponse], errResp azfake.ErrorResponder)

	// ListPredefinedURLCategories is the fake for method LocalRulestacksClient.ListPredefinedURLCategories
	// HTTP status codes to indicate success: http.StatusOK
	ListPredefinedURLCategories func(ctx context.Context, resourceGroupName string, localRulestackName string, options *armpanngfw.LocalRulestacksClientListPredefinedURLCategoriesOptions) (resp azfake.Responder[armpanngfw.LocalRulestacksClientListPredefinedURLCategoriesResponse], errResp azfake.ErrorResponder)

	// ListSecurityServices is the fake for method LocalRulestacksClient.ListSecurityServices
	// HTTP status codes to indicate success: http.StatusOK
	ListSecurityServices func(ctx context.Context, resourceGroupName string, localRulestackName string, typeParam armpanngfw.SecurityServicesTypeEnum, options *armpanngfw.LocalRulestacksClientListSecurityServicesOptions) (resp azfake.Responder[armpanngfw.LocalRulestacksClientListSecurityServicesResponse], errResp azfake.ErrorResponder)

	// Revert is the fake for method LocalRulestacksClient.Revert
	// HTTP status codes to indicate success: http.StatusNoContent
	Revert func(ctx context.Context, resourceGroupName string, localRulestackName string, options *armpanngfw.LocalRulestacksClientRevertOptions) (resp azfake.Responder[armpanngfw.LocalRulestacksClientRevertResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method LocalRulestacksClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, localRulestackName string, properties armpanngfw.LocalRulestackResourceUpdate, options *armpanngfw.LocalRulestacksClientUpdateOptions) (resp azfake.Responder[armpanngfw.LocalRulestacksClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewLocalRulestacksServerTransport creates a new instance of LocalRulestacksServerTransport with the provided implementation.
// The returned LocalRulestacksServerTransport instance is connected to an instance of armpanngfw.LocalRulestacksClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewLocalRulestacksServerTransport(srv *LocalRulestacksServer) *LocalRulestacksServerTransport {
	return &LocalRulestacksServerTransport{
		srv:                         srv,
		beginCommit:                 newTracker[azfake.PollerResponder[armpanngfw.LocalRulestacksClientCommitResponse]](),
		beginCreateOrUpdate:         newTracker[azfake.PollerResponder[armpanngfw.LocalRulestacksClientCreateOrUpdateResponse]](),
		beginDelete:                 newTracker[azfake.PollerResponder[armpanngfw.LocalRulestacksClientDeleteResponse]](),
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armpanngfw.LocalRulestacksClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:  newTracker[azfake.PagerResponder[armpanngfw.LocalRulestacksClientListBySubscriptionResponse]](),
	}
}

// LocalRulestacksServerTransport connects instances of armpanngfw.LocalRulestacksClient to instances of LocalRulestacksServer.
// Don't use this type directly, use NewLocalRulestacksServerTransport instead.
type LocalRulestacksServerTransport struct {
	srv                         *LocalRulestacksServer
	beginCommit                 *tracker[azfake.PollerResponder[armpanngfw.LocalRulestacksClientCommitResponse]]
	beginCreateOrUpdate         *tracker[azfake.PollerResponder[armpanngfw.LocalRulestacksClientCreateOrUpdateResponse]]
	beginDelete                 *tracker[azfake.PollerResponder[armpanngfw.LocalRulestacksClientDeleteResponse]]
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armpanngfw.LocalRulestacksClientListByResourceGroupResponse]]
	newListBySubscriptionPager  *tracker[azfake.PagerResponder[armpanngfw.LocalRulestacksClientListBySubscriptionResponse]]
}

// Do implements the policy.Transporter interface for LocalRulestacksServerTransport.
func (l *LocalRulestacksServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "LocalRulestacksClient.BeginCommit":
		resp, err = l.dispatchBeginCommit(req)
	case "LocalRulestacksClient.BeginCreateOrUpdate":
		resp, err = l.dispatchBeginCreateOrUpdate(req)
	case "LocalRulestacksClient.BeginDelete":
		resp, err = l.dispatchBeginDelete(req)
	case "LocalRulestacksClient.Get":
		resp, err = l.dispatchGet(req)
	case "LocalRulestacksClient.GetChangeLog":
		resp, err = l.dispatchGetChangeLog(req)
	case "LocalRulestacksClient.GetSupportInfo":
		resp, err = l.dispatchGetSupportInfo(req)
	case "LocalRulestacksClient.ListAdvancedSecurityObjects":
		resp, err = l.dispatchListAdvancedSecurityObjects(req)
	case "LocalRulestacksClient.ListAppIDs":
		resp, err = l.dispatchListAppIDs(req)
	case "LocalRulestacksClient.NewListByResourceGroupPager":
		resp, err = l.dispatchNewListByResourceGroupPager(req)
	case "LocalRulestacksClient.NewListBySubscriptionPager":
		resp, err = l.dispatchNewListBySubscriptionPager(req)
	case "LocalRulestacksClient.ListCountries":
		resp, err = l.dispatchListCountries(req)
	case "LocalRulestacksClient.ListFirewalls":
		resp, err = l.dispatchListFirewalls(req)
	case "LocalRulestacksClient.ListPredefinedURLCategories":
		resp, err = l.dispatchListPredefinedURLCategories(req)
	case "LocalRulestacksClient.ListSecurityServices":
		resp, err = l.dispatchListSecurityServices(req)
	case "LocalRulestacksClient.Revert":
		resp, err = l.dispatchRevert(req)
	case "LocalRulestacksClient.Update":
		resp, err = l.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (l *LocalRulestacksServerTransport) dispatchBeginCommit(req *http.Request) (*http.Response, error) {
	if l.srv.BeginCommit == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCommit not implemented")}
	}
	beginCommit := l.beginCommit.get(req)
	if beginCommit == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks/(?P<localRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/commit`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		localRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("localRulestackName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginCommit(req.Context(), resourceGroupNameParam, localRulestackNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCommit = &respr
		l.beginCommit.add(req, beginCommit)
	}

	resp, err := server.PollerResponderNext(beginCommit, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		l.beginCommit.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCommit) {
		l.beginCommit.remove(req)
	}

	return resp, nil
}

func (l *LocalRulestacksServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if l.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := l.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks/(?P<localRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armpanngfw.LocalRulestackResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		localRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("localRulestackName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, localRulestackNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		l.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		l.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		l.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (l *LocalRulestacksServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if l.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := l.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks/(?P<localRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		localRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("localRulestackName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginDelete(req.Context(), resourceGroupNameParam, localRulestackNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		l.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		l.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		l.beginDelete.remove(req)
	}

	return resp, nil
}

func (l *LocalRulestacksServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if l.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks/(?P<localRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	localRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("localRulestackName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.Get(req.Context(), resourceGroupNameParam, localRulestackNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).LocalRulestackResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LocalRulestacksServerTransport) dispatchGetChangeLog(req *http.Request) (*http.Response, error) {
	if l.srv.GetChangeLog == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetChangeLog not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks/(?P<localRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getChangeLog`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	localRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("localRulestackName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.GetChangeLog(req.Context(), resourceGroupNameParam, localRulestackNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Changelog, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LocalRulestacksServerTransport) dispatchGetSupportInfo(req *http.Request) (*http.Response, error) {
	if l.srv.GetSupportInfo == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSupportInfo not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks/(?P<localRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getSupportInfo`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	localRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("localRulestackName")])
	if err != nil {
		return nil, err
	}
	emailUnescaped, err := url.QueryUnescape(qp.Get("email"))
	if err != nil {
		return nil, err
	}
	emailParam := getOptional(emailUnescaped)
	var options *armpanngfw.LocalRulestacksClientGetSupportInfoOptions
	if emailParam != nil {
		options = &armpanngfw.LocalRulestacksClientGetSupportInfoOptions{
			Email: emailParam,
		}
	}
	respr, errRespr := l.srv.GetSupportInfo(req.Context(), resourceGroupNameParam, localRulestackNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SupportInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LocalRulestacksServerTransport) dispatchListAdvancedSecurityObjects(req *http.Request) (*http.Response, error) {
	if l.srv.ListAdvancedSecurityObjects == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListAdvancedSecurityObjects not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks/(?P<localRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listAdvancedSecurityObjects`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	localRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("localRulestackName")])
	if err != nil {
		return nil, err
	}
	skipUnescaped, err := url.QueryUnescape(qp.Get("skip"))
	if err != nil {
		return nil, err
	}
	skipParam := getOptional(skipUnescaped)
	topUnescaped, err := url.QueryUnescape(qp.Get("top"))
	if err != nil {
		return nil, err
	}
	topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	typeParamParam, err := parseWithCast(qp.Get("type"), func(v string) (armpanngfw.AdvSecurityObjectTypeEnum, error) {
		p, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armpanngfw.AdvSecurityObjectTypeEnum(p), nil
	})
	if err != nil {
		return nil, err
	}
	var options *armpanngfw.LocalRulestacksClientListAdvancedSecurityObjectsOptions
	if skipParam != nil || topParam != nil {
		options = &armpanngfw.LocalRulestacksClientListAdvancedSecurityObjectsOptions{
			Skip: skipParam,
			Top:  topParam,
		}
	}
	respr, errRespr := l.srv.ListAdvancedSecurityObjects(req.Context(), resourceGroupNameParam, localRulestackNameParam, typeParamParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AdvSecurityObjectListResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LocalRulestacksServerTransport) dispatchListAppIDs(req *http.Request) (*http.Response, error) {
	if l.srv.ListAppIDs == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListAppIDs not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks/(?P<localRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listAppIds`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	localRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("localRulestackName")])
	if err != nil {
		return nil, err
	}
	appIDVersionUnescaped, err := url.QueryUnescape(qp.Get("appIdVersion"))
	if err != nil {
		return nil, err
	}
	appIDVersionParam := getOptional(appIDVersionUnescaped)
	appPrefixUnescaped, err := url.QueryUnescape(qp.Get("appPrefix"))
	if err != nil {
		return nil, err
	}
	appPrefixParam := getOptional(appPrefixUnescaped)
	skipUnescaped, err := url.QueryUnescape(qp.Get("skip"))
	if err != nil {
		return nil, err
	}
	skipParam := getOptional(skipUnescaped)
	topUnescaped, err := url.QueryUnescape(qp.Get("top"))
	if err != nil {
		return nil, err
	}
	topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	var options *armpanngfw.LocalRulestacksClientListAppIDsOptions
	if appIDVersionParam != nil || appPrefixParam != nil || skipParam != nil || topParam != nil {
		options = &armpanngfw.LocalRulestacksClientListAppIDsOptions{
			AppIDVersion: appIDVersionParam,
			AppPrefix:    appPrefixParam,
			Skip:         skipParam,
			Top:          topParam,
		}
	}
	respr, errRespr := l.srv.ListAppIDs(req.Context(), resourceGroupNameParam, localRulestackNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ListAppIDResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LocalRulestacksServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := l.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := l.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		l.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armpanngfw.LocalRulestacksClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		l.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (l *LocalRulestacksServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := l.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := l.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		l.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armpanngfw.LocalRulestacksClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		l.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (l *LocalRulestacksServerTransport) dispatchListCountries(req *http.Request) (*http.Response, error) {
	if l.srv.ListCountries == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListCountries not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks/(?P<localRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listCountries`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	localRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("localRulestackName")])
	if err != nil {
		return nil, err
	}
	skipUnescaped, err := url.QueryUnescape(qp.Get("skip"))
	if err != nil {
		return nil, err
	}
	skipParam := getOptional(skipUnescaped)
	topUnescaped, err := url.QueryUnescape(qp.Get("top"))
	if err != nil {
		return nil, err
	}
	topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	var options *armpanngfw.LocalRulestacksClientListCountriesOptions
	if skipParam != nil || topParam != nil {
		options = &armpanngfw.LocalRulestacksClientListCountriesOptions{
			Skip: skipParam,
			Top:  topParam,
		}
	}
	respr, errRespr := l.srv.ListCountries(req.Context(), resourceGroupNameParam, localRulestackNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CountriesResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LocalRulestacksServerTransport) dispatchListFirewalls(req *http.Request) (*http.Response, error) {
	if l.srv.ListFirewalls == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListFirewalls not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks/(?P<localRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listFirewalls`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	localRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("localRulestackName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.ListFirewalls(req.Context(), resourceGroupNameParam, localRulestackNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ListFirewallsResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LocalRulestacksServerTransport) dispatchListPredefinedURLCategories(req *http.Request) (*http.Response, error) {
	if l.srv.ListPredefinedURLCategories == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListPredefinedURLCategories not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks/(?P<localRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listPredefinedUrlCategories`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	localRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("localRulestackName")])
	if err != nil {
		return nil, err
	}
	skipUnescaped, err := url.QueryUnescape(qp.Get("skip"))
	if err != nil {
		return nil, err
	}
	skipParam := getOptional(skipUnescaped)
	topUnescaped, err := url.QueryUnescape(qp.Get("top"))
	if err != nil {
		return nil, err
	}
	topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	var options *armpanngfw.LocalRulestacksClientListPredefinedURLCategoriesOptions
	if skipParam != nil || topParam != nil {
		options = &armpanngfw.LocalRulestacksClientListPredefinedURLCategoriesOptions{
			Skip: skipParam,
			Top:  topParam,
		}
	}
	respr, errRespr := l.srv.ListPredefinedURLCategories(req.Context(), resourceGroupNameParam, localRulestackNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PredefinedURLCategoriesResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LocalRulestacksServerTransport) dispatchListSecurityServices(req *http.Request) (*http.Response, error) {
	if l.srv.ListSecurityServices == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListSecurityServices not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks/(?P<localRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listSecurityServices`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	localRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("localRulestackName")])
	if err != nil {
		return nil, err
	}
	skipUnescaped, err := url.QueryUnescape(qp.Get("skip"))
	if err != nil {
		return nil, err
	}
	skipParam := getOptional(skipUnescaped)
	topUnescaped, err := url.QueryUnescape(qp.Get("top"))
	if err != nil {
		return nil, err
	}
	topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	typeParamParam, err := parseWithCast(qp.Get("type"), func(v string) (armpanngfw.SecurityServicesTypeEnum, error) {
		p, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armpanngfw.SecurityServicesTypeEnum(p), nil
	})
	if err != nil {
		return nil, err
	}
	var options *armpanngfw.LocalRulestacksClientListSecurityServicesOptions
	if skipParam != nil || topParam != nil {
		options = &armpanngfw.LocalRulestacksClientListSecurityServicesOptions{
			Skip: skipParam,
			Top:  topParam,
		}
	}
	respr, errRespr := l.srv.ListSecurityServices(req.Context(), resourceGroupNameParam, localRulestackNameParam, typeParamParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SecurityServicesResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LocalRulestacksServerTransport) dispatchRevert(req *http.Request) (*http.Response, error) {
	if l.srv.Revert == nil {
		return nil, &nonRetriableError{errors.New("fake for method Revert not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks/(?P<localRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/revert`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	localRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("localRulestackName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.Revert(req.Context(), resourceGroupNameParam, localRulestackNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LocalRulestacksServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if l.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks/(?P<localRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpanngfw.LocalRulestackResourceUpdate](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	localRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("localRulestackName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.Update(req.Context(), resourceGroupNameParam, localRulestackNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).LocalRulestackResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
