//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/paloaltonetworksngfw/armpanngfw"
	"net/http"
	"net/url"
	"regexp"
)

// CertificateObjectLocalRulestackServer is a fake server for instances of the armpanngfw.CertificateObjectLocalRulestackClient type.
type CertificateObjectLocalRulestackServer struct {
	// BeginCreateOrUpdate is the fake for method CertificateObjectLocalRulestackClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, localRulestackName string, name string, resource armpanngfw.CertificateObjectLocalRulestackResource, options *armpanngfw.CertificateObjectLocalRulestackClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armpanngfw.CertificateObjectLocalRulestackClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method CertificateObjectLocalRulestackClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, localRulestackName string, name string, options *armpanngfw.CertificateObjectLocalRulestackClientBeginDeleteOptions) (resp azfake.PollerResponder[armpanngfw.CertificateObjectLocalRulestackClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method CertificateObjectLocalRulestackClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, localRulestackName string, name string, options *armpanngfw.CertificateObjectLocalRulestackClientGetOptions) (resp azfake.Responder[armpanngfw.CertificateObjectLocalRulestackClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByLocalRulestacksPager is the fake for method CertificateObjectLocalRulestackClient.NewListByLocalRulestacksPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByLocalRulestacksPager func(resourceGroupName string, localRulestackName string, options *armpanngfw.CertificateObjectLocalRulestackClientListByLocalRulestacksOptions) (resp azfake.PagerResponder[armpanngfw.CertificateObjectLocalRulestackClientListByLocalRulestacksResponse])
}

// NewCertificateObjectLocalRulestackServerTransport creates a new instance of CertificateObjectLocalRulestackServerTransport with the provided implementation.
// The returned CertificateObjectLocalRulestackServerTransport instance is connected to an instance of armpanngfw.CertificateObjectLocalRulestackClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCertificateObjectLocalRulestackServerTransport(srv *CertificateObjectLocalRulestackServer) *CertificateObjectLocalRulestackServerTransport {
	return &CertificateObjectLocalRulestackServerTransport{
		srv:                           srv,
		beginCreateOrUpdate:           newTracker[azfake.PollerResponder[armpanngfw.CertificateObjectLocalRulestackClientCreateOrUpdateResponse]](),
		beginDelete:                   newTracker[azfake.PollerResponder[armpanngfw.CertificateObjectLocalRulestackClientDeleteResponse]](),
		newListByLocalRulestacksPager: newTracker[azfake.PagerResponder[armpanngfw.CertificateObjectLocalRulestackClientListByLocalRulestacksResponse]](),
	}
}

// CertificateObjectLocalRulestackServerTransport connects instances of armpanngfw.CertificateObjectLocalRulestackClient to instances of CertificateObjectLocalRulestackServer.
// Don't use this type directly, use NewCertificateObjectLocalRulestackServerTransport instead.
type CertificateObjectLocalRulestackServerTransport struct {
	srv                           *CertificateObjectLocalRulestackServer
	beginCreateOrUpdate           *tracker[azfake.PollerResponder[armpanngfw.CertificateObjectLocalRulestackClientCreateOrUpdateResponse]]
	beginDelete                   *tracker[azfake.PollerResponder[armpanngfw.CertificateObjectLocalRulestackClientDeleteResponse]]
	newListByLocalRulestacksPager *tracker[azfake.PagerResponder[armpanngfw.CertificateObjectLocalRulestackClientListByLocalRulestacksResponse]]
}

// Do implements the policy.Transporter interface for CertificateObjectLocalRulestackServerTransport.
func (c *CertificateObjectLocalRulestackServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CertificateObjectLocalRulestackClient.BeginCreateOrUpdate":
		resp, err = c.dispatchBeginCreateOrUpdate(req)
	case "CertificateObjectLocalRulestackClient.BeginDelete":
		resp, err = c.dispatchBeginDelete(req)
	case "CertificateObjectLocalRulestackClient.Get":
		resp, err = c.dispatchGet(req)
	case "CertificateObjectLocalRulestackClient.NewListByLocalRulestacksPager":
		resp, err = c.dispatchNewListByLocalRulestacksPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CertificateObjectLocalRulestackServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := c.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks/(?P<localRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/certificates/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armpanngfw.CertificateObjectLocalRulestackResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		localRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("localRulestackName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, localRulestackNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		c.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		c.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		c.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (c *CertificateObjectLocalRulestackServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := c.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks/(?P<localRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/certificates/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		localRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("localRulestackName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDelete(req.Context(), resourceGroupNameParam, localRulestackNameParam, nameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		c.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		c.beginDelete.remove(req)
	}

	return resp, nil
}

func (c *CertificateObjectLocalRulestackServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks/(?P<localRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/certificates/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	localRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("localRulestackName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, localRulestackNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CertificateObjectLocalRulestackResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CertificateObjectLocalRulestackServerTransport) dispatchNewListByLocalRulestacksPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByLocalRulestacksPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByLocalRulestacksPager not implemented")}
	}
	newListByLocalRulestacksPager := c.newListByLocalRulestacksPager.get(req)
	if newListByLocalRulestacksPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks/(?P<localRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/certificates`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		localRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("localRulestackName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListByLocalRulestacksPager(resourceGroupNameParam, localRulestackNameParam, nil)
		newListByLocalRulestacksPager = &resp
		c.newListByLocalRulestacksPager.add(req, newListByLocalRulestacksPager)
		server.PagerResponderInjectNextLinks(newListByLocalRulestacksPager, req, func(page *armpanngfw.CertificateObjectLocalRulestackClientListByLocalRulestacksResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByLocalRulestacksPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByLocalRulestacksPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByLocalRulestacksPager) {
		c.newListByLocalRulestacksPager.remove(req)
	}
	return resp, nil
}
