//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/operationalinsights/armoperationalinsights"
	"net/http"
	"net/url"
	"regexp"
)

// WorkspacePurgeServer is a fake server for instances of the armoperationalinsights.WorkspacePurgeClient type.
type WorkspacePurgeServer struct {
	// GetPurgeStatus is the fake for method WorkspacePurgeClient.GetPurgeStatus
	// HTTP status codes to indicate success: http.StatusOK
	GetPurgeStatus func(ctx context.Context, resourceGroupName string, workspaceName string, purgeID string, options *armoperationalinsights.WorkspacePurgeClientGetPurgeStatusOptions) (resp azfake.Responder[armoperationalinsights.WorkspacePurgeClientGetPurgeStatusResponse], errResp azfake.ErrorResponder)

	// Purge is the fake for method WorkspacePurgeClient.Purge
	// HTTP status codes to indicate success: http.StatusAccepted
	Purge func(ctx context.Context, resourceGroupName string, workspaceName string, body armoperationalinsights.WorkspacePurgeBody, options *armoperationalinsights.WorkspacePurgeClientPurgeOptions) (resp azfake.Responder[armoperationalinsights.WorkspacePurgeClientPurgeResponse], errResp azfake.ErrorResponder)
}

// NewWorkspacePurgeServerTransport creates a new instance of WorkspacePurgeServerTransport with the provided implementation.
// The returned WorkspacePurgeServerTransport instance is connected to an instance of armoperationalinsights.WorkspacePurgeClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewWorkspacePurgeServerTransport(srv *WorkspacePurgeServer) *WorkspacePurgeServerTransport {
	return &WorkspacePurgeServerTransport{srv: srv}
}

// WorkspacePurgeServerTransport connects instances of armoperationalinsights.WorkspacePurgeClient to instances of WorkspacePurgeServer.
// Don't use this type directly, use NewWorkspacePurgeServerTransport instead.
type WorkspacePurgeServerTransport struct {
	srv *WorkspacePurgeServer
}

// Do implements the policy.Transporter interface for WorkspacePurgeServerTransport.
func (w *WorkspacePurgeServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "WorkspacePurgeClient.GetPurgeStatus":
		resp, err = w.dispatchGetPurgeStatus(req)
	case "WorkspacePurgeClient.Purge":
		resp, err = w.dispatchPurge(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (w *WorkspacePurgeServerTransport) dispatchGetPurgeStatus(req *http.Request) (*http.Response, error) {
	if w.srv.GetPurgeStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPurgeStatus not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OperationalInsights/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/operations/(?P<purgeId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	purgeIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("purgeId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetPurgeStatus(req.Context(), resourceGroupNameParam, workspaceNameParam, purgeIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkspacePurgeStatusResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkspacePurgeServerTransport) dispatchPurge(req *http.Request) (*http.Response, error) {
	if w.srv.Purge == nil {
		return nil, &nonRetriableError{errors.New("fake for method Purge not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OperationalInsights/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/purge`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armoperationalinsights.WorkspacePurgeBody](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Purge(req.Context(), resourceGroupNameParam, workspaceNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkspacePurgeResponse, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).XMSStatusLocation; val != nil {
		resp.Header.Set("x-ms-status-location", *val)
	}
	return resp, nil
}
