//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/newrelic/armnewrelicobservability"
	"net/http"
	"net/url"
	"regexp"
)

// PlansServer is a fake server for instances of the armnewrelicobservability.PlansClient type.
type PlansServer struct {
	// NewListPager is the fake for method PlansClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armnewrelicobservability.PlansClientListOptions) (resp azfake.PagerResponder[armnewrelicobservability.PlansClientListResponse])
}

// NewPlansServerTransport creates a new instance of PlansServerTransport with the provided implementation.
// The returned PlansServerTransport instance is connected to an instance of armnewrelicobservability.PlansClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPlansServerTransport(srv *PlansServer) *PlansServerTransport {
	return &PlansServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armnewrelicobservability.PlansClientListResponse]](),
	}
}

// PlansServerTransport connects instances of armnewrelicobservability.PlansClient to instances of PlansServer.
// Don't use this type directly, use NewPlansServerTransport instead.
type PlansServerTransport struct {
	srv          *PlansServer
	newListPager *tracker[azfake.PagerResponder[armnewrelicobservability.PlansClientListResponse]]
}

// Do implements the policy.Transporter interface for PlansServerTransport.
func (p *PlansServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PlansClient.NewListPager":
		resp, err = p.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PlansServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := p.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/NewRelic\.Observability/plans`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		accountIDUnescaped, err := url.QueryUnescape(qp.Get("accountId"))
		if err != nil {
			return nil, err
		}
		accountIDParam := getOptional(accountIDUnescaped)
		organizationIDUnescaped, err := url.QueryUnescape(qp.Get("organizationId"))
		if err != nil {
			return nil, err
		}
		organizationIDParam := getOptional(organizationIDUnescaped)
		var options *armnewrelicobservability.PlansClientListOptions
		if accountIDParam != nil || organizationIDParam != nil {
			options = &armnewrelicobservability.PlansClientListOptions{
				AccountID:      accountIDParam,
				OrganizationID: organizationIDParam,
			}
		}
		resp := p.srv.NewListPager(options)
		newListPager = &resp
		p.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armnewrelicobservability.PlansClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		p.newListPager.remove(req)
	}
	return resp, nil
}
