//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/newrelic/armnewrelicobservability"
	"net/http"
	"net/url"
	"regexp"
)

// OrganizationsServer is a fake server for instances of the armnewrelicobservability.OrganizationsClient type.
type OrganizationsServer struct {
	// NewListPager is the fake for method OrganizationsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(userEmail string, location string, options *armnewrelicobservability.OrganizationsClientListOptions) (resp azfake.PagerResponder[armnewrelicobservability.OrganizationsClientListResponse])
}

// NewOrganizationsServerTransport creates a new instance of OrganizationsServerTransport with the provided implementation.
// The returned OrganizationsServerTransport instance is connected to an instance of armnewrelicobservability.OrganizationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewOrganizationsServerTransport(srv *OrganizationsServer) *OrganizationsServerTransport {
	return &OrganizationsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armnewrelicobservability.OrganizationsClientListResponse]](),
	}
}

// OrganizationsServerTransport connects instances of armnewrelicobservability.OrganizationsClient to instances of OrganizationsServer.
// Don't use this type directly, use NewOrganizationsServerTransport instead.
type OrganizationsServerTransport struct {
	srv          *OrganizationsServer
	newListPager *tracker[azfake.PagerResponder[armnewrelicobservability.OrganizationsClientListResponse]]
}

// Do implements the policy.Transporter interface for OrganizationsServerTransport.
func (o *OrganizationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "OrganizationsClient.NewListPager":
		resp, err = o.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (o *OrganizationsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if o.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := o.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/NewRelic\.Observability/organizations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		userEmailParam, err := url.QueryUnescape(qp.Get("userEmail"))
		if err != nil {
			return nil, err
		}
		locationParam, err := url.QueryUnescape(qp.Get("location"))
		if err != nil {
			return nil, err
		}
		resp := o.srv.NewListPager(userEmailParam, locationParam, nil)
		newListPager = &resp
		o.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armnewrelicobservability.OrganizationsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		o.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		o.newListPager.remove(req)
	}
	return resp, nil
}
