//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/networkfunction/armnetworkfunction/v2"
	"net/http"
	"regexp"
)

// AzureTrafficCollectorsBySubscriptionServer is a fake server for instances of the armnetworkfunction.AzureTrafficCollectorsBySubscriptionClient type.
type AzureTrafficCollectorsBySubscriptionServer struct {
	// NewListPager is the fake for method AzureTrafficCollectorsBySubscriptionClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armnetworkfunction.AzureTrafficCollectorsBySubscriptionClientListOptions) (resp azfake.PagerResponder[armnetworkfunction.AzureTrafficCollectorsBySubscriptionClientListResponse])
}

// NewAzureTrafficCollectorsBySubscriptionServerTransport creates a new instance of AzureTrafficCollectorsBySubscriptionServerTransport with the provided implementation.
// The returned AzureTrafficCollectorsBySubscriptionServerTransport instance is connected to an instance of armnetworkfunction.AzureTrafficCollectorsBySubscriptionClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAzureTrafficCollectorsBySubscriptionServerTransport(srv *AzureTrafficCollectorsBySubscriptionServer) *AzureTrafficCollectorsBySubscriptionServerTransport {
	return &AzureTrafficCollectorsBySubscriptionServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armnetworkfunction.AzureTrafficCollectorsBySubscriptionClientListResponse]](),
	}
}

// AzureTrafficCollectorsBySubscriptionServerTransport connects instances of armnetworkfunction.AzureTrafficCollectorsBySubscriptionClient to instances of AzureTrafficCollectorsBySubscriptionServer.
// Don't use this type directly, use NewAzureTrafficCollectorsBySubscriptionServerTransport instead.
type AzureTrafficCollectorsBySubscriptionServerTransport struct {
	srv          *AzureTrafficCollectorsBySubscriptionServer
	newListPager *tracker[azfake.PagerResponder[armnetworkfunction.AzureTrafficCollectorsBySubscriptionClientListResponse]]
}

// Do implements the policy.Transporter interface for AzureTrafficCollectorsBySubscriptionServerTransport.
func (a *AzureTrafficCollectorsBySubscriptionServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AzureTrafficCollectorsBySubscriptionClient.NewListPager":
		resp, err = a.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AzureTrafficCollectorsBySubscriptionServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkFunction/azureTrafficCollectors`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := a.srv.NewListPager(nil)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armnetworkfunction.AzureTrafficCollectorsBySubscriptionClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}
