//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/networkcloud/armnetworkcloud"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// StorageAppliancesServer is a fake server for instances of the armnetworkcloud.StorageAppliancesClient type.
type StorageAppliancesServer struct {
	// BeginCreateOrUpdate is the fake for method StorageAppliancesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, storageApplianceName string, storageApplianceParameters armnetworkcloud.StorageAppliance, options *armnetworkcloud.StorageAppliancesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armnetworkcloud.StorageAppliancesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method StorageAppliancesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, storageApplianceName string, options *armnetworkcloud.StorageAppliancesClientBeginDeleteOptions) (resp azfake.PollerResponder[armnetworkcloud.StorageAppliancesClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDisableRemoteVendorManagement is the fake for method StorageAppliancesClient.BeginDisableRemoteVendorManagement
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDisableRemoteVendorManagement func(ctx context.Context, resourceGroupName string, storageApplianceName string, options *armnetworkcloud.StorageAppliancesClientBeginDisableRemoteVendorManagementOptions) (resp azfake.PollerResponder[armnetworkcloud.StorageAppliancesClientDisableRemoteVendorManagementResponse], errResp azfake.ErrorResponder)

	// BeginEnableRemoteVendorManagement is the fake for method StorageAppliancesClient.BeginEnableRemoteVendorManagement
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginEnableRemoteVendorManagement func(ctx context.Context, resourceGroupName string, storageApplianceName string, options *armnetworkcloud.StorageAppliancesClientBeginEnableRemoteVendorManagementOptions) (resp azfake.PollerResponder[armnetworkcloud.StorageAppliancesClientEnableRemoteVendorManagementResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method StorageAppliancesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, storageApplianceName string, options *armnetworkcloud.StorageAppliancesClientGetOptions) (resp azfake.Responder[armnetworkcloud.StorageAppliancesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method StorageAppliancesClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armnetworkcloud.StorageAppliancesClientListByResourceGroupOptions) (resp azfake.PagerResponder[armnetworkcloud.StorageAppliancesClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method StorageAppliancesClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armnetworkcloud.StorageAppliancesClientListBySubscriptionOptions) (resp azfake.PagerResponder[armnetworkcloud.StorageAppliancesClientListBySubscriptionResponse])

	// BeginUpdate is the fake for method StorageAppliancesClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, storageApplianceName string, storageApplianceUpdateParameters armnetworkcloud.StorageAppliancePatchParameters, options *armnetworkcloud.StorageAppliancesClientBeginUpdateOptions) (resp azfake.PollerResponder[armnetworkcloud.StorageAppliancesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewStorageAppliancesServerTransport creates a new instance of StorageAppliancesServerTransport with the provided implementation.
// The returned StorageAppliancesServerTransport instance is connected to an instance of armnetworkcloud.StorageAppliancesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewStorageAppliancesServerTransport(srv *StorageAppliancesServer) *StorageAppliancesServerTransport {
	return &StorageAppliancesServerTransport{
		srv:                                srv,
		beginCreateOrUpdate:                newTracker[azfake.PollerResponder[armnetworkcloud.StorageAppliancesClientCreateOrUpdateResponse]](),
		beginDelete:                        newTracker[azfake.PollerResponder[armnetworkcloud.StorageAppliancesClientDeleteResponse]](),
		beginDisableRemoteVendorManagement: newTracker[azfake.PollerResponder[armnetworkcloud.StorageAppliancesClientDisableRemoteVendorManagementResponse]](),
		beginEnableRemoteVendorManagement:  newTracker[azfake.PollerResponder[armnetworkcloud.StorageAppliancesClientEnableRemoteVendorManagementResponse]](),
		newListByResourceGroupPager:        newTracker[azfake.PagerResponder[armnetworkcloud.StorageAppliancesClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:         newTracker[azfake.PagerResponder[armnetworkcloud.StorageAppliancesClientListBySubscriptionResponse]](),
		beginUpdate:                        newTracker[azfake.PollerResponder[armnetworkcloud.StorageAppliancesClientUpdateResponse]](),
	}
}

// StorageAppliancesServerTransport connects instances of armnetworkcloud.StorageAppliancesClient to instances of StorageAppliancesServer.
// Don't use this type directly, use NewStorageAppliancesServerTransport instead.
type StorageAppliancesServerTransport struct {
	srv                                *StorageAppliancesServer
	beginCreateOrUpdate                *tracker[azfake.PollerResponder[armnetworkcloud.StorageAppliancesClientCreateOrUpdateResponse]]
	beginDelete                        *tracker[azfake.PollerResponder[armnetworkcloud.StorageAppliancesClientDeleteResponse]]
	beginDisableRemoteVendorManagement *tracker[azfake.PollerResponder[armnetworkcloud.StorageAppliancesClientDisableRemoteVendorManagementResponse]]
	beginEnableRemoteVendorManagement  *tracker[azfake.PollerResponder[armnetworkcloud.StorageAppliancesClientEnableRemoteVendorManagementResponse]]
	newListByResourceGroupPager        *tracker[azfake.PagerResponder[armnetworkcloud.StorageAppliancesClientListByResourceGroupResponse]]
	newListBySubscriptionPager         *tracker[azfake.PagerResponder[armnetworkcloud.StorageAppliancesClientListBySubscriptionResponse]]
	beginUpdate                        *tracker[azfake.PollerResponder[armnetworkcloud.StorageAppliancesClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for StorageAppliancesServerTransport.
func (s *StorageAppliancesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "StorageAppliancesClient.BeginCreateOrUpdate":
		resp, err = s.dispatchBeginCreateOrUpdate(req)
	case "StorageAppliancesClient.BeginDelete":
		resp, err = s.dispatchBeginDelete(req)
	case "StorageAppliancesClient.BeginDisableRemoteVendorManagement":
		resp, err = s.dispatchBeginDisableRemoteVendorManagement(req)
	case "StorageAppliancesClient.BeginEnableRemoteVendorManagement":
		resp, err = s.dispatchBeginEnableRemoteVendorManagement(req)
	case "StorageAppliancesClient.Get":
		resp, err = s.dispatchGet(req)
	case "StorageAppliancesClient.NewListByResourceGroupPager":
		resp, err = s.dispatchNewListByResourceGroupPager(req)
	case "StorageAppliancesClient.NewListBySubscriptionPager":
		resp, err = s.dispatchNewListBySubscriptionPager(req)
	case "StorageAppliancesClient.BeginUpdate":
		resp, err = s.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *StorageAppliancesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := s.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/storageAppliances/(?P<storageApplianceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetworkcloud.StorageAppliance](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		storageApplianceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageApplianceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, storageApplianceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		s.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		s.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		s.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (s *StorageAppliancesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := s.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/storageAppliances/(?P<storageApplianceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		storageApplianceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageApplianceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDelete(req.Context(), resourceGroupNameParam, storageApplianceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		s.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		s.beginDelete.remove(req)
	}

	return resp, nil
}

func (s *StorageAppliancesServerTransport) dispatchBeginDisableRemoteVendorManagement(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDisableRemoteVendorManagement == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDisableRemoteVendorManagement not implemented")}
	}
	beginDisableRemoteVendorManagement := s.beginDisableRemoteVendorManagement.get(req)
	if beginDisableRemoteVendorManagement == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/storageAppliances/(?P<storageApplianceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/disableRemoteVendorManagement`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		storageApplianceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageApplianceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDisableRemoteVendorManagement(req.Context(), resourceGroupNameParam, storageApplianceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDisableRemoteVendorManagement = &respr
		s.beginDisableRemoteVendorManagement.add(req, beginDisableRemoteVendorManagement)
	}

	resp, err := server.PollerResponderNext(beginDisableRemoteVendorManagement, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDisableRemoteVendorManagement.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDisableRemoteVendorManagement) {
		s.beginDisableRemoteVendorManagement.remove(req)
	}

	return resp, nil
}

func (s *StorageAppliancesServerTransport) dispatchBeginEnableRemoteVendorManagement(req *http.Request) (*http.Response, error) {
	if s.srv.BeginEnableRemoteVendorManagement == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginEnableRemoteVendorManagement not implemented")}
	}
	beginEnableRemoteVendorManagement := s.beginEnableRemoteVendorManagement.get(req)
	if beginEnableRemoteVendorManagement == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/storageAppliances/(?P<storageApplianceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/enableRemoteVendorManagement`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetworkcloud.StorageApplianceEnableRemoteVendorManagementParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		storageApplianceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageApplianceName")])
		if err != nil {
			return nil, err
		}
		var options *armnetworkcloud.StorageAppliancesClientBeginEnableRemoteVendorManagementOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armnetworkcloud.StorageAppliancesClientBeginEnableRemoteVendorManagementOptions{
				StorageApplianceEnableRemoteVendorManagementParameters: &body,
			}
		}
		respr, errRespr := s.srv.BeginEnableRemoteVendorManagement(req.Context(), resourceGroupNameParam, storageApplianceNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginEnableRemoteVendorManagement = &respr
		s.beginEnableRemoteVendorManagement.add(req, beginEnableRemoteVendorManagement)
	}

	resp, err := server.PollerResponderNext(beginEnableRemoteVendorManagement, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginEnableRemoteVendorManagement.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginEnableRemoteVendorManagement) {
		s.beginEnableRemoteVendorManagement.remove(req)
	}

	return resp, nil
}

func (s *StorageAppliancesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/storageAppliances/(?P<storageApplianceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	storageApplianceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageApplianceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, storageApplianceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StorageAppliance, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StorageAppliancesServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := s.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/storageAppliances`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		s.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armnetworkcloud.StorageAppliancesClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		s.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (s *StorageAppliancesServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := s.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/storageAppliances`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := s.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		s.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armnetworkcloud.StorageAppliancesClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		s.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (s *StorageAppliancesServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := s.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/storageAppliances/(?P<storageApplianceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetworkcloud.StorageAppliancePatchParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		storageApplianceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageApplianceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginUpdate(req.Context(), resourceGroupNameParam, storageApplianceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		s.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		s.beginUpdate.remove(req)
	}

	return resp, nil
}
