//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armnetworkcloud

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/networkcloud/armnetworkcloud"
	moduleVersion = "v1.1.0"
)

// ActionType - Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
type ActionType string

const (
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeInternal,
	}
}

// AdvertiseToFabric - The indicator of if this advertisement is also made to the network fabric associated with the Network
// Cloud Cluster. This field is ignored if fabricPeeringEnabled is set to False.
type AdvertiseToFabric string

const (
	AdvertiseToFabricFalse AdvertiseToFabric = "False"
	AdvertiseToFabricTrue  AdvertiseToFabric = "True"
)

// PossibleAdvertiseToFabricValues returns the possible values for the AdvertiseToFabric const type.
func PossibleAdvertiseToFabricValues() []AdvertiseToFabric {
	return []AdvertiseToFabric{
		AdvertiseToFabricFalse,
		AdvertiseToFabricTrue,
	}
}

// AgentPoolDetailedStatus - The current status of the agent pool.
type AgentPoolDetailedStatus string

const (
	AgentPoolDetailedStatusAvailable    AgentPoolDetailedStatus = "Available"
	AgentPoolDetailedStatusError        AgentPoolDetailedStatus = "Error"
	AgentPoolDetailedStatusProvisioning AgentPoolDetailedStatus = "Provisioning"
)

// PossibleAgentPoolDetailedStatusValues returns the possible values for the AgentPoolDetailedStatus const type.
func PossibleAgentPoolDetailedStatusValues() []AgentPoolDetailedStatus {
	return []AgentPoolDetailedStatus{
		AgentPoolDetailedStatusAvailable,
		AgentPoolDetailedStatusError,
		AgentPoolDetailedStatusProvisioning,
	}
}

// AgentPoolMode - The selection of how this agent pool is utilized, either as a system pool or a user pool. System pools
// run the features and critical services for the Kubernetes Cluster, while user pools are dedicated
// to user workloads. Every Kubernetes cluster must contain at least one system node pool with at least one node.
type AgentPoolMode string

const (
	AgentPoolModeNotApplicable AgentPoolMode = "NotApplicable"
	AgentPoolModeSystem        AgentPoolMode = "System"
	AgentPoolModeUser          AgentPoolMode = "User"
)

// PossibleAgentPoolModeValues returns the possible values for the AgentPoolMode const type.
func PossibleAgentPoolModeValues() []AgentPoolMode {
	return []AgentPoolMode{
		AgentPoolModeNotApplicable,
		AgentPoolModeSystem,
		AgentPoolModeUser,
	}
}

// AgentPoolProvisioningState - The provisioning state of the agent pool.
type AgentPoolProvisioningState string

const (
	AgentPoolProvisioningStateAccepted   AgentPoolProvisioningState = "Accepted"
	AgentPoolProvisioningStateCanceled   AgentPoolProvisioningState = "Canceled"
	AgentPoolProvisioningStateDeleting   AgentPoolProvisioningState = "Deleting"
	AgentPoolProvisioningStateFailed     AgentPoolProvisioningState = "Failed"
	AgentPoolProvisioningStateInProgress AgentPoolProvisioningState = "InProgress"
	AgentPoolProvisioningStateSucceeded  AgentPoolProvisioningState = "Succeeded"
	AgentPoolProvisioningStateUpdating   AgentPoolProvisioningState = "Updating"
)

// PossibleAgentPoolProvisioningStateValues returns the possible values for the AgentPoolProvisioningState const type.
func PossibleAgentPoolProvisioningStateValues() []AgentPoolProvisioningState {
	return []AgentPoolProvisioningState{
		AgentPoolProvisioningStateAccepted,
		AgentPoolProvisioningStateCanceled,
		AgentPoolProvisioningStateDeleting,
		AgentPoolProvisioningStateFailed,
		AgentPoolProvisioningStateInProgress,
		AgentPoolProvisioningStateSucceeded,
		AgentPoolProvisioningStateUpdating,
	}
}

// AvailabilityLifecycle - The version lifecycle indicator.
type AvailabilityLifecycle string

const (
	AvailabilityLifecycleGenerallyAvailable AvailabilityLifecycle = "GenerallyAvailable"
	AvailabilityLifecyclePreview            AvailabilityLifecycle = "Preview"
)

// PossibleAvailabilityLifecycleValues returns the possible values for the AvailabilityLifecycle const type.
func PossibleAvailabilityLifecycleValues() []AvailabilityLifecycle {
	return []AvailabilityLifecycle{
		AvailabilityLifecycleGenerallyAvailable,
		AvailabilityLifecyclePreview,
	}
}

// BareMetalMachineCordonStatus - The cordon status of the bare metal machine.
type BareMetalMachineCordonStatus string

const (
	BareMetalMachineCordonStatusCordoned   BareMetalMachineCordonStatus = "Cordoned"
	BareMetalMachineCordonStatusUncordoned BareMetalMachineCordonStatus = "Uncordoned"
)

// PossibleBareMetalMachineCordonStatusValues returns the possible values for the BareMetalMachineCordonStatus const type.
func PossibleBareMetalMachineCordonStatusValues() []BareMetalMachineCordonStatus {
	return []BareMetalMachineCordonStatus{
		BareMetalMachineCordonStatusCordoned,
		BareMetalMachineCordonStatusUncordoned,
	}
}

// BareMetalMachineDetailedStatus - The more detailed status of the bare metal machine.
type BareMetalMachineDetailedStatus string

const (
	BareMetalMachineDetailedStatusAvailable      BareMetalMachineDetailedStatus = "Available"
	BareMetalMachineDetailedStatusDeprovisioning BareMetalMachineDetailedStatus = "Deprovisioning"
	BareMetalMachineDetailedStatusError          BareMetalMachineDetailedStatus = "Error"
	BareMetalMachineDetailedStatusPreparing      BareMetalMachineDetailedStatus = "Preparing"
	BareMetalMachineDetailedStatusProvisioned    BareMetalMachineDetailedStatus = "Provisioned"
	BareMetalMachineDetailedStatusProvisioning   BareMetalMachineDetailedStatus = "Provisioning"
)

// PossibleBareMetalMachineDetailedStatusValues returns the possible values for the BareMetalMachineDetailedStatus const type.
func PossibleBareMetalMachineDetailedStatusValues() []BareMetalMachineDetailedStatus {
	return []BareMetalMachineDetailedStatus{
		BareMetalMachineDetailedStatusAvailable,
		BareMetalMachineDetailedStatusDeprovisioning,
		BareMetalMachineDetailedStatusError,
		BareMetalMachineDetailedStatusPreparing,
		BareMetalMachineDetailedStatusProvisioned,
		BareMetalMachineDetailedStatusProvisioning,
	}
}

// BareMetalMachineEvacuate - The indicator of whether to evacuate the node workload when the bare metal machine is cordoned.
type BareMetalMachineEvacuate string

const (
	BareMetalMachineEvacuateFalse BareMetalMachineEvacuate = "False"
	BareMetalMachineEvacuateTrue  BareMetalMachineEvacuate = "True"
)

// PossibleBareMetalMachineEvacuateValues returns the possible values for the BareMetalMachineEvacuate const type.
func PossibleBareMetalMachineEvacuateValues() []BareMetalMachineEvacuate {
	return []BareMetalMachineEvacuate{
		BareMetalMachineEvacuateFalse,
		BareMetalMachineEvacuateTrue,
	}
}

// BareMetalMachineHardwareValidationResult - The outcome of the hardware validation.
type BareMetalMachineHardwareValidationResult string

const (
	BareMetalMachineHardwareValidationResultFail BareMetalMachineHardwareValidationResult = "Fail"
	BareMetalMachineHardwareValidationResultPass BareMetalMachineHardwareValidationResult = "Pass"
)

// PossibleBareMetalMachineHardwareValidationResultValues returns the possible values for the BareMetalMachineHardwareValidationResult const type.
func PossibleBareMetalMachineHardwareValidationResultValues() []BareMetalMachineHardwareValidationResult {
	return []BareMetalMachineHardwareValidationResult{
		BareMetalMachineHardwareValidationResultFail,
		BareMetalMachineHardwareValidationResultPass,
	}
}

// BareMetalMachineKeySetDetailedStatus - The more detailed status of the key set.
type BareMetalMachineKeySetDetailedStatus string

const (
	BareMetalMachineKeySetDetailedStatusAllActive   BareMetalMachineKeySetDetailedStatus = "AllActive"
	BareMetalMachineKeySetDetailedStatusAllInvalid  BareMetalMachineKeySetDetailedStatus = "AllInvalid"
	BareMetalMachineKeySetDetailedStatusSomeInvalid BareMetalMachineKeySetDetailedStatus = "SomeInvalid"
	BareMetalMachineKeySetDetailedStatusValidating  BareMetalMachineKeySetDetailedStatus = "Validating"
)

// PossibleBareMetalMachineKeySetDetailedStatusValues returns the possible values for the BareMetalMachineKeySetDetailedStatus const type.
func PossibleBareMetalMachineKeySetDetailedStatusValues() []BareMetalMachineKeySetDetailedStatus {
	return []BareMetalMachineKeySetDetailedStatus{
		BareMetalMachineKeySetDetailedStatusAllActive,
		BareMetalMachineKeySetDetailedStatusAllInvalid,
		BareMetalMachineKeySetDetailedStatusSomeInvalid,
		BareMetalMachineKeySetDetailedStatusValidating,
	}
}

// BareMetalMachineKeySetPrivilegeLevel - The access level allowed for the users in this key set.
type BareMetalMachineKeySetPrivilegeLevel string

const (
	BareMetalMachineKeySetPrivilegeLevelStandard  BareMetalMachineKeySetPrivilegeLevel = "Standard"
	BareMetalMachineKeySetPrivilegeLevelSuperuser BareMetalMachineKeySetPrivilegeLevel = "Superuser"
)

// PossibleBareMetalMachineKeySetPrivilegeLevelValues returns the possible values for the BareMetalMachineKeySetPrivilegeLevel const type.
func PossibleBareMetalMachineKeySetPrivilegeLevelValues() []BareMetalMachineKeySetPrivilegeLevel {
	return []BareMetalMachineKeySetPrivilegeLevel{
		BareMetalMachineKeySetPrivilegeLevelStandard,
		BareMetalMachineKeySetPrivilegeLevelSuperuser,
	}
}

// BareMetalMachineKeySetProvisioningState - The provisioning state of the bare metal machine key set.
type BareMetalMachineKeySetProvisioningState string

const (
	BareMetalMachineKeySetProvisioningStateAccepted     BareMetalMachineKeySetProvisioningState = "Accepted"
	BareMetalMachineKeySetProvisioningStateCanceled     BareMetalMachineKeySetProvisioningState = "Canceled"
	BareMetalMachineKeySetProvisioningStateFailed       BareMetalMachineKeySetProvisioningState = "Failed"
	BareMetalMachineKeySetProvisioningStateProvisioning BareMetalMachineKeySetProvisioningState = "Provisioning"
	BareMetalMachineKeySetProvisioningStateSucceeded    BareMetalMachineKeySetProvisioningState = "Succeeded"
)

// PossibleBareMetalMachineKeySetProvisioningStateValues returns the possible values for the BareMetalMachineKeySetProvisioningState const type.
func PossibleBareMetalMachineKeySetProvisioningStateValues() []BareMetalMachineKeySetProvisioningState {
	return []BareMetalMachineKeySetProvisioningState{
		BareMetalMachineKeySetProvisioningStateAccepted,
		BareMetalMachineKeySetProvisioningStateCanceled,
		BareMetalMachineKeySetProvisioningStateFailed,
		BareMetalMachineKeySetProvisioningStateProvisioning,
		BareMetalMachineKeySetProvisioningStateSucceeded,
	}
}

// BareMetalMachineKeySetUserSetupStatus - The indicator of whether the user is currently deployed for access.
type BareMetalMachineKeySetUserSetupStatus string

const (
	BareMetalMachineKeySetUserSetupStatusActive  BareMetalMachineKeySetUserSetupStatus = "Active"
	BareMetalMachineKeySetUserSetupStatusInvalid BareMetalMachineKeySetUserSetupStatus = "Invalid"
)

// PossibleBareMetalMachineKeySetUserSetupStatusValues returns the possible values for the BareMetalMachineKeySetUserSetupStatus const type.
func PossibleBareMetalMachineKeySetUserSetupStatusValues() []BareMetalMachineKeySetUserSetupStatus {
	return []BareMetalMachineKeySetUserSetupStatus{
		BareMetalMachineKeySetUserSetupStatusActive,
		BareMetalMachineKeySetUserSetupStatusInvalid,
	}
}

// BareMetalMachinePowerState - The power state derived from the baseboard management controller.
type BareMetalMachinePowerState string

const (
	BareMetalMachinePowerStateOff BareMetalMachinePowerState = "Off"
	BareMetalMachinePowerStateOn  BareMetalMachinePowerState = "On"
)

// PossibleBareMetalMachinePowerStateValues returns the possible values for the BareMetalMachinePowerState const type.
func PossibleBareMetalMachinePowerStateValues() []BareMetalMachinePowerState {
	return []BareMetalMachinePowerState{
		BareMetalMachinePowerStateOff,
		BareMetalMachinePowerStateOn,
	}
}

// BareMetalMachineProvisioningState - The provisioning state of the bare metal machine.
type BareMetalMachineProvisioningState string

const (
	BareMetalMachineProvisioningStateAccepted     BareMetalMachineProvisioningState = "Accepted"
	BareMetalMachineProvisioningStateCanceled     BareMetalMachineProvisioningState = "Canceled"
	BareMetalMachineProvisioningStateFailed       BareMetalMachineProvisioningState = "Failed"
	BareMetalMachineProvisioningStateProvisioning BareMetalMachineProvisioningState = "Provisioning"
	BareMetalMachineProvisioningStateSucceeded    BareMetalMachineProvisioningState = "Succeeded"
)

// PossibleBareMetalMachineProvisioningStateValues returns the possible values for the BareMetalMachineProvisioningState const type.
func PossibleBareMetalMachineProvisioningStateValues() []BareMetalMachineProvisioningState {
	return []BareMetalMachineProvisioningState{
		BareMetalMachineProvisioningStateAccepted,
		BareMetalMachineProvisioningStateCanceled,
		BareMetalMachineProvisioningStateFailed,
		BareMetalMachineProvisioningStateProvisioning,
		BareMetalMachineProvisioningStateSucceeded,
	}
}

// BareMetalMachineReadyState - The indicator of whether the bare metal machine is ready to receive workloads.
type BareMetalMachineReadyState string

const (
	BareMetalMachineReadyStateFalse BareMetalMachineReadyState = "False"
	BareMetalMachineReadyStateTrue  BareMetalMachineReadyState = "True"
)

// PossibleBareMetalMachineReadyStateValues returns the possible values for the BareMetalMachineReadyState const type.
func PossibleBareMetalMachineReadyStateValues() []BareMetalMachineReadyState {
	return []BareMetalMachineReadyState{
		BareMetalMachineReadyStateFalse,
		BareMetalMachineReadyStateTrue,
	}
}

// BareMetalMachineSkipShutdown - The indicator of whether to skip the graceful OS shutdown and power off the bare metal machine
// immediately.
type BareMetalMachineSkipShutdown string

const (
	BareMetalMachineSkipShutdownFalse BareMetalMachineSkipShutdown = "False"
	BareMetalMachineSkipShutdownTrue  BareMetalMachineSkipShutdown = "True"
)

// PossibleBareMetalMachineSkipShutdownValues returns the possible values for the BareMetalMachineSkipShutdown const type.
func PossibleBareMetalMachineSkipShutdownValues() []BareMetalMachineSkipShutdown {
	return []BareMetalMachineSkipShutdown{
		BareMetalMachineSkipShutdownFalse,
		BareMetalMachineSkipShutdownTrue,
	}
}

// BfdEnabled - The indicator to determine if automatic allocation from the pool should occur.
type BfdEnabled string

const (
	BfdEnabledFalse BfdEnabled = "False"
	BfdEnabledTrue  BfdEnabled = "True"
)

// PossibleBfdEnabledValues returns the possible values for the BfdEnabled const type.
func PossibleBfdEnabledValues() []BfdEnabled {
	return []BfdEnabled{
		BfdEnabledFalse,
		BfdEnabledTrue,
	}
}

// BgpMultiHop - The indicator to enable multi-hop peering support.
type BgpMultiHop string

const (
	BgpMultiHopFalse BgpMultiHop = "False"
	BgpMultiHopTrue  BgpMultiHop = "True"
)

// PossibleBgpMultiHopValues returns the possible values for the BgpMultiHop const type.
func PossibleBgpMultiHopValues() []BgpMultiHop {
	return []BgpMultiHop{
		BgpMultiHopFalse,
		BgpMultiHopTrue,
	}
}

// BmcKeySetDetailedStatus - The more detailed status of the key set.
type BmcKeySetDetailedStatus string

const (
	BmcKeySetDetailedStatusAllActive   BmcKeySetDetailedStatus = "AllActive"
	BmcKeySetDetailedStatusAllInvalid  BmcKeySetDetailedStatus = "AllInvalid"
	BmcKeySetDetailedStatusSomeInvalid BmcKeySetDetailedStatus = "SomeInvalid"
	BmcKeySetDetailedStatusValidating  BmcKeySetDetailedStatus = "Validating"
)

// PossibleBmcKeySetDetailedStatusValues returns the possible values for the BmcKeySetDetailedStatus const type.
func PossibleBmcKeySetDetailedStatusValues() []BmcKeySetDetailedStatus {
	return []BmcKeySetDetailedStatus{
		BmcKeySetDetailedStatusAllActive,
		BmcKeySetDetailedStatusAllInvalid,
		BmcKeySetDetailedStatusSomeInvalid,
		BmcKeySetDetailedStatusValidating,
	}
}

// BmcKeySetPrivilegeLevel - The access level allowed for the users in this key set.
type BmcKeySetPrivilegeLevel string

const (
	BmcKeySetPrivilegeLevelAdministrator BmcKeySetPrivilegeLevel = "Administrator"
	BmcKeySetPrivilegeLevelReadOnly      BmcKeySetPrivilegeLevel = "ReadOnly"
)

// PossibleBmcKeySetPrivilegeLevelValues returns the possible values for the BmcKeySetPrivilegeLevel const type.
func PossibleBmcKeySetPrivilegeLevelValues() []BmcKeySetPrivilegeLevel {
	return []BmcKeySetPrivilegeLevel{
		BmcKeySetPrivilegeLevelAdministrator,
		BmcKeySetPrivilegeLevelReadOnly,
	}
}

// BmcKeySetProvisioningState - The provisioning state of the baseboard management controller key set.
type BmcKeySetProvisioningState string

const (
	BmcKeySetProvisioningStateAccepted     BmcKeySetProvisioningState = "Accepted"
	BmcKeySetProvisioningStateCanceled     BmcKeySetProvisioningState = "Canceled"
	BmcKeySetProvisioningStateFailed       BmcKeySetProvisioningState = "Failed"
	BmcKeySetProvisioningStateProvisioning BmcKeySetProvisioningState = "Provisioning"
	BmcKeySetProvisioningStateSucceeded    BmcKeySetProvisioningState = "Succeeded"
)

// PossibleBmcKeySetProvisioningStateValues returns the possible values for the BmcKeySetProvisioningState const type.
func PossibleBmcKeySetProvisioningStateValues() []BmcKeySetProvisioningState {
	return []BmcKeySetProvisioningState{
		BmcKeySetProvisioningStateAccepted,
		BmcKeySetProvisioningStateCanceled,
		BmcKeySetProvisioningStateFailed,
		BmcKeySetProvisioningStateProvisioning,
		BmcKeySetProvisioningStateSucceeded,
	}
}

// BootstrapProtocol - The type of bootstrap protocol used.
type BootstrapProtocol string

const (
	BootstrapProtocolPXE BootstrapProtocol = "PXE"
)

// PossibleBootstrapProtocolValues returns the possible values for the BootstrapProtocol const type.
func PossibleBootstrapProtocolValues() []BootstrapProtocol {
	return []BootstrapProtocol{
		BootstrapProtocolPXE,
	}
}

// CloudServicesNetworkDetailedStatus - The more detailed status of the cloud services network.
type CloudServicesNetworkDetailedStatus string

const (
	CloudServicesNetworkDetailedStatusAvailable    CloudServicesNetworkDetailedStatus = "Available"
	CloudServicesNetworkDetailedStatusError        CloudServicesNetworkDetailedStatus = "Error"
	CloudServicesNetworkDetailedStatusProvisioning CloudServicesNetworkDetailedStatus = "Provisioning"
)

// PossibleCloudServicesNetworkDetailedStatusValues returns the possible values for the CloudServicesNetworkDetailedStatus const type.
func PossibleCloudServicesNetworkDetailedStatusValues() []CloudServicesNetworkDetailedStatus {
	return []CloudServicesNetworkDetailedStatus{
		CloudServicesNetworkDetailedStatusAvailable,
		CloudServicesNetworkDetailedStatusError,
		CloudServicesNetworkDetailedStatusProvisioning,
	}
}

// CloudServicesNetworkEnableDefaultEgressEndpoints - The indicator of whether the platform default endpoints are allowed
// for the egress traffic.
type CloudServicesNetworkEnableDefaultEgressEndpoints string

const (
	CloudServicesNetworkEnableDefaultEgressEndpointsFalse CloudServicesNetworkEnableDefaultEgressEndpoints = "False"
	CloudServicesNetworkEnableDefaultEgressEndpointsTrue  CloudServicesNetworkEnableDefaultEgressEndpoints = "True"
)

// PossibleCloudServicesNetworkEnableDefaultEgressEndpointsValues returns the possible values for the CloudServicesNetworkEnableDefaultEgressEndpoints const type.
func PossibleCloudServicesNetworkEnableDefaultEgressEndpointsValues() []CloudServicesNetworkEnableDefaultEgressEndpoints {
	return []CloudServicesNetworkEnableDefaultEgressEndpoints{
		CloudServicesNetworkEnableDefaultEgressEndpointsFalse,
		CloudServicesNetworkEnableDefaultEgressEndpointsTrue,
	}
}

// CloudServicesNetworkProvisioningState - The provisioning state of the cloud services network.
type CloudServicesNetworkProvisioningState string

const (
	CloudServicesNetworkProvisioningStateAccepted     CloudServicesNetworkProvisioningState = "Accepted"
	CloudServicesNetworkProvisioningStateCanceled     CloudServicesNetworkProvisioningState = "Canceled"
	CloudServicesNetworkProvisioningStateFailed       CloudServicesNetworkProvisioningState = "Failed"
	CloudServicesNetworkProvisioningStateProvisioning CloudServicesNetworkProvisioningState = "Provisioning"
	CloudServicesNetworkProvisioningStateSucceeded    CloudServicesNetworkProvisioningState = "Succeeded"
)

// PossibleCloudServicesNetworkProvisioningStateValues returns the possible values for the CloudServicesNetworkProvisioningState const type.
func PossibleCloudServicesNetworkProvisioningStateValues() []CloudServicesNetworkProvisioningState {
	return []CloudServicesNetworkProvisioningState{
		CloudServicesNetworkProvisioningStateAccepted,
		CloudServicesNetworkProvisioningStateCanceled,
		CloudServicesNetworkProvisioningStateFailed,
		CloudServicesNetworkProvisioningStateProvisioning,
		CloudServicesNetworkProvisioningStateSucceeded,
	}
}

// ClusterConnectionStatus - The latest heartbeat status between the cluster manager and the cluster.
type ClusterConnectionStatus string

const (
	ClusterConnectionStatusConnected ClusterConnectionStatus = "Connected"
	ClusterConnectionStatusTimeout   ClusterConnectionStatus = "Timeout"
	ClusterConnectionStatusUndefined ClusterConnectionStatus = "Undefined"
)

// PossibleClusterConnectionStatusValues returns the possible values for the ClusterConnectionStatus const type.
func PossibleClusterConnectionStatusValues() []ClusterConnectionStatus {
	return []ClusterConnectionStatus{
		ClusterConnectionStatusConnected,
		ClusterConnectionStatusTimeout,
		ClusterConnectionStatusUndefined,
	}
}

// ClusterDetailedStatus - The current detailed status of the cluster.
type ClusterDetailedStatus string

const (
	ClusterDetailedStatusDegraded          ClusterDetailedStatus = "Degraded"
	ClusterDetailedStatusDeleting          ClusterDetailedStatus = "Deleting"
	ClusterDetailedStatusDeploying         ClusterDetailedStatus = "Deploying"
	ClusterDetailedStatusDisconnected      ClusterDetailedStatus = "Disconnected"
	ClusterDetailedStatusFailed            ClusterDetailedStatus = "Failed"
	ClusterDetailedStatusPendingDeployment ClusterDetailedStatus = "PendingDeployment"
	ClusterDetailedStatusRunning           ClusterDetailedStatus = "Running"
	ClusterDetailedStatusUpdating          ClusterDetailedStatus = "Updating"
)

// PossibleClusterDetailedStatusValues returns the possible values for the ClusterDetailedStatus const type.
func PossibleClusterDetailedStatusValues() []ClusterDetailedStatus {
	return []ClusterDetailedStatus{
		ClusterDetailedStatusDegraded,
		ClusterDetailedStatusDeleting,
		ClusterDetailedStatusDeploying,
		ClusterDetailedStatusDisconnected,
		ClusterDetailedStatusFailed,
		ClusterDetailedStatusPendingDeployment,
		ClusterDetailedStatusRunning,
		ClusterDetailedStatusUpdating,
	}
}

// ClusterManagerConnectionStatus - The latest connectivity status between cluster manager and the cluster.
type ClusterManagerConnectionStatus string

const (
	ClusterManagerConnectionStatusConnected   ClusterManagerConnectionStatus = "Connected"
	ClusterManagerConnectionStatusUnreachable ClusterManagerConnectionStatus = "Unreachable"
)

// PossibleClusterManagerConnectionStatusValues returns the possible values for the ClusterManagerConnectionStatus const type.
func PossibleClusterManagerConnectionStatusValues() []ClusterManagerConnectionStatus {
	return []ClusterManagerConnectionStatus{
		ClusterManagerConnectionStatusConnected,
		ClusterManagerConnectionStatusUnreachable,
	}
}

// ClusterManagerDetailedStatus - The detailed status that provides additional information about the cluster manager.
type ClusterManagerDetailedStatus string

const (
	ClusterManagerDetailedStatusAvailable          ClusterManagerDetailedStatus = "Available"
	ClusterManagerDetailedStatusError              ClusterManagerDetailedStatus = "Error"
	ClusterManagerDetailedStatusProvisioning       ClusterManagerDetailedStatus = "Provisioning"
	ClusterManagerDetailedStatusProvisioningFailed ClusterManagerDetailedStatus = "ProvisioningFailed"
	ClusterManagerDetailedStatusUpdateFailed       ClusterManagerDetailedStatus = "UpdateFailed"
	ClusterManagerDetailedStatusUpdating           ClusterManagerDetailedStatus = "Updating"
)

// PossibleClusterManagerDetailedStatusValues returns the possible values for the ClusterManagerDetailedStatus const type.
func PossibleClusterManagerDetailedStatusValues() []ClusterManagerDetailedStatus {
	return []ClusterManagerDetailedStatus{
		ClusterManagerDetailedStatusAvailable,
		ClusterManagerDetailedStatusError,
		ClusterManagerDetailedStatusProvisioning,
		ClusterManagerDetailedStatusProvisioningFailed,
		ClusterManagerDetailedStatusUpdateFailed,
		ClusterManagerDetailedStatusUpdating,
	}
}

// ClusterManagerProvisioningState - The provisioning state of the cluster manager.
type ClusterManagerProvisioningState string

const (
	ClusterManagerProvisioningStateAccepted     ClusterManagerProvisioningState = "Accepted"
	ClusterManagerProvisioningStateCanceled     ClusterManagerProvisioningState = "Canceled"
	ClusterManagerProvisioningStateFailed       ClusterManagerProvisioningState = "Failed"
	ClusterManagerProvisioningStateProvisioning ClusterManagerProvisioningState = "Provisioning"
	ClusterManagerProvisioningStateSucceeded    ClusterManagerProvisioningState = "Succeeded"
	ClusterManagerProvisioningStateUpdating     ClusterManagerProvisioningState = "Updating"
)

// PossibleClusterManagerProvisioningStateValues returns the possible values for the ClusterManagerProvisioningState const type.
func PossibleClusterManagerProvisioningStateValues() []ClusterManagerProvisioningState {
	return []ClusterManagerProvisioningState{
		ClusterManagerProvisioningStateAccepted,
		ClusterManagerProvisioningStateCanceled,
		ClusterManagerProvisioningStateFailed,
		ClusterManagerProvisioningStateProvisioning,
		ClusterManagerProvisioningStateSucceeded,
		ClusterManagerProvisioningStateUpdating,
	}
}

// ClusterMetricsConfigurationDetailedStatus - The more detailed status of the metrics configuration.
type ClusterMetricsConfigurationDetailedStatus string

const (
	ClusterMetricsConfigurationDetailedStatusApplied    ClusterMetricsConfigurationDetailedStatus = "Applied"
	ClusterMetricsConfigurationDetailedStatusError      ClusterMetricsConfigurationDetailedStatus = "Error"
	ClusterMetricsConfigurationDetailedStatusProcessing ClusterMetricsConfigurationDetailedStatus = "Processing"
)

// PossibleClusterMetricsConfigurationDetailedStatusValues returns the possible values for the ClusterMetricsConfigurationDetailedStatus const type.
func PossibleClusterMetricsConfigurationDetailedStatusValues() []ClusterMetricsConfigurationDetailedStatus {
	return []ClusterMetricsConfigurationDetailedStatus{
		ClusterMetricsConfigurationDetailedStatusApplied,
		ClusterMetricsConfigurationDetailedStatusError,
		ClusterMetricsConfigurationDetailedStatusProcessing,
	}
}

// ClusterMetricsConfigurationProvisioningState - The provisioning state of the metrics configuration.
type ClusterMetricsConfigurationProvisioningState string

const (
	ClusterMetricsConfigurationProvisioningStateAccepted     ClusterMetricsConfigurationProvisioningState = "Accepted"
	ClusterMetricsConfigurationProvisioningStateCanceled     ClusterMetricsConfigurationProvisioningState = "Canceled"
	ClusterMetricsConfigurationProvisioningStateFailed       ClusterMetricsConfigurationProvisioningState = "Failed"
	ClusterMetricsConfigurationProvisioningStateProvisioning ClusterMetricsConfigurationProvisioningState = "Provisioning"
	ClusterMetricsConfigurationProvisioningStateSucceeded    ClusterMetricsConfigurationProvisioningState = "Succeeded"
)

// PossibleClusterMetricsConfigurationProvisioningStateValues returns the possible values for the ClusterMetricsConfigurationProvisioningState const type.
func PossibleClusterMetricsConfigurationProvisioningStateValues() []ClusterMetricsConfigurationProvisioningState {
	return []ClusterMetricsConfigurationProvisioningState{
		ClusterMetricsConfigurationProvisioningStateAccepted,
		ClusterMetricsConfigurationProvisioningStateCanceled,
		ClusterMetricsConfigurationProvisioningStateFailed,
		ClusterMetricsConfigurationProvisioningStateProvisioning,
		ClusterMetricsConfigurationProvisioningStateSucceeded,
	}
}

// ClusterProvisioningState - The provisioning state of the cluster.
type ClusterProvisioningState string

const (
	ClusterProvisioningStateAccepted   ClusterProvisioningState = "Accepted"
	ClusterProvisioningStateCanceled   ClusterProvisioningState = "Canceled"
	ClusterProvisioningStateFailed     ClusterProvisioningState = "Failed"
	ClusterProvisioningStateSucceeded  ClusterProvisioningState = "Succeeded"
	ClusterProvisioningStateUpdating   ClusterProvisioningState = "Updating"
	ClusterProvisioningStateValidating ClusterProvisioningState = "Validating"
)

// PossibleClusterProvisioningStateValues returns the possible values for the ClusterProvisioningState const type.
func PossibleClusterProvisioningStateValues() []ClusterProvisioningState {
	return []ClusterProvisioningState{
		ClusterProvisioningStateAccepted,
		ClusterProvisioningStateCanceled,
		ClusterProvisioningStateFailed,
		ClusterProvisioningStateSucceeded,
		ClusterProvisioningStateUpdating,
		ClusterProvisioningStateValidating,
	}
}

// ClusterType - The type of rack configuration for the cluster.
type ClusterType string

const (
	ClusterTypeMultiRack  ClusterType = "MultiRack"
	ClusterTypeSingleRack ClusterType = "SingleRack"
)

// PossibleClusterTypeValues returns the possible values for the ClusterType const type.
func PossibleClusterTypeValues() []ClusterType {
	return []ClusterType{
		ClusterTypeMultiRack,
		ClusterTypeSingleRack,
	}
}

// ConsoleDetailedStatus - The more detailed status of the console.
type ConsoleDetailedStatus string

const (
	ConsoleDetailedStatusError ConsoleDetailedStatus = "Error"
	ConsoleDetailedStatusReady ConsoleDetailedStatus = "Ready"
)

// PossibleConsoleDetailedStatusValues returns the possible values for the ConsoleDetailedStatus const type.
func PossibleConsoleDetailedStatusValues() []ConsoleDetailedStatus {
	return []ConsoleDetailedStatus{
		ConsoleDetailedStatusError,
		ConsoleDetailedStatusReady,
	}
}

// ConsoleEnabled - The credentials used to login to the image repository that has access to the specified image.
type ConsoleEnabled string

const (
	ConsoleEnabledFalse ConsoleEnabled = "False"
	ConsoleEnabledTrue  ConsoleEnabled = "True"
)

// PossibleConsoleEnabledValues returns the possible values for the ConsoleEnabled const type.
func PossibleConsoleEnabledValues() []ConsoleEnabled {
	return []ConsoleEnabled{
		ConsoleEnabledFalse,
		ConsoleEnabledTrue,
	}
}

// ConsoleProvisioningState - The provisioning state of the virtual machine console.
type ConsoleProvisioningState string

const (
	ConsoleProvisioningStateAccepted     ConsoleProvisioningState = "Accepted"
	ConsoleProvisioningStateCanceled     ConsoleProvisioningState = "Canceled"
	ConsoleProvisioningStateFailed       ConsoleProvisioningState = "Failed"
	ConsoleProvisioningStateProvisioning ConsoleProvisioningState = "Provisioning"
	ConsoleProvisioningStateSucceeded    ConsoleProvisioningState = "Succeeded"
)

// PossibleConsoleProvisioningStateValues returns the possible values for the ConsoleProvisioningState const type.
func PossibleConsoleProvisioningStateValues() []ConsoleProvisioningState {
	return []ConsoleProvisioningState{
		ConsoleProvisioningStateAccepted,
		ConsoleProvisioningStateCanceled,
		ConsoleProvisioningStateFailed,
		ConsoleProvisioningStateProvisioning,
		ConsoleProvisioningStateSucceeded,
	}
}

// ControlImpact - The indicator of whether the control plane will be impacted during the upgrade.
type ControlImpact string

const (
	ControlImpactFalse ControlImpact = "False"
	ControlImpactTrue  ControlImpact = "True"
)

// PossibleControlImpactValues returns the possible values for the ControlImpact const type.
func PossibleControlImpactValues() []ControlImpact {
	return []ControlImpact{
		ControlImpactFalse,
		ControlImpactTrue,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// DefaultGateway - The indicator of whether this is the default gateway. Only one of the attached networks (including the
// CloudServicesNetwork attachment) for a single machine may be specified as True.
type DefaultGateway string

const (
	DefaultGatewayFalse DefaultGateway = "False"
	DefaultGatewayTrue  DefaultGateway = "True"
)

// PossibleDefaultGatewayValues returns the possible values for the DefaultGateway const type.
func PossibleDefaultGatewayValues() []DefaultGateway {
	return []DefaultGateway{
		DefaultGatewayFalse,
		DefaultGatewayTrue,
	}
}

// DeviceConnectionType - The connection type of the device.
type DeviceConnectionType string

const (
	DeviceConnectionTypePCI DeviceConnectionType = "PCI"
)

// PossibleDeviceConnectionTypeValues returns the possible values for the DeviceConnectionType const type.
func PossibleDeviceConnectionTypeValues() []DeviceConnectionType {
	return []DeviceConnectionType{
		DeviceConnectionTypePCI,
	}
}

// DiskType - The disk type of rack SKU resource.
type DiskType string

const (
	DiskTypeHDD DiskType = "HDD"
	DiskTypeSSD DiskType = "SSD"
)

// PossibleDiskTypeValues returns the possible values for the DiskType const type.
func PossibleDiskTypeValues() []DiskType {
	return []DiskType{
		DiskTypeHDD,
		DiskTypeSSD,
	}
}

// FabricPeeringEnabled - The indicator to specify if the load balancer peers with the network fabric.
type FabricPeeringEnabled string

const (
	FabricPeeringEnabledFalse FabricPeeringEnabled = "False"
	FabricPeeringEnabledTrue  FabricPeeringEnabled = "True"
)

// PossibleFabricPeeringEnabledValues returns the possible values for the FabricPeeringEnabled const type.
func PossibleFabricPeeringEnabledValues() []FabricPeeringEnabled {
	return []FabricPeeringEnabled{
		FabricPeeringEnabledFalse,
		FabricPeeringEnabledTrue,
	}
}

// FeatureDetailedStatus - The status representing the state of this feature.
type FeatureDetailedStatus string

const (
	FeatureDetailedStatusFailed  FeatureDetailedStatus = "Failed"
	FeatureDetailedStatusRunning FeatureDetailedStatus = "Running"
	FeatureDetailedStatusUnknown FeatureDetailedStatus = "Unknown"
)

// PossibleFeatureDetailedStatusValues returns the possible values for the FeatureDetailedStatus const type.
func PossibleFeatureDetailedStatusValues() []FeatureDetailedStatus {
	return []FeatureDetailedStatus{
		FeatureDetailedStatusFailed,
		FeatureDetailedStatusRunning,
		FeatureDetailedStatusUnknown,
	}
}

// HugepagesSize - The size of the hugepages to allocate.
type HugepagesSize string

const (
	HugepagesSizeOneG HugepagesSize = "1G"
	HugepagesSizeTwoM HugepagesSize = "2M"
)

// PossibleHugepagesSizeValues returns the possible values for the HugepagesSize const type.
func PossibleHugepagesSizeValues() []HugepagesSize {
	return []HugepagesSize{
		HugepagesSizeOneG,
		HugepagesSizeTwoM,
	}
}

// HybridAksIpamEnabled - Field Deprecated. The field was previously optional, now it will have no defined behavior and will
// be ignored. The indicator of whether or not to disable IPAM allocation on the network attachment
// definition injected into the Hybrid AKS Cluster.
type HybridAksIpamEnabled string

const (
	HybridAksIpamEnabledFalse HybridAksIpamEnabled = "False"
	HybridAksIpamEnabledTrue  HybridAksIpamEnabled = "True"
)

// PossibleHybridAksIpamEnabledValues returns the possible values for the HybridAksIpamEnabled const type.
func PossibleHybridAksIpamEnabledValues() []HybridAksIpamEnabled {
	return []HybridAksIpamEnabled{
		HybridAksIpamEnabledFalse,
		HybridAksIpamEnabledTrue,
	}
}

// HybridAksPluginType - Field Deprecated. The field was previously optional, now it will have no defined behavior and will
// be ignored. The network plugin type for Hybrid AKS.
type HybridAksPluginType string

const (
	HybridAksPluginTypeDPDK     HybridAksPluginType = "DPDK"
	HybridAksPluginTypeOSDevice HybridAksPluginType = "OSDevice"
	HybridAksPluginTypeSRIOV    HybridAksPluginType = "SRIOV"
)

// PossibleHybridAksPluginTypeValues returns the possible values for the HybridAksPluginType const type.
func PossibleHybridAksPluginTypeValues() []HybridAksPluginType {
	return []HybridAksPluginType{
		HybridAksPluginTypeDPDK,
		HybridAksPluginTypeOSDevice,
		HybridAksPluginTypeSRIOV,
	}
}

// IPAllocationType - The type of the IP address allocation, defaulted to "DualStack".
type IPAllocationType string

const (
	IPAllocationTypeDualStack IPAllocationType = "DualStack"
	IPAllocationTypeIPV4      IPAllocationType = "IPV4"
	IPAllocationTypeIPV6      IPAllocationType = "IPV6"
)

// PossibleIPAllocationTypeValues returns the possible values for the IPAllocationType const type.
func PossibleIPAllocationTypeValues() []IPAllocationType {
	return []IPAllocationType{
		IPAllocationTypeDualStack,
		IPAllocationTypeIPV4,
		IPAllocationTypeIPV6,
	}
}

// KubernetesClusterDetailedStatus - The current status of the Kubernetes cluster.
type KubernetesClusterDetailedStatus string

const (
	KubernetesClusterDetailedStatusAvailable    KubernetesClusterDetailedStatus = "Available"
	KubernetesClusterDetailedStatusError        KubernetesClusterDetailedStatus = "Error"
	KubernetesClusterDetailedStatusProvisioning KubernetesClusterDetailedStatus = "Provisioning"
)

// PossibleKubernetesClusterDetailedStatusValues returns the possible values for the KubernetesClusterDetailedStatus const type.
func PossibleKubernetesClusterDetailedStatusValues() []KubernetesClusterDetailedStatus {
	return []KubernetesClusterDetailedStatus{
		KubernetesClusterDetailedStatusAvailable,
		KubernetesClusterDetailedStatusError,
		KubernetesClusterDetailedStatusProvisioning,
	}
}

// KubernetesClusterNodeDetailedStatus - The detailed state of this node.
type KubernetesClusterNodeDetailedStatus string

const (
	KubernetesClusterNodeDetailedStatusAvailable    KubernetesClusterNodeDetailedStatus = "Available"
	KubernetesClusterNodeDetailedStatusError        KubernetesClusterNodeDetailedStatus = "Error"
	KubernetesClusterNodeDetailedStatusProvisioning KubernetesClusterNodeDetailedStatus = "Provisioning"
	KubernetesClusterNodeDetailedStatusRunning      KubernetesClusterNodeDetailedStatus = "Running"
	KubernetesClusterNodeDetailedStatusScheduling   KubernetesClusterNodeDetailedStatus = "Scheduling"
	KubernetesClusterNodeDetailedStatusStopped      KubernetesClusterNodeDetailedStatus = "Stopped"
	KubernetesClusterNodeDetailedStatusTerminating  KubernetesClusterNodeDetailedStatus = "Terminating"
	KubernetesClusterNodeDetailedStatusUnknown      KubernetesClusterNodeDetailedStatus = "Unknown"
)

// PossibleKubernetesClusterNodeDetailedStatusValues returns the possible values for the KubernetesClusterNodeDetailedStatus const type.
func PossibleKubernetesClusterNodeDetailedStatusValues() []KubernetesClusterNodeDetailedStatus {
	return []KubernetesClusterNodeDetailedStatus{
		KubernetesClusterNodeDetailedStatusAvailable,
		KubernetesClusterNodeDetailedStatusError,
		KubernetesClusterNodeDetailedStatusProvisioning,
		KubernetesClusterNodeDetailedStatusRunning,
		KubernetesClusterNodeDetailedStatusScheduling,
		KubernetesClusterNodeDetailedStatusStopped,
		KubernetesClusterNodeDetailedStatusTerminating,
		KubernetesClusterNodeDetailedStatusUnknown,
	}
}

// KubernetesClusterProvisioningState - The provisioning state of the Kubernetes cluster resource.
type KubernetesClusterProvisioningState string

const (
	KubernetesClusterProvisioningStateAccepted   KubernetesClusterProvisioningState = "Accepted"
	KubernetesClusterProvisioningStateCanceled   KubernetesClusterProvisioningState = "Canceled"
	KubernetesClusterProvisioningStateCreated    KubernetesClusterProvisioningState = "Created"
	KubernetesClusterProvisioningStateDeleting   KubernetesClusterProvisioningState = "Deleting"
	KubernetesClusterProvisioningStateFailed     KubernetesClusterProvisioningState = "Failed"
	KubernetesClusterProvisioningStateInProgress KubernetesClusterProvisioningState = "InProgress"
	KubernetesClusterProvisioningStateSucceeded  KubernetesClusterProvisioningState = "Succeeded"
	KubernetesClusterProvisioningStateUpdating   KubernetesClusterProvisioningState = "Updating"
)

// PossibleKubernetesClusterProvisioningStateValues returns the possible values for the KubernetesClusterProvisioningState const type.
func PossibleKubernetesClusterProvisioningStateValues() []KubernetesClusterProvisioningState {
	return []KubernetesClusterProvisioningState{
		KubernetesClusterProvisioningStateAccepted,
		KubernetesClusterProvisioningStateCanceled,
		KubernetesClusterProvisioningStateCreated,
		KubernetesClusterProvisioningStateDeleting,
		KubernetesClusterProvisioningStateFailed,
		KubernetesClusterProvisioningStateInProgress,
		KubernetesClusterProvisioningStateSucceeded,
		KubernetesClusterProvisioningStateUpdating,
	}
}

// KubernetesNodePowerState - The power state of this node.
type KubernetesNodePowerState string

const (
	KubernetesNodePowerStateOff     KubernetesNodePowerState = "Off"
	KubernetesNodePowerStateOn      KubernetesNodePowerState = "On"
	KubernetesNodePowerStateUnknown KubernetesNodePowerState = "Unknown"
)

// PossibleKubernetesNodePowerStateValues returns the possible values for the KubernetesNodePowerState const type.
func PossibleKubernetesNodePowerStateValues() []KubernetesNodePowerState {
	return []KubernetesNodePowerState{
		KubernetesNodePowerStateOff,
		KubernetesNodePowerStateOn,
		KubernetesNodePowerStateUnknown,
	}
}

// KubernetesNodeRole - The role of this node in the cluster.
type KubernetesNodeRole string

const (
	KubernetesNodeRoleControlPlane KubernetesNodeRole = "ControlPlane"
	KubernetesNodeRoleWorker       KubernetesNodeRole = "Worker"
)

// PossibleKubernetesNodeRoleValues returns the possible values for the KubernetesNodeRole const type.
func PossibleKubernetesNodeRoleValues() []KubernetesNodeRole {
	return []KubernetesNodeRole{
		KubernetesNodeRoleControlPlane,
		KubernetesNodeRoleWorker,
	}
}

// KubernetesPluginType - The indicator of how this network will be utilized by the Kubernetes cluster.
type KubernetesPluginType string

const (
	KubernetesPluginTypeDPDK     KubernetesPluginType = "DPDK"
	KubernetesPluginTypeIPVLAN   KubernetesPluginType = "IPVLAN"
	KubernetesPluginTypeMACVLAN  KubernetesPluginType = "MACVLAN"
	KubernetesPluginTypeOSDevice KubernetesPluginType = "OSDevice"
	KubernetesPluginTypeSRIOV    KubernetesPluginType = "SRIOV"
)

// PossibleKubernetesPluginTypeValues returns the possible values for the KubernetesPluginType const type.
func PossibleKubernetesPluginTypeValues() []KubernetesPluginType {
	return []KubernetesPluginType{
		KubernetesPluginTypeDPDK,
		KubernetesPluginTypeIPVLAN,
		KubernetesPluginTypeMACVLAN,
		KubernetesPluginTypeOSDevice,
		KubernetesPluginTypeSRIOV,
	}
}

// L2NetworkDetailedStatus - The more detailed status of the L2 network.
type L2NetworkDetailedStatus string

const (
	L2NetworkDetailedStatusAvailable    L2NetworkDetailedStatus = "Available"
	L2NetworkDetailedStatusError        L2NetworkDetailedStatus = "Error"
	L2NetworkDetailedStatusProvisioning L2NetworkDetailedStatus = "Provisioning"
)

// PossibleL2NetworkDetailedStatusValues returns the possible values for the L2NetworkDetailedStatus const type.
func PossibleL2NetworkDetailedStatusValues() []L2NetworkDetailedStatus {
	return []L2NetworkDetailedStatus{
		L2NetworkDetailedStatusAvailable,
		L2NetworkDetailedStatusError,
		L2NetworkDetailedStatusProvisioning,
	}
}

// L2NetworkProvisioningState - The provisioning state of the L2 network.
type L2NetworkProvisioningState string

const (
	L2NetworkProvisioningStateAccepted     L2NetworkProvisioningState = "Accepted"
	L2NetworkProvisioningStateCanceled     L2NetworkProvisioningState = "Canceled"
	L2NetworkProvisioningStateFailed       L2NetworkProvisioningState = "Failed"
	L2NetworkProvisioningStateProvisioning L2NetworkProvisioningState = "Provisioning"
	L2NetworkProvisioningStateSucceeded    L2NetworkProvisioningState = "Succeeded"
)

// PossibleL2NetworkProvisioningStateValues returns the possible values for the L2NetworkProvisioningState const type.
func PossibleL2NetworkProvisioningStateValues() []L2NetworkProvisioningState {
	return []L2NetworkProvisioningState{
		L2NetworkProvisioningStateAccepted,
		L2NetworkProvisioningStateCanceled,
		L2NetworkProvisioningStateFailed,
		L2NetworkProvisioningStateProvisioning,
		L2NetworkProvisioningStateSucceeded,
	}
}

// L3NetworkConfigurationIpamEnabled - The indication of whether this network will or will not perform IP address management
// and allocate IP addresses when attached.
type L3NetworkConfigurationIpamEnabled string

const (
	L3NetworkConfigurationIpamEnabledFalse L3NetworkConfigurationIpamEnabled = "False"
	L3NetworkConfigurationIpamEnabledTrue  L3NetworkConfigurationIpamEnabled = "True"
)

// PossibleL3NetworkConfigurationIpamEnabledValues returns the possible values for the L3NetworkConfigurationIpamEnabled const type.
func PossibleL3NetworkConfigurationIpamEnabledValues() []L3NetworkConfigurationIpamEnabled {
	return []L3NetworkConfigurationIpamEnabled{
		L3NetworkConfigurationIpamEnabledFalse,
		L3NetworkConfigurationIpamEnabledTrue,
	}
}

// L3NetworkDetailedStatus - The more detailed status of the L3 network.
type L3NetworkDetailedStatus string

const (
	L3NetworkDetailedStatusAvailable    L3NetworkDetailedStatus = "Available"
	L3NetworkDetailedStatusError        L3NetworkDetailedStatus = "Error"
	L3NetworkDetailedStatusProvisioning L3NetworkDetailedStatus = "Provisioning"
)

// PossibleL3NetworkDetailedStatusValues returns the possible values for the L3NetworkDetailedStatus const type.
func PossibleL3NetworkDetailedStatusValues() []L3NetworkDetailedStatus {
	return []L3NetworkDetailedStatus{
		L3NetworkDetailedStatusAvailable,
		L3NetworkDetailedStatusError,
		L3NetworkDetailedStatusProvisioning,
	}
}

// L3NetworkProvisioningState - The provisioning state of the L3 network.
type L3NetworkProvisioningState string

const (
	L3NetworkProvisioningStateAccepted     L3NetworkProvisioningState = "Accepted"
	L3NetworkProvisioningStateCanceled     L3NetworkProvisioningState = "Canceled"
	L3NetworkProvisioningStateFailed       L3NetworkProvisioningState = "Failed"
	L3NetworkProvisioningStateProvisioning L3NetworkProvisioningState = "Provisioning"
	L3NetworkProvisioningStateSucceeded    L3NetworkProvisioningState = "Succeeded"
)

// PossibleL3NetworkProvisioningStateValues returns the possible values for the L3NetworkProvisioningState const type.
func PossibleL3NetworkProvisioningStateValues() []L3NetworkProvisioningState {
	return []L3NetworkProvisioningState{
		L3NetworkProvisioningStateAccepted,
		L3NetworkProvisioningStateCanceled,
		L3NetworkProvisioningStateFailed,
		L3NetworkProvisioningStateProvisioning,
		L3NetworkProvisioningStateSucceeded,
	}
}

// MachineSKUDiskConnectionType - The connection type of the rack SKU resource.
type MachineSKUDiskConnectionType string

const (
	MachineSKUDiskConnectionTypePCIE MachineSKUDiskConnectionType = "PCIE"
	MachineSKUDiskConnectionTypeRAID MachineSKUDiskConnectionType = "RAID"
	MachineSKUDiskConnectionTypeSAS  MachineSKUDiskConnectionType = "SAS"
	MachineSKUDiskConnectionTypeSATA MachineSKUDiskConnectionType = "SATA"
)

// PossibleMachineSKUDiskConnectionTypeValues returns the possible values for the MachineSKUDiskConnectionType const type.
func PossibleMachineSKUDiskConnectionTypeValues() []MachineSKUDiskConnectionType {
	return []MachineSKUDiskConnectionType{
		MachineSKUDiskConnectionTypePCIE,
		MachineSKUDiskConnectionTypeRAID,
		MachineSKUDiskConnectionTypeSAS,
		MachineSKUDiskConnectionTypeSATA,
	}
}

// Origin - The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
// value is "user,system"
type Origin string

const (
	OriginSystem     Origin = "system"
	OriginUser       Origin = "user"
	OriginUserSystem Origin = "user,system"
)

// PossibleOriginValues returns the possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{
		OriginSystem,
		OriginUser,
		OriginUserSystem,
	}
}

// OsDiskCreateOption - The strategy for creating the OS disk.
type OsDiskCreateOption string

const (
	OsDiskCreateOptionEphemeral OsDiskCreateOption = "Ephemeral"
)

// PossibleOsDiskCreateOptionValues returns the possible values for the OsDiskCreateOption const type.
func PossibleOsDiskCreateOptionValues() []OsDiskCreateOption {
	return []OsDiskCreateOption{
		OsDiskCreateOptionEphemeral,
	}
}

// OsDiskDeleteOption - The strategy for deleting the OS disk.
type OsDiskDeleteOption string

const (
	OsDiskDeleteOptionDelete OsDiskDeleteOption = "Delete"
)

// PossibleOsDiskDeleteOptionValues returns the possible values for the OsDiskDeleteOption const type.
func PossibleOsDiskDeleteOptionValues() []OsDiskDeleteOption {
	return []OsDiskDeleteOption{
		OsDiskDeleteOptionDelete,
	}
}

// RackDetailedStatus - The more detailed status of the rack.
type RackDetailedStatus string

const (
	RackDetailedStatusAvailable    RackDetailedStatus = "Available"
	RackDetailedStatusError        RackDetailedStatus = "Error"
	RackDetailedStatusProvisioning RackDetailedStatus = "Provisioning"
)

// PossibleRackDetailedStatusValues returns the possible values for the RackDetailedStatus const type.
func PossibleRackDetailedStatusValues() []RackDetailedStatus {
	return []RackDetailedStatus{
		RackDetailedStatusAvailable,
		RackDetailedStatusError,
		RackDetailedStatusProvisioning,
	}
}

// RackProvisioningState - The provisioning state of the rack resource.
type RackProvisioningState string

const (
	RackProvisioningStateAccepted     RackProvisioningState = "Accepted"
	RackProvisioningStateCanceled     RackProvisioningState = "Canceled"
	RackProvisioningStateFailed       RackProvisioningState = "Failed"
	RackProvisioningStateProvisioning RackProvisioningState = "Provisioning"
	RackProvisioningStateSucceeded    RackProvisioningState = "Succeeded"
)

// PossibleRackProvisioningStateValues returns the possible values for the RackProvisioningState const type.
func PossibleRackProvisioningStateValues() []RackProvisioningState {
	return []RackProvisioningState{
		RackProvisioningStateAccepted,
		RackProvisioningStateCanceled,
		RackProvisioningStateFailed,
		RackProvisioningStateProvisioning,
		RackProvisioningStateSucceeded,
	}
}

// RackSKUProvisioningState - The provisioning state of the rack SKU resource.
type RackSKUProvisioningState string

const (
	RackSKUProvisioningStateSucceeded RackSKUProvisioningState = "Succeeded"
)

// PossibleRackSKUProvisioningStateValues returns the possible values for the RackSKUProvisioningState const type.
func PossibleRackSKUProvisioningStateValues() []RackSKUProvisioningState {
	return []RackSKUProvisioningState{
		RackSKUProvisioningStateSucceeded,
	}
}

// RackSKUType - The type of the rack.
type RackSKUType string

const (
	RackSKUTypeAggregator RackSKUType = "Aggregator"
	RackSKUTypeCompute    RackSKUType = "Compute"
	RackSKUTypeSingle     RackSKUType = "Single"
)

// PossibleRackSKUTypeValues returns the possible values for the RackSKUType const type.
func PossibleRackSKUTypeValues() []RackSKUType {
	return []RackSKUType{
		RackSKUTypeAggregator,
		RackSKUTypeCompute,
		RackSKUTypeSingle,
	}
}

// RemoteVendorManagementFeature - The indicator of whether the storage appliance supports remote vendor management.
type RemoteVendorManagementFeature string

const (
	RemoteVendorManagementFeatureSupported   RemoteVendorManagementFeature = "Supported"
	RemoteVendorManagementFeatureUnsupported RemoteVendorManagementFeature = "Unsupported"
)

// PossibleRemoteVendorManagementFeatureValues returns the possible values for the RemoteVendorManagementFeature const type.
func PossibleRemoteVendorManagementFeatureValues() []RemoteVendorManagementFeature {
	return []RemoteVendorManagementFeature{
		RemoteVendorManagementFeatureSupported,
		RemoteVendorManagementFeatureUnsupported,
	}
}

// RemoteVendorManagementStatus - The indicator of whether the remote vendor management feature is enabled or disabled, or
// unsupported if it is an unsupported feature.
type RemoteVendorManagementStatus string

const (
	RemoteVendorManagementStatusDisabled    RemoteVendorManagementStatus = "Disabled"
	RemoteVendorManagementStatusEnabled     RemoteVendorManagementStatus = "Enabled"
	RemoteVendorManagementStatusUnsupported RemoteVendorManagementStatus = "Unsupported"
)

// PossibleRemoteVendorManagementStatusValues returns the possible values for the RemoteVendorManagementStatus const type.
func PossibleRemoteVendorManagementStatusValues() []RemoteVendorManagementStatus {
	return []RemoteVendorManagementStatus{
		RemoteVendorManagementStatusDisabled,
		RemoteVendorManagementStatusEnabled,
		RemoteVendorManagementStatusUnsupported,
	}
}

// SkipShutdown - The indicator of whether to skip the graceful OS shutdown and power off the virtual machine immediately.
type SkipShutdown string

const (
	SkipShutdownFalse SkipShutdown = "False"
	SkipShutdownTrue  SkipShutdown = "True"
)

// PossibleSkipShutdownValues returns the possible values for the SkipShutdown const type.
func PossibleSkipShutdownValues() []SkipShutdown {
	return []SkipShutdown{
		SkipShutdownFalse,
		SkipShutdownTrue,
	}
}

// StorageApplianceDetailedStatus - The detailed status of the storage appliance.
type StorageApplianceDetailedStatus string

const (
	StorageApplianceDetailedStatusAvailable    StorageApplianceDetailedStatus = "Available"
	StorageApplianceDetailedStatusError        StorageApplianceDetailedStatus = "Error"
	StorageApplianceDetailedStatusProvisioning StorageApplianceDetailedStatus = "Provisioning"
)

// PossibleStorageApplianceDetailedStatusValues returns the possible values for the StorageApplianceDetailedStatus const type.
func PossibleStorageApplianceDetailedStatusValues() []StorageApplianceDetailedStatus {
	return []StorageApplianceDetailedStatus{
		StorageApplianceDetailedStatusAvailable,
		StorageApplianceDetailedStatusError,
		StorageApplianceDetailedStatusProvisioning,
	}
}

// StorageApplianceProvisioningState - The provisioning state of the storage appliance.
type StorageApplianceProvisioningState string

const (
	StorageApplianceProvisioningStateAccepted     StorageApplianceProvisioningState = "Accepted"
	StorageApplianceProvisioningStateCanceled     StorageApplianceProvisioningState = "Canceled"
	StorageApplianceProvisioningStateFailed       StorageApplianceProvisioningState = "Failed"
	StorageApplianceProvisioningStateProvisioning StorageApplianceProvisioningState = "Provisioning"
	StorageApplianceProvisioningStateSucceeded    StorageApplianceProvisioningState = "Succeeded"
)

// PossibleStorageApplianceProvisioningStateValues returns the possible values for the StorageApplianceProvisioningState const type.
func PossibleStorageApplianceProvisioningStateValues() []StorageApplianceProvisioningState {
	return []StorageApplianceProvisioningState{
		StorageApplianceProvisioningStateAccepted,
		StorageApplianceProvisioningStateCanceled,
		StorageApplianceProvisioningStateFailed,
		StorageApplianceProvisioningStateProvisioning,
		StorageApplianceProvisioningStateSucceeded,
	}
}

// TrunkedNetworkDetailedStatus - The more detailed status of the trunked network.
type TrunkedNetworkDetailedStatus string

const (
	TrunkedNetworkDetailedStatusAvailable    TrunkedNetworkDetailedStatus = "Available"
	TrunkedNetworkDetailedStatusError        TrunkedNetworkDetailedStatus = "Error"
	TrunkedNetworkDetailedStatusProvisioning TrunkedNetworkDetailedStatus = "Provisioning"
)

// PossibleTrunkedNetworkDetailedStatusValues returns the possible values for the TrunkedNetworkDetailedStatus const type.
func PossibleTrunkedNetworkDetailedStatusValues() []TrunkedNetworkDetailedStatus {
	return []TrunkedNetworkDetailedStatus{
		TrunkedNetworkDetailedStatusAvailable,
		TrunkedNetworkDetailedStatusError,
		TrunkedNetworkDetailedStatusProvisioning,
	}
}

// TrunkedNetworkProvisioningState - The provisioning state of the trunked network.
type TrunkedNetworkProvisioningState string

const (
	TrunkedNetworkProvisioningStateAccepted     TrunkedNetworkProvisioningState = "Accepted"
	TrunkedNetworkProvisioningStateCanceled     TrunkedNetworkProvisioningState = "Canceled"
	TrunkedNetworkProvisioningStateFailed       TrunkedNetworkProvisioningState = "Failed"
	TrunkedNetworkProvisioningStateProvisioning TrunkedNetworkProvisioningState = "Provisioning"
	TrunkedNetworkProvisioningStateSucceeded    TrunkedNetworkProvisioningState = "Succeeded"
)

// PossibleTrunkedNetworkProvisioningStateValues returns the possible values for the TrunkedNetworkProvisioningState const type.
func PossibleTrunkedNetworkProvisioningStateValues() []TrunkedNetworkProvisioningState {
	return []TrunkedNetworkProvisioningState{
		TrunkedNetworkProvisioningStateAccepted,
		TrunkedNetworkProvisioningStateCanceled,
		TrunkedNetworkProvisioningStateFailed,
		TrunkedNetworkProvisioningStateProvisioning,
		TrunkedNetworkProvisioningStateSucceeded,
	}
}

// ValidationThresholdGrouping - Selection of how the type evaluation is applied to the cluster calculation.
type ValidationThresholdGrouping string

const (
	ValidationThresholdGroupingPerCluster ValidationThresholdGrouping = "PerCluster"
	ValidationThresholdGroupingPerRack    ValidationThresholdGrouping = "PerRack"
)

// PossibleValidationThresholdGroupingValues returns the possible values for the ValidationThresholdGrouping const type.
func PossibleValidationThresholdGroupingValues() []ValidationThresholdGrouping {
	return []ValidationThresholdGrouping{
		ValidationThresholdGroupingPerCluster,
		ValidationThresholdGroupingPerRack,
	}
}

// ValidationThresholdType - Selection of how the threshold should be evaluated.
type ValidationThresholdType string

const (
	ValidationThresholdTypeCountSuccess   ValidationThresholdType = "CountSuccess"
	ValidationThresholdTypePercentSuccess ValidationThresholdType = "PercentSuccess"
)

// PossibleValidationThresholdTypeValues returns the possible values for the ValidationThresholdType const type.
func PossibleValidationThresholdTypeValues() []ValidationThresholdType {
	return []ValidationThresholdType{
		ValidationThresholdTypeCountSuccess,
		ValidationThresholdTypePercentSuccess,
	}
}

// VirtualMachineBootMethod - Selects the boot method for the virtual machine.
type VirtualMachineBootMethod string

const (
	VirtualMachineBootMethodBIOS VirtualMachineBootMethod = "BIOS"
	VirtualMachineBootMethodUEFI VirtualMachineBootMethod = "UEFI"
)

// PossibleVirtualMachineBootMethodValues returns the possible values for the VirtualMachineBootMethod const type.
func PossibleVirtualMachineBootMethodValues() []VirtualMachineBootMethod {
	return []VirtualMachineBootMethod{
		VirtualMachineBootMethodBIOS,
		VirtualMachineBootMethodUEFI,
	}
}

// VirtualMachineDetailedStatus - The more detailed status of the virtual machine.
type VirtualMachineDetailedStatus string

const (
	VirtualMachineDetailedStatusAvailable    VirtualMachineDetailedStatus = "Available"
	VirtualMachineDetailedStatusError        VirtualMachineDetailedStatus = "Error"
	VirtualMachineDetailedStatusProvisioning VirtualMachineDetailedStatus = "Provisioning"
	VirtualMachineDetailedStatusRunning      VirtualMachineDetailedStatus = "Running"
	VirtualMachineDetailedStatusScheduling   VirtualMachineDetailedStatus = "Scheduling"
	VirtualMachineDetailedStatusStopped      VirtualMachineDetailedStatus = "Stopped"
	VirtualMachineDetailedStatusTerminating  VirtualMachineDetailedStatus = "Terminating"
	VirtualMachineDetailedStatusUnknown      VirtualMachineDetailedStatus = "Unknown"
)

// PossibleVirtualMachineDetailedStatusValues returns the possible values for the VirtualMachineDetailedStatus const type.
func PossibleVirtualMachineDetailedStatusValues() []VirtualMachineDetailedStatus {
	return []VirtualMachineDetailedStatus{
		VirtualMachineDetailedStatusAvailable,
		VirtualMachineDetailedStatusError,
		VirtualMachineDetailedStatusProvisioning,
		VirtualMachineDetailedStatusRunning,
		VirtualMachineDetailedStatusScheduling,
		VirtualMachineDetailedStatusStopped,
		VirtualMachineDetailedStatusTerminating,
		VirtualMachineDetailedStatusUnknown,
	}
}

// VirtualMachineDeviceModelType - The type of the device model to use.
type VirtualMachineDeviceModelType string

const (
	VirtualMachineDeviceModelTypeT1 VirtualMachineDeviceModelType = "T1"
	VirtualMachineDeviceModelTypeT2 VirtualMachineDeviceModelType = "T2"
)

// PossibleVirtualMachineDeviceModelTypeValues returns the possible values for the VirtualMachineDeviceModelType const type.
func PossibleVirtualMachineDeviceModelTypeValues() []VirtualMachineDeviceModelType {
	return []VirtualMachineDeviceModelType{
		VirtualMachineDeviceModelTypeT1,
		VirtualMachineDeviceModelTypeT2,
	}
}

// VirtualMachineIPAllocationMethod - The IP allocation mechanism for the virtual machine. Dynamic and Static are only valid
// for l3Network which may also specify Disabled. Otherwise, Disabled is the only permitted value.
type VirtualMachineIPAllocationMethod string

const (
	VirtualMachineIPAllocationMethodDisabled VirtualMachineIPAllocationMethod = "Disabled"
	VirtualMachineIPAllocationMethodDynamic  VirtualMachineIPAllocationMethod = "Dynamic"
	VirtualMachineIPAllocationMethodStatic   VirtualMachineIPAllocationMethod = "Static"
)

// PossibleVirtualMachineIPAllocationMethodValues returns the possible values for the VirtualMachineIPAllocationMethod const type.
func PossibleVirtualMachineIPAllocationMethodValues() []VirtualMachineIPAllocationMethod {
	return []VirtualMachineIPAllocationMethod{
		VirtualMachineIPAllocationMethodDisabled,
		VirtualMachineIPAllocationMethodDynamic,
		VirtualMachineIPAllocationMethodStatic,
	}
}

// VirtualMachineIsolateEmulatorThread - Field Deprecated, the value will be ignored if provided. The indicator of whether
// one of the specified CPU cores is isolated to run the emulator thread for this virtual machine.
type VirtualMachineIsolateEmulatorThread string

const (
	VirtualMachineIsolateEmulatorThreadFalse VirtualMachineIsolateEmulatorThread = "False"
	VirtualMachineIsolateEmulatorThreadTrue  VirtualMachineIsolateEmulatorThread = "True"
)

// PossibleVirtualMachineIsolateEmulatorThreadValues returns the possible values for the VirtualMachineIsolateEmulatorThread const type.
func PossibleVirtualMachineIsolateEmulatorThreadValues() []VirtualMachineIsolateEmulatorThread {
	return []VirtualMachineIsolateEmulatorThread{
		VirtualMachineIsolateEmulatorThreadFalse,
		VirtualMachineIsolateEmulatorThreadTrue,
	}
}

// VirtualMachinePlacementHintPodAffinityScope - The scope for the virtual machine affinity or anti-affinity placement hint.
// It should always be "Machine" in the case of node affinity.
type VirtualMachinePlacementHintPodAffinityScope string

const (
	VirtualMachinePlacementHintPodAffinityScopeMachine VirtualMachinePlacementHintPodAffinityScope = "Machine"
	VirtualMachinePlacementHintPodAffinityScopeRack    VirtualMachinePlacementHintPodAffinityScope = "Rack"
)

// PossibleVirtualMachinePlacementHintPodAffinityScopeValues returns the possible values for the VirtualMachinePlacementHintPodAffinityScope const type.
func PossibleVirtualMachinePlacementHintPodAffinityScopeValues() []VirtualMachinePlacementHintPodAffinityScope {
	return []VirtualMachinePlacementHintPodAffinityScope{
		VirtualMachinePlacementHintPodAffinityScopeMachine,
		VirtualMachinePlacementHintPodAffinityScopeRack,
	}
}

// VirtualMachinePlacementHintType - The specification of whether this hint supports affinity or anti-affinity with the referenced
// resources.
type VirtualMachinePlacementHintType string

const (
	VirtualMachinePlacementHintTypeAffinity     VirtualMachinePlacementHintType = "Affinity"
	VirtualMachinePlacementHintTypeAntiAffinity VirtualMachinePlacementHintType = "AntiAffinity"
)

// PossibleVirtualMachinePlacementHintTypeValues returns the possible values for the VirtualMachinePlacementHintType const type.
func PossibleVirtualMachinePlacementHintTypeValues() []VirtualMachinePlacementHintType {
	return []VirtualMachinePlacementHintType{
		VirtualMachinePlacementHintTypeAffinity,
		VirtualMachinePlacementHintTypeAntiAffinity,
	}
}

// VirtualMachinePowerState - The power state of the virtual machine.
type VirtualMachinePowerState string

const (
	VirtualMachinePowerStateOff     VirtualMachinePowerState = "Off"
	VirtualMachinePowerStateOn      VirtualMachinePowerState = "On"
	VirtualMachinePowerStateUnknown VirtualMachinePowerState = "Unknown"
)

// PossibleVirtualMachinePowerStateValues returns the possible values for the VirtualMachinePowerState const type.
func PossibleVirtualMachinePowerStateValues() []VirtualMachinePowerState {
	return []VirtualMachinePowerState{
		VirtualMachinePowerStateOff,
		VirtualMachinePowerStateOn,
		VirtualMachinePowerStateUnknown,
	}
}

// VirtualMachineProvisioningState - The provisioning state of the virtual machine.
type VirtualMachineProvisioningState string

const (
	VirtualMachineProvisioningStateAccepted     VirtualMachineProvisioningState = "Accepted"
	VirtualMachineProvisioningStateCanceled     VirtualMachineProvisioningState = "Canceled"
	VirtualMachineProvisioningStateFailed       VirtualMachineProvisioningState = "Failed"
	VirtualMachineProvisioningStateProvisioning VirtualMachineProvisioningState = "Provisioning"
	VirtualMachineProvisioningStateSucceeded    VirtualMachineProvisioningState = "Succeeded"
)

// PossibleVirtualMachineProvisioningStateValues returns the possible values for the VirtualMachineProvisioningState const type.
func PossibleVirtualMachineProvisioningStateValues() []VirtualMachineProvisioningState {
	return []VirtualMachineProvisioningState{
		VirtualMachineProvisioningStateAccepted,
		VirtualMachineProvisioningStateCanceled,
		VirtualMachineProvisioningStateFailed,
		VirtualMachineProvisioningStateProvisioning,
		VirtualMachineProvisioningStateSucceeded,
	}
}

// VirtualMachineSchedulingExecution - The indicator of whether the hint is a hard or soft requirement during scheduling.
type VirtualMachineSchedulingExecution string

const (
	VirtualMachineSchedulingExecutionHard VirtualMachineSchedulingExecution = "Hard"
	VirtualMachineSchedulingExecutionSoft VirtualMachineSchedulingExecution = "Soft"
)

// PossibleVirtualMachineSchedulingExecutionValues returns the possible values for the VirtualMachineSchedulingExecution const type.
func PossibleVirtualMachineSchedulingExecutionValues() []VirtualMachineSchedulingExecution {
	return []VirtualMachineSchedulingExecution{
		VirtualMachineSchedulingExecutionHard,
		VirtualMachineSchedulingExecutionSoft,
	}
}

// VirtualMachineVirtioInterfaceType - Field Deprecated, use virtualizationModel instead. The type of the virtio interface.
type VirtualMachineVirtioInterfaceType string

const (
	VirtualMachineVirtioInterfaceTypeModern       VirtualMachineVirtioInterfaceType = "Modern"
	VirtualMachineVirtioInterfaceTypeTransitional VirtualMachineVirtioInterfaceType = "Transitional"
)

// PossibleVirtualMachineVirtioInterfaceTypeValues returns the possible values for the VirtualMachineVirtioInterfaceType const type.
func PossibleVirtualMachineVirtioInterfaceTypeValues() []VirtualMachineVirtioInterfaceType {
	return []VirtualMachineVirtioInterfaceType{
		VirtualMachineVirtioInterfaceTypeModern,
		VirtualMachineVirtioInterfaceTypeTransitional,
	}
}

// VolumeDetailedStatus - The more detailed status of the volume.
type VolumeDetailedStatus string

const (
	VolumeDetailedStatusActive       VolumeDetailedStatus = "Active"
	VolumeDetailedStatusError        VolumeDetailedStatus = "Error"
	VolumeDetailedStatusProvisioning VolumeDetailedStatus = "Provisioning"
)

// PossibleVolumeDetailedStatusValues returns the possible values for the VolumeDetailedStatus const type.
func PossibleVolumeDetailedStatusValues() []VolumeDetailedStatus {
	return []VolumeDetailedStatus{
		VolumeDetailedStatusActive,
		VolumeDetailedStatusError,
		VolumeDetailedStatusProvisioning,
	}
}

// VolumeProvisioningState - The provisioning state of the volume.
type VolumeProvisioningState string

const (
	VolumeProvisioningStateAccepted     VolumeProvisioningState = "Accepted"
	VolumeProvisioningStateCanceled     VolumeProvisioningState = "Canceled"
	VolumeProvisioningStateFailed       VolumeProvisioningState = "Failed"
	VolumeProvisioningStateProvisioning VolumeProvisioningState = "Provisioning"
	VolumeProvisioningStateSucceeded    VolumeProvisioningState = "Succeeded"
)

// PossibleVolumeProvisioningStateValues returns the possible values for the VolumeProvisioningState const type.
func PossibleVolumeProvisioningStateValues() []VolumeProvisioningState {
	return []VolumeProvisioningState{
		VolumeProvisioningStateAccepted,
		VolumeProvisioningStateCanceled,
		VolumeProvisioningStateFailed,
		VolumeProvisioningStateProvisioning,
		VolumeProvisioningStateSucceeded,
	}
}

// WorkloadImpact - The indicator of whether the workload will be impacted during the upgrade.
type WorkloadImpact string

const (
	WorkloadImpactFalse WorkloadImpact = "False"
	WorkloadImpactTrue  WorkloadImpact = "True"
)

// PossibleWorkloadImpactValues returns the possible values for the WorkloadImpact const type.
func PossibleWorkloadImpactValues() []WorkloadImpact {
	return []WorkloadImpact{
		WorkloadImpactFalse,
		WorkloadImpactTrue,
	}
}
