//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armnetworkcloud

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAgentPoolsClient creates a new instance of AgentPoolsClient.
func (c *ClientFactory) NewAgentPoolsClient() *AgentPoolsClient {
	subClient, _ := NewAgentPoolsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewBareMetalMachineKeySetsClient creates a new instance of BareMetalMachineKeySetsClient.
func (c *ClientFactory) NewBareMetalMachineKeySetsClient() *BareMetalMachineKeySetsClient {
	subClient, _ := NewBareMetalMachineKeySetsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewBareMetalMachinesClient creates a new instance of BareMetalMachinesClient.
func (c *ClientFactory) NewBareMetalMachinesClient() *BareMetalMachinesClient {
	subClient, _ := NewBareMetalMachinesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewBmcKeySetsClient creates a new instance of BmcKeySetsClient.
func (c *ClientFactory) NewBmcKeySetsClient() *BmcKeySetsClient {
	subClient, _ := NewBmcKeySetsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCloudServicesNetworksClient creates a new instance of CloudServicesNetworksClient.
func (c *ClientFactory) NewCloudServicesNetworksClient() *CloudServicesNetworksClient {
	subClient, _ := NewCloudServicesNetworksClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewClusterManagersClient creates a new instance of ClusterManagersClient.
func (c *ClientFactory) NewClusterManagersClient() *ClusterManagersClient {
	subClient, _ := NewClusterManagersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewClustersClient creates a new instance of ClustersClient.
func (c *ClientFactory) NewClustersClient() *ClustersClient {
	subClient, _ := NewClustersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewConsolesClient creates a new instance of ConsolesClient.
func (c *ClientFactory) NewConsolesClient() *ConsolesClient {
	subClient, _ := NewConsolesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewKubernetesClustersClient creates a new instance of KubernetesClustersClient.
func (c *ClientFactory) NewKubernetesClustersClient() *KubernetesClustersClient {
	subClient, _ := NewKubernetesClustersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewL2NetworksClient creates a new instance of L2NetworksClient.
func (c *ClientFactory) NewL2NetworksClient() *L2NetworksClient {
	subClient, _ := NewL2NetworksClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewL3NetworksClient creates a new instance of L3NetworksClient.
func (c *ClientFactory) NewL3NetworksClient() *L3NetworksClient {
	subClient, _ := NewL3NetworksClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewMetricsConfigurationsClient creates a new instance of MetricsConfigurationsClient.
func (c *ClientFactory) NewMetricsConfigurationsClient() *MetricsConfigurationsClient {
	subClient, _ := NewMetricsConfigurationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewRackSKUsClient creates a new instance of RackSKUsClient.
func (c *ClientFactory) NewRackSKUsClient() *RackSKUsClient {
	subClient, _ := NewRackSKUsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRacksClient creates a new instance of RacksClient.
func (c *ClientFactory) NewRacksClient() *RacksClient {
	subClient, _ := NewRacksClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewStorageAppliancesClient creates a new instance of StorageAppliancesClient.
func (c *ClientFactory) NewStorageAppliancesClient() *StorageAppliancesClient {
	subClient, _ := NewStorageAppliancesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewTrunkedNetworksClient creates a new instance of TrunkedNetworksClient.
func (c *ClientFactory) NewTrunkedNetworksClient() *TrunkedNetworksClient {
	subClient, _ := NewTrunkedNetworksClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualMachinesClient creates a new instance of VirtualMachinesClient.
func (c *ClientFactory) NewVirtualMachinesClient() *VirtualMachinesClient {
	subClient, _ := NewVirtualMachinesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVolumesClient creates a new instance of VolumesClient.
func (c *ClientFactory) NewVolumesClient() *VolumesClient {
	subClient, _ := NewVolumesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
