//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armnetwork

import "time"

// AADAuthenticationParameters - AAD Vpn authentication type related parameters.
type AADAuthenticationParameters struct {
	// AAD Vpn authentication parameter AAD audience.
	AADAudience *string

	// AAD Vpn authentication parameter AAD issuer.
	AADIssuer *string

	// AAD Vpn authentication parameter AAD tenant.
	AADTenant *string
}

// Action to be taken on a route matching a RouteMap criterion.
type Action struct {
	// List of parameters relevant to the action.For instance if type is drop then parameters has list of prefixes to be dropped.If
	// type is add, parameters would have list of ASN numbers to be added
	Parameters []*Parameter

	// Type of action to be taken. Supported types are 'Remove', 'Add', 'Replace', and 'Drop.'
	Type *RouteMapActionType
}

// ActiveBaseSecurityAdminRule - Network base admin rule.
type ActiveBaseSecurityAdminRule struct {
	// REQUIRED; Whether the rule is custom or default.
	Kind *EffectiveAdminRuleKind

	// Deployment time string.
	CommitTime *time.Time

	// A description of the security admin configuration.
	ConfigurationDescription *string

	// Resource ID.
	ID *string

	// Deployment region.
	Region *string

	// Groups for rule collection
	RuleCollectionAppliesToGroups []*ManagerSecurityGroupItem

	// A description of the rule collection.
	RuleCollectionDescription *string

	// Effective configuration groups.
	RuleGroups []*ConfigurationGroup
}

// GetActiveBaseSecurityAdminRule implements the ActiveBaseSecurityAdminRuleClassification interface for type ActiveBaseSecurityAdminRule.
func (a *ActiveBaseSecurityAdminRule) GetActiveBaseSecurityAdminRule() *ActiveBaseSecurityAdminRule {
	return a
}

// ActiveConfigurationParameter - Effective Virtual Networks Parameter.
type ActiveConfigurationParameter struct {
	// List of regions.
	Regions []*string

	// When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current
	// request) to retrieve the next page of data.
	SkipToken *string
}

// ActiveConnectivityConfiguration - Active connectivity configuration.
type ActiveConnectivityConfiguration struct {
	// Deployment time string.
	CommitTime *time.Time

	// Effective configuration groups.
	ConfigurationGroups []*ConfigurationGroup

	// Connectivity configuration ID.
	ID *string

	// Properties of a network manager connectivity configuration
	Properties *ConnectivityConfigurationProperties

	// Deployment region.
	Region *string
}

// ActiveConnectivityConfigurationsListResult - Result of the request to list active connectivity configurations. It contains
// a list of active connectivity configurations and a skiptoken to get the next set of results.
type ActiveConnectivityConfigurationsListResult struct {
	// When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current
	// request) to retrieve the next page of data.
	SkipToken *string

	// Gets a page of active connectivity configurations.
	Value []*ActiveConnectivityConfiguration
}

// ActiveDefaultSecurityAdminRule - Network default admin rule.
type ActiveDefaultSecurityAdminRule struct {
	// REQUIRED; Whether the rule is custom or default.
	Kind *EffectiveAdminRuleKind

	// Deployment time string.
	CommitTime *time.Time

	// A description of the security admin configuration.
	ConfigurationDescription *string

	// Resource ID.
	ID *string

	// Indicates the properties of the default security admin rule
	Properties *DefaultAdminPropertiesFormat

	// Deployment region.
	Region *string

	// Groups for rule collection
	RuleCollectionAppliesToGroups []*ManagerSecurityGroupItem

	// A description of the rule collection.
	RuleCollectionDescription *string

	// Effective configuration groups.
	RuleGroups []*ConfigurationGroup
}

// GetActiveBaseSecurityAdminRule implements the ActiveBaseSecurityAdminRuleClassification interface for type ActiveDefaultSecurityAdminRule.
func (a *ActiveDefaultSecurityAdminRule) GetActiveBaseSecurityAdminRule() *ActiveBaseSecurityAdminRule {
	return &ActiveBaseSecurityAdminRule{
		CommitTime:                    a.CommitTime,
		ConfigurationDescription:      a.ConfigurationDescription,
		ID:                            a.ID,
		Kind:                          a.Kind,
		Region:                        a.Region,
		RuleCollectionAppliesToGroups: a.RuleCollectionAppliesToGroups,
		RuleCollectionDescription:     a.RuleCollectionDescription,
		RuleGroups:                    a.RuleGroups,
	}
}

// ActiveSecurityAdminRule - Network admin rule.
type ActiveSecurityAdminRule struct {
	// REQUIRED; Whether the rule is custom or default.
	Kind *EffectiveAdminRuleKind

	// Deployment time string.
	CommitTime *time.Time

	// A description of the security admin configuration.
	ConfigurationDescription *string

	// Resource ID.
	ID *string

	// Indicates the properties of the security admin rule
	Properties *AdminPropertiesFormat

	// Deployment region.
	Region *string

	// Groups for rule collection
	RuleCollectionAppliesToGroups []*ManagerSecurityGroupItem

	// A description of the rule collection.
	RuleCollectionDescription *string

	// Effective configuration groups.
	RuleGroups []*ConfigurationGroup
}

// GetActiveBaseSecurityAdminRule implements the ActiveBaseSecurityAdminRuleClassification interface for type ActiveSecurityAdminRule.
func (a *ActiveSecurityAdminRule) GetActiveBaseSecurityAdminRule() *ActiveBaseSecurityAdminRule {
	return &ActiveBaseSecurityAdminRule{
		CommitTime:                    a.CommitTime,
		ConfigurationDescription:      a.ConfigurationDescription,
		ID:                            a.ID,
		Kind:                          a.Kind,
		Region:                        a.Region,
		RuleCollectionAppliesToGroups: a.RuleCollectionAppliesToGroups,
		RuleCollectionDescription:     a.RuleCollectionDescription,
		RuleGroups:                    a.RuleGroups,
	}
}

// ActiveSecurityAdminRulesListResult - Result of the request to list active security admin rules. It contains a list of active
// security admin rules and a skiptoken to get the next set of results.
type ActiveSecurityAdminRulesListResult struct {
	// When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current
	// request) to retrieve the next page of data.
	SkipToken *string

	// Gets a page of active security admin rules.
	Value []ActiveBaseSecurityAdminRuleClassification
}

// AddressPrefixItem - Address prefix item.
type AddressPrefixItem struct {
	// Address prefix.
	AddressPrefix *string

	// Address prefix type.
	AddressPrefixType *AddressPrefixType
}

// AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network.
type AddressSpace struct {
	// A list of address blocks reserved for this virtual network in CIDR notation.
	AddressPrefixes []*string
}

// AdminPropertiesFormat - Security admin rule resource.
type AdminPropertiesFormat struct {
	// REQUIRED; Indicates the access allowed for this particular rule
	Access *SecurityConfigurationRuleAccess

	// REQUIRED; Indicates if the traffic matched against the rule in inbound or outbound.
	Direction *SecurityConfigurationRuleDirection

	// REQUIRED; The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule
	// in the collection. The lower the priority number, the higher the priority of the rule.
	Priority *int32

	// REQUIRED; Network protocol this rule applies to.
	Protocol *SecurityConfigurationRuleProtocol

	// A description for this rule. Restricted to 140 chars.
	Description *string

	// The destination port ranges.
	DestinationPortRanges []*string

	// The destination address prefixes. CIDR or destination IP ranges.
	Destinations []*AddressPrefixItem

	// The source port ranges.
	SourcePortRanges []*string

	// The CIDR or source IP ranges.
	Sources []*AddressPrefixItem

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Unique identifier for this resource.
	ResourceGUID *string
}

// AdminRule - Network admin rule.
type AdminRule struct {
	// REQUIRED; Whether the rule is custom or default.
	Kind *AdminRuleKind

	// Indicates the properties of the security admin rule
	Properties *AdminPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// GetBaseAdminRule implements the BaseAdminRuleClassification interface for type AdminRule.
func (a *AdminRule) GetBaseAdminRule() *BaseAdminRule {
	return &BaseAdminRule{
		Etag:       a.Etag,
		ID:         a.ID,
		Kind:       a.Kind,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// AdminRuleCollection - Defines the admin rule collection.
type AdminRuleCollection struct {
	// Indicates the properties for the network manager admin rule collection.
	Properties *AdminRuleCollectionPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// AdminRuleCollectionListResult - Security admin configuration rule collection list result.
type AdminRuleCollectionListResult struct {
	// Gets the URL to get the next set of results.
	NextLink *string

	// A list of network manager security admin configuration rule collections
	Value []*AdminRuleCollection
}

// AdminRuleCollectionPropertiesFormat - Defines the admin rule collection properties.
type AdminRuleCollectionPropertiesFormat struct {
	// REQUIRED; Groups for configuration
	AppliesToGroups []*ManagerSecurityGroupItem

	// A description of the admin rule collection.
	Description *string

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Unique identifier for this resource.
	ResourceGUID *string
}

// AdminRuleListResult - security configuration admin rule list result.
type AdminRuleListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of admin rules
	Value []BaseAdminRuleClassification
}

// ApplicationGateway - Application gateway resource.
type ApplicationGateway struct {
	// Resource ID.
	ID *string

	// The identity of the application gateway, if configured.
	Identity *ManagedServiceIdentity

	// Resource location.
	Location *string

	// Properties of the application gateway.
	Properties *ApplicationGatewayPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// A list of availability zones denoting where the resource needs to come from.
	Zones []*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ApplicationGatewayAuthenticationCertificate - Authentication certificates of an application gateway.
type ApplicationGatewayAuthenticationCertificate struct {
	// Resource ID.
	ID *string

	// Name of the authentication certificate that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway authentication certificate.
	Properties *ApplicationGatewayAuthenticationCertificatePropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewayAuthenticationCertificatePropertiesFormat - Authentication certificates properties of an application
// gateway.
type ApplicationGatewayAuthenticationCertificatePropertiesFormat struct {
	// Certificate public data.
	Data *string

	// READ-ONLY; The provisioning state of the authentication certificate resource.
	ProvisioningState *ProvisioningState
}

// ApplicationGatewayAutoscaleConfiguration - Application Gateway autoscale configuration.
type ApplicationGatewayAutoscaleConfiguration struct {
	// REQUIRED; Lower bound on number of Application Gateway capacity.
	MinCapacity *int32

	// Upper bound on number of Application Gateway capacity.
	MaxCapacity *int32
}

// ApplicationGatewayAvailableSSLOptions - Response for ApplicationGatewayAvailableSslOptions API service call.
type ApplicationGatewayAvailableSSLOptions struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the application gateway available SSL options.
	Properties *ApplicationGatewayAvailableSSLOptionsPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ApplicationGatewayAvailableSSLOptionsPropertiesFormat - Properties of ApplicationGatewayAvailableSslOptions.
type ApplicationGatewayAvailableSSLOptionsPropertiesFormat struct {
	// List of available Ssl cipher suites.
	AvailableCipherSuites []*ApplicationGatewaySSLCipherSuite

	// List of available Ssl protocols.
	AvailableProtocols []*ApplicationGatewaySSLProtocol

	// Name of the Ssl predefined policy applied by default to application gateway.
	DefaultPolicy *ApplicationGatewaySSLPolicyName

	// List of available Ssl predefined policy.
	PredefinedPolicies []*SubResource
}

// ApplicationGatewayAvailableSSLPredefinedPolicies - Response for ApplicationGatewayAvailableSslOptions API service call.
type ApplicationGatewayAvailableSSLPredefinedPolicies struct {
	// URL to get the next set of results.
	NextLink *string

	// List of available Ssl predefined policy.
	Value []*ApplicationGatewaySSLPredefinedPolicy
}

// ApplicationGatewayAvailableWafRuleSetsResult - Response for ApplicationGatewayAvailableWafRuleSets API service call.
type ApplicationGatewayAvailableWafRuleSetsResult struct {
	// The list of application gateway rule sets.
	Value []*ApplicationGatewayFirewallRuleSet
}

// ApplicationGatewayBackendAddress - Backend address of an application gateway.
type ApplicationGatewayBackendAddress struct {
	// Fully qualified domain name (FQDN).
	Fqdn *string

	// IP address.
	IPAddress *string
}

// ApplicationGatewayBackendAddressPool - Backend Address Pool of an application gateway.
type ApplicationGatewayBackendAddressPool struct {
	// Resource ID.
	ID *string

	// Name of the backend address pool that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway backend address pool.
	Properties *ApplicationGatewayBackendAddressPoolPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewayBackendAddressPoolPropertiesFormat - Properties of Backend Address Pool of an application gateway.
type ApplicationGatewayBackendAddressPoolPropertiesFormat struct {
	// Backend addresses.
	BackendAddresses []*ApplicationGatewayBackendAddress

	// READ-ONLY; Collection of references to IPs defined in network interfaces.
	BackendIPConfigurations []*InterfaceIPConfiguration

	// READ-ONLY; The provisioning state of the backend address pool resource.
	ProvisioningState *ProvisioningState
}

// ApplicationGatewayBackendHTTPSettings - Backend address pool settings of an application gateway.
type ApplicationGatewayBackendHTTPSettings struct {
	// Resource ID.
	ID *string

	// Name of the backend http settings that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway backend HTTP settings.
	Properties *ApplicationGatewayBackendHTTPSettingsPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewayBackendHTTPSettingsPropertiesFormat - Properties of Backend address pool settings of an application gateway.
type ApplicationGatewayBackendHTTPSettingsPropertiesFormat struct {
	// Cookie name to use for the affinity cookie.
	AffinityCookieName *string

	// Array of references to application gateway authentication certificates.
	AuthenticationCertificates []*SubResource

	// Connection draining of the backend http settings resource.
	ConnectionDraining *ApplicationGatewayConnectionDraining

	// Cookie based affinity.
	CookieBasedAffinity *ApplicationGatewayCookieBasedAffinity

	// Host header to be sent to the backend servers.
	HostName *string

	// Path which should be used as a prefix for all HTTP requests. Null means no path will be prefixed. Default value is null.
	Path *string

	// Whether to pick host header should be picked from the host name of the backend server. Default value is false.
	PickHostNameFromBackendAddress *bool

	// The destination port on the backend.
	Port *int32

	// Probe resource of an application gateway.
	Probe *SubResource

	// Whether the probe is enabled. Default value is false.
	ProbeEnabled *bool

	// The protocol used to communicate with the backend.
	Protocol *ApplicationGatewayProtocol

	// Request timeout in seconds. Application Gateway will fail the request if response is not received within RequestTimeout.
	// Acceptable values are from 1 second to 86400 seconds.
	RequestTimeout *int32

	// Array of references to application gateway trusted root certificates.
	TrustedRootCertificates []*SubResource

	// READ-ONLY; The provisioning state of the backend HTTP settings resource.
	ProvisioningState *ProvisioningState
}

// ApplicationGatewayBackendHealth - Response for ApplicationGatewayBackendHealth API service call.
type ApplicationGatewayBackendHealth struct {
	// A list of ApplicationGatewayBackendHealthPool resources.
	BackendAddressPools []*ApplicationGatewayBackendHealthPool
}

// ApplicationGatewayBackendHealthHTTPSettings - Application gateway BackendHealthHttp settings.
type ApplicationGatewayBackendHealthHTTPSettings struct {
	// Reference to an ApplicationGatewayBackendHttpSettings resource.
	BackendHTTPSettings *ApplicationGatewayBackendHTTPSettings

	// List of ApplicationGatewayBackendHealthServer resources.
	Servers []*ApplicationGatewayBackendHealthServer
}

// ApplicationGatewayBackendHealthOnDemand - Result of on demand test probe.
type ApplicationGatewayBackendHealthOnDemand struct {
	// Reference to an ApplicationGatewayBackendAddressPool resource.
	BackendAddressPool *ApplicationGatewayBackendAddressPool

	// Application gateway BackendHealthHttp settings.
	BackendHealthHTTPSettings *ApplicationGatewayBackendHealthHTTPSettings
}

// ApplicationGatewayBackendHealthPool - Application gateway BackendHealth pool.
type ApplicationGatewayBackendHealthPool struct {
	// Reference to an ApplicationGatewayBackendAddressPool resource.
	BackendAddressPool *ApplicationGatewayBackendAddressPool

	// List of ApplicationGatewayBackendHealthHttpSettings resources.
	BackendHTTPSettingsCollection []*ApplicationGatewayBackendHealthHTTPSettings
}

// ApplicationGatewayBackendHealthServer - Application gateway backendhealth http settings.
type ApplicationGatewayBackendHealthServer struct {
	// IP address or FQDN of backend server.
	Address *string

	// Health of backend server.
	Health *ApplicationGatewayBackendHealthServerHealth

	// Health Probe Log.
	HealthProbeLog *string

	// Reference to IP configuration of backend server.
	IPConfiguration *InterfaceIPConfiguration
}

// ApplicationGatewayBackendSettings - Backend address pool settings of an application gateway.
type ApplicationGatewayBackendSettings struct {
	// Resource ID.
	ID *string

	// Name of the backend settings that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway backend settings.
	Properties *ApplicationGatewayBackendSettingsPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewayBackendSettingsPropertiesFormat - Properties of Backend address pool settings of an application gateway.
type ApplicationGatewayBackendSettingsPropertiesFormat struct {
	// Server name indication to be sent to the backend servers for Tls protocol.
	HostName *string

	// Whether to pick server name indication from the host name of the backend server for Tls protocol. Default value is false.
	PickHostNameFromBackendAddress *bool

	// The destination port on the backend.
	Port *int32

	// Probe resource of an application gateway.
	Probe *SubResource

	// The protocol used to communicate with the backend.
	Protocol *ApplicationGatewayProtocol

	// Connection timeout in seconds. Application Gateway will fail the request if response is not received within ConnectionTimeout.
	// Acceptable values are from 1 second to 86400 seconds.
	Timeout *int32

	// Array of references to application gateway trusted root certificates.
	TrustedRootCertificates []*SubResource

	// READ-ONLY; The provisioning state of the backend HTTP settings resource.
	ProvisioningState *ProvisioningState
}

// ApplicationGatewayClientAuthConfiguration - Application gateway client authentication configuration.
type ApplicationGatewayClientAuthConfiguration struct {
	// Verify client certificate issuer name on the application gateway.
	VerifyClientCertIssuerDN *bool

	// Verify client certificate revocation status.
	VerifyClientRevocation *ApplicationGatewayClientRevocationOptions
}

// ApplicationGatewayConnectionDraining - Connection draining allows open connections to a backend server to be active for
// a specified time after the backend server got removed from the configuration.
type ApplicationGatewayConnectionDraining struct {
	// REQUIRED; The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds.
	DrainTimeoutInSec *int32

	// REQUIRED; Whether connection draining is enabled or not.
	Enabled *bool
}

// ApplicationGatewayCustomError - Custom error of an application gateway.
type ApplicationGatewayCustomError struct {
	// Error page URL of the application gateway custom error.
	CustomErrorPageURL *string

	// Status code of the application gateway custom error.
	StatusCode *ApplicationGatewayCustomErrorStatusCode
}

// ApplicationGatewayFirewallDisabledRuleGroup - Allows to disable rules within a rule group or an entire rule group.
type ApplicationGatewayFirewallDisabledRuleGroup struct {
	// REQUIRED; The name of the rule group that will be disabled.
	RuleGroupName *string

	// The list of rules that will be disabled. If null, all rules of the rule group will be disabled.
	Rules []*int32
}

// ApplicationGatewayFirewallExclusion - Allow to exclude some variable satisfy the condition for the WAF check.
type ApplicationGatewayFirewallExclusion struct {
	// REQUIRED; The variable to be excluded.
	MatchVariable *string

	// REQUIRED; When matchVariable is a collection, operator used to specify which elements in the collection this exclusion
	// applies to.
	Selector *string

	// REQUIRED; When matchVariable is a collection, operate on the selector to specify which elements in the collection this
	// exclusion applies to.
	SelectorMatchOperator *string
}

// ApplicationGatewayFirewallManifestRuleSet - Properties of the web application firewall rule set.
type ApplicationGatewayFirewallManifestRuleSet struct {
	// REQUIRED; The rule groups of the web application firewall rule set.
	RuleGroups []*ApplicationGatewayFirewallRuleGroup

	// REQUIRED; The type of the web application firewall rule set.
	RuleSetType *string

	// REQUIRED; The version of the web application firewall rule set type.
	RuleSetVersion *string

	// The rule set status
	Status *ApplicationGatewayRuleSetStatusOptions

	// Tier of an application gateway that support the rule set.
	Tiers []*ApplicationGatewayTierTypes
}

// ApplicationGatewayFirewallRule - A web application firewall rule.
type ApplicationGatewayFirewallRule struct {
	// REQUIRED; The identifier of the web application firewall rule.
	RuleID *int32

	// The string representation of the web application firewall rule action.
	Action *ApplicationGatewayWafRuleActionTypes

	// The description of the web application firewall rule.
	Description *string

	// The string representation of the web application firewall rule identifier.
	RuleIDString *string

	// The string representation of the web application firewall rule state.
	State *ApplicationGatewayWafRuleStateTypes
}

// ApplicationGatewayFirewallRuleGroup - A web application firewall rule group.
type ApplicationGatewayFirewallRuleGroup struct {
	// REQUIRED; The name of the web application firewall rule group.
	RuleGroupName *string

	// REQUIRED; The rules of the web application firewall rule group.
	Rules []*ApplicationGatewayFirewallRule

	// The description of the web application firewall rule group.
	Description *string
}

// ApplicationGatewayFirewallRuleSet - A web application firewall rule set.
type ApplicationGatewayFirewallRuleSet struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the application gateway firewall rule set.
	Properties *ApplicationGatewayFirewallRuleSetPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ApplicationGatewayFirewallRuleSetPropertiesFormat - Properties of the web application firewall rule set.
type ApplicationGatewayFirewallRuleSetPropertiesFormat struct {
	// REQUIRED; The rule groups of the web application firewall rule set.
	RuleGroups []*ApplicationGatewayFirewallRuleGroup

	// REQUIRED; The type of the web application firewall rule set.
	RuleSetType *string

	// REQUIRED; The version of the web application firewall rule set type.
	RuleSetVersion *string

	// Tier of an application gateway that support the rule set.
	Tiers []*ApplicationGatewayTierTypes

	// READ-ONLY; The provisioning state of the web application firewall rule set.
	ProvisioningState *ProvisioningState
}

// ApplicationGatewayFrontendIPConfiguration - Frontend IP configuration of an application gateway.
type ApplicationGatewayFrontendIPConfiguration struct {
	// Resource ID.
	ID *string

	// Name of the frontend IP configuration that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway frontend IP configuration.
	Properties *ApplicationGatewayFrontendIPConfigurationPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewayFrontendIPConfigurationPropertiesFormat - Properties of Frontend IP configuration of an application gateway.
type ApplicationGatewayFrontendIPConfigurationPropertiesFormat struct {
	// PrivateIPAddress of the network interface IP Configuration.
	PrivateIPAddress *string

	// The private IP address allocation method.
	PrivateIPAllocationMethod *IPAllocationMethod

	// Reference to the application gateway private link configuration.
	PrivateLinkConfiguration *SubResource

	// Reference to the PublicIP resource.
	PublicIPAddress *SubResource

	// Reference to the subnet resource.
	Subnet *SubResource

	// READ-ONLY; The provisioning state of the frontend IP configuration resource.
	ProvisioningState *ProvisioningState
}

// ApplicationGatewayFrontendPort - Frontend port of an application gateway.
type ApplicationGatewayFrontendPort struct {
	// Resource ID.
	ID *string

	// Name of the frontend port that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway frontend port.
	Properties *ApplicationGatewayFrontendPortPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewayFrontendPortPropertiesFormat - Properties of Frontend port of an application gateway.
type ApplicationGatewayFrontendPortPropertiesFormat struct {
	// Frontend port.
	Port *int32

	// READ-ONLY; The provisioning state of the frontend port resource.
	ProvisioningState *ProvisioningState
}

// ApplicationGatewayGlobalConfiguration - Application Gateway global configuration.
type ApplicationGatewayGlobalConfiguration struct {
	// Enable request buffering.
	EnableRequestBuffering *bool

	// Enable response buffering.
	EnableResponseBuffering *bool
}

// ApplicationGatewayHTTPListener - Http listener of an application gateway.
type ApplicationGatewayHTTPListener struct {
	// Resource ID.
	ID *string

	// Name of the HTTP listener that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway HTTP listener.
	Properties *ApplicationGatewayHTTPListenerPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewayHTTPListenerPropertiesFormat - Properties of HTTP listener of an application gateway.
type ApplicationGatewayHTTPListenerPropertiesFormat struct {
	// Custom error configurations of the HTTP listener.
	CustomErrorConfigurations []*ApplicationGatewayCustomError

	// Reference to the FirewallPolicy resource.
	FirewallPolicy *SubResource

	// Frontend IP configuration resource of an application gateway.
	FrontendIPConfiguration *SubResource

	// Frontend port resource of an application gateway.
	FrontendPort *SubResource

	// Host name of HTTP listener.
	HostName *string

	// List of Host names for HTTP Listener that allows special wildcard characters as well.
	HostNames []*string

	// Protocol of the HTTP listener.
	Protocol *ApplicationGatewayProtocol

	// Applicable only if protocol is https. Enables SNI for multi-hosting.
	RequireServerNameIndication *bool

	// SSL certificate resource of an application gateway.
	SSLCertificate *SubResource

	// SSL profile resource of the application gateway.
	SSLProfile *SubResource

	// READ-ONLY; The provisioning state of the HTTP listener resource.
	ProvisioningState *ProvisioningState
}

// ApplicationGatewayHeaderConfiguration - Header configuration of the Actions set in Application Gateway.
type ApplicationGatewayHeaderConfiguration struct {
	// Header name of the header configuration.
	HeaderName *string

	// Header value of the header configuration.
	HeaderValue *string
}

// ApplicationGatewayIPConfiguration - IP configuration of an application gateway. Currently 1 public and 1 private IP configuration
// is allowed.
type ApplicationGatewayIPConfiguration struct {
	// Resource ID.
	ID *string

	// Name of the IP configuration that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway IP configuration.
	Properties *ApplicationGatewayIPConfigurationPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewayIPConfigurationPropertiesFormat - Properties of IP configuration of an application gateway.
type ApplicationGatewayIPConfigurationPropertiesFormat struct {
	// Reference to the subnet resource. A subnet from where application gateway gets its private address.
	Subnet *SubResource

	// READ-ONLY; The provisioning state of the application gateway IP configuration resource.
	ProvisioningState *ProvisioningState
}

// ApplicationGatewayListResult - Response for ListApplicationGateways API service call.
type ApplicationGatewayListResult struct {
	// URL to get the next set of results.
	NextLink *string

	// List of an application gateways in a resource group.
	Value []*ApplicationGateway
}

// ApplicationGatewayListener - Listener of an application gateway.
type ApplicationGatewayListener struct {
	// Resource ID.
	ID *string

	// Name of the listener that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway listener.
	Properties *ApplicationGatewayListenerPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewayListenerPropertiesFormat - Properties of listener of an application gateway.
type ApplicationGatewayListenerPropertiesFormat struct {
	// Frontend IP configuration resource of an application gateway.
	FrontendIPConfiguration *SubResource

	// Frontend port resource of an application gateway.
	FrontendPort *SubResource

	// List of Server Name Indications(SNI) for TLS Multi-site Listener that allows special wildcard characters as well.
	HostNames []*string

	// Protocol of the listener.
	Protocol *ApplicationGatewayProtocol

	// SSL certificate resource of an application gateway.
	SSLCertificate *SubResource

	// SSL profile resource of the application gateway.
	SSLProfile *SubResource

	// READ-ONLY; The provisioning state of the listener resource.
	ProvisioningState *ProvisioningState
}

// ApplicationGatewayLoadDistributionPolicy - Load Distribution Policy of an application gateway.
type ApplicationGatewayLoadDistributionPolicy struct {
	// Resource ID.
	ID *string

	// Name of the load distribution policy that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway load distribution policy.
	Properties *ApplicationGatewayLoadDistributionPolicyPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewayLoadDistributionPolicyPropertiesFormat - Properties of Load Distribution Policy of an application gateway.
type ApplicationGatewayLoadDistributionPolicyPropertiesFormat struct {
	// Load Distribution Targets resource of an application gateway.
	LoadDistributionAlgorithm *ApplicationGatewayLoadDistributionAlgorithm

	// Load Distribution Targets resource of an application gateway.
	LoadDistributionTargets []*ApplicationGatewayLoadDistributionTarget

	// READ-ONLY; The provisioning state of the Load Distribution Policy resource.
	ProvisioningState *ProvisioningState
}

// ApplicationGatewayLoadDistributionTarget - Load Distribution Target of an application gateway.
type ApplicationGatewayLoadDistributionTarget struct {
	// Resource ID.
	ID *string

	// Name of the load distribution policy that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway load distribution target.
	Properties *ApplicationGatewayLoadDistributionTargetPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

type ApplicationGatewayLoadDistributionTargetPropertiesFormat struct {
	// Backend address pool resource of the application gateway.
	BackendAddressPool *SubResource

	// Weight per server. Range between 1 and 100.
	WeightPerServer *int32
}

// ApplicationGatewayOnDemandProbe - Details of on demand test probe request.
type ApplicationGatewayOnDemandProbe struct {
	// Reference to backend pool of application gateway to which probe request will be sent.
	BackendAddressPool *SubResource

	// Reference to backend http setting of application gateway to be used for test probe.
	BackendHTTPSettings *SubResource

	// Host name to send the probe to.
	Host *string

	// Criterion for classifying a healthy probe response.
	Match *ApplicationGatewayProbeHealthResponseMatch

	// Relative path of probe. Valid path starts from '/'. Probe is sent to ://:.
	Path *string

	// Whether the host header should be picked from the backend http settings. Default value is false.
	PickHostNameFromBackendHTTPSettings *bool

	// The protocol used for the probe.
	Protocol *ApplicationGatewayProtocol

	// The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable
	// values are from 1 second to 86400 seconds.
	Timeout *int32
}

// ApplicationGatewayPathRule - Path rule of URL path map of an application gateway.
type ApplicationGatewayPathRule struct {
	// Resource ID.
	ID *string

	// Name of the path rule that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway path rule.
	Properties *ApplicationGatewayPathRulePropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewayPathRulePropertiesFormat - Properties of path rule of an application gateway.
type ApplicationGatewayPathRulePropertiesFormat struct {
	// Backend address pool resource of URL path map path rule.
	BackendAddressPool *SubResource

	// Backend http settings resource of URL path map path rule.
	BackendHTTPSettings *SubResource

	// Reference to the FirewallPolicy resource.
	FirewallPolicy *SubResource

	// Load Distribution Policy resource of URL path map path rule.
	LoadDistributionPolicy *SubResource

	// Path rules of URL path map.
	Paths []*string

	// Redirect configuration resource of URL path map path rule.
	RedirectConfiguration *SubResource

	// Rewrite rule set resource of URL path map path rule.
	RewriteRuleSet *SubResource

	// READ-ONLY; The provisioning state of the path rule resource.
	ProvisioningState *ProvisioningState
}

// ApplicationGatewayPrivateEndpointConnection - Private Endpoint connection on an application gateway.
type ApplicationGatewayPrivateEndpointConnection struct {
	// Resource ID.
	ID *string

	// Name of the private endpoint connection on an application gateway.
	Name *string

	// Properties of the application gateway private endpoint connection.
	Properties *ApplicationGatewayPrivateEndpointConnectionProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewayPrivateEndpointConnectionListResult - Response for ListApplicationGatewayPrivateEndpointConnection API
// service call. Gets all private endpoint connections for an application gateway.
type ApplicationGatewayPrivateEndpointConnectionListResult struct {
	// URL to get the next set of results.
	NextLink *string

	// List of private endpoint connections on an application gateway.
	Value []*ApplicationGatewayPrivateEndpointConnection
}

// ApplicationGatewayPrivateEndpointConnectionProperties - Properties of Private Link Resource of an application gateway.
type ApplicationGatewayPrivateEndpointConnectionProperties struct {
	// A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// READ-ONLY; The consumer link id.
	LinkIdentifier *string

	// READ-ONLY; The resource of private end point.
	PrivateEndpoint *PrivateEndpoint

	// READ-ONLY; The provisioning state of the application gateway private endpoint connection resource.
	ProvisioningState *ProvisioningState
}

// ApplicationGatewayPrivateLinkConfiguration - Private Link Configuration on an application gateway.
type ApplicationGatewayPrivateLinkConfiguration struct {
	// Resource ID.
	ID *string

	// Name of the private link configuration that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway private link configuration.
	Properties *ApplicationGatewayPrivateLinkConfigurationProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewayPrivateLinkConfigurationProperties - Properties of private link configuration on an application gateway.
type ApplicationGatewayPrivateLinkConfigurationProperties struct {
	// An array of application gateway private link ip configurations.
	IPConfigurations []*ApplicationGatewayPrivateLinkIPConfiguration

	// READ-ONLY; The provisioning state of the application gateway private link configuration.
	ProvisioningState *ProvisioningState
}

// ApplicationGatewayPrivateLinkIPConfiguration - The application gateway private link ip configuration.
type ApplicationGatewayPrivateLinkIPConfiguration struct {
	// Resource ID.
	ID *string

	// The name of application gateway private link ip configuration.
	Name *string

	// Properties of an application gateway private link ip configuration.
	Properties *ApplicationGatewayPrivateLinkIPConfigurationProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; The resource type.
	Type *string
}

// ApplicationGatewayPrivateLinkIPConfigurationProperties - Properties of an application gateway private link IP configuration.
type ApplicationGatewayPrivateLinkIPConfigurationProperties struct {
	// Whether the ip configuration is primary or not.
	Primary *bool

	// The private IP address of the IP configuration.
	PrivateIPAddress *string

	// The private IP address allocation method.
	PrivateIPAllocationMethod *IPAllocationMethod

	// Reference to the subnet resource.
	Subnet *SubResource

	// READ-ONLY; The provisioning state of the application gateway private link IP configuration.
	ProvisioningState *ProvisioningState
}

// ApplicationGatewayPrivateLinkResource - PrivateLink Resource of an application gateway.
type ApplicationGatewayPrivateLinkResource struct {
	// Resource ID.
	ID *string

	// Name of the private link resource that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway private link resource.
	Properties *ApplicationGatewayPrivateLinkResourceProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewayPrivateLinkResourceListResult - Response for ListApplicationGatewayPrivateLinkResources API service call.
// Gets all private link resources for an application gateway.
type ApplicationGatewayPrivateLinkResourceListResult struct {
	// URL to get the next set of results.
	NextLink *string

	// List of private link resources of an application gateway.
	Value []*ApplicationGatewayPrivateLinkResource
}

// ApplicationGatewayPrivateLinkResourceProperties - Properties of a private link resource.
type ApplicationGatewayPrivateLinkResourceProperties struct {
	// Required DNS zone names of the the private link resource.
	RequiredZoneNames []*string

	// READ-ONLY; Group identifier of private link resource.
	GroupID *string

	// READ-ONLY; Required member names of private link resource.
	RequiredMembers []*string
}

// ApplicationGatewayProbe - Probe of the application gateway.
type ApplicationGatewayProbe struct {
	// Resource ID.
	ID *string

	// Name of the probe that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway probe.
	Properties *ApplicationGatewayProbePropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewayProbeHealthResponseMatch - Application gateway probe health response match.
type ApplicationGatewayProbeHealthResponseMatch struct {
	// Body that must be contained in the health response. Default value is empty.
	Body *string

	// Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.
	StatusCodes []*string
}

// ApplicationGatewayProbePropertiesFormat - Properties of probe of an application gateway.
type ApplicationGatewayProbePropertiesFormat struct {
	// Host name to send the probe to.
	Host *string

	// The probing interval in seconds. This is the time interval between two consecutive probes. Acceptable values are from 1
	// second to 86400 seconds.
	Interval *int32

	// Criterion for classifying a healthy probe response.
	Match *ApplicationGatewayProbeHealthResponseMatch

	// Minimum number of servers that are always marked healthy. Default value is 0.
	MinServers *int32

	// Relative path of probe. Valid path starts from '/'. Probe is sent to ://:.
	Path *string

	// Whether the host header should be picked from the backend http settings. Default value is false.
	PickHostNameFromBackendHTTPSettings *bool

	// Whether the server name indication should be picked from the backend settings for Tls protocol. Default value is false.
	PickHostNameFromBackendSettings *bool

	// Custom port which will be used for probing the backend servers. The valid value ranges from 1 to 65535. In case not set,
	// port from http settings will be used. This property is valid for Basic,
	// Standardv2 and WAFv2 only.
	Port *int32

	// The protocol used for the probe.
	Protocol *ApplicationGatewayProtocol

	// The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable
	// values are from 1 second to 86400 seconds.
	Timeout *int32

	// The probe retry count. Backend server is marked down after consecutive probe failure count reaches UnhealthyThreshold.
	// Acceptable values are from 1 second to 20.
	UnhealthyThreshold *int32

	// READ-ONLY; The provisioning state of the probe resource.
	ProvisioningState *ProvisioningState
}

// ApplicationGatewayPropertiesFormat - Properties of the application gateway.
type ApplicationGatewayPropertiesFormat struct {
	// Authentication certificates of the application gateway resource. For default limits, see Application Gateway limits
	// [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	AuthenticationCertificates []*ApplicationGatewayAuthenticationCertificate

	// Autoscale Configuration.
	AutoscaleConfiguration *ApplicationGatewayAutoscaleConfiguration

	// Backend address pool of the application gateway resource. For default limits, see Application Gateway limits
	// [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	BackendAddressPools []*ApplicationGatewayBackendAddressPool

	// Backend http settings of the application gateway resource. For default limits, see Application Gateway limits
	// [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	BackendHTTPSettingsCollection []*ApplicationGatewayBackendHTTPSettings

	// Backend settings of the application gateway resource. For default limits, see Application Gateway limits [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits]
	// .
	BackendSettingsCollection []*ApplicationGatewayBackendSettings

	// Custom error configurations of the application gateway resource.
	CustomErrorConfigurations []*ApplicationGatewayCustomError

	// Whether FIPS is enabled on the application gateway resource.
	EnableFips *bool

	// Whether HTTP2 is enabled on the application gateway resource.
	EnableHTTP2 *bool

	// Reference to the FirewallPolicy resource.
	FirewallPolicy *SubResource

	// If true, associates a firewall policy with an application gateway regardless whether the policy differs from the WAF Config.
	ForceFirewallPolicyAssociation *bool

	// Frontend IP addresses of the application gateway resource. For default limits, see Application Gateway limits
	// [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	FrontendIPConfigurations []*ApplicationGatewayFrontendIPConfiguration

	// Frontend ports of the application gateway resource. For default limits, see Application Gateway limits [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	FrontendPorts []*ApplicationGatewayFrontendPort

	// Subnets of the application gateway resource. For default limits, see Application Gateway limits [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	GatewayIPConfigurations []*ApplicationGatewayIPConfiguration

	// Global Configuration.
	GlobalConfiguration *ApplicationGatewayGlobalConfiguration

	// Http listeners of the application gateway resource. For default limits, see Application Gateway limits [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	HTTPListeners []*ApplicationGatewayHTTPListener

	// Listeners of the application gateway resource. For default limits, see Application Gateway limits [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	Listeners []*ApplicationGatewayListener

	// Load distribution policies of the application gateway resource.
	LoadDistributionPolicies []*ApplicationGatewayLoadDistributionPolicy

	// PrivateLink configurations on application gateway.
	PrivateLinkConfigurations []*ApplicationGatewayPrivateLinkConfiguration

	// Probes of the application gateway resource.
	Probes []*ApplicationGatewayProbe

	// Redirect configurations of the application gateway resource. For default limits, see Application Gateway limits
	// [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	RedirectConfigurations []*ApplicationGatewayRedirectConfiguration

	// Request routing rules of the application gateway resource.
	RequestRoutingRules []*ApplicationGatewayRequestRoutingRule

	// Rewrite rules for the application gateway resource.
	RewriteRuleSets []*ApplicationGatewayRewriteRuleSet

	// Routing rules of the application gateway resource.
	RoutingRules []*ApplicationGatewayRoutingRule

	// SKU of the application gateway resource.
	SKU *ApplicationGatewaySKU

	// SSL certificates of the application gateway resource. For default limits, see Application Gateway limits [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits]
	// .
	SSLCertificates []*ApplicationGatewaySSLCertificate

	// SSL policy of the application gateway resource.
	SSLPolicy *ApplicationGatewaySSLPolicy

	// SSL profiles of the application gateway resource. For default limits, see Application Gateway limits [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	SSLProfiles []*ApplicationGatewaySSLProfile

	// Trusted client certificates of the application gateway resource. For default limits, see Application Gateway limits
	// [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	TrustedClientCertificates []*ApplicationGatewayTrustedClientCertificate

	// Trusted Root certificates of the application gateway resource. For default limits, see Application Gateway limits
	// [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	TrustedRootCertificates []*ApplicationGatewayTrustedRootCertificate

	// URL path map of the application gateway resource. For default limits, see Application Gateway limits [https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits].
	URLPathMaps []*ApplicationGatewayURLPathMap

	// Web application firewall configuration.
	WebApplicationFirewallConfiguration *ApplicationGatewayWebApplicationFirewallConfiguration

	// READ-ONLY; The default predefined SSL Policy applied on the application gateway resource.
	DefaultPredefinedSSLPolicy *ApplicationGatewaySSLPolicyName

	// READ-ONLY; Operational state of the application gateway resource.
	OperationalState *ApplicationGatewayOperationalState

	// READ-ONLY; Private Endpoint connections on application gateway.
	PrivateEndpointConnections []*ApplicationGatewayPrivateEndpointConnection

	// READ-ONLY; The provisioning state of the application gateway resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource GUID property of the application gateway resource.
	ResourceGUID *string
}

// ApplicationGatewayRedirectConfiguration - Redirect configuration of an application gateway.
type ApplicationGatewayRedirectConfiguration struct {
	// Resource ID.
	ID *string

	// Name of the redirect configuration that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway redirect configuration.
	Properties *ApplicationGatewayRedirectConfigurationPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewayRedirectConfigurationPropertiesFormat - Properties of redirect configuration of the application gateway.
type ApplicationGatewayRedirectConfigurationPropertiesFormat struct {
	// Include path in the redirected url.
	IncludePath *bool

	// Include query string in the redirected url.
	IncludeQueryString *bool

	// Path rules specifying redirect configuration.
	PathRules []*SubResource

	// HTTP redirection type.
	RedirectType *ApplicationGatewayRedirectType

	// Request routing specifying redirect configuration.
	RequestRoutingRules []*SubResource

	// Reference to a listener to redirect the request to.
	TargetListener *SubResource

	// Url to redirect the request to.
	TargetURL *string

	// Url path maps specifying default redirect configuration.
	URLPathMaps []*SubResource
}

// ApplicationGatewayRequestRoutingRule - Request routing rule of an application gateway.
type ApplicationGatewayRequestRoutingRule struct {
	// Resource ID.
	ID *string

	// Name of the request routing rule that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway request routing rule.
	Properties *ApplicationGatewayRequestRoutingRulePropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewayRequestRoutingRulePropertiesFormat - Properties of request routing rule of the application gateway.
type ApplicationGatewayRequestRoutingRulePropertiesFormat struct {
	// Backend address pool resource of the application gateway.
	BackendAddressPool *SubResource

	// Backend http settings resource of the application gateway.
	BackendHTTPSettings *SubResource

	// Http listener resource of the application gateway.
	HTTPListener *SubResource

	// Load Distribution Policy resource of the application gateway.
	LoadDistributionPolicy *SubResource

	// Priority of the request routing rule.
	Priority *int32

	// Redirect configuration resource of the application gateway.
	RedirectConfiguration *SubResource

	// Rewrite Rule Set resource in Basic rule of the application gateway.
	RewriteRuleSet *SubResource

	// Rule type.
	RuleType *ApplicationGatewayRequestRoutingRuleType

	// URL path map resource of the application gateway.
	URLPathMap *SubResource

	// READ-ONLY; The provisioning state of the request routing rule resource.
	ProvisioningState *ProvisioningState
}

// ApplicationGatewayRewriteRule - Rewrite rule of an application gateway.
type ApplicationGatewayRewriteRule struct {
	// Set of actions to be done as part of the rewrite Rule.
	ActionSet *ApplicationGatewayRewriteRuleActionSet

	// Conditions based on which the action set execution will be evaluated.
	Conditions []*ApplicationGatewayRewriteRuleCondition

	// Name of the rewrite rule that is unique within an Application Gateway.
	Name *string

	// Rule Sequence of the rewrite rule that determines the order of execution of a particular rule in a RewriteRuleSet.
	RuleSequence *int32
}

// ApplicationGatewayRewriteRuleActionSet - Set of actions in the Rewrite Rule in Application Gateway.
type ApplicationGatewayRewriteRuleActionSet struct {
	// Request Header Actions in the Action Set.
	RequestHeaderConfigurations []*ApplicationGatewayHeaderConfiguration

	// Response Header Actions in the Action Set.
	ResponseHeaderConfigurations []*ApplicationGatewayHeaderConfiguration

	// Url Configuration Action in the Action Set.
	URLConfiguration *ApplicationGatewayURLConfiguration
}

// ApplicationGatewayRewriteRuleCondition - Set of conditions in the Rewrite Rule in Application Gateway.
type ApplicationGatewayRewriteRuleCondition struct {
	// Setting this parameter to truth value with force the pattern to do a case in-sensitive comparison.
	IgnoreCase *bool

	// Setting this value as truth will force to check the negation of the condition given by the user.
	Negate *bool

	// The pattern, either fixed string or regular expression, that evaluates the truthfulness of the condition.
	Pattern *string

	// The condition parameter of the RewriteRuleCondition.
	Variable *string
}

// ApplicationGatewayRewriteRuleSet - Rewrite rule set of an application gateway.
type ApplicationGatewayRewriteRuleSet struct {
	// Resource ID.
	ID *string

	// Name of the rewrite rule set that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway rewrite rule set.
	Properties *ApplicationGatewayRewriteRuleSetPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// ApplicationGatewayRewriteRuleSetPropertiesFormat - Properties of rewrite rule set of the application gateway.
type ApplicationGatewayRewriteRuleSetPropertiesFormat struct {
	// Rewrite rules in the rewrite rule set.
	RewriteRules []*ApplicationGatewayRewriteRule

	// READ-ONLY; The provisioning state of the rewrite rule set resource.
	ProvisioningState *ProvisioningState
}

// ApplicationGatewayRoutingRule - Routing rule of an application gateway.
type ApplicationGatewayRoutingRule struct {
	// Resource ID.
	ID *string

	// Name of the routing rule that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway routing rule.
	Properties *ApplicationGatewayRoutingRulePropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewayRoutingRulePropertiesFormat - Properties of routing rule of the application gateway.
type ApplicationGatewayRoutingRulePropertiesFormat struct {
	// REQUIRED; Priority of the routing rule.
	Priority *int32

	// Backend address pool resource of the application gateway.
	BackendAddressPool *SubResource

	// Backend settings resource of the application gateway.
	BackendSettings *SubResource

	// Listener resource of the application gateway.
	Listener *SubResource

	// Rule type.
	RuleType *ApplicationGatewayRequestRoutingRuleType

	// READ-ONLY; The provisioning state of the request routing rule resource.
	ProvisioningState *ProvisioningState
}

// ApplicationGatewaySKU - SKU of an application gateway.
type ApplicationGatewaySKU struct {
	// Capacity (instance count) of an application gateway.
	Capacity *int32

	// Name of an application gateway SKU.
	Name *ApplicationGatewaySKUName

	// Tier of an application gateway.
	Tier *ApplicationGatewayTier
}

// ApplicationGatewaySSLCertificate - SSL certificates of an application gateway.
type ApplicationGatewaySSLCertificate struct {
	// Resource ID.
	ID *string

	// Name of the SSL certificate that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway SSL certificate.
	Properties *ApplicationGatewaySSLCertificatePropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewaySSLCertificatePropertiesFormat - Properties of SSL certificates of an application gateway.
type ApplicationGatewaySSLCertificatePropertiesFormat struct {
	// Base-64 encoded pfx certificate. Only applicable in PUT Request.
	Data *string

	// Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
	KeyVaultSecretID *string

	// Password for the pfx file specified in data. Only applicable in PUT request.
	Password *string

	// READ-ONLY; The provisioning state of the SSL certificate resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Base-64 encoded Public cert data corresponding to pfx specified in data. Only applicable in GET request.
	PublicCertData *string
}

// ApplicationGatewaySSLPolicy - Application Gateway Ssl policy.
type ApplicationGatewaySSLPolicy struct {
	// Ssl cipher suites to be enabled in the specified order to application gateway.
	CipherSuites []*ApplicationGatewaySSLCipherSuite

	// Ssl protocols to be disabled on application gateway.
	DisabledSSLProtocols []*ApplicationGatewaySSLProtocol

	// Minimum version of Ssl protocol to be supported on application gateway.
	MinProtocolVersion *ApplicationGatewaySSLProtocol

	// Name of Ssl predefined policy.
	PolicyName *ApplicationGatewaySSLPolicyName

	// Type of Ssl Policy.
	PolicyType *ApplicationGatewaySSLPolicyType
}

// ApplicationGatewaySSLPredefinedPolicy - An Ssl predefined policy.
type ApplicationGatewaySSLPredefinedPolicy struct {
	// Resource ID.
	ID *string

	// Name of the Ssl predefined policy.
	Name *string

	// Properties of the application gateway SSL predefined policy.
	Properties *ApplicationGatewaySSLPredefinedPolicyPropertiesFormat
}

// ApplicationGatewaySSLPredefinedPolicyPropertiesFormat - Properties of ApplicationGatewaySslPredefinedPolicy.
type ApplicationGatewaySSLPredefinedPolicyPropertiesFormat struct {
	// Ssl cipher suites to be enabled in the specified order for application gateway.
	CipherSuites []*ApplicationGatewaySSLCipherSuite

	// Minimum version of Ssl protocol to be supported on application gateway.
	MinProtocolVersion *ApplicationGatewaySSLProtocol
}

// ApplicationGatewaySSLProfile - SSL profile of an application gateway.
type ApplicationGatewaySSLProfile struct {
	// Resource ID.
	ID *string

	// Name of the SSL profile that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway SSL profile.
	Properties *ApplicationGatewaySSLProfilePropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewaySSLProfilePropertiesFormat - Properties of SSL profile of an application gateway.
type ApplicationGatewaySSLProfilePropertiesFormat struct {
	// Client authentication configuration of the application gateway resource.
	ClientAuthConfiguration *ApplicationGatewayClientAuthConfiguration

	// SSL policy of the application gateway resource.
	SSLPolicy *ApplicationGatewaySSLPolicy

	// Array of references to application gateway trusted client certificates.
	TrustedClientCertificates []*SubResource

	// READ-ONLY; The provisioning state of the HTTP listener resource.
	ProvisioningState *ProvisioningState
}

// ApplicationGatewayTrustedClientCertificate - Trusted client certificates of an application gateway.
type ApplicationGatewayTrustedClientCertificate struct {
	// Resource ID.
	ID *string

	// Name of the trusted client certificate that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway trusted client certificate.
	Properties *ApplicationGatewayTrustedClientCertificatePropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewayTrustedClientCertificatePropertiesFormat - Trusted client certificates properties of an application gateway.
type ApplicationGatewayTrustedClientCertificatePropertiesFormat struct {
	// Certificate public data.
	Data *string

	// READ-ONLY; Distinguished name of client certificate issuer.
	ClientCertIssuerDN *string

	// READ-ONLY; The provisioning state of the trusted client certificate resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Validated certificate data.
	ValidatedCertData *string
}

// ApplicationGatewayTrustedRootCertificate - Trusted Root certificates of an application gateway.
type ApplicationGatewayTrustedRootCertificate struct {
	// Resource ID.
	ID *string

	// Name of the trusted root certificate that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway trusted root certificate.
	Properties *ApplicationGatewayTrustedRootCertificatePropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewayTrustedRootCertificatePropertiesFormat - Trusted Root certificates properties of an application gateway.
type ApplicationGatewayTrustedRootCertificatePropertiesFormat struct {
	// Certificate public data.
	Data *string

	// Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
	KeyVaultSecretID *string

	// READ-ONLY; The provisioning state of the trusted root certificate resource.
	ProvisioningState *ProvisioningState
}

// ApplicationGatewayURLConfiguration - Url configuration of the Actions set in Application Gateway.
type ApplicationGatewayURLConfiguration struct {
	// Url path which user has provided for url rewrite. Null means no path will be updated. Default value is null.
	ModifiedPath *string

	// Query string which user has provided for url rewrite. Null means no query string will be updated. Default value is null.
	ModifiedQueryString *string

	// If set as true, it will re-evaluate the url path map provided in path based request routing rules using modified path.
	// Default value is false.
	Reroute *bool
}

// ApplicationGatewayURLPathMap - UrlPathMaps give a url path to the backend mapping information for PathBasedRouting.
type ApplicationGatewayURLPathMap struct {
	// Resource ID.
	ID *string

	// Name of the URL path map that is unique within an Application Gateway.
	Name *string

	// Properties of the application gateway URL path map.
	Properties *ApplicationGatewayURLPathMapPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ApplicationGatewayURLPathMapPropertiesFormat - Properties of UrlPathMap of the application gateway.
type ApplicationGatewayURLPathMapPropertiesFormat struct {
	// Default backend address pool resource of URL path map.
	DefaultBackendAddressPool *SubResource

	// Default backend http settings resource of URL path map.
	DefaultBackendHTTPSettings *SubResource

	// Default Load Distribution Policy resource of URL path map.
	DefaultLoadDistributionPolicy *SubResource

	// Default redirect configuration resource of URL path map.
	DefaultRedirectConfiguration *SubResource

	// Default Rewrite rule set resource of URL path map.
	DefaultRewriteRuleSet *SubResource

	// Path rule of URL path map resource.
	PathRules []*ApplicationGatewayPathRule

	// READ-ONLY; The provisioning state of the URL path map resource.
	ProvisioningState *ProvisioningState
}

// ApplicationGatewayWafDynamicManifestPropertiesResult - Properties of ApplicationGatewayWafDynamicManifest.
type ApplicationGatewayWafDynamicManifestPropertiesResult struct {
	// The available rulesets.
	AvailableRuleSets []*ApplicationGatewayFirewallManifestRuleSet

	// The default ruleset.
	DefaultRuleSet *DefaultRuleSetPropertyFormat
}

// ApplicationGatewayWafDynamicManifestResult - Response for ApplicationGatewayWafDynamicManifest API service call.
type ApplicationGatewayWafDynamicManifestResult struct {
	// Resource ID.
	ID *string

	// Properties of the ApplicationGatewayWafDynamicManifest .
	Properties *ApplicationGatewayWafDynamicManifestPropertiesResult

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ApplicationGatewayWafDynamicManifestResultList - Response for ApplicationGatewayWafDynamicManifests API service call.
type ApplicationGatewayWafDynamicManifestResultList struct {
	// URL to get the next set of results.
	NextLink *string

	// The list of application gateway waf manifest.
	Value []*ApplicationGatewayWafDynamicManifestResult
}

// ApplicationGatewayWebApplicationFirewallConfiguration - Application gateway web application firewall configuration.
type ApplicationGatewayWebApplicationFirewallConfiguration struct {
	// REQUIRED; Whether the web application firewall is enabled or not.
	Enabled *bool

	// REQUIRED; Web application firewall mode.
	FirewallMode *ApplicationGatewayFirewallMode

	// REQUIRED; The type of the web application firewall rule set. Possible values are: 'OWASP'.
	RuleSetType *string

	// REQUIRED; The version of the rule set type.
	RuleSetVersion *string

	// The disabled rule groups.
	DisabledRuleGroups []*ApplicationGatewayFirewallDisabledRuleGroup

	// The exclusion list.
	Exclusions []*ApplicationGatewayFirewallExclusion

	// Maximum file upload size in Mb for WAF.
	FileUploadLimitInMb *int32

	// Maximum request body size for WAF.
	MaxRequestBodySize *int32

	// Maximum request body size in Kb for WAF.
	MaxRequestBodySizeInKb *int32

	// Whether allow WAF to check request Body.
	RequestBodyCheck *bool
}

// ApplicationRule - Rule of type application.
type ApplicationRule struct {
	// REQUIRED; Rule Type.
	RuleType *FirewallPolicyRuleType

	// Description of the rule.
	Description *string

	// List of destination IP addresses or Service Tags.
	DestinationAddresses []*string

	// List of FQDN Tags for this rule.
	FqdnTags []*string

	// List of HTTP/S headers to insert.
	HTTPHeadersToInsert []*FirewallPolicyHTTPHeaderToInsert

	// Name of the rule.
	Name *string

	// Array of Application Protocols.
	Protocols []*FirewallPolicyRuleApplicationProtocol

	// List of source IP addresses for this rule.
	SourceAddresses []*string

	// List of source IpGroups for this rule.
	SourceIPGroups []*string

	// List of FQDNs for this rule.
	TargetFqdns []*string

	// List of Urls for this rule condition.
	TargetUrls []*string

	// Terminate TLS connections for this rule.
	TerminateTLS *bool

	// List of destination azure web categories.
	WebCategories []*string
}

// GetFirewallPolicyRule implements the FirewallPolicyRuleClassification interface for type ApplicationRule.
func (a *ApplicationRule) GetFirewallPolicyRule() *FirewallPolicyRule {
	return &FirewallPolicyRule{
		Description: a.Description,
		Name:        a.Name,
		RuleType:    a.RuleType,
	}
}

// ApplicationSecurityGroup - An application security group in a resource group.
type ApplicationSecurityGroup struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the application security group.
	Properties *ApplicationSecurityGroupPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ApplicationSecurityGroupListResult - A list of application security groups.
type ApplicationSecurityGroupListResult struct {
	// A list of application security groups.
	Value []*ApplicationSecurityGroup

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// ApplicationSecurityGroupPropertiesFormat - Application security group properties.
type ApplicationSecurityGroupPropertiesFormat struct {
	// READ-ONLY; The provisioning state of the application security group resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource GUID property of the application security group resource. It uniquely identifies a resource, even
	// if the user changes its name or migrate the resource across subscriptions or resource
	// groups.
	ResourceGUID *string
}

// AuthorizationListResult - Response for ListAuthorizations API service call retrieves all authorizations that belongs to
// an ExpressRouteCircuit.
type AuthorizationListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The authorizations in an ExpressRoute Circuit.
	Value []*ExpressRouteCircuitAuthorization
}

// AuthorizationPropertiesFormat - Properties of ExpressRouteCircuitAuthorization.
type AuthorizationPropertiesFormat struct {
	// The authorization key.
	AuthorizationKey *string

	// The authorization use status.
	AuthorizationUseStatus *AuthorizationUseStatus

	// READ-ONLY; The provisioning state of the authorization resource.
	ProvisioningState *ProvisioningState
}

// AutoApprovedPrivateLinkService - The information of an AutoApprovedPrivateLinkService.
type AutoApprovedPrivateLinkService struct {
	// The id of the private link service resource.
	PrivateLinkService *string
}

// AutoApprovedPrivateLinkServicesResult - An array of private link service id that can be linked to a private end point with
// auto approved.
type AutoApprovedPrivateLinkServicesResult struct {
	// An array of auto approved private link service.
	Value []*AutoApprovedPrivateLinkService

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// Availability of the metric.
type Availability struct {
	// Duration of the availability blob.
	BlobDuration *string

	// The retention of the availability.
	Retention *string

	// The time grain of the availability.
	TimeGrain *string
}

// AvailableDelegation - The serviceName of an AvailableDelegation indicates a possible delegation for a subnet.
type AvailableDelegation struct {
	// The actions permitted to the service upon delegation.
	Actions []*string

	// A unique identifier of the AvailableDelegation resource.
	ID *string

	// The name of the AvailableDelegation resource.
	Name *string

	// The name of the service and resource.
	ServiceName *string

	// Resource type.
	Type *string
}

// AvailableDelegationsResult - An array of available delegations.
type AvailableDelegationsResult struct {
	// An array of available delegations.
	Value []*AvailableDelegation

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// AvailablePrivateEndpointType - The information of an AvailablePrivateEndpointType.
type AvailablePrivateEndpointType struct {
	// Display name of the resource.
	DisplayName *string

	// A unique identifier of the AvailablePrivateEndpoint Type resource.
	ID *string

	// The name of the service and resource.
	Name *string

	// The name of the service and resource.
	ResourceName *string

	// Resource type.
	Type *string
}

// AvailablePrivateEndpointTypesResult - An array of available PrivateEndpoint types.
type AvailablePrivateEndpointTypesResult struct {
	// An array of available privateEndpoint type.
	Value []*AvailablePrivateEndpointType

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// AvailableProvidersList - List of available countries with details.
type AvailableProvidersList struct {
	// REQUIRED; List of available countries.
	Countries []*AvailableProvidersListCountry
}

// AvailableProvidersListCity - City or town details.
type AvailableProvidersListCity struct {
	// The city or town name.
	CityName *string

	// A list of Internet service providers.
	Providers []*string
}

// AvailableProvidersListCountry - Country details.
type AvailableProvidersListCountry struct {
	// The country name.
	CountryName *string

	// A list of Internet service providers.
	Providers []*string

	// List of available states in the country.
	States []*AvailableProvidersListState
}

// AvailableProvidersListParameters - Constraints that determine the list of available Internet service providers.
type AvailableProvidersListParameters struct {
	// A list of Azure regions.
	AzureLocations []*string

	// The city or town for available providers list.
	City *string

	// The country for available providers list.
	Country *string

	// The state for available providers list.
	State *string
}

// AvailableProvidersListState - State details.
type AvailableProvidersListState struct {
	// List of available cities or towns in the state.
	Cities []*AvailableProvidersListCity

	// A list of Internet service providers.
	Providers []*string

	// The state name.
	StateName *string
}

// AvailableServiceAlias - The available service alias.
type AvailableServiceAlias struct {
	// The ID of the service alias.
	ID *string

	// The name of the service alias.
	Name *string

	// The resource name of the service alias.
	ResourceName *string

	// The type of the resource.
	Type *string
}

// AvailableServiceAliasesResult - An array of available service aliases.
type AvailableServiceAliasesResult struct {
	// An array of available service aliases.
	Value []*AvailableServiceAlias

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// AzureAsyncOperationResult - The response body contains the status of the specified asynchronous operation, indicating whether
// it has succeeded, is in progress, or has failed. Note that this status is distinct from the HTTP
// status code returned for the Get Operation Status operation itself. If the asynchronous operation succeeded, the response
// body includes the HTTP status code for the successful request. If the
// asynchronous operation failed, the response body includes the HTTP status code for the failed request and error information
// regarding the failure.
type AzureAsyncOperationResult struct {
	// Details of the error occurred during specified asynchronous operation.
	Error *Error

	// Status of the Azure async operation.
	Status *NetworkOperationStatus
}

// AzureFirewall - Azure Firewall resource.
type AzureFirewall struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the azure firewall.
	Properties *AzureFirewallPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// A list of availability zones denoting where the resource needs to come from.
	Zones []*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// AzureFirewallApplicationRule - Properties of an application rule.
type AzureFirewallApplicationRule struct {
	// Description of the rule.
	Description *string

	// List of FQDN Tags for this rule.
	FqdnTags []*string

	// Name of the application rule.
	Name *string

	// Array of ApplicationRuleProtocols.
	Protocols []*AzureFirewallApplicationRuleProtocol

	// List of source IP addresses for this rule.
	SourceAddresses []*string

	// List of source IpGroups for this rule.
	SourceIPGroups []*string

	// List of FQDNs for this rule.
	TargetFqdns []*string
}

// AzureFirewallApplicationRuleCollection - Application rule collection resource.
type AzureFirewallApplicationRuleCollection struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
	Name *string

	// Properties of the azure firewall application rule collection.
	Properties *AzureFirewallApplicationRuleCollectionPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// AzureFirewallApplicationRuleCollectionPropertiesFormat - Properties of the application rule collection.
type AzureFirewallApplicationRuleCollectionPropertiesFormat struct {
	// The action type of a rule collection.
	Action *AzureFirewallRCAction

	// Priority of the application rule collection resource.
	Priority *int32

	// Collection of rules used by a application rule collection.
	Rules []*AzureFirewallApplicationRule

	// READ-ONLY; The provisioning state of the application rule collection resource.
	ProvisioningState *ProvisioningState
}

// AzureFirewallApplicationRuleProtocol - Properties of the application rule protocol.
type AzureFirewallApplicationRuleProtocol struct {
	// Port number for the protocol, cannot be greater than 64000. This field is optional.
	Port *int32

	// Protocol type.
	ProtocolType *AzureFirewallApplicationRuleProtocolType
}

// AzureFirewallFqdnTag - Azure Firewall FQDN Tag Resource.
type AzureFirewallFqdnTag struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the azure firewall FQDN tag.
	Properties *AzureFirewallFqdnTagPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// AzureFirewallFqdnTagListResult - Response for ListAzureFirewallFqdnTags API service call.
type AzureFirewallFqdnTagListResult struct {
	// URL to get the next set of results.
	NextLink *string

	// List of Azure Firewall FQDN Tags in a resource group.
	Value []*AzureFirewallFqdnTag
}

// AzureFirewallFqdnTagPropertiesFormat - Azure Firewall FQDN Tag Properties.
type AzureFirewallFqdnTagPropertiesFormat struct {
	// READ-ONLY; The name of this FQDN Tag.
	FqdnTagName *string

	// READ-ONLY; The provisioning state of the Azure firewall FQDN tag resource.
	ProvisioningState *ProvisioningState
}

// AzureFirewallIPConfiguration - IP configuration of an Azure Firewall.
type AzureFirewallIPConfiguration struct {
	// Resource ID.
	ID *string

	// Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the azure firewall IP configuration.
	Properties *AzureFirewallIPConfigurationPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// AzureFirewallIPConfigurationPropertiesFormat - Properties of IP configuration of an Azure Firewall.
type AzureFirewallIPConfigurationPropertiesFormat struct {
	// Reference to the PublicIP resource. This field is a mandatory input if subnet is not null.
	PublicIPAddress *SubResource

	// Reference to the subnet resource. This resource must be named 'AzureFirewallSubnet' or 'AzureFirewallManagementSubnet'.
	Subnet *SubResource

	// READ-ONLY; The Firewall Internal Load Balancer IP to be used as the next hop in User Defined Routes.
	PrivateIPAddress *string

	// READ-ONLY; The provisioning state of the Azure firewall IP configuration resource.
	ProvisioningState *ProvisioningState
}

// AzureFirewallIPGroups - IpGroups associated with azure firewall.
type AzureFirewallIPGroups struct {
	// READ-ONLY; The iteration number.
	ChangeNumber *string

	// READ-ONLY; Resource ID.
	ID *string
}

// AzureFirewallListResult - Response for ListAzureFirewalls API service call.
type AzureFirewallListResult struct {
	// URL to get the next set of results.
	NextLink *string

	// List of Azure Firewalls in a resource group.
	Value []*AzureFirewall
}

// AzureFirewallNatRCAction - AzureFirewall NAT Rule Collection Action.
type AzureFirewallNatRCAction struct {
	// The type of action.
	Type *AzureFirewallNatRCActionType
}

// AzureFirewallNatRule - Properties of a NAT rule.
type AzureFirewallNatRule struct {
	// Description of the rule.
	Description *string

	// List of destination IP addresses for this rule. Supports IP ranges, prefixes, and service tags.
	DestinationAddresses []*string

	// List of destination ports.
	DestinationPorts []*string

	// Name of the NAT rule.
	Name *string

	// Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
	Protocols []*AzureFirewallNetworkRuleProtocol

	// List of source IP addresses for this rule.
	SourceAddresses []*string

	// List of source IpGroups for this rule.
	SourceIPGroups []*string

	// The translated address for this NAT rule.
	TranslatedAddress *string

	// The translated FQDN for this NAT rule.
	TranslatedFqdn *string

	// The translated port for this NAT rule.
	TranslatedPort *string
}

// AzureFirewallNatRuleCollection - NAT rule collection resource.
type AzureFirewallNatRuleCollection struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
	Name *string

	// Properties of the azure firewall NAT rule collection.
	Properties *AzureFirewallNatRuleCollectionProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// AzureFirewallNatRuleCollectionProperties - Properties of the NAT rule collection.
type AzureFirewallNatRuleCollectionProperties struct {
	// The action type of a NAT rule collection.
	Action *AzureFirewallNatRCAction

	// Priority of the NAT rule collection resource.
	Priority *int32

	// Collection of rules used by a NAT rule collection.
	Rules []*AzureFirewallNatRule

	// READ-ONLY; The provisioning state of the NAT rule collection resource.
	ProvisioningState *ProvisioningState
}

// AzureFirewallNetworkRule - Properties of the network rule.
type AzureFirewallNetworkRule struct {
	// Description of the rule.
	Description *string

	// List of destination IP addresses.
	DestinationAddresses []*string

	// List of destination FQDNs.
	DestinationFqdns []*string

	// List of destination IpGroups for this rule.
	DestinationIPGroups []*string

	// List of destination ports.
	DestinationPorts []*string

	// Name of the network rule.
	Name *string

	// Array of AzureFirewallNetworkRuleProtocols.
	Protocols []*AzureFirewallNetworkRuleProtocol

	// List of source IP addresses for this rule.
	SourceAddresses []*string

	// List of source IpGroups for this rule.
	SourceIPGroups []*string
}

// AzureFirewallNetworkRuleCollection - Network rule collection resource.
type AzureFirewallNetworkRuleCollection struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
	Name *string

	// Properties of the azure firewall network rule collection.
	Properties *AzureFirewallNetworkRuleCollectionPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// AzureFirewallNetworkRuleCollectionPropertiesFormat - Properties of the network rule collection.
type AzureFirewallNetworkRuleCollectionPropertiesFormat struct {
	// The action type of a rule collection.
	Action *AzureFirewallRCAction

	// Priority of the network rule collection resource.
	Priority *int32

	// Collection of rules used by a network rule collection.
	Rules []*AzureFirewallNetworkRule

	// READ-ONLY; The provisioning state of the network rule collection resource.
	ProvisioningState *ProvisioningState
}

// AzureFirewallPacketCaptureFlags - Properties of the AzureFirewallRCAction.
type AzureFirewallPacketCaptureFlags struct {
	// Flags to capture
	Type *AzureFirewallPacketCaptureFlagsType
}

// AzureFirewallPacketCaptureRule - Group of src/dest ips and ports to be captured.
type AzureFirewallPacketCaptureRule struct {
	// List of ports to be captured.
	DestinationPorts []*string

	// List of destination IP addresses/subnets to be captured.
	Destinations []*string

	// List of source IP addresses/subnets to be captured.
	Sources []*string
}

// AzureFirewallPropertiesFormat - Properties of the Azure Firewall.
type AzureFirewallPropertiesFormat struct {
	// The additional properties used to further config this azure firewall.
	AdditionalProperties map[string]*string

	// Collection of application rule collections used by Azure Firewall.
	ApplicationRuleCollections []*AzureFirewallApplicationRuleCollection

	// The firewallPolicy associated with this azure firewall.
	FirewallPolicy *SubResource

	// IP addresses associated with AzureFirewall.
	HubIPAddresses *HubIPAddresses

	// IP configuration of the Azure Firewall resource.
	IPConfigurations []*AzureFirewallIPConfiguration

	// IP configuration of the Azure Firewall used for management traffic.
	ManagementIPConfiguration *AzureFirewallIPConfiguration

	// Collection of NAT rule collections used by Azure Firewall.
	NatRuleCollections []*AzureFirewallNatRuleCollection

	// Collection of network rule collections used by Azure Firewall.
	NetworkRuleCollections []*AzureFirewallNetworkRuleCollection

	// The Azure Firewall Resource SKU.
	SKU *AzureFirewallSKU

	// The operation mode for Threat Intelligence.
	ThreatIntelMode *AzureFirewallThreatIntelMode

	// The virtualHub to which the firewall belongs.
	VirtualHub *SubResource

	// READ-ONLY; IpGroups associated with AzureFirewall.
	IPGroups []*AzureFirewallIPGroups

	// READ-ONLY; The provisioning state of the Azure firewall resource.
	ProvisioningState *ProvisioningState
}

// AzureFirewallPublicIPAddress - Public IP Address associated with azure firewall.
type AzureFirewallPublicIPAddress struct {
	// Public IP Address value.
	Address *string
}

// AzureFirewallRCAction - Properties of the AzureFirewallRCAction.
type AzureFirewallRCAction struct {
	// The type of action.
	Type *AzureFirewallRCActionType
}

// AzureFirewallSKU - SKU of an Azure Firewall.
type AzureFirewallSKU struct {
	// Name of an Azure Firewall SKU.
	Name *AzureFirewallSKUName

	// Tier of an Azure Firewall.
	Tier *AzureFirewallSKUTier
}

// AzureReachabilityReport - Azure reachability report details.
type AzureReachabilityReport struct {
	// REQUIRED; The aggregation level of Azure reachability report. Can be Country, State or City.
	AggregationLevel *string

	// REQUIRED; Parameters that define a geographic location.
	ProviderLocation *AzureReachabilityReportLocation

	// REQUIRED; List of Azure reachability report items.
	ReachabilityReport []*AzureReachabilityReportItem
}

// AzureReachabilityReportItem - Azure reachability report details for a given provider location.
type AzureReachabilityReportItem struct {
	// The Azure region.
	AzureLocation *string

	// List of latency details for each of the time series.
	Latencies []*AzureReachabilityReportLatencyInfo

	// The Internet service provider.
	Provider *string
}

// AzureReachabilityReportLatencyInfo - Details on latency for a time series.
type AzureReachabilityReportLatencyInfo struct {
	// The relative latency score between 1 and 100, higher values indicating a faster connection.
	Score *int32

	// The time stamp.
	TimeStamp *time.Time
}

// AzureReachabilityReportLocation - Parameters that define a geographic location.
type AzureReachabilityReportLocation struct {
	// REQUIRED; The name of the country.
	Country *string

	// The name of the city or town.
	City *string

	// The name of the state.
	State *string
}

// AzureReachabilityReportParameters - Geographic and time constraints for Azure reachability report.
type AzureReachabilityReportParameters struct {
	// REQUIRED; The end time for the Azure reachability report.
	EndTime *time.Time

	// REQUIRED; Parameters that define a geographic location.
	ProviderLocation *AzureReachabilityReportLocation

	// REQUIRED; The start time for the Azure reachability report.
	StartTime *time.Time

	// Optional Azure regions to scope the query to.
	AzureLocations []*string

	// List of Internet service providers.
	Providers []*string
}

// AzureWebCategory - Azure Web Category Resource.
type AzureWebCategory struct {
	// Resource ID.
	ID *string

	// Properties of the Azure Web Category.
	Properties *AzureWebCategoryPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// AzureWebCategoryListResult - Response for ListAzureWebCategories API service call.
type AzureWebCategoryListResult struct {
	// URL to get the next set of results.
	NextLink *string

	// List of Azure Web Categories for a given Subscription.
	Value []*AzureWebCategory
}

// AzureWebCategoryPropertiesFormat - Azure Web Category Properties.
type AzureWebCategoryPropertiesFormat struct {
	// READ-ONLY; The name of the group that the category belongs to.
	Group *string
}

// BGPCommunity - Contains bgp community information offered in Service Community resources.
type BGPCommunity struct {
	// The name of the bgp community. e.g. Skype.
	CommunityName *string

	// The prefixes that the bgp community contains.
	CommunityPrefixes []*string

	// The value of the bgp community. For more information: https://docs.microsoft.com/en-us/azure/expressroute/expressroute-routing.
	CommunityValue *string

	// Customer is authorized to use bgp community or not.
	IsAuthorizedToUse *bool

	// The service group of the bgp community contains.
	ServiceGroup *string

	// The region which the service support. e.g. For O365, region is Global.
	ServiceSupportedRegion *string
}

// BackendAddressInboundNatRulePortMappings - The response for a QueryInboundNatRulePortMapping API.
type BackendAddressInboundNatRulePortMappings struct {
	// Collection of inbound NAT rule port mappings.
	InboundNatRulePortMappings []*InboundNatRulePortMapping
}

// BackendAddressPool - Pool of backend IP addresses.
type BackendAddressPool struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within the set of backend address pools used by the load balancer. This name can
	// be used to access the resource.
	Name *string

	// Properties of load balancer backend address pool.
	Properties *BackendAddressPoolPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// BackendAddressPoolPropertiesFormat - Properties of the backend address pool.
type BackendAddressPoolPropertiesFormat struct {
	// Amount of seconds Load Balancer waits for before sending RESET to client and backend address.
	DrainPeriodInSeconds *int32

	// An array of backend addresses.
	LoadBalancerBackendAddresses []*LoadBalancerBackendAddress

	// The location of the backend address pool.
	Location *string

	// Backend address synchronous mode for the backend pool
	SyncMode *SyncMode

	// An array of gateway load balancer tunnel interfaces.
	TunnelInterfaces []*GatewayLoadBalancerTunnelInterface

	// A reference to a virtual network.
	VirtualNetwork *SubResource

	// READ-ONLY; An array of references to IP addresses defined in network interfaces.
	BackendIPConfigurations []*InterfaceIPConfiguration

	// READ-ONLY; An array of references to inbound NAT rules that use this backend address pool.
	InboundNatRules []*SubResource

	// READ-ONLY; An array of references to load balancing rules that use this backend address pool.
	LoadBalancingRules []*SubResource

	// READ-ONLY; A reference to an outbound rule that uses this backend address pool.
	OutboundRule *SubResource

	// READ-ONLY; An array of references to outbound rules that use this backend address pool.
	OutboundRules []*SubResource

	// READ-ONLY; The provisioning state of the backend address pool resource.
	ProvisioningState *ProvisioningState
}

// BaseAdminRule - Network base admin rule.
type BaseAdminRule struct {
	// REQUIRED; Whether the rule is custom or default.
	Kind *AdminRuleKind

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// GetBaseAdminRule implements the BaseAdminRuleClassification interface for type BaseAdminRule.
func (b *BaseAdminRule) GetBaseAdminRule() *BaseAdminRule { return b }

// BastionActiveSession - The session detail for a target.
type BastionActiveSession struct {
	// READ-ONLY; The protocol used to connect to the target.
	Protocol *BastionConnectProtocol

	// READ-ONLY; The type of the resource.
	ResourceType *string

	// READ-ONLY; Duration in mins the session has been active.
	SessionDurationInMins *float32

	// READ-ONLY; A unique id for the session.
	SessionID *string

	// READ-ONLY; The time when the session started.
	StartTime any

	// READ-ONLY; The host name of the target.
	TargetHostName *string

	// READ-ONLY; The IP Address of the target.
	TargetIPAddress *string

	// READ-ONLY; The resource group of the target.
	TargetResourceGroup *string

	// READ-ONLY; The resource id of the target.
	TargetResourceID *string

	// READ-ONLY; The subscription id for the target virtual machine.
	TargetSubscriptionID *string

	// READ-ONLY; The user name who is active on this session.
	UserName *string
}

// BastionActiveSessionListResult - Response for GetActiveSessions.
type BastionActiveSessionListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// List of active sessions on the bastion.
	Value []*BastionActiveSession
}

// BastionHost - Bastion Host resource.
type BastionHost struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Represents the bastion host resource.
	Properties *BastionHostPropertiesFormat

	// The sku of this Bastion Host.
	SKU *SKU

	// Resource tags.
	Tags map[string]*string

	// A list of availability zones denoting where the resource needs to come from.
	Zones []*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// BastionHostIPConfiguration - IP configuration of an Bastion Host.
type BastionHostIPConfiguration struct {
	// Resource ID.
	ID *string

	// Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Represents the ip configuration associated with the resource.
	Properties *BastionHostIPConfigurationPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Ip configuration type.
	Type *string
}

// BastionHostIPConfigurationPropertiesFormat - Properties of IP configuration of an Bastion Host.
type BastionHostIPConfigurationPropertiesFormat struct {
	// REQUIRED; Reference of the PublicIP resource.
	PublicIPAddress *SubResource

	// REQUIRED; Reference of the subnet resource.
	Subnet *SubResource

	// Private IP allocation method.
	PrivateIPAllocationMethod *IPAllocationMethod

	// READ-ONLY; The provisioning state of the bastion host IP configuration resource.
	ProvisioningState *ProvisioningState
}

// BastionHostListResult - Response for ListBastionHosts API service call.
type BastionHostListResult struct {
	// URL to get the next set of results.
	NextLink *string

	// List of Bastion Hosts in a resource group.
	Value []*BastionHost
}

// BastionHostPropertiesFormat - Properties of the Bastion Host.
type BastionHostPropertiesFormat struct {
	// FQDN for the endpoint on which bastion host is accessible.
	DNSName *string

	// Enable/Disable Copy/Paste feature of the Bastion Host resource.
	DisableCopyPaste *bool

	// Enable/Disable File Copy feature of the Bastion Host resource.
	EnableFileCopy *bool

	// Enable/Disable IP Connect feature of the Bastion Host resource.
	EnableIPConnect *bool

	// Enable/Disable Kerberos feature of the Bastion Host resource.
	EnableKerberos *bool

	// Enable/Disable Shareable Link of the Bastion Host resource.
	EnableShareableLink *bool

	// Enable/Disable Tunneling feature of the Bastion Host resource.
	EnableTunneling *bool

	// IP configuration of the Bastion Host resource.
	IPConfigurations []*BastionHostIPConfiguration
	NetworkACLs      *BastionHostPropertiesFormatNetworkACLs

	// The scale units for the Bastion Host resource.
	ScaleUnits *int32

	// Reference to an existing virtual network required for Developer Bastion Host only.
	VirtualNetwork *SubResource

	// READ-ONLY; The provisioning state of the bastion host resource.
	ProvisioningState *ProvisioningState
}

type BastionHostPropertiesFormatNetworkACLs struct {
	// Sets the IP ACL rules for Developer Bastion Host.
	IPRules []*IPRule
}

// BastionSessionDeleteResult - Response for DisconnectActiveSessions.
type BastionSessionDeleteResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// List of sessions with their corresponding state.
	Value []*BastionSessionState
}

// BastionSessionState - The session state detail for a target.
type BastionSessionState struct {
	// READ-ONLY; Used for extra information.
	Message *string

	// READ-ONLY; A unique id for the session.
	SessionID *string

	// READ-ONLY; The state of the session. Disconnected/Failed/NotFound.
	State *string
}

// BastionShareableLink - Bastion Shareable Link.
type BastionShareableLink struct {
	// REQUIRED; Reference of the virtual machine resource.
	VM *VM

	// READ-ONLY; The unique Bastion Shareable Link to the virtual machine.
	Bsl *string

	// READ-ONLY; The time when the link was created.
	CreatedAt *string

	// READ-ONLY; Optional field indicating the warning or error message related to the vm in case of partial failure.
	Message *string
}

// BastionShareableLinkListRequest - Post request for Create/Delete/Get Bastion Shareable Link endpoints.
type BastionShareableLinkListRequest struct {
	// List of VM references.
	VMs []*BastionShareableLink
}

// BastionShareableLinkListResult - Response for all the Bastion Shareable Link endpoints.
type BastionShareableLinkListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// List of Bastion Shareable Links for the request.
	Value []*BastionShareableLink
}

// BastionShareableLinkTokenListRequest - Post request for Delete Bastion Shareable Link By Token endpoint.
type BastionShareableLinkTokenListRequest struct {
	// List of Bastion Shareable Link Token.
	Tokens []*string
}

// BgpConnection - Virtual Appliance Site resource.
type BgpConnection struct {
	// Resource ID.
	ID *string

	// Name of the connection.
	Name *string

	// The properties of the Bgp connections.
	Properties *BgpConnectionProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Connection type.
	Type *string
}

// BgpConnectionProperties - Properties of the bgp connection.
type BgpConnectionProperties struct {
	// The reference to the HubVirtualNetworkConnection resource.
	HubVirtualNetworkConnection *SubResource

	// Peer ASN.
	PeerAsn *int64

	// Peer IP.
	PeerIP *string

	// READ-ONLY; The current state of the VirtualHub to Peer.
	ConnectionState *HubBgpConnectionStatus

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// BgpPeerStatus - BGP peer status details.
type BgpPeerStatus struct {
	// READ-ONLY; The autonomous system number of the remote BGP peer.
	Asn *int64

	// READ-ONLY; For how long the peering has been up.
	ConnectedDuration *string

	// READ-ONLY; The virtual network gateway's local address.
	LocalAddress *string

	// READ-ONLY; The number of BGP messages received.
	MessagesReceived *int64

	// READ-ONLY; The number of BGP messages sent.
	MessagesSent *int64

	// READ-ONLY; The remote BGP peer.
	Neighbor *string

	// READ-ONLY; The number of routes learned from this peer.
	RoutesReceived *int64

	// READ-ONLY; The BGP peer state.
	State *BgpPeerState
}

// BgpPeerStatusListResult - Response for list BGP peer status API service call.
type BgpPeerStatusListResult struct {
	// List of BGP peers.
	Value []*BgpPeerStatus
}

// BgpServiceCommunity - Service Community Properties.
type BgpServiceCommunity struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the BGP service community.
	Properties *BgpServiceCommunityPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// BgpServiceCommunityListResult - Response for the ListServiceCommunity API service call.
type BgpServiceCommunityListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of service community resources.
	Value []*BgpServiceCommunity
}

// BgpServiceCommunityPropertiesFormat - Properties of Service Community.
type BgpServiceCommunityPropertiesFormat struct {
	// A list of bgp communities.
	BgpCommunities []*BGPCommunity

	// The name of the bgp community. e.g. Skype.
	ServiceName *string
}

// BgpSettings - BGP settings details.
type BgpSettings struct {
	// The BGP speaker's ASN.
	Asn *int64

	// The BGP peering address and BGP identifier of this BGP speaker.
	BgpPeeringAddress *string

	// BGP peering address with IP configuration ID for virtual network gateway.
	BgpPeeringAddresses []*IPConfigurationBgpPeeringAddress

	// The weight added to routes learned from this BGP speaker.
	PeerWeight *int32
}

// BreakOutCategoryPolicies - Network Virtual Appliance Sku Properties.
type BreakOutCategoryPolicies struct {
	// Flag to control breakout of o365 allow category.
	Allow *bool

	// Flag to control breakout of o365 default category.
	Default *bool

	// Flag to control breakout of o365 optimize category.
	Optimize *bool
}

// CheckPrivateLinkServiceVisibilityRequest - Request body of the CheckPrivateLinkServiceVisibility API service call.
type CheckPrivateLinkServiceVisibilityRequest struct {
	// The alias of the private link service.
	PrivateLinkServiceAlias *string
}

// ChildResource - Proxy resource representation.
type ChildResource struct {
	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

type Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string
}

// ConfigurationDiagnosticParameters - Parameters to get network configuration diagnostic.
type ConfigurationDiagnosticParameters struct {
	// REQUIRED; List of network configuration diagnostic profiles.
	Profiles []*ConfigurationDiagnosticProfile

	// REQUIRED; The ID of the target resource to perform network configuration diagnostic. Valid options are VM, NetworkInterface,
	// VMSS/NetworkInterface and Application Gateway.
	TargetResourceID *string

	// Verbosity level.
	VerbosityLevel *VerbosityLevel
}

// ConfigurationDiagnosticProfile - Parameters to compare with network configuration.
type ConfigurationDiagnosticProfile struct {
	// REQUIRED; Traffic destination. Accepted values are: '*', IP Address/CIDR, Service Tag.
	Destination *string

	// REQUIRED; Traffic destination port. Accepted values are '*' and a single port in the range (0 - 65535).
	DestinationPort *string

	// REQUIRED; The direction of the traffic.
	Direction *Direction

	// REQUIRED; Protocol to be verified on. Accepted values are '*', TCP, UDP.
	Protocol *string

	// REQUIRED; Traffic source. Accepted values are '*', IP Address/CIDR, Service Tag.
	Source *string
}

// ConfigurationDiagnosticResponse - Results of network configuration diagnostic on the target resource.
type ConfigurationDiagnosticResponse struct {
	// READ-ONLY; List of network configuration diagnostic results.
	Results []*ConfigurationDiagnosticResult
}

// ConfigurationDiagnosticResult - Network configuration diagnostic result corresponded to provided traffic query.
type ConfigurationDiagnosticResult struct {
	// Network security group result.
	NetworkSecurityGroupResult *SecurityGroupResult

	// Network configuration diagnostic profile.
	Profile *ConfigurationDiagnosticProfile
}

// ConfigurationGroup - The network configuration group resource
type ConfigurationGroup struct {
	// Network group ID.
	ID *string

	// The network configuration group properties
	Properties *GroupProperties
}

// ConnectionMonitor - Parameters that define the operation to create a connection monitor.
type ConnectionMonitor struct {
	// REQUIRED; Properties of the connection monitor.
	Properties *ConnectionMonitorParameters

	// Connection monitor location.
	Location *string

	// Connection monitor tags.
	Tags map[string]*string
}

// ConnectionMonitorDestination - Describes the destination of connection monitor.
type ConnectionMonitorDestination struct {
	// Address of the connection monitor destination (IP or domain name).
	Address *string

	// The destination port used by connection monitor.
	Port *int32

	// The ID of the resource used as the destination by connection monitor.
	ResourceID *string
}

// ConnectionMonitorEndpoint - Describes the connection monitor endpoint.
type ConnectionMonitorEndpoint struct {
	// REQUIRED; The name of the connection monitor endpoint.
	Name *string

	// Address of the connection monitor endpoint (IP or domain name).
	Address *string

	// Test coverage for the endpoint.
	CoverageLevel *CoverageLevel

	// Filter for sub-items within the endpoint.
	Filter *ConnectionMonitorEndpointFilter

	// Resource ID of the connection monitor endpoint.
	ResourceID *string

	// Endpoint scope.
	Scope *ConnectionMonitorEndpointScope

	// The endpoint type.
	Type *EndpointType
}

// ConnectionMonitorEndpointFilter - Describes the connection monitor endpoint filter.
type ConnectionMonitorEndpointFilter struct {
	// List of items in the filter.
	Items []*ConnectionMonitorEndpointFilterItem

	// The behavior of the endpoint filter. Currently only 'Include' is supported.
	Type *ConnectionMonitorEndpointFilterType
}

// ConnectionMonitorEndpointFilterItem - Describes the connection monitor endpoint filter item.
type ConnectionMonitorEndpointFilterItem struct {
	// The address of the filter item.
	Address *string

	// The type of item included in the filter. Currently only 'AgentAddress' is supported.
	Type *ConnectionMonitorEndpointFilterItemType
}

// ConnectionMonitorEndpointScope - Describes the connection monitor endpoint scope.
type ConnectionMonitorEndpointScope struct {
	// List of items which needs to be excluded from the endpoint scope.
	Exclude []*ConnectionMonitorEndpointScopeItem

	// List of items which needs to be included to the endpoint scope.
	Include []*ConnectionMonitorEndpointScopeItem
}

// ConnectionMonitorEndpointScopeItem - Describes the connection monitor endpoint scope item.
type ConnectionMonitorEndpointScopeItem struct {
	// The address of the endpoint item. Supported types are IPv4/IPv6 subnet mask or IPv4/IPv6 IP address.
	Address *string
}

// ConnectionMonitorHTTPConfiguration - Describes the HTTP configuration.
type ConnectionMonitorHTTPConfiguration struct {
	// The HTTP method to use.
	Method *HTTPConfigurationMethod

	// The path component of the URI. For instance, "/dir1/dir2".
	Path *string

	// The port to connect to.
	Port *int32

	// Value indicating whether HTTPS is preferred over HTTP in cases where the choice is not explicit.
	PreferHTTPS *bool

	// The HTTP headers to transmit with the request.
	RequestHeaders []*HTTPHeader

	// HTTP status codes to consider successful. For instance, "2xx,301-304,418".
	ValidStatusCodeRanges []*string
}

// ConnectionMonitorIcmpConfiguration - Describes the ICMP configuration.
type ConnectionMonitorIcmpConfiguration struct {
	// Value indicating whether path evaluation with trace route should be disabled.
	DisableTraceRoute *bool
}

// ConnectionMonitorListResult - List of connection monitors.
type ConnectionMonitorListResult struct {
	// Information about connection monitors.
	Value []*ConnectionMonitorResult
}

// ConnectionMonitorOutput - Describes a connection monitor output destination.
type ConnectionMonitorOutput struct {
	// Connection monitor output destination type. Currently, only "Workspace" is supported.
	Type *OutputType

	// Describes the settings for producing output into a log analytics workspace.
	WorkspaceSettings *ConnectionMonitorWorkspaceSettings
}

// ConnectionMonitorParameters - Parameters that define the operation to create a connection monitor.
type ConnectionMonitorParameters struct {
	// Determines if the connection monitor will start automatically once created.
	AutoStart *bool

	// Describes the destination of connection monitor.
	Destination *ConnectionMonitorDestination

	// List of connection monitor endpoints.
	Endpoints []*ConnectionMonitorEndpoint

	// Monitoring interval in seconds.
	MonitoringIntervalInSeconds *int32

	// Optional notes to be associated with the connection monitor.
	Notes *string

	// List of connection monitor outputs.
	Outputs []*ConnectionMonitorOutput

	// Describes the source of connection monitor.
	Source *ConnectionMonitorSource

	// List of connection monitor test configurations.
	TestConfigurations []*ConnectionMonitorTestConfiguration

	// List of connection monitor test groups.
	TestGroups []*ConnectionMonitorTestGroup
}

// ConnectionMonitorQueryResult - List of connection states snapshots.
type ConnectionMonitorQueryResult struct {
	// Status of connection monitor source.
	SourceStatus *ConnectionMonitorSourceStatus

	// Information about connection states.
	States []*ConnectionStateSnapshot
}

// ConnectionMonitorResult - Information about the connection monitor.
type ConnectionMonitorResult struct {
	// Connection monitor location.
	Location *string

	// Properties of the connection monitor result.
	Properties *ConnectionMonitorResultProperties

	// Connection monitor tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; ID of the connection monitor.
	ID *string

	// READ-ONLY; Name of the connection monitor.
	Name *string

	// READ-ONLY; Connection monitor type.
	Type *string
}

// ConnectionMonitorResultProperties - Describes the properties of a connection monitor.
type ConnectionMonitorResultProperties struct {
	// Determines if the connection monitor will start automatically once created.
	AutoStart *bool

	// Describes the destination of connection monitor.
	Destination *ConnectionMonitorDestination

	// List of connection monitor endpoints.
	Endpoints []*ConnectionMonitorEndpoint

	// Monitoring interval in seconds.
	MonitoringIntervalInSeconds *int32

	// Optional notes to be associated with the connection monitor.
	Notes *string

	// List of connection monitor outputs.
	Outputs []*ConnectionMonitorOutput

	// Describes the source of connection monitor.
	Source *ConnectionMonitorSource

	// List of connection monitor test configurations.
	TestConfigurations []*ConnectionMonitorTestConfiguration

	// List of connection monitor test groups.
	TestGroups []*ConnectionMonitorTestGroup

	// READ-ONLY; Type of connection monitor.
	ConnectionMonitorType *ConnectionMonitorType

	// READ-ONLY; The monitoring status of the connection monitor.
	MonitoringStatus *string

	// READ-ONLY; The provisioning state of the connection monitor.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The date and time when the connection monitor was started.
	StartTime *time.Time
}

// ConnectionMonitorSource - Describes the source of connection monitor.
type ConnectionMonitorSource struct {
	// REQUIRED; The ID of the resource used as the source by connection monitor.
	ResourceID *string

	// The source port used by connection monitor.
	Port *int32
}

// ConnectionMonitorSuccessThreshold - Describes the threshold for declaring a test successful.
type ConnectionMonitorSuccessThreshold struct {
	// The maximum percentage of failed checks permitted for a test to evaluate as successful.
	ChecksFailedPercent *int32

	// The maximum round-trip time in milliseconds permitted for a test to evaluate as successful.
	RoundTripTimeMs *float32
}

// ConnectionMonitorTCPConfiguration - Describes the TCP configuration.
type ConnectionMonitorTCPConfiguration struct {
	// Destination port behavior.
	DestinationPortBehavior *DestinationPortBehavior

	// Value indicating whether path evaluation with trace route should be disabled.
	DisableTraceRoute *bool

	// The port to connect to.
	Port *int32
}

// ConnectionMonitorTestConfiguration - Describes a connection monitor test configuration.
type ConnectionMonitorTestConfiguration struct {
	// REQUIRED; The name of the connection monitor test configuration.
	Name *string

	// REQUIRED; The protocol to use in test evaluation.
	Protocol *ConnectionMonitorTestConfigurationProtocol

	// The parameters used to perform test evaluation over HTTP.
	HTTPConfiguration *ConnectionMonitorHTTPConfiguration

	// The parameters used to perform test evaluation over ICMP.
	IcmpConfiguration *ConnectionMonitorIcmpConfiguration

	// The preferred IP version to use in test evaluation. The connection monitor may choose to use a different version depending
	// on other parameters.
	PreferredIPVersion *PreferredIPVersion

	// The threshold for declaring a test successful.
	SuccessThreshold *ConnectionMonitorSuccessThreshold

	// The parameters used to perform test evaluation over TCP.
	TCPConfiguration *ConnectionMonitorTCPConfiguration

	// The frequency of test evaluation, in seconds.
	TestFrequencySec *int32
}

// ConnectionMonitorTestGroup - Describes the connection monitor test group.
type ConnectionMonitorTestGroup struct {
	// REQUIRED; List of destination endpoint names.
	Destinations []*string

	// REQUIRED; The name of the connection monitor test group.
	Name *string

	// REQUIRED; List of source endpoint names.
	Sources []*string

	// REQUIRED; List of test configuration names.
	TestConfigurations []*string

	// Value indicating whether test group is disabled.
	Disable *bool
}

// ConnectionMonitorWorkspaceSettings - Describes the settings for producing output into a log analytics workspace.
type ConnectionMonitorWorkspaceSettings struct {
	// Log analytics workspace resource ID.
	WorkspaceResourceID *string
}

// ConnectionResetSharedKey - The virtual network connection reset shared key.
type ConnectionResetSharedKey struct {
	// REQUIRED; The virtual network connection reset shared key length, should between 1 and 128.
	KeyLength *int32
}

// ConnectionSharedKey - Response for GetConnectionSharedKey API service call.
type ConnectionSharedKey struct {
	// REQUIRED; The virtual network connection shared key value.
	Value *string

	// Resource ID.
	ID *string
}

// ConnectionStateSnapshot - Connection state snapshot.
type ConnectionStateSnapshot struct {
	// Average latency in ms.
	AvgLatencyInMs *int64

	// The connection state.
	ConnectionState *ConnectionState

	// The end time of the connection snapshot.
	EndTime *time.Time

	// Connectivity analysis evaluation state.
	EvaluationState *EvaluationState

	// Maximum latency in ms.
	MaxLatencyInMs *int64

	// Minimum latency in ms.
	MinLatencyInMs *int64

	// The number of failed probes.
	ProbesFailed *int64

	// The number of sent probes.
	ProbesSent *int64

	// The start time of the connection snapshot.
	StartTime *time.Time

	// READ-ONLY; List of hops between the source and the destination.
	Hops []*ConnectivityHop
}

// ConnectivityConfiguration - The network manager connectivity configuration resource
type ConnectivityConfiguration struct {
	// Properties of a network manager connectivity configuration
	Properties *ConnectivityConfigurationProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// ConnectivityConfigurationListResult - Result of the request to list network manager connectivity configurations. It contains
// a list of configurations and a link to get the next set of results.
type ConnectivityConfigurationListResult struct {
	// Gets the URL to get the next page of results.
	NextLink *string

	// Gets a page of Connectivity Configurations
	Value []*ConnectivityConfiguration
}

// ConnectivityConfigurationProperties - Properties of network manager connectivity configuration
type ConnectivityConfigurationProperties struct {
	// REQUIRED; Groups for configuration
	AppliesToGroups []*ConnectivityGroupItem

	// REQUIRED; Connectivity topology type.
	ConnectivityTopology *ConnectivityTopology

	// Flag if need to remove current existing peerings.
	DeleteExistingPeering *DeleteExistingPeering

	// A description of the connectivity configuration.
	Description *string

	// List of hubItems
	Hubs []*Hub

	// Flag if global mesh is supported.
	IsGlobal *IsGlobal

	// READ-ONLY; The provisioning state of the connectivity configuration resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Unique identifier for this resource.
	ResourceGUID *string
}

// ConnectivityDestination - Parameters that define destination of connection.
type ConnectivityDestination struct {
	// The IP address or URI the resource to which a connection attempt will be made.
	Address *string

	// Port on which check connectivity will be performed.
	Port *int32

	// The ID of the resource to which a connection attempt will be made.
	ResourceID *string
}

// ConnectivityGroupItem - Connectivity group item.
type ConnectivityGroupItem struct {
	// REQUIRED; Group connectivity type.
	GroupConnectivity *GroupConnectivity

	// REQUIRED; Network group Id.
	NetworkGroupID *string

	// Flag if global is supported.
	IsGlobal *IsGlobal

	// Flag if need to use hub gateway.
	UseHubGateway *UseHubGateway
}

// ConnectivityHop - Information about a hop between the source and the destination.
type ConnectivityHop struct {
	// READ-ONLY; The IP address of the hop.
	Address *string

	// READ-ONLY; The ID of the hop.
	ID *string

	// READ-ONLY; List of issues.
	Issues []*ConnectivityIssue

	// READ-ONLY; List of hop links.
	Links []*HopLink

	// READ-ONLY; List of next hop identifiers.
	NextHopIDs []*string

	// READ-ONLY; List of previous hop identifiers.
	PreviousHopIDs []*string

	// READ-ONLY; List of previous hop links.
	PreviousLinks []*HopLink

	// READ-ONLY; The ID of the resource corresponding to this hop.
	ResourceID *string

	// READ-ONLY; The type of the hop.
	Type *string
}

// ConnectivityInformation - Information on the connectivity status.
type ConnectivityInformation struct {
	// READ-ONLY; Average latency in milliseconds.
	AvgLatencyInMs *int32

	// READ-ONLY; The connection status.
	ConnectionStatus *ConnectionStatus

	// READ-ONLY; List of hops between the source and the destination.
	Hops []*ConnectivityHop

	// READ-ONLY; Maximum latency in milliseconds.
	MaxLatencyInMs *int32

	// READ-ONLY; Minimum latency in milliseconds.
	MinLatencyInMs *int32

	// READ-ONLY; Number of failed probes.
	ProbesFailed *int32

	// READ-ONLY; Total number of probes sent.
	ProbesSent *int32
}

// ConnectivityIssue - Information about an issue encountered in the process of checking for connectivity.
type ConnectivityIssue struct {
	// READ-ONLY; Provides additional context on the issue.
	Context []map[string]*string

	// READ-ONLY; The origin of the issue.
	Origin *Origin

	// READ-ONLY; The severity of the issue.
	Severity *Severity

	// READ-ONLY; The type of issue.
	Type *IssueType
}

// ConnectivityParameters - Parameters that determine how the connectivity check will be performed.
type ConnectivityParameters struct {
	// REQUIRED; The destination of connection.
	Destination *ConnectivityDestination

	// REQUIRED; The source of the connection.
	Source *ConnectivitySource

	// Preferred IP version of the connection.
	PreferredIPVersion *IPVersion

	// Network protocol.
	Protocol *Protocol

	// Configuration of the protocol.
	ProtocolConfiguration *ProtocolConfiguration
}

// ConnectivitySource - Parameters that define the source of the connection.
type ConnectivitySource struct {
	// REQUIRED; The ID of the resource from which a connectivity check will be initiated.
	ResourceID *string

	// The source port from which a connectivity check will be performed.
	Port *int32
}

// Container - Reference to container resource in remote resource provider.
type Container struct {
	// Resource ID.
	ID *string
}

// ContainerNetworkInterface - Container network interface child resource.
type ContainerNetworkInterface struct {
	// Resource ID.
	ID *string

	// The name of the resource. This name can be used to access the resource.
	Name *string

	// Container network interface properties.
	Properties *ContainerNetworkInterfacePropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Sub Resource type.
	Type *string
}

// ContainerNetworkInterfaceConfiguration - Container network interface configuration child resource.
type ContainerNetworkInterfaceConfiguration struct {
	// Resource ID.
	ID *string

	// The name of the resource. This name can be used to access the resource.
	Name *string

	// Container network interface configuration properties.
	Properties *ContainerNetworkInterfaceConfigurationPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Sub Resource type.
	Type *string
}

// ContainerNetworkInterfaceConfigurationPropertiesFormat - Container network interface configuration properties.
type ContainerNetworkInterfaceConfigurationPropertiesFormat struct {
	// A list of container network interfaces created from this container network interface configuration.
	ContainerNetworkInterfaces []*SubResource

	// A list of ip configurations of the container network interface configuration.
	IPConfigurations []*IPConfigurationProfile

	// READ-ONLY; The provisioning state of the container network interface configuration resource.
	ProvisioningState *ProvisioningState
}

// ContainerNetworkInterfaceIPConfiguration - The ip configuration for a container network interface.
type ContainerNetworkInterfaceIPConfiguration struct {
	// The name of the resource. This name can be used to access the resource.
	Name *string

	// Properties of the container network interface IP configuration.
	Properties *ContainerNetworkInterfaceIPConfigurationPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Sub Resource type.
	Type *string
}

// ContainerNetworkInterfaceIPConfigurationPropertiesFormat - Properties of the container network interface IP configuration.
type ContainerNetworkInterfaceIPConfigurationPropertiesFormat struct {
	// READ-ONLY; The provisioning state of the container network interface IP configuration resource.
	ProvisioningState *ProvisioningState
}

// ContainerNetworkInterfacePropertiesFormat - Properties of container network interface.
type ContainerNetworkInterfacePropertiesFormat struct {
	// Reference to the container to which this container network interface is attached.
	Container *Container

	// READ-ONLY; Container network interface configuration from which this container network interface is created.
	ContainerNetworkInterfaceConfiguration *ContainerNetworkInterfaceConfiguration

	// READ-ONLY; Reference to the ip configuration on this container nic.
	IPConfigurations []*ContainerNetworkInterfaceIPConfiguration

	// READ-ONLY; The provisioning state of the container network interface resource.
	ProvisioningState *ProvisioningState
}

// Criterion - A matching criteria which matches routes based on route prefix, community, and AS path.
type Criterion struct {
	// List of AS paths which this criteria matches.
	AsPath []*string

	// List of BGP communities which this criteria matches.
	Community []*string

	// Match condition to apply RouteMap rules.
	MatchCondition *RouteMapMatchCondition

	// List of route prefixes which this criteria matches.
	RoutePrefix []*string
}

// CrossTenantScopes - Cross tenant scopes.
type CrossTenantScopes struct {
	// READ-ONLY; List of management groups.
	ManagementGroups []*string

	// READ-ONLY; List of subscriptions.
	Subscriptions []*string

	// READ-ONLY; Tenant ID.
	TenantID *string
}

// CustomDNSConfigPropertiesFormat - Contains custom Dns resolution configuration from customer.
type CustomDNSConfigPropertiesFormat struct {
	// Fqdn that resolves to private endpoint ip address.
	Fqdn *string

	// A list of private ip addresses of the private endpoint.
	IPAddresses []*string
}

// CustomIPPrefix - Custom IP prefix resource.
type CustomIPPrefix struct {
	// The extended location of the custom IP prefix.
	ExtendedLocation *ExtendedLocation

	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Custom IP prefix properties.
	Properties *CustomIPPrefixPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// A list of availability zones denoting the IP allocated for the resource needs to come from.
	Zones []*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// CustomIPPrefixListResult - Response for ListCustomIpPrefixes API service call.
type CustomIPPrefixListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of Custom IP prefixes that exists in a resource group.
	Value []*CustomIPPrefix
}

// CustomIPPrefixPropertiesFormat - Custom IP prefix properties.
type CustomIPPrefixPropertiesFormat struct {
	// The ASN for CIDR advertising. Should be an integer as string.
	Asn *string

	// Authorization message for WAN validation.
	AuthorizationMessage *string

	// The prefix range in CIDR notation. Should include the start address and the prefix length.
	Cidr *string

	// The commissioned state of the Custom IP Prefix.
	CommissionedState *CommissionedState

	// The Parent CustomIpPrefix for IPv6 /64 CustomIpPrefix.
	CustomIPPrefixParent *SubResource

	// Whether to do express route advertise.
	ExpressRouteAdvertise *bool

	// The Geo for CIDR advertising. Should be an Geo code.
	Geo *Geo

	// Whether to Advertise the range to Internet.
	NoInternetAdvertise *bool

	// Type of custom IP prefix. Should be Singular, Parent, or Child.
	PrefixType *CustomIPPrefixType

	// Signed message for WAN validation.
	SignedMessage *string

	// READ-ONLY; The list of all Children for IPv6 /48 CustomIpPrefix.
	ChildCustomIPPrefixes []*SubResource

	// READ-ONLY; The reason why resource is in failed state.
	FailedReason *string

	// READ-ONLY; The provisioning state of the custom IP prefix resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The list of all referenced PublicIpPrefixes.
	PublicIPPrefixes []*SubResource

	// READ-ONLY; The resource GUID property of the custom IP prefix resource.
	ResourceGUID *string
}

// DNSNameAvailabilityResult - Response for the CheckDnsNameAvailability API service call.
type DNSNameAvailabilityResult struct {
	// Domain availability (True/False).
	Available *bool
}

// DNSSettings - DNS Proxy Settings in Firewall Policy.
type DNSSettings struct {
	// Enable DNS Proxy on Firewalls attached to the Firewall Policy.
	EnableProxy *bool

	// FQDNs in Network Rules are supported when set to true.
	RequireProxyForNetworkRules *bool

	// List of Custom DNS Servers.
	Servers []*string
}

// DdosCustomPolicy - A DDoS custom policy in a resource group.
type DdosCustomPolicy struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the DDoS custom policy.
	Properties *DdosCustomPolicyPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// DdosCustomPolicyPropertiesFormat - DDoS custom policy properties.
type DdosCustomPolicyPropertiesFormat struct {
	// READ-ONLY; The provisioning state of the DDoS custom policy resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource GUID property of the DDoS custom policy resource. It uniquely identifies the resource, even if
	// the user changes its name or migrate the resource across subscriptions or resource groups.
	ResourceGUID *string
}

// DdosProtectionPlan - A DDoS protection plan in a resource group.
type DdosProtectionPlan struct {
	// Resource location.
	Location *string

	// Properties of the DDoS protection plan.
	Properties *DdosProtectionPlanPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// DdosProtectionPlanListResult - A list of DDoS protection plans.
type DdosProtectionPlanListResult struct {
	// A list of DDoS protection plans.
	Value []*DdosProtectionPlan

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// DdosProtectionPlanPropertiesFormat - DDoS protection plan properties.
type DdosProtectionPlanPropertiesFormat struct {
	// READ-ONLY; The provisioning state of the DDoS protection plan resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The list of public IPs associated with the DDoS protection plan resource. This list is read-only.
	PublicIPAddresses []*SubResource

	// READ-ONLY; The resource GUID property of the DDoS protection plan resource. It uniquely identifies the resource, even if
	// the user changes its name or migrate the resource across subscriptions or resource groups.
	ResourceGUID *string

	// READ-ONLY; The list of virtual networks associated with the DDoS protection plan resource. This list is read-only.
	VirtualNetworks []*SubResource
}

// DdosSettings - Contains the DDoS protection settings of the public IP.
type DdosSettings struct {
	// The DDoS protection plan associated with the public IP. Can only be set if ProtectionMode is Enabled
	DdosProtectionPlan *SubResource

	// The DDoS protection mode of the public IP
	ProtectionMode *DdosSettingsProtectionMode
}

// DefaultAdminPropertiesFormat - Security default admin rule resource.
type DefaultAdminPropertiesFormat struct {
	// Default rule flag.
	Flag *string

	// READ-ONLY; Indicates the access allowed for this particular rule
	Access *SecurityConfigurationRuleAccess

	// READ-ONLY; A description for this rule. Restricted to 140 chars.
	Description *string

	// READ-ONLY; The destination port ranges.
	DestinationPortRanges []*string

	// READ-ONLY; The destination address prefixes. CIDR or destination IP ranges.
	Destinations []*AddressPrefixItem

	// READ-ONLY; Indicates if the traffic matched against the rule in inbound or outbound.
	Direction *SecurityConfigurationRuleDirection

	// READ-ONLY; The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule
	// in the collection. The lower the priority number, the higher the priority of the rule.
	Priority *int32

	// READ-ONLY; Network protocol this rule applies to.
	Protocol *SecurityConfigurationRuleProtocol

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Unique identifier for this resource.
	ResourceGUID *string

	// READ-ONLY; The source port ranges.
	SourcePortRanges []*string

	// READ-ONLY; The CIDR or source IP ranges.
	Sources []*AddressPrefixItem
}

// DefaultAdminRule - Network default admin rule.
type DefaultAdminRule struct {
	// REQUIRED; Whether the rule is custom or default.
	Kind *AdminRuleKind

	// Indicates the properties of the security admin rule
	Properties *DefaultAdminPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// GetBaseAdminRule implements the BaseAdminRuleClassification interface for type DefaultAdminRule.
func (d *DefaultAdminRule) GetBaseAdminRule() *BaseAdminRule {
	return &BaseAdminRule{
		Etag:       d.Etag,
		ID:         d.ID,
		Kind:       d.Kind,
		Name:       d.Name,
		SystemData: d.SystemData,
		Type:       d.Type,
	}
}

// DefaultRuleSetPropertyFormat - the default web application firewall rule set.
type DefaultRuleSetPropertyFormat struct {
	// The type of the web application firewall rule set.
	RuleSetType *string

	// The version of the web application firewall rule set type.
	RuleSetVersion *string
}

// Delegation - Details the service to which the subnet is delegated.
type Delegation struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a subnet. This name can be used to access the resource.
	Name *string

	// Properties of the subnet.
	Properties *ServiceDelegationPropertiesFormat

	// Resource type.
	Type *string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// DelegationProperties - Properties of the delegation.
type DelegationProperties struct {
	// The service name to which the NVA is delegated.
	ServiceName *string

	// READ-ONLY; The current provisioning state.
	ProvisioningState *ProvisioningState
}

// DeviceProperties - List of properties of the device.
type DeviceProperties struct {
	// Model of the device.
	DeviceModel *string

	// Name of the device Vendor.
	DeviceVendor *string

	// Link speed.
	LinkSpeedInMbps *int32
}

// DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for
// a subnet overrides VNET DHCP options.
type DhcpOptions struct {
	// The list of DNS servers IP addresses.
	DNSServers []*string
}

// Dimension of the metric.
type Dimension struct {
	// The display name of the dimension.
	DisplayName *string

	// The internal name of the dimension.
	InternalName *string

	// The name of the dimension.
	Name *string
}

// DscpConfiguration - Differentiated Services Code Point configuration for any given network interface
type DscpConfiguration struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the network interface.
	Properties *DscpConfigurationPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// DscpConfigurationListResult - Response for the DscpConfigurationList API service call.
type DscpConfigurationListResult struct {
	// A list of dscp configurations in a resource group.
	Value []*DscpConfiguration

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// DscpConfigurationPropertiesFormat - Differentiated Services Code Point configuration properties.
type DscpConfigurationPropertiesFormat struct {
	// Destination IP ranges.
	DestinationIPRanges []*QosIPRange

	// Destination port ranges.
	DestinationPortRanges []*QosPortRange

	// List of markings to be used in the configuration.
	Markings []*int32

	// RNM supported protocol types.
	Protocol *ProtocolType

	// QoS object definitions
	QosDefinitionCollection []*QosDefinition

	// Source IP ranges.
	SourceIPRanges []*QosIPRange

	// Sources port ranges.
	SourcePortRanges []*QosPortRange

	// READ-ONLY; Associated Network Interfaces to the DSCP Configuration.
	AssociatedNetworkInterfaces []*Interface

	// READ-ONLY; The provisioning state of the DSCP Configuration resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Qos Collection ID generated by RNM.
	QosCollectionID *string

	// READ-ONLY; The resource GUID property of the DSCP Configuration resource.
	ResourceGUID *string
}

// EffectiveBaseSecurityAdminRule - Network base admin rule.
type EffectiveBaseSecurityAdminRule struct {
	// REQUIRED; Whether the rule is custom or default.
	Kind *EffectiveAdminRuleKind

	// A description of the security admin configuration.
	ConfigurationDescription *string

	// Resource ID.
	ID *string

	// Groups for rule collection
	RuleCollectionAppliesToGroups []*ManagerSecurityGroupItem

	// A description of the rule collection.
	RuleCollectionDescription *string

	// Effective configuration groups.
	RuleGroups []*ConfigurationGroup
}

// GetEffectiveBaseSecurityAdminRule implements the EffectiveBaseSecurityAdminRuleClassification interface for type EffectiveBaseSecurityAdminRule.
func (e *EffectiveBaseSecurityAdminRule) GetEffectiveBaseSecurityAdminRule() *EffectiveBaseSecurityAdminRule {
	return e
}

// EffectiveConnectivityConfiguration - The network manager effective connectivity configuration
type EffectiveConnectivityConfiguration struct {
	// Effective configuration groups.
	ConfigurationGroups []*ConfigurationGroup

	// Connectivity configuration ID.
	ID *string

	// Properties of a network manager connectivity configuration
	Properties *ConnectivityConfigurationProperties
}

// EffectiveDefaultSecurityAdminRule - Network default admin rule.
type EffectiveDefaultSecurityAdminRule struct {
	// REQUIRED; Whether the rule is custom or default.
	Kind *EffectiveAdminRuleKind

	// A description of the security admin configuration.
	ConfigurationDescription *string

	// Resource ID.
	ID *string

	// Indicates the properties of the default security admin rule
	Properties *DefaultAdminPropertiesFormat

	// Groups for rule collection
	RuleCollectionAppliesToGroups []*ManagerSecurityGroupItem

	// A description of the rule collection.
	RuleCollectionDescription *string

	// Effective configuration groups.
	RuleGroups []*ConfigurationGroup
}

// GetEffectiveBaseSecurityAdminRule implements the EffectiveBaseSecurityAdminRuleClassification interface for type EffectiveDefaultSecurityAdminRule.
func (e *EffectiveDefaultSecurityAdminRule) GetEffectiveBaseSecurityAdminRule() *EffectiveBaseSecurityAdminRule {
	return &EffectiveBaseSecurityAdminRule{
		ConfigurationDescription:      e.ConfigurationDescription,
		ID:                            e.ID,
		Kind:                          e.Kind,
		RuleCollectionAppliesToGroups: e.RuleCollectionAppliesToGroups,
		RuleCollectionDescription:     e.RuleCollectionDescription,
		RuleGroups:                    e.RuleGroups,
	}
}

// EffectiveNetworkSecurityGroup - Effective network security group.
type EffectiveNetworkSecurityGroup struct {
	// Associated resources.
	Association *EffectiveNetworkSecurityGroupAssociation

	// A collection of effective security rules.
	EffectiveSecurityRules []*EffectiveNetworkSecurityRule

	// The ID of network security group that is applied.
	NetworkSecurityGroup *SubResource

	// Mapping of tags to list of IP Addresses included within the tag.
	TagMap *string
}

// EffectiveNetworkSecurityGroupAssociation - The effective network security group association.
type EffectiveNetworkSecurityGroupAssociation struct {
	// The ID of the network interface if assigned.
	NetworkInterface *SubResource

	// The ID of the Azure network manager if assigned.
	NetworkManager *SubResource

	// The ID of the subnet if assigned.
	Subnet *SubResource
}

// EffectiveNetworkSecurityGroupListResult - Response for list effective network security groups API service call.
type EffectiveNetworkSecurityGroupListResult struct {
	// A list of effective network security groups.
	Value []*EffectiveNetworkSecurityGroup

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// EffectiveNetworkSecurityRule - Effective network security rules.
type EffectiveNetworkSecurityRule struct {
	// Whether network traffic is allowed or denied.
	Access *SecurityRuleAccess

	// The destination address prefix.
	DestinationAddressPrefix *string

	// The destination address prefixes. Expected values include CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer,
	// Internet), System Tags, and the asterisk (*).
	DestinationAddressPrefixes []*string

	// The destination port or range.
	DestinationPortRange *string

	// The destination port ranges. Expected values include a single integer between 0 and 65535, a range using '-' as separator
	// (e.g. 100-400), or an asterisk (*).
	DestinationPortRanges []*string

	// The direction of the rule.
	Direction *SecurityRuleDirection

	// Expanded destination address prefix.
	ExpandedDestinationAddressPrefix []*string

	// The expanded source address prefix.
	ExpandedSourceAddressPrefix []*string

	// The name of the security rule specified by the user (if created by the user).
	Name *string

	// The priority of the rule.
	Priority *int32

	// The network protocol this rule applies to.
	Protocol *EffectiveSecurityRuleProtocol

	// The source address prefix.
	SourceAddressPrefix *string

	// The source address prefixes. Expected values include CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet),
	// System Tags, and the asterisk (*).
	SourceAddressPrefixes []*string

	// The source port or range.
	SourcePortRange *string

	// The source port ranges. Expected values include a single integer between 0 and 65535, a range using '-' as separator (e.g.
	// 100-400), or an asterisk (*).
	SourcePortRanges []*string
}

// EffectiveRoute - Effective Route.
type EffectiveRoute struct {
	// The address prefixes of the effective routes in CIDR notation.
	AddressPrefix []*string

	// If true, on-premises routes are not propagated to the network interfaces in the subnet.
	DisableBgpRoutePropagation *bool

	// The name of the user defined route. This is optional.
	Name *string

	// The IP address of the next hop of the effective route.
	NextHopIPAddress []*string

	// The type of Azure hop the packet should be sent to.
	NextHopType *RouteNextHopType

	// Who created the route.
	Source *EffectiveRouteSource

	// The value of effective route.
	State *EffectiveRouteState
}

// EffectiveRouteListResult - Response for list effective route API service call.
type EffectiveRouteListResult struct {
	// A list of effective routes.
	Value []*EffectiveRoute

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// EffectiveRouteMapRoute - The effective RouteMap route configured on the connection resource.
type EffectiveRouteMapRoute struct {
	// The ASPath of this route.
	AsPath *string

	// BGP communities of the route.
	BgpCommunities *string

	// The address prefix of the route.
	Prefix *string
}

// EffectiveRouteMapRouteList - EffectiveRouteMapRoute List.
type EffectiveRouteMapRouteList struct {
	// The list of Effective RouteMap Routes configured on the connection resource.
	Value []*EffectiveRouteMapRoute
}

// EffectiveRoutesParameters - The parameters specifying the resource whose effective routes are being requested.
type EffectiveRoutesParameters struct {
	// The resource whose effective routes are being requested.
	ResourceID *string

	// The type of the specified resource like RouteTable, ExpressRouteConnection, HubVirtualNetworkConnection, VpnConnection
	// and P2SConnection.
	VirtualWanResourceType *string
}

// EffectiveSecurityAdminRule - Network admin rule.
type EffectiveSecurityAdminRule struct {
	// REQUIRED; Whether the rule is custom or default.
	Kind *EffectiveAdminRuleKind

	// A description of the security admin configuration.
	ConfigurationDescription *string

	// Resource ID.
	ID *string

	// Indicates the properties of the security admin rule
	Properties *AdminPropertiesFormat

	// Groups for rule collection
	RuleCollectionAppliesToGroups []*ManagerSecurityGroupItem

	// A description of the rule collection.
	RuleCollectionDescription *string

	// Effective configuration groups.
	RuleGroups []*ConfigurationGroup
}

// GetEffectiveBaseSecurityAdminRule implements the EffectiveBaseSecurityAdminRuleClassification interface for type EffectiveSecurityAdminRule.
func (e *EffectiveSecurityAdminRule) GetEffectiveBaseSecurityAdminRule() *EffectiveBaseSecurityAdminRule {
	return &EffectiveBaseSecurityAdminRule{
		ConfigurationDescription:      e.ConfigurationDescription,
		ID:                            e.ID,
		Kind:                          e.Kind,
		RuleCollectionAppliesToGroups: e.RuleCollectionAppliesToGroups,
		RuleCollectionDescription:     e.RuleCollectionDescription,
		RuleGroups:                    e.RuleGroups,
	}
}

// EndpointServiceResult - Endpoint service.
type EndpointServiceResult struct {
	// Resource ID.
	ID *string

	// READ-ONLY; Name of the endpoint service.
	Name *string

	// READ-ONLY; Type of the endpoint service.
	Type *string
}

// EndpointServicesListResult - Response for the ListAvailableEndpointServices API service call.
type EndpointServicesListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// List of available endpoint services in a region.
	Value []*EndpointServiceResult
}

// Error - Common error representation.
type Error struct {
	// Error code.
	Code *string

	// Error details.
	Details []*ErrorDetails

	// Inner error message.
	InnerError *string

	// Error message.
	Message *string

	// Error target.
	Target *string
}

// ErrorDetails - Common error details representation.
type ErrorDetails struct {
	// Error code.
	Code *string

	// Error message.
	Message *string

	// Error target.
	Target *string
}

// ErrorResponse - The error object.
type ErrorResponse struct {
	// The error details object.
	Error *ErrorDetails
}

// EvaluatedNetworkSecurityGroup - Results of network security group evaluation.
type EvaluatedNetworkSecurityGroup struct {
	// Resource ID of nic or subnet to which network security group is applied.
	AppliedTo *string

	// Matched network security rule.
	MatchedRule *MatchedRule

	// Network security group ID.
	NetworkSecurityGroupID *string

	// READ-ONLY; List of network security rules evaluation results.
	RulesEvaluationResult []*SecurityRulesEvaluationResult
}

// ExclusionManagedRule - Defines a managed rule to use for exclusion.
type ExclusionManagedRule struct {
	// REQUIRED; Identifier for the managed rule.
	RuleID *string
}

// ExclusionManagedRuleGroup - Defines a managed rule group to use for exclusion.
type ExclusionManagedRuleGroup struct {
	// REQUIRED; The managed rule group for exclusion.
	RuleGroupName *string

	// List of rules that will be excluded. If none specified, all rules in the group will be excluded.
	Rules []*ExclusionManagedRule
}

// ExclusionManagedRuleSet - Defines a managed rule set for Exclusions.
type ExclusionManagedRuleSet struct {
	// REQUIRED; Defines the rule set type to use.
	RuleSetType *string

	// REQUIRED; Defines the version of the rule set to use.
	RuleSetVersion *string

	// Defines the rule groups to apply to the rule set.
	RuleGroups []*ExclusionManagedRuleGroup
}

// ExplicitProxySettings - Explicit Proxy Settings in Firewall Policy.
type ExplicitProxySettings struct {
	// When set to true, explicit proxy mode is enabled.
	EnableExplicitProxy *bool

	// When set to true, pac file port and url needs to be provided.
	EnablePacFile *bool

	// Port number for explicit proxy http protocol, cannot be greater than 64000.
	HTTPPort *int32

	// Port number for explicit proxy https protocol, cannot be greater than 64000.
	HTTPSPort *int32

	// SAS URL for PAC file.
	PacFile *string

	// Port number for firewall to serve PAC file.
	PacFilePort *int32
}

// ExpressRouteCircuit resource.
type ExpressRouteCircuit struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the express route circuit.
	Properties *ExpressRouteCircuitPropertiesFormat

	// The SKU.
	SKU *ExpressRouteCircuitSKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ExpressRouteCircuitArpTable - The ARP table associated with the ExpressRouteCircuit.
type ExpressRouteCircuitArpTable struct {
	// Entry age in minutes.
	Age *int32

	// The IP address.
	IPAddress *string

	// Interface address.
	Interface *string

	// The MAC address.
	MacAddress *string
}

// ExpressRouteCircuitAuthorization - Authorization in an ExpressRouteCircuit resource.
type ExpressRouteCircuitAuthorization struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the express route circuit authorization.
	Properties *AuthorizationPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ExpressRouteCircuitConnection - Express Route Circuit Connection in an ExpressRouteCircuitPeering resource.
type ExpressRouteCircuitConnection struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the express route circuit connection.
	Properties *ExpressRouteCircuitConnectionPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ExpressRouteCircuitConnectionListResult - Response for ListConnections API service call retrieves all global reach connections
// that belongs to a Private Peering for an ExpressRouteCircuit.
type ExpressRouteCircuitConnectionListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The global reach connection associated with Private Peering in an ExpressRoute Circuit.
	Value []*ExpressRouteCircuitConnection
}

// ExpressRouteCircuitConnectionPropertiesFormat - Properties of the express route circuit connection.
type ExpressRouteCircuitConnectionPropertiesFormat struct {
	// /29 IP address space to carve out Customer addresses for tunnels.
	AddressPrefix *string

	// The authorization key.
	AuthorizationKey *string

	// Reference to Express Route Circuit Private Peering Resource of the circuit initiating connection.
	ExpressRouteCircuitPeering *SubResource

	// IPv6 Address PrefixProperties of the express route circuit connection.
	IPv6CircuitConnectionConfig *IPv6CircuitConnectionConfig

	// Reference to Express Route Circuit Private Peering Resource of the peered circuit.
	PeerExpressRouteCircuitPeering *SubResource

	// READ-ONLY; Express Route Circuit connection state.
	CircuitConnectionStatus *CircuitConnectionStatus

	// READ-ONLY; The provisioning state of the express route circuit connection resource.
	ProvisioningState *ProvisioningState
}

// ExpressRouteCircuitListResult - Response for ListExpressRouteCircuit API service call.
type ExpressRouteCircuitListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of ExpressRouteCircuits in a resource group.
	Value []*ExpressRouteCircuit
}

// ExpressRouteCircuitPeering - Peering in an ExpressRouteCircuit resource.
type ExpressRouteCircuitPeering struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the express route circuit peering.
	Properties *ExpressRouteCircuitPeeringPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ExpressRouteCircuitPeeringConfig - Specifies the peering configuration.
type ExpressRouteCircuitPeeringConfig struct {
	// The communities of bgp peering. Specified for microsoft peering.
	AdvertisedCommunities []*string

	// The reference to AdvertisedPublicPrefixes.
	AdvertisedPublicPrefixes []*string

	// The CustomerASN of the peering.
	CustomerASN *int32

	// The legacy mode of the peering.
	LegacyMode *int32

	// The RoutingRegistryName of the configuration.
	RoutingRegistryName *string

	// READ-ONLY; The advertised public prefix state of the Peering resource.
	AdvertisedPublicPrefixesState *ExpressRouteCircuitPeeringAdvertisedPublicPrefixState
}

// ExpressRouteCircuitPeeringID - ExpressRoute circuit peering identifier.
type ExpressRouteCircuitPeeringID struct {
	// The ID of the ExpressRoute circuit peering.
	ID *string
}

// ExpressRouteCircuitPeeringListResult - Response for ListPeering API service call retrieves all peerings that belong to
// an ExpressRouteCircuit.
type ExpressRouteCircuitPeeringListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The peerings in an express route circuit.
	Value []*ExpressRouteCircuitPeering
}

// ExpressRouteCircuitPeeringPropertiesFormat - Properties of the express route circuit peering.
type ExpressRouteCircuitPeeringPropertiesFormat struct {
	// The Azure ASN.
	AzureASN *int32

	// The list of circuit connections associated with Azure Private Peering for this circuit.
	Connections []*ExpressRouteCircuitConnection

	// The ExpressRoute connection.
	ExpressRouteConnection *ExpressRouteConnectionID

	// The GatewayManager Etag.
	GatewayManagerEtag *string

	// The IPv6 peering configuration.
	IPv6PeeringConfig *IPv6ExpressRouteCircuitPeeringConfig

	// The Microsoft peering configuration.
	MicrosoftPeeringConfig *ExpressRouteCircuitPeeringConfig

	// The peer ASN.
	PeerASN *int64

	// The peering type.
	PeeringType *ExpressRoutePeeringType

	// The primary port.
	PrimaryAzurePort *string

	// The primary address prefix.
	PrimaryPeerAddressPrefix *string

	// The reference to the RouteFilter resource.
	RouteFilter *SubResource

	// The secondary port.
	SecondaryAzurePort *string

	// The secondary address prefix.
	SecondaryPeerAddressPrefix *string

	// The shared key.
	SharedKey *string

	// The peering state.
	State *ExpressRoutePeeringState

	// The peering stats of express route circuit.
	Stats *ExpressRouteCircuitStats

	// The VLAN ID.
	VlanID *int32

	// READ-ONLY; Who was the last to modify the peering.
	LastModifiedBy *string

	// READ-ONLY; The list of peered circuit connections associated with Azure Private Peering for this circuit.
	PeeredConnections []*PeerExpressRouteCircuitConnection

	// READ-ONLY; The provisioning state of the express route circuit peering resource.
	ProvisioningState *ProvisioningState
}

// ExpressRouteCircuitPropertiesFormat - Properties of ExpressRouteCircuit.
type ExpressRouteCircuitPropertiesFormat struct {
	// Allow classic operations.
	AllowClassicOperations *bool

	// The authorizationKey.
	AuthorizationKey *string

	// The list of authorizations.
	Authorizations []*ExpressRouteCircuitAuthorization

	// The bandwidth of the circuit when the circuit is provisioned on an ExpressRoutePort resource.
	BandwidthInGbps *float32

	// The CircuitProvisioningState state of the resource.
	CircuitProvisioningState *string

	// The reference to the ExpressRoutePort resource when the circuit is provisioned on an ExpressRoutePort resource.
	ExpressRoutePort *SubResource

	// The GatewayManager Etag.
	GatewayManagerEtag *string

	// Flag denoting global reach status.
	GlobalReachEnabled *bool

	// The list of peerings.
	Peerings []*ExpressRouteCircuitPeering

	// The ServiceKey.
	ServiceKey *string

	// The ServiceProviderNotes.
	ServiceProviderNotes *string

	// The ServiceProviderProperties.
	ServiceProviderProperties *ExpressRouteCircuitServiceProviderProperties

	// The ServiceProviderProvisioningState state of the resource.
	ServiceProviderProvisioningState *ServiceProviderProvisioningState

	// READ-ONLY; The authorization status of the Circuit.
	AuthorizationStatus *string

	// READ-ONLY; The provisioning state of the express route circuit resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The identifier of the circuit traffic. Outer tag for QinQ encapsulation.
	Stag *int32
}

// ExpressRouteCircuitReference - Reference to an express route circuit.
type ExpressRouteCircuitReference struct {
	// Corresponding Express Route Circuit Id.
	ID *string
}

// ExpressRouteCircuitRoutesTable - The routes table associated with the ExpressRouteCircuit.
type ExpressRouteCircuitRoutesTable struct {
	// Local preference value as set with the set local-preference route-map configuration command.
	LocPrf *string

	// IP address of a network entity.
	Network *string

	// NextHop address.
	NextHop *string

	// Autonomous system paths to the destination network.
	Path *string

	// Route Weight.
	Weight *int32
}

// ExpressRouteCircuitRoutesTableSummary - The routes table associated with the ExpressRouteCircuit.
type ExpressRouteCircuitRoutesTableSummary struct {
	// Autonomous system number.
	As *int32

	// IP address of the neighbor.
	Neighbor *string

	// Current state of the BGP session, and the number of prefixes that have been received from a neighbor or peer group.
	StatePfxRcd *string

	// The length of time that the BGP session has been in the Established state, or the current status if not in the Established
	// state.
	UpDown *string

	// BGP version number spoken to the neighbor.
	V *int32
}

// ExpressRouteCircuitSKU - Contains SKU in an ExpressRouteCircuit.
type ExpressRouteCircuitSKU struct {
	// The family of the SKU.
	Family *ExpressRouteCircuitSKUFamily

	// The name of the SKU.
	Name *string

	// The tier of the SKU.
	Tier *ExpressRouteCircuitSKUTier
}

// ExpressRouteCircuitServiceProviderProperties - Contains ServiceProviderProperties in an ExpressRouteCircuit.
type ExpressRouteCircuitServiceProviderProperties struct {
	// The BandwidthInMbps.
	BandwidthInMbps *int32

	// The peering location.
	PeeringLocation *string

	// The serviceProviderName.
	ServiceProviderName *string
}

// ExpressRouteCircuitStats - Contains stats associated with the peering.
type ExpressRouteCircuitStats struct {
	// The Primary BytesIn of the peering.
	PrimarybytesIn *int64

	// The primary BytesOut of the peering.
	PrimarybytesOut *int64

	// The secondary BytesIn of the peering.
	SecondarybytesIn *int64

	// The secondary BytesOut of the peering.
	SecondarybytesOut *int64
}

// ExpressRouteCircuitsArpTableListResult - Response for ListArpTable associated with the Express Route Circuits API.
type ExpressRouteCircuitsArpTableListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of the ARP tables.
	Value []*ExpressRouteCircuitArpTable
}

// ExpressRouteCircuitsRoutesTableListResult - Response for ListRoutesTable associated with the Express Route Circuits API.
type ExpressRouteCircuitsRoutesTableListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The list of routes table.
	Value []*ExpressRouteCircuitRoutesTable
}

// ExpressRouteCircuitsRoutesTableSummaryListResult - Response for ListRoutesTable associated with the Express Route Circuits
// API.
type ExpressRouteCircuitsRoutesTableSummaryListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of the routes table.
	Value []*ExpressRouteCircuitRoutesTableSummary
}

// ExpressRouteConnection resource.
type ExpressRouteConnection struct {
	// REQUIRED; The name of the resource.
	Name *string

	// Resource ID.
	ID *string

	// Properties of the express route connection.
	Properties *ExpressRouteConnectionProperties
}

// ExpressRouteConnectionID - The ID of the ExpressRouteConnection.
type ExpressRouteConnectionID struct {
	// READ-ONLY; The ID of the ExpressRouteConnection.
	ID *string
}

// ExpressRouteConnectionList - ExpressRouteConnection list.
type ExpressRouteConnectionList struct {
	// The list of ExpressRoute connections.
	Value []*ExpressRouteConnection
}

// ExpressRouteConnectionProperties - Properties of the ExpressRouteConnection subresource.
type ExpressRouteConnectionProperties struct {
	// REQUIRED; The ExpressRoute circuit peering.
	ExpressRouteCircuitPeering *ExpressRouteCircuitPeeringID

	// Authorization key to establish the connection.
	AuthorizationKey *string

	// Enable internet security.
	EnableInternetSecurity *bool

	// Bypass the ExpressRoute gateway when accessing private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be
	// enabled.
	EnablePrivateLinkFastPath *bool

	// Enable FastPath to vWan Firewall hub.
	ExpressRouteGatewayBypass *bool

	// The Routing Configuration indicating the associated and propagated route tables on this connection.
	RoutingConfiguration *RoutingConfiguration

	// The routing weight associated to the connection.
	RoutingWeight *int32

	// READ-ONLY; The provisioning state of the express route connection resource.
	ProvisioningState *ProvisioningState
}

// ExpressRouteCrossConnection resource.
type ExpressRouteCrossConnection struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the express route cross connection.
	Properties *ExpressRouteCrossConnectionProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ExpressRouteCrossConnectionListResult - Response for ListExpressRouteCrossConnection API service call.
type ExpressRouteCrossConnectionListResult struct {
	// A list of ExpressRouteCrossConnection resources.
	Value []*ExpressRouteCrossConnection

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// ExpressRouteCrossConnectionPeering - Peering in an ExpressRoute Cross Connection resource.
type ExpressRouteCrossConnectionPeering struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the express route cross connection peering.
	Properties *ExpressRouteCrossConnectionPeeringProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// ExpressRouteCrossConnectionPeeringList - Response for ListPeering API service call retrieves all peerings that belong to
// an ExpressRouteCrossConnection.
type ExpressRouteCrossConnectionPeeringList struct {
	// The peerings in an express route cross connection.
	Value []*ExpressRouteCrossConnectionPeering

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// ExpressRouteCrossConnectionPeeringProperties - Properties of express route cross connection peering.
type ExpressRouteCrossConnectionPeeringProperties struct {
	// The GatewayManager Etag.
	GatewayManagerEtag *string

	// The IPv6 peering configuration.
	IPv6PeeringConfig *IPv6ExpressRouteCircuitPeeringConfig

	// The Microsoft peering configuration.
	MicrosoftPeeringConfig *ExpressRouteCircuitPeeringConfig

	// The peer ASN.
	PeerASN *int64

	// The peering type.
	PeeringType *ExpressRoutePeeringType

	// The primary address prefix.
	PrimaryPeerAddressPrefix *string

	// The secondary address prefix.
	SecondaryPeerAddressPrefix *string

	// The shared key.
	SharedKey *string

	// The peering state.
	State *ExpressRoutePeeringState

	// The VLAN ID.
	VlanID *int32

	// READ-ONLY; The Azure ASN.
	AzureASN *int32

	// READ-ONLY; Who was the last to modify the peering.
	LastModifiedBy *string

	// READ-ONLY; The primary port.
	PrimaryAzurePort *string

	// READ-ONLY; The provisioning state of the express route cross connection peering resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The secondary port.
	SecondaryAzurePort *string
}

// ExpressRouteCrossConnectionProperties - Properties of ExpressRouteCrossConnection.
type ExpressRouteCrossConnectionProperties struct {
	// The ExpressRouteCircuit.
	ExpressRouteCircuit *ExpressRouteCircuitReference

	// The list of peerings.
	Peerings []*ExpressRouteCrossConnectionPeering

	// Additional read only notes set by the connectivity provider.
	ServiceProviderNotes *string

	// The provisioning state of the circuit in the connectivity provider system.
	ServiceProviderProvisioningState *ServiceProviderProvisioningState

	// READ-ONLY; The circuit bandwidth In Mbps.
	BandwidthInMbps *int32

	// READ-ONLY; The peering location of the ExpressRoute circuit.
	PeeringLocation *string

	// READ-ONLY; The name of the primary port.
	PrimaryAzurePort *string

	// READ-ONLY; The provisioning state of the express route cross connection resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The identifier of the circuit traffic.
	STag *int32

	// READ-ONLY; The name of the secondary port.
	SecondaryAzurePort *string
}

// ExpressRouteCrossConnectionRoutesTableSummary - The routes table associated with the ExpressRouteCircuit.
type ExpressRouteCrossConnectionRoutesTableSummary struct {
	// Autonomous system number.
	Asn *int32

	// IP address of Neighbor router.
	Neighbor *string

	// Current state of the BGP session, and the number of prefixes that have been received from a neighbor or peer group.
	StateOrPrefixesReceived *string

	// The length of time that the BGP session has been in the Established state, or the current status if not in the Established
	// state.
	UpDown *string
}

// ExpressRouteCrossConnectionsRoutesTableSummaryListResult - Response for ListRoutesTable associated with the Express Route
// Cross Connections.
type ExpressRouteCrossConnectionsRoutesTableSummaryListResult struct {
	// A list of the routes table.
	Value []*ExpressRouteCrossConnectionRoutesTableSummary

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// ExpressRouteGateway - ExpressRoute gateway resource.
type ExpressRouteGateway struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the express route gateway.
	Properties *ExpressRouteGatewayProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ExpressRouteGatewayList - List of ExpressRoute gateways.
type ExpressRouteGatewayList struct {
	// List of ExpressRoute gateways.
	Value []*ExpressRouteGateway
}

// ExpressRouteGatewayProperties - ExpressRoute gateway resource properties.
type ExpressRouteGatewayProperties struct {
	// REQUIRED; The Virtual Hub where the ExpressRoute gateway is or will be deployed.
	VirtualHub *VirtualHubID

	// Configures this gateway to accept traffic from non Virtual WAN networks.
	AllowNonVirtualWanTraffic *bool

	// Configuration for auto scaling.
	AutoScaleConfiguration *ExpressRouteGatewayPropertiesAutoScaleConfiguration

	// List of ExpressRoute connections to the ExpressRoute gateway.
	ExpressRouteConnections []*ExpressRouteConnection

	// READ-ONLY; The provisioning state of the express route gateway resource.
	ProvisioningState *ProvisioningState
}

// ExpressRouteGatewayPropertiesAutoScaleConfiguration - Configuration for auto scaling.
type ExpressRouteGatewayPropertiesAutoScaleConfiguration struct {
	// Minimum and maximum number of scale units to deploy.
	Bounds *ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds
}

// ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds - Minimum and maximum number of scale units to deploy.
type ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds struct {
	// Maximum number of scale units deployed for ExpressRoute gateway.
	Max *int32

	// Minimum number of scale units deployed for ExpressRoute gateway.
	Min *int32
}

// ExpressRouteLink child resource definition.
type ExpressRouteLink struct {
	// Resource ID.
	ID *string

	// Name of child port resource that is unique among child port resources of the parent.
	Name *string

	// ExpressRouteLink properties.
	Properties *ExpressRouteLinkPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// ExpressRouteLinkListResult - Response for ListExpressRouteLinks API service call.
type ExpressRouteLinkListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The list of ExpressRouteLink sub-resources.
	Value []*ExpressRouteLink
}

// ExpressRouteLinkMacSecConfig - ExpressRouteLink Mac Security Configuration.
type ExpressRouteLinkMacSecConfig struct {
	// Keyvault Secret Identifier URL containing Mac security CAK key.
	CakSecretIdentifier *string

	// Mac security cipher.
	Cipher *ExpressRouteLinkMacSecCipher

	// Keyvault Secret Identifier URL containing Mac security CKN key.
	CknSecretIdentifier *string

	// Sci mode enabled/disabled.
	SciState *ExpressRouteLinkMacSecSciState
}

// ExpressRouteLinkPropertiesFormat - Properties specific to ExpressRouteLink resources.
type ExpressRouteLinkPropertiesFormat struct {
	// Administrative state of the physical port.
	AdminState *ExpressRouteLinkAdminState

	// MacSec configuration.
	MacSecConfig *ExpressRouteLinkMacSecConfig

	// READ-ONLY; Cololocation for ExpressRoute Hybrid Direct.
	ColoLocation *string

	// READ-ONLY; Physical fiber port type.
	ConnectorType *ExpressRouteLinkConnectorType

	// READ-ONLY; Name of Azure router interface.
	InterfaceName *string

	// READ-ONLY; Mapping between physical port to patch panel port.
	PatchPanelID *string

	// READ-ONLY; The provisioning state of the express route link resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Mapping of physical patch panel to rack.
	RackID *string

	// READ-ONLY; Name of Azure router associated with physical port.
	RouterName *string
}

// ExpressRoutePort resource definition.
type ExpressRoutePort struct {
	// Resource ID.
	ID *string

	// The identity of ExpressRoutePort, if configured.
	Identity *ManagedServiceIdentity

	// Resource location.
	Location *string

	// ExpressRoutePort properties.
	Properties *ExpressRoutePortPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ExpressRoutePortAuthorization - ExpressRoutePort Authorization resource definition.
type ExpressRoutePortAuthorization struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// ExpressRoutePort properties.
	Properties *ExpressRoutePortAuthorizationPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ExpressRoutePortAuthorizationListResult - Response for ListExpressRoutePortAuthorizations API service call.
type ExpressRoutePortAuthorizationListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The authorizations in an ExpressRoute Port.
	Value []*ExpressRoutePortAuthorization
}

// ExpressRoutePortAuthorizationPropertiesFormat - Properties of ExpressRoutePort Authorization.
type ExpressRoutePortAuthorizationPropertiesFormat struct {
	// READ-ONLY; The authorization key.
	AuthorizationKey *string

	// READ-ONLY; The authorization use status.
	AuthorizationUseStatus *ExpressRoutePortAuthorizationUseStatus

	// READ-ONLY; The reference to the ExpressRoute circuit resource using the authorization.
	CircuitResourceURI *string

	// READ-ONLY; The provisioning state of the authorization resource.
	ProvisioningState *ProvisioningState
}

// ExpressRoutePortListResult - Response for ListExpressRoutePorts API service call.
type ExpressRoutePortListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of ExpressRoutePort resources.
	Value []*ExpressRoutePort
}

// ExpressRoutePortPropertiesFormat - Properties specific to ExpressRoutePort resources.
type ExpressRoutePortPropertiesFormat struct {
	// Bandwidth of procured ports in Gbps.
	BandwidthInGbps *int32

	// The billing type of the ExpressRoutePort resource.
	BillingType *ExpressRoutePortsBillingType

	// Encapsulation method on physical ports.
	Encapsulation *ExpressRoutePortsEncapsulation

	// The set of physical links of the ExpressRoutePort resource.
	Links []*ExpressRouteLink

	// The name of the peering location that the ExpressRoutePort is mapped to physically.
	PeeringLocation *string

	// READ-ONLY; Date of the physical port allocation to be used in Letter of Authorization.
	AllocationDate *string

	// READ-ONLY; Reference the ExpressRoute circuit(s) that are provisioned on this ExpressRoutePort resource.
	Circuits []*SubResource

	// READ-ONLY; Ether type of the physical port.
	EtherType *string

	// READ-ONLY; Maximum transmission unit of the physical port pair(s).
	Mtu *string

	// READ-ONLY; Aggregate Gbps of associated circuit bandwidths.
	ProvisionedBandwidthInGbps *float32

	// READ-ONLY; The provisioning state of the express route port resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource GUID property of the express route port resource.
	ResourceGUID *string
}

// ExpressRoutePortsLocation - Definition of the ExpressRoutePorts peering location resource.
type ExpressRoutePortsLocation struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// ExpressRoutePort peering location properties.
	Properties *ExpressRoutePortsLocationPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ExpressRoutePortsLocationBandwidths - Real-time inventory of available ExpressRoute port bandwidths.
type ExpressRoutePortsLocationBandwidths struct {
	// READ-ONLY; Bandwidth descriptive name.
	OfferName *string

	// READ-ONLY; Bandwidth value in Gbps.
	ValueInGbps *int32
}

// ExpressRoutePortsLocationListResult - Response for ListExpressRoutePortsLocations API service call.
type ExpressRoutePortsLocationListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The list of all ExpressRoutePort peering locations.
	Value []*ExpressRoutePortsLocation
}

// ExpressRoutePortsLocationPropertiesFormat - Properties specific to ExpressRoutePorts peering location resources.
type ExpressRoutePortsLocationPropertiesFormat struct {
	// The inventory of available ExpressRoutePort bandwidths.
	AvailableBandwidths []*ExpressRoutePortsLocationBandwidths

	// READ-ONLY; Address of peering location.
	Address *string

	// READ-ONLY; Contact details of peering locations.
	Contact *string

	// READ-ONLY; The provisioning state of the express route port location resource.
	ProvisioningState *ProvisioningState
}

// ExpressRouteProviderPort resource.
type ExpressRouteProviderPort struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the express route Service Provider Port.
	Properties *ExpressRouteProviderPortProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ExpressRouteProviderPortListResult - Response for ListExpressRouteProviderPort API service call.
type ExpressRouteProviderPortListResult struct {
	// A list of ExpressRouteProviderPort resources.
	Value []*ExpressRouteProviderPort

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// ExpressRouteProviderPortProperties - Properties of ExpressRouteProviderPort.
type ExpressRouteProviderPortProperties struct {
	// Overprovisioning factor for the port pair.
	OverprovisionFactor *int32

	// The peering location of the port pair.
	PeeringLocation *string

	// Bandwidth of the port in Mbps
	PortBandwidthInMbps *int32

	// Remaining Bandwidth of the port in Mbps
	RemainingBandwidthInMbps *int32

	// Used Bandwidth of the port in Mbps
	UsedBandwidthInMbps *int32

	// READ-ONLY; The name of the port pair.
	PortPairDescriptor *string

	// READ-ONLY; The name of the primary port.
	PrimaryAzurePort *string

	// READ-ONLY; The name of the secondary port.
	SecondaryAzurePort *string
}

// ExpressRouteServiceProvider - A ExpressRouteResourceProvider object.
type ExpressRouteServiceProvider struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the express route service provider.
	Properties *ExpressRouteServiceProviderPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ExpressRouteServiceProviderBandwidthsOffered - Contains bandwidths offered in ExpressRouteServiceProvider resources.
type ExpressRouteServiceProviderBandwidthsOffered struct {
	// The OfferName.
	OfferName *string

	// The ValueInMbps.
	ValueInMbps *int32
}

// ExpressRouteServiceProviderListResult - Response for the ListExpressRouteServiceProvider API service call.
type ExpressRouteServiceProviderListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of ExpressRouteResourceProvider resources.
	Value []*ExpressRouteServiceProvider
}

// ExpressRouteServiceProviderPropertiesFormat - Properties of ExpressRouteServiceProvider.
type ExpressRouteServiceProviderPropertiesFormat struct {
	// A list of bandwidths offered.
	BandwidthsOffered []*ExpressRouteServiceProviderBandwidthsOffered

	// A list of peering locations.
	PeeringLocations []*string

	// READ-ONLY; The provisioning state of the express route service provider resource.
	ProvisioningState *ProvisioningState
}

// ExtendedLocation complex type.
type ExtendedLocation struct {
	// The name of the extended location.
	Name *string

	// The type of the extended location.
	Type *ExtendedLocationTypes
}

// FilterItems - Will contain the filter name and values to operate on
type FilterItems struct {
	// The name of the field we would like to filter
	Field *string

	// List of values to filter the current field by
	Values []*string
}

// FirewallPacketCaptureParameters - Azure Firewall Packet Capture Parameters resource.
type FirewallPacketCaptureParameters struct {
	// Resource ID.
	ID *string

	// Properties of the azure firewall.
	Properties *FirewallPacketCaptureParametersFormat
}

// FirewallPacketCaptureParametersFormat - Packet capture parameters on azure firewall.
type FirewallPacketCaptureParametersFormat struct {
	// Duration of packet capture in seconds.
	DurationInSeconds *int32

	// Name of file to be uploaded to sasURL
	FileName *string

	// Rules to filter packet captures.
	Filters []*AzureFirewallPacketCaptureRule

	// The tcp-flag type to be captured. Used with protocol TCP
	Flags []*AzureFirewallPacketCaptureFlags

	// Number of packets to be captured.
	NumberOfPacketsToCapture *int32

	// The protocol of packets to capture
	Protocol *AzureFirewallNetworkRuleProtocol

	// Upload capture location
	SasURL *string
}

// FirewallPolicy Resource.
type FirewallPolicy struct {
	// Resource ID.
	ID *string

	// The identity of the firewall policy.
	Identity *ManagedServiceIdentity

	// Resource location.
	Location *string

	// Properties of the firewall policy.
	Properties *FirewallPolicyPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// FirewallPolicyCertificateAuthority - Trusted Root certificates properties for tls.
type FirewallPolicyCertificateAuthority struct {
	// Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
	KeyVaultSecretID *string

	// Name of the CA certificate.
	Name *string
}

// FirewallPolicyFilterRuleCollection - Firewall Policy Filter Rule Collection.
type FirewallPolicyFilterRuleCollection struct {
	// REQUIRED; The type of the rule collection.
	RuleCollectionType *FirewallPolicyRuleCollectionType

	// The action type of a Filter rule collection.
	Action *FirewallPolicyFilterRuleCollectionAction

	// The name of the rule collection.
	Name *string

	// Priority of the Firewall Policy Rule Collection resource.
	Priority *int32

	// List of rules included in a rule collection.
	Rules []FirewallPolicyRuleClassification
}

// GetFirewallPolicyRuleCollection implements the FirewallPolicyRuleCollectionClassification interface for type FirewallPolicyFilterRuleCollection.
func (f *FirewallPolicyFilterRuleCollection) GetFirewallPolicyRuleCollection() *FirewallPolicyRuleCollection {
	return &FirewallPolicyRuleCollection{
		Name:               f.Name,
		Priority:           f.Priority,
		RuleCollectionType: f.RuleCollectionType,
	}
}

// FirewallPolicyFilterRuleCollectionAction - Properties of the FirewallPolicyFilterRuleCollectionAction.
type FirewallPolicyFilterRuleCollectionAction struct {
	// The type of action.
	Type *FirewallPolicyFilterRuleCollectionActionType
}

// FirewallPolicyHTTPHeaderToInsert - name and value of HTTP/S header to insert
type FirewallPolicyHTTPHeaderToInsert struct {
	// Contains the name of the header
	HeaderName *string

	// Contains the value of the header
	HeaderValue *string
}

// FirewallPolicyInsights - Firewall Policy Insights.
type FirewallPolicyInsights struct {
	// A flag to indicate if the insights are enabled on the policy.
	IsEnabled *bool

	// Workspaces needed to configure the Firewall Policy Insights.
	LogAnalyticsResources *FirewallPolicyLogAnalyticsResources

	// Number of days the insights should be enabled on the policy.
	RetentionDays *int32
}

// FirewallPolicyIntrusionDetection - Configuration for intrusion detection mode and rules.
type FirewallPolicyIntrusionDetection struct {
	// Intrusion detection configuration properties.
	Configuration *FirewallPolicyIntrusionDetectionConfiguration

	// Intrusion detection general state. When attached to a parent policy, the firewall's effective IDPS mode is the stricter
	// mode of the two.
	Mode *FirewallPolicyIntrusionDetectionStateType

	// IDPS profile name. When attached to a parent policy, the firewall's effective profile is the profile name of the parent
	// policy.
	Profile *FirewallPolicyIntrusionDetectionProfileType
}

// FirewallPolicyIntrusionDetectionBypassTrafficSpecifications - Intrusion detection bypass traffic specification.
type FirewallPolicyIntrusionDetectionBypassTrafficSpecifications struct {
	// Description of the bypass traffic rule.
	Description *string

	// List of destination IP addresses or ranges for this rule.
	DestinationAddresses []*string

	// List of destination IpGroups for this rule.
	DestinationIPGroups []*string

	// List of destination ports or ranges.
	DestinationPorts []*string

	// Name of the bypass traffic rule.
	Name *string

	// The rule bypass protocol.
	Protocol *FirewallPolicyIntrusionDetectionProtocol

	// List of source IP addresses or ranges for this rule.
	SourceAddresses []*string

	// List of source IpGroups for this rule.
	SourceIPGroups []*string
}

// FirewallPolicyIntrusionDetectionConfiguration - The operation for configuring intrusion detection.
type FirewallPolicyIntrusionDetectionConfiguration struct {
	// List of rules for traffic to bypass.
	BypassTrafficSettings []*FirewallPolicyIntrusionDetectionBypassTrafficSpecifications

	// IDPS Private IP address ranges are used to identify traffic direction (i.e. inbound, outbound, etc.). By default, only
	// ranges defined by IANA RFC 1918 are considered private IP addresses. To modify
	// default ranges, specify your Private IP address ranges with this property
	PrivateRanges []*string

	// List of specific signatures states.
	SignatureOverrides []*FirewallPolicyIntrusionDetectionSignatureSpecification
}

// FirewallPolicyIntrusionDetectionSignatureSpecification - Intrusion detection signatures specification states.
type FirewallPolicyIntrusionDetectionSignatureSpecification struct {
	// Signature id.
	ID *string

	// The signature state.
	Mode *FirewallPolicyIntrusionDetectionStateType
}

// FirewallPolicyListResult - Response for ListFirewallPolicies API service call.
type FirewallPolicyListResult struct {
	// URL to get the next set of results.
	NextLink *string

	// List of Firewall Policies in a resource group.
	Value []*FirewallPolicy
}

// FirewallPolicyLogAnalyticsResources - Log Analytics Resources for Firewall Policy Insights.
type FirewallPolicyLogAnalyticsResources struct {
	// The default workspace Id for Firewall Policy Insights.
	DefaultWorkspaceID *SubResource

	// List of workspaces for Firewall Policy Insights.
	Workspaces []*FirewallPolicyLogAnalyticsWorkspace
}

// FirewallPolicyLogAnalyticsWorkspace - Log Analytics Workspace for Firewall Policy Insights.
type FirewallPolicyLogAnalyticsWorkspace struct {
	// Region to configure the Workspace.
	Region *string

	// The workspace Id for Firewall Policy Insights.
	WorkspaceID *SubResource
}

// FirewallPolicyNatRuleCollection - Firewall Policy NAT Rule Collection.
type FirewallPolicyNatRuleCollection struct {
	// REQUIRED; The type of the rule collection.
	RuleCollectionType *FirewallPolicyRuleCollectionType

	// The action type of a Nat rule collection.
	Action *FirewallPolicyNatRuleCollectionAction

	// The name of the rule collection.
	Name *string

	// Priority of the Firewall Policy Rule Collection resource.
	Priority *int32

	// List of rules included in a rule collection.
	Rules []FirewallPolicyRuleClassification
}

// GetFirewallPolicyRuleCollection implements the FirewallPolicyRuleCollectionClassification interface for type FirewallPolicyNatRuleCollection.
func (f *FirewallPolicyNatRuleCollection) GetFirewallPolicyRuleCollection() *FirewallPolicyRuleCollection {
	return &FirewallPolicyRuleCollection{
		Name:               f.Name,
		Priority:           f.Priority,
		RuleCollectionType: f.RuleCollectionType,
	}
}

// FirewallPolicyNatRuleCollectionAction - Properties of the FirewallPolicyNatRuleCollectionAction.
type FirewallPolicyNatRuleCollectionAction struct {
	// The type of action.
	Type *FirewallPolicyNatRuleCollectionActionType
}

// FirewallPolicyPropertiesFormat - Firewall Policy definition.
type FirewallPolicyPropertiesFormat struct {
	// The parent firewall policy from which rules are inherited.
	BasePolicy *SubResource

	// DNS Proxy Settings definition.
	DNSSettings *DNSSettings

	// Explicit Proxy Settings definition.
	ExplicitProxySettings *ExplicitProxySettings

	// Insights on Firewall Policy.
	Insights *FirewallPolicyInsights

	// The configuration for Intrusion detection.
	IntrusionDetection *FirewallPolicyIntrusionDetection

	// The Firewall Policy SKU.
	SKU *FirewallPolicySKU

	// SQL Settings definition.
	SQL *FirewallPolicySQL

	// The private IP addresses/IP ranges to which traffic will not be SNAT.
	Snat *FirewallPolicySNAT

	// The operation mode for Threat Intelligence.
	ThreatIntelMode *AzureFirewallThreatIntelMode

	// ThreatIntel Whitelist for Firewall Policy.
	ThreatIntelWhitelist *FirewallPolicyThreatIntelWhitelist

	// TLS Configuration definition.
	TransportSecurity *FirewallPolicyTransportSecurity

	// READ-ONLY; List of references to Child Firewall Policies.
	ChildPolicies []*SubResource

	// READ-ONLY; List of references to Azure Firewalls that this Firewall Policy is associated with.
	Firewalls []*SubResource

	// READ-ONLY; The provisioning state of the firewall policy resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; List of references to FirewallPolicyRuleCollectionGroups.
	RuleCollectionGroups []*SubResource

	// READ-ONLY; A read-only string that represents the size of the FirewallPolicyPropertiesFormat in MB. (ex 0.5MB)
	Size *string
}

// FirewallPolicyRule - Properties of a rule.
type FirewallPolicyRule struct {
	// REQUIRED; Rule Type.
	RuleType *FirewallPolicyRuleType

	// Description of the rule.
	Description *string

	// Name of the rule.
	Name *string
}

// GetFirewallPolicyRule implements the FirewallPolicyRuleClassification interface for type FirewallPolicyRule.
func (f *FirewallPolicyRule) GetFirewallPolicyRule() *FirewallPolicyRule { return f }

// FirewallPolicyRuleApplicationProtocol - Properties of the application rule protocol.
type FirewallPolicyRuleApplicationProtocol struct {
	// Port number for the protocol, cannot be greater than 64000.
	Port *int32

	// Protocol type.
	ProtocolType *FirewallPolicyRuleApplicationProtocolType
}

// FirewallPolicyRuleCollection - Properties of the rule collection.
type FirewallPolicyRuleCollection struct {
	// REQUIRED; The type of the rule collection.
	RuleCollectionType *FirewallPolicyRuleCollectionType

	// The name of the rule collection.
	Name *string

	// Priority of the Firewall Policy Rule Collection resource.
	Priority *int32
}

// GetFirewallPolicyRuleCollection implements the FirewallPolicyRuleCollectionClassification interface for type FirewallPolicyRuleCollection.
func (f *FirewallPolicyRuleCollection) GetFirewallPolicyRuleCollection() *FirewallPolicyRuleCollection {
	return f
}

// FirewallPolicyRuleCollectionGroup - Rule Collection Group resource.
type FirewallPolicyRuleCollectionGroup struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// The properties of the firewall policy rule collection group.
	Properties *FirewallPolicyRuleCollectionGroupProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Rule Group type.
	Type *string
}

// FirewallPolicyRuleCollectionGroupListResult - Response for ListFirewallPolicyRuleCollectionGroups API service call.
type FirewallPolicyRuleCollectionGroupListResult struct {
	// URL to get the next set of results.
	NextLink *string

	// List of FirewallPolicyRuleCollectionGroups in a FirewallPolicy.
	Value []*FirewallPolicyRuleCollectionGroup
}

// FirewallPolicyRuleCollectionGroupProperties - Properties of the rule collection group.
type FirewallPolicyRuleCollectionGroupProperties struct {
	// Priority of the Firewall Policy Rule Collection Group resource.
	Priority *int32

	// Group of Firewall Policy rule collections.
	RuleCollections []FirewallPolicyRuleCollectionClassification

	// READ-ONLY; The provisioning state of the firewall policy rule collection group resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; A read-only string that represents the size of the FirewallPolicyRuleCollectionGroupProperties in MB. (ex 1.2MB)
	Size *string
}

// FirewallPolicySKU - SKU of Firewall policy.
type FirewallPolicySKU struct {
	// Tier of Firewall Policy.
	Tier *FirewallPolicySKUTier
}

// FirewallPolicySNAT - The private IP addresses/IP ranges to which traffic will not be SNAT.
type FirewallPolicySNAT struct {
	// The operation mode for automatically learning private ranges to not be SNAT
	AutoLearnPrivateRanges *AutoLearnPrivateRangesMode

	// List of private IP addresses/IP address ranges to not be SNAT.
	PrivateRanges []*string
}

// FirewallPolicySQL - SQL Settings in Firewall Policy.
type FirewallPolicySQL struct {
	// A flag to indicate if SQL Redirect traffic filtering is enabled. Turning on the flag requires no rule using port 11000-11999.
	AllowSQLRedirect *bool
}

// FirewallPolicyThreatIntelWhitelist - ThreatIntel Whitelist for Firewall Policy.
type FirewallPolicyThreatIntelWhitelist struct {
	// List of FQDNs for the ThreatIntel Whitelist.
	Fqdns []*string

	// List of IP addresses for the ThreatIntel Whitelist.
	IPAddresses []*string
}

// FirewallPolicyTransportSecurity - Configuration needed to perform TLS termination & initiation.
type FirewallPolicyTransportSecurity struct {
	// The CA used for intermediate CA generation.
	CertificateAuthority *FirewallPolicyCertificateAuthority
}

// FlowLog - A flow log resource.
type FlowLog struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the flow log.
	Properties *FlowLogPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// FlowLogFormatParameters - Parameters that define the flow log format.
type FlowLogFormatParameters struct {
	// The file type of flow log.
	Type *FlowLogFormatType

	// The version (revision) of the flow log.
	Version *int32
}

// FlowLogInformation - Information on the configuration of flow log and traffic analytics (optional) .
type FlowLogInformation struct {
	// REQUIRED; Properties of the flow log.
	Properties *FlowLogProperties

	// REQUIRED; The ID of the resource to configure for flow log and traffic analytics (optional) .
	TargetResourceID *string

	// Parameters that define the configuration of traffic analytics.
	FlowAnalyticsConfiguration *TrafficAnalyticsProperties
}

// FlowLogListResult - List of flow logs.
type FlowLogListResult struct {
	// Information about flow log resource.
	Value []*FlowLog

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// FlowLogProperties - Parameters that define the configuration of flow log.
type FlowLogProperties struct {
	// REQUIRED; Flag to enable/disable flow logging.
	Enabled *bool

	// REQUIRED; ID of the storage account which is used to store the flow log.
	StorageID *string

	// Parameters that define the flow log format.
	Format *FlowLogFormatParameters

	// Parameters that define the retention policy for flow log.
	RetentionPolicy *RetentionPolicyParameters
}

// FlowLogPropertiesFormat - Parameters that define the configuration of flow log.
type FlowLogPropertiesFormat struct {
	// REQUIRED; ID of the storage account which is used to store the flow log.
	StorageID *string

	// REQUIRED; ID of network security group to which flow log will be applied.
	TargetResourceID *string

	// Flag to enable/disable flow logging.
	Enabled *bool

	// Parameters that define the configuration of traffic analytics.
	FlowAnalyticsConfiguration *TrafficAnalyticsProperties

	// Parameters that define the flow log format.
	Format *FlowLogFormatParameters

	// Parameters that define the retention policy for flow log.
	RetentionPolicy *RetentionPolicyParameters

	// READ-ONLY; The provisioning state of the flow log.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Guid of network security group to which flow log will be applied.
	TargetResourceGUID *string
}

// FlowLogStatusParameters - Parameters that define a resource to query flow log and traffic analytics (optional) status.
type FlowLogStatusParameters struct {
	// REQUIRED; The target resource where getting the flow log and traffic analytics (optional) status.
	TargetResourceID *string
}

// FrontendIPConfiguration - Frontend IP address of the load balancer.
type FrontendIPConfiguration struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within the set of frontend IP configurations used by the load balancer. This name
	// can be used to access the resource.
	Name *string

	// Properties of the load balancer probe.
	Properties *FrontendIPConfigurationPropertiesFormat

	// A list of availability zones denoting the IP allocated for the resource needs to come from.
	Zones []*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// FrontendIPConfigurationPropertiesFormat - Properties of Frontend IP Configuration of the load balancer.
type FrontendIPConfigurationPropertiesFormat struct {
	// The reference to gateway load balancer frontend IP.
	GatewayLoadBalancer *SubResource

	// The private IP address of the IP configuration.
	PrivateIPAddress *string

	// Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
	PrivateIPAddressVersion *IPVersion

	// The Private IP allocation method.
	PrivateIPAllocationMethod *IPAllocationMethod

	// The reference to the Public IP resource.
	PublicIPAddress *PublicIPAddress

	// The reference to the Public IP Prefix resource.
	PublicIPPrefix *SubResource

	// The reference to the subnet resource.
	Subnet *Subnet

	// READ-ONLY; An array of references to inbound pools that use this frontend IP.
	InboundNatPools []*SubResource

	// READ-ONLY; An array of references to inbound rules that use this frontend IP.
	InboundNatRules []*SubResource

	// READ-ONLY; An array of references to load balancing rules that use this frontend IP.
	LoadBalancingRules []*SubResource

	// READ-ONLY; An array of references to outbound rules that use this frontend IP.
	OutboundRules []*SubResource

	// READ-ONLY; The provisioning state of the frontend IP configuration resource.
	ProvisioningState *ProvisioningState
}

// GatewayCustomBgpIPAddressIPConfiguration - GatewayCustomBgpIpAddressIpConfiguration for a virtual network gateway connection.
type GatewayCustomBgpIPAddressIPConfiguration struct {
	// REQUIRED; The custom BgpPeeringAddress which belongs to IpconfigurationId.
	CustomBgpIPAddress *string

	// REQUIRED; The IpconfigurationId of ipconfiguration which belongs to gateway.
	IPConfigurationID *string
}

// GatewayLoadBalancerTunnelInterface - Gateway load balancer tunnel interface of a load balancer backend address pool.
type GatewayLoadBalancerTunnelInterface struct {
	// Identifier of gateway load balancer tunnel interface.
	Identifier *int32

	// Port of gateway load balancer tunnel interface.
	Port *int32

	// Protocol of gateway load balancer tunnel interface.
	Protocol *GatewayLoadBalancerTunnelProtocol

	// Traffic type of gateway load balancer tunnel interface.
	Type *GatewayLoadBalancerTunnelInterfaceType
}

// GatewayRoute - Gateway routing details.
type GatewayRoute struct {
	// READ-ONLY; The route's AS path sequence.
	AsPath *string

	// READ-ONLY; The gateway's local address.
	LocalAddress *string

	// READ-ONLY; The route's network prefix.
	Network *string

	// READ-ONLY; The route's next hop.
	NextHop *string

	// READ-ONLY; The source this route was learned from.
	Origin *string

	// READ-ONLY; The peer this route was learned from.
	SourcePeer *string

	// READ-ONLY; The route's weight.
	Weight *int32
}

// GatewayRouteListResult - List of virtual network gateway routes.
type GatewayRouteListResult struct {
	// List of gateway routes.
	Value []*GatewayRoute
}

// GenerateExpressRoutePortsLOARequest - The customer name to be printed on a letter of authorization.
type GenerateExpressRoutePortsLOARequest struct {
	// REQUIRED; The customer name.
	CustomerName *string
}

// GenerateExpressRoutePortsLOAResult - Response for GenerateExpressRoutePortsLOA API service call.
type GenerateExpressRoutePortsLOAResult struct {
	// The content as a base64 encoded string.
	EncodedContent *string
}

// GetInboundRoutesParameters - The parameters specifying the connection resource whose inbound routes are being requested.
type GetInboundRoutesParameters struct {
	// The type of the specified connection resource like ExpressRouteConnection, HubVirtualNetworkConnection, VpnConnection and
	// P2SConnection.
	ConnectionType *string

	// The connection resource whose inbound routes are being requested.
	ResourceURI *string
}

// GetOutboundRoutesParameters - The parameters specifying the connection resource whose outbound routes are being requested.
type GetOutboundRoutesParameters struct {
	// The type of the specified connection resource like ExpressRouteConnection, HubVirtualNetworkConnection, VpnConnection and
	// P2SConnection.
	ConnectionType *string

	// The connection resource whose outbound routes are being requested.
	ResourceURI *string
}

// GetVPNSitesConfigurationRequest - List of Vpn-Sites.
type GetVPNSitesConfigurationRequest struct {
	// REQUIRED; The sas-url to download the configurations for vpn-sites.
	OutputBlobSasURL *string

	// List of resource-ids of the vpn-sites for which config is to be downloaded.
	VPNSites []*string
}

// Group - The network group resource
type Group struct {
	// The Network Group properties
	Properties *GroupProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// GroupByUserSession - Define user session identifier group by clauses.
type GroupByUserSession struct {
	// REQUIRED; List of group by clause variables.
	GroupByVariables []*GroupByVariable
}

// GroupByVariable - Define user session group by clause variables.
type GroupByVariable struct {
	// REQUIRED; User Session clause variable.
	VariableName *ApplicationGatewayFirewallUserSessionVariable
}

// GroupListResult - Result of the request to list NetworkGroup. It contains a list of groups and a URL link to get the next
// set of results.
type GroupListResult struct {
	// Gets the URL to get the next set of results.
	NextLink *string

	// Gets a page of NetworkGroup
	Value []*Group
}

// GroupProperties - Properties of network group
type GroupProperties struct {
	// A description of the network group.
	Description *string

	// READ-ONLY; The provisioning state of the scope assignment resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Unique identifier for this resource.
	ResourceGUID *string
}

// HTTPConfiguration - HTTP configuration of the connectivity check.
type HTTPConfiguration struct {
	// List of HTTP headers.
	Headers []*HTTPHeader

	// HTTP method.
	Method *HTTPMethod

	// Valid status codes.
	ValidStatusCodes []*int32
}

// HTTPHeader - The HTTP header.
type HTTPHeader struct {
	// The name in HTTP header.
	Name *string

	// The value in HTTP header.
	Value *string
}

// HopLink - Hop link.
type HopLink struct {
	// Hop link properties.
	Properties *HopLinkProperties

	// READ-ONLY; Provides additional context on links.
	Context map[string]*string

	// READ-ONLY; List of issues.
	Issues []*ConnectivityIssue

	// READ-ONLY; Link type.
	LinkType *string

	// READ-ONLY; The ID of the next hop.
	NextHopID *string

	// READ-ONLY; Resource ID.
	ResourceID *string
}

// HopLinkProperties - Hop link properties.
type HopLinkProperties struct {
	// READ-ONLY; Average roundtrip time in milliseconds.
	RoundTripTimeAvg *int64

	// READ-ONLY; Maximum roundtrip time in milliseconds.
	RoundTripTimeMax *int64

	// READ-ONLY; Minimum roundtrip time in milliseconds.
	RoundTripTimeMin *int64
}

// Hub Item.
type Hub struct {
	// Resource Id.
	ResourceID *string

	// Resource Type.
	ResourceType *string
}

// HubIPAddresses - IP addresses associated with azure firewall.
type HubIPAddresses struct {
	// Private IP Address associated with azure firewall.
	PrivateIPAddress *string

	// Public IP addresses associated with azure firewall.
	PublicIPs *HubPublicIPAddresses
}

// HubIPConfiguration - IpConfigurations.
type HubIPConfiguration struct {
	// Resource ID.
	ID *string

	// Name of the Ip Configuration.
	Name *string

	// The properties of the Virtual Hub IPConfigurations.
	Properties *HubIPConfigurationPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Ipconfiguration type.
	Type *string
}

// HubIPConfigurationPropertiesFormat - Properties of IP configuration.
type HubIPConfigurationPropertiesFormat struct {
	// The private IP address of the IP configuration.
	PrivateIPAddress *string

	// The private IP address allocation method.
	PrivateIPAllocationMethod *IPAllocationMethod

	// The reference to the public IP resource.
	PublicIPAddress *PublicIPAddress

	// The reference to the subnet resource.
	Subnet *Subnet

	// READ-ONLY; The provisioning state of the IP configuration resource.
	ProvisioningState *ProvisioningState
}

// HubPublicIPAddresses - Public IP addresses associated with azure firewall.
type HubPublicIPAddresses struct {
	// The list of Public IP addresses associated with azure firewall or IP addresses to be retained.
	Addresses []*AzureFirewallPublicIPAddress

	// The number of Public IP addresses associated with azure firewall.
	Count *int32
}

// HubRoute - RouteTable route.
type HubRoute struct {
	// REQUIRED; The type of destinations (eg: CIDR, ResourceId, Service).
	DestinationType *string

	// REQUIRED; List of all destinations.
	Destinations []*string

	// REQUIRED; The name of the Route that is unique within a RouteTable. This name can be used to access this route.
	Name *string

	// REQUIRED; NextHop resource ID.
	NextHop *string

	// REQUIRED; The type of next hop (eg: ResourceId).
	NextHopType *string
}

// HubRouteTable - RouteTable resource in a virtual hub.
type HubRouteTable struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the RouteTable resource.
	Properties *HubRouteTableProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource type.
	Type *string
}

// HubRouteTableProperties - Parameters for RouteTable.
type HubRouteTableProperties struct {
	// List of labels associated with this route table.
	Labels []*string

	// List of all routes.
	Routes []*HubRoute

	// READ-ONLY; List of all connections associated with this route table.
	AssociatedConnections []*string

	// READ-ONLY; List of all connections that advertise to this route table.
	PropagatingConnections []*string

	// READ-ONLY; The provisioning state of the RouteTable resource.
	ProvisioningState *ProvisioningState
}

// HubVirtualNetworkConnection Resource.
type HubVirtualNetworkConnection struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the hub virtual network connection.
	Properties *HubVirtualNetworkConnectionProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// HubVirtualNetworkConnectionProperties - Parameters for HubVirtualNetworkConnection.
type HubVirtualNetworkConnectionProperties struct {
	// Deprecated: VirtualHub to RemoteVnet transit to enabled or not.
	AllowHubToRemoteVnetTransit *bool

	// Deprecated: Allow RemoteVnet to use Virtual Hub's gateways.
	AllowRemoteVnetToUseHubVnetGateways *bool

	// Enable internet security.
	EnableInternetSecurity *bool

	// Reference to the remote virtual network.
	RemoteVirtualNetwork *SubResource

	// The Routing Configuration indicating the associated and propagated route tables on this connection.
	RoutingConfiguration *RoutingConfiguration

	// READ-ONLY; The provisioning state of the hub virtual network connection resource.
	ProvisioningState *ProvisioningState
}

// IDPSQueryObject - Will describe the query to run against the IDPS signatures DB
type IDPSQueryObject struct {
	// Contain all filters names and values
	Filters []*FilterItems

	// Column to sort response by
	OrderBy *OrderBy

	// The number of the results to return in each page
	ResultsPerPage *int32

	// Search term in all columns
	Search *string

	// The number of records matching the filter to skip
	Skip *int32
}

// IPAddressAvailabilityResult - Response for CheckIPAddressAvailability API service call.
type IPAddressAvailabilityResult struct {
	// Private IP address availability.
	Available *bool

	// Contains other available private IP addresses if the asked for address is taken.
	AvailableIPAddresses []*string

	// Private IP address platform reserved.
	IsPlatformReserved *bool
}

// IPAllocation - IpAllocation resource.
type IPAllocation struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the IpAllocation.
	Properties *IPAllocationPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// IPAllocationListResult - Response for the ListIpAllocations API service call.
type IPAllocationListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of IpAllocation resources.
	Value []*IPAllocation
}

// IPAllocationPropertiesFormat - Properties of the IpAllocation.
type IPAllocationPropertiesFormat struct {
	// IpAllocation tags.
	AllocationTags map[string]*string

	// The IPAM allocation ID.
	IpamAllocationID *string

	// The address prefix for the IpAllocation.
	Prefix *string

	// The address prefix length for the IpAllocation.
	PrefixLength *int32

	// The address prefix Type for the IpAllocation.
	PrefixType *IPVersion

	// The type for the IpAllocation.
	Type *IPAllocationType

	// READ-ONLY; The Subnet that using the prefix of this IpAllocation resource.
	Subnet *SubResource

	// READ-ONLY; The VirtualNetwork that using the prefix of this IpAllocation resource.
	VirtualNetwork *SubResource
}

// IPConfiguration - IP configuration.
type IPConfiguration struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the IP configuration.
	Properties *IPConfigurationPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// IPConfigurationBgpPeeringAddress - Properties of IPConfigurationBgpPeeringAddress.
type IPConfigurationBgpPeeringAddress struct {
	// The list of custom BGP peering addresses which belong to IP configuration.
	CustomBgpIPAddresses []*string

	// The ID of IP configuration which belongs to gateway.
	IPConfigurationID *string

	// READ-ONLY; The list of default BGP peering addresses which belong to IP configuration.
	DefaultBgpIPAddresses []*string

	// READ-ONLY; The list of tunnel public IP addresses which belong to IP configuration.
	TunnelIPAddresses []*string
}

// IPConfigurationProfile - IP configuration profile child resource.
type IPConfigurationProfile struct {
	// Resource ID.
	ID *string

	// The name of the resource. This name can be used to access the resource.
	Name *string

	// Properties of the IP configuration profile.
	Properties *IPConfigurationProfilePropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Sub Resource type.
	Type *string
}

// IPConfigurationProfilePropertiesFormat - IP configuration profile properties.
type IPConfigurationProfilePropertiesFormat struct {
	// The reference to the subnet resource to create a container network interface ip configuration.
	Subnet *Subnet

	// READ-ONLY; The provisioning state of the IP configuration profile resource.
	ProvisioningState *ProvisioningState
}

// IPConfigurationPropertiesFormat - Properties of IP configuration.
type IPConfigurationPropertiesFormat struct {
	// The private IP address of the IP configuration.
	PrivateIPAddress *string

	// The private IP address allocation method.
	PrivateIPAllocationMethod *IPAllocationMethod

	// The reference to the public IP resource.
	PublicIPAddress *PublicIPAddress

	// The reference to the subnet resource.
	Subnet *Subnet

	// READ-ONLY; The provisioning state of the IP configuration resource.
	ProvisioningState *ProvisioningState
}

// IPGroup - The IpGroups resource information.
type IPGroup struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the IpGroups.
	Properties *IPGroupPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// IPGroupListResult - Response for the ListIpGroups API service call.
type IPGroupListResult struct {
	// URL to get the next set of results.
	NextLink *string

	// The list of IpGroups information resources.
	Value []*IPGroup
}

// IPGroupPropertiesFormat - The IpGroups property information.
type IPGroupPropertiesFormat struct {
	// IpAddresses/IpAddressPrefixes in the IpGroups resource.
	IPAddresses []*string

	// READ-ONLY; List of references to Firewall Policies resources that this IpGroups is associated with.
	FirewallPolicies []*SubResource

	// READ-ONLY; List of references to Firewall resources that this IpGroups is associated with.
	Firewalls []*SubResource

	// READ-ONLY; The provisioning state of the IpGroups resource.
	ProvisioningState *ProvisioningState
}

// IPPrefixesList - List of SNAT IP Prefixes learnt by firewall to not SNAT
type IPPrefixesList struct {
	// IP Prefix value.
	IPPrefixes []*string
}

type IPRule struct {
	// Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
	AddressPrefix *string
}

// IPSecPolicy - An IPSec Policy configuration for a virtual network gateway connection.
type IPSecPolicy struct {
	// REQUIRED; The DH Group used in IKE Phase 1 for initial SA.
	DhGroup *DhGroup

	// REQUIRED; The IPSec encryption algorithm (IKE phase 1).
	IPSecEncryption *IPSecEncryption

	// REQUIRED; The IPSec integrity algorithm (IKE phase 1).
	IPSecIntegrity *IPSecIntegrity

	// REQUIRED; The IKE encryption algorithm (IKE phase 2).
	IkeEncryption *IkeEncryption

	// REQUIRED; The IKE integrity algorithm (IKE phase 2).
	IkeIntegrity *IkeIntegrity

	// REQUIRED; The Pfs Group used in IKE Phase 2 for new child SA.
	PfsGroup *PfsGroup

	// REQUIRED; The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for a site to site VPN
	// tunnel.
	SaDataSizeKilobytes *int32

	// REQUIRED; The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for a site to site
	// VPN tunnel.
	SaLifeTimeSeconds *int32
}

// IPTag - Contains the IpTag associated with the object.
type IPTag struct {
	// The IP tag type. Example: FirstPartyUsage.
	IPTagType *string

	// The value of the IP tag associated with the public IP. Example: SQL.
	Tag *string
}

// IPv6CircuitConnectionConfig - IPv6 Circuit Connection properties for global reach.
type IPv6CircuitConnectionConfig struct {
	// /125 IP address space to carve out customer addresses for global reach.
	AddressPrefix *string

	// READ-ONLY; Express Route Circuit connection state.
	CircuitConnectionStatus *CircuitConnectionStatus
}

// IPv6ExpressRouteCircuitPeeringConfig - Contains IPv6 peering config.
type IPv6ExpressRouteCircuitPeeringConfig struct {
	// The Microsoft peering configuration.
	MicrosoftPeeringConfig *ExpressRouteCircuitPeeringConfig

	// The primary address prefix.
	PrimaryPeerAddressPrefix *string

	// The reference to the RouteFilter resource.
	RouteFilter *SubResource

	// The secondary address prefix.
	SecondaryPeerAddressPrefix *string

	// The state of peering.
	State *ExpressRouteCircuitPeeringState
}

// InboundNatPool - Inbound NAT pool of the load balancer.
type InboundNatPool struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within the set of inbound NAT pools used by the load balancer. This name can be
	// used to access the resource.
	Name *string

	// Properties of load balancer inbound nat pool.
	Properties *InboundNatPoolPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// InboundNatPoolPropertiesFormat - Properties of Inbound NAT pool.
type InboundNatPoolPropertiesFormat struct {
	// REQUIRED; The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
	BackendPort *int32

	// REQUIRED; The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated
	// with a load balancer. Acceptable values range between 1 and 65535.
	FrontendPortRangeEnd *int32

	// REQUIRED; The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated
	// with a load balancer. Acceptable values range between 1 and 65534.
	FrontendPortRangeStart *int32

	// REQUIRED; The reference to the transport protocol used by the inbound NAT pool.
	Protocol *TransportProtocol

	// Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability
	// Group. This setting is required when using the SQL AlwaysOn Availability Groups
	// in SQL server. This setting can't be changed after you create the endpoint.
	EnableFloatingIP *bool

	// Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used
	// when the protocol is set to TCP.
	EnableTCPReset *bool

	// A reference to frontend IP addresses.
	FrontendIPConfiguration *SubResource

	// The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes.
	// This element is only used when the protocol is set to TCP.
	IdleTimeoutInMinutes *int32

	// READ-ONLY; The provisioning state of the inbound NAT pool resource.
	ProvisioningState *ProvisioningState
}

// InboundNatRule - Inbound NAT rule of the load balancer.
type InboundNatRule struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within the set of inbound NAT rules used by the load balancer. This name can be
	// used to access the resource.
	Name *string

	// Properties of load balancer inbound NAT rule.
	Properties *InboundNatRulePropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// InboundNatRuleListResult - Response for ListInboundNatRule API service call.
type InboundNatRuleListResult struct {
	// A list of inbound NAT rules in a load balancer.
	Value []*InboundNatRule

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// InboundNatRulePortMapping - Individual port mappings for inbound NAT rule created for backend pool.
type InboundNatRulePortMapping struct {
	// READ-ONLY; Backend port.
	BackendPort *int32

	// READ-ONLY; Frontend port.
	FrontendPort *int32

	// READ-ONLY; Name of inbound NAT rule.
	InboundNatRuleName *string

	// READ-ONLY; The reference to the transport protocol used by the inbound NAT rule.
	Protocol *TransportProtocol
}

// InboundNatRulePropertiesFormat - Properties of the inbound NAT rule.
type InboundNatRulePropertiesFormat struct {
	// A reference to backendAddressPool resource.
	BackendAddressPool *SubResource

	// The port used for the internal endpoint. Acceptable values range from 1 to 65535.
	BackendPort *int32

	// Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability
	// Group. This setting is required when using the SQL AlwaysOn Availability Groups
	// in SQL server. This setting can't be changed after you create the endpoint.
	EnableFloatingIP *bool

	// Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used
	// when the protocol is set to TCP.
	EnableTCPReset *bool

	// A reference to frontend IP addresses.
	FrontendIPConfiguration *SubResource

	// The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values
	// range from 1 to 65534.
	FrontendPort *int32

	// The port range end for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeStart.
	// Individual inbound NAT rule port mappings will be created for each
	// backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
	FrontendPortRangeEnd *int32

	// The port range start for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeEnd.
	// Individual inbound NAT rule port mappings will be created for each
	// backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
	FrontendPortRangeStart *int32

	// The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes.
	// This element is only used when the protocol is set to TCP.
	IdleTimeoutInMinutes *int32

	// The reference to the transport protocol used by the load balancing rule.
	Protocol *TransportProtocol

	// READ-ONLY; A reference to a private IP address defined on a network interface of a VM. Traffic sent to the frontend port
	// of each of the frontend IP configurations is forwarded to the backend IP.
	BackendIPConfiguration *InterfaceIPConfiguration

	// READ-ONLY; The provisioning state of the inbound NAT rule resource.
	ProvisioningState *ProvisioningState
}

// InboundSecurityRule - NVA Inbound Security Rule resource.
type InboundSecurityRule struct {
	// Resource ID.
	ID *string

	// Name of security rule collection.
	Name *string

	// The properties of the Inbound Security Rules.
	Properties *InboundSecurityRuleProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; NVA inbound security rule type.
	Type *string
}

// InboundSecurityRuleProperties - Properties of the Inbound Security Rules resource.
type InboundSecurityRuleProperties struct {
	// List of allowed rules.
	Rules []*InboundSecurityRules

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// InboundSecurityRules - Properties of the Inbound Security Rules resource.
type InboundSecurityRules struct {
	// NVA port ranges to be opened up. One needs to provide specific ports.
	DestinationPortRange *int32

	// Protocol. This should be either TCP or UDP.
	Protocol *InboundSecurityRulesProtocol

	// The CIDR or source IP range. Only /30, /31 and /32 Ip ranges are allowed.
	SourceAddressPrefix *string
}

// IntentPolicy - Network Intent Policy resource.
type IntentPolicy struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// IntentPolicyConfiguration - Details of NetworkIntentPolicyConfiguration for PrepareNetworkPoliciesRequest.
type IntentPolicyConfiguration struct {
	// The name of the Network Intent Policy for storing in target subscription.
	NetworkIntentPolicyName *string

	// Source network intent policy.
	SourceNetworkIntentPolicy *IntentPolicy
}

// Interface - A network interface in a resource group.
type Interface struct {
	// The extended location of the network interface.
	ExtendedLocation *ExtendedLocation

	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the network interface.
	Properties *InterfacePropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// InterfaceAssociation - Network interface and its custom security rules.
type InterfaceAssociation struct {
	// Collection of custom security rules.
	SecurityRules []*SecurityRule

	// READ-ONLY; Network interface ID.
	ID *string
}

// InterfaceDNSSettings - DNS settings of a network interface.
type InterfaceDNSSettings struct {
	// List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS'
	// value cannot be combined with other IPs, it must be the only value in dnsServers
	// collection.
	DNSServers []*string

	// Relative DNS name for this NIC used for internal communications between VMs in the same virtual network.
	InternalDNSNameLabel *string

	// READ-ONLY; If the VM that uses this NIC is part of an Availability Set, then this list will have the union of all DNS servers
	// from all NICs that are part of the Availability Set. This property is what is
	// configured on each of those VMs.
	AppliedDNSServers []*string

	// READ-ONLY; Even if internalDnsNameLabel is not specified, a DNS entry is created for the primary NIC of the VM. This DNS
	// name can be constructed by concatenating the VM name with the value of
	// internalDomainNameSuffix.
	InternalDomainNameSuffix *string

	// READ-ONLY; Fully qualified DNS name supporting internal communications between VMs in the same virtual network.
	InternalFqdn *string
}

// InterfaceIPConfiguration - IPConfiguration in a network interface.
type InterfaceIPConfiguration struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Network interface IP configuration properties.
	Properties *InterfaceIPConfigurationPropertiesFormat

	// Resource type.
	Type *string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// InterfaceIPConfigurationListResult - Response for list ip configurations API service call.
type InterfaceIPConfigurationListResult struct {
	// A list of ip configurations.
	Value []*InterfaceIPConfiguration

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// InterfaceIPConfigurationPrivateLinkConnectionProperties - PrivateLinkConnection properties for the network interface.
type InterfaceIPConfigurationPrivateLinkConnectionProperties struct {
	// READ-ONLY; List of FQDNs for current private link connection.
	Fqdns []*string

	// READ-ONLY; The group ID for current private link connection.
	GroupID *string

	// READ-ONLY; The required member name for current private link connection.
	RequiredMemberName *string
}

// InterfaceIPConfigurationPropertiesFormat - Properties of IP configuration.
type InterfaceIPConfigurationPropertiesFormat struct {
	// The reference to ApplicationGatewayBackendAddressPool resource.
	ApplicationGatewayBackendAddressPools []*ApplicationGatewayBackendAddressPool

	// Application security groups in which the IP configuration is included.
	ApplicationSecurityGroups []*ApplicationSecurityGroup

	// The reference to gateway load balancer frontend IP.
	GatewayLoadBalancer *SubResource

	// The reference to LoadBalancerBackendAddressPool resource.
	LoadBalancerBackendAddressPools []*BackendAddressPool

	// A list of references of LoadBalancerInboundNatRules.
	LoadBalancerInboundNatRules []*InboundNatRule

	// Whether this is a primary customer address on the network interface.
	Primary *bool

	// Private IP address of the IP configuration.
	PrivateIPAddress *string

	// Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
	PrivateIPAddressVersion *IPVersion

	// The private IP address allocation method.
	PrivateIPAllocationMethod *IPAllocationMethod

	// Public IP address bound to the IP configuration.
	PublicIPAddress *PublicIPAddress

	// Subnet bound to the IP configuration.
	Subnet *Subnet

	// The reference to Virtual Network Taps.
	VirtualNetworkTaps []*VirtualNetworkTap

	// READ-ONLY; PrivateLinkConnection properties for the network interface.
	PrivateLinkConnectionProperties *InterfaceIPConfigurationPrivateLinkConnectionProperties

	// READ-ONLY; The provisioning state of the network interface IP configuration.
	ProvisioningState *ProvisioningState
}

// InterfaceListResult - Response for the ListNetworkInterface API service call.
type InterfaceListResult struct {
	// A list of network interfaces in a resource group.
	Value []*Interface

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// InterfaceLoadBalancerListResult - Response for list ip configurations API service call.
type InterfaceLoadBalancerListResult struct {
	// A list of load balancers.
	Value []*LoadBalancer

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// InterfacePropertiesFormat - NetworkInterface properties.
type InterfacePropertiesFormat struct {
	// Auxiliary mode of Network Interface resource.
	AuxiliaryMode *NetworkInterfaceAuxiliaryMode

	// Auxiliary sku of Network Interface resource.
	AuxiliarySKU *NetworkInterfaceAuxiliarySKU

	// The DNS settings in network interface.
	DNSSettings *InterfaceDNSSettings

	// Indicates whether to disable tcp state tracking.
	DisableTCPStateTracking *bool

	// If the network interface is configured for accelerated networking. Not applicable to VM sizes which require accelerated
	// networking.
	EnableAcceleratedNetworking *bool

	// Indicates whether IP forwarding is enabled on this network interface.
	EnableIPForwarding *bool

	// A list of IPConfigurations of the network interface.
	IPConfigurations []*InterfaceIPConfiguration

	// Migration phase of Network Interface resource.
	MigrationPhase *NetworkInterfaceMigrationPhase

	// The reference to the NetworkSecurityGroup resource.
	NetworkSecurityGroup *SecurityGroup

	// Type of Network Interface resource.
	NicType *NetworkInterfaceNicType

	// Privatelinkservice of the network interface resource.
	PrivateLinkService *PrivateLinkService

	// WorkloadType of the NetworkInterface for BareMetal resources
	WorkloadType *string

	// READ-ONLY; A reference to the dscp configuration to which the network interface is linked.
	DscpConfiguration *SubResource

	// READ-ONLY; A list of references to linked BareMetal resources.
	HostedWorkloads []*string

	// READ-ONLY; The MAC address of the network interface.
	MacAddress *string

	// READ-ONLY; Whether this is a primary network interface on a virtual machine.
	Primary *bool

	// READ-ONLY; A reference to the private endpoint to which the network interface is linked.
	PrivateEndpoint *PrivateEndpoint

	// READ-ONLY; The provisioning state of the network interface resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource GUID property of the network interface resource.
	ResourceGUID *string

	// READ-ONLY; A list of TapConfigurations of the network interface.
	TapConfigurations []*InterfaceTapConfiguration

	// READ-ONLY; The reference to a virtual machine.
	VirtualMachine *SubResource

	// READ-ONLY; Whether the virtual machine this nic is attached to supports encryption.
	VnetEncryptionSupported *bool
}

// InterfaceTapConfiguration - Tap configuration in a Network Interface.
type InterfaceTapConfiguration struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the Virtual Network Tap configuration.
	Properties *InterfaceTapConfigurationPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Sub Resource type.
	Type *string
}

// InterfaceTapConfigurationListResult - Response for list tap configurations API service call.
type InterfaceTapConfigurationListResult struct {
	// A list of tap configurations.
	Value []*InterfaceTapConfiguration

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// InterfaceTapConfigurationPropertiesFormat - Properties of Virtual Network Tap configuration.
type InterfaceTapConfigurationPropertiesFormat struct {
	// The reference to the Virtual Network Tap resource.
	VirtualNetworkTap *VirtualNetworkTap

	// READ-ONLY; The provisioning state of the network interface tap configuration resource.
	ProvisioningState *ProvisioningState
}

// InternetIngressPublicIPsProperties - Resource Uri of Public Ip for Standard Load Balancer Frontend End.
type InternetIngressPublicIPsProperties struct {
	// Resource Uri of Public Ip
	ID *string
}

// ListHubRouteTablesResult - List of RouteTables and a URL nextLink to get the next set of results.
type ListHubRouteTablesResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of RouteTables.
	Value []*HubRouteTable
}

// ListHubVirtualNetworkConnectionsResult - List of HubVirtualNetworkConnections and a URL nextLink to get the next set of
// results.
type ListHubVirtualNetworkConnectionsResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of HubVirtualNetworkConnections.
	Value []*HubVirtualNetworkConnection
}

// ListP2SVPNGatewaysResult - Result of the request to list P2SVpnGateways. It contains a list of P2SVpnGateways and a URL
// nextLink to get the next set of results.
type ListP2SVPNGatewaysResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of P2SVpnGateways.
	Value []*P2SVPNGateway
}

// ListRouteMapsResult - List of RouteMaps and a URL nextLink to get the next set of results.
type ListRouteMapsResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of RouteMaps.
	Value []*RouteMap
}

// ListRoutingIntentResult - List of the routing intent result and a URL nextLink to get the next set of results.
type ListRoutingIntentResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of RoutingIntent resource.
	Value []*RoutingIntent
}

// ListVPNConnectionsResult - Result of the request to list all vpn connections to a virtual wan vpn gateway. It contains
// a list of Vpn Connections and a URL nextLink to get the next set of results.
type ListVPNConnectionsResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of Vpn Connections.
	Value []*VPNConnection
}

// ListVPNGatewayNatRulesResult - Result of the request to list all nat rules to a virtual wan vpn gateway. It contains a
// list of Nat rules and a URL nextLink to get the next set of results.
type ListVPNGatewayNatRulesResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of Nat Rules.
	Value []*VPNGatewayNatRule
}

// ListVPNGatewaysResult - Result of the request to list VpnGateways. It contains a list of VpnGateways and a URL nextLink
// to get the next set of results.
type ListVPNGatewaysResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of VpnGateways.
	Value []*VPNGateway
}

// ListVPNServerConfigurationPolicyGroupsResult - Result of the request to list VpnServerConfigurationPolicyGroups. It contains
// a list of VpnServerConfigurationPolicyGroups and a URL nextLink to get the next set of results.
type ListVPNServerConfigurationPolicyGroupsResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of VpnServerConfigurationPolicyGroups.
	Value []*VPNServerConfigurationPolicyGroup
}

// ListVPNServerConfigurationsResult - Result of the request to list all VpnServerConfigurations. It contains a list of VpnServerConfigurations
// and a URL nextLink to get the next set of results.
type ListVPNServerConfigurationsResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of VpnServerConfigurations.
	Value []*VPNServerConfiguration
}

// ListVPNSiteLinkConnectionsResult - Result of the request to list all vpn connections to a virtual wan vpn gateway. It contains
// a list of Vpn Connections and a URL nextLink to get the next set of results.
type ListVPNSiteLinkConnectionsResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of VpnSiteLinkConnections.
	Value []*VPNSiteLinkConnection
}

// ListVPNSiteLinksResult - Result of the request to list VpnSiteLinks. It contains a list of VpnSiteLinks and a URL nextLink
// to get the next set of results.
type ListVPNSiteLinksResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of VpnSitesLinks.
	Value []*VPNSiteLink
}

// ListVPNSitesResult - Result of the request to list VpnSites. It contains a list of VpnSites and a URL nextLink to get the
// next set of results.
type ListVPNSitesResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of VpnSites.
	Value []*VPNSite
}

// ListVirtualHubBgpConnectionResults - VirtualHubBgpConnections list.
type ListVirtualHubBgpConnectionResults struct {
	// URL to get the next set of results.
	NextLink *string

	// The list of VirtualHubBgpConnections.
	Value []*BgpConnection
}

// ListVirtualHubIPConfigurationResults - VirtualHubIpConfigurations list.
type ListVirtualHubIPConfigurationResults struct {
	// URL to get the next set of results.
	NextLink *string

	// The list of VirtualHubIpConfigurations.
	Value []*HubIPConfiguration
}

// ListVirtualHubRouteTableV2SResult - List of VirtualHubRouteTableV2s and a URL nextLink to get the next set of results.
type ListVirtualHubRouteTableV2SResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of VirtualHubRouteTableV2s.
	Value []*VirtualHubRouteTableV2
}

// ListVirtualHubsResult - Result of the request to list VirtualHubs. It contains a list of VirtualHubs and a URL nextLink
// to get the next set of results.
type ListVirtualHubsResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of VirtualHubs.
	Value []*VirtualHub
}

// ListVirtualNetworkGatewayNatRulesResult - Result of the request to list all nat rules to a virtual network gateway. It
// contains a list of Nat rules and a URL nextLink to get the next set of results.
type ListVirtualNetworkGatewayNatRulesResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of Nat Rules.
	Value []*VirtualNetworkGatewayNatRule
}

// ListVirtualWANsResult - Result of the request to list VirtualWANs. It contains a list of VirtualWANs and a URL nextLink
// to get the next set of results.
type ListVirtualWANsResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of VirtualWANs.
	Value []*VirtualWAN
}

// LoadBalancer resource.
type LoadBalancer struct {
	// The extended location of the load balancer.
	ExtendedLocation *ExtendedLocation

	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of load balancer.
	Properties *LoadBalancerPropertiesFormat

	// The load balancer SKU.
	SKU *LoadBalancerSKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// LoadBalancerBackendAddress - Load balancer backend addresses.
type LoadBalancerBackendAddress struct {
	// Name of the backend address.
	Name *string

	// Properties of load balancer backend address pool.
	Properties *LoadBalancerBackendAddressPropertiesFormat
}

// LoadBalancerBackendAddressPoolListResult - Response for ListBackendAddressPool API service call.
type LoadBalancerBackendAddressPoolListResult struct {
	// A list of backend address pools in a load balancer.
	Value []*BackendAddressPool

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// LoadBalancerBackendAddressPropertiesFormat - Properties of the load balancer backend addresses.
type LoadBalancerBackendAddressPropertiesFormat struct {
	// A list of administrative states which once set can override health probe so that Load Balancer will always forward new
	// connections to backend, or deny new connections and reset existing connections.
	AdminState *LoadBalancerBackendAddressAdminState

	// IP Address belonging to the referenced virtual network.
	IPAddress *string

	// Reference to the frontend ip address configuration defined in regional loadbalancer.
	LoadBalancerFrontendIPConfiguration *SubResource

	// Reference to an existing subnet.
	Subnet *SubResource

	// Reference to an existing virtual network.
	VirtualNetwork *SubResource

	// READ-ONLY; Collection of inbound NAT rule port mappings.
	InboundNatRulesPortMapping []*NatRulePortMapping

	// READ-ONLY; Reference to IP address defined in network interfaces.
	NetworkInterfaceIPConfiguration *SubResource
}

// LoadBalancerFrontendIPConfigurationListResult - Response for ListFrontendIPConfiguration API service call.
type LoadBalancerFrontendIPConfigurationListResult struct {
	// A list of frontend IP configurations in a load balancer.
	Value []*FrontendIPConfiguration

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// LoadBalancerListResult - Response for ListLoadBalancers API service call.
type LoadBalancerListResult struct {
	// A list of load balancers in a resource group.
	Value []*LoadBalancer

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// LoadBalancerLoadBalancingRuleListResult - Response for ListLoadBalancingRule API service call.
type LoadBalancerLoadBalancingRuleListResult struct {
	// A list of load balancing rules in a load balancer.
	Value []*LoadBalancingRule

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// LoadBalancerOutboundRuleListResult - Response for ListOutboundRule API service call.
type LoadBalancerOutboundRuleListResult struct {
	// A list of outbound rules in a load balancer.
	Value []*OutboundRule

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// LoadBalancerProbeListResult - Response for ListProbe API service call.
type LoadBalancerProbeListResult struct {
	// A list of probes in a load balancer.
	Value []*Probe

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// LoadBalancerPropertiesFormat - Properties of the load balancer.
type LoadBalancerPropertiesFormat struct {
	// Collection of backend address pools used by a load balancer.
	BackendAddressPools []*BackendAddressPool

	// Object representing the frontend IPs to be used for the load balancer.
	FrontendIPConfigurations []*FrontendIPConfiguration

	// Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound
	// NAT rules are created automatically for each NIC associated with the Load
	// Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive
	// with defining inbound NAT rules. Inbound NAT pools are referenced from virtual
	// machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They
	// have to reference individual inbound NAT rules.
	InboundNatPools []*InboundNatPool

	// Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive
	// with defining an inbound NAT pool. Inbound NAT pools are referenced from
	// virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool.
	// They have to reference individual inbound NAT rules.
	InboundNatRules []*InboundNatRule

	// Object collection representing the load balancing rules Gets the provisioning.
	LoadBalancingRules []*LoadBalancingRule

	// The outbound rules.
	OutboundRules []*OutboundRule

	// Collection of probe objects used in the load balancer.
	Probes []*Probe

	// READ-ONLY; The provisioning state of the load balancer resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource GUID property of the load balancer resource.
	ResourceGUID *string
}

// LoadBalancerSKU - SKU of a load balancer.
type LoadBalancerSKU struct {
	// Name of a load balancer SKU.
	Name *LoadBalancerSKUName

	// Tier of a load balancer SKU.
	Tier *LoadBalancerSKUTier
}

// LoadBalancerVipSwapRequest - The request for a VIP swap.
type LoadBalancerVipSwapRequest struct {
	// A list of frontend IP configuration resources that should swap VIPs.
	FrontendIPConfigurations []*LoadBalancerVipSwapRequestFrontendIPConfiguration
}

// LoadBalancerVipSwapRequestFrontendIPConfiguration - VIP swap request's frontend IP configuration object.
type LoadBalancerVipSwapRequestFrontendIPConfiguration struct {
	// The ID of frontend IP configuration resource.
	ID *string

	// The properties of VIP swap request's frontend IP configuration object.
	Properties *LoadBalancerVipSwapRequestFrontendIPConfigurationProperties
}

// LoadBalancerVipSwapRequestFrontendIPConfigurationProperties - The properties of VIP swap request's frontend IP configuration
// object.
type LoadBalancerVipSwapRequestFrontendIPConfigurationProperties struct {
	// A reference to public IP address resource.
	PublicIPAddress *SubResource
}

// LoadBalancingRule - A load balancing rule for a load balancer.
type LoadBalancingRule struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within the set of load balancing rules used by the load balancer. This name can
	// be used to access the resource.
	Name *string

	// Properties of load balancer load balancing rule.
	Properties *LoadBalancingRulePropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// LoadBalancingRulePropertiesFormat - Properties of the load balancer.
type LoadBalancingRulePropertiesFormat struct {
	// REQUIRED; The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable
	// values are between 0 and 65534. Note that value 0 enables "Any Port".
	FrontendPort *int32

	// REQUIRED; The reference to the transport protocol used by the load balancing rule.
	Protocol *TransportProtocol

	// A reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs.
	BackendAddressPool *SubResource

	// An array of references to pool of DIPs.
	BackendAddressPools []*SubResource

	// The port used for internal connections on the endpoint. Acceptable values are between 0 and 65535. Note that value 0 enables
	// "Any Port".
	BackendPort *int32

	// Configures SNAT for the VMs in the backend pool to use the publicIP address specified in the frontend of the load balancing
	// rule.
	DisableOutboundSnat *bool

	// Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability
	// Group. This setting is required when using the SQL AlwaysOn Availability Groups
	// in SQL server. This setting can't be changed after you create the endpoint.
	EnableFloatingIP *bool

	// Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used
	// when the protocol is set to TCP.
	EnableTCPReset *bool

	// A reference to frontend IP addresses.
	FrontendIPConfiguration *SubResource

	// The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes.
	// This element is only used when the protocol is set to TCP.
	IdleTimeoutInMinutes *int32

	// The load distribution policy for this rule.
	LoadDistribution *LoadDistribution

	// The reference to the load balancer probe used by the load balancing rule.
	Probe *SubResource

	// READ-ONLY; The provisioning state of the load balancing rule resource.
	ProvisioningState *ProvisioningState
}

// LocalNetworkGateway - A common class for general resource information.
type LocalNetworkGateway struct {
	// REQUIRED; Properties of the local network gateway.
	Properties *LocalNetworkGatewayPropertiesFormat

	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// LocalNetworkGatewayListResult - Response for ListLocalNetworkGateways API service call.
type LocalNetworkGatewayListResult struct {
	// A list of local network gateways that exists in a resource group.
	Value []*LocalNetworkGateway

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// LocalNetworkGatewayPropertiesFormat - LocalNetworkGateway properties.
type LocalNetworkGatewayPropertiesFormat struct {
	// Local network gateway's BGP speaker settings.
	BgpSettings *BgpSettings

	// FQDN of local network gateway.
	Fqdn *string

	// IP address of local network gateway.
	GatewayIPAddress *string

	// Local network site address space.
	LocalNetworkAddressSpace *AddressSpace

	// READ-ONLY; The provisioning state of the local network gateway resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource GUID property of the local network gateway resource.
	ResourceGUID *string
}

// LogSpecification - Description of logging specification.
type LogSpecification struct {
	// Duration of the blob.
	BlobDuration *string

	// The display name of the specification.
	DisplayName *string

	// The name of the specification.
	Name *string
}

// ManagedRuleGroupOverride - Defines a managed rule group override setting.
type ManagedRuleGroupOverride struct {
	// REQUIRED; The managed rule group to override.
	RuleGroupName *string

	// List of rules that will be disabled. If none specified, all rules in the group will be disabled.
	Rules []*ManagedRuleOverride
}

// ManagedRuleOverride - Defines a managed rule group override setting.
type ManagedRuleOverride struct {
	// REQUIRED; Identifier for the managed rule.
	RuleID *string

	// Describes the override action to be applied when rule matches.
	Action *ActionType

	// The state of the managed rule. Defaults to Disabled if not specified.
	State *ManagedRuleEnabledState
}

// ManagedRuleSet - Defines a managed rule set.
type ManagedRuleSet struct {
	// REQUIRED; Defines the rule set type to use.
	RuleSetType *string

	// REQUIRED; Defines the version of the rule set to use.
	RuleSetVersion *string

	// Defines the rule group overrides to apply to the rule set.
	RuleGroupOverrides []*ManagedRuleGroupOverride
}

// ManagedRulesDefinition - Allow to exclude some variable satisfy the condition for the WAF check.
type ManagedRulesDefinition struct {
	// REQUIRED; The managed rule sets that are associated with the policy.
	ManagedRuleSets []*ManagedRuleSet

	// The Exclusions that are applied on the policy.
	Exclusions []*OwaspCrsExclusionEntry
}

// ManagedServiceIdentity - Identity for the resource.
type ManagedServiceIdentity struct {
	// The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created
	// identity and a set of user assigned identities. The type 'None' will remove any
	// identities from the virtual machine.
	Type *ResourceIdentityType

	// The list of user identities associated with resource. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties

	// READ-ONLY; The principal id of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string

	// READ-ONLY; The tenant id of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string
}

// Manager - The Managed Network resource
type Manager struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// The network manager properties
	Properties *ManagerProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// ManagerCommit - Network Manager Commit.
type ManagerCommit struct {
	// REQUIRED; Commit Type.
	CommitType *ConfigurationType

	// REQUIRED; List of target locations.
	TargetLocations []*string

	// List of configuration ids.
	ConfigurationIDs []*string

	// READ-ONLY; Commit Id.
	CommitID *string
}

// ManagerConnection - The Network Manager Connection resource
type ManagerConnection struct {
	// The scope connection properties
	Properties *ManagerConnectionProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// ManagerConnectionListResult - List of network manager connections.
type ManagerConnectionListResult struct {
	// Gets the URL to get the next page of results.
	NextLink *string

	// List of network manager connections.
	Value []*ManagerConnection
}

// ManagerConnectionProperties - Information about the network manager connection.
type ManagerConnectionProperties struct {
	// A description of the network manager connection.
	Description *string

	// Network Manager Id.
	NetworkManagerID *string

	// READ-ONLY; Connection state.
	ConnectionState *ScopeConnectionState
}

// ManagerDeploymentStatus - Network Manager Deployment Status.
type ManagerDeploymentStatus struct {
	// Commit Time.
	CommitTime *time.Time

	// List of configuration ids.
	ConfigurationIDs []*string

	// Deployment Status.
	DeploymentStatus *DeploymentStatus

	// Configuration Deployment Type.
	DeploymentType *ConfigurationType

	// Error Message.
	ErrorMessage *string

	// Region Name.
	Region *string
}

// ManagerDeploymentStatusListResult - A list of Network Manager Deployment Status
type ManagerDeploymentStatusListResult struct {
	// When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current
	// request) to retrieve the next page of data.
	SkipToken *string

	// Gets a page of Network Manager Deployment Status
	Value []*ManagerDeploymentStatus
}

// ManagerDeploymentStatusParameter - Network Manager Deployment Status Parameter.
type ManagerDeploymentStatusParameter struct {
	// List of deployment types.
	DeploymentTypes []*ConfigurationType

	// List of locations.
	Regions []*string

	// Continuation token for pagination, capturing the next page size and offset, as well as the context of the query.
	SkipToken *string
}

// ManagerEffectiveConnectivityConfigurationListResult - Result of the request to list networkManagerEffectiveConnectivityConfiguration.
// It contains a list of groups and a skiptoken to get the next set of results.
type ManagerEffectiveConnectivityConfigurationListResult struct {
	// When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current
	// request) to retrieve the next page of data.
	SkipToken *string

	// Gets a page of NetworkManagerEffectiveConnectivityConfiguration
	Value []*EffectiveConnectivityConfiguration
}

// ManagerEffectiveSecurityAdminRulesListResult - Result of the request to list networkManagerEffectiveSecurityAdminRules.
// It contains a list of groups and a skiptoken to get the next set of results.
type ManagerEffectiveSecurityAdminRulesListResult struct {
	// When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current
	// request) to retrieve the next page of data.
	SkipToken *string

	// Gets a page of NetworkManagerEffectiveSecurityAdminRules
	Value []EffectiveBaseSecurityAdminRuleClassification
}

// ManagerListResult - Result of the request to list NetworkManager. It contains a list of network managers and a URL link
// to get the next set of results.
type ManagerListResult struct {
	// Gets the URL to get the next page of results.
	NextLink *string

	// Gets a page of NetworkManager
	Value []*Manager
}

// ManagerProperties - Properties of Managed Network
type ManagerProperties struct {
	// REQUIRED; Scope Access.
	NetworkManagerScopeAccesses []*ConfigurationType

	// REQUIRED; Scope of Network Manager.
	NetworkManagerScopes *ManagerPropertiesNetworkManagerScopes

	// A description of the network manager.
	Description *string

	// READ-ONLY; The provisioning state of the network manager resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Unique identifier for this resource.
	ResourceGUID *string
}

// ManagerPropertiesNetworkManagerScopes - Scope of Network Manager.
type ManagerPropertiesNetworkManagerScopes struct {
	// List of management groups.
	ManagementGroups []*string

	// List of subscriptions.
	Subscriptions []*string

	// READ-ONLY; List of cross tenant scopes.
	CrossTenantScopes []*CrossTenantScopes
}

// ManagerSecurityGroupItem - Network manager security group item.
type ManagerSecurityGroupItem struct {
	// REQUIRED; Network manager group Id.
	NetworkGroupID *string
}

// MatchCondition - Define match conditions.
type MatchCondition struct {
	// REQUIRED; Match value.
	MatchValues []*string

	// REQUIRED; List of match variables.
	MatchVariables []*MatchVariable

	// REQUIRED; The operator to be matched.
	Operator *WebApplicationFirewallOperator

	// Whether this is negate condition or not.
	NegationConditon *bool

	// List of transforms.
	Transforms []*WebApplicationFirewallTransform
}

// MatchVariable - Define match variables.
type MatchVariable struct {
	// REQUIRED; Match Variable.
	VariableName *WebApplicationFirewallMatchVariable

	// The selector of match variable.
	Selector *string
}

// MatchedRule - Matched rule.
type MatchedRule struct {
	// The network traffic is allowed or denied. Possible values are 'Allow' and 'Deny'.
	Action *string

	// Name of the matched network security rule.
	RuleName *string
}

// MetricSpecification - Description of metrics specification.
type MetricSpecification struct {
	// The aggregation type.
	AggregationType *string

	// List of availability.
	Availabilities []*Availability

	// List of dimensions.
	Dimensions []*Dimension

	// The description of the metric.
	DisplayDescription *string

	// The display name of the metric.
	DisplayName *string

	// Whether regional MDM account enabled.
	EnableRegionalMdmAccount *bool

	// Whether gaps would be filled with zeros.
	FillGapWithZero *bool

	// Whether the metric is internal.
	IsInternal *bool

	// Pattern for the filter of the metric.
	MetricFilterPattern *string

	// The name of the metric.
	Name *string

	// The resource Id dimension name override.
	ResourceIDDimensionNameOverride *string

	// The source MDM account.
	SourceMdmAccount *string

	// The source MDM namespace.
	SourceMdmNamespace *string

	// Units the metric to be displayed in.
	Unit *string
}

// MigrateLoadBalancerToIPBasedRequest - The request for a migrateToIpBased API.
type MigrateLoadBalancerToIPBasedRequest struct {
	// A list of pool names that should be migrated from Nic based to IP based pool
	Pools []*string
}

// MigratedPools - The response for a migrateToIpBased API.
type MigratedPools struct {
	// A list of pools migrated from Nic based to IP based pool
	MigratedPools []*string
}

// NatGateway - Nat Gateway resource.
type NatGateway struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Nat Gateway properties.
	Properties *NatGatewayPropertiesFormat

	// The nat gateway SKU.
	SKU *NatGatewaySKU

	// Resource tags.
	Tags map[string]*string

	// A list of availability zones denoting the zone in which Nat Gateway should be deployed.
	Zones []*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// NatGatewayListResult - Response for ListNatGateways API service call.
type NatGatewayListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of Nat Gateways that exists in a resource group.
	Value []*NatGateway
}

// NatGatewayPropertiesFormat - Nat Gateway properties.
type NatGatewayPropertiesFormat struct {
	// The idle timeout of the nat gateway.
	IdleTimeoutInMinutes *int32

	// An array of public ip addresses associated with the nat gateway resource.
	PublicIPAddresses []*SubResource

	// An array of public ip prefixes associated with the nat gateway resource.
	PublicIPPrefixes []*SubResource

	// READ-ONLY; The provisioning state of the NAT gateway resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource GUID property of the NAT gateway resource.
	ResourceGUID *string

	// READ-ONLY; An array of references to the subnets using this nat gateway resource.
	Subnets []*SubResource
}

// NatGatewaySKU - SKU of nat gateway.
type NatGatewaySKU struct {
	// Name of Nat Gateway SKU.
	Name *NatGatewaySKUName
}

// NatRule - Rule of type nat.
type NatRule struct {
	// REQUIRED; Rule Type.
	RuleType *FirewallPolicyRuleType

	// Description of the rule.
	Description *string

	// List of destination IP addresses or Service Tags.
	DestinationAddresses []*string

	// List of destination ports.
	DestinationPorts []*string

	// Array of FirewallPolicyRuleNetworkProtocols.
	IPProtocols []*FirewallPolicyRuleNetworkProtocol

	// Name of the rule.
	Name *string

	// List of source IP addresses for this rule.
	SourceAddresses []*string

	// List of source IpGroups for this rule.
	SourceIPGroups []*string

	// The translated address for this NAT rule.
	TranslatedAddress *string

	// The translated FQDN for this NAT rule.
	TranslatedFqdn *string

	// The translated port for this NAT rule.
	TranslatedPort *string
}

// GetFirewallPolicyRule implements the FirewallPolicyRuleClassification interface for type NatRule.
func (n *NatRule) GetFirewallPolicyRule() *FirewallPolicyRule {
	return &FirewallPolicyRule{
		Description: n.Description,
		Name:        n.Name,
		RuleType:    n.RuleType,
	}
}

// NatRulePortMapping - Individual port mappings for inbound NAT rule created for backend pool.
type NatRulePortMapping struct {
	// Backend port.
	BackendPort *int32

	// Frontend port.
	FrontendPort *int32

	// Name of inbound NAT rule.
	InboundNatRuleName *string
}

// NextHopParameters - Parameters that define the source and destination endpoint.
type NextHopParameters struct {
	// REQUIRED; The destination IP address.
	DestinationIPAddress *string

	// REQUIRED; The source IP address.
	SourceIPAddress *string

	// REQUIRED; The resource identifier of the target resource against which the action is to be performed.
	TargetResourceID *string

	// The NIC ID. (If VM has multiple NICs and IP forwarding is enabled on any of the nics, then this parameter must be specified.
	// Otherwise optional).
	TargetNicResourceID *string
}

// NextHopResult - The information about next hop from the specified VM.
type NextHopResult struct {
	// Next hop IP Address.
	NextHopIPAddress *string

	// Next hop type.
	NextHopType *NextHopType

	// The resource identifier for the route table associated with the route being returned. If the route being returned does
	// not correspond to any user created routes then this field will be the string
	// 'System Route'.
	RouteTableID *string
}

// O365BreakOutCategoryPolicies - Office365 breakout categories.
type O365BreakOutCategoryPolicies struct {
	// Flag to control allow category.
	Allow *bool

	// Flag to control default category.
	Default *bool

	// Flag to control optimize category.
	Optimize *bool
}

// O365PolicyProperties - The Office365 breakout policy.
type O365PolicyProperties struct {
	// Office365 breakout categories.
	BreakOutCategories *O365BreakOutCategoryPolicies
}

// Office365PolicyProperties - Network Virtual Appliance Sku Properties.
type Office365PolicyProperties struct {
	// Office 365 breakout categories.
	BreakOutCategories *BreakOutCategoryPolicies
}

// Operation - Network REST API operation definition.
type Operation struct {
	// Display metadata associated with the operation.
	Display *OperationDisplay

	// Operation name: {provider}/{resource}/{operation}.
	Name *string

	// Origin of the operation.
	Origin *string

	// Operation properties format.
	Properties *OperationPropertiesFormat
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// Description of the operation.
	Description *string

	// Type of the operation: get, read, delete, etc.
	Operation *string

	// Service provider: Microsoft Network.
	Provider *string

	// Resource on which the operation is performed.
	Resource *string
}

// OperationListResult - Result of the request to list Network operations. It contains a list of operations and a URL link
// to get the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of Network operations supported by the Network resource provider.
	Value []*Operation
}

// OperationPropertiesFormat - Description of operation properties format.
type OperationPropertiesFormat struct {
	// Specification of the service.
	ServiceSpecification *OperationPropertiesFormatServiceSpecification
}

// OperationPropertiesFormatServiceSpecification - Specification of the service.
type OperationPropertiesFormatServiceSpecification struct {
	// Operation log specification.
	LogSpecifications []*LogSpecification

	// Operation service specification.
	MetricSpecifications []*MetricSpecification
}

// OrderBy - Describes a column to sort
type OrderBy struct {
	// Describes the actual column name to sort by
	Field *string

	// Describes if results should be in ascending/descending order
	Order *FirewallPolicyIDPSQuerySortOrder
}

// OutboundRule - Outbound rule of the load balancer.
type OutboundRule struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within the set of outbound rules used by the load balancer. This name can be used
	// to access the resource.
	Name *string

	// Properties of load balancer outbound rule.
	Properties *OutboundRulePropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// OutboundRulePropertiesFormat - Outbound rule of the load balancer.
type OutboundRulePropertiesFormat struct {
	// REQUIRED; A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs.
	BackendAddressPool *SubResource

	// REQUIRED; The Frontend IP addresses of the load balancer.
	FrontendIPConfigurations []*SubResource

	// REQUIRED; The protocol for the outbound rule in load balancer.
	Protocol *LoadBalancerOutboundRuleProtocol

	// The number of outbound ports to be used for NAT.
	AllocatedOutboundPorts *int32

	// Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used
	// when the protocol is set to TCP.
	EnableTCPReset *bool

	// The timeout for the TCP idle connection.
	IdleTimeoutInMinutes *int32

	// READ-ONLY; The provisioning state of the outbound rule resource.
	ProvisioningState *ProvisioningState
}

// OwaspCrsExclusionEntry - Allow to exclude some variable satisfy the condition for the WAF check.
type OwaspCrsExclusionEntry struct {
	// REQUIRED; The variable to be excluded.
	MatchVariable *OwaspCrsExclusionEntryMatchVariable

	// REQUIRED; When matchVariable is a collection, operator used to specify which elements in the collection this exclusion
	// applies to.
	Selector *string

	// REQUIRED; When matchVariable is a collection, operate on the selector to specify which elements in the collection this
	// exclusion applies to.
	SelectorMatchOperator *OwaspCrsExclusionEntrySelectorMatchOperator

	// The managed rule sets that are associated with the exclusion.
	ExclusionManagedRuleSets []*ExclusionManagedRuleSet
}

// P2SConnectionConfiguration Resource.
type P2SConnectionConfiguration struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the P2S connection configuration.
	Properties *P2SConnectionConfigurationProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// P2SConnectionConfigurationProperties - Parameters for P2SConnectionConfiguration.
type P2SConnectionConfigurationProperties struct {
	// Flag indicating whether the enable internet security flag is turned on for the P2S Connections or not.
	EnableInternetSecurity *bool

	// The Routing Configuration indicating the associated and propagated route tables on this connection.
	RoutingConfiguration *RoutingConfiguration

	// The reference to the address space resource which represents Address space for P2S VpnClient.
	VPNClientAddressPool *AddressSpace

	// READ-ONLY; List of Configuration Policy Groups that this P2SConnectionConfiguration is attached to.
	ConfigurationPolicyGroupAssociations []*SubResource

	// READ-ONLY; List of previous Configuration Policy Groups that this P2SConnectionConfiguration was attached to.
	PreviousConfigurationPolicyGroupAssociations []*VPNServerConfigurationPolicyGroup

	// READ-ONLY; The provisioning state of the P2SConnectionConfiguration resource.
	ProvisioningState *ProvisioningState
}

// P2SVPNConnectionHealth - P2S Vpn connection detailed health written to sas url.
type P2SVPNConnectionHealth struct {
	// Returned sas url of the blob to which the p2s vpn connection detailed health will be written.
	SasURL *string
}

// P2SVPNConnectionHealthRequest - List of P2S Vpn connection health request.
type P2SVPNConnectionHealthRequest struct {
	// The sas-url to download the P2S Vpn connection health detail.
	OutputBlobSasURL *string

	// The list of p2s vpn user names whose p2s vpn connection detailed health to retrieve for.
	VPNUserNamesFilter []*string
}

// P2SVPNConnectionRequest - List of p2s vpn connections to be disconnected.
type P2SVPNConnectionRequest struct {
	// List of p2s vpn connection Ids.
	VPNConnectionIDs []*string
}

// P2SVPNGateway - P2SVpnGateway Resource.
type P2SVPNGateway struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the P2SVpnGateway.
	Properties *P2SVPNGatewayProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// P2SVPNGatewayProperties - Parameters for P2SVpnGateway.
type P2SVPNGatewayProperties struct {
	// List of all customer specified DNS servers IP addresses.
	CustomDNSServers []*string

	// Enable Routing Preference property for the Public IP Interface of the P2SVpnGateway.
	IsRoutingPreferenceInternet *bool

	// List of all p2s connection configurations of the gateway.
	P2SConnectionConfigurations []*P2SConnectionConfiguration

	// The scale unit for this p2s vpn gateway.
	VPNGatewayScaleUnit *int32

	// The VpnServerConfiguration to which the p2sVpnGateway is attached to.
	VPNServerConfiguration *SubResource

	// The VirtualHub to which the gateway belongs.
	VirtualHub *SubResource

	// READ-ONLY; The provisioning state of the P2S VPN gateway resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; All P2S VPN clients' connection health status.
	VPNClientConnectionHealth *VPNClientConnectionHealth
}

// P2SVPNProfileParameters - Vpn Client Parameters for package generation.
type P2SVPNProfileParameters struct {
	// VPN client authentication method.
	AuthenticationMethod *AuthenticationMethod
}

// PacketCapture - Parameters that define the create packet capture operation.
type PacketCapture struct {
	// REQUIRED; Properties of the packet capture.
	Properties *PacketCaptureParameters
}

// PacketCaptureFilter - Filter that is applied to packet capture request. Multiple filters can be applied.
type PacketCaptureFilter struct {
	// Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range.
	// "127.0.0.1;127.0.0.5"? for multiple entries. Multiple ranges not currently
	// supported. Mixing ranges with multiple entries not currently supported. Default = null.
	LocalIPAddress *string

	// Local port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple
	// ranges not currently supported. Mixing ranges with multiple entries not
	// currently supported. Default = null.
	LocalPort *string

	// Protocol to be filtered on.
	Protocol *PcProtocol

	// Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range.
	// "127.0.0.1;127.0.0.5;" for multiple entries. Multiple ranges not currently
	// supported. Mixing ranges with multiple entries not currently supported. Default = null.
	RemoteIPAddress *string

	// Remote port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries.
	// Multiple ranges not currently supported. Mixing ranges with multiple entries not
	// currently supported. Default = null.
	RemotePort *string
}

// PacketCaptureListResult - List of packet capture sessions.
type PacketCaptureListResult struct {
	// Information about packet capture sessions.
	Value []*PacketCaptureResult
}

// PacketCaptureMachineScope - A list of AzureVMSS instances which can be included or excluded to run packet capture. If both
// included and excluded are empty, then the packet capture will run on all instances of AzureVMSS.
type PacketCaptureMachineScope struct {
	// List of AzureVMSS instances which has to be excluded from the AzureVMSS from running packet capture.
	Exclude []*string

	// List of AzureVMSS instances to run packet capture on.
	Include []*string
}

// PacketCaptureParameters - Parameters that define the create packet capture operation.
type PacketCaptureParameters struct {
	// REQUIRED; The storage location for a packet capture session.
	StorageLocation *PacketCaptureStorageLocation

	// REQUIRED; The ID of the targeted resource, only AzureVM and AzureVMSS as target type are currently supported.
	Target *string

	// Number of bytes captured per packet, the remaining bytes are truncated.
	BytesToCapturePerPacket *int64

	// A list of packet capture filters.
	Filters []*PacketCaptureFilter

	// A list of AzureVMSS instances which can be included or excluded to run packet capture. If both included and excluded are
	// empty, then the packet capture will run on all instances of AzureVMSS.
	Scope *PacketCaptureMachineScope

	// Target type of the resource provided.
	TargetType *PacketCaptureTargetType

	// Maximum duration of the capture session in seconds.
	TimeLimitInSeconds *int32

	// Maximum size of the capture output.
	TotalBytesPerSession *int64
}

// PacketCaptureQueryStatusResult - Status of packet capture session.
type PacketCaptureQueryStatusResult struct {
	// The start time of the packet capture session.
	CaptureStartTime *time.Time

	// The ID of the packet capture resource.
	ID *string

	// The name of the packet capture resource.
	Name *string

	// List of errors of packet capture session.
	PacketCaptureError []*PcError

	// The status of the packet capture session.
	PacketCaptureStatus *PcStatus

	// The reason the current packet capture session was stopped.
	StopReason *string
}

// PacketCaptureResult - Information about packet capture session.
type PacketCaptureResult struct {
	// Properties of the packet capture result.
	Properties *PacketCaptureResultProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; ID of the packet capture operation.
	ID *string

	// READ-ONLY; Name of the packet capture session.
	Name *string
}

// PacketCaptureResultProperties - The properties of a packet capture session.
type PacketCaptureResultProperties struct {
	// REQUIRED; The storage location for a packet capture session.
	StorageLocation *PacketCaptureStorageLocation

	// REQUIRED; The ID of the targeted resource, only AzureVM and AzureVMSS as target type are currently supported.
	Target *string

	// Number of bytes captured per packet, the remaining bytes are truncated.
	BytesToCapturePerPacket *int64

	// A list of packet capture filters.
	Filters []*PacketCaptureFilter

	// A list of AzureVMSS instances which can be included or excluded to run packet capture. If both included and excluded are
	// empty, then the packet capture will run on all instances of AzureVMSS.
	Scope *PacketCaptureMachineScope

	// Target type of the resource provided.
	TargetType *PacketCaptureTargetType

	// Maximum duration of the capture session in seconds.
	TimeLimitInSeconds *int32

	// Maximum size of the capture output.
	TotalBytesPerSession *int64

	// READ-ONLY; The provisioning state of the packet capture session.
	ProvisioningState *ProvisioningState
}

// PacketCaptureStorageLocation - The storage location for a packet capture session.
type PacketCaptureStorageLocation struct {
	// A valid local path on the targeting VM. Must include the name of the capture file (*.cap). For linux virtual machine it
	// must start with /var/captures. Required if no storage ID is provided, otherwise
	// optional.
	FilePath *string

	// The ID of the storage account to save the packet capture session. Required if no local file path is provided.
	StorageID *string

	// The URI of the storage path to save the packet capture. Must be a well-formed URI describing the location to save the packet
	// capture.
	StoragePath *string
}

// Parameters for an Action.
type Parameter struct {
	// List of AS paths.
	AsPath []*string

	// List of BGP communities.
	Community []*string

	// List of route prefixes.
	RoutePrefix []*string
}

// PartnerManagedResourceProperties - Properties of the partner managed resource.
type PartnerManagedResourceProperties struct {
	// READ-ONLY; The partner managed resource id.
	ID *string

	// READ-ONLY; The partner managed ILB resource id
	InternalLoadBalancerID *string

	// READ-ONLY; The partner managed SLB resource id
	StandardLoadBalancerID *string
}

// PatchObject - Object for patch operations.
type PatchObject struct {
	// Resource tags.
	Tags map[string]*string
}

// PatchRouteFilter - Route Filter Resource.
type PatchRouteFilter struct {
	// Resource ID.
	ID *string

	// Properties of the route filter.
	Properties *RouteFilterPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// PatchRouteFilterRule - Route Filter Rule Resource.
type PatchRouteFilterRule struct {
	// Resource ID.
	ID *string

	// Properties of the route filter rule.
	Properties *RouteFilterRulePropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string
}

// PeerExpressRouteCircuitConnection - Peer Express Route Circuit Connection in an ExpressRouteCircuitPeering resource.
type PeerExpressRouteCircuitConnection struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the peer express route circuit connection.
	Properties *PeerExpressRouteCircuitConnectionPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// PeerExpressRouteCircuitConnectionListResult - Response for ListPeeredConnections API service call retrieves all global
// reach peer circuit connections that belongs to a Private Peering for an ExpressRouteCircuit.
type PeerExpressRouteCircuitConnectionListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The global reach peer circuit connection associated with Private Peering in an ExpressRoute Circuit.
	Value []*PeerExpressRouteCircuitConnection
}

// PeerExpressRouteCircuitConnectionPropertiesFormat - Properties of the peer express route circuit connection.
type PeerExpressRouteCircuitConnectionPropertiesFormat struct {
	// /29 IP address space to carve out Customer addresses for tunnels.
	AddressPrefix *string

	// The resource guid of the authorization used for the express route circuit connection.
	AuthResourceGUID *string

	// The name of the express route circuit connection resource.
	ConnectionName *string

	// Reference to Express Route Circuit Private Peering Resource of the circuit.
	ExpressRouteCircuitPeering *SubResource

	// Reference to Express Route Circuit Private Peering Resource of the peered circuit.
	PeerExpressRouteCircuitPeering *SubResource

	// READ-ONLY; Express Route Circuit connection state.
	CircuitConnectionStatus *CircuitConnectionStatus

	// READ-ONLY; The provisioning state of the peer express route circuit connection resource.
	ProvisioningState *ProvisioningState
}

// PeerRoute - Peer routing details.
type PeerRoute struct {
	// READ-ONLY; The route's AS path sequence.
	AsPath *string

	// READ-ONLY; The peer's local address.
	LocalAddress *string

	// READ-ONLY; The route's network prefix.
	Network *string

	// READ-ONLY; The route's next hop.
	NextHop *string

	// READ-ONLY; The source this route was learned from.
	Origin *string

	// READ-ONLY; The peer this route was learned from.
	SourcePeer *string

	// READ-ONLY; The route's weight.
	Weight *int32
}

// PolicySettings - Defines contents of a web application firewall global configuration.
type PolicySettings struct {
	// If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
	CustomBlockResponseBody *string

	// If the action type is block, customer can override the response status code.
	CustomBlockResponseStatusCode *int32

	// Whether allow WAF to enforce file upload limits.
	FileUploadEnforcement *bool

	// Maximum file upload size in Mb for WAF.
	FileUploadLimitInMb *int32

	// To scrub sensitive log fields
	LogScrubbing *PolicySettingsLogScrubbing

	// Maximum request body size in Kb for WAF.
	MaxRequestBodySizeInKb *int32

	// The mode of the policy.
	Mode *WebApplicationFirewallMode

	// Whether to allow WAF to check request Body.
	RequestBodyCheck *bool

	// Whether allow WAF to enforce request body limits.
	RequestBodyEnforcement *bool

	// Max inspection limit in KB for request body inspection for WAF.
	RequestBodyInspectLimitInKB *int32

	// The state of the policy.
	State *WebApplicationFirewallEnabledState
}

// PolicySettingsLogScrubbing - To scrub sensitive log fields
type PolicySettingsLogScrubbing struct {
	// The rules that are applied to the logs for scrubbing.
	ScrubbingRules []*WebApplicationFirewallScrubbingRules

	// State of the log scrubbing config. Default value is Enabled.
	State *WebApplicationFirewallScrubbingState
}

// PrepareNetworkPoliciesRequest - Details of PrepareNetworkPolicies for Subnet.
type PrepareNetworkPoliciesRequest struct {
	// A list of NetworkIntentPolicyConfiguration.
	NetworkIntentPolicyConfigurations []*IntentPolicyConfiguration

	// The name of the service for which subnet is being prepared for.
	ServiceName *string
}

// PrivateDNSZoneConfig - PrivateDnsZoneConfig resource.
type PrivateDNSZoneConfig struct {
	// Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the private dns zone configuration.
	Properties *PrivateDNSZonePropertiesFormat
}

// PrivateDNSZoneGroup - Private dns zone group resource.
type PrivateDNSZoneGroup struct {
	// Resource ID.
	ID *string

	// Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the private dns zone group.
	Properties *PrivateDNSZoneGroupPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// PrivateDNSZoneGroupListResult - Response for the ListPrivateDnsZoneGroups API service call.
type PrivateDNSZoneGroupListResult struct {
	// A list of private dns zone group resources in a private endpoint.
	Value []*PrivateDNSZoneGroup

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// PrivateDNSZoneGroupPropertiesFormat - Properties of the private dns zone group.
type PrivateDNSZoneGroupPropertiesFormat struct {
	// A collection of private dns zone configurations of the private dns zone group.
	PrivateDNSZoneConfigs []*PrivateDNSZoneConfig

	// READ-ONLY; The provisioning state of the private dns zone group resource.
	ProvisioningState *ProvisioningState
}

// PrivateDNSZonePropertiesFormat - Properties of the private dns zone configuration resource.
type PrivateDNSZonePropertiesFormat struct {
	// The resource id of the private dns zone.
	PrivateDNSZoneID *string

	// READ-ONLY; A collection of information regarding a recordSet, holding information to identify private resources.
	RecordSets []*RecordSet
}

// PrivateEndpoint - Private endpoint resource.
type PrivateEndpoint struct {
	// The extended location of the load balancer.
	ExtendedLocation *ExtendedLocation

	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the private endpoint.
	Properties *PrivateEndpointProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// PrivateEndpointConnection resource.
type PrivateEndpointConnection struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the private end point connection.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; The resource type.
	Type *string
}

// PrivateEndpointConnectionListResult - Response for the ListPrivateEndpointConnection API service call.
type PrivateEndpointConnectionListResult struct {
	// A list of PrivateEndpointConnection resources for a specific private link service.
	Value []*PrivateEndpointConnection

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// READ-ONLY; The consumer link id.
	LinkIdentifier *string

	// READ-ONLY; The resource of private end point.
	PrivateEndpoint *PrivateEndpoint

	// READ-ONLY; The location of the private endpoint.
	PrivateEndpointLocation *string

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *ProvisioningState
}

// PrivateEndpointIPConfiguration - An IP Configuration of the private endpoint.
type PrivateEndpointIPConfiguration struct {
	// The name of the resource that is unique within a resource group.
	Name *string

	// Properties of private endpoint IP configurations.
	Properties *PrivateEndpointIPConfigurationProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; The resource type.
	Type *string
}

// PrivateEndpointIPConfigurationProperties - Properties of an IP Configuration of the private endpoint.
type PrivateEndpointIPConfigurationProperties struct {
	// The ID of a group obtained from the remote resource that this private endpoint should connect to.
	GroupID *string

	// The member name of a group obtained from the remote resource that this private endpoint should connect to.
	MemberName *string

	// A private ip address obtained from the private endpoint's subnet.
	PrivateIPAddress *string
}

// PrivateEndpointListResult - Response for the ListPrivateEndpoints API service call.
type PrivateEndpointListResult struct {
	// A list of private endpoint resources in a resource group.
	Value []*PrivateEndpoint

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// PrivateEndpointProperties - Properties of the private endpoint.
type PrivateEndpointProperties struct {
	// Application security groups in which the private endpoint IP configuration is included.
	ApplicationSecurityGroups []*ApplicationSecurityGroup

	// An array of custom dns configurations.
	CustomDNSConfigs []*CustomDNSConfigPropertiesFormat

	// The custom name of the network interface attached to the private endpoint.
	CustomNetworkInterfaceName *string

	// A list of IP configurations of the private endpoint. This will be used to map to the First Party Service's endpoints.
	IPConfigurations []*PrivateEndpointIPConfiguration

	// A grouping of information about the connection to the remote resource. Used when the network admin does not have access
	// to approve connections to the remote resource.
	ManualPrivateLinkServiceConnections []*PrivateLinkServiceConnection

	// A grouping of information about the connection to the remote resource.
	PrivateLinkServiceConnections []*PrivateLinkServiceConnection

	// The ID of the subnet from which the private IP will be allocated.
	Subnet *Subnet

	// READ-ONLY; An array of references to the network interfaces created for this private endpoint.
	NetworkInterfaces []*Interface

	// READ-ONLY; The provisioning state of the private endpoint resource.
	ProvisioningState *ProvisioningState
}

// PrivateLinkService - Private link service resource.
type PrivateLinkService struct {
	// The extended location of the load balancer.
	ExtendedLocation *ExtendedLocation

	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the private link service.
	Properties *PrivateLinkServiceProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// PrivateLinkServiceConnection resource.
type PrivateLinkServiceConnection struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the private link service connection.
	Properties *PrivateLinkServiceConnectionProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; The resource type.
	Type *string
}

// PrivateLinkServiceConnectionProperties - Properties of the PrivateLinkServiceConnection.
type PrivateLinkServiceConnectionProperties struct {
	// The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to.
	GroupIDs []*string

	// A collection of read-only information about the state of the connection to the remote resource.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// The resource id of private link service.
	PrivateLinkServiceID *string

	// A message passed to the owner of the remote resource with this connection request. Restricted to 140 chars.
	RequestMessage *string

	// READ-ONLY; The provisioning state of the private link service connection resource.
	ProvisioningState *ProvisioningState
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string

	// The reason for approval/rejection of the connection.
	Description *string

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *string
}

// PrivateLinkServiceIPConfiguration - The private link service ip configuration.
type PrivateLinkServiceIPConfiguration struct {
	// Resource ID.
	ID *string

	// The name of private link service ip configuration.
	Name *string

	// Properties of the private link service ip configuration.
	Properties *PrivateLinkServiceIPConfigurationProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; The resource type.
	Type *string
}

// PrivateLinkServiceIPConfigurationProperties - Properties of private link service IP configuration.
type PrivateLinkServiceIPConfigurationProperties struct {
	// Whether the ip configuration is primary or not.
	Primary *bool

	// The private IP address of the IP configuration.
	PrivateIPAddress *string

	// Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
	PrivateIPAddressVersion *IPVersion

	// The private IP address allocation method.
	PrivateIPAllocationMethod *IPAllocationMethod

	// The reference to the subnet resource.
	Subnet *Subnet

	// READ-ONLY; The provisioning state of the private link service IP configuration resource.
	ProvisioningState *ProvisioningState
}

// PrivateLinkServiceListResult - Response for the ListPrivateLinkService API service call.
type PrivateLinkServiceListResult struct {
	// A list of PrivateLinkService resources in a resource group.
	Value []*PrivateLinkService

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// PrivateLinkServiceProperties - Properties of the private link service.
type PrivateLinkServiceProperties struct {
	// The auto-approval list of the private link service.
	AutoApproval *PrivateLinkServicePropertiesAutoApproval

	// Whether the private link service is enabled for proxy protocol or not.
	EnableProxyProtocol *bool

	// The list of Fqdn.
	Fqdns []*string

	// An array of private link service IP configurations.
	IPConfigurations []*PrivateLinkServiceIPConfiguration

	// An array of references to the load balancer IP configurations.
	LoadBalancerFrontendIPConfigurations []*FrontendIPConfiguration

	// The visibility list of the private link service.
	Visibility *PrivateLinkServicePropertiesVisibility

	// READ-ONLY; The alias of the private link service.
	Alias *string

	// READ-ONLY; An array of references to the network interfaces created for this private link service.
	NetworkInterfaces []*Interface

	// READ-ONLY; An array of list about connections to the private endpoint.
	PrivateEndpointConnections []*PrivateEndpointConnection

	// READ-ONLY; The provisioning state of the private link service resource.
	ProvisioningState *ProvisioningState
}

// PrivateLinkServicePropertiesAutoApproval - The auto-approval list of the private link service.
type PrivateLinkServicePropertiesAutoApproval struct {
	// The list of subscriptions.
	Subscriptions []*string
}

// PrivateLinkServicePropertiesVisibility - The visibility list of the private link service.
type PrivateLinkServicePropertiesVisibility struct {
	// The list of subscriptions.
	Subscriptions []*string
}

// PrivateLinkServiceVisibility - Response for the CheckPrivateLinkServiceVisibility API service call.
type PrivateLinkServiceVisibility struct {
	// Private Link Service Visibility (True/False).
	Visible *bool
}

// Probe - A load balancer probe.
type Probe struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within the set of probes used by the load balancer. This name can be used to access
	// the resource.
	Name *string

	// Properties of load balancer probe.
	Properties *ProbePropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Type of the resource.
	Type *string
}

// ProbePropertiesFormat - Load balancer probe resource.
type ProbePropertiesFormat struct {
	// REQUIRED; The port for communicating the probe. Possible values range from 1 to 65535, inclusive.
	Port *int32

	// REQUIRED; The protocol of the end point. If 'Tcp' is specified, a received ACK is required for the probe to be successful.
	// If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required
	// for the probe to be successful.
	Protocol *ProbeProtocol

	// The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly
	// less than half the allocated timeout period (in seconds) which allows two full
	// probes before taking the instance out of rotation. The default value is 15, the minimum value is 5.
	IntervalInSeconds *int32

	// The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint.
	// This values allows endpoints to be taken out of rotation faster or slower than
	// the typical times used in Azure.
	NumberOfProbes *int32

	// The number of consecutive successful or failed probes in order to allow or deny traffic from being delivered to this endpoint.
	// After failing the number of consecutive probes equal to this value, the
	// endpoint will be taken out of rotation and require the same number of successful consecutive probes to be placed back in
	// rotation.
	ProbeThreshold *int32

	// The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is
	// not allowed. There is no default value.
	RequestPath *string

	// READ-ONLY; The load balancer rules that use this probe.
	LoadBalancingRules []*SubResource

	// READ-ONLY; The provisioning state of the probe resource.
	ProvisioningState *ProvisioningState
}

// Profile - Network profile resource.
type Profile struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Network profile properties.
	Properties *ProfilePropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ProfileListResult - Response for ListNetworkProfiles API service call.
type ProfileListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of network profiles that exist in a resource group.
	Value []*Profile
}

// ProfilePropertiesFormat - Network profile properties.
type ProfilePropertiesFormat struct {
	// List of chid container network interface configurations.
	ContainerNetworkInterfaceConfigurations []*ContainerNetworkInterfaceConfiguration

	// READ-ONLY; List of child container network interfaces.
	ContainerNetworkInterfaces []*ContainerNetworkInterface

	// READ-ONLY; The provisioning state of the network profile resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource GUID property of the network profile resource.
	ResourceGUID *string
}

// PropagatedRouteTable - The list of RouteTables to advertise the routes to.
type PropagatedRouteTable struct {
	// The list of resource ids of all the RouteTables.
	IDs []*SubResource

	// The list of labels.
	Labels []*string
}

// ProtocolConfiguration - Configuration of the protocol.
type ProtocolConfiguration struct {
	// HTTP configuration of the connectivity check.
	HTTPConfiguration *HTTPConfiguration
}

// PublicIPAddress - Public IP address resource.
type PublicIPAddress struct {
	// The extended location of the public ip address.
	ExtendedLocation *ExtendedLocation

	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Public IP address properties.
	Properties *PublicIPAddressPropertiesFormat

	// The public IP address SKU.
	SKU *PublicIPAddressSKU

	// Resource tags.
	Tags map[string]*string

	// A list of availability zones denoting the IP allocated for the resource needs to come from.
	Zones []*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// PublicIPAddressDNSSettings - Contains FQDN of the DNS record associated with the public IP address.
type PublicIPAddressDNSSettings struct {
	// The domain name label. The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified
	// domain name associated with the public IP address. If a domain name label is
	// specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
	DomainNameLabel *string

	// The domain name label scope. If a domain name label and a domain name label scope are specified, an A DNS record is created
	// for the public IP in the Microsoft Azure DNS system with a hashed value
	// includes in FQDN.
	DomainNameLabelScope *PublicIPAddressDNSSettingsDomainNameLabelScope

	// The Fully Qualified Domain Name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel
	// and the regionalized DNS zone.
	Fqdn *string

	// The reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn
	// is specified, then a PTR DNS record is created pointing from the IP address in
	// the in-addr.arpa domain to the reverse FQDN.
	ReverseFqdn *string
}

// PublicIPAddressListResult - Response for ListPublicIpAddresses API service call.
type PublicIPAddressListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of public IP addresses that exists in a resource group.
	Value []*PublicIPAddress
}

// PublicIPAddressPropertiesFormat - Public IP address properties.
type PublicIPAddressPropertiesFormat struct {
	// The FQDN of the DNS record associated with the public IP address.
	DNSSettings *PublicIPAddressDNSSettings

	// The DDoS protection custom policy associated with the public IP address.
	DdosSettings *DdosSettings

	// Specify what happens to the public IP address when the VM using it is deleted
	DeleteOption *DeleteOptions

	// The IP address associated with the public IP address resource.
	IPAddress *string

	// The list of tags associated with the public IP address.
	IPTags []*IPTag

	// The idle timeout of the public IP address.
	IdleTimeoutInMinutes *int32

	// The linked public IP address of the public IP address resource.
	LinkedPublicIPAddress *PublicIPAddress

	// Migration phase of Public IP Address.
	MigrationPhase *PublicIPAddressMigrationPhase

	// The NatGateway for the Public IP address.
	NatGateway *NatGateway

	// The public IP address version.
	PublicIPAddressVersion *IPVersion

	// The public IP address allocation method.
	PublicIPAllocationMethod *IPAllocationMethod

	// The Public IP Prefix this Public IP Address should be allocated from.
	PublicIPPrefix *SubResource

	// The service public IP address of the public IP address resource.
	ServicePublicIPAddress *PublicIPAddress

	// READ-ONLY; The IP configuration associated with the public IP address.
	IPConfiguration *IPConfiguration

	// READ-ONLY; The provisioning state of the public IP address resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource GUID property of the public IP address resource.
	ResourceGUID *string
}

// PublicIPAddressSKU - SKU of a public IP address.
type PublicIPAddressSKU struct {
	// Name of a public IP address SKU.
	Name *PublicIPAddressSKUName

	// Tier of a public IP address SKU.
	Tier *PublicIPAddressSKUTier
}

// PublicIPDdosProtectionStatusResult - Response for GetPublicIpAddressDdosProtectionStatusOperation API service call.
type PublicIPDdosProtectionStatusResult struct {
	// DDoS protection plan Resource Id of a if IP address is protected through a plan.
	DdosProtectionPlanID *string

	// Value indicating whether the IP address is DDoS workload protected or not.
	IsWorkloadProtected *IsWorkloadProtected

	// IP Address of the Public IP Resource
	PublicIPAddress *string

	// Public IP ARM resource ID
	PublicIPAddressID *string
}

// PublicIPPrefix - Public IP prefix resource.
type PublicIPPrefix struct {
	// The extended location of the public ip address.
	ExtendedLocation *ExtendedLocation

	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Public IP prefix properties.
	Properties *PublicIPPrefixPropertiesFormat

	// The public IP prefix SKU.
	SKU *PublicIPPrefixSKU

	// Resource tags.
	Tags map[string]*string

	// A list of availability zones denoting the IP allocated for the resource needs to come from.
	Zones []*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// PublicIPPrefixListResult - Response for ListPublicIpPrefixes API service call.
type PublicIPPrefixListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of public IP prefixes that exists in a resource group.
	Value []*PublicIPPrefix
}

// PublicIPPrefixPropertiesFormat - Public IP prefix properties.
type PublicIPPrefixPropertiesFormat struct {
	// The customIpPrefix that this prefix is associated with.
	CustomIPPrefix *SubResource

	// The list of tags associated with the public IP prefix.
	IPTags []*IPTag

	// NatGateway of Public IP Prefix.
	NatGateway *NatGateway

	// The Length of the Public IP Prefix.
	PrefixLength *int32

	// The public IP address version.
	PublicIPAddressVersion *IPVersion

	// READ-ONLY; The allocated Prefix.
	IPPrefix *string

	// READ-ONLY; The reference to load balancer frontend IP configuration associated with the public IP prefix.
	LoadBalancerFrontendIPConfiguration *SubResource

	// READ-ONLY; The provisioning state of the public IP prefix resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The list of all referenced PublicIPAddresses.
	PublicIPAddresses []*ReferencedPublicIPAddress

	// READ-ONLY; The resource GUID property of the public IP prefix resource.
	ResourceGUID *string
}

// PublicIPPrefixSKU - SKU of a public IP prefix.
type PublicIPPrefixSKU struct {
	// Name of a public IP prefix SKU.
	Name *PublicIPPrefixSKUName

	// Tier of a public IP prefix SKU.
	Tier *PublicIPPrefixSKUTier
}

// QosDefinition - Quality of Service defines the traffic configuration between endpoints. Mandatory to have one marking.
type QosDefinition struct {
	// Destination IP ranges.
	DestinationIPRanges []*QosIPRange

	// Destination port ranges.
	DestinationPortRanges []*QosPortRange

	// List of markings to be used in the configuration.
	Markings []*int32

	// RNM supported protocol types.
	Protocol *ProtocolType

	// Source IP ranges.
	SourceIPRanges []*QosIPRange

	// Sources port ranges.
	SourcePortRanges []*QosPortRange
}

// QosIPRange - Qos Traffic Profiler IP Range properties.
type QosIPRange struct {
	// End IP Address.
	EndIP *string

	// Start IP Address.
	StartIP *string
}

// QosPortRange - Qos Traffic Profiler Port range properties.
type QosPortRange struct {
	// Qos Port Range end.
	End *int32

	// Qos Port Range start.
	Start *int32
}

// QueryInboundNatRulePortMappingRequest - The request for a QueryInboundNatRulePortMapping API. Either IpConfiguration or
// IpAddress should be set
type QueryInboundNatRulePortMappingRequest struct {
	// IP address set in load balancer backend address.
	IPAddress *string

	// NetworkInterfaceIPConfiguration set in load balancer backend address.
	IPConfiguration *SubResource
}

// QueryRequestOptions - Query Request Options
type QueryRequestOptions struct {
	// When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current
	// request) to retrieve the next page of data.
	SkipToken *string
}

// QueryResults - Query result
type QueryResults struct {
	// Number of total records matching the query.
	MatchingRecordsCount *int64

	// Array containing the results of the query
	Signatures []*SingleQueryResult
}

// QueryTroubleshootingParameters - Parameters that define the resource to query the troubleshooting result.
type QueryTroubleshootingParameters struct {
	// REQUIRED; The target resource ID to query the troubleshooting result.
	TargetResourceID *string
}

// RadiusServer - Radius Server Settings.
type RadiusServer struct {
	// REQUIRED; The address of this radius server.
	RadiusServerAddress *string

	// The initial score assigned to this radius server.
	RadiusServerScore *int64

	// The secret used for this radius server.
	RadiusServerSecret *string
}

// RecordSet - A collective group of information about the record set information.
type RecordSet struct {
	// Fqdn that resolves to private endpoint ip address.
	Fqdn *string

	// The private ip address of the private endpoint.
	IPAddresses []*string

	// Recordset name.
	RecordSetName *string

	// Resource record type.
	RecordType *string

	// Recordset time to live.
	TTL *int32

	// READ-ONLY; The provisioning state of the recordset.
	ProvisioningState *ProvisioningState
}

// ReferencedPublicIPAddress - Reference to a public IP address.
type ReferencedPublicIPAddress struct {
	// The PublicIPAddress Reference.
	ID *string
}

// Resource - Common resource representation.
type Resource struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ResourceNavigationLink resource.
type ResourceNavigationLink struct {
	// Resource ID.
	ID *string

	// Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Resource navigation link properties format.
	Properties *ResourceNavigationLinkFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource type.
	Type *string
}

// ResourceNavigationLinkFormat - Properties of ResourceNavigationLink.
type ResourceNavigationLinkFormat struct {
	// Link to the external resource.
	Link *string

	// Resource type of the linked resource.
	LinkedResourceType *string

	// READ-ONLY; The provisioning state of the resource navigation link resource.
	ProvisioningState *ProvisioningState
}

// ResourceNavigationLinksListResult - Response for ResourceNavigationLinks_List operation.
type ResourceNavigationLinksListResult struct {
	// The resource navigation links in a subnet.
	Value []*ResourceNavigationLink

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// ResourceSet - The base resource set for visibility and auto-approval.
type ResourceSet struct {
	// The list of subscriptions.
	Subscriptions []*string
}

// RetentionPolicyParameters - Parameters that define the retention policy for flow log.
type RetentionPolicyParameters struct {
	// Number of days to retain flow log records.
	Days *int32

	// Flag to enable/disable retention.
	Enabled *bool
}

// Route resource.
type Route struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the route.
	Properties *RoutePropertiesFormat

	// The type of the resource.
	Type *string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// RouteFilter - Route Filter Resource.
type RouteFilter struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the route filter.
	Properties *RouteFilterPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// RouteFilterListResult - Response for the ListRouteFilters API service call.
type RouteFilterListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of route filters in a resource group.
	Value []*RouteFilter
}

// RouteFilterPropertiesFormat - Route Filter Resource.
type RouteFilterPropertiesFormat struct {
	// Collection of RouteFilterRules contained within a route filter.
	Rules []*RouteFilterRule

	// READ-ONLY; A collection of references to express route circuit ipv6 peerings.
	IPv6Peerings []*ExpressRouteCircuitPeering

	// READ-ONLY; A collection of references to express route circuit peerings.
	Peerings []*ExpressRouteCircuitPeering

	// READ-ONLY; The provisioning state of the route filter resource.
	ProvisioningState *ProvisioningState
}

// RouteFilterRule - Route Filter Rule Resource.
type RouteFilterRule struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the route filter rule.
	Properties *RouteFilterRulePropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// RouteFilterRuleListResult - Response for the ListRouteFilterRules API service call.
type RouteFilterRuleListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of RouteFilterRules in a resource group.
	Value []*RouteFilterRule
}

// RouteFilterRulePropertiesFormat - Route Filter Rule Resource.
type RouteFilterRulePropertiesFormat struct {
	// REQUIRED; The access type of the rule.
	Access *Access

	// REQUIRED; The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020'].
	Communities []*string

	// REQUIRED; The rule type of the rule.
	RouteFilterRuleType *RouteFilterRuleType

	// READ-ONLY; The provisioning state of the route filter rule resource.
	ProvisioningState *ProvisioningState
}

// RouteListResult - Response for the ListRoute API service call.
type RouteListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of routes in a resource group.
	Value []*Route
}

// RouteMap - The RouteMap child resource of a Virtual hub.
type RouteMap struct {
	// Resource ID.
	ID *string

	// Properties of the RouteMap resource.
	Properties *RouteMapProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// RouteMapProperties - Properties of RouteMap resource
type RouteMapProperties struct {
	// List of connections which have this RoutMap associated for inbound traffic.
	AssociatedInboundConnections []*string

	// List of connections which have this RoutMap associated for outbound traffic.
	AssociatedOutboundConnections []*string

	// List of RouteMap rules to be applied.
	Rules []*RouteMapRule

	// READ-ONLY; The provisioning state of the RouteMap resource.
	ProvisioningState *ProvisioningState
}

// RouteMapRule - A RouteMap Rule.
type RouteMapRule struct {
	// List of actions which will be applied on a match.
	Actions []*Action

	// List of matching criterion which will be applied to traffic.
	MatchCriteria []*Criterion

	// The unique name for the rule.
	Name *string

	// Next step after rule is evaluated. Current supported behaviors are 'Continue'(to next rule) and 'Terminate'.
	NextStepIfMatched *NextStep
}

// RoutePropertiesFormat - Route resource.
type RoutePropertiesFormat struct {
	// REQUIRED; The type of Azure hop the packet should be sent to.
	NextHopType *RouteNextHopType

	// The destination CIDR to which the route applies.
	AddressPrefix *string

	// A value indicating whether this route overrides overlapping BGP routes regardless of LPM.
	HasBgpOverride *bool

	// The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
	NextHopIPAddress *string

	// READ-ONLY; The provisioning state of the route resource.
	ProvisioningState *ProvisioningState
}

// RouteTable - Route table resource.
type RouteTable struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the route table.
	Properties *RouteTablePropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// RouteTableListResult - Response for the ListRouteTable API service call.
type RouteTableListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of route tables in a resource group.
	Value []*RouteTable
}

// RouteTablePropertiesFormat - Route Table resource.
type RouteTablePropertiesFormat struct {
	// Whether to disable the routes learned by BGP on that route table. True means disable.
	DisableBgpRoutePropagation *bool

	// Collection of routes contained within a route table.
	Routes []*Route

	// READ-ONLY; The provisioning state of the route table resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource GUID property of the route table.
	ResourceGUID *string

	// READ-ONLY; A collection of references to subnets.
	Subnets []*Subnet
}

// RoutingConfiguration - Routing Configuration indicating the associated and propagated route tables for this connection.
type RoutingConfiguration struct {
	// The resource id RouteTable associated with this RoutingConfiguration.
	AssociatedRouteTable *SubResource

	// The resource id of the RouteMap associated with this RoutingConfiguration for inbound learned routes.
	InboundRouteMap *SubResource

	// The resource id of theRouteMap associated with this RoutingConfiguration for outbound advertised routes.
	OutboundRouteMap *SubResource

	// The list of RouteTables to advertise the routes to.
	PropagatedRouteTables *PropagatedRouteTable

	// List of routes that control routing from VirtualHub into a virtual network connection.
	VnetRoutes *VnetRoute
}

// RoutingIntent - The routing intent child resource of a Virtual hub.
type RoutingIntent struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the RoutingIntent resource.
	Properties *RoutingIntentProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource type.
	Type *string
}

// RoutingIntentProperties - The properties of a RoutingIntent resource.
type RoutingIntentProperties struct {
	// List of routing policies.
	RoutingPolicies []*RoutingPolicy

	// READ-ONLY; The provisioning state of the RoutingIntent resource.
	ProvisioningState *ProvisioningState
}

// RoutingPolicy - The routing policy object used in a RoutingIntent resource.
type RoutingPolicy struct {
	// REQUIRED; List of all destinations which this routing policy is applicable to (for example: Internet, PrivateTraffic).
	Destinations []*string

	// REQUIRED; The unique name for the routing policy.
	Name *string

	// REQUIRED; The next hop resource id on which this routing policy is applicable to.
	NextHop *string
}

// Rule of type network.
type Rule struct {
	// REQUIRED; Rule Type.
	RuleType *FirewallPolicyRuleType

	// Description of the rule.
	Description *string

	// List of destination IP addresses or Service Tags.
	DestinationAddresses []*string

	// List of destination FQDNs.
	DestinationFqdns []*string

	// List of destination IpGroups for this rule.
	DestinationIPGroups []*string

	// List of destination ports.
	DestinationPorts []*string

	// Array of FirewallPolicyRuleNetworkProtocols.
	IPProtocols []*FirewallPolicyRuleNetworkProtocol

	// Name of the rule.
	Name *string

	// List of source IP addresses for this rule.
	SourceAddresses []*string

	// List of source IpGroups for this rule.
	SourceIPGroups []*string
}

// GetFirewallPolicyRule implements the FirewallPolicyRuleClassification interface for type Rule.
func (r *Rule) GetFirewallPolicyRule() *FirewallPolicyRule {
	return &FirewallPolicyRule{
		Description: r.Description,
		Name:        r.Name,
		RuleType:    r.RuleType,
	}
}

// SKU - The sku of this Bastion Host.
type SKU struct {
	// The name of this Bastion Host.
	Name *BastionHostSKUName
}

// ScopeConnection - The Scope Connections resource
type ScopeConnection struct {
	// The scope connection properties
	Properties *ScopeConnectionProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// ScopeConnectionListResult - List of scope connections.
type ScopeConnectionListResult struct {
	// Gets the URL to get the next page of results.
	NextLink *string

	// List of scope connections.
	Value []*ScopeConnection
}

// ScopeConnectionProperties - Scope connection.
type ScopeConnectionProperties struct {
	// A description of the scope connection.
	Description *string

	// Resource ID.
	ResourceID *string

	// Tenant ID.
	TenantID *string

	// READ-ONLY; Connection State
	ConnectionState *ScopeConnectionState
}

// SecurityAdminConfiguration - Defines the security admin configuration
type SecurityAdminConfiguration struct {
	// Indicates the properties for the network manager security admin configuration.
	Properties *SecurityAdminConfigurationPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// SecurityAdminConfigurationListResult - A list of network manager security admin configurations
type SecurityAdminConfigurationListResult struct {
	// Gets the URL to get the next page of results.
	NextLink *string

	// Gets a page of security admin configurations
	Value []*SecurityAdminConfiguration
}

// SecurityAdminConfigurationPropertiesFormat - Defines the security admin configuration properties.
type SecurityAdminConfigurationPropertiesFormat struct {
	// Enum list of network intent policy based services.
	ApplyOnNetworkIntentPolicyBasedServices []*NetworkIntentPolicyBasedService

	// A description of the security configuration.
	Description *string

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Unique identifier for this resource.
	ResourceGUID *string
}

// SecurityGroup - NetworkSecurityGroup resource.
type SecurityGroup struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the network security group.
	Properties *SecurityGroupPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SecurityGroupListResult - Response for ListNetworkSecurityGroups API service call.
type SecurityGroupListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of NetworkSecurityGroup resources.
	Value []*SecurityGroup
}

// SecurityGroupNetworkInterface - Network interface and all its associated security rules.
type SecurityGroupNetworkInterface struct {
	// ID of the network interface.
	ID *string

	// All security rules associated with the network interface.
	SecurityRuleAssociations *SecurityRuleAssociations
}

// SecurityGroupPropertiesFormat - Network Security Group resource.
type SecurityGroupPropertiesFormat struct {
	// When enabled, flows created from Network Security Group connections will be re-evaluated when rules are updates. Initial
	// enablement will trigger re-evaluation.
	FlushConnection *bool

	// A collection of security rules of the network security group.
	SecurityRules []*SecurityRule

	// READ-ONLY; The default security rules of network security group.
	DefaultSecurityRules []*SecurityRule

	// READ-ONLY; A collection of references to flow log resources.
	FlowLogs []*FlowLog

	// READ-ONLY; A collection of references to network interfaces.
	NetworkInterfaces []*Interface

	// READ-ONLY; The provisioning state of the network security group resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource GUID property of the network security group resource.
	ResourceGUID *string

	// READ-ONLY; A collection of references to subnets.
	Subnets []*Subnet
}

// SecurityGroupResult - Network configuration diagnostic result corresponded provided traffic query.
type SecurityGroupResult struct {
	// The network traffic is allowed or denied.
	SecurityRuleAccessResult *SecurityRuleAccess

	// READ-ONLY; List of results network security groups diagnostic.
	EvaluatedNetworkSecurityGroups []*EvaluatedNetworkSecurityGroup
}

// SecurityGroupViewParameters - Parameters that define the VM to check security groups for.
type SecurityGroupViewParameters struct {
	// REQUIRED; ID of the target VM.
	TargetResourceID *string
}

// SecurityGroupViewResult - The information about security rules applied to the specified VM.
type SecurityGroupViewResult struct {
	// List of network interfaces on the specified VM.
	NetworkInterfaces []*SecurityGroupNetworkInterface
}

// SecurityPartnerProvider - Security Partner Provider resource.
type SecurityPartnerProvider struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the Security Partner Provider.
	Properties *SecurityPartnerProviderPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SecurityPartnerProviderListResult - Response for ListSecurityPartnerProviders API service call.
type SecurityPartnerProviderListResult struct {
	// URL to get the next set of results.
	NextLink *string

	// List of Security Partner Providers in a resource group.
	Value []*SecurityPartnerProvider
}

// SecurityPartnerProviderPropertiesFormat - Properties of the Security Partner Provider.
type SecurityPartnerProviderPropertiesFormat struct {
	// The security provider name.
	SecurityProviderName *SecurityProviderName

	// The virtualHub to which the Security Partner Provider belongs.
	VirtualHub *SubResource

	// READ-ONLY; The connection status with the Security Partner Provider.
	ConnectionStatus *SecurityPartnerProviderConnectionStatus

	// READ-ONLY; The provisioning state of the Security Partner Provider resource.
	ProvisioningState *ProvisioningState
}

// SecurityRule - Network security rule.
type SecurityRule struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the security rule.
	Properties *SecurityRulePropertiesFormat

	// The type of the resource.
	Type *string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// SecurityRuleAssociations - All security rules associated with the network interface.
type SecurityRuleAssociations struct {
	// Collection of default security rules of the network security group.
	DefaultSecurityRules []*SecurityRule

	// Collection of effective security rules.
	EffectiveSecurityRules []*EffectiveNetworkSecurityRule

	// Network interface and it's custom security rules.
	NetworkInterfaceAssociation *InterfaceAssociation

	// Subnet and it's custom security rules.
	SubnetAssociation *SubnetAssociation
}

// SecurityRuleListResult - Response for ListSecurityRule API service call. Retrieves all security rules that belongs to a
// network security group.
type SecurityRuleListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The security rules in a network security group.
	Value []*SecurityRule
}

// SecurityRulePropertiesFormat - Security rule resource.
type SecurityRulePropertiesFormat struct {
	// REQUIRED; The network traffic is allowed or denied.
	Access *SecurityRuleAccess

	// REQUIRED; The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
	Direction *SecurityRuleDirection

	// REQUIRED; The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each
	// rule in the collection. The lower the priority number, the higher the priority of the rule.
	Priority *int32

	// REQUIRED; Network protocol this rule applies to.
	Protocol *SecurityRuleProtocol

	// A description for this rule. Restricted to 140 chars.
	Description *string

	// The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default
	// tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also
	// be used.
	DestinationAddressPrefix *string

	// The destination address prefixes. CIDR or destination IP ranges.
	DestinationAddressPrefixes []*string

	// The application security group specified as destination.
	DestinationApplicationSecurityGroups []*ApplicationSecurityGroup

	// The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
	DestinationPortRange *string

	// The destination port ranges.
	DestinationPortRanges []*string

	// The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork',
	// 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress
	// rule, specifies where network traffic originates from.
	SourceAddressPrefix *string

	// The CIDR or source IP ranges.
	SourceAddressPrefixes []*string

	// The application security group specified as source.
	SourceApplicationSecurityGroups []*ApplicationSecurityGroup

	// The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
	SourcePortRange *string

	// The source port ranges.
	SourcePortRanges []*string

	// READ-ONLY; The provisioning state of the security rule resource.
	ProvisioningState *ProvisioningState
}

// SecurityRulesEvaluationResult - Network security rules evaluation result.
type SecurityRulesEvaluationResult struct {
	// Value indicating whether destination is matched.
	DestinationMatched *bool

	// Value indicating whether destination port is matched.
	DestinationPortMatched *bool

	// Name of the network security rule.
	Name *string

	// Value indicating whether protocol is matched.
	ProtocolMatched *bool

	// Value indicating whether source is matched.
	SourceMatched *bool

	// Value indicating whether source port is matched.
	SourcePortMatched *bool
}

// ServiceAssociationLink resource.
type ServiceAssociationLink struct {
	// Resource ID.
	ID *string

	// Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Resource navigation link properties format.
	Properties *ServiceAssociationLinkPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource type.
	Type *string
}

// ServiceAssociationLinkPropertiesFormat - Properties of ServiceAssociationLink.
type ServiceAssociationLinkPropertiesFormat struct {
	// If true, the resource can be deleted.
	AllowDelete *bool

	// Link to the external resource.
	Link *string

	// Resource type of the linked resource.
	LinkedResourceType *string

	// A list of locations.
	Locations []*string

	// READ-ONLY; The provisioning state of the service association link resource.
	ProvisioningState *ProvisioningState
}

// ServiceAssociationLinksListResult - Response for ServiceAssociationLinks_List operation.
type ServiceAssociationLinksListResult struct {
	// The service association links in a subnet.
	Value []*ServiceAssociationLink

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// ServiceDelegationPropertiesFormat - Properties of a service delegation.
type ServiceDelegationPropertiesFormat struct {
	// The name of the service to whom the subnet should be delegated (e.g. Microsoft.Sql/servers).
	ServiceName *string

	// READ-ONLY; The actions permitted to the service upon delegation.
	Actions []*string

	// READ-ONLY; The provisioning state of the service delegation resource.
	ProvisioningState *ProvisioningState
}

// ServiceEndpointPolicy - Service End point policy resource.
type ServiceEndpointPolicy struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the service end point policy.
	Properties *ServiceEndpointPolicyPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Kind of service endpoint policy. This is metadata used for the Azure portal experience.
	Kind *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ServiceEndpointPolicyDefinition - Service Endpoint policy definitions.
type ServiceEndpointPolicyDefinition struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the service endpoint policy definition.
	Properties *ServiceEndpointPolicyDefinitionPropertiesFormat

	// The type of the resource.
	Type *string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// ServiceEndpointPolicyDefinitionListResult - Response for ListServiceEndpointPolicyDefinition API service call. Retrieves
// all service endpoint policy definition that belongs to a service endpoint policy.
type ServiceEndpointPolicyDefinitionListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The service endpoint policy definition in a service endpoint policy.
	Value []*ServiceEndpointPolicyDefinition
}

// ServiceEndpointPolicyDefinitionPropertiesFormat - Service Endpoint policy definition resource.
type ServiceEndpointPolicyDefinitionPropertiesFormat struct {
	// A description for this rule. Restricted to 140 chars.
	Description *string

	// Service endpoint name.
	Service *string

	// A list of service resources.
	ServiceResources []*string

	// READ-ONLY; The provisioning state of the service endpoint policy definition resource.
	ProvisioningState *ProvisioningState
}

// ServiceEndpointPolicyListResult - Response for ListServiceEndpointPolicies API service call.
type ServiceEndpointPolicyListResult struct {
	// A list of ServiceEndpointPolicy resources.
	Value []*ServiceEndpointPolicy

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// ServiceEndpointPolicyPropertiesFormat - Service Endpoint Policy resource.
type ServiceEndpointPolicyPropertiesFormat struct {
	// A collection of contextual service endpoint policy.
	ContextualServiceEndpointPolicies []*string

	// The alias indicating if the policy belongs to a service
	ServiceAlias *string

	// A collection of service endpoint policy definitions of the service endpoint policy.
	ServiceEndpointPolicyDefinitions []*ServiceEndpointPolicyDefinition

	// READ-ONLY; The provisioning state of the service endpoint policy resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource GUID property of the service endpoint policy resource.
	ResourceGUID *string

	// READ-ONLY; A collection of references to subnets.
	Subnets []*Subnet
}

// ServiceEndpointPropertiesFormat - The service endpoint properties.
type ServiceEndpointPropertiesFormat struct {
	// A list of locations.
	Locations []*string

	// The type of the endpoint service.
	Service *string

	// READ-ONLY; The provisioning state of the service endpoint resource.
	ProvisioningState *ProvisioningState
}

// ServiceTagInformation - The service tag information.
type ServiceTagInformation struct {
	// READ-ONLY; The ID of service tag.
	ID *string

	// READ-ONLY; The name of service tag.
	Name *string

	// READ-ONLY; Properties of the service tag information.
	Properties *ServiceTagInformationPropertiesFormat

	// READ-ONLY; The iteration number of service tag object for region.
	ServiceTagChangeNumber *string
}

// ServiceTagInformationListResult - Response for Get ServiceTagInformation API service call. Retrieves the list of service
// tag information resources.
type ServiceTagInformationListResult struct {
	// The list of service tag information resources.
	Value []*ServiceTagInformation

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// ServiceTagInformationPropertiesFormat - Properties of the service tag information.
type ServiceTagInformationPropertiesFormat struct {
	// READ-ONLY; The list of IP address prefixes.
	AddressPrefixes []*string

	// READ-ONLY; The iteration number of service tag.
	ChangeNumber *string

	// READ-ONLY; The region of service tag.
	Region *string

	// READ-ONLY; The state of the service tag.
	State *string

	// READ-ONLY; The name of system service.
	SystemService *string
}

// ServiceTagsListResult - Response for the ListServiceTags API service call.
type ServiceTagsListResult struct {
	// READ-ONLY; The iteration number.
	ChangeNumber *string

	// READ-ONLY; The name of the cloud.
	Cloud *string

	// READ-ONLY; The ID of the cloud.
	ID *string

	// READ-ONLY; The name of the cloud.
	Name *string

	// READ-ONLY; The URL to get next page of service tag information resources.
	NextLink *string

	// READ-ONLY; The azure resource type.
	Type *string

	// READ-ONLY; The list of service tag information resources.
	Values []*ServiceTagInformation
}

// SessionIDs - List of session IDs.
type SessionIDs struct {
	// List of session IDs.
	SessionIDs []*string
}

// SignatureOverridesFilterValuesQuery - Describes the filter values possibles for a given column
type SignatureOverridesFilterValuesQuery struct {
	// Describes the name of the column which values will be returned
	FilterName *string
}

// SignatureOverridesFilterValuesResponse - Describes the list of all possible values for a specific filter value
type SignatureOverridesFilterValuesResponse struct {
	// Describes the possible values
	FilterValues []*string
}

// SignaturesOverrides - Contains all specific policy signatures overrides for the IDPS
type SignaturesOverrides struct {
	// Will contain the resource id of the signature override resource
	ID *string

	// Contains the name of the resource (default)
	Name *string

	// Will contain the properties of the resource (the actual signature overrides)
	Properties *SignaturesOverridesProperties

	// Will contain the type of the resource: Microsoft.Network/firewallPolicies/intrusionDetectionSignaturesOverrides
	Type *string
}

// SignaturesOverridesList - Describes an object containing an array with a single item
type SignaturesOverridesList struct {
	// Describes a list consisting exactly one item describing the policy's signature override status
	Value []*SignaturesOverrides
}

// SignaturesOverridesProperties - Will contain the properties of the resource (the actual signature overrides)
type SignaturesOverridesProperties struct {
	// Dictionary of
	Signatures map[string]*string
}

type SingleQueryResult struct {
	// Describes what is the signature enforces
	Description *string

	// Describes the list of destination ports related to this signature
	DestinationPorts []*string

	// Describes in which direction signature is being enforced: 0 - OutBound, 1 - InBound, 2 - Any, 3 - Internal, 4 - InternalOutbound
	Direction *FirewallPolicyIDPSSignatureDirection

	// Describes the groups the signature belongs to
	Group *string

	// Describes if this override is inherited from base policy or not
	InheritedFromParentPolicy *bool

	// Describes the last updated time of the signature (provided from 3rd party vendor)
	LastUpdated *string

	// The current mode enforced, 0 - Disabled, 1 - Alert, 2 -Deny
	Mode *FirewallPolicyIDPSSignatureMode

	// Describes the protocol the signatures is being enforced in
	Protocol *string

	// Describes the severity of signature: 1 - High, 2 - Medium, 3 - Low
	Severity *FirewallPolicyIDPSSignatureSeverity

	// The ID of the signature
	SignatureID *int32

	// Describes the list of source ports related to this signature
	SourcePorts []*string
}

// StaticMember Item.
type StaticMember struct {
	// The Static Member properties
	Properties *StaticMemberProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// StaticMemberListResult - Result of the request to list StaticMember. It contains a list of groups and a URL link to get
// the next set of results.
type StaticMemberListResult struct {
	// Gets the URL to get the next set of results.
	NextLink *string

	// Gets a page of StaticMember
	Value []*StaticMember
}

// StaticMemberProperties - Properties of static member.
type StaticMemberProperties struct {
	// Resource Id.
	ResourceID *string

	// READ-ONLY; The provisioning state of the scope assignment resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Resource region.
	Region *string
}

// StaticRoute - List of all Static Routes.
type StaticRoute struct {
	// List of all address prefixes.
	AddressPrefixes []*string

	// The name of the StaticRoute that is unique within a VnetRoute.
	Name *string

	// The ip address of the next hop.
	NextHopIPAddress *string
}

// StaticRoutesConfig - Configuration for static routes on this HubVnetConnectionConfiguration for static routes on this HubVnetConnection.
type StaticRoutesConfig struct {
	// Parameter determining whether NVA in spoke vnet is bypassed for traffic with destination in spoke.
	VnetLocalRouteOverrideCriteria *VnetLocalRouteOverrideCriteria

	// READ-ONLY; Boolean indicating whether static routes on this connection are automatically propagate to route tables which
	// this connection propagates to.
	PropagateStaticRoutes *bool
}

// SubResource - Reference to another subresource.
type SubResource struct {
	// Resource ID.
	ID *string
}

// Subnet in a virtual network resource.
type Subnet struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the subnet.
	Properties *SubnetPropertiesFormat

	// Resource type.
	Type *string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// SubnetAssociation - Subnet and it's custom security rules.
type SubnetAssociation struct {
	// Collection of custom security rules.
	SecurityRules []*SecurityRule

	// READ-ONLY; Subnet ID.
	ID *string
}

// SubnetListResult - Response for ListSubnets API service callRetrieves all subnet that belongs to a virtual network.
type SubnetListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The subnets in a virtual network.
	Value []*Subnet
}

// SubnetPropertiesFormat - Properties of the subnet.
type SubnetPropertiesFormat struct {
	// The address prefix for the subnet.
	AddressPrefix *string

	// List of address prefixes for the subnet.
	AddressPrefixes []*string

	// Application gateway IP configurations of virtual network resource.
	ApplicationGatewayIPConfigurations []*ApplicationGatewayIPConfiguration

	// Set this property to false to disable default outbound connectivity for all VMs in the subnet. This property can only be
	// set at the time of subnet creation and cannot be updated for an existing
	// subnet.
	DefaultOutboundAccess *bool

	// An array of references to the delegations on the subnet.
	Delegations []*Delegation

	// Array of IpAllocation which reference this subnet.
	IPAllocations []*SubResource

	// Nat gateway associated with this subnet.
	NatGateway *SubResource

	// The reference to the NetworkSecurityGroup resource.
	NetworkSecurityGroup *SecurityGroup

	// Enable or Disable apply network policies on private end point in the subnet.
	PrivateEndpointNetworkPolicies *VirtualNetworkPrivateEndpointNetworkPolicies

	// Enable or Disable apply network policies on private link service in the subnet.
	PrivateLinkServiceNetworkPolicies *VirtualNetworkPrivateLinkServiceNetworkPolicies

	// The reference to the RouteTable resource.
	RouteTable *RouteTable

	// An array of service endpoint policies.
	ServiceEndpointPolicies []*ServiceEndpointPolicy

	// An array of service endpoints.
	ServiceEndpoints []*ServiceEndpointPropertiesFormat

	// READ-ONLY; Array of IP configuration profiles which reference this subnet.
	IPConfigurationProfiles []*IPConfigurationProfile

	// READ-ONLY; An array of references to the network interface IP configurations using subnet.
	IPConfigurations []*IPConfiguration

	// READ-ONLY; An array of references to private endpoints.
	PrivateEndpoints []*PrivateEndpoint

	// READ-ONLY; The provisioning state of the subnet resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; A read-only string identifying the intention of use for this subnet based on delegations and other user-defined
	// properties.
	Purpose *string

	// READ-ONLY; An array of references to the external resources using subnet.
	ResourceNavigationLinks []*ResourceNavigationLink

	// READ-ONLY; An array of references to services injecting into this subnet.
	ServiceAssociationLinks []*ServiceAssociationLink
}

// SwapResource to represent slot type on the specified cloud service.
type SwapResource struct {
	// Swap resource properties
	Properties *SwapResourceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SwapResourceListResult - SwapResource List with single entry to represent slot type on the specified cloud service.
type SwapResourceListResult struct {
	Value []*SwapResource
}

// SwapResourceProperties - Swap resource properties
type SwapResourceProperties struct {
	// Specifies slot info on a cloud service
	SlotType *SlotType
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The type of identity that last modified the resource.
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TagsObject - Tags object for patch operations.
type TagsObject struct {
	// Resource tags.
	Tags map[string]*string
}

// Topology of the specified resource group.
type Topology struct {
	// A list of topology resources.
	Resources []*TopologyResource

	// READ-ONLY; The datetime when the topology was initially created for the resource group.
	CreatedDateTime *time.Time

	// READ-ONLY; GUID representing the operation id.
	ID *string

	// READ-ONLY; The datetime when the topology was last modified.
	LastModified *time.Time
}

// TopologyAssociation - Resources that have an association with the parent resource.
type TopologyAssociation struct {
	// The association type of the child resource to the parent resource.
	AssociationType *AssociationType

	// The name of the resource that is associated with the parent resource.
	Name *string

	// The ID of the resource that is associated with the parent resource.
	ResourceID *string
}

// TopologyParameters - Parameters that define the representation of topology.
type TopologyParameters struct {
	// The name of the target resource group to perform topology on.
	TargetResourceGroupName *string

	// The reference to the Subnet resource.
	TargetSubnet *SubResource

	// The reference to the Virtual Network resource.
	TargetVirtualNetwork *SubResource
}

// TopologyResource - The network resource topology information for the given resource group.
type TopologyResource struct {
	// Holds the associations the resource has with other resources in the resource group.
	Associations []*TopologyAssociation

	// ID of the resource.
	ID *string

	// Resource location.
	Location *string

	// Name of the resource.
	Name *string
}

// TrafficAnalyticsConfigurationProperties - Parameters that define the configuration of traffic analytics.
type TrafficAnalyticsConfigurationProperties struct {
	// Flag to enable/disable traffic analytics.
	Enabled *bool

	// The interval in minutes which would decide how frequently TA service should do flow analytics.
	TrafficAnalyticsInterval *int32

	// The resource guid of the attached workspace.
	WorkspaceID *string

	// The location of the attached workspace.
	WorkspaceRegion *string

	// Resource Id of the attached workspace.
	WorkspaceResourceID *string
}

// TrafficAnalyticsProperties - Parameters that define the configuration of traffic analytics.
type TrafficAnalyticsProperties struct {
	// Parameters that define the configuration of traffic analytics.
	NetworkWatcherFlowAnalyticsConfiguration *TrafficAnalyticsConfigurationProperties
}

// TrafficSelectorPolicy - An traffic selector policy for a virtual network gateway connection.
type TrafficSelectorPolicy struct {
	// REQUIRED; A collection of local address spaces in CIDR format.
	LocalAddressRanges []*string

	// REQUIRED; A collection of remote address spaces in CIDR format.
	RemoteAddressRanges []*string
}

// TroubleshootingDetails - Information gained from troubleshooting of specified resource.
type TroubleshootingDetails struct {
	// Details on troubleshooting results.
	Detail *string

	// The id of the get troubleshoot operation.
	ID *string

	// Reason type of failure.
	ReasonType *string

	// List of recommended actions.
	RecommendedActions []*TroubleshootingRecommendedActions

	// A summary of troubleshooting.
	Summary *string
}

// TroubleshootingParameters - Parameters that define the resource to troubleshoot.
type TroubleshootingParameters struct {
	// REQUIRED; Properties of the troubleshooting resource.
	Properties *TroubleshootingProperties

	// REQUIRED; The target resource to troubleshoot.
	TargetResourceID *string
}

// TroubleshootingProperties - Storage location provided for troubleshoot.
type TroubleshootingProperties struct {
	// REQUIRED; The ID for the storage account to save the troubleshoot result.
	StorageID *string

	// REQUIRED; The path to the blob to save the troubleshoot result in.
	StoragePath *string
}

// TroubleshootingRecommendedActions - Recommended actions based on discovered issues.
type TroubleshootingRecommendedActions struct {
	// ID of the recommended action.
	ActionID *string

	// Description of recommended actions.
	ActionText *string

	// The uri linking to a documentation for the recommended troubleshooting actions.
	ActionURI *string

	// The information from the URI for the recommended troubleshooting actions.
	ActionURIText *string
}

// TroubleshootingResult - Troubleshooting information gained from specified resource.
type TroubleshootingResult struct {
	// The result code of the troubleshooting.
	Code *string

	// The end time of the troubleshooting.
	EndTime *time.Time

	// Information from troubleshooting.
	Results []*TroubleshootingDetails

	// The start time of the troubleshooting.
	StartTime *time.Time
}

// TunnelConnectionHealth - VirtualNetworkGatewayConnection properties.
type TunnelConnectionHealth struct {
	// READ-ONLY; Virtual Network Gateway connection status.
	ConnectionStatus *VirtualNetworkGatewayConnectionStatus

	// READ-ONLY; The Egress Bytes Transferred in this connection.
	EgressBytesTransferred *int64

	// READ-ONLY; The Ingress Bytes Transferred in this connection.
	IngressBytesTransferred *int64

	// READ-ONLY; The time at which connection was established in Utc format.
	LastConnectionEstablishedUTCTime *string

	// READ-ONLY; Tunnel name.
	Tunnel *string
}

// UnprepareNetworkPoliciesRequest - Details of UnprepareNetworkPolicies for Subnet.
type UnprepareNetworkPoliciesRequest struct {
	// The name of the service for which subnet is being unprepared for.
	ServiceName *string
}

// Usage - The network resource usage.
type Usage struct {
	// REQUIRED; The current value of the usage.
	CurrentValue *int64

	// REQUIRED; The limit of usage.
	Limit *int64

	// REQUIRED; The name of the type of usage.
	Name *UsageName

	// REQUIRED; An enum describing the unit of measurement.
	Unit *UsageUnit

	// READ-ONLY; Resource identifier.
	ID *string
}

// UsageName - The usage names.
type UsageName struct {
	// A localized string describing the resource name.
	LocalizedValue *string

	// A string describing the resource name.
	Value *string
}

// UsagesListResult - The list usages operation response.
type UsagesListResult struct {
	// URL to get the next set of results.
	NextLink *string

	// The list network resource usages.
	Value []*Usage
}

// VM - Describes a Virtual Machine.
type VM struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// VPNClientConfiguration - VpnClientConfiguration for P2S client.
type VPNClientConfiguration struct {
	// The AADAudience property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
	AADAudience *string

	// The AADIssuer property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
	AADIssuer *string

	// The AADTenant property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
	AADTenant *string

	// The radius server address property of the VirtualNetworkGateway resource for vpn client connection.
	RadiusServerAddress *string

	// The radius secret property of the VirtualNetworkGateway resource for vpn client connection.
	RadiusServerSecret *string

	// The radiusServers property for multiple radius server configuration.
	RadiusServers []*RadiusServer

	// VPN authentication types for the virtual network gateway..
	VPNAuthenticationTypes []*VPNAuthenticationType

	// The reference to the address space resource which represents Address space for P2S VpnClient.
	VPNClientAddressPool *AddressSpace

	// VpnClientIpsecPolicies for virtual network gateway P2S client.
	VPNClientIPSecPolicies []*IPSecPolicy

	// VpnClientProtocols for Virtual network gateway.
	VPNClientProtocols []*VPNClientProtocol

	// VpnClientRevokedCertificate for Virtual network gateway.
	VPNClientRevokedCertificates []*VPNClientRevokedCertificate

	// VpnClientRootCertificate for virtual network gateway.
	VPNClientRootCertificates []*VPNClientRootCertificate

	// per ip address pool connection policy for virtual network gateway P2S client.
	VngClientConnectionConfigurations []*VngClientConnectionConfiguration
}

// VPNClientConnectionHealth - VpnClientConnectionHealth properties.
type VPNClientConnectionHealth struct {
	// List of allocated ip addresses to the connected p2s vpn clients.
	AllocatedIPAddresses []*string

	// The total of p2s vpn clients connected at this time to this P2SVpnGateway.
	VPNClientConnectionsCount *int32

	// READ-ONLY; Total of the Egress Bytes Transferred in this connection.
	TotalEgressBytesTransferred *int64

	// READ-ONLY; Total of the Ingress Bytes Transferred in this P2S Vpn connection.
	TotalIngressBytesTransferred *int64
}

// VPNClientConnectionHealthDetail - VPN client connection health detail.
type VPNClientConnectionHealthDetail struct {
	// READ-ONLY; The egress bytes per second.
	EgressBytesTransferred *int64

	// READ-ONLY; The egress packets per second.
	EgressPacketsTransferred *int64

	// READ-ONLY; The ingress bytes per second.
	IngressBytesTransferred *int64

	// READ-ONLY; The ingress packets per second.
	IngressPacketsTransferred *int64

	// READ-ONLY; The max band width.
	MaxBandwidth *int64

	// READ-ONLY; The max packets transferred per second.
	MaxPacketsPerSecond *int64

	// READ-ONLY; The assigned private Ip of a connected vpn client.
	PrivateIPAddress *string

	// READ-ONLY; The public Ip of a connected vpn client.
	PublicIPAddress *string

	// READ-ONLY; The duration time of a connected vpn client.
	VPNConnectionDuration *int64

	// READ-ONLY; The vpn client Id.
	VPNConnectionID *string

	// READ-ONLY; The start time of a connected vpn client.
	VPNConnectionTime *string

	// READ-ONLY; The user name of a connected vpn client.
	VPNUserName *string
}

// VPNClientConnectionHealthDetailListResult - List of virtual network gateway vpn client connection health.
type VPNClientConnectionHealthDetailListResult struct {
	// List of vpn client connection health.
	Value []*VPNClientConnectionHealthDetail
}

// VPNClientIPsecParameters - An IPSec parameters for a virtual network gateway P2S connection.
type VPNClientIPsecParameters struct {
	// REQUIRED; The DH Group used in IKE Phase 1 for initial SA.
	DhGroup *DhGroup

	// REQUIRED; The IPSec encryption algorithm (IKE phase 1).
	IPSecEncryption *IPSecEncryption

	// REQUIRED; The IPSec integrity algorithm (IKE phase 1).
	IPSecIntegrity *IPSecIntegrity

	// REQUIRED; The IKE encryption algorithm (IKE phase 2).
	IkeEncryption *IkeEncryption

	// REQUIRED; The IKE integrity algorithm (IKE phase 2).
	IkeIntegrity *IkeIntegrity

	// REQUIRED; The Pfs Group used in IKE Phase 2 for new child SA.
	PfsGroup *PfsGroup

	// REQUIRED; The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for P2S client..
	SaDataSizeKilobytes *int32

	// REQUIRED; The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for P2S client.
	SaLifeTimeSeconds *int32
}

// VPNClientParameters - Vpn Client Parameters for package generation.
type VPNClientParameters struct {
	// VPN client authentication method.
	AuthenticationMethod *AuthenticationMethod

	// A list of client root certificates public certificate data encoded as Base-64 strings. Optional parameter for external
	// radius based authentication with EAPTLS.
	ClientRootCertificates []*string

	// VPN client Processor Architecture.
	ProcessorArchitecture *ProcessorArchitecture

	// The public certificate data for the radius server authentication certificate as a Base-64 encoded string. Required only
	// if external radius authentication has been configured with EAPTLS
	// authentication.
	RadiusServerAuthCertificate *string
}

// VPNClientRevokedCertificate - VPN client revoked certificate of virtual network gateway.
type VPNClientRevokedCertificate struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the vpn client revoked certificate.
	Properties *VPNClientRevokedCertificatePropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// VPNClientRevokedCertificatePropertiesFormat - Properties of the revoked VPN client certificate of virtual network gateway.
type VPNClientRevokedCertificatePropertiesFormat struct {
	// The revoked VPN client certificate thumbprint.
	Thumbprint *string

	// READ-ONLY; The provisioning state of the VPN client revoked certificate resource.
	ProvisioningState *ProvisioningState
}

// VPNClientRootCertificate - VPN client root certificate of virtual network gateway.
type VPNClientRootCertificate struct {
	// REQUIRED; Properties of the vpn client root certificate.
	Properties *VPNClientRootCertificatePropertiesFormat

	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// VPNClientRootCertificatePropertiesFormat - Properties of SSL certificates of application gateway.
type VPNClientRootCertificatePropertiesFormat struct {
	// REQUIRED; The certificate public data.
	PublicCertData *string

	// READ-ONLY; The provisioning state of the VPN client root certificate resource.
	ProvisioningState *ProvisioningState
}

// VPNConnection - VpnConnection Resource.
type VPNConnection struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the VPN connection.
	Properties *VPNConnectionProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// VPNConnectionPacketCaptureStartParameters - Vpn Connection packet capture parameters supplied to start packet capture on
// gateway connection.
type VPNConnectionPacketCaptureStartParameters struct {
	// Start Packet capture parameters on vpn connection.
	FilterData *string

	// List of site link connection names.
	LinkConnectionNames []*string
}

// VPNConnectionPacketCaptureStopParameters - Vpn Connection packet capture parameters supplied to stop packet capture on
// gateway connection.
type VPNConnectionPacketCaptureStopParameters struct {
	// List of site link connection names.
	LinkConnectionNames []*string

	// SAS url for packet capture on vpn connection.
	SasURL *string
}

// VPNConnectionProperties - Parameters for VpnConnection.
type VPNConnectionProperties struct {
	// Expected bandwidth in MBPS.
	ConnectionBandwidth *int32

	// DPD timeout in seconds for vpn connection.
	DpdTimeoutSeconds *int32

	// EnableBgp flag.
	EnableBgp *bool

	// Enable internet security.
	EnableInternetSecurity *bool

	// EnableBgp flag.
	EnableRateLimiting *bool

	// The IPSec Policies to be considered by this connection.
	IPSecPolicies []*IPSecPolicy

	// Id of the connected vpn site.
	RemoteVPNSite *SubResource

	// The Routing Configuration indicating the associated and propagated route tables on this connection.
	RoutingConfiguration *RoutingConfiguration

	// Routing weight for vpn connection.
	RoutingWeight *int32

	// SharedKey for the vpn connection.
	SharedKey *string

	// The Traffic Selector Policies to be considered by this connection.
	TrafficSelectorPolicies []*TrafficSelectorPolicy

	// Use local azure ip to initiate connection.
	UseLocalAzureIPAddress *bool

	// Enable policy-based traffic selectors.
	UsePolicyBasedTrafficSelectors *bool

	// Connection protocol used for this connection.
	VPNConnectionProtocolType *VirtualNetworkGatewayConnectionProtocol

	// List of all vpn site link connections to the gateway.
	VPNLinkConnections []*VPNSiteLinkConnection

	// READ-ONLY; The connection status.
	ConnectionStatus *VPNConnectionStatus

	// READ-ONLY; Egress bytes transferred.
	EgressBytesTransferred *int64

	// READ-ONLY; Ingress bytes transferred.
	IngressBytesTransferred *int64

	// READ-ONLY; The provisioning state of the VPN connection resource.
	ProvisioningState *ProvisioningState
}

// VPNDeviceScriptParameters - Vpn device configuration script generation parameters.
type VPNDeviceScriptParameters struct {
	// The device family for the vpn device.
	DeviceFamily *string

	// The firmware version for the vpn device.
	FirmwareVersion *string

	// The vendor for the vpn device.
	Vendor *string
}

// VPNGateway - VpnGateway Resource.
type VPNGateway struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the VPN gateway.
	Properties *VPNGatewayProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// VPNGatewayIPConfiguration - IP Configuration of a VPN Gateway Resource.
type VPNGatewayIPConfiguration struct {
	// The identifier of the IP configuration for a VPN Gateway.
	ID *string

	// The private IP address of this IP configuration.
	PrivateIPAddress *string

	// The public IP address of this IP configuration.
	PublicIPAddress *string
}

// VPNGatewayNatRule - VpnGatewayNatRule Resource.
type VPNGatewayNatRule struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the VpnGateway NAT rule.
	Properties *VPNGatewayNatRuleProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource type.
	Type *string
}

// VPNGatewayNatRuleProperties - Parameters for VpnGatewayNatRule.
type VPNGatewayNatRuleProperties struct {
	// The private IP address external mapping for NAT.
	ExternalMappings []*VPNNatRuleMapping

	// The IP Configuration ID this NAT rule applies to.
	IPConfigurationID *string

	// The private IP address internal mapping for NAT.
	InternalMappings []*VPNNatRuleMapping

	// The Source NAT direction of a VPN NAT.
	Mode *VPNNatRuleMode

	// The type of NAT rule for VPN NAT.
	Type *VPNNatRuleType

	// READ-ONLY; List of egress VpnSiteLinkConnections.
	EgressVPNSiteLinkConnections []*SubResource

	// READ-ONLY; List of ingress VpnSiteLinkConnections.
	IngressVPNSiteLinkConnections []*SubResource

	// READ-ONLY; The provisioning state of the NAT Rule resource.
	ProvisioningState *ProvisioningState
}

// VPNGatewayPacketCaptureStartParameters - Start packet capture parameters.
type VPNGatewayPacketCaptureStartParameters struct {
	// Start Packet capture parameters on vpn gateway.
	FilterData *string
}

// VPNGatewayPacketCaptureStopParameters - Stop packet capture parameters.
type VPNGatewayPacketCaptureStopParameters struct {
	// SAS url for packet capture on vpn gateway.
	SasURL *string
}

// VPNGatewayProperties - Parameters for VpnGateway.
type VPNGatewayProperties struct {
	// Local network gateway's BGP speaker settings.
	BgpSettings *BgpSettings

	// List of all vpn connections to the gateway.
	Connections []*VPNConnection

	// Enable BGP routes translation for NAT on this VpnGateway.
	EnableBgpRouteTranslationForNat *bool

	// Enable Routing Preference property for the Public IP Interface of the VpnGateway.
	IsRoutingPreferenceInternet *bool

	// List of all the nat Rules associated with the gateway.
	NatRules []*VPNGatewayNatRule

	// The scale unit for this vpn gateway.
	VPNGatewayScaleUnit *int32

	// The VirtualHub to which the gateway belongs.
	VirtualHub *SubResource

	// READ-ONLY; List of all IPs configured on the gateway.
	IPConfigurations []*VPNGatewayIPConfiguration

	// READ-ONLY; The provisioning state of the VPN gateway resource.
	ProvisioningState *ProvisioningState
}

// VPNLinkBgpSettings - BGP settings details for a link.
type VPNLinkBgpSettings struct {
	// The BGP speaker's ASN.
	Asn *int64

	// The BGP peering address and BGP identifier of this BGP speaker.
	BgpPeeringAddress *string
}

// VPNLinkProviderProperties - List of properties of a link provider.
type VPNLinkProviderProperties struct {
	// Name of the link provider.
	LinkProviderName *string

	// Link speed.
	LinkSpeedInMbps *int32
}

// VPNNatRuleMapping - Vpn NatRule mapping.
type VPNNatRuleMapping struct {
	// Address space for Vpn NatRule mapping.
	AddressSpace *string

	// Port range for Vpn NatRule mapping.
	PortRange *string
}

// VPNPacketCaptureStartParameters - Start packet capture parameters on virtual network gateway.
type VPNPacketCaptureStartParameters struct {
	// Start Packet capture parameters.
	FilterData *string
}

// VPNPacketCaptureStopParameters - Stop packet capture parameters.
type VPNPacketCaptureStopParameters struct {
	// SAS url for packet capture on virtual network gateway.
	SasURL *string
}

// VPNProfileResponse - Vpn Profile Response for package generation.
type VPNProfileResponse struct {
	// URL to the VPN profile.
	ProfileURL *string
}

// VPNServerConfigRadiusClientRootCertificate - Properties of the Radius client root certificate of VpnServerConfiguration.
type VPNServerConfigRadiusClientRootCertificate struct {
	// The certificate name.
	Name *string

	// The Radius client root certificate thumbprint.
	Thumbprint *string
}

// VPNServerConfigRadiusServerRootCertificate - Properties of Radius Server root certificate of VpnServerConfiguration.
type VPNServerConfigRadiusServerRootCertificate struct {
	// The certificate name.
	Name *string

	// The certificate public data.
	PublicCertData *string
}

// VPNServerConfigVPNClientRevokedCertificate - Properties of the revoked VPN client certificate of VpnServerConfiguration.
type VPNServerConfigVPNClientRevokedCertificate struct {
	// The certificate name.
	Name *string

	// The revoked VPN client certificate thumbprint.
	Thumbprint *string
}

// VPNServerConfigVPNClientRootCertificate - Properties of VPN client root certificate of VpnServerConfiguration.
type VPNServerConfigVPNClientRootCertificate struct {
	// The certificate name.
	Name *string

	// The certificate public data.
	PublicCertData *string
}

// VPNServerConfiguration - VpnServerConfiguration Resource.
type VPNServerConfiguration struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the P2SVpnServer configuration.
	Properties *VPNServerConfigurationProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// VPNServerConfigurationPolicyGroup - VpnServerConfigurationPolicyGroup Resource.
type VPNServerConfigurationPolicyGroup struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the VpnServerConfigurationPolicyGroup.
	Properties *VPNServerConfigurationPolicyGroupProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource type.
	Type *string
}

// VPNServerConfigurationPolicyGroupMember - VpnServerConfiguration PolicyGroup member
type VPNServerConfigurationPolicyGroupMember struct {
	// The Vpn Policy member attribute type.
	AttributeType *VPNPolicyMemberAttributeType

	// The value of Attribute used for this VpnServerConfigurationPolicyGroupMember.
	AttributeValue *string

	// Name of the VpnServerConfigurationPolicyGroupMember.
	Name *string
}

// VPNServerConfigurationPolicyGroupProperties - Parameters for VpnServerConfigurationPolicyGroup.
type VPNServerConfigurationPolicyGroupProperties struct {
	// Shows if this is a Default VpnServerConfigurationPolicyGroup or not.
	IsDefault *bool

	// Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
	PolicyMembers []*VPNServerConfigurationPolicyGroupMember

	// Priority for VpnServerConfigurationPolicyGroup.
	Priority *int32

	// READ-ONLY; List of references to P2SConnectionConfigurations.
	P2SConnectionConfigurations []*SubResource

	// READ-ONLY; The provisioning state of the VpnServerConfigurationPolicyGroup resource.
	ProvisioningState *ProvisioningState
}

// VPNServerConfigurationProperties - Parameters for VpnServerConfiguration.
type VPNServerConfigurationProperties struct {
	// The set of aad vpn authentication parameters.
	AADAuthenticationParameters *AADAuthenticationParameters

	// List of all VpnServerConfigurationPolicyGroups.
	ConfigurationPolicyGroups []*VPNServerConfigurationPolicyGroup

	// The name of the VpnServerConfiguration that is unique within a resource group.
	Name *string

	// Radius client root certificate of VpnServerConfiguration.
	RadiusClientRootCertificates []*VPNServerConfigRadiusClientRootCertificate

	// The radius server address property of the VpnServerConfiguration resource for point to site client connection.
	RadiusServerAddress *string

	// Radius Server root certificate of VpnServerConfiguration.
	RadiusServerRootCertificates []*VPNServerConfigRadiusServerRootCertificate

	// The radius secret property of the VpnServerConfiguration resource for point to site client connection.
	RadiusServerSecret *string

	// Multiple Radius Server configuration for VpnServerConfiguration.
	RadiusServers []*RadiusServer

	// VPN authentication types for the VpnServerConfiguration.
	VPNAuthenticationTypes []*VPNAuthenticationType

	// VpnClientIpsecPolicies for VpnServerConfiguration.
	VPNClientIPSecPolicies []*IPSecPolicy

	// VPN client revoked certificate of VpnServerConfiguration.
	VPNClientRevokedCertificates []*VPNServerConfigVPNClientRevokedCertificate

	// VPN client root certificate of VpnServerConfiguration.
	VPNClientRootCertificates []*VPNServerConfigVPNClientRootCertificate

	// VPN protocols for the VpnServerConfiguration.
	VPNProtocols []*VPNGatewayTunnelingProtocol

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; List of references to P2SVpnGateways.
	P2SVPNGateways []*P2SVPNGateway

	// READ-ONLY; The provisioning state of the VpnServerConfiguration resource. Possible values are: 'Updating', 'Deleting',
	// and 'Failed'.
	ProvisioningState *string
}

// VPNServerConfigurationsResponse - VpnServerConfigurations list associated with VirtualWan Response.
type VPNServerConfigurationsResponse struct {
	// List of VpnServerConfigurations associated with VirtualWan.
	VPNServerConfigurationResourceIDs []*string
}

// VPNSite - VpnSite Resource.
type VPNSite struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the VPN site.
	Properties *VPNSiteProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// VPNSiteID - VpnSite Resource.
type VPNSiteID struct {
	// READ-ONLY; The resource-uri of the vpn-site for which config is to be fetched.
	VPNSite *string
}

// VPNSiteLink - VpnSiteLink Resource.
type VPNSiteLink struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the VPN site link.
	Properties *VPNSiteLinkProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource type.
	Type *string
}

// VPNSiteLinkConnection - VpnSiteLinkConnection Resource.
type VPNSiteLinkConnection struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the VPN site link connection.
	Properties *VPNSiteLinkConnectionProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource type.
	Type *string
}

// VPNSiteLinkConnectionProperties - Parameters for VpnConnection.
type VPNSiteLinkConnectionProperties struct {
	// Expected bandwidth in MBPS.
	ConnectionBandwidth *int32

	// List of egress NatRules.
	EgressNatRules []*SubResource

	// EnableBgp flag.
	EnableBgp *bool

	// EnableBgp flag.
	EnableRateLimiting *bool

	// The IPSec Policies to be considered by this connection.
	IPSecPolicies []*IPSecPolicy

	// List of ingress NatRules.
	IngressNatRules []*SubResource

	// Routing weight for vpn connection.
	RoutingWeight *int32

	// SharedKey for the vpn connection.
	SharedKey *string

	// Use local azure ip to initiate connection.
	UseLocalAzureIPAddress *bool

	// Enable policy-based traffic selectors.
	UsePolicyBasedTrafficSelectors *bool

	// Connection protocol used for this connection.
	VPNConnectionProtocolType *VirtualNetworkGatewayConnectionProtocol

	// vpnGatewayCustomBgpAddresses used by this connection.
	VPNGatewayCustomBgpAddresses []*GatewayCustomBgpIPAddressIPConfiguration

	// Vpn link connection mode.
	VPNLinkConnectionMode *VPNLinkConnectionMode

	// Id of the connected vpn site link.
	VPNSiteLink *SubResource

	// READ-ONLY; The connection status.
	ConnectionStatus *VPNConnectionStatus

	// READ-ONLY; Egress bytes transferred.
	EgressBytesTransferred *int64

	// READ-ONLY; Ingress bytes transferred.
	IngressBytesTransferred *int64

	// READ-ONLY; The provisioning state of the VPN site link connection resource.
	ProvisioningState *ProvisioningState
}

// VPNSiteLinkProperties - Parameters for VpnSite.
type VPNSiteLinkProperties struct {
	// The set of bgp properties.
	BgpProperties *VPNLinkBgpSettings

	// FQDN of vpn-site-link.
	Fqdn *string

	// The ip-address for the vpn-site-link.
	IPAddress *string

	// The link provider properties.
	LinkProperties *VPNLinkProviderProperties

	// READ-ONLY; The provisioning state of the VPN site link resource.
	ProvisioningState *ProvisioningState
}

// VPNSiteProperties - Parameters for VpnSite.
type VPNSiteProperties struct {
	// The AddressSpace that contains an array of IP address ranges.
	AddressSpace *AddressSpace

	// The set of bgp properties.
	BgpProperties *BgpSettings

	// The device properties.
	DeviceProperties *DeviceProperties

	// The ip-address for the vpn-site.
	IPAddress *string

	// IsSecuritySite flag.
	IsSecuritySite *bool

	// Office365 Policy.
	O365Policy *O365PolicyProperties

	// The key for vpn-site that can be used for connections.
	SiteKey *string

	// List of all vpn site links.
	VPNSiteLinks []*VPNSiteLink

	// The VirtualWAN to which the vpnSite belongs.
	VirtualWan *SubResource

	// READ-ONLY; The provisioning state of the VPN site resource.
	ProvisioningState *ProvisioningState
}

// VerificationIPFlowParameters - Parameters that define the IP flow to be verified.
type VerificationIPFlowParameters struct {
	// REQUIRED; The direction of the packet represented as a 5-tuple.
	Direction *Direction

	// REQUIRED; The local IP address. Acceptable values are valid IPv4 addresses.
	LocalIPAddress *string

	// REQUIRED; The local port. Acceptable values are a single integer in the range (0-65535). Support for * for the source port,
	// which depends on the direction.
	LocalPort *string

	// REQUIRED; Protocol to be verified on.
	Protocol *IPFlowProtocol

	// REQUIRED; The remote IP address. Acceptable values are valid IPv4 addresses.
	RemoteIPAddress *string

	// REQUIRED; The remote port. Acceptable values are a single integer in the range (0-65535). Support for * for the source
	// port, which depends on the direction.
	RemotePort *string

	// REQUIRED; The ID of the target resource to perform next-hop on.
	TargetResourceID *string

	// The NIC ID. (If VM has multiple NICs and IP forwarding is enabled on any of them, then this parameter must be specified.
	// Otherwise optional).
	TargetNicResourceID *string
}

// VerificationIPFlowResult - Results of IP flow verification on the target resource.
type VerificationIPFlowResult struct {
	// Indicates whether the traffic is allowed or denied.
	Access *Access

	// Name of the rule. If input is not matched against any security rule, it is not displayed.
	RuleName *string
}

// VirtualAppliance - NetworkVirtualAppliance Resource.
type VirtualAppliance struct {
	// Resource ID.
	ID *string

	// The service principal that has read access to cloud-init and config blob.
	Identity *ManagedServiceIdentity

	// Resource location.
	Location *string

	// Properties of the Network Virtual Appliance.
	Properties *VirtualAppliancePropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// VirtualApplianceAdditionalNicProperties - Network Virtual Appliance Additional NIC properties.
type VirtualApplianceAdditionalNicProperties struct {
	// Flag (true or false) for Intent for Public Ip on additional nic
	HasPublicIP *bool

	// Name of additional nic
	Name *string
}

// VirtualApplianceConnection - NetworkVirtualApplianceConnection resource.
type VirtualApplianceConnection struct {
	// Resource ID.
	ID *string

	// The name of the resource.
	Name *string

	// Properties of the express route connection.
	Properties *VirtualApplianceConnectionProperties
}

// VirtualApplianceConnectionList - NetworkVirtualApplianceConnection list.
type VirtualApplianceConnectionList struct {
	// URL to get the next set of results.
	NextLink *string

	// The list of NetworkVirtualAppliance connections.
	Value []*VirtualApplianceConnection
}

// VirtualApplianceConnectionProperties - Properties of the NetworkVirtualApplianceConnection subresource.
type VirtualApplianceConnectionProperties struct {
	// Network Virtual Appliance ASN.
	Asn *int64

	// List of bgpPeerAddresses for the NVA instances
	BgpPeerAddress []*string

	// Enable internet security.
	EnableInternetSecurity *bool

	// The name of the resource.
	Name *string

	// The Routing Configuration indicating the associated and propagated route tables on this connection.
	RoutingConfiguration *RoutingConfiguration

	// Unique identifier for the connection.
	TunnelIdentifier *int64

	// READ-ONLY; The provisioning state of the NetworkVirtualApplianceConnection resource.
	ProvisioningState *ProvisioningState
}

// VirtualApplianceListResult - Response for ListNetworkVirtualAppliances API service call.
type VirtualApplianceListResult struct {
	// URL to get the next set of results.
	NextLink *string

	// List of Network Virtual Appliances.
	Value []*VirtualAppliance
}

// VirtualApplianceNicProperties - Network Virtual Appliance NIC properties.
type VirtualApplianceNicProperties struct {
	// READ-ONLY; Instance on which nic is attached.
	InstanceName *string

	// READ-ONLY; NIC name.
	Name *string

	// READ-ONLY; Private IP address.
	PrivateIPAddress *string

	// READ-ONLY; Public IP address.
	PublicIPAddress *string
}

// VirtualAppliancePropertiesFormat - Network Virtual Appliance definition.
type VirtualAppliancePropertiesFormat struct {
	// Details required for Additional Network Interface.
	AdditionalNics []*VirtualApplianceAdditionalNicProperties

	// BootStrapConfigurationBlobs storage URLs.
	BootStrapConfigurationBlobs []*string

	// CloudInitConfiguration string in plain text.
	CloudInitConfiguration *string

	// CloudInitConfigurationBlob storage URLs.
	CloudInitConfigurationBlobs []*string

	// The delegation for the Virtual Appliance
	Delegation *DelegationProperties

	// List of Resource Uri of Public IPs for Internet Ingress Scenario.
	InternetIngressPublicIPs []*InternetIngressPublicIPsProperties

	// Network Virtual Appliance SKU.
	NvaSKU *VirtualApplianceSKUProperties

	// The delegation for the Virtual Appliance
	PartnerManagedResource *PartnerManagedResourceProperties

	// Public key for SSH login.
	SSHPublicKey *string

	// VirtualAppliance ASN. Microsoft private, public and IANA reserved ASN are not supported.
	VirtualApplianceAsn *int64

	// The Virtual Hub where Network Virtual Appliance is being deployed.
	VirtualHub *SubResource

	// READ-ONLY; Address Prefix.
	AddressPrefix *string

	// READ-ONLY; The deployment type. PartnerManaged for the SaaS NVA
	DeploymentType *string

	// READ-ONLY; List of references to InboundSecurityRules.
	InboundSecurityRules []*SubResource

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; List of references to VirtualApplianceConnections.
	VirtualApplianceConnections []*SubResource

	// READ-ONLY; List of Virtual Appliance Network Interfaces.
	VirtualApplianceNics []*VirtualApplianceNicProperties

	// READ-ONLY; List of references to VirtualApplianceSite.
	VirtualApplianceSites []*SubResource
}

// VirtualApplianceSKU - Definition of the NetworkVirtualApplianceSkus resource.
type VirtualApplianceSKU struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// NetworkVirtualApplianceSku properties.
	Properties *VirtualApplianceSKUPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// VirtualApplianceSKUInstances - List of available Sku and instances.
type VirtualApplianceSKUInstances struct {
	// READ-ONLY; Instance Count.
	InstanceCount *int32

	// READ-ONLY; Scale Unit.
	ScaleUnit *string
}

// VirtualApplianceSKUListResult - Response for ListNetworkVirtualApplianceSkus API service call.
type VirtualApplianceSKUListResult struct {
	// URL to get the next set of results.
	NextLink *string

	// List of Network Virtual Appliance Skus that are available.
	Value []*VirtualApplianceSKU
}

// VirtualApplianceSKUProperties - Network Virtual Appliance Sku Properties.
type VirtualApplianceSKUProperties struct {
	// Virtual Appliance Scale Unit.
	BundledScaleUnit *string

	// Virtual Appliance Version.
	MarketPlaceVersion *string

	// Virtual Appliance Vendor.
	Vendor *string
}

// VirtualApplianceSKUPropertiesFormat - Properties specific to NetworkVirtualApplianceSkus.
type VirtualApplianceSKUPropertiesFormat struct {
	// The list of scale units available.
	AvailableScaleUnits []*VirtualApplianceSKUInstances

	// READ-ONLY; Available Network Virtual Appliance versions.
	AvailableVersions []*string

	// READ-ONLY; Network Virtual Appliance Sku vendor.
	Vendor *string
}

// VirtualApplianceSite - Virtual Appliance Site resource.
type VirtualApplianceSite struct {
	// Resource ID.
	ID *string

	// Name of the virtual appliance site.
	Name *string

	// The properties of the Virtual Appliance Sites.
	Properties *VirtualApplianceSiteProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Site type.
	Type *string
}

// VirtualApplianceSiteListResult - Response for ListNetworkVirtualApplianceSites API service call.
type VirtualApplianceSiteListResult struct {
	// URL to get the next set of results.
	NextLink *string

	// List of Network Virtual Appliance sites.
	Value []*VirtualApplianceSite
}

// VirtualApplianceSiteProperties - Properties of the rule group.
type VirtualApplianceSiteProperties struct {
	// Address Prefix.
	AddressPrefix *string

	// Office 365 Policy.
	O365Policy *Office365PolicyProperties

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// VirtualHub Resource.
type VirtualHub struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the virtual hub.
	Properties *VirtualHubProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Kind of service virtual hub. This is metadata used for the Azure portal experience for Route Server.
	Kind *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// VirtualHubEffectiveRoute - The effective route configured on the virtual hub or specified resource.
type VirtualHubEffectiveRoute struct {
	// The list of address prefixes.
	AddressPrefixes []*string

	// The ASPath of this route.
	AsPath *string

	// The type of the next hop.
	NextHopType *string

	// The list of next hops.
	NextHops []*string

	// The origin of this route.
	RouteOrigin *string
}

// VirtualHubEffectiveRouteList - EffectiveRoutes List.
type VirtualHubEffectiveRouteList struct {
	// The list of effective routes configured on the virtual hub or the specified resource.
	Value []*VirtualHubEffectiveRoute
}

// VirtualHubID - Virtual Hub identifier.
type VirtualHubID struct {
	// The resource URI for the Virtual Hub where the ExpressRoute gateway is or will be deployed. The Virtual Hub resource and
	// the ExpressRoute gateway resource reside in the same subscription.
	ID *string
}

// VirtualHubProperties - Parameters for VirtualHub.
type VirtualHubProperties struct {
	// Address-prefix for this VirtualHub.
	AddressPrefix *string

	// Flag to control transit for VirtualRouter hub.
	AllowBranchToBranchTraffic *bool

	// The azureFirewall associated with this VirtualHub.
	AzureFirewall *SubResource

	// The expressRouteGateway associated with this VirtualHub.
	ExpressRouteGateway *SubResource

	// The hubRoutingPreference of this VirtualHub.
	HubRoutingPreference *HubRoutingPreference

	// The P2SVpnGateway associated with this VirtualHub.
	P2SVPNGateway *SubResource

	// The preferred gateway to route on-prem traffic
	PreferredRoutingGateway *PreferredRoutingGateway

	// The routeTable associated with this virtual hub.
	RouteTable *VirtualHubRouteTable

	// The sku of this VirtualHub.
	SKU *string

	// The securityPartnerProvider associated with this VirtualHub.
	SecurityPartnerProvider *SubResource

	// The Security Provider name.
	SecurityProviderName *string

	// The VpnGateway associated with this VirtualHub.
	VPNGateway *SubResource

	// List of all virtual hub route table v2s associated with this VirtualHub.
	VirtualHubRouteTableV2S []*VirtualHubRouteTableV2

	// VirtualRouter ASN.
	VirtualRouterAsn *int64

	// The VirtualHub Router autoscale configuration.
	VirtualRouterAutoScaleConfiguration *VirtualRouterAutoScaleConfiguration

	// VirtualRouter IPs.
	VirtualRouterIPs []*string

	// The VirtualWAN to which the VirtualHub belongs.
	VirtualWan *SubResource

	// READ-ONLY; List of references to Bgp Connections.
	BgpConnections []*SubResource

	// READ-ONLY; List of references to IpConfigurations.
	IPConfigurations []*SubResource

	// READ-ONLY; The provisioning state of the virtual hub resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; List of references to RouteMaps.
	RouteMaps []*SubResource

	// READ-ONLY; The routing state.
	RoutingState *RoutingState
}

// VirtualHubRoute - VirtualHub route.
type VirtualHubRoute struct {
	// List of all addressPrefixes.
	AddressPrefixes []*string

	// NextHop ip address.
	NextHopIPAddress *string
}

// VirtualHubRouteTable - VirtualHub route table.
type VirtualHubRouteTable struct {
	// List of all routes.
	Routes []*VirtualHubRoute
}

// VirtualHubRouteTableV2 Resource.
type VirtualHubRouteTableV2 struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the virtual hub route table v2.
	Properties *VirtualHubRouteTableV2Properties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// VirtualHubRouteTableV2Properties - Parameters for VirtualHubRouteTableV2.
type VirtualHubRouteTableV2Properties struct {
	// List of all connections attached to this route table v2.
	AttachedConnections []*string

	// List of all routes.
	Routes []*VirtualHubRouteV2

	// READ-ONLY; The provisioning state of the virtual hub route table v2 resource.
	ProvisioningState *ProvisioningState
}

// VirtualHubRouteV2 - VirtualHubRouteTableV2 route.
type VirtualHubRouteV2 struct {
	// The type of destinations.
	DestinationType *string

	// List of all destinations.
	Destinations []*string

	// The type of next hops.
	NextHopType *string

	// NextHops ip address.
	NextHops []*string
}

// VirtualNetwork - Virtual Network resource.
type VirtualNetwork struct {
	// The extended location of the virtual network.
	ExtendedLocation *ExtendedLocation

	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the virtual network.
	Properties *VirtualNetworkPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// VirtualNetworkBgpCommunities - Bgp Communities sent over ExpressRoute with each route corresponding to a prefix in this
// VNET.
type VirtualNetworkBgpCommunities struct {
	// REQUIRED; The BGP community associated with the virtual network.
	VirtualNetworkCommunity *string

	// READ-ONLY; The BGP community associated with the region of the virtual network.
	RegionalCommunity *string
}

// VirtualNetworkConnectionGatewayReference - A reference to VirtualNetworkGateway or LocalNetworkGateway resource.
type VirtualNetworkConnectionGatewayReference struct {
	// REQUIRED; The ID of VirtualNetworkGateway or LocalNetworkGateway resource.
	ID *string
}

// VirtualNetworkDdosProtectionStatusResult - Response for GetVirtualNetworkDdosProtectionStatusOperation.
type VirtualNetworkDdosProtectionStatusResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The Ddos Protection Status Result for each public ip under a virtual network.
	Value []*PublicIPDdosProtectionStatusResult
}

// VirtualNetworkEncryption - Indicates if encryption is enabled on virtual network and if VM without encryption is allowed
// in encrypted VNet.
type VirtualNetworkEncryption struct {
	// REQUIRED; Indicates if encryption is enabled on the virtual network.
	Enabled *bool

	// If the encrypted VNet allows VM that does not support encryption
	Enforcement *VirtualNetworkEncryptionEnforcement
}

// VirtualNetworkGateway - A common class for general resource information.
type VirtualNetworkGateway struct {
	// REQUIRED; Properties of the virtual network gateway.
	Properties *VirtualNetworkGatewayPropertiesFormat

	// The extended location of type local virtual network gateway.
	ExtendedLocation *ExtendedLocation

	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

type VirtualNetworkGatewayAutoScaleBounds struct {
	// Maximum Scale Units for Autoscale configuration
	Max *int32

	// Minimum scale Units for Autoscale configuration
	Min *int32
}

// VirtualNetworkGatewayAutoScaleConfiguration - Virtual Network Gateway Autoscale Configuration details
type VirtualNetworkGatewayAutoScaleConfiguration struct {
	// The bounds of the autoscale configuration
	Bounds *VirtualNetworkGatewayAutoScaleBounds
}

// VirtualNetworkGatewayConnection - A common class for general resource information.
type VirtualNetworkGatewayConnection struct {
	// REQUIRED; Properties of the virtual network gateway connection.
	Properties *VirtualNetworkGatewayConnectionPropertiesFormat

	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// VirtualNetworkGatewayConnectionListEntity - A common class for general resource information.
type VirtualNetworkGatewayConnectionListEntity struct {
	// REQUIRED; Properties of the virtual network gateway connection.
	Properties *VirtualNetworkGatewayConnectionListEntityPropertiesFormat

	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// VirtualNetworkGatewayConnectionListEntityPropertiesFormat - VirtualNetworkGatewayConnection properties.
type VirtualNetworkGatewayConnectionListEntityPropertiesFormat struct {
	// REQUIRED; Gateway connection type.
	ConnectionType *VirtualNetworkGatewayConnectionType

	// REQUIRED; The reference to virtual network gateway resource.
	VirtualNetworkGateway1 *VirtualNetworkConnectionGatewayReference

	// The authorizationKey.
	AuthorizationKey *string

	// The connection mode for this connection.
	ConnectionMode *VirtualNetworkGatewayConnectionMode

	// Connection protocol used for this connection.
	ConnectionProtocol *VirtualNetworkGatewayConnectionProtocol

	// EnableBgp flag.
	EnableBgp *bool

	// Bypass the ExpressRoute gateway when accessing private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be
	// enabled.
	EnablePrivateLinkFastPath *bool

	// Bypass ExpressRoute Gateway for data forwarding.
	ExpressRouteGatewayBypass *bool

	// GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection.
	GatewayCustomBgpIPAddresses []*GatewayCustomBgpIPAddressIPConfiguration

	// The IPSec Policies to be considered by this connection.
	IPSecPolicies []*IPSecPolicy

	// The reference to local network gateway resource.
	LocalNetworkGateway2 *VirtualNetworkConnectionGatewayReference

	// The reference to peerings resource.
	Peer *SubResource

	// The routing weight.
	RoutingWeight *int32

	// The IPSec shared key.
	SharedKey *string

	// The Traffic Selector Policies to be considered by this connection.
	TrafficSelectorPolicies []*TrafficSelectorPolicy

	// Enable policy-based traffic selectors.
	UsePolicyBasedTrafficSelectors *bool

	// The reference to virtual network gateway resource.
	VirtualNetworkGateway2 *VirtualNetworkConnectionGatewayReference

	// READ-ONLY; Virtual Network Gateway connection status.
	ConnectionStatus *VirtualNetworkGatewayConnectionStatus

	// READ-ONLY; The egress bytes transferred in this connection.
	EgressBytesTransferred *int64

	// READ-ONLY; The ingress bytes transferred in this connection.
	IngressBytesTransferred *int64

	// READ-ONLY; The provisioning state of the virtual network gateway connection resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource GUID property of the virtual network gateway connection resource.
	ResourceGUID *string

	// READ-ONLY; Collection of all tunnels' connection health status.
	TunnelConnectionStatus []*TunnelConnectionHealth
}

// VirtualNetworkGatewayConnectionListResult - Response for the ListVirtualNetworkGatewayConnections API service call.
type VirtualNetworkGatewayConnectionListResult struct {
	// A list of VirtualNetworkGatewayConnection resources that exists in a resource group.
	Value []*VirtualNetworkGatewayConnection

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// VirtualNetworkGatewayConnectionPropertiesFormat - VirtualNetworkGatewayConnection properties.
type VirtualNetworkGatewayConnectionPropertiesFormat struct {
	// REQUIRED; Gateway connection type.
	ConnectionType *VirtualNetworkGatewayConnectionType

	// REQUIRED; The reference to virtual network gateway resource.
	VirtualNetworkGateway1 *VirtualNetworkGateway

	// The authorizationKey.
	AuthorizationKey *string

	// The connection mode for this connection.
	ConnectionMode *VirtualNetworkGatewayConnectionMode

	// Connection protocol used for this connection.
	ConnectionProtocol *VirtualNetworkGatewayConnectionProtocol

	// The dead peer detection timeout of this connection in seconds.
	DpdTimeoutSeconds *int32

	// List of egress NatRules.
	EgressNatRules []*SubResource

	// EnableBgp flag.
	EnableBgp *bool

	// Bypass the ExpressRoute gateway when accessing private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be
	// enabled.
	EnablePrivateLinkFastPath *bool

	// Bypass ExpressRoute Gateway for data forwarding.
	ExpressRouteGatewayBypass *bool

	// GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection.
	GatewayCustomBgpIPAddresses []*GatewayCustomBgpIPAddressIPConfiguration

	// The IPSec Policies to be considered by this connection.
	IPSecPolicies []*IPSecPolicy

	// List of ingress NatRules.
	IngressNatRules []*SubResource

	// The reference to local network gateway resource.
	LocalNetworkGateway2 *LocalNetworkGateway

	// The reference to peerings resource.
	Peer *SubResource

	// The routing weight.
	RoutingWeight *int32

	// The IPSec shared key.
	SharedKey *string

	// The Traffic Selector Policies to be considered by this connection.
	TrafficSelectorPolicies []*TrafficSelectorPolicy

	// Use private local Azure IP for the connection.
	UseLocalAzureIPAddress *bool

	// Enable policy-based traffic selectors.
	UsePolicyBasedTrafficSelectors *bool

	// The reference to virtual network gateway resource.
	VirtualNetworkGateway2 *VirtualNetworkGateway

	// READ-ONLY; Virtual Network Gateway connection status.
	ConnectionStatus *VirtualNetworkGatewayConnectionStatus

	// READ-ONLY; The egress bytes transferred in this connection.
	EgressBytesTransferred *int64

	// READ-ONLY; The ingress bytes transferred in this connection.
	IngressBytesTransferred *int64

	// READ-ONLY; The provisioning state of the virtual network gateway connection resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource GUID property of the virtual network gateway connection resource.
	ResourceGUID *string

	// READ-ONLY; Collection of all tunnels' connection health status.
	TunnelConnectionStatus []*TunnelConnectionHealth
}

// VirtualNetworkGatewayIPConfiguration - IP configuration for virtual network gateway.
type VirtualNetworkGatewayIPConfiguration struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the virtual network gateway ip configuration.
	Properties *VirtualNetworkGatewayIPConfigurationPropertiesFormat

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// VirtualNetworkGatewayIPConfigurationPropertiesFormat - Properties of VirtualNetworkGatewayIPConfiguration.
type VirtualNetworkGatewayIPConfigurationPropertiesFormat struct {
	// The private IP address allocation method.
	PrivateIPAllocationMethod *IPAllocationMethod

	// The reference to the public IP resource.
	PublicIPAddress *SubResource

	// The reference to the subnet resource.
	Subnet *SubResource

	// READ-ONLY; Private IP Address for this gateway.
	PrivateIPAddress *string

	// READ-ONLY; The provisioning state of the virtual network gateway IP configuration resource.
	ProvisioningState *ProvisioningState
}

// VirtualNetworkGatewayListConnectionsResult - Response for the VirtualNetworkGatewayListConnections API service call.
type VirtualNetworkGatewayListConnectionsResult struct {
	// A list of VirtualNetworkGatewayConnection resources that exists in a resource group.
	Value []*VirtualNetworkGatewayConnectionListEntity

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// VirtualNetworkGatewayListResult - Response for the ListVirtualNetworkGateways API service call.
type VirtualNetworkGatewayListResult struct {
	// A list of VirtualNetworkGateway resources that exists in a resource group.
	Value []*VirtualNetworkGateway

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// VirtualNetworkGatewayNatRule Resource.
type VirtualNetworkGatewayNatRule struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the Virtual Network Gateway NAT rule.
	Properties *VirtualNetworkGatewayNatRuleProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource type.
	Type *string
}

// VirtualNetworkGatewayNatRuleProperties - Parameters for VirtualNetworkGatewayNatRule.
type VirtualNetworkGatewayNatRuleProperties struct {
	// The private IP address external mapping for NAT.
	ExternalMappings []*VPNNatRuleMapping

	// The IP Configuration ID this NAT rule applies to.
	IPConfigurationID *string

	// The private IP address internal mapping for NAT.
	InternalMappings []*VPNNatRuleMapping

	// The Source NAT direction of a VPN NAT.
	Mode *VPNNatRuleMode

	// The type of NAT rule for VPN NAT.
	Type *VPNNatRuleType

	// READ-ONLY; The provisioning state of the NAT Rule resource.
	ProvisioningState *ProvisioningState
}

// VirtualNetworkGatewayPolicyGroup - Parameters for VirtualNetworkGatewayPolicyGroup.
type VirtualNetworkGatewayPolicyGroup struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of tVirtualNetworkGatewayPolicyGroup.
	Properties *VirtualNetworkGatewayPolicyGroupProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// VirtualNetworkGatewayPolicyGroupMember - Vpn Client Connection configuration PolicyGroup member
type VirtualNetworkGatewayPolicyGroupMember struct {
	// The Vpn Policy member attribute type.
	AttributeType *VPNPolicyMemberAttributeType

	// The value of Attribute used for this VirtualNetworkGatewayPolicyGroupMember.
	AttributeValue *string

	// Name of the VirtualNetworkGatewayPolicyGroupMember.
	Name *string
}

// VirtualNetworkGatewayPolicyGroupProperties - Properties of VirtualNetworkGatewayPolicyGroup.
type VirtualNetworkGatewayPolicyGroupProperties struct {
	// REQUIRED; Shows if this is a Default VirtualNetworkGatewayPolicyGroup or not.
	IsDefault *bool

	// REQUIRED; Multiple PolicyMembers for VirtualNetworkGatewayPolicyGroup.
	PolicyMembers []*VirtualNetworkGatewayPolicyGroupMember

	// REQUIRED; Priority for VirtualNetworkGatewayPolicyGroup.
	Priority *int32

	// READ-ONLY; The provisioning state of the VirtualNetworkGatewayPolicyGroup resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; List of references to vngClientConnectionConfigurations.
	VngClientConnectionConfigurations []*SubResource
}

// VirtualNetworkGatewayPropertiesFormat - VirtualNetworkGateway properties.
type VirtualNetworkGatewayPropertiesFormat struct {
	// ActiveActive flag.
	Active *bool

	// Property to indicate if the Express Route Gateway serves traffic when there are multiple Express Route Gateways in the
	// vnet
	AdminState *AdminState

	// Configure this gateway to accept traffic from other Azure Virtual Networks. This configuration does not support connectivity
	// to Azure Virtual WAN.
	AllowRemoteVnetTraffic *bool

	// Configures this gateway to accept traffic from remote Virtual WAN networks.
	AllowVirtualWanTraffic *bool

	// Autoscale configuration for virutal network gateway
	AutoScaleConfiguration *VirtualNetworkGatewayAutoScaleConfiguration

	// Virtual network gateway's BGP speaker settings.
	BgpSettings *BgpSettings

	// The reference to the address space resource which represents the custom routes address space specified by the customer
	// for virtual network gateway and VpnClient.
	CustomRoutes *AddressSpace

	// disableIPSecReplayProtection flag.
	DisableIPSecReplayProtection *bool

	// Whether BGP is enabled for this virtual network gateway or not.
	EnableBgp *bool

	// EnableBgpRouteTranslationForNat flag.
	EnableBgpRouteTranslationForNat *bool

	// Whether dns forwarding is enabled or not.
	EnableDNSForwarding *bool

	// Whether private IP needs to be enabled on this gateway for connections or not.
	EnablePrivateIPAddress *bool

	// The reference to the LocalNetworkGateway resource which represents local network site having default routes. Assign Null
	// value in case of removing existing default site setting.
	GatewayDefaultSite *SubResource

	// The type of this virtual network gateway.
	GatewayType *VirtualNetworkGatewayType

	// IP configurations for virtual network gateway.
	IPConfigurations []*VirtualNetworkGatewayIPConfiguration

	// NatRules for virtual network gateway.
	NatRules []*VirtualNetworkGatewayNatRule

	// The reference to the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.
	SKU *VirtualNetworkGatewaySKU

	// Customer vnet resource id. VirtualNetworkGateway of type local gateway is associated with the customer vnet.
	VNetExtendedLocationResourceID *string

	// The reference to the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
	VPNClientConfiguration *VPNClientConfiguration

	// The generation for this VirtualNetworkGateway. Must be None if gatewayType is not VPN.
	VPNGatewayGeneration *VPNGatewayGeneration

	// The type of this virtual network gateway.
	VPNType *VPNType

	// The reference to the VirtualNetworkGatewayPolicyGroup resource which represents the available VirtualNetworkGatewayPolicyGroup
	// for the gateway.
	VirtualNetworkGatewayPolicyGroups []*VirtualNetworkGatewayPolicyGroup

	// READ-ONLY; The IP address allocated by the gateway to which dns requests can be sent.
	InboundDNSForwardingEndpoint *string

	// READ-ONLY; The provisioning state of the virtual network gateway resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource GUID property of the virtual network gateway resource.
	ResourceGUID *string
}

// VirtualNetworkGatewaySKU - VirtualNetworkGatewaySku details.
type VirtualNetworkGatewaySKU struct {
	// Gateway SKU name.
	Name *VirtualNetworkGatewaySKUName

	// Gateway SKU tier.
	Tier *VirtualNetworkGatewaySKUTier

	// READ-ONLY; The capacity.
	Capacity *int32
}

// VirtualNetworkListResult - Response for the ListVirtualNetworks API service call.
type VirtualNetworkListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of VirtualNetwork resources in a resource group.
	Value []*VirtualNetwork
}

// VirtualNetworkListUsageResult - Response for the virtual networks GetUsage API service call.
type VirtualNetworkListUsageResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// READ-ONLY; VirtualNetwork usage stats.
	Value []*VirtualNetworkUsage
}

// VirtualNetworkPeering - Peerings in a virtual network resource.
type VirtualNetworkPeering struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the virtual network peering.
	Properties *VirtualNetworkPeeringPropertiesFormat

	// Resource type.
	Type *string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// VirtualNetworkPeeringListResult - Response for ListSubnets API service call. Retrieves all subnets that belong to a virtual
// network.
type VirtualNetworkPeeringListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The peerings in a virtual network.
	Value []*VirtualNetworkPeering
}

// VirtualNetworkPeeringPropertiesFormat - Properties of the virtual network peering.
type VirtualNetworkPeeringPropertiesFormat struct {
	// Whether the forwarded traffic from the VMs in the local virtual network will be allowed/disallowed in remote virtual network.
	AllowForwardedTraffic *bool

	// If gateway links can be used in remote virtual networking to link to this virtual network.
	AllowGatewayTransit *bool

	// Whether the VMs in the local virtual network space would be able to access the VMs in remote virtual network space.
	AllowVirtualNetworkAccess *bool

	// If we need to verify the provisioning state of the remote gateway.
	DoNotVerifyRemoteGateways *bool

	// The status of the virtual network peering.
	PeeringState *VirtualNetworkPeeringState

	// The peering sync status of the virtual network peering.
	PeeringSyncLevel *VirtualNetworkPeeringLevel

	// The reference to the address space peered with the remote virtual network.
	RemoteAddressSpace *AddressSpace

	// The reference to the remote virtual network's Bgp Communities.
	RemoteBgpCommunities *VirtualNetworkBgpCommunities

	// The reference to the remote virtual network. The remote virtual network can be in the same or different region (preview).
	// See here to register for the preview and learn more
	// (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
	RemoteVirtualNetwork *SubResource

	// The reference to the current address space of the remote virtual network.
	RemoteVirtualNetworkAddressSpace *AddressSpace

	// If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering
	// is also true, virtual network will use gateways of remote virtual network
	// for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a
	// gateway.
	UseRemoteGateways *bool

	// READ-ONLY; The provisioning state of the virtual network peering resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The reference to the remote virtual network's encryption
	RemoteVirtualNetworkEncryption *VirtualNetworkEncryption

	// READ-ONLY; The resourceGuid property of the Virtual Network peering resource.
	ResourceGUID *string
}

// VirtualNetworkPropertiesFormat - Properties of the virtual network.
type VirtualNetworkPropertiesFormat struct {
	// The AddressSpace that contains an array of IP address ranges that can be used by subnets.
	AddressSpace *AddressSpace

	// Bgp Communities sent over ExpressRoute with each route corresponding to a prefix in this VNET.
	BgpCommunities *VirtualNetworkBgpCommunities

	// The DDoS protection plan associated with the virtual network.
	DdosProtectionPlan *SubResource

	// The dhcpOptions that contains an array of DNS servers available to VMs deployed in the virtual network.
	DhcpOptions *DhcpOptions

	// Indicates if DDoS protection is enabled for all the protected resources in the virtual network. It requires a DDoS protection
	// plan associated with the resource.
	EnableDdosProtection *bool

	// Indicates if VM protection is enabled for all the subnets in the virtual network.
	EnableVMProtection *bool

	// Indicates if encryption is enabled on virtual network and if VM without encryption is allowed in encrypted VNet.
	Encryption *VirtualNetworkEncryption

	// The FlowTimeout value (in minutes) for the Virtual Network
	FlowTimeoutInMinutes *int32

	// Array of IpAllocation which reference this VNET.
	IPAllocations []*SubResource

	// A list of subnets in a Virtual Network.
	Subnets []*Subnet

	// A list of peerings in a Virtual Network.
	VirtualNetworkPeerings []*VirtualNetworkPeering

	// READ-ONLY; A collection of references to flow log resources.
	FlowLogs []*FlowLog

	// READ-ONLY; The provisioning state of the virtual network resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resourceGuid property of the Virtual Network resource.
	ResourceGUID *string
}

// VirtualNetworkTap - Virtual Network Tap resource.
type VirtualNetworkTap struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Virtual Network Tap Properties.
	Properties *VirtualNetworkTapPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// VirtualNetworkTapListResult - Response for ListVirtualNetworkTap API service call.
type VirtualNetworkTapListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of VirtualNetworkTaps in a resource group.
	Value []*VirtualNetworkTap
}

// VirtualNetworkTapPropertiesFormat - Virtual Network Tap properties.
type VirtualNetworkTapPropertiesFormat struct {
	// The reference to the private IP address on the internal Load Balancer that will receive the tap.
	DestinationLoadBalancerFrontEndIPConfiguration *FrontendIPConfiguration

	// The reference to the private IP Address of the collector nic that will receive the tap.
	DestinationNetworkInterfaceIPConfiguration *InterfaceIPConfiguration

	// The VXLAN destination port that will receive the tapped traffic.
	DestinationPort *int32

	// READ-ONLY; Specifies the list of resource IDs for the network interface IP configuration that needs to be tapped.
	NetworkInterfaceTapConfigurations []*InterfaceTapConfiguration

	// READ-ONLY; The provisioning state of the virtual network tap resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource GUID property of the virtual network tap resource.
	ResourceGUID *string
}

// VirtualNetworkUsage - Usage details for subnet.
type VirtualNetworkUsage struct {
	// READ-ONLY; Indicates number of IPs used from the Subnet.
	CurrentValue *float64

	// READ-ONLY; Subnet identifier.
	ID *string

	// READ-ONLY; Indicates the size of the subnet.
	Limit *float64

	// READ-ONLY; The name containing common and localized value for usage.
	Name *VirtualNetworkUsageName

	// READ-ONLY; Usage units. Returns 'Count'.
	Unit *string
}

// VirtualNetworkUsageName - Usage strings container.
type VirtualNetworkUsageName struct {
	// READ-ONLY; Localized subnet size and usage string.
	LocalizedValue *string

	// READ-ONLY; Subnet size and usage string.
	Value *string
}

// VirtualRouter Resource.
type VirtualRouter struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the Virtual Router.
	Properties *VirtualRouterPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// VirtualRouterAutoScaleConfiguration - The VirtualHub Router autoscale configuration.
type VirtualRouterAutoScaleConfiguration struct {
	// The minimum number of scale units for VirtualHub Router.
	MinCapacity *int32
}

// VirtualRouterListResult - Response for ListVirtualRouters API service call.
type VirtualRouterListResult struct {
	// URL to get the next set of results.
	NextLink *string

	// List of Virtual Routers.
	Value []*VirtualRouter
}

// VirtualRouterPeering - Virtual Router Peering resource.
type VirtualRouterPeering struct {
	// Resource ID.
	ID *string

	// Name of the virtual router peering that is unique within a virtual router.
	Name *string

	// The properties of the Virtual Router Peering.
	Properties *VirtualRouterPeeringProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Peering type.
	Type *string
}

// VirtualRouterPeeringListResult - Response for ListVirtualRouterPeerings API service call.
type VirtualRouterPeeringListResult struct {
	// URL to get the next set of results.
	NextLink *string

	// List of VirtualRouterPeerings in a VirtualRouter.
	Value []*VirtualRouterPeering
}

// VirtualRouterPeeringProperties - Properties of the rule group.
type VirtualRouterPeeringProperties struct {
	// Peer ASN.
	PeerAsn *int64

	// Peer IP.
	PeerIP *string

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// VirtualRouterPropertiesFormat - Virtual Router definition.
type VirtualRouterPropertiesFormat struct {
	// The Gateway on which VirtualRouter is hosted.
	HostedGateway *SubResource

	// The Subnet on which VirtualRouter is hosted.
	HostedSubnet *SubResource

	// VirtualRouter ASN.
	VirtualRouterAsn *int64

	// VirtualRouter IPs.
	VirtualRouterIPs []*string

	// READ-ONLY; List of references to VirtualRouterPeerings.
	Peerings []*SubResource

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// VirtualWAN Resource.
type VirtualWAN struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the virtual WAN.
	Properties *VirtualWanProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// VirtualWanProperties - Parameters for VirtualWAN.
type VirtualWanProperties struct {
	// True if branch to branch traffic is allowed.
	AllowBranchToBranchTraffic *bool

	// True if Vnet to Vnet traffic is allowed.
	AllowVnetToVnetTraffic *bool

	// Vpn encryption to be disabled or not.
	DisableVPNEncryption *bool

	// The type of the VirtualWAN.
	Type *string

	// READ-ONLY; The office local breakout category.
	Office365LocalBreakoutCategory *OfficeTrafficCategory

	// READ-ONLY; The provisioning state of the virtual WAN resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; List of VpnSites in the VirtualWAN.
	VPNSites []*SubResource

	// READ-ONLY; List of VirtualHubs in the VirtualWAN.
	VirtualHubs []*SubResource
}

// VirtualWanSecurityProvider - Collection of SecurityProviders.
type VirtualWanSecurityProvider struct {
	// Name of the security provider.
	Name *string

	// Url of the security provider.
	URL *string

	// READ-ONLY; Name of the security provider.
	Type *VirtualWanSecurityProviderType
}

// VirtualWanSecurityProviders - Collection of SecurityProviders.
type VirtualWanSecurityProviders struct {
	// List of VirtualWAN security providers.
	SupportedProviders []*VirtualWanSecurityProvider
}

// VirtualWanVPNProfileParameters - Virtual Wan Vpn profile parameters Vpn profile generation.
type VirtualWanVPNProfileParameters struct {
	// VPN client authentication method.
	AuthenticationMethod *AuthenticationMethod

	// VpnServerConfiguration partial resource uri with which VirtualWan is associated to.
	VPNServerConfigurationResourceID *string
}

// VnetRoute - List of routes that control routing from VirtualHub into a virtual network connection.
type VnetRoute struct {
	// List of all Static Routes.
	StaticRoutes []*StaticRoute

	// Configuration for static routes on this HubVnetConnection.
	StaticRoutesConfig *StaticRoutesConfig

	// READ-ONLY; The list of references to HubBgpConnection objects.
	BgpConnections []*SubResource
}

// VngClientConnectionConfiguration - A vpn client connection configuration for client connection configuration.
type VngClientConnectionConfiguration struct {
	// Resource ID.
	ID *string

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// Properties of the vpn client root certificate.
	Properties *VngClientConnectionConfigurationProperties

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// VngClientConnectionConfigurationProperties - Properties of VngClientConnectionConfiguration.
type VngClientConnectionConfigurationProperties struct {
	// REQUIRED; The reference to the address space resource which represents Address space for P2S VpnClient.
	VPNClientAddressPool *AddressSpace

	// REQUIRED; List of references to virtualNetworkGatewayPolicyGroups
	VirtualNetworkGatewayPolicyGroups []*SubResource

	// READ-ONLY; The provisioning state of the VngClientConnectionConfiguration resource.
	ProvisioningState *ProvisioningState
}

// Watcher - Network watcher in a resource group.
type Watcher struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the network watcher.
	Properties *WatcherPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// WatcherListResult - Response for ListNetworkWatchers API service call.
type WatcherListResult struct {
	// List of network watcher resources.
	Value []*Watcher
}

// WatcherPropertiesFormat - The network watcher properties.
type WatcherPropertiesFormat struct {
	// READ-ONLY; The provisioning state of the network watcher resource.
	ProvisioningState *ProvisioningState
}

// WebApplicationFirewallCustomRule - Defines contents of a web application rule.
type WebApplicationFirewallCustomRule struct {
	// REQUIRED; Type of Actions.
	Action *WebApplicationFirewallAction

	// REQUIRED; List of match conditions.
	MatchConditions []*MatchCondition

	// REQUIRED; Priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
	Priority *int32

	// REQUIRED; The rule type.
	RuleType *WebApplicationFirewallRuleType

	// List of user session identifier group by clauses.
	GroupByUserSession []*GroupByUserSession

	// The name of the resource that is unique within a policy. This name can be used to access the resource.
	Name *string

	// Duration over which Rate Limit policy will be applied. Applies only when ruleType is RateLimitRule.
	RateLimitDuration *ApplicationGatewayFirewallRateLimitDuration

	// Rate Limit threshold to apply in case ruleType is RateLimitRule. Must be greater than or equal to 1
	RateLimitThreshold *int32

	// Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
	State *WebApplicationFirewallState

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string
}

// WebApplicationFirewallPolicy - Defines web application firewall policy.
type WebApplicationFirewallPolicy struct {
	// Resource ID.
	ID *string

	// Resource location.
	Location *string

	// Properties of the web application firewall policy.
	Properties *WebApplicationFirewallPolicyPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// WebApplicationFirewallPolicyListResult - Result of the request to list WebApplicationFirewallPolicies. It contains a list
// of WebApplicationFirewallPolicy objects and a URL link to get the next set of results.
type WebApplicationFirewallPolicyListResult struct {
	// READ-ONLY; URL to get the next set of WebApplicationFirewallPolicy objects if there are any.
	NextLink *string

	// READ-ONLY; List of WebApplicationFirewallPolicies within a resource group.
	Value []*WebApplicationFirewallPolicy
}

// WebApplicationFirewallPolicyPropertiesFormat - Defines web application firewall policy properties.
type WebApplicationFirewallPolicyPropertiesFormat struct {
	// REQUIRED; Describes the managedRules structure.
	ManagedRules *ManagedRulesDefinition

	// The custom rules inside the policy.
	CustomRules []*WebApplicationFirewallCustomRule

	// The PolicySettings for policy.
	PolicySettings *PolicySettings

	// READ-ONLY; A collection of references to application gateways.
	ApplicationGateways []*ApplicationGateway

	// READ-ONLY; A collection of references to application gateway http listeners.
	HTTPListeners []*SubResource

	// READ-ONLY; A collection of references to application gateway path rules.
	PathBasedRules []*SubResource

	// READ-ONLY; The provisioning state of the web application firewall policy resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Resource status of the policy.
	ResourceState *WebApplicationFirewallPolicyResourceState
}

// WebApplicationFirewallScrubbingRules - Allow certain variables to be scrubbed on WAF logs
type WebApplicationFirewallScrubbingRules struct {
	// REQUIRED; The variable to be scrubbed from the logs.
	MatchVariable *ScrubbingRuleEntryMatchVariable

	// REQUIRED; When matchVariable is a collection, operate on the selector to specify which elements in the collection this
	// rule applies to.
	SelectorMatchOperator *ScrubbingRuleEntryMatchOperator

	// When matchVariable is a collection, operator used to specify which elements in the collection this rule applies to.
	Selector *string

	// Defines the state of log scrubbing rule. Default value is Enabled.
	State *ScrubbingRuleEntryState
}
