//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v5"
	"net/http"
	"net/url"
	"regexp"
)

// RouteFilterRulesServer is a fake server for instances of the armnetwork.RouteFilterRulesClient type.
type RouteFilterRulesServer struct {
	// BeginCreateOrUpdate is the fake for method RouteFilterRulesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, routeFilterName string, ruleName string, routeFilterRuleParameters armnetwork.RouteFilterRule, options *armnetwork.RouteFilterRulesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armnetwork.RouteFilterRulesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method RouteFilterRulesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, routeFilterName string, ruleName string, options *armnetwork.RouteFilterRulesClientBeginDeleteOptions) (resp azfake.PollerResponder[armnetwork.RouteFilterRulesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method RouteFilterRulesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, routeFilterName string, ruleName string, options *armnetwork.RouteFilterRulesClientGetOptions) (resp azfake.Responder[armnetwork.RouteFilterRulesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByRouteFilterPager is the fake for method RouteFilterRulesClient.NewListByRouteFilterPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByRouteFilterPager func(resourceGroupName string, routeFilterName string, options *armnetwork.RouteFilterRulesClientListByRouteFilterOptions) (resp azfake.PagerResponder[armnetwork.RouteFilterRulesClientListByRouteFilterResponse])
}

// NewRouteFilterRulesServerTransport creates a new instance of RouteFilterRulesServerTransport with the provided implementation.
// The returned RouteFilterRulesServerTransport instance is connected to an instance of armnetwork.RouteFilterRulesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewRouteFilterRulesServerTransport(srv *RouteFilterRulesServer) *RouteFilterRulesServerTransport {
	return &RouteFilterRulesServerTransport{
		srv:                       srv,
		beginCreateOrUpdate:       newTracker[azfake.PollerResponder[armnetwork.RouteFilterRulesClientCreateOrUpdateResponse]](),
		beginDelete:               newTracker[azfake.PollerResponder[armnetwork.RouteFilterRulesClientDeleteResponse]](),
		newListByRouteFilterPager: newTracker[azfake.PagerResponder[armnetwork.RouteFilterRulesClientListByRouteFilterResponse]](),
	}
}

// RouteFilterRulesServerTransport connects instances of armnetwork.RouteFilterRulesClient to instances of RouteFilterRulesServer.
// Don't use this type directly, use NewRouteFilterRulesServerTransport instead.
type RouteFilterRulesServerTransport struct {
	srv                       *RouteFilterRulesServer
	beginCreateOrUpdate       *tracker[azfake.PollerResponder[armnetwork.RouteFilterRulesClientCreateOrUpdateResponse]]
	beginDelete               *tracker[azfake.PollerResponder[armnetwork.RouteFilterRulesClientDeleteResponse]]
	newListByRouteFilterPager *tracker[azfake.PagerResponder[armnetwork.RouteFilterRulesClientListByRouteFilterResponse]]
}

// Do implements the policy.Transporter interface for RouteFilterRulesServerTransport.
func (r *RouteFilterRulesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "RouteFilterRulesClient.BeginCreateOrUpdate":
		resp, err = r.dispatchBeginCreateOrUpdate(req)
	case "RouteFilterRulesClient.BeginDelete":
		resp, err = r.dispatchBeginDelete(req)
	case "RouteFilterRulesClient.Get":
		resp, err = r.dispatchGet(req)
	case "RouteFilterRulesClient.NewListByRouteFilterPager":
		resp, err = r.dispatchNewListByRouteFilterPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *RouteFilterRulesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if r.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := r.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/routeFilters/(?P<routeFilterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/routeFilterRules/(?P<ruleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.RouteFilterRule](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		routeFilterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("routeFilterName")])
		if err != nil {
			return nil, err
		}
		ruleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("ruleName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, routeFilterNameParam, ruleNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		r.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		r.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		r.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (r *RouteFilterRulesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if r.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := r.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/routeFilters/(?P<routeFilterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/routeFilterRules/(?P<ruleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		routeFilterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("routeFilterName")])
		if err != nil {
			return nil, err
		}
		ruleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("ruleName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginDelete(req.Context(), resourceGroupNameParam, routeFilterNameParam, ruleNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		r.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		r.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		r.beginDelete.remove(req)
	}

	return resp, nil
}

func (r *RouteFilterRulesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/routeFilters/(?P<routeFilterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/routeFilterRules/(?P<ruleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	routeFilterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("routeFilterName")])
	if err != nil {
		return nil, err
	}
	ruleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("ruleName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), resourceGroupNameParam, routeFilterNameParam, ruleNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RouteFilterRule, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RouteFilterRulesServerTransport) dispatchNewListByRouteFilterPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByRouteFilterPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByRouteFilterPager not implemented")}
	}
	newListByRouteFilterPager := r.newListByRouteFilterPager.get(req)
	if newListByRouteFilterPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/routeFilters/(?P<routeFilterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/routeFilterRules`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		routeFilterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("routeFilterName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListByRouteFilterPager(resourceGroupNameParam, routeFilterNameParam, nil)
		newListByRouteFilterPager = &resp
		r.newListByRouteFilterPager.add(req, newListByRouteFilterPager)
		server.PagerResponderInjectNextLinks(newListByRouteFilterPager, req, func(page *armnetwork.RouteFilterRulesClientListByRouteFilterResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByRouteFilterPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByRouteFilterPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByRouteFilterPager) {
		r.newListByRouteFilterPager.remove(req)
	}
	return resp, nil
}
