//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmysqlflexibleservers

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// LocationBasedCapabilitySetClient contains the methods for the LocationBasedCapabilitySet group.
// Don't use this type directly, use NewLocationBasedCapabilitySetClient() instead.
type LocationBasedCapabilitySetClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewLocationBasedCapabilitySetClient creates a new instance of LocationBasedCapabilitySetClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewLocationBasedCapabilitySetClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*LocationBasedCapabilitySetClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &LocationBasedCapabilitySetClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Get capabilities at specified location in a given subscription.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-30
//   - locationName - The name of the location.
//   - capabilitySetName - Name of capability set
//   - options - LocationBasedCapabilitySetClientGetOptions contains the optional parameters for the LocationBasedCapabilitySetClient.Get
//     method.
func (client *LocationBasedCapabilitySetClient) Get(ctx context.Context, locationName string, capabilitySetName string, options *LocationBasedCapabilitySetClientGetOptions) (LocationBasedCapabilitySetClientGetResponse, error) {
	var err error
	const operationName = "LocationBasedCapabilitySetClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, locationName, capabilitySetName, options)
	if err != nil {
		return LocationBasedCapabilitySetClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return LocationBasedCapabilitySetClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return LocationBasedCapabilitySetClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *LocationBasedCapabilitySetClient) getCreateRequest(ctx context.Context, locationName string, capabilitySetName string, options *LocationBasedCapabilitySetClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DBforMySQL/locations/{locationName}/capabilitySets/{capabilitySetName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if locationName == "" {
		return nil, errors.New("parameter locationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{locationName}", url.PathEscape(locationName))
	if capabilitySetName == "" {
		return nil, errors.New("parameter capabilitySetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{capabilitySetName}", url.PathEscape(capabilitySetName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-30")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *LocationBasedCapabilitySetClient) getHandleResponse(resp *http.Response) (LocationBasedCapabilitySetClientGetResponse, error) {
	result := LocationBasedCapabilitySetClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Capability); err != nil {
		return LocationBasedCapabilitySetClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Get capabilities at specified location in a given subscription.
//
// Generated from API version 2023-12-30
//   - locationName - The name of the location.
//   - options - LocationBasedCapabilitySetClientListOptions contains the optional parameters for the LocationBasedCapabilitySetClient.NewListPager
//     method.
func (client *LocationBasedCapabilitySetClient) NewListPager(locationName string, options *LocationBasedCapabilitySetClientListOptions) *runtime.Pager[LocationBasedCapabilitySetClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[LocationBasedCapabilitySetClientListResponse]{
		More: func(page LocationBasedCapabilitySetClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *LocationBasedCapabilitySetClientListResponse) (LocationBasedCapabilitySetClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "LocationBasedCapabilitySetClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, locationName, options)
			}, nil)
			if err != nil {
				return LocationBasedCapabilitySetClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *LocationBasedCapabilitySetClient) listCreateRequest(ctx context.Context, locationName string, options *LocationBasedCapabilitySetClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DBforMySQL/locations/{locationName}/capabilitySets"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if locationName == "" {
		return nil, errors.New("parameter locationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{locationName}", url.PathEscape(locationName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-30")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *LocationBasedCapabilitySetClient) listHandleResponse(resp *http.Response) (LocationBasedCapabilitySetClientListResponse, error) {
	result := LocationBasedCapabilitySetClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CapabilitySetsList); err != nil {
		return LocationBasedCapabilitySetClientListResponse{}, err
	}
	return result, nil
}
