//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mysql/armmysqlflexibleservers/v2"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// MaintenancesServer is a fake server for instances of the armmysqlflexibleservers.MaintenancesClient type.
type MaintenancesServer struct {
	// NewListPager is the fake for method MaintenancesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, serverName string, options *armmysqlflexibleservers.MaintenancesClientListOptions) (resp azfake.PagerResponder[armmysqlflexibleservers.MaintenancesClientListResponse])

	// Read is the fake for method MaintenancesClient.Read
	// HTTP status codes to indicate success: http.StatusOK
	Read func(ctx context.Context, resourceGroupName string, serverName string, maintenanceName string, options *armmysqlflexibleservers.MaintenancesClientReadOptions) (resp azfake.Responder[armmysqlflexibleservers.MaintenancesClientReadResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method MaintenancesClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, serverName string, maintenanceName string, options *armmysqlflexibleservers.MaintenancesClientBeginUpdateOptions) (resp azfake.PollerResponder[armmysqlflexibleservers.MaintenancesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewMaintenancesServerTransport creates a new instance of MaintenancesServerTransport with the provided implementation.
// The returned MaintenancesServerTransport instance is connected to an instance of armmysqlflexibleservers.MaintenancesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMaintenancesServerTransport(srv *MaintenancesServer) *MaintenancesServerTransport {
	return &MaintenancesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armmysqlflexibleservers.MaintenancesClientListResponse]](),
		beginUpdate:  newTracker[azfake.PollerResponder[armmysqlflexibleservers.MaintenancesClientUpdateResponse]](),
	}
}

// MaintenancesServerTransport connects instances of armmysqlflexibleservers.MaintenancesClient to instances of MaintenancesServer.
// Don't use this type directly, use NewMaintenancesServerTransport instead.
type MaintenancesServerTransport struct {
	srv          *MaintenancesServer
	newListPager *tracker[azfake.PagerResponder[armmysqlflexibleservers.MaintenancesClientListResponse]]
	beginUpdate  *tracker[azfake.PollerResponder[armmysqlflexibleservers.MaintenancesClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for MaintenancesServerTransport.
func (m *MaintenancesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MaintenancesClient.NewListPager":
		resp, err = m.dispatchNewListPager(req)
	case "MaintenancesClient.Read":
		resp, err = m.dispatchRead(req)
	case "MaintenancesClient.BeginUpdate":
		resp, err = m.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MaintenancesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := m.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DBforMySQL/flexibleServers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/maintenances`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListPager(resourceGroupNameParam, serverNameParam, nil)
		newListPager = &resp
		m.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armmysqlflexibleservers.MaintenancesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		m.newListPager.remove(req)
	}
	return resp, nil
}

func (m *MaintenancesServerTransport) dispatchRead(req *http.Request) (*http.Response, error) {
	if m.srv.Read == nil {
		return nil, &nonRetriableError{errors.New("fake for method Read not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DBforMySQL/flexibleServers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/maintenances/(?P<maintenanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	maintenanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("maintenanceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Read(req.Context(), resourceGroupNameParam, serverNameParam, maintenanceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Maintenance, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MaintenancesServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := m.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DBforMySQL/flexibleServers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/maintenances/(?P<maintenanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmysqlflexibleservers.MaintenanceUpdate](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		maintenanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("maintenanceName")])
		if err != nil {
			return nil, err
		}
		var options *armmysqlflexibleservers.MaintenancesClientBeginUpdateOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armmysqlflexibleservers.MaintenancesClientBeginUpdateOptions{
				Parameters: &body,
			}
		}
		respr, errRespr := m.srv.BeginUpdate(req.Context(), resourceGroupNameParam, serverNameParam, maintenanceNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		m.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		m.beginUpdate.remove(req)
	}

	return resp, nil
}
