//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/monitor/armmonitor"
	"net/http"
	"net/url"
	"regexp"
)

// MetricNamespacesServer is a fake server for instances of the armmonitor.MetricNamespacesClient type.
type MetricNamespacesServer struct {
	// NewListPager is the fake for method MetricNamespacesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceURI string, options *armmonitor.MetricNamespacesClientListOptions) (resp azfake.PagerResponder[armmonitor.MetricNamespacesClientListResponse])
}

// NewMetricNamespacesServerTransport creates a new instance of MetricNamespacesServerTransport with the provided implementation.
// The returned MetricNamespacesServerTransport instance is connected to an instance of armmonitor.MetricNamespacesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMetricNamespacesServerTransport(srv *MetricNamespacesServer) *MetricNamespacesServerTransport {
	return &MetricNamespacesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armmonitor.MetricNamespacesClientListResponse]](),
	}
}

// MetricNamespacesServerTransport connects instances of armmonitor.MetricNamespacesClient to instances of MetricNamespacesServer.
// Don't use this type directly, use NewMetricNamespacesServerTransport instead.
type MetricNamespacesServerTransport struct {
	srv          *MetricNamespacesServer
	newListPager *tracker[azfake.PagerResponder[armmonitor.MetricNamespacesClientListResponse]]
}

// Do implements the policy.Transporter interface for MetricNamespacesServerTransport.
func (m *MetricNamespacesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MetricNamespacesClient.NewListPager":
		resp, err = m.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MetricNamespacesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := m.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/microsoft\.insights/metricNamespaces`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
		if err != nil {
			return nil, err
		}
		startTimeUnescaped, err := url.QueryUnescape(qp.Get("startTime"))
		if err != nil {
			return nil, err
		}
		startTimeParam := getOptional(startTimeUnescaped)
		var options *armmonitor.MetricNamespacesClientListOptions
		if startTimeParam != nil {
			options = &armmonitor.MetricNamespacesClientListOptions{
				StartTime: startTimeParam,
			}
		}
		resp := m.srv.NewListPager(resourceURIParam, options)
		newListPager = &resp
		m.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		m.newListPager.remove(req)
	}
	return resp, nil
}
