//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmobilenetwork

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type Ambr.
func (a Ambr) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "downlink", a.Downlink)
	populate(objectMap, "uplink", a.Uplink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Ambr.
func (a *Ambr) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "downlink":
			err = unpopulate(val, "Downlink", &a.Downlink)
			delete(rawMsg, key)
		case "uplink":
			err = unpopulate(val, "Uplink", &a.Uplink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmfID.
func (a AmfID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "pointer", a.Pointer)
	populate(objectMap, "regionId", a.RegionID)
	populate(objectMap, "setId", a.SetID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmfID.
func (a *AmfID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "pointer":
			err = unpopulate(val, "Pointer", &a.Pointer)
			delete(rawMsg, key)
		case "regionId":
			err = unpopulate(val, "RegionID", &a.RegionID)
			delete(rawMsg, key)
		case "setId":
			err = unpopulate(val, "SetID", &a.SetID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Arp.
func (a Arp) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "preemptCap", a.PreemptCap)
	populate(objectMap, "preemptVuln", a.PreemptVuln)
	populate(objectMap, "priorityLevel", a.PriorityLevel)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Arp.
func (a *Arp) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "preemptCap":
			err = unpopulate(val, "PreemptCap", &a.PreemptCap)
			delete(rawMsg, key)
		case "preemptVuln":
			err = unpopulate(val, "PreemptVuln", &a.PreemptVuln)
			delete(rawMsg, key)
		case "priorityLevel":
			err = unpopulate(val, "PriorityLevel", &a.PriorityLevel)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AsyncOperationID.
func (a AsyncOperationID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AsyncOperationID.
func (a *AsyncOperationID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AsyncOperationStatus.
func (a AsyncOperationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endTime", a.EndTime)
	populate(objectMap, "error", a.Error)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "percentComplete", a.PercentComplete)
	populateAny(objectMap, "properties", a.Properties)
	populate(objectMap, "resourceId", a.ResourceID)
	populateDateTimeRFC3339(objectMap, "startTime", a.StartTime)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AsyncOperationStatus.
func (a *AsyncOperationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &a.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &a.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &a.PercentComplete)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &a.ResourceID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &a.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AttachedDataNetwork.
func (a AttachedDataNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AttachedDataNetwork.
func (a *AttachedDataNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AttachedDataNetworkListResult.
func (a AttachedDataNetworkListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AttachedDataNetworkListResult.
func (a *AttachedDataNetworkListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AttachedDataNetworkPropertiesFormat.
func (a AttachedDataNetworkPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsAddresses", a.DNSAddresses)
	populate(objectMap, "naptConfiguration", a.NaptConfiguration)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "userEquipmentAddressPoolPrefix", a.UserEquipmentAddressPoolPrefix)
	populate(objectMap, "userEquipmentStaticAddressPoolPrefix", a.UserEquipmentStaticAddressPoolPrefix)
	populate(objectMap, "userPlaneDataInterface", a.UserPlaneDataInterface)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AttachedDataNetworkPropertiesFormat.
func (a *AttachedDataNetworkPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsAddresses":
			err = unpopulate(val, "DNSAddresses", &a.DNSAddresses)
			delete(rawMsg, key)
		case "naptConfiguration":
			err = unpopulate(val, "NaptConfiguration", &a.NaptConfiguration)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "userEquipmentAddressPoolPrefix":
			err = unpopulate(val, "UserEquipmentAddressPoolPrefix", &a.UserEquipmentAddressPoolPrefix)
			delete(rawMsg, key)
		case "userEquipmentStaticAddressPoolPrefix":
			err = unpopulate(val, "UserEquipmentStaticAddressPoolPrefix", &a.UserEquipmentStaticAddressPoolPrefix)
			delete(rawMsg, key)
		case "userPlaneDataInterface":
			err = unpopulate(val, "UserPlaneDataInterface", &a.UserPlaneDataInterface)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AttachedDataNetworkResourceID.
func (a AttachedDataNetworkResourceID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AttachedDataNetworkResourceID.
func (a *AttachedDataNetworkResourceID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureStackEdgeDeviceResourceID.
func (a AzureStackEdgeDeviceResourceID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureStackEdgeDeviceResourceID.
func (a *AzureStackEdgeDeviceResourceID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureStackHCIClusterResourceID.
func (a AzureStackHCIClusterResourceID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureStackHCIClusterResourceID.
func (a *AzureStackHCIClusterResourceID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateProvisioning.
func (c CertificateProvisioning) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "reason", c.Reason)
	populate(objectMap, "state", c.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateProvisioning.
func (c *CertificateProvisioning) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "reason":
			err = unpopulate(val, "Reason", &c.Reason)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommonSimPropertiesFormat.
func (c CommonSimPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deviceType", c.DeviceType)
	populate(objectMap, "integratedCircuitCardIdentifier", c.IntegratedCircuitCardIdentifier)
	populate(objectMap, "internationalMobileSubscriberIdentity", c.InternationalMobileSubscriberIdentity)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "simPolicy", c.SimPolicy)
	populate(objectMap, "simState", c.SimState)
	populate(objectMap, "siteProvisioningState", c.SiteProvisioningState)
	populate(objectMap, "staticIpConfiguration", c.StaticIPConfiguration)
	populate(objectMap, "vendorKeyFingerprint", c.VendorKeyFingerprint)
	populate(objectMap, "vendorName", c.VendorName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommonSimPropertiesFormat.
func (c *CommonSimPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceType":
			err = unpopulate(val, "DeviceType", &c.DeviceType)
			delete(rawMsg, key)
		case "integratedCircuitCardIdentifier":
			err = unpopulate(val, "IntegratedCircuitCardIdentifier", &c.IntegratedCircuitCardIdentifier)
			delete(rawMsg, key)
		case "internationalMobileSubscriberIdentity":
			err = unpopulate(val, "InternationalMobileSubscriberIdentity", &c.InternationalMobileSubscriberIdentity)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "simPolicy":
			err = unpopulate(val, "SimPolicy", &c.SimPolicy)
			delete(rawMsg, key)
		case "simState":
			err = unpopulate(val, "SimState", &c.SimState)
			delete(rawMsg, key)
		case "siteProvisioningState":
			err = unpopulate(val, "SiteProvisioningState", &c.SiteProvisioningState)
			delete(rawMsg, key)
		case "staticIpConfiguration":
			err = unpopulate(val, "StaticIPConfiguration", &c.StaticIPConfiguration)
			delete(rawMsg, key)
		case "vendorKeyFingerprint":
			err = unpopulate(val, "VendorKeyFingerprint", &c.VendorKeyFingerprint)
			delete(rawMsg, key)
		case "vendorName":
			err = unpopulate(val, "VendorName", &c.VendorName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectedClusterResourceID.
func (c ConnectedClusterResourceID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectedClusterResourceID.
func (c *ConnectedClusterResourceID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomLocationResourceID.
func (c CustomLocationResourceID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomLocationResourceID.
func (c *CustomLocationResourceID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataNetwork.
func (d DataNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataNetwork.
func (d *DataNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataNetworkConfiguration.
func (d DataNetworkConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalAllowedSessionTypes", d.AdditionalAllowedSessionTypes)
	populate(objectMap, "allocationAndRetentionPriorityLevel", d.AllocationAndRetentionPriorityLevel)
	populate(objectMap, "allowedServices", d.AllowedServices)
	populate(objectMap, "dataNetwork", d.DataNetwork)
	populate(objectMap, "defaultSessionType", d.DefaultSessionType)
	populate(objectMap, "5qi", d.FiveQi)
	populate(objectMap, "maximumNumberOfBufferedPackets", d.MaximumNumberOfBufferedPackets)
	populate(objectMap, "preemptionCapability", d.PreemptionCapability)
	populate(objectMap, "preemptionVulnerability", d.PreemptionVulnerability)
	populate(objectMap, "sessionAmbr", d.SessionAmbr)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataNetworkConfiguration.
func (d *DataNetworkConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalAllowedSessionTypes":
			err = unpopulate(val, "AdditionalAllowedSessionTypes", &d.AdditionalAllowedSessionTypes)
			delete(rawMsg, key)
		case "allocationAndRetentionPriorityLevel":
			err = unpopulate(val, "AllocationAndRetentionPriorityLevel", &d.AllocationAndRetentionPriorityLevel)
			delete(rawMsg, key)
		case "allowedServices":
			err = unpopulate(val, "AllowedServices", &d.AllowedServices)
			delete(rawMsg, key)
		case "dataNetwork":
			err = unpopulate(val, "DataNetwork", &d.DataNetwork)
			delete(rawMsg, key)
		case "defaultSessionType":
			err = unpopulate(val, "DefaultSessionType", &d.DefaultSessionType)
			delete(rawMsg, key)
		case "5qi":
			err = unpopulate(val, "FiveQi", &d.FiveQi)
			delete(rawMsg, key)
		case "maximumNumberOfBufferedPackets":
			err = unpopulate(val, "MaximumNumberOfBufferedPackets", &d.MaximumNumberOfBufferedPackets)
			delete(rawMsg, key)
		case "preemptionCapability":
			err = unpopulate(val, "PreemptionCapability", &d.PreemptionCapability)
			delete(rawMsg, key)
		case "preemptionVulnerability":
			err = unpopulate(val, "PreemptionVulnerability", &d.PreemptionVulnerability)
			delete(rawMsg, key)
		case "sessionAmbr":
			err = unpopulate(val, "SessionAmbr", &d.SessionAmbr)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataNetworkListResult.
func (d DataNetworkListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataNetworkListResult.
func (d *DataNetworkListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataNetworkPropertiesFormat.
func (d DataNetworkPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataNetworkPropertiesFormat.
func (d *DataNetworkPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataNetworkResourceID.
func (d DataNetworkResourceID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataNetworkResourceID.
func (d *DataNetworkResourceID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticsPackage.
func (d DiagnosticsPackage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticsPackage.
func (d *DiagnosticsPackage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticsPackageListResult.
func (d DiagnosticsPackageListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticsPackageListResult.
func (d *DiagnosticsPackageListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticsPackagePropertiesFormat.
func (d DiagnosticsPackagePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "reason", d.Reason)
	populate(objectMap, "status", d.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticsPackagePropertiesFormat.
func (d *DiagnosticsPackagePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &d.Reason)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticsUploadConfiguration.
func (d DiagnosticsUploadConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "storageAccountContainerUrl", d.StorageAccountContainerURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticsUploadConfiguration.
func (d *DiagnosticsUploadConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "storageAccountContainerUrl":
			err = unpopulate(val, "StorageAccountContainerURL", &d.StorageAccountContainerURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DnnIPPair.
func (d DnnIPPair) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnn", d.Dnn)
	populate(objectMap, "ueIpAddress", d.UeIPAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DnnIPPair.
func (d *DnnIPPair) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnn":
			err = unpopulate(val, "Dnn", &d.Dnn)
			delete(rawMsg, key)
		case "ueIpAddress":
			err = unpopulate(val, "UeIPAddress", &d.UeIPAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptedSimPropertiesFormat.
func (e EncryptedSimPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deviceType", e.DeviceType)
	populate(objectMap, "encryptedCredentials", e.EncryptedCredentials)
	populate(objectMap, "integratedCircuitCardIdentifier", e.IntegratedCircuitCardIdentifier)
	populate(objectMap, "internationalMobileSubscriberIdentity", e.InternationalMobileSubscriberIdentity)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "simPolicy", e.SimPolicy)
	populate(objectMap, "simState", e.SimState)
	populate(objectMap, "siteProvisioningState", e.SiteProvisioningState)
	populate(objectMap, "staticIpConfiguration", e.StaticIPConfiguration)
	populate(objectMap, "vendorKeyFingerprint", e.VendorKeyFingerprint)
	populate(objectMap, "vendorName", e.VendorName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptedSimPropertiesFormat.
func (e *EncryptedSimPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceType":
			err = unpopulate(val, "DeviceType", &e.DeviceType)
			delete(rawMsg, key)
		case "encryptedCredentials":
			err = unpopulate(val, "EncryptedCredentials", &e.EncryptedCredentials)
			delete(rawMsg, key)
		case "integratedCircuitCardIdentifier":
			err = unpopulate(val, "IntegratedCircuitCardIdentifier", &e.IntegratedCircuitCardIdentifier)
			delete(rawMsg, key)
		case "internationalMobileSubscriberIdentity":
			err = unpopulate(val, "InternationalMobileSubscriberIdentity", &e.InternationalMobileSubscriberIdentity)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "simPolicy":
			err = unpopulate(val, "SimPolicy", &e.SimPolicy)
			delete(rawMsg, key)
		case "simState":
			err = unpopulate(val, "SimState", &e.SimState)
			delete(rawMsg, key)
		case "siteProvisioningState":
			err = unpopulate(val, "SiteProvisioningState", &e.SiteProvisioningState)
			delete(rawMsg, key)
		case "staticIpConfiguration":
			err = unpopulate(val, "StaticIPConfiguration", &e.StaticIPConfiguration)
			delete(rawMsg, key)
		case "vendorKeyFingerprint":
			err = unpopulate(val, "VendorKeyFingerprint", &e.VendorKeyFingerprint)
			delete(rawMsg, key)
		case "vendorName":
			err = unpopulate(val, "VendorName", &e.VendorName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptedSimUploadList.
func (e EncryptedSimUploadList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureKeyIdentifier", e.AzureKeyIdentifier)
	populate(objectMap, "encryptedTransportKey", e.EncryptedTransportKey)
	populate(objectMap, "signedTransportKey", e.SignedTransportKey)
	populate(objectMap, "sims", e.Sims)
	populate(objectMap, "vendorKeyFingerprint", e.VendorKeyFingerprint)
	populate(objectMap, "version", e.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptedSimUploadList.
func (e *EncryptedSimUploadList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureKeyIdentifier":
			err = unpopulate(val, "AzureKeyIdentifier", &e.AzureKeyIdentifier)
			delete(rawMsg, key)
		case "encryptedTransportKey":
			err = unpopulate(val, "EncryptedTransportKey", &e.EncryptedTransportKey)
			delete(rawMsg, key)
		case "signedTransportKey":
			err = unpopulate(val, "SignedTransportKey", &e.SignedTransportKey)
			delete(rawMsg, key)
		case "sims":
			err = unpopulate(val, "Sims", &e.Sims)
			delete(rawMsg, key)
		case "vendorKeyFingerprint":
			err = unpopulate(val, "VendorKeyFingerprint", &e.VendorKeyFingerprint)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &e.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorAdditionalInfo.
func (e ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "info", e.Info)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorAdditionalInfo.
func (e *ErrorAdditionalInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "info":
			err = unpopulate(val, "Info", &e.Info)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetail.
func (e ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetail.
func (e *ErrorDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &e.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubConfiguration.
func (e EventHubConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "reportingInterval", e.ReportingInterval)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubConfiguration.
func (e *EventHubConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "reportingInterval":
			err = unpopulate(val, "ReportingInterval", &e.ReportingInterval)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedUeInfo.
func (e ExtendedUeInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "systemData", e.SystemData)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedUeInfo.
func (e *ExtendedUeInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			e.Properties, err = unmarshalExtendedUeInfoPropertiesClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &e.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedUeInfoProperties.
func (e ExtendedUeInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "lastReadAt", e.LastReadAt)
	objectMap["ratType"] = e.RatType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedUeInfoProperties.
func (e *ExtendedUeInfoProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastReadAt":
			err = unpopulateDateTimeRFC3339(val, "LastReadAt", &e.LastReadAt)
			delete(rawMsg, key)
		case "ratType":
			err = unpopulate(val, "RatType", &e.RatType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GNbID.
func (g GNbID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bitLength", g.BitLength)
	populate(objectMap, "gNBValue", g.GNBValue)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GNbID.
func (g *GNbID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bitLength":
			err = unpopulate(val, "BitLength", &g.BitLength)
			delete(rawMsg, key)
		case "gNBValue":
			err = unpopulate(val, "GNBValue", &g.GNBValue)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GlobalRanNodeID.
func (g GlobalRanNodeID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eNbId", g.ENbID)
	populate(objectMap, "gNbId", g.GNbID)
	populate(objectMap, "n3IwfId", g.N3IwfID)
	populate(objectMap, "ngeNbId", g.NgeNbID)
	populate(objectMap, "nid", g.Nid)
	populate(objectMap, "plmnId", g.PlmnID)
	populate(objectMap, "tngfId", g.TngfID)
	populate(objectMap, "wagfId", g.WagfID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GlobalRanNodeID.
func (g *GlobalRanNodeID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eNbId":
			err = unpopulate(val, "ENbID", &g.ENbID)
			delete(rawMsg, key)
		case "gNbId":
			err = unpopulate(val, "GNbID", &g.GNbID)
			delete(rawMsg, key)
		case "n3IwfId":
			err = unpopulate(val, "N3IwfID", &g.N3IwfID)
			delete(rawMsg, key)
		case "ngeNbId":
			err = unpopulate(val, "NgeNbID", &g.NgeNbID)
			delete(rawMsg, key)
		case "nid":
			err = unpopulate(val, "Nid", &g.Nid)
			delete(rawMsg, key)
		case "plmnId":
			err = unpopulate(val, "PlmnID", &g.PlmnID)
			delete(rawMsg, key)
		case "tngfId":
			err = unpopulate(val, "TngfID", &g.TngfID)
			delete(rawMsg, key)
		case "wagfId":
			err = unpopulate(val, "WagfID", &g.WagfID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Guti4G.
func (g Guti4G) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "mTmsi", g.MTmsi)
	populate(objectMap, "mmeId", g.MmeID)
	populate(objectMap, "plmn", g.Plmn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Guti4G.
func (g *Guti4G) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mTmsi":
			err = unpopulate(val, "MTmsi", &g.MTmsi)
			delete(rawMsg, key)
		case "mmeId":
			err = unpopulate(val, "MmeID", &g.MmeID)
			delete(rawMsg, key)
		case "plmn":
			err = unpopulate(val, "Plmn", &g.Plmn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Guti5G.
func (g Guti5G) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amfId", g.AmfID)
	populate(objectMap, "fivegTmsi", g.FivegTmsi)
	populate(objectMap, "plmn", g.Plmn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Guti5G.
func (g *Guti5G) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amfId":
			err = unpopulate(val, "AmfID", &g.AmfID)
			delete(rawMsg, key)
		case "fivegTmsi":
			err = unpopulate(val, "FivegTmsi", &g.FivegTmsi)
			delete(rawMsg, key)
		case "plmn":
			err = unpopulate(val, "Plmn", &g.Plmn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPSServerCertificate.
func (h HTTPSServerCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificateUrl", h.CertificateURL)
	populate(objectMap, "provisioning", h.Provisioning)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPSServerCertificate.
func (h *HTTPSServerCertificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateUrl":
			err = unpopulate(val, "CertificateURL", &h.CertificateURL)
			delete(rawMsg, key)
		case "provisioning":
			err = unpopulate(val, "Provisioning", &h.Provisioning)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HomeNetworkPrivateKeysProvisioning.
func (h HomeNetworkPrivateKeysProvisioning) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "state", h.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HomeNetworkPrivateKeysProvisioning.
func (h *HomeNetworkPrivateKeysProvisioning) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "state":
			err = unpopulate(val, "State", &h.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HomeNetworkPublicKey.
func (h HomeNetworkPublicKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "url", h.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HomeNetworkPublicKey.
func (h *HomeNetworkPublicKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &h.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityAndTagsObject.
func (i IdentityAndTagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", i.Identity)
	populate(objectMap, "tags", i.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentityAndTagsObject.
func (i *IdentityAndTagsObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &i.Identity)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Installation.
func (i Installation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "desiredState", i.DesiredState)
	populate(objectMap, "operation", i.Operation)
	populate(objectMap, "reasons", i.Reasons)
	populate(objectMap, "reinstallRequired", i.ReinstallRequired)
	populate(objectMap, "state", i.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Installation.
func (i *Installation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "desiredState":
			err = unpopulate(val, "DesiredState", &i.DesiredState)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &i.Operation)
			delete(rawMsg, key)
		case "reasons":
			err = unpopulate(val, "Reasons", &i.Reasons)
			delete(rawMsg, key)
		case "reinstallRequired":
			err = unpopulate(val, "ReinstallRequired", &i.ReinstallRequired)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &i.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceProperties.
func (i InterfaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipv4Address", i.IPv4Address)
	populate(objectMap, "ipv4Gateway", i.IPv4Gateway)
	populate(objectMap, "ipv4Subnet", i.IPv4Subnet)
	populate(objectMap, "name", i.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceProperties.
func (i *InterfaceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipv4Address":
			err = unpopulate(val, "IPv4Address", &i.IPv4Address)
			delete(rawMsg, key)
		case "ipv4Gateway":
			err = unpopulate(val, "IPv4Gateway", &i.IPv4Gateway)
			delete(rawMsg, key)
		case "ipv4Subnet":
			err = unpopulate(val, "IPv4Subnet", &i.IPv4Subnet)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultKey.
func (k KeyVaultKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyUrl", k.KeyURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultKey.
func (k *KeyVaultKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyUrl":
			err = unpopulate(val, "KeyURL", &k.KeyURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListResult.
func (l ListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListResult.
func (l *ListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalDiagnosticsAccessConfiguration.
func (l LocalDiagnosticsAccessConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationType", l.AuthenticationType)
	populate(objectMap, "httpsServerCertificate", l.HTTPSServerCertificate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalDiagnosticsAccessConfiguration.
func (l *LocalDiagnosticsAccessConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationType":
			err = unpopulate(val, "AuthenticationType", &l.AuthenticationType)
			delete(rawMsg, key)
		case "httpsServerCertificate":
			err = unpopulate(val, "HTTPSServerCertificate", &l.HTTPSServerCertificate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedServiceIdentity.
func (m ManagedServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedServiceIdentity.
func (m *ManagedServiceIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &m.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MmeID.
func (m MmeID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", m.Code)
	populate(objectMap, "groupId", m.GroupID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MmeID.
func (m *MmeID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &m.Code)
			delete(rawMsg, key)
		case "groupId":
			err = unpopulate(val, "GroupID", &m.GroupID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MobileNetwork.
func (m MobileNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "identity", m.Identity)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MobileNetwork.
func (m *MobileNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &m.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NASRerouteConfiguration.
func (n NASRerouteConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "macroMmeGroupId", n.MacroMmeGroupID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NASRerouteConfiguration.
func (n *NASRerouteConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "macroMmeGroupId":
			err = unpopulate(val, "MacroMmeGroupID", &n.MacroMmeGroupID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NaptConfiguration.
func (n NaptConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", n.Enabled)
	populate(objectMap, "pinholeLimits", n.PinholeLimits)
	populate(objectMap, "pinholeTimeouts", n.PinholeTimeouts)
	populate(objectMap, "portRange", n.PortRange)
	populate(objectMap, "portReuseHoldTime", n.PortReuseHoldTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NaptConfiguration.
func (n *NaptConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &n.Enabled)
			delete(rawMsg, key)
		case "pinholeLimits":
			err = unpopulate(val, "PinholeLimits", &n.PinholeLimits)
			delete(rawMsg, key)
		case "pinholeTimeouts":
			err = unpopulate(val, "PinholeTimeouts", &n.PinholeTimeouts)
			delete(rawMsg, key)
		case "portRange":
			err = unpopulate(val, "PortRange", &n.PortRange)
			delete(rawMsg, key)
		case "portReuseHoldTime":
			err = unpopulate(val, "PortReuseHoldTime", &n.PortReuseHoldTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationList.
func (o OperationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationList.
func (o *OperationList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCapture.
func (p PacketCapture) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCapture.
func (p *PacketCapture) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCaptureListResult.
func (p PacketCaptureListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCaptureListResult.
func (p *PacketCaptureListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCapturePropertiesFormat.
func (p PacketCapturePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bytesToCapturePerPacket", p.BytesToCapturePerPacket)
	populateDateTimeRFC3339(objectMap, "captureStartTime", p.CaptureStartTime)
	populate(objectMap, "networkInterfaces", p.NetworkInterfaces)
	populate(objectMap, "outputFiles", p.OutputFiles)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "reason", p.Reason)
	populate(objectMap, "status", p.Status)
	populate(objectMap, "timeLimitInSeconds", p.TimeLimitInSeconds)
	populate(objectMap, "totalBytesPerSession", p.TotalBytesPerSession)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCapturePropertiesFormat.
func (p *PacketCapturePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bytesToCapturePerPacket":
			err = unpopulate(val, "BytesToCapturePerPacket", &p.BytesToCapturePerPacket)
			delete(rawMsg, key)
		case "captureStartTime":
			err = unpopulateDateTimeRFC3339(val, "CaptureStartTime", &p.CaptureStartTime)
			delete(rawMsg, key)
		case "networkInterfaces":
			err = unpopulate(val, "NetworkInterfaces", &p.NetworkInterfaces)
			delete(rawMsg, key)
		case "outputFiles":
			err = unpopulate(val, "OutputFiles", &p.OutputFiles)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &p.Reason)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		case "timeLimitInSeconds":
			err = unpopulate(val, "TimeLimitInSeconds", &p.TimeLimitInSeconds)
			delete(rawMsg, key)
		case "totalBytesPerSession":
			err = unpopulate(val, "TotalBytesPerSession", &p.TotalBytesPerSession)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCoreControlPlane.
func (p PacketCoreControlPlane) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "identity", p.Identity)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCoreControlPlane.
func (p *PacketCoreControlPlane) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &p.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCoreControlPlaneCollectDiagnosticsPackage.
func (p PacketCoreControlPlaneCollectDiagnosticsPackage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "storageAccountBlobUrl", p.StorageAccountBlobURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCoreControlPlaneCollectDiagnosticsPackage.
func (p *PacketCoreControlPlaneCollectDiagnosticsPackage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "storageAccountBlobUrl":
			err = unpopulate(val, "StorageAccountBlobURL", &p.StorageAccountBlobURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCoreControlPlaneListResult.
func (p PacketCoreControlPlaneListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCoreControlPlaneListResult.
func (p *PacketCoreControlPlaneListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCoreControlPlanePropertiesFormat.
func (p PacketCoreControlPlanePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "controlPlaneAccessInterface", p.ControlPlaneAccessInterface)
	populate(objectMap, "controlPlaneAccessVirtualIpv4Addresses", p.ControlPlaneAccessVirtualIPv4Addresses)
	populate(objectMap, "coreNetworkTechnology", p.CoreNetworkTechnology)
	populate(objectMap, "diagnosticsUpload", p.DiagnosticsUpload)
	populate(objectMap, "eventHub", p.EventHub)
	populate(objectMap, "homeNetworkPrivateKeysProvisioning", p.HomeNetworkPrivateKeysProvisioning)
	populate(objectMap, "installation", p.Installation)
	populate(objectMap, "installedVersion", p.InstalledVersion)
	populateAny(objectMap, "interopSettings", p.InteropSettings)
	populate(objectMap, "localDiagnosticsAccess", p.LocalDiagnosticsAccess)
	populate(objectMap, "platform", p.Platform)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "rollbackVersion", p.RollbackVersion)
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "signaling", p.Signaling)
	populate(objectMap, "sites", p.Sites)
	populate(objectMap, "ueMtu", p.UeMtu)
	populate(objectMap, "version", p.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCoreControlPlanePropertiesFormat.
func (p *PacketCoreControlPlanePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "controlPlaneAccessInterface":
			err = unpopulate(val, "ControlPlaneAccessInterface", &p.ControlPlaneAccessInterface)
			delete(rawMsg, key)
		case "controlPlaneAccessVirtualIpv4Addresses":
			err = unpopulate(val, "ControlPlaneAccessVirtualIPv4Addresses", &p.ControlPlaneAccessVirtualIPv4Addresses)
			delete(rawMsg, key)
		case "coreNetworkTechnology":
			err = unpopulate(val, "CoreNetworkTechnology", &p.CoreNetworkTechnology)
			delete(rawMsg, key)
		case "diagnosticsUpload":
			err = unpopulate(val, "DiagnosticsUpload", &p.DiagnosticsUpload)
			delete(rawMsg, key)
		case "eventHub":
			err = unpopulate(val, "EventHub", &p.EventHub)
			delete(rawMsg, key)
		case "homeNetworkPrivateKeysProvisioning":
			err = unpopulate(val, "HomeNetworkPrivateKeysProvisioning", &p.HomeNetworkPrivateKeysProvisioning)
			delete(rawMsg, key)
		case "installation":
			err = unpopulate(val, "Installation", &p.Installation)
			delete(rawMsg, key)
		case "installedVersion":
			err = unpopulate(val, "InstalledVersion", &p.InstalledVersion)
			delete(rawMsg, key)
		case "interopSettings":
			err = unpopulate(val, "InteropSettings", &p.InteropSettings)
			delete(rawMsg, key)
		case "localDiagnosticsAccess":
			err = unpopulate(val, "LocalDiagnosticsAccess", &p.LocalDiagnosticsAccess)
			delete(rawMsg, key)
		case "platform":
			err = unpopulate(val, "Platform", &p.Platform)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "rollbackVersion":
			err = unpopulate(val, "RollbackVersion", &p.RollbackVersion)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &p.SKU)
			delete(rawMsg, key)
		case "signaling":
			err = unpopulate(val, "Signaling", &p.Signaling)
			delete(rawMsg, key)
		case "sites":
			err = unpopulate(val, "Sites", &p.Sites)
			delete(rawMsg, key)
		case "ueMtu":
			err = unpopulate(val, "UeMtu", &p.UeMtu)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &p.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCoreControlPlaneResourceID.
func (p PacketCoreControlPlaneResourceID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCoreControlPlaneResourceID.
func (p *PacketCoreControlPlaneResourceID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCoreControlPlaneVersion.
func (p PacketCoreControlPlaneVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCoreControlPlaneVersion.
func (p *PacketCoreControlPlaneVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCoreControlPlaneVersionListResult.
func (p PacketCoreControlPlaneVersionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCoreControlPlaneVersionListResult.
func (p *PacketCoreControlPlaneVersionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCoreControlPlaneVersionPropertiesFormat.
func (p PacketCoreControlPlaneVersionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "platforms", p.Platforms)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCoreControlPlaneVersionPropertiesFormat.
func (p *PacketCoreControlPlaneVersionPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "platforms":
			err = unpopulate(val, "Platforms", &p.Platforms)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCoreDataPlane.
func (p PacketCoreDataPlane) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCoreDataPlane.
func (p *PacketCoreDataPlane) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCoreDataPlaneListResult.
func (p PacketCoreDataPlaneListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCoreDataPlaneListResult.
func (p *PacketCoreDataPlaneListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCoreDataPlanePropertiesFormat.
func (p PacketCoreDataPlanePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "userPlaneAccessInterface", p.UserPlaneAccessInterface)
	populate(objectMap, "userPlaneAccessVirtualIpv4Addresses", p.UserPlaneAccessVirtualIPv4Addresses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCoreDataPlanePropertiesFormat.
func (p *PacketCoreDataPlanePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "userPlaneAccessInterface":
			err = unpopulate(val, "UserPlaneAccessInterface", &p.UserPlaneAccessInterface)
			delete(rawMsg, key)
		case "userPlaneAccessVirtualIpv4Addresses":
			err = unpopulate(val, "UserPlaneAccessVirtualIPv4Addresses", &p.UserPlaneAccessVirtualIPv4Addresses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PccRuleConfiguration.
func (p PccRuleConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ruleName", p.RuleName)
	populate(objectMap, "rulePrecedence", p.RulePrecedence)
	populate(objectMap, "ruleQosPolicy", p.RuleQosPolicy)
	populate(objectMap, "serviceDataFlowTemplates", p.ServiceDataFlowTemplates)
	populate(objectMap, "trafficControl", p.TrafficControl)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PccRuleConfiguration.
func (p *PccRuleConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ruleName":
			err = unpopulate(val, "RuleName", &p.RuleName)
			delete(rawMsg, key)
		case "rulePrecedence":
			err = unpopulate(val, "RulePrecedence", &p.RulePrecedence)
			delete(rawMsg, key)
		case "ruleQosPolicy":
			err = unpopulate(val, "RuleQosPolicy", &p.RuleQosPolicy)
			delete(rawMsg, key)
		case "serviceDataFlowTemplates":
			err = unpopulate(val, "ServiceDataFlowTemplates", &p.ServiceDataFlowTemplates)
			delete(rawMsg, key)
		case "trafficControl":
			err = unpopulate(val, "TrafficControl", &p.TrafficControl)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PccRuleQosPolicy.
func (p PccRuleQosPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allocationAndRetentionPriorityLevel", p.AllocationAndRetentionPriorityLevel)
	populate(objectMap, "5qi", p.FiveQi)
	populate(objectMap, "guaranteedBitRate", p.GuaranteedBitRate)
	populate(objectMap, "maximumBitRate", p.MaximumBitRate)
	populate(objectMap, "preemptionCapability", p.PreemptionCapability)
	populate(objectMap, "preemptionVulnerability", p.PreemptionVulnerability)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PccRuleQosPolicy.
func (p *PccRuleQosPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allocationAndRetentionPriorityLevel":
			err = unpopulate(val, "AllocationAndRetentionPriorityLevel", &p.AllocationAndRetentionPriorityLevel)
			delete(rawMsg, key)
		case "5qi":
			err = unpopulate(val, "FiveQi", &p.FiveQi)
			delete(rawMsg, key)
		case "guaranteedBitRate":
			err = unpopulate(val, "GuaranteedBitRate", &p.GuaranteedBitRate)
			delete(rawMsg, key)
		case "maximumBitRate":
			err = unpopulate(val, "MaximumBitRate", &p.MaximumBitRate)
			delete(rawMsg, key)
		case "preemptionCapability":
			err = unpopulate(val, "PreemptionCapability", &p.PreemptionCapability)
			delete(rawMsg, key)
		case "preemptionVulnerability":
			err = unpopulate(val, "PreemptionVulnerability", &p.PreemptionVulnerability)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PinholeTimeouts.
func (p PinholeTimeouts) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "icmp", p.Icmp)
	populate(objectMap, "tcp", p.TCP)
	populate(objectMap, "udp", p.UDP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PinholeTimeouts.
func (p *PinholeTimeouts) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "icmp":
			err = unpopulate(val, "Icmp", &p.Icmp)
			delete(rawMsg, key)
		case "tcp":
			err = unpopulate(val, "TCP", &p.TCP)
			delete(rawMsg, key)
		case "udp":
			err = unpopulate(val, "UDP", &p.UDP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Platform.
func (p Platform) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maximumPlatformSoftwareVersion", p.MaximumPlatformSoftwareVersion)
	populate(objectMap, "minimumPlatformSoftwareVersion", p.MinimumPlatformSoftwareVersion)
	populate(objectMap, "obsoleteVersion", p.ObsoleteVersion)
	populate(objectMap, "platformType", p.PlatformType)
	populate(objectMap, "recommendedVersion", p.RecommendedVersion)
	populate(objectMap, "versionState", p.VersionState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Platform.
func (p *Platform) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maximumPlatformSoftwareVersion":
			err = unpopulate(val, "MaximumPlatformSoftwareVersion", &p.MaximumPlatformSoftwareVersion)
			delete(rawMsg, key)
		case "minimumPlatformSoftwareVersion":
			err = unpopulate(val, "MinimumPlatformSoftwareVersion", &p.MinimumPlatformSoftwareVersion)
			delete(rawMsg, key)
		case "obsoleteVersion":
			err = unpopulate(val, "ObsoleteVersion", &p.ObsoleteVersion)
			delete(rawMsg, key)
		case "platformType":
			err = unpopulate(val, "PlatformType", &p.PlatformType)
			delete(rawMsg, key)
		case "recommendedVersion":
			err = unpopulate(val, "RecommendedVersion", &p.RecommendedVersion)
			delete(rawMsg, key)
		case "versionState":
			err = unpopulate(val, "VersionState", &p.VersionState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlatformConfiguration.
func (p PlatformConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureStackEdgeDevice", p.AzureStackEdgeDevice)
	populate(objectMap, "azureStackEdgeDevices", p.AzureStackEdgeDevices)
	populate(objectMap, "azureStackHciCluster", p.AzureStackHciCluster)
	populate(objectMap, "connectedCluster", p.ConnectedCluster)
	populate(objectMap, "customLocation", p.CustomLocation)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlatformConfiguration.
func (p *PlatformConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureStackEdgeDevice":
			err = unpopulate(val, "AzureStackEdgeDevice", &p.AzureStackEdgeDevice)
			delete(rawMsg, key)
		case "azureStackEdgeDevices":
			err = unpopulate(val, "AzureStackEdgeDevices", &p.AzureStackEdgeDevices)
			delete(rawMsg, key)
		case "azureStackHciCluster":
			err = unpopulate(val, "AzureStackHciCluster", &p.AzureStackHciCluster)
			delete(rawMsg, key)
		case "connectedCluster":
			err = unpopulate(val, "ConnectedCluster", &p.ConnectedCluster)
			delete(rawMsg, key)
		case "customLocation":
			err = unpopulate(val, "CustomLocation", &p.CustomLocation)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlmnID.
func (p PlmnID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "mcc", p.Mcc)
	populate(objectMap, "mnc", p.Mnc)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlmnID.
func (p *PlmnID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mcc":
			err = unpopulate(val, "Mcc", &p.Mcc)
			delete(rawMsg, key)
		case "mnc":
			err = unpopulate(val, "Mnc", &p.Mnc)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortRange.
func (p PortRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxPort", p.MaxPort)
	populate(objectMap, "minPort", p.MinPort)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortRange.
func (p *PortRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxPort":
			err = unpopulate(val, "MaxPort", &p.MaxPort)
			delete(rawMsg, key)
		case "minPort":
			err = unpopulate(val, "MinPort", &p.MinPort)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortReuseHoldTimes.
func (p PortReuseHoldTimes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tcp", p.TCP)
	populate(objectMap, "udp", p.UDP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortReuseHoldTimes.
func (p *PortReuseHoldTimes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tcp":
			err = unpopulate(val, "TCP", &p.TCP)
			delete(rawMsg, key)
		case "udp":
			err = unpopulate(val, "UDP", &p.UDP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PropertiesFormat.
func (p PropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "publicLandMobileNetworkIdentifier", p.PublicLandMobileNetworkIdentifier)
	populate(objectMap, "publicLandMobileNetworks", p.PublicLandMobileNetworks)
	populate(objectMap, "serviceKey", p.ServiceKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PropertiesFormat.
func (p *PropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "publicLandMobileNetworkIdentifier":
			err = unpopulate(val, "PublicLandMobileNetworkIdentifier", &p.PublicLandMobileNetworkIdentifier)
			delete(rawMsg, key)
		case "publicLandMobileNetworks":
			err = unpopulate(val, "PublicLandMobileNetworks", &p.PublicLandMobileNetworks)
			delete(rawMsg, key)
		case "serviceKey":
			err = unpopulate(val, "ServiceKey", &p.ServiceKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicLandMobileNetwork.
func (p PublicLandMobileNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "homeNetworkPublicKeys", p.HomeNetworkPublicKeys)
	populate(objectMap, "mcc", p.Mcc)
	populate(objectMap, "mnc", p.Mnc)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicLandMobileNetwork.
func (p *PublicLandMobileNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "homeNetworkPublicKeys":
			err = unpopulate(val, "HomeNetworkPublicKeys", &p.HomeNetworkPublicKeys)
			delete(rawMsg, key)
		case "mcc":
			err = unpopulate(val, "Mcc", &p.Mcc)
			delete(rawMsg, key)
		case "mnc":
			err = unpopulate(val, "Mnc", &p.Mnc)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicLandMobileNetworkHomeNetworkPublicKeys.
func (p PublicLandMobileNetworkHomeNetworkPublicKeys) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "profileA", p.ProfileA)
	populate(objectMap, "profileB", p.ProfileB)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicLandMobileNetworkHomeNetworkPublicKeys.
func (p *PublicLandMobileNetworkHomeNetworkPublicKeys) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "profileA":
			err = unpopulate(val, "ProfileA", &p.ProfileA)
			delete(rawMsg, key)
		case "profileB":
			err = unpopulate(val, "ProfileB", &p.ProfileB)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QosPolicy.
func (q QosPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allocationAndRetentionPriorityLevel", q.AllocationAndRetentionPriorityLevel)
	populate(objectMap, "5qi", q.FiveQi)
	populate(objectMap, "maximumBitRate", q.MaximumBitRate)
	populate(objectMap, "preemptionCapability", q.PreemptionCapability)
	populate(objectMap, "preemptionVulnerability", q.PreemptionVulnerability)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QosPolicy.
func (q *QosPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allocationAndRetentionPriorityLevel":
			err = unpopulate(val, "AllocationAndRetentionPriorityLevel", &q.AllocationAndRetentionPriorityLevel)
			delete(rawMsg, key)
		case "5qi":
			err = unpopulate(val, "FiveQi", &q.FiveQi)
			delete(rawMsg, key)
		case "maximumBitRate":
			err = unpopulate(val, "MaximumBitRate", &q.MaximumBitRate)
			delete(rawMsg, key)
		case "preemptionCapability":
			err = unpopulate(val, "PreemptionCapability", &q.PreemptionCapability)
			delete(rawMsg, key)
		case "preemptionVulnerability":
			err = unpopulate(val, "PreemptionVulnerability", &q.PreemptionVulnerability)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceID.
func (r ResourceID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceID.
func (r *ResourceID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Service.
func (s Service) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Service.
func (s *Service) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceDataFlowTemplate.
func (s ServiceDataFlowTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "direction", s.Direction)
	populate(objectMap, "ports", s.Ports)
	populate(objectMap, "protocol", s.Protocol)
	populate(objectMap, "remoteIpList", s.RemoteIPList)
	populate(objectMap, "templateName", s.TemplateName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceDataFlowTemplate.
func (s *ServiceDataFlowTemplate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "direction":
			err = unpopulate(val, "Direction", &s.Direction)
			delete(rawMsg, key)
		case "ports":
			err = unpopulate(val, "Ports", &s.Ports)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &s.Protocol)
			delete(rawMsg, key)
		case "remoteIpList":
			err = unpopulate(val, "RemoteIPList", &s.RemoteIPList)
			delete(rawMsg, key)
		case "templateName":
			err = unpopulate(val, "TemplateName", &s.TemplateName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceListResult.
func (s ServiceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceListResult.
func (s *ServiceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServicePropertiesFormat.
func (s ServicePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "pccRules", s.PccRules)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "servicePrecedence", s.ServicePrecedence)
	populate(objectMap, "serviceQosPolicy", s.ServiceQosPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServicePropertiesFormat.
func (s *ServicePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "pccRules":
			err = unpopulate(val, "PccRules", &s.PccRules)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "servicePrecedence":
			err = unpopulate(val, "ServicePrecedence", &s.ServicePrecedence)
			delete(rawMsg, key)
		case "serviceQosPolicy":
			err = unpopulate(val, "ServiceQosPolicy", &s.ServiceQosPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceResourceID.
func (s ServiceResourceID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceResourceID.
func (s *ServiceResourceID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SignalingConfiguration.
func (s SignalingConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nasReroute", s.NasReroute)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SignalingConfiguration.
func (s *SignalingConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nasReroute":
			err = unpopulate(val, "NasReroute", &s.NasReroute)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Sim.
func (s Sim) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Sim.
func (s *Sim) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SimDeleteList.
func (s SimDeleteList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sims", s.Sims)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SimDeleteList.
func (s *SimDeleteList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sims":
			err = unpopulate(val, "Sims", &s.Sims)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SimGroup.
func (s SimGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SimGroup.
func (s *SimGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SimGroupListResult.
func (s SimGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SimGroupListResult.
func (s *SimGroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SimGroupPropertiesFormat.
func (s SimGroupPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryptionKey", s.EncryptionKey)
	populate(objectMap, "mobileNetwork", s.MobileNetwork)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SimGroupPropertiesFormat.
func (s *SimGroupPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryptionKey":
			err = unpopulate(val, "EncryptionKey", &s.EncryptionKey)
			delete(rawMsg, key)
		case "mobileNetwork":
			err = unpopulate(val, "MobileNetwork", &s.MobileNetwork)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SimGroupResourceID.
func (s SimGroupResourceID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SimGroupResourceID.
func (s *SimGroupResourceID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SimListResult.
func (s SimListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SimListResult.
func (s *SimListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SimNameAndEncryptedProperties.
func (s SimNameAndEncryptedProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SimNameAndEncryptedProperties.
func (s *SimNameAndEncryptedProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SimNameAndProperties.
func (s SimNameAndProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SimNameAndProperties.
func (s *SimNameAndProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SimPolicy.
func (s SimPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SimPolicy.
func (s *SimPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SimPolicyListResult.
func (s SimPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SimPolicyListResult.
func (s *SimPolicyListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SimPolicyPropertiesFormat.
func (s SimPolicyPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultSlice", s.DefaultSlice)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "registrationTimer", s.RegistrationTimer)
	populate(objectMap, "rfspIndex", s.RfspIndex)
	populate(objectMap, "siteProvisioningState", s.SiteProvisioningState)
	populate(objectMap, "sliceConfigurations", s.SliceConfigurations)
	populate(objectMap, "ueAmbr", s.UeAmbr)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SimPolicyPropertiesFormat.
func (s *SimPolicyPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultSlice":
			err = unpopulate(val, "DefaultSlice", &s.DefaultSlice)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "registrationTimer":
			err = unpopulate(val, "RegistrationTimer", &s.RegistrationTimer)
			delete(rawMsg, key)
		case "rfspIndex":
			err = unpopulate(val, "RfspIndex", &s.RfspIndex)
			delete(rawMsg, key)
		case "siteProvisioningState":
			err = unpopulate(val, "SiteProvisioningState", &s.SiteProvisioningState)
			delete(rawMsg, key)
		case "sliceConfigurations":
			err = unpopulate(val, "SliceConfigurations", &s.SliceConfigurations)
			delete(rawMsg, key)
		case "ueAmbr":
			err = unpopulate(val, "UeAmbr", &s.UeAmbr)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SimPolicyResourceID.
func (s SimPolicyResourceID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SimPolicyResourceID.
func (s *SimPolicyResourceID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SimPropertiesFormat.
func (s SimPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationKey", s.AuthenticationKey)
	populate(objectMap, "deviceType", s.DeviceType)
	populate(objectMap, "integratedCircuitCardIdentifier", s.IntegratedCircuitCardIdentifier)
	populate(objectMap, "internationalMobileSubscriberIdentity", s.InternationalMobileSubscriberIdentity)
	populate(objectMap, "operatorKeyCode", s.OperatorKeyCode)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "simPolicy", s.SimPolicy)
	populate(objectMap, "simState", s.SimState)
	populate(objectMap, "siteProvisioningState", s.SiteProvisioningState)
	populate(objectMap, "staticIpConfiguration", s.StaticIPConfiguration)
	populate(objectMap, "vendorKeyFingerprint", s.VendorKeyFingerprint)
	populate(objectMap, "vendorName", s.VendorName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SimPropertiesFormat.
func (s *SimPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationKey":
			err = unpopulate(val, "AuthenticationKey", &s.AuthenticationKey)
			delete(rawMsg, key)
		case "deviceType":
			err = unpopulate(val, "DeviceType", &s.DeviceType)
			delete(rawMsg, key)
		case "integratedCircuitCardIdentifier":
			err = unpopulate(val, "IntegratedCircuitCardIdentifier", &s.IntegratedCircuitCardIdentifier)
			delete(rawMsg, key)
		case "internationalMobileSubscriberIdentity":
			err = unpopulate(val, "InternationalMobileSubscriberIdentity", &s.InternationalMobileSubscriberIdentity)
			delete(rawMsg, key)
		case "operatorKeyCode":
			err = unpopulate(val, "OperatorKeyCode", &s.OperatorKeyCode)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "simPolicy":
			err = unpopulate(val, "SimPolicy", &s.SimPolicy)
			delete(rawMsg, key)
		case "simState":
			err = unpopulate(val, "SimState", &s.SimState)
			delete(rawMsg, key)
		case "siteProvisioningState":
			err = unpopulate(val, "SiteProvisioningState", &s.SiteProvisioningState)
			delete(rawMsg, key)
		case "staticIpConfiguration":
			err = unpopulate(val, "StaticIPConfiguration", &s.StaticIPConfiguration)
			delete(rawMsg, key)
		case "vendorKeyFingerprint":
			err = unpopulate(val, "VendorKeyFingerprint", &s.VendorKeyFingerprint)
			delete(rawMsg, key)
		case "vendorName":
			err = unpopulate(val, "VendorName", &s.VendorName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SimStaticIPProperties.
func (s SimStaticIPProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attachedDataNetwork", s.AttachedDataNetwork)
	populate(objectMap, "slice", s.Slice)
	populate(objectMap, "staticIp", s.StaticIP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SimStaticIPProperties.
func (s *SimStaticIPProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attachedDataNetwork":
			err = unpopulate(val, "AttachedDataNetwork", &s.AttachedDataNetwork)
			delete(rawMsg, key)
		case "slice":
			err = unpopulate(val, "Slice", &s.Slice)
			delete(rawMsg, key)
		case "staticIp":
			err = unpopulate(val, "StaticIP", &s.StaticIP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SimStaticIPPropertiesStaticIP.
func (s SimStaticIPPropertiesStaticIP) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipv4Address", s.IPv4Address)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SimStaticIPPropertiesStaticIP.
func (s *SimStaticIPPropertiesStaticIP) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipv4Address":
			err = unpopulate(val, "IPv4Address", &s.IPv4Address)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SimUploadList.
func (s SimUploadList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sims", s.Sims)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SimUploadList.
func (s *SimUploadList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sims":
			err = unpopulate(val, "Sims", &s.Sims)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Site.
func (s Site) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Site.
func (s *Site) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteDeletePacketCore.
func (s SiteDeletePacketCore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "packetCore", s.PacketCore)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteDeletePacketCore.
func (s *SiteDeletePacketCore) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "packetCore":
			err = unpopulate(val, "PacketCore", &s.PacketCore)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteListResult.
func (s SiteListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteListResult.
func (s *SiteListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SitePropertiesFormat.
func (s SitePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkFunctions", s.NetworkFunctions)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SitePropertiesFormat.
func (s *SitePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkFunctions":
			err = unpopulate(val, "NetworkFunctions", &s.NetworkFunctions)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteResourceID.
func (s SiteResourceID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteResourceID.
func (s *SiteResourceID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Slice.
func (s Slice) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Slice.
func (s *Slice) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SliceConfiguration.
func (s SliceConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataNetworkConfigurations", s.DataNetworkConfigurations)
	populate(objectMap, "defaultDataNetwork", s.DefaultDataNetwork)
	populate(objectMap, "slice", s.Slice)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SliceConfiguration.
func (s *SliceConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataNetworkConfigurations":
			err = unpopulate(val, "DataNetworkConfigurations", &s.DataNetworkConfigurations)
			delete(rawMsg, key)
		case "defaultDataNetwork":
			err = unpopulate(val, "DefaultDataNetwork", &s.DefaultDataNetwork)
			delete(rawMsg, key)
		case "slice":
			err = unpopulate(val, "Slice", &s.Slice)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SliceListResult.
func (s SliceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SliceListResult.
func (s *SliceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SlicePropertiesFormat.
func (s SlicePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "snssai", s.Snssai)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SlicePropertiesFormat.
func (s *SlicePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "snssai":
			err = unpopulate(val, "Snssai", &s.Snssai)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SliceResourceID.
func (s SliceResourceID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SliceResourceID.
func (s *SliceResourceID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Snssai.
func (s Snssai) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sd", s.Sd)
	populate(objectMap, "sst", s.Sst)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Snssai.
func (s *Snssai) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sd":
			err = unpopulate(val, "Sd", &s.Sd)
			delete(rawMsg, key)
		case "sst":
			err = unpopulate(val, "Sst", &s.Sst)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubResource.
func (s SubResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubResource.
func (s *SubResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagsObject.
func (t TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagsObject.
func (t *TagsObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackedResource.
func (t *TrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &t.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UeConnectionInfo4G.
func (u UeConnectionInfo4G) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enbS1apId", u.EnbS1ApID)
	populate(objectMap, "globalRanNodeId", u.GlobalRanNodeID)
	populateDateTimeRFC3339(objectMap, "lastActivityTime", u.LastActivityTime)
	populate(objectMap, "lastVisitedTai", u.LastVisitedTai)
	populate(objectMap, "locationInfo", u.LocationInfo)
	populate(objectMap, "mmeS1apId", u.MmeS1ApID)
	populate(objectMap, "perUeTnla", u.PerUeTnla)
	populate(objectMap, "rrcEstablishmentCause", u.RrcEstablishmentCause)
	populate(objectMap, "ueState", u.UeState)
	populate(objectMap, "ueUsageSetting", u.UeUsageSetting)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UeConnectionInfo4G.
func (u *UeConnectionInfo4G) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enbS1apId":
			err = unpopulate(val, "EnbS1ApID", &u.EnbS1ApID)
			delete(rawMsg, key)
		case "globalRanNodeId":
			err = unpopulate(val, "GlobalRanNodeID", &u.GlobalRanNodeID)
			delete(rawMsg, key)
		case "lastActivityTime":
			err = unpopulateDateTimeRFC3339(val, "LastActivityTime", &u.LastActivityTime)
			delete(rawMsg, key)
		case "lastVisitedTai":
			err = unpopulate(val, "LastVisitedTai", &u.LastVisitedTai)
			delete(rawMsg, key)
		case "locationInfo":
			err = unpopulate(val, "LocationInfo", &u.LocationInfo)
			delete(rawMsg, key)
		case "mmeS1apId":
			err = unpopulate(val, "MmeS1ApID", &u.MmeS1ApID)
			delete(rawMsg, key)
		case "perUeTnla":
			err = unpopulate(val, "PerUeTnla", &u.PerUeTnla)
			delete(rawMsg, key)
		case "rrcEstablishmentCause":
			err = unpopulate(val, "RrcEstablishmentCause", &u.RrcEstablishmentCause)
			delete(rawMsg, key)
		case "ueState":
			err = unpopulate(val, "UeState", &u.UeState)
			delete(rawMsg, key)
		case "ueUsageSetting":
			err = unpopulate(val, "UeUsageSetting", &u.UeUsageSetting)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UeConnectionInfo5G.
func (u UeConnectionInfo5G) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedNssai", u.AllowedNssai)
	populate(objectMap, "amfUeNgapId", u.AmfUeNgapID)
	populate(objectMap, "globalRanNodeId", u.GlobalRanNodeID)
	populateDateTimeRFC3339(objectMap, "lastActivityTime", u.LastActivityTime)
	populate(objectMap, "lastVisitedTai", u.LastVisitedTai)
	populate(objectMap, "locationInfo", u.LocationInfo)
	populate(objectMap, "perUeTnla", u.PerUeTnla)
	populate(objectMap, "ranUeNgapId", u.RanUeNgapID)
	populate(objectMap, "rrcEstablishmentCause", u.RrcEstablishmentCause)
	populate(objectMap, "ueState", u.UeState)
	populate(objectMap, "ueUsageSetting", u.UeUsageSetting)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UeConnectionInfo5G.
func (u *UeConnectionInfo5G) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedNssai":
			err = unpopulate(val, "AllowedNssai", &u.AllowedNssai)
			delete(rawMsg, key)
		case "amfUeNgapId":
			err = unpopulate(val, "AmfUeNgapID", &u.AmfUeNgapID)
			delete(rawMsg, key)
		case "globalRanNodeId":
			err = unpopulate(val, "GlobalRanNodeID", &u.GlobalRanNodeID)
			delete(rawMsg, key)
		case "lastActivityTime":
			err = unpopulateDateTimeRFC3339(val, "LastActivityTime", &u.LastActivityTime)
			delete(rawMsg, key)
		case "lastVisitedTai":
			err = unpopulate(val, "LastVisitedTai", &u.LastVisitedTai)
			delete(rawMsg, key)
		case "locationInfo":
			err = unpopulate(val, "LocationInfo", &u.LocationInfo)
			delete(rawMsg, key)
		case "perUeTnla":
			err = unpopulate(val, "PerUeTnla", &u.PerUeTnla)
			delete(rawMsg, key)
		case "ranUeNgapId":
			err = unpopulate(val, "RanUeNgapID", &u.RanUeNgapID)
			delete(rawMsg, key)
		case "rrcEstablishmentCause":
			err = unpopulate(val, "RrcEstablishmentCause", &u.RrcEstablishmentCause)
			delete(rawMsg, key)
		case "ueState":
			err = unpopulate(val, "UeState", &u.UeState)
			delete(rawMsg, key)
		case "ueUsageSetting":
			err = unpopulate(val, "UeUsageSetting", &u.UeUsageSetting)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UeIPAddress.
func (u UeIPAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipV4Addr", u.IPV4Addr)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UeIPAddress.
func (u *UeIPAddress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipV4Addr":
			err = unpopulate(val, "IPV4Addr", &u.IPV4Addr)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UeInfo.
func (u UeInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", u.ID)
	populate(objectMap, "name", u.Name)
	populate(objectMap, "properties", u.Properties)
	populate(objectMap, "systemData", u.SystemData)
	populate(objectMap, "type", u.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UeInfo.
func (u *UeInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &u.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &u.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UeInfo4G.
func (u UeInfo4G) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "info", u.Info)
	populateDateTimeRFC3339(objectMap, "lastReadAt", u.LastReadAt)
	objectMap["ratType"] = RatTypeFourG
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UeInfo4G.
func (u *UeInfo4G) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "info":
			err = unpopulate(val, "Info", &u.Info)
			delete(rawMsg, key)
		case "lastReadAt":
			err = unpopulateDateTimeRFC3339(val, "LastReadAt", &u.LastReadAt)
			delete(rawMsg, key)
		case "ratType":
			err = unpopulate(val, "RatType", &u.RatType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UeInfo4GProperties.
func (u UeInfo4GProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionInfo", u.ConnectionInfo)
	populate(objectMap, "guti", u.Guti)
	populate(objectMap, "imei", u.Imei)
	populate(objectMap, "imeisv", u.Imeisv)
	populate(objectMap, "imsi", u.Imsi)
	populate(objectMap, "sessionInfo", u.SessionInfo)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UeInfo4GProperties.
func (u *UeInfo4GProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionInfo":
			err = unpopulate(val, "ConnectionInfo", &u.ConnectionInfo)
			delete(rawMsg, key)
		case "guti":
			err = unpopulate(val, "Guti", &u.Guti)
			delete(rawMsg, key)
		case "imei":
			err = unpopulate(val, "Imei", &u.Imei)
			delete(rawMsg, key)
		case "imeisv":
			err = unpopulate(val, "Imeisv", &u.Imeisv)
			delete(rawMsg, key)
		case "imsi":
			err = unpopulate(val, "Imsi", &u.Imsi)
			delete(rawMsg, key)
		case "sessionInfo":
			err = unpopulate(val, "SessionInfo", &u.SessionInfo)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UeInfo5G.
func (u UeInfo5G) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "info", u.Info)
	populateDateTimeRFC3339(objectMap, "lastReadAt", u.LastReadAt)
	objectMap["ratType"] = RatTypeFiveG
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UeInfo5G.
func (u *UeInfo5G) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "info":
			err = unpopulate(val, "Info", &u.Info)
			delete(rawMsg, key)
		case "lastReadAt":
			err = unpopulateDateTimeRFC3339(val, "LastReadAt", &u.LastReadAt)
			delete(rawMsg, key)
		case "ratType":
			err = unpopulate(val, "RatType", &u.RatType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UeInfo5GProperties.
func (u UeInfo5GProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionInfo", u.ConnectionInfo)
	populate(objectMap, "fivegGuti", u.FivegGuti)
	populate(objectMap, "pei", u.Pei)
	populate(objectMap, "sessionInfo", u.SessionInfo)
	populate(objectMap, "supi", u.Supi)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UeInfo5GProperties.
func (u *UeInfo5GProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionInfo":
			err = unpopulate(val, "ConnectionInfo", &u.ConnectionInfo)
			delete(rawMsg, key)
		case "fivegGuti":
			err = unpopulate(val, "FivegGuti", &u.FivegGuti)
			delete(rawMsg, key)
		case "pei":
			err = unpopulate(val, "Pei", &u.Pei)
			delete(rawMsg, key)
		case "sessionInfo":
			err = unpopulate(val, "SessionInfo", &u.SessionInfo)
			delete(rawMsg, key)
		case "supi":
			err = unpopulate(val, "Supi", &u.Supi)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UeInfoList.
func (u UeInfoList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", u.NextLink)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UeInfoList.
func (u *UeInfoList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &u.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UeInfoPropertiesFormat.
func (u UeInfoPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "lastReadAt", u.LastReadAt)
	populate(objectMap, "ratType", u.RatType)
	populate(objectMap, "ueIpAddresses", u.UeIPAddresses)
	populate(objectMap, "ueState", u.UeState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UeInfoPropertiesFormat.
func (u *UeInfoPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastReadAt":
			err = unpopulateDateTimeRFC3339(val, "LastReadAt", &u.LastReadAt)
			delete(rawMsg, key)
		case "ratType":
			err = unpopulate(val, "RatType", &u.RatType)
			delete(rawMsg, key)
		case "ueIpAddresses":
			err = unpopulate(val, "UeIPAddresses", &u.UeIPAddresses)
			delete(rawMsg, key)
		case "ueState":
			err = unpopulate(val, "UeState", &u.UeState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UeLocationInfo.
func (u UeLocationInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "locationType", u.LocationType)
	populate(objectMap, "plmn", u.Plmn)
	populate(objectMap, "tac", u.Tac)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UeLocationInfo.
func (u *UeLocationInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "locationType":
			err = unpopulate(val, "LocationType", &u.LocationType)
			delete(rawMsg, key)
		case "plmn":
			err = unpopulate(val, "Plmn", &u.Plmn)
			delete(rawMsg, key)
		case "tac":
			err = unpopulate(val, "Tac", &u.Tac)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UeQOSFlow.
func (u UeQOSFlow) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fiveqi", u.Fiveqi)
	populate(objectMap, "gbr", u.Gbr)
	populate(objectMap, "mbr", u.Mbr)
	populate(objectMap, "qfi", u.Qfi)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UeQOSFlow.
func (u *UeQOSFlow) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fiveqi":
			err = unpopulate(val, "Fiveqi", &u.Fiveqi)
			delete(rawMsg, key)
		case "gbr":
			err = unpopulate(val, "Gbr", &u.Gbr)
			delete(rawMsg, key)
		case "mbr":
			err = unpopulate(val, "Mbr", &u.Mbr)
			delete(rawMsg, key)
		case "qfi":
			err = unpopulate(val, "Qfi", &u.Qfi)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UeSessionInfo4G.
func (u UeSessionInfo4G) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apn", u.Apn)
	populate(objectMap, "ebi", u.Ebi)
	populate(objectMap, "pdnType", u.PdnType)
	populate(objectMap, "ueIpAddress", u.UeIPAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UeSessionInfo4G.
func (u *UeSessionInfo4G) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apn":
			err = unpopulate(val, "Apn", &u.Apn)
			delete(rawMsg, key)
		case "ebi":
			err = unpopulate(val, "Ebi", &u.Ebi)
			delete(rawMsg, key)
		case "pdnType":
			err = unpopulate(val, "PdnType", &u.PdnType)
			delete(rawMsg, key)
		case "ueIpAddress":
			err = unpopulate(val, "UeIPAddress", &u.UeIPAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UeSessionInfo5G.
func (u UeSessionInfo5G) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ambr", u.Ambr)
	populate(objectMap, "dnn", u.Dnn)
	populate(objectMap, "pdnType", u.PdnType)
	populate(objectMap, "pduSessionId", u.PduSessionID)
	populate(objectMap, "qosFlow", u.QosFlow)
	populate(objectMap, "snssai", u.Snssai)
	populate(objectMap, "ueIpAddress", u.UeIPAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UeSessionInfo5G.
func (u *UeSessionInfo5G) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ambr":
			err = unpopulate(val, "Ambr", &u.Ambr)
			delete(rawMsg, key)
		case "dnn":
			err = unpopulate(val, "Dnn", &u.Dnn)
			delete(rawMsg, key)
		case "pdnType":
			err = unpopulate(val, "PdnType", &u.PdnType)
			delete(rawMsg, key)
		case "pduSessionId":
			err = unpopulate(val, "PduSessionID", &u.PduSessionID)
			delete(rawMsg, key)
		case "qosFlow":
			err = unpopulate(val, "QosFlow", &u.QosFlow)
			delete(rawMsg, key)
		case "snssai":
			err = unpopulate(val, "Snssai", &u.Snssai)
			delete(rawMsg, key)
		case "ueIpAddress":
			err = unpopulate(val, "UeIPAddress", &u.UeIPAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedIdentity.
func (u UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "principalId", u.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedIdentity.
func (u *UserAssignedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &u.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil || string(data) == "null" {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
