//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mobilenetwork/armmobilenetwork/v4"
	"net/http"
	"net/url"
	"regexp"
)

// UeInformationServer is a fake server for instances of the armmobilenetwork.UeInformationClient type.
type UeInformationServer struct {
	// NewListPager is the fake for method UeInformationClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, packetCoreControlPlaneName string, options *armmobilenetwork.UeInformationClientListOptions) (resp azfake.PagerResponder[armmobilenetwork.UeInformationClientListResponse])
}

// NewUeInformationServerTransport creates a new instance of UeInformationServerTransport with the provided implementation.
// The returned UeInformationServerTransport instance is connected to an instance of armmobilenetwork.UeInformationClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewUeInformationServerTransport(srv *UeInformationServer) *UeInformationServerTransport {
	return &UeInformationServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armmobilenetwork.UeInformationClientListResponse]](),
	}
}

// UeInformationServerTransport connects instances of armmobilenetwork.UeInformationClient to instances of UeInformationServer.
// Don't use this type directly, use NewUeInformationServerTransport instead.
type UeInformationServerTransport struct {
	srv          *UeInformationServer
	newListPager *tracker[azfake.PagerResponder[armmobilenetwork.UeInformationClientListResponse]]
}

// Do implements the policy.Transporter interface for UeInformationServerTransport.
func (u *UeInformationServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "UeInformationClient.NewListPager":
		resp, err = u.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (u *UeInformationServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if u.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := u.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes/(?P<packetCoreControlPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ues`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		packetCoreControlPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreControlPlaneName")])
		if err != nil {
			return nil, err
		}
		resp := u.srv.NewListPager(resourceGroupNameParam, packetCoreControlPlaneNameParam, nil)
		newListPager = &resp
		u.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armmobilenetwork.UeInformationClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		u.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		u.newListPager.remove(req)
	}
	return resp, nil
}
