//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmobilenetwork

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	internal       *arm.Client
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	internal, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID,
		internal:       internal,
	}, nil
}

// NewAttachedDataNetworksClient creates a new instance of AttachedDataNetworksClient.
func (c *ClientFactory) NewAttachedDataNetworksClient() *AttachedDataNetworksClient {
	return &AttachedDataNetworksClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewDataNetworksClient creates a new instance of DataNetworksClient.
func (c *ClientFactory) NewDataNetworksClient() *DataNetworksClient {
	return &DataNetworksClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewDiagnosticsPackagesClient creates a new instance of DiagnosticsPackagesClient.
func (c *ClientFactory) NewDiagnosticsPackagesClient() *DiagnosticsPackagesClient {
	return &DiagnosticsPackagesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewExtendedUeInformationClient creates a new instance of ExtendedUeInformationClient.
func (c *ClientFactory) NewExtendedUeInformationClient() *ExtendedUeInformationClient {
	return &ExtendedUeInformationClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewMobileNetworksClient creates a new instance of MobileNetworksClient.
func (c *ClientFactory) NewMobileNetworksClient() *MobileNetworksClient {
	return &MobileNetworksClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	return &OperationsClient{
		internal: c.internal,
	}
}

// NewPacketCapturesClient creates a new instance of PacketCapturesClient.
func (c *ClientFactory) NewPacketCapturesClient() *PacketCapturesClient {
	return &PacketCapturesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewPacketCoreControlPlaneVersionsClient creates a new instance of PacketCoreControlPlaneVersionsClient.
func (c *ClientFactory) NewPacketCoreControlPlaneVersionsClient() *PacketCoreControlPlaneVersionsClient {
	return &PacketCoreControlPlaneVersionsClient{
		internal: c.internal,
	}
}

// NewPacketCoreControlPlanesClient creates a new instance of PacketCoreControlPlanesClient.
func (c *ClientFactory) NewPacketCoreControlPlanesClient() *PacketCoreControlPlanesClient {
	return &PacketCoreControlPlanesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewPacketCoreDataPlanesClient creates a new instance of PacketCoreDataPlanesClient.
func (c *ClientFactory) NewPacketCoreDataPlanesClient() *PacketCoreDataPlanesClient {
	return &PacketCoreDataPlanesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewServicesClient creates a new instance of ServicesClient.
func (c *ClientFactory) NewServicesClient() *ServicesClient {
	return &ServicesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewSimGroupsClient creates a new instance of SimGroupsClient.
func (c *ClientFactory) NewSimGroupsClient() *SimGroupsClient {
	return &SimGroupsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewSimPoliciesClient creates a new instance of SimPoliciesClient.
func (c *ClientFactory) NewSimPoliciesClient() *SimPoliciesClient {
	return &SimPoliciesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewSimsClient creates a new instance of SimsClient.
func (c *ClientFactory) NewSimsClient() *SimsClient {
	return &SimsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewSitesClient creates a new instance of SitesClient.
func (c *ClientFactory) NewSitesClient() *SitesClient {
	return &SitesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewSlicesClient creates a new instance of SlicesClient.
func (c *ClientFactory) NewSlicesClient() *SlicesClient {
	return &SlicesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewUeInformationClient creates a new instance of UeInformationClient.
func (c *ClientFactory) NewUeInformationClient() *UeInformationClient {
	return &UeInformationClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}
