//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmigrationdiscoverysap

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ServerInstancesClient contains the methods for the ServerInstances group.
// Don't use this type directly, use NewServerInstancesClient() instead.
type ServerInstancesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewServerInstancesClient creates a new instance of ServerInstancesClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewServerInstancesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ServerInstancesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ServerInstancesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreate - Creates the Server Instance resource.
// ;This will be used by service only. PUT operation on this resource by end user will return a Bad Request error.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - sapDiscoverySiteName - The name of the discovery site resource for SAP Migration.
//   - sapInstanceName - The name of SAP Instance resource for SAP Migration.
//   - serverInstanceName - The name of the Server instance resource for SAP Migration.
//   - resource - Resource create parameters.
//   - options - ServerInstancesClientBeginCreateOptions contains the optional parameters for the ServerInstancesClient.BeginCreate
//     method.
func (client *ServerInstancesClient) BeginCreate(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, sapInstanceName string, serverInstanceName string, resource ServerInstance, options *ServerInstancesClientBeginCreateOptions) (*runtime.Poller[ServerInstancesClientCreateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.create(ctx, resourceGroupName, sapDiscoverySiteName, sapInstanceName, serverInstanceName, resource, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ServerInstancesClientCreateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ServerInstancesClientCreateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Create - Creates the Server Instance resource.
// ;This will be used by service only. PUT operation on this resource by end user will return a Bad Request error.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01-preview
func (client *ServerInstancesClient) create(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, sapInstanceName string, serverInstanceName string, resource ServerInstance, options *ServerInstancesClientBeginCreateOptions) (*http.Response, error) {
	var err error
	const operationName = "ServerInstancesClient.BeginCreate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, resourceGroupName, sapDiscoverySiteName, sapInstanceName, serverInstanceName, resource, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createCreateRequest creates the Create request.
func (client *ServerInstancesClient) createCreateRequest(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, sapInstanceName string, serverInstanceName string, resource ServerInstance, options *ServerInstancesClientBeginCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}/sapInstances/{sapInstanceName}/serverInstances/{serverInstanceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if sapDiscoverySiteName == "" {
		return nil, errors.New("parameter sapDiscoverySiteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapDiscoverySiteName}", url.PathEscape(sapDiscoverySiteName))
	if sapInstanceName == "" {
		return nil, errors.New("parameter sapInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapInstanceName}", url.PathEscape(sapInstanceName))
	if serverInstanceName == "" {
		return nil, errors.New("parameter serverInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverInstanceName}", url.PathEscape(serverInstanceName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, resource); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - Deletes the Server Instance resource.
// ;This will be used by service only. Delete operation on this resource by end user will return a Bad Request error. You
// can delete the parent resource, which is the SAP Migration discovery site
// resource, using the delete operation on it.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - sapDiscoverySiteName - The name of the discovery site resource for SAP Migration.
//   - sapInstanceName - The name of SAP Instance resource for SAP Migration.
//   - serverInstanceName - The name of the Server instance resource for SAP Migration.
//   - options - ServerInstancesClientBeginDeleteOptions contains the optional parameters for the ServerInstancesClient.BeginDelete
//     method.
func (client *ServerInstancesClient) BeginDelete(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, sapInstanceName string, serverInstanceName string, options *ServerInstancesClientBeginDeleteOptions) (*runtime.Poller[ServerInstancesClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, sapDiscoverySiteName, sapInstanceName, serverInstanceName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ServerInstancesClientDeleteResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ServerInstancesClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Deletes the Server Instance resource.
// ;This will be used by service only. Delete operation on this resource by end user will return a Bad Request error. You
// can delete the parent resource, which is the SAP Migration discovery site
// resource, using the delete operation on it.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01-preview
func (client *ServerInstancesClient) deleteOperation(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, sapInstanceName string, serverInstanceName string, options *ServerInstancesClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "ServerInstancesClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, sapDiscoverySiteName, sapInstanceName, serverInstanceName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ServerInstancesClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, sapInstanceName string, serverInstanceName string, options *ServerInstancesClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}/sapInstances/{sapInstanceName}/serverInstances/{serverInstanceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if sapDiscoverySiteName == "" {
		return nil, errors.New("parameter sapDiscoverySiteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapDiscoverySiteName}", url.PathEscape(sapDiscoverySiteName))
	if sapInstanceName == "" {
		return nil, errors.New("parameter sapInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapInstanceName}", url.PathEscape(sapInstanceName))
	if serverInstanceName == "" {
		return nil, errors.New("parameter serverInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverInstanceName}", url.PathEscape(serverInstanceName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Gets the Server Instance resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - sapDiscoverySiteName - The name of the discovery site resource for SAP Migration.
//   - sapInstanceName - The name of SAP Instance resource for SAP Migration.
//   - serverInstanceName - The name of the Server instance resource for SAP Migration.
//   - options - ServerInstancesClientGetOptions contains the optional parameters for the ServerInstancesClient.Get method.
func (client *ServerInstancesClient) Get(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, sapInstanceName string, serverInstanceName string, options *ServerInstancesClientGetOptions) (ServerInstancesClientGetResponse, error) {
	var err error
	const operationName = "ServerInstancesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, sapDiscoverySiteName, sapInstanceName, serverInstanceName, options)
	if err != nil {
		return ServerInstancesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ServerInstancesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ServerInstancesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ServerInstancesClient) getCreateRequest(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, sapInstanceName string, serverInstanceName string, options *ServerInstancesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}/sapInstances/{sapInstanceName}/serverInstances/{serverInstanceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if sapDiscoverySiteName == "" {
		return nil, errors.New("parameter sapDiscoverySiteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapDiscoverySiteName}", url.PathEscape(sapDiscoverySiteName))
	if sapInstanceName == "" {
		return nil, errors.New("parameter sapInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapInstanceName}", url.PathEscape(sapInstanceName))
	if serverInstanceName == "" {
		return nil, errors.New("parameter serverInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverInstanceName}", url.PathEscape(serverInstanceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ServerInstancesClient) getHandleResponse(resp *http.Response) (ServerInstancesClientGetResponse, error) {
	result := ServerInstancesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ServerInstance); err != nil {
		return ServerInstancesClientGetResponse{}, err
	}
	return result, nil
}

// NewListBySapInstancePager - Lists the Server Instance resources for the given SAP Instance resource.
//
// Generated from API version 2023-10-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - sapDiscoverySiteName - The name of the discovery site resource for SAP Migration.
//   - sapInstanceName - The name of SAP Instance resource for SAP Migration.
//   - options - ServerInstancesClientListBySapInstanceOptions contains the optional parameters for the ServerInstancesClient.NewListBySapInstancePager
//     method.
func (client *ServerInstancesClient) NewListBySapInstancePager(resourceGroupName string, sapDiscoverySiteName string, sapInstanceName string, options *ServerInstancesClientListBySapInstanceOptions) *runtime.Pager[ServerInstancesClientListBySapInstanceResponse] {
	return runtime.NewPager(runtime.PagingHandler[ServerInstancesClientListBySapInstanceResponse]{
		More: func(page ServerInstancesClientListBySapInstanceResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ServerInstancesClientListBySapInstanceResponse) (ServerInstancesClientListBySapInstanceResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ServerInstancesClient.NewListBySapInstancePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySapInstanceCreateRequest(ctx, resourceGroupName, sapDiscoverySiteName, sapInstanceName, options)
			}, nil)
			if err != nil {
				return ServerInstancesClientListBySapInstanceResponse{}, err
			}
			return client.listBySapInstanceHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySapInstanceCreateRequest creates the ListBySapInstance request.
func (client *ServerInstancesClient) listBySapInstanceCreateRequest(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, sapInstanceName string, options *ServerInstancesClientListBySapInstanceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}/sapInstances/{sapInstanceName}/serverInstances"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if sapDiscoverySiteName == "" {
		return nil, errors.New("parameter sapDiscoverySiteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapDiscoverySiteName}", url.PathEscape(sapDiscoverySiteName))
	if sapInstanceName == "" {
		return nil, errors.New("parameter sapInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapInstanceName}", url.PathEscape(sapInstanceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySapInstanceHandleResponse handles the ListBySapInstance response.
func (client *ServerInstancesClient) listBySapInstanceHandleResponse(resp *http.Response) (ServerInstancesClientListBySapInstanceResponse, error) {
	result := ServerInstancesClientListBySapInstanceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ServerInstanceListResult); err != nil {
		return ServerInstancesClientListBySapInstanceResponse{}, err
	}
	return result, nil
}

// Update - Updates the Server Instance resource. This operation on a resource by end user will return a Bad Request error.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - sapDiscoverySiteName - The name of the discovery site resource for SAP Migration.
//   - sapInstanceName - The name of SAP Instance resource for SAP Migration.
//   - serverInstanceName - The name of the Server instance resource for SAP Migration.
//   - properties - The resource properties to be updated.
//   - options - ServerInstancesClientUpdateOptions contains the optional parameters for the ServerInstancesClient.Update method.
func (client *ServerInstancesClient) Update(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, sapInstanceName string, serverInstanceName string, properties UpdateServerInstanceRequest, options *ServerInstancesClientUpdateOptions) (ServerInstancesClientUpdateResponse, error) {
	var err error
	const operationName = "ServerInstancesClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, sapDiscoverySiteName, sapInstanceName, serverInstanceName, properties, options)
	if err != nil {
		return ServerInstancesClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ServerInstancesClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ServerInstancesClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *ServerInstancesClient) updateCreateRequest(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, sapInstanceName string, serverInstanceName string, properties UpdateServerInstanceRequest, options *ServerInstancesClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}/sapInstances/{sapInstanceName}/serverInstances/{serverInstanceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if sapDiscoverySiteName == "" {
		return nil, errors.New("parameter sapDiscoverySiteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapDiscoverySiteName}", url.PathEscape(sapDiscoverySiteName))
	if sapInstanceName == "" {
		return nil, errors.New("parameter sapInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapInstanceName}", url.PathEscape(sapInstanceName))
	if serverInstanceName == "" {
		return nil, errors.New("parameter serverInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverInstanceName}", url.PathEscape(serverInstanceName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, properties); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *ServerInstancesClient) updateHandleResponse(resp *http.Response) (ServerInstancesClientUpdateResponse, error) {
	result := ServerInstancesClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ServerInstance); err != nil {
		return ServerInstancesClientUpdateResponse{}, err
	}
	return result, nil
}
